/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.runtime.logging;

import org.osgi.annotation.bundle.Capability;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.bridge.SLF4JBridgeHandler;

/**
 * Activator to initialize SLF4J
 * @author Juergen Albert
 * @since 7 Mar 2018
 */
@SuppressWarnings("restriction")
@Capability(namespace="java.logging", name="slf4j", version="1.7.25")
public class LoggingActivator implements BundleActivator {

//	private Activator osgiLoggingActivator;
//	private LoggingConfigurator loggingConfigurator;

	/* 
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	@Override
	public void start(BundleContext context) throws Exception {
		SLF4JBridgeHandler.removeHandlersForRootLogger();
		SLF4JBridgeHandler.install();
//		if(loggingConfigurator != null) {
//			loggingConfigurator = new LoggingConfigurator();
//			context.addBundleListener(loggingConfigurator);
//		}
		
//		if(osgiLoggingActivator == null) {
//			osgiLoggingActivator = new Activator();
//			osgiLoggingActivator.start(context);
//		}
	}

	/* 
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	@Override
	public void stop(BundleContext context) throws Exception {
//		if(osgiLoggingActivator != null) {
//			osgiLoggingActivator.stop(context);
//		}
//		if(loggingConfigurator != null) {
//			context.removeBundleListener(loggingConfigurator);
//		}

	}

}
