/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package net.opengis.gml.gml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Compass Point Enumeration</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * These directions are necessarily approximate, giving direction with a precision of 22.5°. It is thus generally unnecessary to specify the reference frame, though this may be detailed in the definition of a GML application language.
 * <!-- end-model-doc -->
 * @see net.opengis.gml.gml.GMLPackage#getCompassPointEnumeration()
 * @model extendedMetaData="name='CompassPointEnumeration'"
 * @generated
 */
@ProviderType
public enum CompassPointEnumeration implements Enumerator {
	/**
	 * The '<em><b>N</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #N_VALUE
	 * @generated
	 * @ordered
	 */
	N(0, "N", "N"),

	/**
	 * The '<em><b>NNE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NNE_VALUE
	 * @generated
	 * @ordered
	 */
	NNE(1, "NNE", "NNE"),

	/**
	 * The '<em><b>NE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NE_VALUE
	 * @generated
	 * @ordered
	 */
	NE(2, "NE", "NE"),

	/**
	 * The '<em><b>ENE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENE_VALUE
	 * @generated
	 * @ordered
	 */
	ENE(3, "ENE", "ENE"),

	/**
	 * The '<em><b>E</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #E_VALUE
	 * @generated
	 * @ordered
	 */
	E(4, "E", "E"),

	/**
	 * The '<em><b>ESE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ESE_VALUE
	 * @generated
	 * @ordered
	 */
	ESE(5, "ESE", "ESE"),

	/**
	 * The '<em><b>SE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SE_VALUE
	 * @generated
	 * @ordered
	 */
	SE(6, "SE", "SE"),

	/**
	 * The '<em><b>SSE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SSE_VALUE
	 * @generated
	 * @ordered
	 */
	SSE(7, "SSE", "SSE"),

	/**
	 * The '<em><b>S</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #S_VALUE
	 * @generated
	 * @ordered
	 */
	S(8, "S", "S"),

	/**
	 * The '<em><b>SSW</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SSW_VALUE
	 * @generated
	 * @ordered
	 */
	SSW(9, "SSW", "SSW"),

	/**
	 * The '<em><b>SW</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SW_VALUE
	 * @generated
	 * @ordered
	 */
	SW(10, "SW", "SW"),

	/**
	 * The '<em><b>WSW</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WSW_VALUE
	 * @generated
	 * @ordered
	 */
	WSW(11, "WSW", "WSW"),

	/**
	 * The '<em><b>W</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #W_VALUE
	 * @generated
	 * @ordered
	 */
	W(12, "W", "W"),

	/**
	 * The '<em><b>WNW</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WNW_VALUE
	 * @generated
	 * @ordered
	 */
	WNW(13, "WNW", "WNW"),

	/**
	 * The '<em><b>NW</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NW_VALUE
	 * @generated
	 * @ordered
	 */
	NW(14, "NW", "NW"),

	/**
	 * The '<em><b>NNW</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NNW_VALUE
	 * @generated
	 * @ordered
	 */
	NNW(15, "NNW", "NNW");

	/**
	 * The '<em><b>N</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #N
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int N_VALUE = 0;

	/**
	 * The '<em><b>NNE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NNE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int NNE_VALUE = 1;

	/**
	 * The '<em><b>NE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int NE_VALUE = 2;

	/**
	 * The '<em><b>ENE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ENE_VALUE = 3;

	/**
	 * The '<em><b>E</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #E
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int E_VALUE = 4;

	/**
	 * The '<em><b>ESE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ESE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ESE_VALUE = 5;

	/**
	 * The '<em><b>SE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SE_VALUE = 6;

	/**
	 * The '<em><b>SSE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SSE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SSE_VALUE = 7;

	/**
	 * The '<em><b>S</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #S
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int S_VALUE = 8;

	/**
	 * The '<em><b>SSW</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SSW
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SSW_VALUE = 9;

	/**
	 * The '<em><b>SW</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SW
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SW_VALUE = 10;

	/**
	 * The '<em><b>WSW</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WSW
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int WSW_VALUE = 11;

	/**
	 * The '<em><b>W</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #W
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int W_VALUE = 12;

	/**
	 * The '<em><b>WNW</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WNW
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int WNW_VALUE = 13;

	/**
	 * The '<em><b>NW</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NW
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int NW_VALUE = 14;

	/**
	 * The '<em><b>NNW</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NNW
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int NNW_VALUE = 15;

	/**
	 * An array of all the '<em><b>Compass Point Enumeration</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final CompassPointEnumeration[] VALUES_ARRAY =
		new CompassPointEnumeration[] {
			N,
			NNE,
			NE,
			ENE,
			E,
			ESE,
			SE,
			SSE,
			S,
			SSW,
			SW,
			WSW,
			W,
			WNW,
			NW,
			NNW,
		};

	/**
	 * A public read-only list of all the '<em><b>Compass Point Enumeration</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<CompassPointEnumeration> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Compass Point Enumeration</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static CompassPointEnumeration get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			CompassPointEnumeration result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Compass Point Enumeration</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static CompassPointEnumeration getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			CompassPointEnumeration result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Compass Point Enumeration</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static CompassPointEnumeration get(int value) {
		switch (value) {
			case N_VALUE: return N;
			case NNE_VALUE: return NNE;
			case NE_VALUE: return NE;
			case ENE_VALUE: return ENE;
			case E_VALUE: return E;
			case ESE_VALUE: return ESE;
			case SE_VALUE: return SE;
			case SSE_VALUE: return SSE;
			case S_VALUE: return S;
			case SSW_VALUE: return SSW;
			case SW_VALUE: return SW;
			case WSW_VALUE: return WSW;
			case W_VALUE: return W;
			case WNW_VALUE: return WNW;
			case NW_VALUE: return NW;
			case NNW_VALUE: return NNW;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private CompassPointEnumeration(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //CompassPointEnumeration
