/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package net.opengis.gml.gml;

import org.eclipse.emf.ecore.EFactory;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see net.opengis.gml.gml.GMLPackage
 * @generated
 */
@ProviderType
public interface GMLFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	GMLFactory eINSTANCE = net.opengis.gml.gml.impl.GMLFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Abstract General Operation Parameter Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Abstract General Operation Parameter Property Type</em>'.
	 * @generated
	 */
	AbstractGeneralOperationParameterPropertyType createAbstractGeneralOperationParameterPropertyType();

	/**
	 * Returns a new object of class '<em>Abstract General Parameter Value Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Abstract General Parameter Value Property Type</em>'.
	 * @generated
	 */
	AbstractGeneralParameterValuePropertyType createAbstractGeneralParameterValuePropertyType();

	/**
	 * Returns a new object of class '<em>Abstract Ring Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Abstract Ring Property Type</em>'.
	 * @generated
	 */
	AbstractRingPropertyType createAbstractRingPropertyType();

	/**
	 * Returns a new object of class '<em>Abstract Solid Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Abstract Solid Type</em>'.
	 * @generated
	 */
	AbstractSolidType createAbstractSolidType();

	/**
	 * Returns a new object of class '<em>Affine CS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Affine CS Property Type</em>'.
	 * @generated
	 */
	AffineCSPropertyType createAffineCSPropertyType();

	/**
	 * Returns a new object of class '<em>Affine CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Affine CS Type</em>'.
	 * @generated
	 */
	AffineCSType createAffineCSType();

	/**
	 * Returns a new object of class '<em>Affine Placement Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Affine Placement Type</em>'.
	 * @generated
	 */
	AffinePlacementType createAffinePlacementType();

	/**
	 * Returns a new object of class '<em>Angle Choice Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Angle Choice Type</em>'.
	 * @generated
	 */
	AngleChoiceType createAngleChoiceType();

	/**
	 * Returns a new object of class '<em>Angle Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Angle Type</em>'.
	 * @generated
	 */
	AngleType createAngleType();

	/**
	 * Returns a new object of class '<em>Arc By Bulge Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Arc By Bulge Type</em>'.
	 * @generated
	 */
	ArcByBulgeType createArcByBulgeType();

	/**
	 * Returns a new object of class '<em>Arc By Center Point Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Arc By Center Point Type</em>'.
	 * @generated
	 */
	ArcByCenterPointType createArcByCenterPointType();

	/**
	 * Returns a new object of class '<em>Arc String By Bulge Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Arc String By Bulge Type</em>'.
	 * @generated
	 */
	ArcStringByBulgeType createArcStringByBulgeType();

	/**
	 * Returns a new object of class '<em>Arc String Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Arc String Type</em>'.
	 * @generated
	 */
	ArcStringType createArcStringType();

	/**
	 * Returns a new object of class '<em>Arc Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Arc Type</em>'.
	 * @generated
	 */
	ArcType createArcType();

	/**
	 * Returns a new object of class '<em>Area Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Area Type</em>'.
	 * @generated
	 */
	AreaType createAreaType();

	/**
	 * Returns a new object of class '<em>Array Association Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Array Association Type</em>'.
	 * @generated
	 */
	ArrayAssociationType createArrayAssociationType();

	/**
	 * Returns a new object of class '<em>Array Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Array Type</em>'.
	 * @generated
	 */
	ArrayType createArrayType();

	/**
	 * Returns a new object of class '<em>Association Role Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Association Role Type</em>'.
	 * @generated
	 */
	AssociationRoleType createAssociationRoleType();

	/**
	 * Returns a new object of class '<em>Bag Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Bag Type</em>'.
	 * @generated
	 */
	BagType createBagType();

	/**
	 * Returns a new object of class '<em>Base Unit Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Base Unit Type</em>'.
	 * @generated
	 */
	BaseUnitType createBaseUnitType();

	/**
	 * Returns a new object of class '<em>Bezier Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Bezier Type</em>'.
	 * @generated
	 */
	BezierType createBezierType();

	/**
	 * Returns a new object of class '<em>Boolean Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Boolean Property Type</em>'.
	 * @generated
	 */
	BooleanPropertyType createBooleanPropertyType();

	/**
	 * Returns a new object of class '<em>Boolean Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Boolean Type</em>'.
	 * @generated
	 */
	BooleanType createBooleanType();

	/**
	 * Returns a new object of class '<em>Bounding Shape Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Bounding Shape Type</em>'.
	 * @generated
	 */
	BoundingShapeType createBoundingShapeType();

	/**
	 * Returns a new object of class '<em>BSpline Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>BSpline Type</em>'.
	 * @generated
	 */
	BSplineType createBSplineType();

	/**
	 * Returns a new object of class '<em>Cartesian CS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cartesian CS Property Type</em>'.
	 * @generated
	 */
	CartesianCSPropertyType createCartesianCSPropertyType();

	/**
	 * Returns a new object of class '<em>Cartesian CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cartesian CS Type</em>'.
	 * @generated
	 */
	CartesianCSType createCartesianCSType();

	/**
	 * Returns a new object of class '<em>Category Extent Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Category Extent Type</em>'.
	 * @generated
	 */
	CategoryExtentType createCategoryExtentType();

	/**
	 * Returns a new object of class '<em>Category Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Category Property Type</em>'.
	 * @generated
	 */
	CategoryPropertyType createCategoryPropertyType();

	/**
	 * Returns a new object of class '<em>Category Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Category Type</em>'.
	 * @generated
	 */
	CategoryType createCategoryType();

	/**
	 * Returns a new object of class '<em>Circle By Center Point Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Circle By Center Point Type</em>'.
	 * @generated
	 */
	CircleByCenterPointType createCircleByCenterPointType();

	/**
	 * Returns a new object of class '<em>Circle Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Circle Type</em>'.
	 * @generated
	 */
	CircleType createCircleType();

	/**
	 * Returns a new object of class '<em>Clothoid Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clothoid Type</em>'.
	 * @generated
	 */
	ClothoidType createClothoidType();

	/**
	 * Returns a new object of class '<em>Code List Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Code List Type</em>'.
	 * @generated
	 */
	CodeListType createCodeListType();

	/**
	 * Returns a new object of class '<em>Code Or Nil Reason List Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Code Or Nil Reason List Type</em>'.
	 * @generated
	 */
	CodeOrNilReasonListType createCodeOrNilReasonListType();

	/**
	 * Returns a new object of class '<em>Code Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Code Type</em>'.
	 * @generated
	 */
	CodeType createCodeType();

	/**
	 * Returns a new object of class '<em>Code With Authority Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Code With Authority Type</em>'.
	 * @generated
	 */
	CodeWithAuthorityType createCodeWithAuthorityType();

	/**
	 * Returns a new object of class '<em>Composite Curve Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Composite Curve Type</em>'.
	 * @generated
	 */
	CompositeCurveType createCompositeCurveType();

	/**
	 * Returns a new object of class '<em>Composite Solid Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Composite Solid Type</em>'.
	 * @generated
	 */
	CompositeSolidType createCompositeSolidType();

	/**
	 * Returns a new object of class '<em>Composite Surface Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Composite Surface Type</em>'.
	 * @generated
	 */
	CompositeSurfaceType createCompositeSurfaceType();

	/**
	 * Returns a new object of class '<em>Composite Value Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Composite Value Type</em>'.
	 * @generated
	 */
	CompositeValueType createCompositeValueType();

	/**
	 * Returns a new object of class '<em>Compound CRS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Compound CRS Property Type</em>'.
	 * @generated
	 */
	CompoundCRSPropertyType createCompoundCRSPropertyType();

	/**
	 * Returns a new object of class '<em>Compound CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Compound CRS Type</em>'.
	 * @generated
	 */
	CompoundCRSType createCompoundCRSType();

	/**
	 * Returns a new object of class '<em>Concatenated Operation Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Concatenated Operation Property Type</em>'.
	 * @generated
	 */
	ConcatenatedOperationPropertyType createConcatenatedOperationPropertyType();

	/**
	 * Returns a new object of class '<em>Concatenated Operation Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Concatenated Operation Type</em>'.
	 * @generated
	 */
	ConcatenatedOperationType createConcatenatedOperationType();

	/**
	 * Returns a new object of class '<em>Cone Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cone Type</em>'.
	 * @generated
	 */
	ConeType createConeType();

	/**
	 * Returns a new object of class '<em>Control Point Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Control Point Type</em>'.
	 * @generated
	 */
	ControlPointType createControlPointType();

	/**
	 * Returns a new object of class '<em>Conventional Unit Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Conventional Unit Type</em>'.
	 * @generated
	 */
	ConventionalUnitType createConventionalUnitType();

	/**
	 * Returns a new object of class '<em>Conversion Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Conversion Property Type</em>'.
	 * @generated
	 */
	ConversionPropertyType createConversionPropertyType();

	/**
	 * Returns a new object of class '<em>Conversion To Preferred Unit Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Conversion To Preferred Unit Type</em>'.
	 * @generated
	 */
	ConversionToPreferredUnitType createConversionToPreferredUnitType();

	/**
	 * Returns a new object of class '<em>Conversion Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Conversion Type</em>'.
	 * @generated
	 */
	ConversionType createConversionType();

	/**
	 * Returns a new object of class '<em>Coordinate Operation Accuracy Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Coordinate Operation Accuracy Type</em>'.
	 * @generated
	 */
	CoordinateOperationAccuracyType createCoordinateOperationAccuracyType();

	/**
	 * Returns a new object of class '<em>Coordinate Operation Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Coordinate Operation Property Type</em>'.
	 * @generated
	 */
	CoordinateOperationPropertyType createCoordinateOperationPropertyType();

	/**
	 * Returns a new object of class '<em>Coordinates Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Coordinates Type</em>'.
	 * @generated
	 */
	CoordinatesType createCoordinatesType();

	/**
	 * Returns a new object of class '<em>Coordinate System Axis Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Coordinate System Axis Property Type</em>'.
	 * @generated
	 */
	CoordinateSystemAxisPropertyType createCoordinateSystemAxisPropertyType();

	/**
	 * Returns a new object of class '<em>Coordinate System Axis Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Coordinate System Axis Type</em>'.
	 * @generated
	 */
	CoordinateSystemAxisType createCoordinateSystemAxisType();

	/**
	 * Returns a new object of class '<em>Coordinate System Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Coordinate System Property Type</em>'.
	 * @generated
	 */
	CoordinateSystemPropertyType createCoordinateSystemPropertyType();

	/**
	 * Returns a new object of class '<em>Count Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Count Property Type</em>'.
	 * @generated
	 */
	CountPropertyType createCountPropertyType();

	/**
	 * Returns a new object of class '<em>Count Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Count Type</em>'.
	 * @generated
	 */
	CountType createCountType();

	/**
	 * Returns a new object of class '<em>Coverage Function Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Coverage Function Type</em>'.
	 * @generated
	 */
	CoverageFunctionType createCoverageFunctionType();

	/**
	 * Returns a new object of class '<em>CRS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CRS Property Type</em>'.
	 * @generated
	 */
	CRSPropertyType createCRSPropertyType();

	/**
	 * Returns a new object of class '<em>Cubic Spline Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cubic Spline Type</em>'.
	 * @generated
	 */
	CubicSplineType createCubicSplineType();

	/**
	 * Returns a new object of class '<em>Curve Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Curve Array Property Type</em>'.
	 * @generated
	 */
	CurveArrayPropertyType createCurveArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Curve Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Curve Property Type</em>'.
	 * @generated
	 */
	CurvePropertyType createCurvePropertyType();

	/**
	 * Returns a new object of class '<em>Curve Segment Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Curve Segment Array Property Type</em>'.
	 * @generated
	 */
	CurveSegmentArrayPropertyType createCurveSegmentArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Curve Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Curve Type</em>'.
	 * @generated
	 */
	CurveType createCurveType();

	/**
	 * Returns a new object of class '<em>Cylinder Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cylinder Type</em>'.
	 * @generated
	 */
	CylinderType createCylinderType();

	/**
	 * Returns a new object of class '<em>Cylindrical CS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cylindrical CS Property Type</em>'.
	 * @generated
	 */
	CylindricalCSPropertyType createCylindricalCSPropertyType();

	/**
	 * Returns a new object of class '<em>Cylindrical CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cylindrical CS Type</em>'.
	 * @generated
	 */
	CylindricalCSType createCylindricalCSType();

	/**
	 * Returns a new object of class '<em>Data Block Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Block Type</em>'.
	 * @generated
	 */
	DataBlockType createDataBlockType();

	/**
	 * Returns a new object of class '<em>Datum Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Datum Property Type</em>'.
	 * @generated
	 */
	DatumPropertyType createDatumPropertyType();

	/**
	 * Returns a new object of class '<em>Definition Base Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Definition Base Type</em>'.
	 * @generated
	 */
	DefinitionBaseType createDefinitionBaseType();

	/**
	 * Returns a new object of class '<em>Definition Proxy Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Definition Proxy Type</em>'.
	 * @generated
	 */
	DefinitionProxyType createDefinitionProxyType();

	/**
	 * Returns a new object of class '<em>Definition Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Definition Type</em>'.
	 * @generated
	 */
	DefinitionType createDefinitionType();

	/**
	 * Returns a new object of class '<em>Degrees Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Degrees Type</em>'.
	 * @generated
	 */
	DegreesType createDegreesType();

	/**
	 * Returns a new object of class '<em>Derivation Unit Term Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Derivation Unit Term Type</em>'.
	 * @generated
	 */
	DerivationUnitTermType createDerivationUnitTermType();

	/**
	 * Returns a new object of class '<em>Derived CRS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Derived CRS Property Type</em>'.
	 * @generated
	 */
	DerivedCRSPropertyType createDerivedCRSPropertyType();

	/**
	 * Returns a new object of class '<em>Derived CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Derived CRS Type</em>'.
	 * @generated
	 */
	DerivedCRSType createDerivedCRSType();

	/**
	 * Returns a new object of class '<em>Derived Unit Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Derived Unit Type</em>'.
	 * @generated
	 */
	DerivedUnitType createDerivedUnitType();

	/**
	 * Returns a new object of class '<em>Dictionary Entry Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dictionary Entry Type</em>'.
	 * @generated
	 */
	DictionaryEntryType createDictionaryEntryType();

	/**
	 * Returns a new object of class '<em>Dictionary Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dictionary Type</em>'.
	 * @generated
	 */
	DictionaryType createDictionaryType();

	/**
	 * Returns a new object of class '<em>Directed Edge Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Directed Edge Property Type</em>'.
	 * @generated
	 */
	DirectedEdgePropertyType createDirectedEdgePropertyType();

	/**
	 * Returns a new object of class '<em>Directed Face Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Directed Face Property Type</em>'.
	 * @generated
	 */
	DirectedFacePropertyType createDirectedFacePropertyType();

	/**
	 * Returns a new object of class '<em>Directed Node Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Directed Node Property Type</em>'.
	 * @generated
	 */
	DirectedNodePropertyType createDirectedNodePropertyType();

	/**
	 * Returns a new object of class '<em>Directed Observation At Distance Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Directed Observation At Distance Type</em>'.
	 * @generated
	 */
	DirectedObservationAtDistanceType createDirectedObservationAtDistanceType();

	/**
	 * Returns a new object of class '<em>Directed Observation Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Directed Observation Type</em>'.
	 * @generated
	 */
	DirectedObservationType createDirectedObservationType();

	/**
	 * Returns a new object of class '<em>Directed Topo Solid Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Directed Topo Solid Property Type</em>'.
	 * @generated
	 */
	DirectedTopoSolidPropertyType createDirectedTopoSolidPropertyType();

	/**
	 * Returns a new object of class '<em>Direction Description Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Direction Description Type</em>'.
	 * @generated
	 */
	DirectionDescriptionType createDirectionDescriptionType();

	/**
	 * Returns a new object of class '<em>Direction Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Direction Property Type</em>'.
	 * @generated
	 */
	DirectionPropertyType createDirectionPropertyType();

	/**
	 * Returns a new object of class '<em>Direction Vector Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Direction Vector Type</em>'.
	 * @generated
	 */
	DirectionVectorType createDirectionVectorType();

	/**
	 * Returns a new object of class '<em>Direct Position List Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Direct Position List Type</em>'.
	 * @generated
	 */
	DirectPositionListType createDirectPositionListType();

	/**
	 * Returns a new object of class '<em>Direct Position Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Direct Position Type</em>'.
	 * @generated
	 */
	DirectPositionType createDirectPositionType();

	/**
	 * Returns a new object of class '<em>Discrete Coverage Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Discrete Coverage Type</em>'.
	 * @generated
	 */
	DiscreteCoverageType createDiscreteCoverageType();

	/**
	 * Returns a new object of class '<em>DMS Angle Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DMS Angle Type</em>'.
	 * @generated
	 */
	DMSAngleType createDMSAngleType();

	/**
	 * Returns a new object of class '<em>Document Root</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Document Root</em>'.
	 * @generated
	 */
	GMLDocumentRoot createGMLDocumentRoot();

	/**
	 * Returns a new object of class '<em>Domain Of Validity Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Domain Of Validity Type</em>'.
	 * @generated
	 */
	DomainOfValidityType createDomainOfValidityType();

	/**
	 * Returns a new object of class '<em>Domain Set Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Domain Set Type</em>'.
	 * @generated
	 */
	DomainSetType createDomainSetType();

	/**
	 * Returns a new object of class '<em>Dynamic Feature Collection Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dynamic Feature Collection Type</em>'.
	 * @generated
	 */
	DynamicFeatureCollectionType createDynamicFeatureCollectionType();

	/**
	 * Returns a new object of class '<em>Dynamic Feature Member Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dynamic Feature Member Type</em>'.
	 * @generated
	 */
	DynamicFeatureMemberType createDynamicFeatureMemberType();

	/**
	 * Returns a new object of class '<em>Dynamic Feature Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dynamic Feature Type</em>'.
	 * @generated
	 */
	DynamicFeatureType createDynamicFeatureType();

	/**
	 * Returns a new object of class '<em>Edge Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Edge Type</em>'.
	 * @generated
	 */
	EdgeType createEdgeType();

	/**
	 * Returns a new object of class '<em>Ellipsoidal CS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ellipsoidal CS Property Type</em>'.
	 * @generated
	 */
	EllipsoidalCSPropertyType createEllipsoidalCSPropertyType();

	/**
	 * Returns a new object of class '<em>Ellipsoidal CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ellipsoidal CS Type</em>'.
	 * @generated
	 */
	EllipsoidalCSType createEllipsoidalCSType();

	/**
	 * Returns a new object of class '<em>Ellipsoid Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ellipsoid Property Type</em>'.
	 * @generated
	 */
	EllipsoidPropertyType createEllipsoidPropertyType();

	/**
	 * Returns a new object of class '<em>Ellipsoid Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ellipsoid Type</em>'.
	 * @generated
	 */
	EllipsoidType createEllipsoidType();

	/**
	 * Returns a new object of class '<em>Engineering CRS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Engineering CRS Property Type</em>'.
	 * @generated
	 */
	EngineeringCRSPropertyType createEngineeringCRSPropertyType();

	/**
	 * Returns a new object of class '<em>Engineering CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Engineering CRS Type</em>'.
	 * @generated
	 */
	EngineeringCRSType createEngineeringCRSType();

	/**
	 * Returns a new object of class '<em>Engineering Datum Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Engineering Datum Property Type</em>'.
	 * @generated
	 */
	EngineeringDatumPropertyType createEngineeringDatumPropertyType();

	/**
	 * Returns a new object of class '<em>Engineering Datum Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Engineering Datum Type</em>'.
	 * @generated
	 */
	EngineeringDatumType createEngineeringDatumType();

	/**
	 * Returns a new object of class '<em>Envelope Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Envelope Type</em>'.
	 * @generated
	 */
	EnvelopeType createEnvelopeType();

	/**
	 * Returns a new object of class '<em>Envelope With Time Period Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Envelope With Time Period Type</em>'.
	 * @generated
	 */
	EnvelopeWithTimePeriodType createEnvelopeWithTimePeriodType();

	/**
	 * Returns a new object of class '<em>Face Or Topo Solid Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Face Or Topo Solid Property Type</em>'.
	 * @generated
	 */
	FaceOrTopoSolidPropertyType createFaceOrTopoSolidPropertyType();

	/**
	 * Returns a new object of class '<em>Face Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Face Type</em>'.
	 * @generated
	 */
	FaceType createFaceType();

	/**
	 * Returns a new object of class '<em>Feature Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Feature Array Property Type</em>'.
	 * @generated
	 */
	FeatureArrayPropertyType createFeatureArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Feature Collection Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Feature Collection Type</em>'.
	 * @generated
	 */
	FeatureCollectionType createFeatureCollectionType();

	/**
	 * Returns a new object of class '<em>Feature Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Feature Property Type</em>'.
	 * @generated
	 */
	FeaturePropertyType createFeaturePropertyType();

	/**
	 * Returns a new object of class '<em>File Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>File Type</em>'.
	 * @generated
	 */
	FileType createFileType();

	/**
	 * Returns a new object of class '<em>Formula Citation Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Formula Citation Type</em>'.
	 * @generated
	 */
	FormulaCitationType createFormulaCitationType();

	/**
	 * Returns a new object of class '<em>Formula Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Formula Type</em>'.
	 * @generated
	 */
	FormulaType createFormulaType();

	/**
	 * Returns a new object of class '<em>General Conversion Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>General Conversion Property Type</em>'.
	 * @generated
	 */
	GeneralConversionPropertyType createGeneralConversionPropertyType();

	/**
	 * Returns a new object of class '<em>General Transformation Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>General Transformation Property Type</em>'.
	 * @generated
	 */
	GeneralTransformationPropertyType createGeneralTransformationPropertyType();

	/**
	 * Returns a new object of class '<em>Generic Meta Data Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Generic Meta Data Type</em>'.
	 * @generated
	 */
	GenericMetaDataType createGenericMetaDataType();

	/**
	 * Returns a new object of class '<em>Geocentric CRS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geocentric CRS Property Type</em>'.
	 * @generated
	 */
	GeocentricCRSPropertyType createGeocentricCRSPropertyType();

	/**
	 * Returns a new object of class '<em>Geocentric CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geocentric CRS Type</em>'.
	 * @generated
	 */
	GeocentricCRSType createGeocentricCRSType();

	/**
	 * Returns a new object of class '<em>Geodesic String Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geodesic String Type</em>'.
	 * @generated
	 */
	GeodesicStringType createGeodesicStringType();

	/**
	 * Returns a new object of class '<em>Geodesic Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geodesic Type</em>'.
	 * @generated
	 */
	GeodesicType createGeodesicType();

	/**
	 * Returns a new object of class '<em>Geodetic CRS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geodetic CRS Property Type</em>'.
	 * @generated
	 */
	GeodeticCRSPropertyType createGeodeticCRSPropertyType();

	/**
	 * Returns a new object of class '<em>Geodetic CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geodetic CRS Type</em>'.
	 * @generated
	 */
	GeodeticCRSType createGeodeticCRSType();

	/**
	 * Returns a new object of class '<em>Geodetic Datum Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geodetic Datum Property Type</em>'.
	 * @generated
	 */
	GeodeticDatumPropertyType createGeodeticDatumPropertyType();

	/**
	 * Returns a new object of class '<em>Geodetic Datum Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geodetic Datum Type</em>'.
	 * @generated
	 */
	GeodeticDatumType createGeodeticDatumType();

	/**
	 * Returns a new object of class '<em>Geographic CRS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geographic CRS Property Type</em>'.
	 * @generated
	 */
	GeographicCRSPropertyType createGeographicCRSPropertyType();

	/**
	 * Returns a new object of class '<em>Geographic CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geographic CRS Type</em>'.
	 * @generated
	 */
	GeographicCRSType createGeographicCRSType();

	/**
	 * Returns a new object of class '<em>Geometric Complex Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geometric Complex Property Type</em>'.
	 * @generated
	 */
	GeometricComplexPropertyType createGeometricComplexPropertyType();

	/**
	 * Returns a new object of class '<em>Geometric Complex Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geometric Complex Type</em>'.
	 * @generated
	 */
	GeometricComplexType createGeometricComplexType();

	/**
	 * Returns a new object of class '<em>Geometric Primitive Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geometric Primitive Property Type</em>'.
	 * @generated
	 */
	GeometricPrimitivePropertyType createGeometricPrimitivePropertyType();

	/**
	 * Returns a new object of class '<em>Geometry Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geometry Array Property Type</em>'.
	 * @generated
	 */
	GeometryArrayPropertyType createGeometryArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Geometry Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geometry Property Type</em>'.
	 * @generated
	 */
	GeometryPropertyType createGeometryPropertyType();

	/**
	 * Returns a new object of class '<em>Grid Envelope Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Grid Envelope Type</em>'.
	 * @generated
	 */
	GridEnvelopeType createGridEnvelopeType();

	/**
	 * Returns a new object of class '<em>Grid Function Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Grid Function Type</em>'.
	 * @generated
	 */
	GridFunctionType createGridFunctionType();

	/**
	 * Returns a new object of class '<em>Grid Length Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Grid Length Type</em>'.
	 * @generated
	 */
	GridLengthType createGridLengthType();

	/**
	 * Returns a new object of class '<em>Grid Limits Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Grid Limits Type</em>'.
	 * @generated
	 */
	GridLimitsType createGridLimitsType();

	/**
	 * Returns a new object of class '<em>Grid Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Grid Type</em>'.
	 * @generated
	 */
	GridType createGridType();

	/**
	 * Returns a new object of class '<em>History Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>History Property Type</em>'.
	 * @generated
	 */
	HistoryPropertyType createHistoryPropertyType();

	/**
	 * Returns a new object of class '<em>Image CRS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Image CRS Property Type</em>'.
	 * @generated
	 */
	ImageCRSPropertyType createImageCRSPropertyType();

	/**
	 * Returns a new object of class '<em>Image CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Image CRS Type</em>'.
	 * @generated
	 */
	ImageCRSType createImageCRSType();

	/**
	 * Returns a new object of class '<em>Image Datum Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Image Datum Property Type</em>'.
	 * @generated
	 */
	ImageDatumPropertyType createImageDatumPropertyType();

	/**
	 * Returns a new object of class '<em>Image Datum Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Image Datum Type</em>'.
	 * @generated
	 */
	ImageDatumType createImageDatumType();

	/**
	 * Returns a new object of class '<em>Indirect Entry Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Indirect Entry Type</em>'.
	 * @generated
	 */
	IndirectEntryType createIndirectEntryType();

	/**
	 * Returns a new object of class '<em>Inline Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Inline Property Type</em>'.
	 * @generated
	 */
	InlinePropertyType createInlinePropertyType();

	/**
	 * Returns a new object of class '<em>Knot Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Knot Property Type</em>'.
	 * @generated
	 */
	KnotPropertyType createKnotPropertyType();

	/**
	 * Returns a new object of class '<em>Knot Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Knot Type</em>'.
	 * @generated
	 */
	KnotType createKnotType();

	/**
	 * Returns a new object of class '<em>Length Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Length Type</em>'.
	 * @generated
	 */
	LengthType createLengthType();

	/**
	 * Returns a new object of class '<em>Linear CS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Linear CS Property Type</em>'.
	 * @generated
	 */
	LinearCSPropertyType createLinearCSPropertyType();

	/**
	 * Returns a new object of class '<em>Linear CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Linear CS Type</em>'.
	 * @generated
	 */
	LinearCSType createLinearCSType();

	/**
	 * Returns a new object of class '<em>Linear Ring Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Linear Ring Property Type</em>'.
	 * @generated
	 */
	LinearRingPropertyType createLinearRingPropertyType();

	/**
	 * Returns a new object of class '<em>Linear Ring Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Linear Ring Type</em>'.
	 * @generated
	 */
	LinearRingType createLinearRingType();

	/**
	 * Returns a new object of class '<em>Line String Segment Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Line String Segment Array Property Type</em>'.
	 * @generated
	 */
	LineStringSegmentArrayPropertyType createLineStringSegmentArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Line String Segment Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Line String Segment Type</em>'.
	 * @generated
	 */
	LineStringSegmentType createLineStringSegmentType();

	/**
	 * Returns a new object of class '<em>Line String Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Line String Type</em>'.
	 * @generated
	 */
	LineStringType createLineStringType();

	/**
	 * Returns a new object of class '<em>Location Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Location Property Type</em>'.
	 * @generated
	 */
	LocationPropertyType createLocationPropertyType();

	/**
	 * Returns a new object of class '<em>Mapping Rule Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mapping Rule Type</em>'.
	 * @generated
	 */
	MappingRuleType createMappingRuleType();

	/**
	 * Returns a new object of class '<em>Measure List Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Measure List Type</em>'.
	 * @generated
	 */
	MeasureListType createMeasureListType();

	/**
	 * Returns a new object of class '<em>Measure Or Nil Reason List Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Measure Or Nil Reason List Type</em>'.
	 * @generated
	 */
	MeasureOrNilReasonListType createMeasureOrNilReasonListType();

	/**
	 * Returns a new object of class '<em>Measure Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Measure Type</em>'.
	 * @generated
	 */
	MeasureType createMeasureType();

	/**
	 * Returns a new object of class '<em>Meta Data Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Meta Data Property Type</em>'.
	 * @generated
	 */
	MetaDataPropertyType createMetaDataPropertyType();

	/**
	 * Returns a new object of class '<em>Moving Object Status Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Moving Object Status Type</em>'.
	 * @generated
	 */
	MovingObjectStatusType createMovingObjectStatusType();

	/**
	 * Returns a new object of class '<em>Multi Curve Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Curve Property Type</em>'.
	 * @generated
	 */
	MultiCurvePropertyType createMultiCurvePropertyType();

	/**
	 * Returns a new object of class '<em>Multi Curve Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Curve Type</em>'.
	 * @generated
	 */
	MultiCurveType createMultiCurveType();

	/**
	 * Returns a new object of class '<em>Multi Geometry Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Geometry Property Type</em>'.
	 * @generated
	 */
	MultiGeometryPropertyType createMultiGeometryPropertyType();

	/**
	 * Returns a new object of class '<em>Multi Geometry Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Geometry Type</em>'.
	 * @generated
	 */
	MultiGeometryType createMultiGeometryType();

	/**
	 * Returns a new object of class '<em>Multi Point Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Point Property Type</em>'.
	 * @generated
	 */
	MultiPointPropertyType createMultiPointPropertyType();

	/**
	 * Returns a new object of class '<em>Multi Point Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Point Type</em>'.
	 * @generated
	 */
	MultiPointType createMultiPointType();

	/**
	 * Returns a new object of class '<em>Multi Solid Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Solid Property Type</em>'.
	 * @generated
	 */
	MultiSolidPropertyType createMultiSolidPropertyType();

	/**
	 * Returns a new object of class '<em>Multi Solid Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Solid Type</em>'.
	 * @generated
	 */
	MultiSolidType createMultiSolidType();

	/**
	 * Returns a new object of class '<em>Multi Surface Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Surface Property Type</em>'.
	 * @generated
	 */
	MultiSurfacePropertyType createMultiSurfacePropertyType();

	/**
	 * Returns a new object of class '<em>Multi Surface Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Surface Type</em>'.
	 * @generated
	 */
	MultiSurfaceType createMultiSurfaceType();

	/**
	 * Returns a new object of class '<em>Node Or Edge Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Node Or Edge Property Type</em>'.
	 * @generated
	 */
	NodeOrEdgePropertyType createNodeOrEdgePropertyType();

	/**
	 * Returns a new object of class '<em>Node Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Node Property Type</em>'.
	 * @generated
	 */
	NodePropertyType createNodePropertyType();

	/**
	 * Returns a new object of class '<em>Node Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Node Type</em>'.
	 * @generated
	 */
	NodeType createNodeType();

	/**
	 * Returns a new object of class '<em>Oblique Cartesian CS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Oblique Cartesian CS Property Type</em>'.
	 * @generated
	 */
	ObliqueCartesianCSPropertyType createObliqueCartesianCSPropertyType();

	/**
	 * Returns a new object of class '<em>Oblique Cartesian CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Oblique Cartesian CS Type</em>'.
	 * @generated
	 */
	ObliqueCartesianCSType createObliqueCartesianCSType();

	/**
	 * Returns a new object of class '<em>Observation Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Observation Type</em>'.
	 * @generated
	 */
	ObservationType createObservationType();

	/**
	 * Returns a new object of class '<em>Offset Curve Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Offset Curve Type</em>'.
	 * @generated
	 */
	OffsetCurveType createOffsetCurveType();

	/**
	 * Returns a new object of class '<em>Operation Method Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operation Method Property Type</em>'.
	 * @generated
	 */
	OperationMethodPropertyType createOperationMethodPropertyType();

	/**
	 * Returns a new object of class '<em>Operation Method Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operation Method Type</em>'.
	 * @generated
	 */
	OperationMethodType createOperationMethodType();

	/**
	 * Returns a new object of class '<em>Operation Parameter Group Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operation Parameter Group Property Type</em>'.
	 * @generated
	 */
	OperationParameterGroupPropertyType createOperationParameterGroupPropertyType();

	/**
	 * Returns a new object of class '<em>Operation Parameter Group Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operation Parameter Group Type</em>'.
	 * @generated
	 */
	OperationParameterGroupType createOperationParameterGroupType();

	/**
	 * Returns a new object of class '<em>Operation Parameter Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operation Parameter Property Type</em>'.
	 * @generated
	 */
	OperationParameterPropertyType createOperationParameterPropertyType();

	/**
	 * Returns a new object of class '<em>Operation Parameter Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operation Parameter Type</em>'.
	 * @generated
	 */
	OperationParameterType createOperationParameterType();

	/**
	 * Returns a new object of class '<em>Operation Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operation Property Type</em>'.
	 * @generated
	 */
	OperationPropertyType createOperationPropertyType();

	/**
	 * Returns a new object of class '<em>Orientable Curve Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Orientable Curve Type</em>'.
	 * @generated
	 */
	OrientableCurveType createOrientableCurveType();

	/**
	 * Returns a new object of class '<em>Orientable Surface Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Orientable Surface Type</em>'.
	 * @generated
	 */
	OrientableSurfaceType createOrientableSurfaceType();

	/**
	 * Returns a new object of class '<em>Parameter Value Group Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Parameter Value Group Type</em>'.
	 * @generated
	 */
	ParameterValueGroupType createParameterValueGroupType();

	/**
	 * Returns a new object of class '<em>Parameter Value Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Parameter Value Type</em>'.
	 * @generated
	 */
	ParameterValueType createParameterValueType();

	/**
	 * Returns a new object of class '<em>Pass Through Operation Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Pass Through Operation Property Type</em>'.
	 * @generated
	 */
	PassThroughOperationPropertyType createPassThroughOperationPropertyType();

	/**
	 * Returns a new object of class '<em>Pass Through Operation Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Pass Through Operation Type</em>'.
	 * @generated
	 */
	PassThroughOperationType createPassThroughOperationType();

	/**
	 * Returns a new object of class '<em>Point Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Point Array Property Type</em>'.
	 * @generated
	 */
	PointArrayPropertyType createPointArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Point Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Point Property Type</em>'.
	 * @generated
	 */
	PointPropertyType createPointPropertyType();

	/**
	 * Returns a new object of class '<em>Point Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Point Type</em>'.
	 * @generated
	 */
	PointType createPointType();

	/**
	 * Returns a new object of class '<em>Polar CS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Polar CS Property Type</em>'.
	 * @generated
	 */
	PolarCSPropertyType createPolarCSPropertyType();

	/**
	 * Returns a new object of class '<em>Polar CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Polar CS Type</em>'.
	 * @generated
	 */
	PolarCSType createPolarCSType();

	/**
	 * Returns a new object of class '<em>Polygon Patch Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Polygon Patch Type</em>'.
	 * @generated
	 */
	PolygonPatchType createPolygonPatchType();

	/**
	 * Returns a new object of class '<em>Polygon Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Polygon Type</em>'.
	 * @generated
	 */
	PolygonType createPolygonType();

	/**
	 * Returns a new object of class '<em>Prime Meridian Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Prime Meridian Property Type</em>'.
	 * @generated
	 */
	PrimeMeridianPropertyType createPrimeMeridianPropertyType();

	/**
	 * Returns a new object of class '<em>Prime Meridian Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Prime Meridian Type</em>'.
	 * @generated
	 */
	PrimeMeridianType createPrimeMeridianType();

	/**
	 * Returns a new object of class '<em>Priority Location Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Priority Location Property Type</em>'.
	 * @generated
	 */
	PriorityLocationPropertyType createPriorityLocationPropertyType();

	/**
	 * Returns a new object of class '<em>Procedure Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Procedure Property Type</em>'.
	 * @generated
	 */
	ProcedurePropertyType createProcedurePropertyType();

	/**
	 * Returns a new object of class '<em>Projected CRS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Projected CRS Property Type</em>'.
	 * @generated
	 */
	ProjectedCRSPropertyType createProjectedCRSPropertyType();

	/**
	 * Returns a new object of class '<em>Projected CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Projected CRS Type</em>'.
	 * @generated
	 */
	ProjectedCRSType createProjectedCRSType();

	/**
	 * Returns a new object of class '<em>Quantity Extent Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Quantity Extent Type</em>'.
	 * @generated
	 */
	QuantityExtentType createQuantityExtentType();

	/**
	 * Returns a new object of class '<em>Quantity Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Quantity Property Type</em>'.
	 * @generated
	 */
	QuantityPropertyType createQuantityPropertyType();

	/**
	 * Returns a new object of class '<em>Quantity Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Quantity Type</em>'.
	 * @generated
	 */
	QuantityType createQuantityType();

	/**
	 * Returns a new object of class '<em>Range Set Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Range Set Type</em>'.
	 * @generated
	 */
	RangeSetType createRangeSetType();

	/**
	 * Returns a new object of class '<em>Rectangle Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Rectangle Type</em>'.
	 * @generated
	 */
	RectangleType createRectangleType();

	/**
	 * Returns a new object of class '<em>Rectified Grid Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Rectified Grid Type</em>'.
	 * @generated
	 */
	RectifiedGridType createRectifiedGridType();

	/**
	 * Returns a new object of class '<em>Reference Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Reference Type</em>'.
	 * @generated
	 */
	ReferenceType createReferenceType();

	/**
	 * Returns a new object of class '<em>Ref Location Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ref Location Type</em>'.
	 * @generated
	 */
	RefLocationType createRefLocationType();

	/**
	 * Returns a new object of class '<em>Related Time Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Related Time Type</em>'.
	 * @generated
	 */
	RelatedTimeType createRelatedTimeType();

	/**
	 * Returns a new object of class '<em>Result Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Result Type</em>'.
	 * @generated
	 */
	ResultType createResultType();

	/**
	 * Returns a new object of class '<em>Ring Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ring Property Type</em>'.
	 * @generated
	 */
	RingPropertyType createRingPropertyType();

	/**
	 * Returns a new object of class '<em>Ring Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ring Type</em>'.
	 * @generated
	 */
	RingType createRingType();

	/**
	 * Returns a new object of class '<em>Rows Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Rows Type</em>'.
	 * @generated
	 */
	RowsType createRowsType();

	/**
	 * Returns a new object of class '<em>Row Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Row Type</em>'.
	 * @generated
	 */
	RowType createRowType();

	/**
	 * Returns a new object of class '<em>Scale Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Scale Type</em>'.
	 * @generated
	 */
	ScaleType createScaleType();

	/**
	 * Returns a new object of class '<em>Second Defining Parameter Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Second Defining Parameter Type</em>'.
	 * @generated
	 */
	SecondDefiningParameterType createSecondDefiningParameterType();

	/**
	 * Returns a new object of class '<em>Second Defining Parameter Type1</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Second Defining Parameter Type1</em>'.
	 * @generated
	 */
	SecondDefiningParameterType1 createSecondDefiningParameterType1();

	/**
	 * Returns a new object of class '<em>Second Defining Parameter Type2</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Second Defining Parameter Type2</em>'.
	 * @generated
	 */
	SecondDefiningParameterType2 createSecondDefiningParameterType2();

	/**
	 * Returns a new object of class '<em>Second Defining Parameter Type3</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Second Defining Parameter Type3</em>'.
	 * @generated
	 */
	SecondDefiningParameterType3 createSecondDefiningParameterType3();

	/**
	 * Returns a new object of class '<em>Sequence Rule Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sequence Rule Type</em>'.
	 * @generated
	 */
	SequenceRuleType createSequenceRuleType();

	/**
	 * Returns a new object of class '<em>Shell Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Shell Property Type</em>'.
	 * @generated
	 */
	ShellPropertyType createShellPropertyType();

	/**
	 * Returns a new object of class '<em>Shell Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Shell Type</em>'.
	 * @generated
	 */
	ShellType createShellType();

	/**
	 * Returns a new object of class '<em>Single CRS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Single CRS Property Type</em>'.
	 * @generated
	 */
	SingleCRSPropertyType createSingleCRSPropertyType();

	/**
	 * Returns a new object of class '<em>Single Operation Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Single Operation Property Type</em>'.
	 * @generated
	 */
	SingleOperationPropertyType createSingleOperationPropertyType();

	/**
	 * Returns a new object of class '<em>Solid Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Solid Array Property Type</em>'.
	 * @generated
	 */
	SolidArrayPropertyType createSolidArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Solid Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Solid Property Type</em>'.
	 * @generated
	 */
	SolidPropertyType createSolidPropertyType();

	/**
	 * Returns a new object of class '<em>Solid Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Solid Type</em>'.
	 * @generated
	 */
	SolidType createSolidType();

	/**
	 * Returns a new object of class '<em>Speed Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Speed Type</em>'.
	 * @generated
	 */
	SpeedType createSpeedType();

	/**
	 * Returns a new object of class '<em>Sphere Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sphere Type</em>'.
	 * @generated
	 */
	SphereType createSphereType();

	/**
	 * Returns a new object of class '<em>Spherical CS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Spherical CS Property Type</em>'.
	 * @generated
	 */
	SphericalCSPropertyType createSphericalCSPropertyType();

	/**
	 * Returns a new object of class '<em>Spherical CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Spherical CS Type</em>'.
	 * @generated
	 */
	SphericalCSType createSphericalCSType();

	/**
	 * Returns a new object of class '<em>String Or Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>String Or Ref Type</em>'.
	 * @generated
	 */
	StringOrRefType createStringOrRefType();

	/**
	 * Returns a new object of class '<em>Surface Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Surface Array Property Type</em>'.
	 * @generated
	 */
	SurfaceArrayPropertyType createSurfaceArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Surface Patch Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Surface Patch Array Property Type</em>'.
	 * @generated
	 */
	SurfacePatchArrayPropertyType createSurfacePatchArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Surface Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Surface Property Type</em>'.
	 * @generated
	 */
	SurfacePropertyType createSurfacePropertyType();

	/**
	 * Returns a new object of class '<em>Surface Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Surface Type</em>'.
	 * @generated
	 */
	SurfaceType createSurfaceType();

	/**
	 * Returns a new object of class '<em>Target Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Target Property Type</em>'.
	 * @generated
	 */
	TargetPropertyType createTargetPropertyType();

	/**
	 * Returns a new object of class '<em>Temporal CRS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Temporal CRS Property Type</em>'.
	 * @generated
	 */
	TemporalCRSPropertyType createTemporalCRSPropertyType();

	/**
	 * Returns a new object of class '<em>Temporal CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Temporal CRS Type</em>'.
	 * @generated
	 */
	TemporalCRSType createTemporalCRSType();

	/**
	 * Returns a new object of class '<em>Temporal CS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Temporal CS Property Type</em>'.
	 * @generated
	 */
	TemporalCSPropertyType createTemporalCSPropertyType();

	/**
	 * Returns a new object of class '<em>Temporal CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Temporal CS Type</em>'.
	 * @generated
	 */
	TemporalCSType createTemporalCSType();

	/**
	 * Returns a new object of class '<em>Temporal Datum Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Temporal Datum Property Type</em>'.
	 * @generated
	 */
	TemporalDatumPropertyType createTemporalDatumPropertyType();

	/**
	 * Returns a new object of class '<em>Temporal Datum Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Temporal Datum Type</em>'.
	 * @generated
	 */
	TemporalDatumType createTemporalDatumType();

	/**
	 * Returns a new object of class '<em>Time Calendar Era Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Calendar Era Property Type</em>'.
	 * @generated
	 */
	TimeCalendarEraPropertyType createTimeCalendarEraPropertyType();

	/**
	 * Returns a new object of class '<em>Time Calendar Era Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Calendar Era Type</em>'.
	 * @generated
	 */
	TimeCalendarEraType createTimeCalendarEraType();

	/**
	 * Returns a new object of class '<em>Time Calendar Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Calendar Property Type</em>'.
	 * @generated
	 */
	TimeCalendarPropertyType createTimeCalendarPropertyType();

	/**
	 * Returns a new object of class '<em>Time Calendar Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Calendar Type</em>'.
	 * @generated
	 */
	TimeCalendarType createTimeCalendarType();

	/**
	 * Returns a new object of class '<em>Time Clock Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Clock Property Type</em>'.
	 * @generated
	 */
	TimeClockPropertyType createTimeClockPropertyType();

	/**
	 * Returns a new object of class '<em>Time Clock Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Clock Type</em>'.
	 * @generated
	 */
	TimeClockType createTimeClockType();

	/**
	 * Returns a new object of class '<em>Time Coordinate System Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Coordinate System Type</em>'.
	 * @generated
	 */
	TimeCoordinateSystemType createTimeCoordinateSystemType();

	/**
	 * Returns a new object of class '<em>Time CS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time CS Property Type</em>'.
	 * @generated
	 */
	TimeCSPropertyType createTimeCSPropertyType();

	/**
	 * Returns a new object of class '<em>Time CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time CS Type</em>'.
	 * @generated
	 */
	TimeCSType createTimeCSType();

	/**
	 * Returns a new object of class '<em>Time Edge Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Edge Property Type</em>'.
	 * @generated
	 */
	TimeEdgePropertyType createTimeEdgePropertyType();

	/**
	 * Returns a new object of class '<em>Time Edge Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Edge Type</em>'.
	 * @generated
	 */
	TimeEdgeType createTimeEdgeType();

	/**
	 * Returns a new object of class '<em>Time Instant Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Instant Property Type</em>'.
	 * @generated
	 */
	TimeInstantPropertyType createTimeInstantPropertyType();

	/**
	 * Returns a new object of class '<em>Time Instant Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Instant Type</em>'.
	 * @generated
	 */
	TimeInstantType createTimeInstantType();

	/**
	 * Returns a new object of class '<em>Time Interval Length Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Interval Length Type</em>'.
	 * @generated
	 */
	TimeIntervalLengthType createTimeIntervalLengthType();

	/**
	 * Returns a new object of class '<em>Time Node Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Node Property Type</em>'.
	 * @generated
	 */
	TimeNodePropertyType createTimeNodePropertyType();

	/**
	 * Returns a new object of class '<em>Time Node Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Node Type</em>'.
	 * @generated
	 */
	TimeNodeType createTimeNodeType();

	/**
	 * Returns a new object of class '<em>Time Ordinal Era Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Ordinal Era Property Type</em>'.
	 * @generated
	 */
	TimeOrdinalEraPropertyType createTimeOrdinalEraPropertyType();

	/**
	 * Returns a new object of class '<em>Time Ordinal Era Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Ordinal Era Type</em>'.
	 * @generated
	 */
	TimeOrdinalEraType createTimeOrdinalEraType();

	/**
	 * Returns a new object of class '<em>Time Ordinal Reference System Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Ordinal Reference System Type</em>'.
	 * @generated
	 */
	TimeOrdinalReferenceSystemType createTimeOrdinalReferenceSystemType();

	/**
	 * Returns a new object of class '<em>Time Period Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Period Property Type</em>'.
	 * @generated
	 */
	TimePeriodPropertyType createTimePeriodPropertyType();

	/**
	 * Returns a new object of class '<em>Time Period Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Period Type</em>'.
	 * @generated
	 */
	TimePeriodType createTimePeriodType();

	/**
	 * Returns a new object of class '<em>Time Position Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Position Type</em>'.
	 * @generated
	 */
	TimePositionType createTimePositionType();

	/**
	 * Returns a new object of class '<em>Time Primitive Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Primitive Property Type</em>'.
	 * @generated
	 */
	TimePrimitivePropertyType createTimePrimitivePropertyType();

	/**
	 * Returns a new object of class '<em>Time Reference System Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Reference System Type</em>'.
	 * @generated
	 */
	TimeReferenceSystemType createTimeReferenceSystemType();

	/**
	 * Returns a new object of class '<em>Time Topology Complex Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Topology Complex Property Type</em>'.
	 * @generated
	 */
	TimeTopologyComplexPropertyType createTimeTopologyComplexPropertyType();

	/**
	 * Returns a new object of class '<em>Time Topology Primitive Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Topology Primitive Property Type</em>'.
	 * @generated
	 */
	TimeTopologyPrimitivePropertyType createTimeTopologyPrimitivePropertyType();

	/**
	 * Returns a new object of class '<em>Time Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Type</em>'.
	 * @generated
	 */
	TimeType createTimeType();

	/**
	 * Returns a new object of class '<em>Tin Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Tin Type</em>'.
	 * @generated
	 */
	TinType createTinType();

	/**
	 * Returns a new object of class '<em>Topo Complex Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Complex Property Type</em>'.
	 * @generated
	 */
	TopoComplexPropertyType createTopoComplexPropertyType();

	/**
	 * Returns a new object of class '<em>Topo Complex Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Complex Type</em>'.
	 * @generated
	 */
	TopoComplexType createTopoComplexType();

	/**
	 * Returns a new object of class '<em>Topo Curve Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Curve Property Type</em>'.
	 * @generated
	 */
	TopoCurvePropertyType createTopoCurvePropertyType();

	/**
	 * Returns a new object of class '<em>Topo Curve Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Curve Type</em>'.
	 * @generated
	 */
	TopoCurveType createTopoCurveType();

	/**
	 * Returns a new object of class '<em>Topo Point Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Point Property Type</em>'.
	 * @generated
	 */
	TopoPointPropertyType createTopoPointPropertyType();

	/**
	 * Returns a new object of class '<em>Topo Point Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Point Type</em>'.
	 * @generated
	 */
	TopoPointType createTopoPointType();

	/**
	 * Returns a new object of class '<em>Topo Primitive Array Association Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Primitive Array Association Type</em>'.
	 * @generated
	 */
	TopoPrimitiveArrayAssociationType createTopoPrimitiveArrayAssociationType();

	/**
	 * Returns a new object of class '<em>Topo Primitive Member Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Primitive Member Type</em>'.
	 * @generated
	 */
	TopoPrimitiveMemberType createTopoPrimitiveMemberType();

	/**
	 * Returns a new object of class '<em>Topo Solid Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Solid Property Type</em>'.
	 * @generated
	 */
	TopoSolidPropertyType createTopoSolidPropertyType();

	/**
	 * Returns a new object of class '<em>Topo Solid Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Solid Type</em>'.
	 * @generated
	 */
	TopoSolidType createTopoSolidType();

	/**
	 * Returns a new object of class '<em>Topo Surface Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Surface Property Type</em>'.
	 * @generated
	 */
	TopoSurfacePropertyType createTopoSurfacePropertyType();

	/**
	 * Returns a new object of class '<em>Topo Surface Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Surface Type</em>'.
	 * @generated
	 */
	TopoSurfaceType createTopoSurfaceType();

	/**
	 * Returns a new object of class '<em>Topo Volume Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Volume Property Type</em>'.
	 * @generated
	 */
	TopoVolumePropertyType createTopoVolumePropertyType();

	/**
	 * Returns a new object of class '<em>Topo Volume Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Volume Type</em>'.
	 * @generated
	 */
	TopoVolumeType createTopoVolumeType();

	/**
	 * Returns a new object of class '<em>Transformation Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Transformation Property Type</em>'.
	 * @generated
	 */
	TransformationPropertyType createTransformationPropertyType();

	/**
	 * Returns a new object of class '<em>Transformation Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Transformation Type</em>'.
	 * @generated
	 */
	TransformationType createTransformationType();

	/**
	 * Returns a new object of class '<em>Triangle Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Triangle Type</em>'.
	 * @generated
	 */
	TriangleType createTriangleType();

	/**
	 * Returns a new object of class '<em>Unit Definition Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Unit Definition Type</em>'.
	 * @generated
	 */
	UnitDefinitionType createUnitDefinitionType();

	/**
	 * Returns a new object of class '<em>Unit Of Measure Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Unit Of Measure Type</em>'.
	 * @generated
	 */
	UnitOfMeasureType createUnitOfMeasureType();

	/**
	 * Returns a new object of class '<em>User Defined CS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>User Defined CS Property Type</em>'.
	 * @generated
	 */
	UserDefinedCSPropertyType createUserDefinedCSPropertyType();

	/**
	 * Returns a new object of class '<em>User Defined CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>User Defined CS Type</em>'.
	 * @generated
	 */
	UserDefinedCSType createUserDefinedCSType();

	/**
	 * Returns a new object of class '<em>Value Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Value Array Property Type</em>'.
	 * @generated
	 */
	ValueArrayPropertyType createValueArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Value Array Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Value Array Type</em>'.
	 * @generated
	 */
	ValueArrayType createValueArrayType();

	/**
	 * Returns a new object of class '<em>Value Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Value Property Type</em>'.
	 * @generated
	 */
	ValuePropertyType createValuePropertyType();

	/**
	 * Returns a new object of class '<em>Vector Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Vector Type</em>'.
	 * @generated
	 */
	VectorType createVectorType();

	/**
	 * Returns a new object of class '<em>Vertical CRS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Vertical CRS Property Type</em>'.
	 * @generated
	 */
	VerticalCRSPropertyType createVerticalCRSPropertyType();

	/**
	 * Returns a new object of class '<em>Vertical CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Vertical CRS Type</em>'.
	 * @generated
	 */
	VerticalCRSType createVerticalCRSType();

	/**
	 * Returns a new object of class '<em>Vertical CS Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Vertical CS Property Type</em>'.
	 * @generated
	 */
	VerticalCSPropertyType createVerticalCSPropertyType();

	/**
	 * Returns a new object of class '<em>Vertical CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Vertical CS Type</em>'.
	 * @generated
	 */
	VerticalCSType createVerticalCSType();

	/**
	 * Returns a new object of class '<em>Vertical Datum Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Vertical Datum Property Type</em>'.
	 * @generated
	 */
	VerticalDatumPropertyType createVerticalDatumPropertyType();

	/**
	 * Returns a new object of class '<em>Vertical Datum Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Vertical Datum Type</em>'.
	 * @generated
	 */
	VerticalDatumType createVerticalDatumType();

	/**
	 * Returns a new object of class '<em>Volume Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Volume Type</em>'.
	 * @generated
	 */
	VolumeType createVolumeType();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	GMLPackage getGMLPackage();

} //GMLFactory
