/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package net.opengis.gml.gml;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * See ISO/DIS 19136 7.2.
 * The gmlBase schema components establish the GML model and syntax, in particular
 * -	a root XML type from which XML types for all GML objects should be derived,
 * -	a pattern and components for GML properties,
 * -	patterns for collections and arrays, and components for generic collections and arrays,
 * -	components for associating metadata with GML objects,
 * -	components for constructing definitions and dictionaries.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * 
 * 			GML is an OGC Standard.
 * 			Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * 			To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 15.6.
 * A number of types and relationships are defined to represent the time-varying properties of geographic features. 
 * In a comprehensive treatment of spatiotemporal modeling, Langran (see Bibliography) distinguished three principal temporal entities: states, events, and evidence; the schema specified in the following Subclauses incorporates elements for each.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 Clause 14.
 * Topology is the branch of mathematics describing the properties of objects which are invariant under continuous deformation. For example, a circle is topologically equivalent to an ellipse because one can be transformed into the other by stretching. In geographic modelling, the foremost use of topology is in accelerating computational geometry. The constructs of topology allow characterisation of the spatial relationships between objects using simple combinatorial or algebraic algorithms. Topology, realised by the appropriate geometry, also allows a compact and unambiguous mechanism for expressing shared geometry among geographic features.
 * There are four instantiable classes of primitive topology objects, one for each dimension up to 3D. In addition, topological complexes are supported, too. 
 * There is strong symmetry in the (topological boundary and coboundary) relationships between topology primitives of adjacent dimensions. Topology primitives are bounded by directed primitives of one lower dimension. The coboundary of each topology primitive is formed from directed topology primitives of one higher dimension.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 20.3.
 * A coverage incorporates a mapping from a spatiotemporal domain to a range set, the latter providing the set in which the attribute values live.  The range set may be an arbitrary set including discrete lists, integer or floating point ranges, and multi-dimensional vector spaces.
 * A coverage can be viewed as the graph of the coverage function f:A à B, that is as the set of ordered pairs {(x, f(x)) | where x is in A}. This view is especially applicable to the GML encoding of a coverage.  In the case of a discrete coverage, the domain set A is partitioned into a collection of subsets (typically a disjoint collection) A = UAi and the function f is constant on each Ai. For a spatial domain, the Ai are geometry elements, hence the coverage can be viewed as a collection of (geometry,value) pairs, where the value is an element of the range set.  If the spatial domain A is a topological space then the coverage can be viewed as a collection of (topology,value) pairs, where the topology element in the pair is a topological n-chain (in GML terms this is a gml:TopoPoint, gml:TopoCurve, gml:TopoSurface or gml:TopoSolid). 
 * A coverage is implemented as a GML feature. We can thus speak of a "temperature distribution feature", or a "remotely sensed image feature", or a "soil distribution feature".
 * As is the case for any GML object, a coverage object may also be the value of a property of a feature.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 13.3.
 * The spatial-temporal coordinate reference systems schema components are divided into two logical parts. One part defines elements and types for XML encoding of abstract coordinate reference systems definitions. The larger part defines specialized constructs for XML encoding of definitions of the multiple concrete types of spatial-temporal coordinate reference systems.
 * These schema components encode the Coordinate Reference System packages of the UML Models of ISO 19111 Clause 8 and ISO/DIS 19136 D.3.10, with the exception of the abstract "SC_CRS" class.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 Clause 19.
 * A GML observation models the act of observing, often with a camera, a person or some form of instrument.  An observation feature describes the "metadata" associated with an information capture event, together with a value for the result of the observation.  This covers a broad range of cases, from a tourist photo (not the photo but the act of taking the photo), to images acquired by space borne sensors or the measurement of a temperature 5 meters below the surfaces of a lake.
 * The basic structures introduced in this schema are intended to serve as the foundation for more comprehensive schemas for scientific, technical and engineering measurement schemas.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 15.5.
 * A value in the time domain is measured relative to a temporal reference system. Common types of reference systems include calendars, ordinal temporal reference systems, and temporal coordinate systems (time elapsed since some epoch).  The primary temporal reference system for use with geographic information is the Gregorian Calendar and 24 hour local or Coordinated Universal Time (UTC), but special applications may entail the use of alternative reference systems.  The Julian day numbering system is a temporal coordinate system that has an origin earlier than any known calendar, at noon on 1 January 4713 BC in the Julian proleptic calendar, and is useful in transformations between dates in different calendars.    
 * In GML seven concrete elements are used to describe temporal reference systems: gml:TimeReferenceSystem, gml:TimeCoordinateSystem, gml:TimeCalendar, gml:TimeCalendarEra, gml:TimeClock, gml:TimeOrdinalReferenceSystem, and gml:TimeOrdinalEra.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * All global schema components that are part of the GML schema, but were deprecated. See Annex I.
 * 			
 * 			GML is an OGC Standard.
 * 			Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * 			To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 8.2.
 * W3C XML Schema provides a set of built-in "simple" types which define methods for representing values as literals without internal markup.  These are described in W3C XML Schema Part 2:2001.  Because GML is an XML encoding in which instances are described using XML Schema, these simple types shall be used as far as possible and practical for the representation of data types.  W3C XML Schema also provides methods for defining 
 * -	new simple types by restriction and combination of the built-in types, and 
 * -	complex types, with simple content, but which also have XML attributes.  
 * In many places where a suitable built-in simple type is not available, simple content types derived using the XML Schema mechanisms are used for the representation of data types in GML.  
 * A set of these simple content types that are required by several GML components are defined in the basicTypes schema, as well as some elements based on them. These are primarily based around components needed to record amounts, counts, flags and terms, together with support for exceptions or null values.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * This schema document provides attribute declarations and
 * attribute group, complex type and simple type definitions which can be used in
 * the construction of user schemas to define the structure of particular linking
 * constructs, e.g.
 * 
 * <xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema"
 *            xmlns:xl="http://www.w3.org/1999/xlink">
 * 
 *  <xs:import namespace="http://www.w3.org/1999/xlink"
 *             location="http://www.w3.org/1999/xlink.xsd">
 * 
 *  <xs:element name="mySimple">
 *   <xs:complexType>
 *    ...
 *    <xs:attributeGroup ref="xl:simpleAttrs"/>
 *    ...
 *   </xs:complexType>
 *  </xs:element>
 *  ...
 * </xs:schema>
 * 
 *      
 *   <div xmlns="http://www.w3.org/1999/xhtml">
 *         
 *     <h1>About the XML namespace</h1>
 *         
 *     <div class="bodytext">
 *            
 *       <p>
 *       This schema document describes the XML namespace, in a form
 *       suitable for import by other schema documents.
 *      </p>
 *            
 *       <p>
 *               See 
 *         <a href="http://www.w3.org/XML/1998/namespace.html">
 *       http://www.w3.org/XML/1998/namespace.html</a>
 *          and
 *       
 *         <a href="http://www.w3.org/TR/REC-xml">
 *       http://www.w3.org/TR/REC-xml</a>
 *          for information 
 *       about this namespace.
 *      
 *       </p>
 *            
 *       <p>
 *       Note that local names in this namespace are intended to be
 *       defined only by the World Wide Web Consortium or its subgroups.
 *       The names currently defined in this namespace are listed below.
 *       They should not be used with conflicting semantics by any Working
 *       Group, specification, or document instance.
 *      </p>
 *            
 *       <p>
 *            
 *       See further below in this document for more information about 
 *         <a href="#usage">how to refer to this schema document from your own
 *       XSD schema documents</a>
 *          and about 
 *         <a href="#nsversioning">the
 *       namespace-versioning policy governing this schema document</a>
 *         .
 *      
 *       </p>
 *           
 *     </div>
 *        
 *   </div>
 *     
 * 
 * 
 *      
 *   <div xmlns="http://www.w3.org/1999/xhtml">
 *        
 *     
 *     <h3>Father (in any context at all)</h3>
 *      
 * 
 *     
 *     <div class="bodytext">
 *            
 *       <p>
 *       denotes Jon Bosak, the chair of 
 *       the original XML Working Group.  This name is reserved by 
 *       the following decision of the W3C XML Plenary and 
 *       XML Coordination groups:
 *      </p>
 *            
 *       <blockquote>
 *                
 *         <p>
 * 	In appreciation for his vision, leadership and
 * 	dedication the W3C XML Plenary on this 10th day of
 * 	February, 2000, reserves for Jon Bosak in perpetuity
 * 	the XML name "xml:Father".
 *        </p>
 *              
 *       </blockquote>
 *           
 *     </div>
 *        
 *   </div>
 *     
 * 
 * 
 *      
 *   <div id="usage" xml:id="usage" xmlns="http://www.w3.org/1999/xhtml">
 *         
 *     <h2>
 *       <a name="usage">About this schema document</a>
 *     </h2>
 *         
 *     <div class="bodytext">
 *            
 *       <p>
 *               This schema defines attributes and an attribute group suitable
 *       for use by schemas wishing to allow 
 *         <code>xml:base</code>
 *         ,
 *       
 *         <code>xml:lang</code>
 *         , 
 *         <code>xml:space</code>
 *          or
 *       
 *         <code>xml:id</code>
 *          attributes on elements they define.
 *      
 *       </p>
 *            
 *       <p>
 *       To enable this, such a schema must import this schema for
 *       the XML namespace, e.g. as follows:
 *      </p>
 *            
 *       <pre>
 *           &lt;schema . . .&gt;
 *            . . .
 *            &lt;import namespace="http://www.w3.org/XML/1998/namespace"
 *                       schemaLocation="http://www.w3.org/2001/xml.xsd"/&gt;
 *      </pre>
 *            
 *       <p>
 *       or
 *      </p>
 *            
 *       <pre>
 *            &lt;import namespace="http://www.w3.org/XML/1998/namespace"
 *                       schemaLocation="http://www.w3.org/2009/01/xml.xsd"/&gt;
 *      </pre>
 *            
 *       <p>
 *       Subsequently, qualified reference to any of the attributes or the
 *       group defined below will have the desired effect, e.g.
 *      </p>
 *            
 *       <pre>
 *           &lt;type . . .&gt;
 *            . . .
 *            &lt;attributeGroup ref="xml:specialAttrs"/&gt;
 *      </pre>
 *            
 *       <p>
 *       will define a type which will schema-validate an instance element
 *       with any of those attributes.
 *      </p>
 *           
 *     </div>
 *        
 *   </div>
 *     
 * 
 * 
 *      
 *   <div id="nsversioning" xml:id="nsversioning" xmlns="http://www.w3.org/1999/xhtml">
 *         
 *     <h2>
 *       <a name="nsversioning">Versioning policy for this schema document</a>
 *     </h2>
 *         
 *     <div class="bodytext">
 *            
 *       <p>
 *               In keeping with the XML Schema WG's standard versioning
 *       policy, this schema document will persist at
 *       
 *         <a href="http://www.w3.org/2009/01/xml.xsd">
 *        http://www.w3.org/2009/01/xml.xsd</a>
 *         .
 *      
 *       </p>
 *            
 *       <p>
 *               At the date of issue it can also be found at
 *       
 *         <a href="http://www.w3.org/2001/xml.xsd">
 *        http://www.w3.org/2001/xml.xsd</a>
 *         .
 *      
 *       </p>
 *            
 *       <p>
 *               The schema document at that URI may however change in the future,
 *       in order to remain compatible with the latest version of XML
 *       Schema itself, or with the XML namespace itself.  In other words,
 *       if the XML Schema or XML namespaces change, the version of this
 *       document at 
 *         <a href="http://www.w3.org/2001/xml.xsd">
 *        http://www.w3.org/2001/xml.xsd 
 *       </a>
 *          
 *       will change accordingly; the version at 
 *       
 *         <a href="http://www.w3.org/2009/01/xml.xsd">
 *        http://www.w3.org/2009/01/xml.xsd 
 *       </a>
 *          
 *       will not change.
 *      
 *       </p>
 *            
 *       <p>
 *       Previous dated (and unchanging) versions of this schema 
 *       document are at:
 *      </p>
 *            
 *       <ul>
 *               
 *         <li>
 *           <a href="http://www.w3.org/2009/01/xml.xsd">
 * 	http://www.w3.org/2009/01/xml.xsd</a>
 *         </li>
 *               
 *         <li>
 *           <a href="http://www.w3.org/2007/08/xml.xsd">
 * 	http://www.w3.org/2007/08/xml.xsd</a>
 *         </li>
 *               
 *         <li>
 *           <a href="http://www.w3.org/2004/10/xml.xsd">
 * 	http://www.w3.org/2004/10/xml.xsd</a>
 *         </li>
 *               
 *         <li>
 *           <a href="http://www.w3.org/2001/03/xml.xsd">
 * 	http://www.w3.org/2001/03/xml.xsd</a>
 *         </li>
 *              
 *       </ul>
 *           
 *     </div>
 *        
 *   </div>
 *     
 * 
 * <!-- end-model-doc -->
 * @see net.opengis.gml.gml.GMLFactory
 * @model kind="package"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:gmlBase:3.2.2 appinfo='gmlBase.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:gml:3.2.2 appinfo='gml.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:dynamicFeature:3.2.2 appinfo='dynamicFeature.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:topology:3.2.2 appinfo='topology.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:coverage:3.2.2 appinfo='coverage.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:coordinateReferenceSystems:3.2.2 appinfo='coordinateReferenceSystems.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:observation:3.2.2 appinfo='observation.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:temporalReferenceSystems:3.2.2 appinfo='temporalReferenceSystems.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:deprecatedTypes:3.2.2 appinfo='deprecatedTypes.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:basicTypes:3.2.2 appinfo='basicTypes.xsd'"
 * @generated
 */
@ProviderType
@EPackage(uri = GMLPackage.eNS_URI, genModel = "/model/gml.genmodel", genModelSourceLocations = {"model/gml.genmodel","net.opengis.gml3.model/model/gml.genmodel"}, ecore="/model/gml.ecore", ecoreSourceLocations="/model/gml.ecore")
public interface GMLPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "gml";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.opengis.net/gml/3.2";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "gml";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	GMLPackage eINSTANCE = net.opengis.gml.gml.impl.GMLPackageImpl.init();

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractGMLTypeImpl <em>Abstract GML Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractGMLTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractGMLType()
	 * @generated
	 */
	int ABSTRACT_GML_TYPE = 21;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GML_TYPE__META_DATA_PROPERTY = 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GML_TYPE__DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GML_TYPE__DESCRIPTION_REFERENCE = 2;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GML_TYPE__IDENTIFIER = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GML_TYPE__NAME = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GML_TYPE__ID = 5;

	/**
	 * The number of structural features of the '<em>Abstract GML Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GML_TYPE_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>Abstract GML Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GML_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractFeatureTypeImpl <em>Abstract Feature Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractFeatureTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractFeatureType()
	 * @generated
	 */
	int ABSTRACT_FEATURE_TYPE = 10;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GML_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_TYPE__IDENTIFIER = ABSTRACT_GML_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_TYPE__ID = ABSTRACT_GML_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_TYPE__BOUNDED_BY = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Location Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_TYPE__LOCATION_GROUP = ABSTRACT_GML_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_TYPE__LOCATION = ABSTRACT_GML_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Abstract Feature Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Abstract Feature Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractCoverageTypeImpl <em>Abstract Coverage Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractCoverageTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractCoverageType()
	 * @generated
	 */
	int ABSTRACT_COVERAGE_TYPE = 3;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COVERAGE_TYPE__META_DATA_PROPERTY = ABSTRACT_FEATURE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COVERAGE_TYPE__DESCRIPTION = ABSTRACT_FEATURE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COVERAGE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_FEATURE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COVERAGE_TYPE__IDENTIFIER = ABSTRACT_FEATURE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COVERAGE_TYPE__NAME = ABSTRACT_FEATURE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COVERAGE_TYPE__ID = ABSTRACT_FEATURE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COVERAGE_TYPE__BOUNDED_BY = ABSTRACT_FEATURE_TYPE__BOUNDED_BY;

	/**
	 * The feature id for the '<em><b>Location Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COVERAGE_TYPE__LOCATION_GROUP = ABSTRACT_FEATURE_TYPE__LOCATION_GROUP;

	/**
	 * The feature id for the '<em><b>Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COVERAGE_TYPE__LOCATION = ABSTRACT_FEATURE_TYPE__LOCATION;

	/**
	 * The feature id for the '<em><b>Domain Set Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COVERAGE_TYPE__DOMAIN_SET_GROUP = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Domain Set</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COVERAGE_TYPE__DOMAIN_SET = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Range Set</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COVERAGE_TYPE__RANGE_SET = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Abstract Coverage Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COVERAGE_TYPE_FEATURE_COUNT = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Abstract Coverage Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COVERAGE_TYPE_OPERATION_COUNT = ABSTRACT_FEATURE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractContinuousCoverageTypeImpl <em>Abstract Continuous Coverage Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractContinuousCoverageTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractContinuousCoverageType()
	 * @generated
	 */
	int ABSTRACT_CONTINUOUS_COVERAGE_TYPE = 0;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__META_DATA_PROPERTY = ABSTRACT_COVERAGE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__DESCRIPTION = ABSTRACT_COVERAGE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_COVERAGE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__IDENTIFIER = ABSTRACT_COVERAGE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__NAME = ABSTRACT_COVERAGE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__ID = ABSTRACT_COVERAGE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__BOUNDED_BY = ABSTRACT_COVERAGE_TYPE__BOUNDED_BY;

	/**
	 * The feature id for the '<em><b>Location Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__LOCATION_GROUP = ABSTRACT_COVERAGE_TYPE__LOCATION_GROUP;

	/**
	 * The feature id for the '<em><b>Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__LOCATION = ABSTRACT_COVERAGE_TYPE__LOCATION;

	/**
	 * The feature id for the '<em><b>Domain Set Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__DOMAIN_SET_GROUP = ABSTRACT_COVERAGE_TYPE__DOMAIN_SET_GROUP;

	/**
	 * The feature id for the '<em><b>Domain Set</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__DOMAIN_SET = ABSTRACT_COVERAGE_TYPE__DOMAIN_SET;

	/**
	 * The feature id for the '<em><b>Range Set</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__RANGE_SET = ABSTRACT_COVERAGE_TYPE__RANGE_SET;

	/**
	 * The feature id for the '<em><b>Coverage Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CONTINUOUS_COVERAGE_TYPE__COVERAGE_FUNCTION = ABSTRACT_COVERAGE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Abstract Continuous Coverage Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CONTINUOUS_COVERAGE_TYPE_FEATURE_COUNT = ABSTRACT_COVERAGE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Abstract Continuous Coverage Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CONTINUOUS_COVERAGE_TYPE_OPERATION_COUNT = ABSTRACT_COVERAGE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DefinitionBaseTypeImpl <em>Definition Base Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DefinitionBaseTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDefinitionBaseType()
	 * @generated
	 */
	int DEFINITION_BASE_TYPE = 108;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_BASE_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_BASE_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_BASE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GML_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_BASE_TYPE__IDENTIFIER = ABSTRACT_GML_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_BASE_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_BASE_TYPE__ID = ABSTRACT_GML_TYPE__ID;

	/**
	 * The number of structural features of the '<em>Definition Base Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_BASE_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Definition Base Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_BASE_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DefinitionTypeImpl <em>Definition Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DefinitionTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDefinitionType()
	 * @generated
	 */
	int DEFINITION_TYPE = 110;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_TYPE__META_DATA_PROPERTY = DEFINITION_BASE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_TYPE__DESCRIPTION = DEFINITION_BASE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_TYPE__DESCRIPTION_REFERENCE = DEFINITION_BASE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_TYPE__IDENTIFIER = DEFINITION_BASE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_TYPE__NAME = DEFINITION_BASE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_TYPE__ID = DEFINITION_BASE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_TYPE__REMARKS = DEFINITION_BASE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Definition Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_TYPE_FEATURE_COUNT = DEFINITION_BASE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Definition Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_TYPE_OPERATION_COUNT = DEFINITION_BASE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.IdentifiedObjectTypeImpl <em>Identified Object Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.IdentifiedObjectTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getIdentifiedObjectType()
	 * @generated
	 */
	int IDENTIFIED_OBJECT_TYPE = 180;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIFIED_OBJECT_TYPE__META_DATA_PROPERTY = DEFINITION_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIFIED_OBJECT_TYPE__DESCRIPTION = DEFINITION_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIFIED_OBJECT_TYPE__DESCRIPTION_REFERENCE = DEFINITION_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIFIED_OBJECT_TYPE__IDENTIFIER = DEFINITION_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIFIED_OBJECT_TYPE__NAME = DEFINITION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIFIED_OBJECT_TYPE__ID = DEFINITION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIFIED_OBJECT_TYPE__REMARKS = DEFINITION_TYPE__REMARKS;

	/**
	 * The number of structural features of the '<em>Identified Object Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT = DEFINITION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Identified Object Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IDENTIFIED_OBJECT_TYPE_OPERATION_COUNT = DEFINITION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractCoordinateOperationTypeImpl <em>Abstract Coordinate Operation Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractCoordinateOperationTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractCoordinateOperationType()
	 * @generated
	 */
	int ABSTRACT_COORDINATE_OPERATION_TYPE = 1;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_OPERATION_TYPE__META_DATA_PROPERTY = IDENTIFIED_OBJECT_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_OPERATION_TYPE__DESCRIPTION = IDENTIFIED_OBJECT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_OPERATION_TYPE__DESCRIPTION_REFERENCE = IDENTIFIED_OBJECT_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_OPERATION_TYPE__IDENTIFIER = IDENTIFIED_OBJECT_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_OPERATION_TYPE__NAME = IDENTIFIED_OBJECT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_OPERATION_TYPE__ID = IDENTIFIED_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_OPERATION_TYPE__REMARKS = IDENTIFIED_OBJECT_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_OPERATION_TYPE__DOMAIN_OF_VALIDITY = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_OPERATION_TYPE__SCOPE = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Operation Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_OPERATION_TYPE__OPERATION_VERSION = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Coordinate Operation Accuracy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_OPERATION_TYPE__COORDINATE_OPERATION_ACCURACY = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Source CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_OPERATION_TYPE__SOURCE_CRS = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Target CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_OPERATION_TYPE__TARGET_CRS = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Abstract Coordinate Operation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>Abstract Coordinate Operation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_OPERATION_TYPE_OPERATION_COUNT = IDENTIFIED_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractCoordinateSystemTypeImpl <em>Abstract Coordinate System Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractCoordinateSystemTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractCoordinateSystemType()
	 * @generated
	 */
	int ABSTRACT_COORDINATE_SYSTEM_TYPE = 2;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_SYSTEM_TYPE__META_DATA_PROPERTY = IDENTIFIED_OBJECT_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION = IDENTIFIED_OBJECT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION_REFERENCE = IDENTIFIED_OBJECT_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_SYSTEM_TYPE__IDENTIFIER = IDENTIFIED_OBJECT_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME = IDENTIFIED_OBJECT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_SYSTEM_TYPE__ID = IDENTIFIED_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_SYSTEM_TYPE__REMARKS = IDENTIFIED_OBJECT_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Axis Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS_GROUP = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Axis</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_SYSTEM_TYPE__AGGREGATION_TYPE = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Abstract Coordinate System Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_SYSTEM_TYPE_FEATURE_COUNT = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Abstract Coordinate System Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_COORDINATE_SYSTEM_TYPE_OPERATION_COUNT = IDENTIFIED_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractCRSTypeImpl <em>Abstract CRS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractCRSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractCRSType()
	 * @generated
	 */
	int ABSTRACT_CRS_TYPE = 4;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CRS_TYPE__META_DATA_PROPERTY = IDENTIFIED_OBJECT_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CRS_TYPE__DESCRIPTION = IDENTIFIED_OBJECT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CRS_TYPE__DESCRIPTION_REFERENCE = IDENTIFIED_OBJECT_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CRS_TYPE__IDENTIFIER = IDENTIFIED_OBJECT_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CRS_TYPE__NAME = IDENTIFIED_OBJECT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CRS_TYPE__ID = IDENTIFIED_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CRS_TYPE__REMARKS = IDENTIFIED_OBJECT_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CRS_TYPE__DOMAIN_OF_VALIDITY = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CRS_TYPE__SCOPE = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Abstract CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CRS_TYPE_FEATURE_COUNT = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Abstract CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CRS_TYPE_OPERATION_COUNT = IDENTIFIED_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractCurveSegmentTypeImpl <em>Abstract Curve Segment Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractCurveSegmentTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractCurveSegmentType()
	 * @generated
	 */
	int ABSTRACT_CURVE_SEGMENT_TYPE = 5;

	/**
	 * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR = 0;

	/**
	 * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END = 1;

	/**
	 * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START = 2;

	/**
	 * The number of structural features of the '<em>Abstract Curve Segment Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Abstract Curve Segment Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractGeometryTypeImpl <em>Abstract Geometry Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractGeometryTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractGeometryType()
	 * @generated
	 */
	int ABSTRACT_GEOMETRY_TYPE = 20;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRY_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRY_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRY_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GML_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRY_TYPE__IDENTIFIER = ABSTRACT_GML_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRY_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRY_TYPE__ID = ABSTRACT_GML_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRY_TYPE__AXIS_LABELS = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRY_TYPE__SRS_DIMENSION = ABSTRACT_GML_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRY_TYPE__SRS_NAME = ABSTRACT_GML_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRY_TYPE__UOM_LABELS = ABSTRACT_GML_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Abstract Geometry Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Abstract Geometry Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRY_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractGeometricPrimitiveTypeImpl <em>Abstract Geometric Primitive Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractGeometricPrimitiveTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractGeometricPrimitiveType()
	 * @generated
	 */
	int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE = 19;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRY_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__DESCRIPTION = ABSTRACT_GEOMETRY_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GEOMETRY_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__IDENTIFIER = ABSTRACT_GEOMETRY_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__NAME = ABSTRACT_GEOMETRY_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__ID = ABSTRACT_GEOMETRY_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRY_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRY_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_NAME = ABSTRACT_GEOMETRY_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__UOM_LABELS = ABSTRACT_GEOMETRY_TYPE__UOM_LABELS;

	/**
	 * The number of structural features of the '<em>Abstract Geometric Primitive Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract Geometric Primitive Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractCurveTypeImpl <em>Abstract Curve Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractCurveTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractCurveType()
	 * @generated
	 */
	int ABSTRACT_CURVE_TYPE = 6;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CURVE_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CURVE_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CURVE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CURVE_TYPE__IDENTIFIER = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CURVE_TYPE__NAME = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CURVE_TYPE__ID = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CURVE_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CURVE_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CURVE_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CURVE_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__UOM_LABELS;

	/**
	 * The number of structural features of the '<em>Abstract Curve Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CURVE_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract Curve Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_CURVE_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractDatumTypeImpl <em>Abstract Datum Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractDatumTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractDatumType()
	 * @generated
	 */
	int ABSTRACT_DATUM_TYPE = 7;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DATUM_TYPE__META_DATA_PROPERTY = IDENTIFIED_OBJECT_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DATUM_TYPE__DESCRIPTION = IDENTIFIED_OBJECT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DATUM_TYPE__DESCRIPTION_REFERENCE = IDENTIFIED_OBJECT_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DATUM_TYPE__IDENTIFIER = IDENTIFIED_OBJECT_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DATUM_TYPE__NAME = IDENTIFIED_OBJECT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DATUM_TYPE__ID = IDENTIFIED_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DATUM_TYPE__REMARKS = IDENTIFIED_OBJECT_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DATUM_TYPE__DOMAIN_OF_VALIDITY = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DATUM_TYPE__SCOPE = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Anchor Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DATUM_TYPE__ANCHOR_DEFINITION = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Realization Epoch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DATUM_TYPE__REALIZATION_EPOCH = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Abstract Datum Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DATUM_TYPE_FEATURE_COUNT = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Abstract Datum Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DATUM_TYPE_OPERATION_COUNT = IDENTIFIED_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractFeatureCollectionTypeImpl <em>Abstract Feature Collection Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractFeatureCollectionTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractFeatureCollectionType()
	 * @generated
	 */
	int ABSTRACT_FEATURE_COLLECTION_TYPE = 8;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_COLLECTION_TYPE__META_DATA_PROPERTY = ABSTRACT_FEATURE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_COLLECTION_TYPE__DESCRIPTION = ABSTRACT_FEATURE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_COLLECTION_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_FEATURE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_COLLECTION_TYPE__IDENTIFIER = ABSTRACT_FEATURE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_COLLECTION_TYPE__NAME = ABSTRACT_FEATURE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_COLLECTION_TYPE__ID = ABSTRACT_FEATURE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_COLLECTION_TYPE__BOUNDED_BY = ABSTRACT_FEATURE_TYPE__BOUNDED_BY;

	/**
	 * The feature id for the '<em><b>Location Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_COLLECTION_TYPE__LOCATION_GROUP = ABSTRACT_FEATURE_TYPE__LOCATION_GROUP;

	/**
	 * The feature id for the '<em><b>Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_COLLECTION_TYPE__LOCATION = ABSTRACT_FEATURE_TYPE__LOCATION;

	/**
	 * The feature id for the '<em><b>Feature Member</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_COLLECTION_TYPE__FEATURE_MEMBER = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Feature Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_COLLECTION_TYPE__FEATURE_MEMBERS = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Abstract Feature Collection Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_COLLECTION_TYPE_FEATURE_COUNT = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Abstract Feature Collection Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_COLLECTION_TYPE_OPERATION_COUNT = ABSTRACT_FEATURE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractFeatureMemberTypeImpl <em>Abstract Feature Member Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractFeatureMemberTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractFeatureMemberType()
	 * @generated
	 */
	int ABSTRACT_FEATURE_MEMBER_TYPE = 9;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_MEMBER_TYPE__OWNS = 0;

	/**
	 * The number of structural features of the '<em>Abstract Feature Member Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_MEMBER_TYPE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Abstract Feature Member Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FEATURE_MEMBER_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractGeneralConversionTypeImpl <em>Abstract General Conversion Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractGeneralConversionTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractGeneralConversionType()
	 * @generated
	 */
	int ABSTRACT_GENERAL_CONVERSION_TYPE = 11;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_CONVERSION_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_OPERATION_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_CONVERSION_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_OPERATION_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_CONVERSION_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_COORDINATE_OPERATION_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_CONVERSION_TYPE__IDENTIFIER = ABSTRACT_COORDINATE_OPERATION_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_CONVERSION_TYPE__NAME = ABSTRACT_COORDINATE_OPERATION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_CONVERSION_TYPE__ID = ABSTRACT_COORDINATE_OPERATION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_CONVERSION_TYPE__REMARKS = ABSTRACT_COORDINATE_OPERATION_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_CONVERSION_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_COORDINATE_OPERATION_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_CONVERSION_TYPE__SCOPE = ABSTRACT_COORDINATE_OPERATION_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Operation Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_CONVERSION_TYPE__OPERATION_VERSION = ABSTRACT_COORDINATE_OPERATION_TYPE__OPERATION_VERSION;

	/**
	 * The feature id for the '<em><b>Coordinate Operation Accuracy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_CONVERSION_TYPE__COORDINATE_OPERATION_ACCURACY = ABSTRACT_COORDINATE_OPERATION_TYPE__COORDINATE_OPERATION_ACCURACY;

	/**
	 * The feature id for the '<em><b>Source CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_CONVERSION_TYPE__SOURCE_CRS = ABSTRACT_COORDINATE_OPERATION_TYPE__SOURCE_CRS;

	/**
	 * The feature id for the '<em><b>Target CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_CONVERSION_TYPE__TARGET_CRS = ABSTRACT_COORDINATE_OPERATION_TYPE__TARGET_CRS;

	/**
	 * The number of structural features of the '<em>Abstract General Conversion Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_CONVERSION_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract General Conversion Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_CONVERSION_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_OPERATION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractGeneralDerivedCRSTypeImpl <em>Abstract General Derived CRS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractGeneralDerivedCRSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractGeneralDerivedCRSType()
	 * @generated
	 */
	int ABSTRACT_GENERAL_DERIVED_CRS_TYPE = 12;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__META_DATA_PROPERTY = ABSTRACT_CRS_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__DESCRIPTION = ABSTRACT_CRS_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_CRS_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__IDENTIFIER = ABSTRACT_CRS_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__NAME = ABSTRACT_CRS_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__ID = ABSTRACT_CRS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__REMARKS = ABSTRACT_CRS_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_CRS_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__SCOPE = ABSTRACT_CRS_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Conversion Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__CONVERSION_GROUP = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Conversion</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_DERIVED_CRS_TYPE__CONVERSION = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Abstract General Derived CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_DERIVED_CRS_TYPE_FEATURE_COUNT = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Abstract General Derived CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_DERIVED_CRS_TYPE_OPERATION_COUNT = ABSTRACT_CRS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractGeneralOperationParameterPropertyTypeImpl <em>Abstract General Operation Parameter Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractGeneralOperationParameterPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractGeneralOperationParameterPropertyType()
	 * @generated
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_PROPERTY_TYPE = 13;

	/**
	 * The feature id for the '<em><b>Abstract General Operation Parameter Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_PROPERTY_TYPE__ABSTRACT_GENERAL_OPERATION_PARAMETER_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract General Operation Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_PROPERTY_TYPE__ABSTRACT_GENERAL_OPERATION_PARAMETER = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_PROPERTY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_PROPERTY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_PROPERTY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_PROPERTY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Abstract General Operation Parameter Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Abstract General Operation Parameter Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractGeneralOperationParameterTypeImpl <em>Abstract General Operation Parameter Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractGeneralOperationParameterTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractGeneralOperationParameterType()
	 * @generated
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE = 14;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__META_DATA_PROPERTY = IDENTIFIED_OBJECT_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__DESCRIPTION = IDENTIFIED_OBJECT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__DESCRIPTION_REFERENCE = IDENTIFIED_OBJECT_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__IDENTIFIER = IDENTIFIED_OBJECT_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__NAME = IDENTIFIED_OBJECT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__ID = IDENTIFIED_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__REMARKS = IDENTIFIED_OBJECT_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Minimum Occurs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__MINIMUM_OCCURS = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Abstract General Operation Parameter Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE_FEATURE_COUNT = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Abstract General Operation Parameter Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE_OPERATION_COUNT = IDENTIFIED_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractGeneralParameterValuePropertyTypeImpl <em>Abstract General Parameter Value Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractGeneralParameterValuePropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractGeneralParameterValuePropertyType()
	 * @generated
	 */
	int ABSTRACT_GENERAL_PARAMETER_VALUE_PROPERTY_TYPE = 15;

	/**
	 * The feature id for the '<em><b>Abstract General Parameter Value Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_PARAMETER_VALUE_PROPERTY_TYPE__ABSTRACT_GENERAL_PARAMETER_VALUE_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract General Parameter Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_PARAMETER_VALUE_PROPERTY_TYPE__ABSTRACT_GENERAL_PARAMETER_VALUE = 1;

	/**
	 * The number of structural features of the '<em>Abstract General Parameter Value Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_PARAMETER_VALUE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Abstract General Parameter Value Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_PARAMETER_VALUE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractGeneralParameterValueTypeImpl <em>Abstract General Parameter Value Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractGeneralParameterValueTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractGeneralParameterValueType()
	 * @generated
	 */
	int ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE = 16;

	/**
	 * The number of structural features of the '<em>Abstract General Parameter Value Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Abstract General Parameter Value Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractGeneralTransformationTypeImpl <em>Abstract General Transformation Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractGeneralTransformationTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractGeneralTransformationType()
	 * @generated
	 */
	int ABSTRACT_GENERAL_TRANSFORMATION_TYPE = 17;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_OPERATION_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_OPERATION_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_COORDINATE_OPERATION_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__IDENTIFIER = ABSTRACT_COORDINATE_OPERATION_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__NAME = ABSTRACT_COORDINATE_OPERATION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__ID = ABSTRACT_COORDINATE_OPERATION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__REMARKS = ABSTRACT_COORDINATE_OPERATION_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_COORDINATE_OPERATION_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__SCOPE = ABSTRACT_COORDINATE_OPERATION_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Operation Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__OPERATION_VERSION = ABSTRACT_COORDINATE_OPERATION_TYPE__OPERATION_VERSION;

	/**
	 * The feature id for the '<em><b>Coordinate Operation Accuracy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__COORDINATE_OPERATION_ACCURACY = ABSTRACT_COORDINATE_OPERATION_TYPE__COORDINATE_OPERATION_ACCURACY;

	/**
	 * The feature id for the '<em><b>Source CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__SOURCE_CRS = ABSTRACT_COORDINATE_OPERATION_TYPE__SOURCE_CRS;

	/**
	 * The feature id for the '<em><b>Target CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_TRANSFORMATION_TYPE__TARGET_CRS = ABSTRACT_COORDINATE_OPERATION_TYPE__TARGET_CRS;

	/**
	 * The number of structural features of the '<em>Abstract General Transformation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_TRANSFORMATION_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract General Transformation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GENERAL_TRANSFORMATION_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_OPERATION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractGeometricAggregateTypeImpl <em>Abstract Geometric Aggregate Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractGeometricAggregateTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractGeometricAggregateType()
	 * @generated
	 */
	int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE = 18;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRY_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION = ABSTRACT_GEOMETRY_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GEOMETRY_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__IDENTIFIER = ABSTRACT_GEOMETRY_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME = ABSTRACT_GEOMETRY_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__ID = ABSTRACT_GEOMETRY_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRY_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRY_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_NAME = ABSTRACT_GEOMETRY_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__UOM_LABELS = ABSTRACT_GEOMETRY_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AGGREGATION_TYPE = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Abstract Geometric Aggregate Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Abstract Geometric Aggregate Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractSurfacePatchTypeImpl <em>Abstract Surface Patch Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractSurfacePatchTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractSurfacePatchType()
	 * @generated
	 */
	int ABSTRACT_SURFACE_PATCH_TYPE = 30;

	/**
	 * The number of structural features of the '<em>Abstract Surface Patch Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SURFACE_PATCH_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Abstract Surface Patch Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SURFACE_PATCH_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractParametricCurveSurfaceTypeImpl <em>Abstract Parametric Curve Surface Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractParametricCurveSurfaceTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractParametricCurveSurfaceType()
	 * @generated
	 */
	int ABSTRACT_PARAMETRIC_CURVE_SURFACE_TYPE = 26;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PARAMETRIC_CURVE_SURFACE_TYPE__AGGREGATION_TYPE = ABSTRACT_SURFACE_PATCH_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Abstract Parametric Curve Surface Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PARAMETRIC_CURVE_SURFACE_TYPE_FEATURE_COUNT = ABSTRACT_SURFACE_PATCH_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Abstract Parametric Curve Surface Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_PARAMETRIC_CURVE_SURFACE_TYPE_OPERATION_COUNT = ABSTRACT_SURFACE_PATCH_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractGriddedSurfaceTypeImpl <em>Abstract Gridded Surface Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractGriddedSurfaceTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractGriddedSurfaceType()
	 * @generated
	 */
	int ABSTRACT_GRIDDED_SURFACE_TYPE = 22;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GRIDDED_SURFACE_TYPE__AGGREGATION_TYPE = ABSTRACT_PARAMETRIC_CURVE_SURFACE_TYPE__AGGREGATION_TYPE;

	/**
	 * The feature id for the '<em><b>Rows</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GRIDDED_SURFACE_TYPE__ROWS = ABSTRACT_PARAMETRIC_CURVE_SURFACE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Columns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GRIDDED_SURFACE_TYPE__COLUMNS = ABSTRACT_PARAMETRIC_CURVE_SURFACE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Rows1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GRIDDED_SURFACE_TYPE__ROWS1 = ABSTRACT_PARAMETRIC_CURVE_SURFACE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Abstract Gridded Surface Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GRIDDED_SURFACE_TYPE_FEATURE_COUNT = ABSTRACT_PARAMETRIC_CURVE_SURFACE_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Abstract Gridded Surface Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GRIDDED_SURFACE_TYPE_OPERATION_COUNT = ABSTRACT_PARAMETRIC_CURVE_SURFACE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractMemberTypeImpl <em>Abstract Member Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractMemberTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractMemberType()
	 * @generated
	 */
	int ABSTRACT_MEMBER_TYPE = 23;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMBER_TYPE__OWNS = 0;

	/**
	 * The number of structural features of the '<em>Abstract Member Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMBER_TYPE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Abstract Member Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MEMBER_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractMetadataPropertyTypeImpl <em>Abstract Metadata Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractMetadataPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractMetadataPropertyType()
	 * @generated
	 */
	int ABSTRACT_METADATA_PROPERTY_TYPE = 24;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_METADATA_PROPERTY_TYPE__OWNS = 0;

	/**
	 * The number of structural features of the '<em>Abstract Metadata Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_METADATA_PROPERTY_TYPE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Abstract Metadata Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_METADATA_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractMetaDataTypeImpl <em>Abstract Meta Data Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractMetaDataTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractMetaDataType()
	 * @generated
	 */
	int ABSTRACT_META_DATA_TYPE = 25;

	/**
	 * The feature id for the '<em><b>Mixed</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_META_DATA_TYPE__MIXED = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_META_DATA_TYPE__ID = 1;

	/**
	 * The number of structural features of the '<em>Abstract Meta Data Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_META_DATA_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Abstract Meta Data Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_META_DATA_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractRingPropertyTypeImpl <em>Abstract Ring Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractRingPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractRingPropertyType()
	 * @generated
	 */
	int ABSTRACT_RING_PROPERTY_TYPE = 27;

	/**
	 * The feature id for the '<em><b>Abstract Ring Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RING_PROPERTY_TYPE__ABSTRACT_RING_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Ring</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RING_PROPERTY_TYPE__ABSTRACT_RING = 1;

	/**
	 * The number of structural features of the '<em>Abstract Ring Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RING_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Abstract Ring Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RING_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractRingTypeImpl <em>Abstract Ring Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractRingTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractRingType()
	 * @generated
	 */
	int ABSTRACT_RING_TYPE = 28;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RING_TYPE__META_DATA_PROPERTY = ABSTRACT_CURVE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RING_TYPE__DESCRIPTION = ABSTRACT_CURVE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RING_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_CURVE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RING_TYPE__IDENTIFIER = ABSTRACT_CURVE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RING_TYPE__NAME = ABSTRACT_CURVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RING_TYPE__ID = ABSTRACT_CURVE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RING_TYPE__AXIS_LABELS = ABSTRACT_CURVE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RING_TYPE__SRS_DIMENSION = ABSTRACT_CURVE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RING_TYPE__SRS_NAME = ABSTRACT_CURVE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RING_TYPE__UOM_LABELS = ABSTRACT_CURVE_TYPE__UOM_LABELS;

	/**
	 * The number of structural features of the '<em>Abstract Ring Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RING_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract Ring Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RING_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractSolidTypeImpl <em>Abstract Solid Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractSolidTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractSolidType()
	 * @generated
	 */
	int ABSTRACT_SOLID_TYPE = 29;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SOLID_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SOLID_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SOLID_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SOLID_TYPE__IDENTIFIER = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SOLID_TYPE__NAME = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SOLID_TYPE__ID = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SOLID_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SOLID_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SOLID_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SOLID_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__UOM_LABELS;

	/**
	 * The number of structural features of the '<em>Abstract Solid Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SOLID_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract Solid Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SOLID_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractSurfaceTypeImpl <em>Abstract Surface Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractSurfaceTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractSurfaceType()
	 * @generated
	 */
	int ABSTRACT_SURFACE_TYPE = 31;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SURFACE_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SURFACE_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SURFACE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SURFACE_TYPE__IDENTIFIER = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SURFACE_TYPE__NAME = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SURFACE_TYPE__ID = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SURFACE_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SURFACE_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SURFACE_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SURFACE_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__UOM_LABELS;

	/**
	 * The number of structural features of the '<em>Abstract Surface Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SURFACE_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract Surface Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_SURFACE_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractTimeObjectTypeImpl <em>Abstract Time Object Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractTimeObjectTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractTimeObjectType()
	 * @generated
	 */
	int ABSTRACT_TIME_OBJECT_TYPE = 34;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_OBJECT_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_OBJECT_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_OBJECT_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GML_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_OBJECT_TYPE__IDENTIFIER = ABSTRACT_GML_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_OBJECT_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_OBJECT_TYPE__ID = ABSTRACT_GML_TYPE__ID;

	/**
	 * The number of structural features of the '<em>Abstract Time Object Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_OBJECT_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract Time Object Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_OBJECT_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractTimeComplexTypeImpl <em>Abstract Time Complex Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractTimeComplexTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractTimeComplexType()
	 * @generated
	 */
	int ABSTRACT_TIME_COMPLEX_TYPE = 32;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_COMPLEX_TYPE__META_DATA_PROPERTY = ABSTRACT_TIME_OBJECT_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_COMPLEX_TYPE__DESCRIPTION = ABSTRACT_TIME_OBJECT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_COMPLEX_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_TIME_OBJECT_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_COMPLEX_TYPE__IDENTIFIER = ABSTRACT_TIME_OBJECT_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_COMPLEX_TYPE__NAME = ABSTRACT_TIME_OBJECT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_COMPLEX_TYPE__ID = ABSTRACT_TIME_OBJECT_TYPE__ID;

	/**
	 * The number of structural features of the '<em>Abstract Time Complex Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_COMPLEX_TYPE_FEATURE_COUNT = ABSTRACT_TIME_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract Time Complex Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_COMPLEX_TYPE_OPERATION_COUNT = ABSTRACT_TIME_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractTimePrimitiveTypeImpl <em>Abstract Time Primitive Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractTimePrimitiveTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractTimePrimitiveType()
	 * @generated
	 */
	int ABSTRACT_TIME_PRIMITIVE_TYPE = 35;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_PRIMITIVE_TYPE__META_DATA_PROPERTY = ABSTRACT_TIME_OBJECT_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_PRIMITIVE_TYPE__DESCRIPTION = ABSTRACT_TIME_OBJECT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_PRIMITIVE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_TIME_OBJECT_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_PRIMITIVE_TYPE__IDENTIFIER = ABSTRACT_TIME_OBJECT_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_PRIMITIVE_TYPE__NAME = ABSTRACT_TIME_OBJECT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_PRIMITIVE_TYPE__ID = ABSTRACT_TIME_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Related Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_PRIMITIVE_TYPE__RELATED_TIME = ABSTRACT_TIME_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Abstract Time Primitive Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_PRIMITIVE_TYPE_FEATURE_COUNT = ABSTRACT_TIME_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Abstract Time Primitive Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_PRIMITIVE_TYPE_OPERATION_COUNT = ABSTRACT_TIME_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractTimeGeometricPrimitiveTypeImpl <em>Abstract Time Geometric Primitive Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractTimeGeometricPrimitiveTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractTimeGeometricPrimitiveType()
	 * @generated
	 */
	int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE = 33;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE__META_DATA_PROPERTY = ABSTRACT_TIME_PRIMITIVE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE__DESCRIPTION = ABSTRACT_TIME_PRIMITIVE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_TIME_PRIMITIVE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE__IDENTIFIER = ABSTRACT_TIME_PRIMITIVE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE__NAME = ABSTRACT_TIME_PRIMITIVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE__ID = ABSTRACT_TIME_PRIMITIVE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Related Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE__RELATED_TIME = ABSTRACT_TIME_PRIMITIVE_TYPE__RELATED_TIME;

	/**
	 * The feature id for the '<em><b>Frame</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE__FRAME = ABSTRACT_TIME_PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Abstract Time Geometric Primitive Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE_FEATURE_COUNT = ABSTRACT_TIME_PRIMITIVE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Abstract Time Geometric Primitive Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_GEOMETRIC_PRIMITIVE_TYPE_OPERATION_COUNT = ABSTRACT_TIME_PRIMITIVE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractTimeSliceTypeImpl <em>Abstract Time Slice Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractTimeSliceTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractTimeSliceType()
	 * @generated
	 */
	int ABSTRACT_TIME_SLICE_TYPE = 36;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_SLICE_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_SLICE_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_SLICE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GML_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_SLICE_TYPE__IDENTIFIER = ABSTRACT_GML_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_SLICE_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_SLICE_TYPE__ID = ABSTRACT_GML_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Valid Time</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_SLICE_TYPE__VALID_TIME = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Data Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_SLICE_TYPE__DATA_SOURCE = ABSTRACT_GML_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Abstract Time Slice Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Abstract Time Slice Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_SLICE_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractTimeTopologyPrimitiveTypeImpl <em>Abstract Time Topology Primitive Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractTimeTopologyPrimitiveTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractTimeTopologyPrimitiveType()
	 * @generated
	 */
	int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE = 37;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE__META_DATA_PROPERTY = ABSTRACT_TIME_PRIMITIVE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE__DESCRIPTION = ABSTRACT_TIME_PRIMITIVE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_TIME_PRIMITIVE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE__IDENTIFIER = ABSTRACT_TIME_PRIMITIVE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE__NAME = ABSTRACT_TIME_PRIMITIVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE__ID = ABSTRACT_TIME_PRIMITIVE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Related Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE__RELATED_TIME = ABSTRACT_TIME_PRIMITIVE_TYPE__RELATED_TIME;

	/**
	 * The feature id for the '<em><b>Complex</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE__COMPLEX = ABSTRACT_TIME_PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Abstract Time Topology Primitive Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE_FEATURE_COUNT = ABSTRACT_TIME_PRIMITIVE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Abstract Time Topology Primitive Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TIME_TOPOLOGY_PRIMITIVE_TYPE_OPERATION_COUNT = ABSTRACT_TIME_PRIMITIVE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractTopologyTypeImpl <em>Abstract Topology Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractTopologyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractTopologyType()
	 * @generated
	 */
	int ABSTRACT_TOPOLOGY_TYPE = 38;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TOPOLOGY_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TOPOLOGY_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TOPOLOGY_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GML_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TOPOLOGY_TYPE__IDENTIFIER = ABSTRACT_GML_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TOPOLOGY_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TOPOLOGY_TYPE__ID = ABSTRACT_GML_TYPE__ID;

	/**
	 * The number of structural features of the '<em>Abstract Topology Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TOPOLOGY_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract Topology Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TOPOLOGY_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AbstractTopoPrimitiveTypeImpl <em>Abstract Topo Primitive Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AbstractTopoPrimitiveTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAbstractTopoPrimitiveType()
	 * @generated
	 */
	int ABSTRACT_TOPO_PRIMITIVE_TYPE = 39;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TOPO_PRIMITIVE_TYPE__META_DATA_PROPERTY = ABSTRACT_TOPOLOGY_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TOPO_PRIMITIVE_TYPE__DESCRIPTION = ABSTRACT_TOPOLOGY_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TOPO_PRIMITIVE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_TOPOLOGY_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TOPO_PRIMITIVE_TYPE__IDENTIFIER = ABSTRACT_TOPOLOGY_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TOPO_PRIMITIVE_TYPE__NAME = ABSTRACT_TOPOLOGY_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TOPO_PRIMITIVE_TYPE__ID = ABSTRACT_TOPOLOGY_TYPE__ID;

	/**
	 * The number of structural features of the '<em>Abstract Topo Primitive Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT = ABSTRACT_TOPOLOGY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract Topo Primitive Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TOPO_PRIMITIVE_TYPE_OPERATION_COUNT = ABSTRACT_TOPOLOGY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AffineCSPropertyTypeImpl <em>Affine CS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AffineCSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAffineCSPropertyType()
	 * @generated
	 */
	int AFFINE_CS_PROPERTY_TYPE = 40;

	/**
	 * The feature id for the '<em><b>Affine CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_PROPERTY_TYPE__AFFINE_CS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Affine CS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Affine CS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AffineCSTypeImpl <em>Affine CS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AffineCSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAffineCSType()
	 * @generated
	 */
	int AFFINE_CS_TYPE = 41;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_SYSTEM_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_TYPE__IDENTIFIER = ABSTRACT_COORDINATE_SYSTEM_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_TYPE__NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_TYPE__ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_TYPE__REMARKS = ABSTRACT_COORDINATE_SYSTEM_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Axis Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_TYPE__AXIS_GROUP = ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS_GROUP;

	/**
	 * The feature id for the '<em><b>Axis</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_TYPE__AXIS = ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_TYPE__AGGREGATION_TYPE = ABSTRACT_COORDINATE_SYSTEM_TYPE__AGGREGATION_TYPE;

	/**
	 * The number of structural features of the '<em>Affine CS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Affine CS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_CS_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AffinePlacementTypeImpl <em>Affine Placement Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AffinePlacementTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAffinePlacementType()
	 * @generated
	 */
	int AFFINE_PLACEMENT_TYPE = 42;

	/**
	 * The feature id for the '<em><b>Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_PLACEMENT_TYPE__LOCATION = 0;

	/**
	 * The feature id for the '<em><b>Ref Direction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_PLACEMENT_TYPE__REF_DIRECTION = 1;

	/**
	 * The feature id for the '<em><b>In Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_PLACEMENT_TYPE__IN_DIMENSION = 2;

	/**
	 * The feature id for the '<em><b>Out Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_PLACEMENT_TYPE__OUT_DIMENSION = 3;

	/**
	 * The number of structural features of the '<em>Affine Placement Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_PLACEMENT_TYPE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Affine Placement Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AFFINE_PLACEMENT_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AngleChoiceTypeImpl <em>Angle Choice Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AngleChoiceTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAngleChoiceType()
	 * @generated
	 */
	int ANGLE_CHOICE_TYPE = 43;

	/**
	 * The feature id for the '<em><b>Angle</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANGLE_CHOICE_TYPE__ANGLE = 0;

	/**
	 * The feature id for the '<em><b>Dms Angle</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANGLE_CHOICE_TYPE__DMS_ANGLE = 1;

	/**
	 * The number of structural features of the '<em>Angle Choice Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANGLE_CHOICE_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Angle Choice Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANGLE_CHOICE_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.MeasureTypeImpl <em>Measure Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.MeasureTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getMeasureType()
	 * @generated
	 */
	int MEASURE_TYPE = 201;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASURE_TYPE__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Uom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASURE_TYPE__UOM = 1;

	/**
	 * The number of structural features of the '<em>Measure Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASURE_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Measure Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASURE_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AngleTypeImpl <em>Angle Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AngleTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAngleType()
	 * @generated
	 */
	int ANGLE_TYPE = 44;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANGLE_TYPE__VALUE = MEASURE_TYPE__VALUE;

	/**
	 * The feature id for the '<em><b>Uom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANGLE_TYPE__UOM = MEASURE_TYPE__UOM;

	/**
	 * The number of structural features of the '<em>Angle Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANGLE_TYPE_FEATURE_COUNT = MEASURE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Angle Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANGLE_TYPE_OPERATION_COUNT = MEASURE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ArcStringByBulgeTypeImpl <em>Arc String By Bulge Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ArcStringByBulgeTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getArcStringByBulgeType()
	 * @generated
	 */
	int ARC_STRING_BY_BULGE_TYPE = 47;

	/**
	 * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_BY_BULGE_TYPE__NUM_DERIVATIVE_INTERIOR = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR;

	/**
	 * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_BY_BULGE_TYPE__NUM_DERIVATIVES_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END;

	/**
	 * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_BY_BULGE_TYPE__NUM_DERIVATIVES_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_BY_BULGE_TYPE__GROUP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_BY_BULGE_TYPE__POS = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_BY_BULGE_TYPE__POINT_PROPERTY = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_BY_BULGE_TYPE__POINT_REP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Pos List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_BY_BULGE_TYPE__POS_LIST = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_BY_BULGE_TYPE__COORDINATES = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Bulge</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_BY_BULGE_TYPE__BULGE = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Normal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_BY_BULGE_TYPE__NORMAL = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_BY_BULGE_TYPE__INTERPOLATION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Num Arc</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_BY_BULGE_TYPE__NUM_ARC = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>Arc String By Bulge Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_BY_BULGE_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of operations of the '<em>Arc String By Bulge Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_BY_BULGE_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ArcByBulgeTypeImpl <em>Arc By Bulge Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ArcByBulgeTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getArcByBulgeType()
	 * @generated
	 */
	int ARC_BY_BULGE_TYPE = 45;

	/**
	 * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_BULGE_TYPE__NUM_DERIVATIVE_INTERIOR = ARC_STRING_BY_BULGE_TYPE__NUM_DERIVATIVE_INTERIOR;

	/**
	 * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_BULGE_TYPE__NUM_DERIVATIVES_AT_END = ARC_STRING_BY_BULGE_TYPE__NUM_DERIVATIVES_AT_END;

	/**
	 * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_BULGE_TYPE__NUM_DERIVATIVES_AT_START = ARC_STRING_BY_BULGE_TYPE__NUM_DERIVATIVES_AT_START;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_BULGE_TYPE__GROUP = ARC_STRING_BY_BULGE_TYPE__GROUP;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_BULGE_TYPE__POS = ARC_STRING_BY_BULGE_TYPE__POS;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_BULGE_TYPE__POINT_PROPERTY = ARC_STRING_BY_BULGE_TYPE__POINT_PROPERTY;

	/**
	 * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_BULGE_TYPE__POINT_REP = ARC_STRING_BY_BULGE_TYPE__POINT_REP;

	/**
	 * The feature id for the '<em><b>Pos List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_BULGE_TYPE__POS_LIST = ARC_STRING_BY_BULGE_TYPE__POS_LIST;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_BULGE_TYPE__COORDINATES = ARC_STRING_BY_BULGE_TYPE__COORDINATES;

	/**
	 * The feature id for the '<em><b>Bulge</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_BULGE_TYPE__BULGE = ARC_STRING_BY_BULGE_TYPE__BULGE;

	/**
	 * The feature id for the '<em><b>Normal</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_BULGE_TYPE__NORMAL = ARC_STRING_BY_BULGE_TYPE__NORMAL;

	/**
	 * The feature id for the '<em><b>Interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_BULGE_TYPE__INTERPOLATION = ARC_STRING_BY_BULGE_TYPE__INTERPOLATION;

	/**
	 * The feature id for the '<em><b>Num Arc</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_BULGE_TYPE__NUM_ARC = ARC_STRING_BY_BULGE_TYPE__NUM_ARC;

	/**
	 * The number of structural features of the '<em>Arc By Bulge Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_BULGE_TYPE_FEATURE_COUNT = ARC_STRING_BY_BULGE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Arc By Bulge Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_BULGE_TYPE_OPERATION_COUNT = ARC_STRING_BY_BULGE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ArcByCenterPointTypeImpl <em>Arc By Center Point Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ArcByCenterPointTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getArcByCenterPointType()
	 * @generated
	 */
	int ARC_BY_CENTER_POINT_TYPE = 46;

	/**
	 * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_CENTER_POINT_TYPE__NUM_DERIVATIVE_INTERIOR = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR;

	/**
	 * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_CENTER_POINT_TYPE__NUM_DERIVATIVES_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END;

	/**
	 * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_CENTER_POINT_TYPE__NUM_DERIVATIVES_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_CENTER_POINT_TYPE__POS = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_CENTER_POINT_TYPE__POINT_PROPERTY = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Point Rep</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_CENTER_POINT_TYPE__POINT_REP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Pos List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_CENTER_POINT_TYPE__POS_LIST = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_CENTER_POINT_TYPE__COORDINATES = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Radius</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_CENTER_POINT_TYPE__RADIUS = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Start Angle</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_CENTER_POINT_TYPE__START_ANGLE = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>End Angle</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_CENTER_POINT_TYPE__END_ANGLE = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_CENTER_POINT_TYPE__INTERPOLATION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Num Arc</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_CENTER_POINT_TYPE__NUM_ARC = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>Arc By Center Point Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_CENTER_POINT_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of operations of the '<em>Arc By Center Point Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_BY_CENTER_POINT_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ArcStringTypeImpl <em>Arc String Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ArcStringTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getArcStringType()
	 * @generated
	 */
	int ARC_STRING_TYPE = 48;

	/**
	 * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_TYPE__NUM_DERIVATIVE_INTERIOR = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR;

	/**
	 * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_TYPE__NUM_DERIVATIVES_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END;

	/**
	 * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_TYPE__NUM_DERIVATIVES_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_TYPE__GROUP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_TYPE__POS = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_TYPE__POINT_PROPERTY = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_TYPE__POINT_REP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Pos List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_TYPE__POS_LIST = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_TYPE__COORDINATES = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_TYPE__INTERPOLATION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Num Arc</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_TYPE__NUM_ARC = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Arc String Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>Arc String Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_STRING_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ArcTypeImpl <em>Arc Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ArcTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getArcType()
	 * @generated
	 */
	int ARC_TYPE = 49;

	/**
	 * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_TYPE__NUM_DERIVATIVE_INTERIOR = ARC_STRING_TYPE__NUM_DERIVATIVE_INTERIOR;

	/**
	 * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_TYPE__NUM_DERIVATIVES_AT_END = ARC_STRING_TYPE__NUM_DERIVATIVES_AT_END;

	/**
	 * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_TYPE__NUM_DERIVATIVES_AT_START = ARC_STRING_TYPE__NUM_DERIVATIVES_AT_START;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_TYPE__GROUP = ARC_STRING_TYPE__GROUP;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_TYPE__POS = ARC_STRING_TYPE__POS;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_TYPE__POINT_PROPERTY = ARC_STRING_TYPE__POINT_PROPERTY;

	/**
	 * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_TYPE__POINT_REP = ARC_STRING_TYPE__POINT_REP;

	/**
	 * The feature id for the '<em><b>Pos List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_TYPE__POS_LIST = ARC_STRING_TYPE__POS_LIST;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_TYPE__COORDINATES = ARC_STRING_TYPE__COORDINATES;

	/**
	 * The feature id for the '<em><b>Interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_TYPE__INTERPOLATION = ARC_STRING_TYPE__INTERPOLATION;

	/**
	 * The feature id for the '<em><b>Num Arc</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_TYPE__NUM_ARC = ARC_STRING_TYPE__NUM_ARC;

	/**
	 * The number of structural features of the '<em>Arc Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_TYPE_FEATURE_COUNT = ARC_STRING_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Arc Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARC_TYPE_OPERATION_COUNT = ARC_STRING_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AreaTypeImpl <em>Area Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AreaTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAreaType()
	 * @generated
	 */
	int AREA_TYPE = 50;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AREA_TYPE__VALUE = MEASURE_TYPE__VALUE;

	/**
	 * The feature id for the '<em><b>Uom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AREA_TYPE__UOM = MEASURE_TYPE__UOM;

	/**
	 * The number of structural features of the '<em>Area Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AREA_TYPE_FEATURE_COUNT = MEASURE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Area Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AREA_TYPE_OPERATION_COUNT = MEASURE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ArrayAssociationTypeImpl <em>Array Association Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ArrayAssociationTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getArrayAssociationType()
	 * @generated
	 */
	int ARRAY_ASSOCIATION_TYPE = 51;

	/**
	 * The feature id for the '<em><b>Abstract Object Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_ASSOCIATION_TYPE__ABSTRACT_OBJECT_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Object</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_ASSOCIATION_TYPE__ABSTRACT_OBJECT = 1;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_ASSOCIATION_TYPE__OWNS = 2;

	/**
	 * The number of structural features of the '<em>Array Association Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_ASSOCIATION_TYPE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Array Association Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_ASSOCIATION_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ArrayTypeImpl <em>Array Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ArrayTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getArrayType()
	 * @generated
	 */
	int ARRAY_TYPE = 52;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GML_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_TYPE__IDENTIFIER = ABSTRACT_GML_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_TYPE__ID = ABSTRACT_GML_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_TYPE__MEMBERS = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Array Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Array Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ARRAY_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.AssociationRoleTypeImpl <em>Association Role Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.AssociationRoleTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getAssociationRoleType()
	 * @generated
	 */
	int ASSOCIATION_ROLE_TYPE = 53;

	/**
	 * The feature id for the '<em><b>Any</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_ROLE_TYPE__ANY = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_ROLE_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_ROLE_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_ROLE_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_ROLE_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_ROLE_TYPE__OWNS = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_ROLE_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_ROLE_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_ROLE_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_ROLE_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_ROLE_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Association Role Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_ROLE_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Association Role Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_ROLE_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.BagTypeImpl <em>Bag Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.BagTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getBagType()
	 * @generated
	 */
	int BAG_TYPE = 54;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BAG_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BAG_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BAG_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GML_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BAG_TYPE__IDENTIFIER = ABSTRACT_GML_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BAG_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BAG_TYPE__ID = ABSTRACT_GML_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Member</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BAG_TYPE__MEMBER = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BAG_TYPE__MEMBERS = ABSTRACT_GML_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Bag Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BAG_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Bag Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BAG_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.UnitDefinitionTypeImpl <em>Unit Definition Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.UnitDefinitionTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getUnitDefinitionType()
	 * @generated
	 */
	int UNIT_DEFINITION_TYPE = 337;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIT_DEFINITION_TYPE__META_DATA_PROPERTY = DEFINITION_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIT_DEFINITION_TYPE__DESCRIPTION = DEFINITION_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIT_DEFINITION_TYPE__DESCRIPTION_REFERENCE = DEFINITION_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIT_DEFINITION_TYPE__IDENTIFIER = DEFINITION_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIT_DEFINITION_TYPE__NAME = DEFINITION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIT_DEFINITION_TYPE__ID = DEFINITION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIT_DEFINITION_TYPE__REMARKS = DEFINITION_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Quantity Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIT_DEFINITION_TYPE__QUANTITY_TYPE = DEFINITION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Quantity Type Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIT_DEFINITION_TYPE__QUANTITY_TYPE_REFERENCE = DEFINITION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Catalog Symbol</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIT_DEFINITION_TYPE__CATALOG_SYMBOL = DEFINITION_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Unit Definition Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIT_DEFINITION_TYPE_FEATURE_COUNT = DEFINITION_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Unit Definition Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIT_DEFINITION_TYPE_OPERATION_COUNT = DEFINITION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.BaseUnitTypeImpl <em>Base Unit Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.BaseUnitTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getBaseUnitType()
	 * @generated
	 */
	int BASE_UNIT_TYPE = 55;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_UNIT_TYPE__META_DATA_PROPERTY = UNIT_DEFINITION_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_UNIT_TYPE__DESCRIPTION = UNIT_DEFINITION_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_UNIT_TYPE__DESCRIPTION_REFERENCE = UNIT_DEFINITION_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_UNIT_TYPE__IDENTIFIER = UNIT_DEFINITION_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_UNIT_TYPE__NAME = UNIT_DEFINITION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_UNIT_TYPE__ID = UNIT_DEFINITION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_UNIT_TYPE__REMARKS = UNIT_DEFINITION_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Quantity Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_UNIT_TYPE__QUANTITY_TYPE = UNIT_DEFINITION_TYPE__QUANTITY_TYPE;

	/**
	 * The feature id for the '<em><b>Quantity Type Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_UNIT_TYPE__QUANTITY_TYPE_REFERENCE = UNIT_DEFINITION_TYPE__QUANTITY_TYPE_REFERENCE;

	/**
	 * The feature id for the '<em><b>Catalog Symbol</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_UNIT_TYPE__CATALOG_SYMBOL = UNIT_DEFINITION_TYPE__CATALOG_SYMBOL;

	/**
	 * The feature id for the '<em><b>Units System</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_UNIT_TYPE__UNITS_SYSTEM = UNIT_DEFINITION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Base Unit Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_UNIT_TYPE_FEATURE_COUNT = UNIT_DEFINITION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Base Unit Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE_UNIT_TYPE_OPERATION_COUNT = UNIT_DEFINITION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.BSplineTypeImpl <em>BSpline Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.BSplineTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getBSplineType()
	 * @generated
	 */
	int BSPLINE_TYPE = 61;

	/**
	 * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BSPLINE_TYPE__NUM_DERIVATIVE_INTERIOR = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR;

	/**
	 * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BSPLINE_TYPE__NUM_DERIVATIVES_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END;

	/**
	 * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BSPLINE_TYPE__NUM_DERIVATIVES_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BSPLINE_TYPE__GROUP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BSPLINE_TYPE__POS = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BSPLINE_TYPE__POINT_PROPERTY = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BSPLINE_TYPE__POINT_REP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Pos List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BSPLINE_TYPE__POS_LIST = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BSPLINE_TYPE__COORDINATES = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Degree</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BSPLINE_TYPE__DEGREE = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Knot</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BSPLINE_TYPE__KNOT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BSPLINE_TYPE__INTERPOLATION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Is Polynomial</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BSPLINE_TYPE__IS_POLYNOMIAL = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Knot Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BSPLINE_TYPE__KNOT_TYPE = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of structural features of the '<em>BSpline Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BSPLINE_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 11;

	/**
	 * The number of operations of the '<em>BSpline Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BSPLINE_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.BezierTypeImpl <em>Bezier Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.BezierTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getBezierType()
	 * @generated
	 */
	int BEZIER_TYPE = 56;

	/**
	 * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEZIER_TYPE__NUM_DERIVATIVE_INTERIOR = BSPLINE_TYPE__NUM_DERIVATIVE_INTERIOR;

	/**
	 * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEZIER_TYPE__NUM_DERIVATIVES_AT_END = BSPLINE_TYPE__NUM_DERIVATIVES_AT_END;

	/**
	 * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEZIER_TYPE__NUM_DERIVATIVES_AT_START = BSPLINE_TYPE__NUM_DERIVATIVES_AT_START;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEZIER_TYPE__GROUP = BSPLINE_TYPE__GROUP;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEZIER_TYPE__POS = BSPLINE_TYPE__POS;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEZIER_TYPE__POINT_PROPERTY = BSPLINE_TYPE__POINT_PROPERTY;

	/**
	 * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEZIER_TYPE__POINT_REP = BSPLINE_TYPE__POINT_REP;

	/**
	 * The feature id for the '<em><b>Pos List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEZIER_TYPE__POS_LIST = BSPLINE_TYPE__POS_LIST;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEZIER_TYPE__COORDINATES = BSPLINE_TYPE__COORDINATES;

	/**
	 * The feature id for the '<em><b>Degree</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEZIER_TYPE__DEGREE = BSPLINE_TYPE__DEGREE;

	/**
	 * The feature id for the '<em><b>Knot</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEZIER_TYPE__KNOT = BSPLINE_TYPE__KNOT;

	/**
	 * The feature id for the '<em><b>Interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEZIER_TYPE__INTERPOLATION = BSPLINE_TYPE__INTERPOLATION;

	/**
	 * The feature id for the '<em><b>Is Polynomial</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEZIER_TYPE__IS_POLYNOMIAL = BSPLINE_TYPE__IS_POLYNOMIAL;

	/**
	 * The feature id for the '<em><b>Knot Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEZIER_TYPE__KNOT_TYPE = BSPLINE_TYPE__KNOT_TYPE;

	/**
	 * The number of structural features of the '<em>Bezier Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEZIER_TYPE_FEATURE_COUNT = BSPLINE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Bezier Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEZIER_TYPE_OPERATION_COUNT = BSPLINE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.BooleanPropertyTypeImpl <em>Boolean Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.BooleanPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getBooleanPropertyType()
	 * @generated
	 */
	int BOOLEAN_PROPERTY_TYPE = 57;

	/**
	 * The feature id for the '<em><b>Boolean</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_PROPERTY_TYPE__BOOLEAN = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Boolean Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Boolean Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.BooleanTypeImpl <em>Boolean Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.BooleanTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getBooleanType()
	 * @generated
	 */
	int BOOLEAN_TYPE = 58;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_TYPE__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>Boolean Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Boolean Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.BoundedFeatureTypeImpl <em>Bounded Feature Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.BoundedFeatureTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getBoundedFeatureType()
	 * @generated
	 */
	int BOUNDED_FEATURE_TYPE = 59;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_FEATURE_TYPE__META_DATA_PROPERTY = ABSTRACT_FEATURE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_FEATURE_TYPE__DESCRIPTION = ABSTRACT_FEATURE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_FEATURE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_FEATURE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_FEATURE_TYPE__IDENTIFIER = ABSTRACT_FEATURE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_FEATURE_TYPE__NAME = ABSTRACT_FEATURE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_FEATURE_TYPE__ID = ABSTRACT_FEATURE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_FEATURE_TYPE__BOUNDED_BY = ABSTRACT_FEATURE_TYPE__BOUNDED_BY;

	/**
	 * The feature id for the '<em><b>Location Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_FEATURE_TYPE__LOCATION_GROUP = ABSTRACT_FEATURE_TYPE__LOCATION_GROUP;

	/**
	 * The feature id for the '<em><b>Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_FEATURE_TYPE__LOCATION = ABSTRACT_FEATURE_TYPE__LOCATION;

	/**
	 * The number of structural features of the '<em>Bounded Feature Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_FEATURE_TYPE_FEATURE_COUNT = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Bounded Feature Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDED_FEATURE_TYPE_OPERATION_COUNT = ABSTRACT_FEATURE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.BoundingShapeTypeImpl <em>Bounding Shape Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.BoundingShapeTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getBoundingShapeType()
	 * @generated
	 */
	int BOUNDING_SHAPE_TYPE = 60;

	/**
	 * The feature id for the '<em><b>Envelope Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDING_SHAPE_TYPE__ENVELOPE_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Envelope</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDING_SHAPE_TYPE__ENVELOPE = 1;

	/**
	 * The feature id for the '<em><b>Null</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDING_SHAPE_TYPE__NULL = 2;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDING_SHAPE_TYPE__NIL_REASON = 3;

	/**
	 * The number of structural features of the '<em>Bounding Shape Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDING_SHAPE_TYPE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Bounding Shape Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOUNDING_SHAPE_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CartesianCSPropertyTypeImpl <em>Cartesian CS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CartesianCSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCartesianCSPropertyType()
	 * @generated
	 */
	int CARTESIAN_CS_PROPERTY_TYPE = 62;

	/**
	 * The feature id for the '<em><b>Cartesian CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_PROPERTY_TYPE__CARTESIAN_CS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Cartesian CS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Cartesian CS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CartesianCSTypeImpl <em>Cartesian CS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CartesianCSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCartesianCSType()
	 * @generated
	 */
	int CARTESIAN_CS_TYPE = 63;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_SYSTEM_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_TYPE__IDENTIFIER = ABSTRACT_COORDINATE_SYSTEM_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_TYPE__NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_TYPE__ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_TYPE__REMARKS = ABSTRACT_COORDINATE_SYSTEM_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Axis Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_TYPE__AXIS_GROUP = ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS_GROUP;

	/**
	 * The feature id for the '<em><b>Axis</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_TYPE__AXIS = ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_TYPE__AGGREGATION_TYPE = ABSTRACT_COORDINATE_SYSTEM_TYPE__AGGREGATION_TYPE;

	/**
	 * The number of structural features of the '<em>Cartesian CS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Cartesian CS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARTESIAN_CS_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CodeOrNilReasonListTypeImpl <em>Code Or Nil Reason List Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CodeOrNilReasonListTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCodeOrNilReasonListType()
	 * @generated
	 */
	int CODE_OR_NIL_REASON_LIST_TYPE = 71;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CODE_OR_NIL_REASON_LIST_TYPE__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Code Space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CODE_OR_NIL_REASON_LIST_TYPE__CODE_SPACE = 1;

	/**
	 * The number of structural features of the '<em>Code Or Nil Reason List Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CODE_OR_NIL_REASON_LIST_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Code Or Nil Reason List Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CODE_OR_NIL_REASON_LIST_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CategoryExtentTypeImpl <em>Category Extent Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CategoryExtentTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCategoryExtentType()
	 * @generated
	 */
	int CATEGORY_EXTENT_TYPE = 64;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_EXTENT_TYPE__VALUE = CODE_OR_NIL_REASON_LIST_TYPE__VALUE;

	/**
	 * The feature id for the '<em><b>Code Space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_EXTENT_TYPE__CODE_SPACE = CODE_OR_NIL_REASON_LIST_TYPE__CODE_SPACE;

	/**
	 * The number of structural features of the '<em>Category Extent Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_EXTENT_TYPE_FEATURE_COUNT = CODE_OR_NIL_REASON_LIST_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Category Extent Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_EXTENT_TYPE_OPERATION_COUNT = CODE_OR_NIL_REASON_LIST_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CategoryPropertyTypeImpl <em>Category Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CategoryPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCategoryPropertyType()
	 * @generated
	 */
	int CATEGORY_PROPERTY_TYPE = 65;

	/**
	 * The feature id for the '<em><b>Category</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_PROPERTY_TYPE__CATEGORY = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Category Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Category Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CodeTypeImpl <em>Code Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CodeTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCodeType()
	 * @generated
	 */
	int CODE_TYPE = 72;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CODE_TYPE__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Code Space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CODE_TYPE__CODE_SPACE = 1;

	/**
	 * The number of structural features of the '<em>Code Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CODE_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Code Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CODE_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CategoryTypeImpl <em>Category Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CategoryTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCategoryType()
	 * @generated
	 */
	int CATEGORY_TYPE = 66;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_TYPE__VALUE = CODE_TYPE__VALUE;

	/**
	 * The feature id for the '<em><b>Code Space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_TYPE__CODE_SPACE = CODE_TYPE__CODE_SPACE;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_TYPE__NIL_REASON = CODE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Category Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_TYPE_FEATURE_COUNT = CODE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Category Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATEGORY_TYPE_OPERATION_COUNT = CODE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CircleByCenterPointTypeImpl <em>Circle By Center Point Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CircleByCenterPointTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCircleByCenterPointType()
	 * @generated
	 */
	int CIRCLE_BY_CENTER_POINT_TYPE = 67;

	/**
	 * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_BY_CENTER_POINT_TYPE__NUM_DERIVATIVE_INTERIOR = ARC_BY_CENTER_POINT_TYPE__NUM_DERIVATIVE_INTERIOR;

	/**
	 * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_BY_CENTER_POINT_TYPE__NUM_DERIVATIVES_AT_END = ARC_BY_CENTER_POINT_TYPE__NUM_DERIVATIVES_AT_END;

	/**
	 * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_BY_CENTER_POINT_TYPE__NUM_DERIVATIVES_AT_START = ARC_BY_CENTER_POINT_TYPE__NUM_DERIVATIVES_AT_START;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_BY_CENTER_POINT_TYPE__POS = ARC_BY_CENTER_POINT_TYPE__POS;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_BY_CENTER_POINT_TYPE__POINT_PROPERTY = ARC_BY_CENTER_POINT_TYPE__POINT_PROPERTY;

	/**
	 * The feature id for the '<em><b>Point Rep</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_BY_CENTER_POINT_TYPE__POINT_REP = ARC_BY_CENTER_POINT_TYPE__POINT_REP;

	/**
	 * The feature id for the '<em><b>Pos List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_BY_CENTER_POINT_TYPE__POS_LIST = ARC_BY_CENTER_POINT_TYPE__POS_LIST;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_BY_CENTER_POINT_TYPE__COORDINATES = ARC_BY_CENTER_POINT_TYPE__COORDINATES;

	/**
	 * The feature id for the '<em><b>Radius</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_BY_CENTER_POINT_TYPE__RADIUS = ARC_BY_CENTER_POINT_TYPE__RADIUS;

	/**
	 * The feature id for the '<em><b>Start Angle</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_BY_CENTER_POINT_TYPE__START_ANGLE = ARC_BY_CENTER_POINT_TYPE__START_ANGLE;

	/**
	 * The feature id for the '<em><b>End Angle</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_BY_CENTER_POINT_TYPE__END_ANGLE = ARC_BY_CENTER_POINT_TYPE__END_ANGLE;

	/**
	 * The feature id for the '<em><b>Interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_BY_CENTER_POINT_TYPE__INTERPOLATION = ARC_BY_CENTER_POINT_TYPE__INTERPOLATION;

	/**
	 * The feature id for the '<em><b>Num Arc</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_BY_CENTER_POINT_TYPE__NUM_ARC = ARC_BY_CENTER_POINT_TYPE__NUM_ARC;

	/**
	 * The number of structural features of the '<em>Circle By Center Point Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_BY_CENTER_POINT_TYPE_FEATURE_COUNT = ARC_BY_CENTER_POINT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Circle By Center Point Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_BY_CENTER_POINT_TYPE_OPERATION_COUNT = ARC_BY_CENTER_POINT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CircleTypeImpl <em>Circle Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CircleTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCircleType()
	 * @generated
	 */
	int CIRCLE_TYPE = 68;

	/**
	 * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_TYPE__NUM_DERIVATIVE_INTERIOR = ARC_TYPE__NUM_DERIVATIVE_INTERIOR;

	/**
	 * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_TYPE__NUM_DERIVATIVES_AT_END = ARC_TYPE__NUM_DERIVATIVES_AT_END;

	/**
	 * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_TYPE__NUM_DERIVATIVES_AT_START = ARC_TYPE__NUM_DERIVATIVES_AT_START;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_TYPE__GROUP = ARC_TYPE__GROUP;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_TYPE__POS = ARC_TYPE__POS;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_TYPE__POINT_PROPERTY = ARC_TYPE__POINT_PROPERTY;

	/**
	 * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_TYPE__POINT_REP = ARC_TYPE__POINT_REP;

	/**
	 * The feature id for the '<em><b>Pos List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_TYPE__POS_LIST = ARC_TYPE__POS_LIST;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_TYPE__COORDINATES = ARC_TYPE__COORDINATES;

	/**
	 * The feature id for the '<em><b>Interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_TYPE__INTERPOLATION = ARC_TYPE__INTERPOLATION;

	/**
	 * The feature id for the '<em><b>Num Arc</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_TYPE__NUM_ARC = ARC_TYPE__NUM_ARC;

	/**
	 * The number of structural features of the '<em>Circle Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_TYPE_FEATURE_COUNT = ARC_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Circle Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CIRCLE_TYPE_OPERATION_COUNT = ARC_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ClothoidTypeImpl <em>Clothoid Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ClothoidTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getClothoidType()
	 * @generated
	 */
	int CLOTHOID_TYPE = 69;

	/**
	 * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOTHOID_TYPE__NUM_DERIVATIVE_INTERIOR = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR;

	/**
	 * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOTHOID_TYPE__NUM_DERIVATIVES_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END;

	/**
	 * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOTHOID_TYPE__NUM_DERIVATIVES_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START;

	/**
	 * The feature id for the '<em><b>Ref Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOTHOID_TYPE__REF_LOCATION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Scale Factor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOTHOID_TYPE__SCALE_FACTOR = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Start Parameter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOTHOID_TYPE__START_PARAMETER = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>End Parameter</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOTHOID_TYPE__END_PARAMETER = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOTHOID_TYPE__INTERPOLATION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Clothoid Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOTHOID_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Clothoid Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLOTHOID_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CodeListTypeImpl <em>Code List Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CodeListTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCodeListType()
	 * @generated
	 */
	int CODE_LIST_TYPE = 70;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CODE_LIST_TYPE__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Code Space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CODE_LIST_TYPE__CODE_SPACE = 1;

	/**
	 * The number of structural features of the '<em>Code List Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CODE_LIST_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Code List Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CODE_LIST_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CodeWithAuthorityTypeImpl <em>Code With Authority Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CodeWithAuthorityTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCodeWithAuthorityType()
	 * @generated
	 */
	int CODE_WITH_AUTHORITY_TYPE = 73;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CODE_WITH_AUTHORITY_TYPE__VALUE = CODE_TYPE__VALUE;

	/**
	 * The feature id for the '<em><b>Code Space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CODE_WITH_AUTHORITY_TYPE__CODE_SPACE = CODE_TYPE__CODE_SPACE;

	/**
	 * The number of structural features of the '<em>Code With Authority Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CODE_WITH_AUTHORITY_TYPE_FEATURE_COUNT = CODE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Code With Authority Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CODE_WITH_AUTHORITY_TYPE_OPERATION_COUNT = CODE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CompositeCurveTypeImpl <em>Composite Curve Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CompositeCurveTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCompositeCurveType()
	 * @generated
	 */
	int COMPOSITE_CURVE_TYPE = 74;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_CURVE_TYPE__META_DATA_PROPERTY = ABSTRACT_CURVE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_CURVE_TYPE__DESCRIPTION = ABSTRACT_CURVE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_CURVE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_CURVE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_CURVE_TYPE__IDENTIFIER = ABSTRACT_CURVE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_CURVE_TYPE__NAME = ABSTRACT_CURVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_CURVE_TYPE__ID = ABSTRACT_CURVE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_CURVE_TYPE__AXIS_LABELS = ABSTRACT_CURVE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_CURVE_TYPE__SRS_DIMENSION = ABSTRACT_CURVE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_CURVE_TYPE__SRS_NAME = ABSTRACT_CURVE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_CURVE_TYPE__UOM_LABELS = ABSTRACT_CURVE_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Curve Member</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_CURVE_TYPE__CURVE_MEMBER = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_CURVE_TYPE__AGGREGATION_TYPE = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Composite Curve Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_CURVE_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Composite Curve Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_CURVE_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CompositeSolidTypeImpl <em>Composite Solid Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CompositeSolidTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCompositeSolidType()
	 * @generated
	 */
	int COMPOSITE_SOLID_TYPE = 75;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SOLID_TYPE__META_DATA_PROPERTY = ABSTRACT_SOLID_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SOLID_TYPE__DESCRIPTION = ABSTRACT_SOLID_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SOLID_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_SOLID_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SOLID_TYPE__IDENTIFIER = ABSTRACT_SOLID_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SOLID_TYPE__NAME = ABSTRACT_SOLID_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SOLID_TYPE__ID = ABSTRACT_SOLID_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SOLID_TYPE__AXIS_LABELS = ABSTRACT_SOLID_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SOLID_TYPE__SRS_DIMENSION = ABSTRACT_SOLID_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SOLID_TYPE__SRS_NAME = ABSTRACT_SOLID_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SOLID_TYPE__UOM_LABELS = ABSTRACT_SOLID_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Solid Member</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SOLID_TYPE__SOLID_MEMBER = ABSTRACT_SOLID_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SOLID_TYPE__AGGREGATION_TYPE = ABSTRACT_SOLID_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Composite Solid Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SOLID_TYPE_FEATURE_COUNT = ABSTRACT_SOLID_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Composite Solid Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SOLID_TYPE_OPERATION_COUNT = ABSTRACT_SOLID_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CompositeSurfaceTypeImpl <em>Composite Surface Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CompositeSurfaceTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCompositeSurfaceType()
	 * @generated
	 */
	int COMPOSITE_SURFACE_TYPE = 76;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SURFACE_TYPE__META_DATA_PROPERTY = ABSTRACT_SURFACE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SURFACE_TYPE__DESCRIPTION = ABSTRACT_SURFACE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SURFACE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_SURFACE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SURFACE_TYPE__IDENTIFIER = ABSTRACT_SURFACE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SURFACE_TYPE__NAME = ABSTRACT_SURFACE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SURFACE_TYPE__ID = ABSTRACT_SURFACE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SURFACE_TYPE__AXIS_LABELS = ABSTRACT_SURFACE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SURFACE_TYPE__SRS_DIMENSION = ABSTRACT_SURFACE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SURFACE_TYPE__SRS_NAME = ABSTRACT_SURFACE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SURFACE_TYPE__UOM_LABELS = ABSTRACT_SURFACE_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Surface Member</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SURFACE_TYPE__SURFACE_MEMBER = ABSTRACT_SURFACE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SURFACE_TYPE__AGGREGATION_TYPE = ABSTRACT_SURFACE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Composite Surface Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SURFACE_TYPE_FEATURE_COUNT = ABSTRACT_SURFACE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Composite Surface Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_SURFACE_TYPE_OPERATION_COUNT = ABSTRACT_SURFACE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CompositeValueTypeImpl <em>Composite Value Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CompositeValueTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCompositeValueType()
	 * @generated
	 */
	int COMPOSITE_VALUE_TYPE = 77;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_VALUE_TYPE__META_DATA_PROPERTY = ABSTRACT_GML_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_VALUE_TYPE__DESCRIPTION = ABSTRACT_GML_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_VALUE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GML_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_VALUE_TYPE__IDENTIFIER = ABSTRACT_GML_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_VALUE_TYPE__NAME = ABSTRACT_GML_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_VALUE_TYPE__ID = ABSTRACT_GML_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Value Component</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_VALUE_TYPE__VALUE_COMPONENT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Value Components</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_VALUE_TYPE__VALUE_COMPONENTS = ABSTRACT_GML_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_VALUE_TYPE__AGGREGATION_TYPE = ABSTRACT_GML_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Composite Value Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_VALUE_TYPE_FEATURE_COUNT = ABSTRACT_GML_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Composite Value Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_VALUE_TYPE_OPERATION_COUNT = ABSTRACT_GML_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CompoundCRSPropertyTypeImpl <em>Compound CRS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CompoundCRSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCompoundCRSPropertyType()
	 * @generated
	 */
	int COMPOUND_CRS_PROPERTY_TYPE = 78;

	/**
	 * The feature id for the '<em><b>Compound CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_PROPERTY_TYPE__COMPOUND_CRS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Compound CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Compound CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CompoundCRSTypeImpl <em>Compound CRS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CompoundCRSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCompoundCRSType()
	 * @generated
	 */
	int COMPOUND_CRS_TYPE = 79;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_TYPE__META_DATA_PROPERTY = ABSTRACT_CRS_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_TYPE__DESCRIPTION = ABSTRACT_CRS_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_CRS_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_TYPE__IDENTIFIER = ABSTRACT_CRS_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_TYPE__NAME = ABSTRACT_CRS_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_TYPE__ID = ABSTRACT_CRS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_TYPE__REMARKS = ABSTRACT_CRS_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_CRS_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_TYPE__SCOPE = ABSTRACT_CRS_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Component Reference System Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_TYPE__COMPONENT_REFERENCE_SYSTEM_GROUP = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Component Reference System</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_TYPE__COMPONENT_REFERENCE_SYSTEM = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_TYPE__AGGREGATION_TYPE = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Compound CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_TYPE_FEATURE_COUNT = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Compound CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOUND_CRS_TYPE_OPERATION_COUNT = ABSTRACT_CRS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ConcatenatedOperationPropertyTypeImpl <em>Concatenated Operation Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ConcatenatedOperationPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getConcatenatedOperationPropertyType()
	 * @generated
	 */
	int CONCATENATED_OPERATION_PROPERTY_TYPE = 80;

	/**
	 * The feature id for the '<em><b>Concatenated Operation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_PROPERTY_TYPE__CONCATENATED_OPERATION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Concatenated Operation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Concatenated Operation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ConcatenatedOperationTypeImpl <em>Concatenated Operation Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ConcatenatedOperationTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getConcatenatedOperationType()
	 * @generated
	 */
	int CONCATENATED_OPERATION_TYPE = 81;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_OPERATION_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_OPERATION_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_COORDINATE_OPERATION_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_TYPE__IDENTIFIER = ABSTRACT_COORDINATE_OPERATION_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_TYPE__NAME = ABSTRACT_COORDINATE_OPERATION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_TYPE__ID = ABSTRACT_COORDINATE_OPERATION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_TYPE__REMARKS = ABSTRACT_COORDINATE_OPERATION_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_COORDINATE_OPERATION_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_TYPE__SCOPE = ABSTRACT_COORDINATE_OPERATION_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Operation Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_TYPE__OPERATION_VERSION = ABSTRACT_COORDINATE_OPERATION_TYPE__OPERATION_VERSION;

	/**
	 * The feature id for the '<em><b>Coordinate Operation Accuracy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_TYPE__COORDINATE_OPERATION_ACCURACY = ABSTRACT_COORDINATE_OPERATION_TYPE__COORDINATE_OPERATION_ACCURACY;

	/**
	 * The feature id for the '<em><b>Source CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_TYPE__SOURCE_CRS = ABSTRACT_COORDINATE_OPERATION_TYPE__SOURCE_CRS;

	/**
	 * The feature id for the '<em><b>Target CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_TYPE__TARGET_CRS = ABSTRACT_COORDINATE_OPERATION_TYPE__TARGET_CRS;

	/**
	 * The feature id for the '<em><b>Coord Operation Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_TYPE__COORD_OPERATION_GROUP = ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Coord Operation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_TYPE__COORD_OPERATION = ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_TYPE__AGGREGATION_TYPE = ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Concatenated Operation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Concatenated Operation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONCATENATED_OPERATION_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_OPERATION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ConeTypeImpl <em>Cone Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ConeTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getConeType()
	 * @generated
	 */
	int CONE_TYPE = 82;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONE_TYPE__AGGREGATION_TYPE = ABSTRACT_GRIDDED_SURFACE_TYPE__AGGREGATION_TYPE;

	/**
	 * The feature id for the '<em><b>Rows</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONE_TYPE__ROWS = ABSTRACT_GRIDDED_SURFACE_TYPE__ROWS;

	/**
	 * The feature id for the '<em><b>Columns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONE_TYPE__COLUMNS = ABSTRACT_GRIDDED_SURFACE_TYPE__COLUMNS;

	/**
	 * The feature id for the '<em><b>Rows1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONE_TYPE__ROWS1 = ABSTRACT_GRIDDED_SURFACE_TYPE__ROWS1;

	/**
	 * The feature id for the '<em><b>Horizontal Curve Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONE_TYPE__HORIZONTAL_CURVE_TYPE = ABSTRACT_GRIDDED_SURFACE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Vertical Curve Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONE_TYPE__VERTICAL_CURVE_TYPE = ABSTRACT_GRIDDED_SURFACE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Cone Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONE_TYPE_FEATURE_COUNT = ABSTRACT_GRIDDED_SURFACE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Cone Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONE_TYPE_OPERATION_COUNT = ABSTRACT_GRIDDED_SURFACE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ControlPointTypeImpl <em>Control Point Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ControlPointTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getControlPointType()
	 * @generated
	 */
	int CONTROL_POINT_TYPE = 83;

	/**
	 * The feature id for the '<em><b>Pos List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTROL_POINT_TYPE__POS_LIST = 0;

	/**
	 * The feature id for the '<em><b>Geometric Position Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTROL_POINT_TYPE__GEOMETRIC_POSITION_GROUP = 1;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTROL_POINT_TYPE__POS = 2;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTROL_POINT_TYPE__POINT_PROPERTY = 3;

	/**
	 * The number of structural features of the '<em>Control Point Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTROL_POINT_TYPE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Control Point Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTROL_POINT_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ConventionalUnitTypeImpl <em>Conventional Unit Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ConventionalUnitTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getConventionalUnitType()
	 * @generated
	 */
	int CONVENTIONAL_UNIT_TYPE = 84;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVENTIONAL_UNIT_TYPE__META_DATA_PROPERTY = UNIT_DEFINITION_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVENTIONAL_UNIT_TYPE__DESCRIPTION = UNIT_DEFINITION_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVENTIONAL_UNIT_TYPE__DESCRIPTION_REFERENCE = UNIT_DEFINITION_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVENTIONAL_UNIT_TYPE__IDENTIFIER = UNIT_DEFINITION_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVENTIONAL_UNIT_TYPE__NAME = UNIT_DEFINITION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVENTIONAL_UNIT_TYPE__ID = UNIT_DEFINITION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVENTIONAL_UNIT_TYPE__REMARKS = UNIT_DEFINITION_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Quantity Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVENTIONAL_UNIT_TYPE__QUANTITY_TYPE = UNIT_DEFINITION_TYPE__QUANTITY_TYPE;

	/**
	 * The feature id for the '<em><b>Quantity Type Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVENTIONAL_UNIT_TYPE__QUANTITY_TYPE_REFERENCE = UNIT_DEFINITION_TYPE__QUANTITY_TYPE_REFERENCE;

	/**
	 * The feature id for the '<em><b>Catalog Symbol</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVENTIONAL_UNIT_TYPE__CATALOG_SYMBOL = UNIT_DEFINITION_TYPE__CATALOG_SYMBOL;

	/**
	 * The feature id for the '<em><b>Conversion To Preferred Unit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVENTIONAL_UNIT_TYPE__CONVERSION_TO_PREFERRED_UNIT = UNIT_DEFINITION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Rough Conversion To Preferred Unit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVENTIONAL_UNIT_TYPE__ROUGH_CONVERSION_TO_PREFERRED_UNIT = UNIT_DEFINITION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Derivation Unit Term</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVENTIONAL_UNIT_TYPE__DERIVATION_UNIT_TERM = UNIT_DEFINITION_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Conventional Unit Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVENTIONAL_UNIT_TYPE_FEATURE_COUNT = UNIT_DEFINITION_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Conventional Unit Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVENTIONAL_UNIT_TYPE_OPERATION_COUNT = UNIT_DEFINITION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ConversionPropertyTypeImpl <em>Conversion Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ConversionPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getConversionPropertyType()
	 * @generated
	 */
	int CONVERSION_PROPERTY_TYPE = 85;

	/**
	 * The feature id for the '<em><b>Conversion</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_PROPERTY_TYPE__CONVERSION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Conversion Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Conversion Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.UnitOfMeasureTypeImpl <em>Unit Of Measure Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.UnitOfMeasureTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getUnitOfMeasureType()
	 * @generated
	 */
	int UNIT_OF_MEASURE_TYPE = 338;

	/**
	 * The feature id for the '<em><b>Uom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIT_OF_MEASURE_TYPE__UOM = 0;

	/**
	 * The number of structural features of the '<em>Unit Of Measure Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIT_OF_MEASURE_TYPE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Unit Of Measure Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIT_OF_MEASURE_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ConversionToPreferredUnitTypeImpl <em>Conversion To Preferred Unit Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ConversionToPreferredUnitTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getConversionToPreferredUnitType()
	 * @generated
	 */
	int CONVERSION_TO_PREFERRED_UNIT_TYPE = 86;

	/**
	 * The feature id for the '<em><b>Uom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TO_PREFERRED_UNIT_TYPE__UOM = UNIT_OF_MEASURE_TYPE__UOM;

	/**
	 * The feature id for the '<em><b>Factor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TO_PREFERRED_UNIT_TYPE__FACTOR = UNIT_OF_MEASURE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Formula</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TO_PREFERRED_UNIT_TYPE__FORMULA = UNIT_OF_MEASURE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Conversion To Preferred Unit Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TO_PREFERRED_UNIT_TYPE_FEATURE_COUNT = UNIT_OF_MEASURE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Conversion To Preferred Unit Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TO_PREFERRED_UNIT_TYPE_OPERATION_COUNT = UNIT_OF_MEASURE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ConversionTypeImpl <em>Conversion Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ConversionTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getConversionType()
	 * @generated
	 */
	int CONVERSION_TYPE = 87;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE__META_DATA_PROPERTY = ABSTRACT_GENERAL_CONVERSION_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE__DESCRIPTION = ABSTRACT_GENERAL_CONVERSION_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GENERAL_CONVERSION_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE__IDENTIFIER = ABSTRACT_GENERAL_CONVERSION_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE__NAME = ABSTRACT_GENERAL_CONVERSION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE__ID = ABSTRACT_GENERAL_CONVERSION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE__REMARKS = ABSTRACT_GENERAL_CONVERSION_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_GENERAL_CONVERSION_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE__SCOPE = ABSTRACT_GENERAL_CONVERSION_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Operation Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE__OPERATION_VERSION = ABSTRACT_GENERAL_CONVERSION_TYPE__OPERATION_VERSION;

	/**
	 * The feature id for the '<em><b>Coordinate Operation Accuracy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE__COORDINATE_OPERATION_ACCURACY = ABSTRACT_GENERAL_CONVERSION_TYPE__COORDINATE_OPERATION_ACCURACY;

	/**
	 * The feature id for the '<em><b>Source CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE__SOURCE_CRS = ABSTRACT_GENERAL_CONVERSION_TYPE__SOURCE_CRS;

	/**
	 * The feature id for the '<em><b>Target CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE__TARGET_CRS = ABSTRACT_GENERAL_CONVERSION_TYPE__TARGET_CRS;

	/**
	 * The feature id for the '<em><b>Method Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE__METHOD_GROUP = ABSTRACT_GENERAL_CONVERSION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Method</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE__METHOD = ABSTRACT_GENERAL_CONVERSION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Parameter Value Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE__PARAMETER_VALUE_GROUP = ABSTRACT_GENERAL_CONVERSION_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Parameter Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE__PARAMETER_VALUE = ABSTRACT_GENERAL_CONVERSION_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Conversion Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE_FEATURE_COUNT = ABSTRACT_GENERAL_CONVERSION_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Conversion Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONVERSION_TYPE_OPERATION_COUNT = ABSTRACT_GENERAL_CONVERSION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CoordinateOperationAccuracyTypeImpl <em>Coordinate Operation Accuracy Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CoordinateOperationAccuracyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCoordinateOperationAccuracyType()
	 * @generated
	 */
	int COORDINATE_OPERATION_ACCURACY_TYPE = 88;

	/**
	 * The feature id for the '<em><b>Abstract DQ Positional Accuracy Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_ACCURACY_TYPE__ABSTRACT_DQ_POSITIONAL_ACCURACY_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract DQ Positional Accuracy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_ACCURACY_TYPE__ABSTRACT_DQ_POSITIONAL_ACCURACY = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_ACCURACY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_ACCURACY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_ACCURACY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_ACCURACY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_ACCURACY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_ACCURACY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_ACCURACY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_ACCURACY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_ACCURACY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Coordinate Operation Accuracy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_ACCURACY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Coordinate Operation Accuracy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_ACCURACY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CoordinateOperationPropertyTypeImpl <em>Coordinate Operation Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CoordinateOperationPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCoordinateOperationPropertyType()
	 * @generated
	 */
	int COORDINATE_OPERATION_PROPERTY_TYPE = 89;

	/**
	 * The feature id for the '<em><b>Abstract Coordinate Operation Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_PROPERTY_TYPE__ABSTRACT_COORDINATE_OPERATION_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Coordinate Operation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_PROPERTY_TYPE__ABSTRACT_COORDINATE_OPERATION = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_PROPERTY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_PROPERTY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_PROPERTY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_PROPERTY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Coordinate Operation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Coordinate Operation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_OPERATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CoordinatesTypeImpl <em>Coordinates Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CoordinatesTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCoordinatesType()
	 * @generated
	 */
	int COORDINATES_TYPE = 90;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATES_TYPE__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Cs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATES_TYPE__CS = 1;

	/**
	 * The feature id for the '<em><b>Decimal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATES_TYPE__DECIMAL = 2;

	/**
	 * The feature id for the '<em><b>Ts</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATES_TYPE__TS = 3;

	/**
	 * The number of structural features of the '<em>Coordinates Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATES_TYPE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Coordinates Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATES_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CoordinateSystemAxisPropertyTypeImpl <em>Coordinate System Axis Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CoordinateSystemAxisPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCoordinateSystemAxisPropertyType()
	 * @generated
	 */
	int COORDINATE_SYSTEM_AXIS_PROPERTY_TYPE = 91;

	/**
	 * The feature id for the '<em><b>Coordinate System Axis</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_PROPERTY_TYPE__COORDINATE_SYSTEM_AXIS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Coordinate System Axis Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Coordinate System Axis Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CoordinateSystemAxisTypeImpl <em>Coordinate System Axis Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CoordinateSystemAxisTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCoordinateSystemAxisType()
	 * @generated
	 */
	int COORDINATE_SYSTEM_AXIS_TYPE = 92;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_TYPE__META_DATA_PROPERTY = IDENTIFIED_OBJECT_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_TYPE__DESCRIPTION = IDENTIFIED_OBJECT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_TYPE__DESCRIPTION_REFERENCE = IDENTIFIED_OBJECT_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_TYPE__IDENTIFIER = IDENTIFIED_OBJECT_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_TYPE__NAME = IDENTIFIED_OBJECT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_TYPE__ID = IDENTIFIED_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_TYPE__REMARKS = IDENTIFIED_OBJECT_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Axis Abbrev</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_TYPE__AXIS_ABBREV = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Axis Direction</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_TYPE__AXIS_DIRECTION = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Minimum Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_TYPE__MINIMUM_VALUE = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Maximum Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_TYPE__MAXIMUM_VALUE = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Range Meaning</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_TYPE__RANGE_MEANING = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Uom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_TYPE__UOM = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Coordinate System Axis Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_TYPE_FEATURE_COUNT = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>Coordinate System Axis Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_AXIS_TYPE_OPERATION_COUNT = IDENTIFIED_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CoordinateSystemPropertyTypeImpl <em>Coordinate System Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CoordinateSystemPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCoordinateSystemPropertyType()
	 * @generated
	 */
	int COORDINATE_SYSTEM_PROPERTY_TYPE = 93;

	/**
	 * The feature id for the '<em><b>Abstract Coordinate System Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_PROPERTY_TYPE__ABSTRACT_COORDINATE_SYSTEM_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Coordinate System</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_PROPERTY_TYPE__ABSTRACT_COORDINATE_SYSTEM = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_PROPERTY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_PROPERTY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_PROPERTY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_PROPERTY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Coordinate System Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Coordinate System Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COORDINATE_SYSTEM_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CountPropertyTypeImpl <em>Count Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CountPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCountPropertyType()
	 * @generated
	 */
	int COUNT_PROPERTY_TYPE = 94;

	/**
	 * The feature id for the '<em><b>Count</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_PROPERTY_TYPE__COUNT = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Count Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Count Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CountTypeImpl <em>Count Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CountTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCountType()
	 * @generated
	 */
	int COUNT_TYPE = 95;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_TYPE__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>Count Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Count Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNT_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CoverageFunctionTypeImpl <em>Coverage Function Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CoverageFunctionTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCoverageFunctionType()
	 * @generated
	 */
	int COVERAGE_FUNCTION_TYPE = 96;

	/**
	 * The feature id for the '<em><b>Mapping Rule</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COVERAGE_FUNCTION_TYPE__MAPPING_RULE = 0;

	/**
	 * The feature id for the '<em><b>Coverage Mapping Rule</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COVERAGE_FUNCTION_TYPE__COVERAGE_MAPPING_RULE = 1;

	/**
	 * The feature id for the '<em><b>Grid Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COVERAGE_FUNCTION_TYPE__GRID_FUNCTION = 2;

	/**
	 * The number of structural features of the '<em>Coverage Function Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COVERAGE_FUNCTION_TYPE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Coverage Function Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COVERAGE_FUNCTION_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CRSPropertyTypeImpl <em>CRS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CRSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCRSPropertyType()
	 * @generated
	 */
	int CRS_PROPERTY_TYPE = 97;

	/**
	 * The feature id for the '<em><b>Abstract CRS Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRS_PROPERTY_TYPE__ABSTRACT_CRS_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRS_PROPERTY_TYPE__ABSTRACT_CRS = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRS_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRS_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRS_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRS_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRS_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRS_PROPERTY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRS_PROPERTY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRS_PROPERTY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRS_PROPERTY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRS_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CRS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CubicSplineTypeImpl <em>Cubic Spline Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CubicSplineTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCubicSplineType()
	 * @generated
	 */
	int CUBIC_SPLINE_TYPE = 98;

	/**
	 * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUBIC_SPLINE_TYPE__NUM_DERIVATIVE_INTERIOR = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR;

	/**
	 * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUBIC_SPLINE_TYPE__NUM_DERIVATIVES_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END;

	/**
	 * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUBIC_SPLINE_TYPE__NUM_DERIVATIVES_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUBIC_SPLINE_TYPE__GROUP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUBIC_SPLINE_TYPE__POS = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUBIC_SPLINE_TYPE__POINT_PROPERTY = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUBIC_SPLINE_TYPE__POINT_REP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Pos List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUBIC_SPLINE_TYPE__POS_LIST = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUBIC_SPLINE_TYPE__COORDINATES = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Vector At Start</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUBIC_SPLINE_TYPE__VECTOR_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Vector At End</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUBIC_SPLINE_TYPE__VECTOR_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Degree</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUBIC_SPLINE_TYPE__DEGREE = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUBIC_SPLINE_TYPE__INTERPOLATION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>Cubic Spline Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUBIC_SPLINE_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of operations of the '<em>Cubic Spline Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CUBIC_SPLINE_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CurveArrayPropertyTypeImpl <em>Curve Array Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CurveArrayPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCurveArrayPropertyType()
	 * @generated
	 */
	int CURVE_ARRAY_PROPERTY_TYPE = 99;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_ARRAY_PROPERTY_TYPE__GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Curve Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_ARRAY_PROPERTY_TYPE__ABSTRACT_CURVE_GROUP = 1;

	/**
	 * The feature id for the '<em><b>Abstract Curve</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_ARRAY_PROPERTY_TYPE__ABSTRACT_CURVE = 2;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_ARRAY_PROPERTY_TYPE__OWNS = 3;

	/**
	 * The number of structural features of the '<em>Curve Array Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_ARRAY_PROPERTY_TYPE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Curve Array Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_ARRAY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CurvePropertyTypeImpl <em>Curve Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CurvePropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCurvePropertyType()
	 * @generated
	 */
	int CURVE_PROPERTY_TYPE = 100;

	/**
	 * The feature id for the '<em><b>Abstract Curve Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_PROPERTY_TYPE__ABSTRACT_CURVE_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Curve</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_PROPERTY_TYPE__ABSTRACT_CURVE = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_PROPERTY_TYPE__OWNS = 6;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_PROPERTY_TYPE__REMOTE_SCHEMA = 7;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_PROPERTY_TYPE__ROLE = 8;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_PROPERTY_TYPE__SHOW = 9;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_PROPERTY_TYPE__TITLE = 10;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_PROPERTY_TYPE__TYPE = 11;

	/**
	 * The number of structural features of the '<em>Curve Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_PROPERTY_TYPE_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Curve Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CurveSegmentArrayPropertyTypeImpl <em>Curve Segment Array Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CurveSegmentArrayPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCurveSegmentArrayPropertyType()
	 * @generated
	 */
	int CURVE_SEGMENT_ARRAY_PROPERTY_TYPE = 101;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_SEGMENT_ARRAY_PROPERTY_TYPE__GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Curve Segment Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_SEGMENT_ARRAY_PROPERTY_TYPE__ABSTRACT_CURVE_SEGMENT_GROUP = 1;

	/**
	 * The feature id for the '<em><b>Abstract Curve Segment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_SEGMENT_ARRAY_PROPERTY_TYPE__ABSTRACT_CURVE_SEGMENT = 2;

	/**
	 * The number of structural features of the '<em>Curve Segment Array Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_SEGMENT_ARRAY_PROPERTY_TYPE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Curve Segment Array Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_SEGMENT_ARRAY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CurveTypeImpl <em>Curve Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CurveTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCurveType()
	 * @generated
	 */
	int CURVE_TYPE = 102;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_TYPE__META_DATA_PROPERTY = ABSTRACT_CURVE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_TYPE__DESCRIPTION = ABSTRACT_CURVE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_CURVE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_TYPE__IDENTIFIER = ABSTRACT_CURVE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_TYPE__NAME = ABSTRACT_CURVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_TYPE__ID = ABSTRACT_CURVE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_TYPE__AXIS_LABELS = ABSTRACT_CURVE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_TYPE__SRS_DIMENSION = ABSTRACT_CURVE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_TYPE__SRS_NAME = ABSTRACT_CURVE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_TYPE__UOM_LABELS = ABSTRACT_CURVE_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Segments</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_TYPE__SEGMENTS = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Curve Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Curve Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CURVE_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CylinderTypeImpl <em>Cylinder Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CylinderTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCylinderType()
	 * @generated
	 */
	int CYLINDER_TYPE = 103;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDER_TYPE__AGGREGATION_TYPE = ABSTRACT_GRIDDED_SURFACE_TYPE__AGGREGATION_TYPE;

	/**
	 * The feature id for the '<em><b>Rows</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDER_TYPE__ROWS = ABSTRACT_GRIDDED_SURFACE_TYPE__ROWS;

	/**
	 * The feature id for the '<em><b>Columns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDER_TYPE__COLUMNS = ABSTRACT_GRIDDED_SURFACE_TYPE__COLUMNS;

	/**
	 * The feature id for the '<em><b>Rows1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDER_TYPE__ROWS1 = ABSTRACT_GRIDDED_SURFACE_TYPE__ROWS1;

	/**
	 * The feature id for the '<em><b>Horizontal Curve Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDER_TYPE__HORIZONTAL_CURVE_TYPE = ABSTRACT_GRIDDED_SURFACE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Vertical Curve Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDER_TYPE__VERTICAL_CURVE_TYPE = ABSTRACT_GRIDDED_SURFACE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Cylinder Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDER_TYPE_FEATURE_COUNT = ABSTRACT_GRIDDED_SURFACE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Cylinder Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDER_TYPE_OPERATION_COUNT = ABSTRACT_GRIDDED_SURFACE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CylindricalCSPropertyTypeImpl <em>Cylindrical CS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CylindricalCSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCylindricalCSPropertyType()
	 * @generated
	 */
	int CYLINDRICAL_CS_PROPERTY_TYPE = 104;

	/**
	 * The feature id for the '<em><b>Cylindrical CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_PROPERTY_TYPE__CYLINDRICAL_CS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Cylindrical CS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Cylindrical CS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.CylindricalCSTypeImpl <em>Cylindrical CS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.CylindricalCSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getCylindricalCSType()
	 * @generated
	 */
	int CYLINDRICAL_CS_TYPE = 105;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_SYSTEM_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_TYPE__IDENTIFIER = ABSTRACT_COORDINATE_SYSTEM_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_TYPE__NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_TYPE__ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_TYPE__REMARKS = ABSTRACT_COORDINATE_SYSTEM_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Axis Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_TYPE__AXIS_GROUP = ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS_GROUP;

	/**
	 * The feature id for the '<em><b>Axis</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_TYPE__AXIS = ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_TYPE__AGGREGATION_TYPE = ABSTRACT_COORDINATE_SYSTEM_TYPE__AGGREGATION_TYPE;

	/**
	 * The number of structural features of the '<em>Cylindrical CS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Cylindrical CS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CYLINDRICAL_CS_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DataBlockTypeImpl <em>Data Block Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DataBlockTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDataBlockType()
	 * @generated
	 */
	int DATA_BLOCK_TYPE = 106;

	/**
	 * The feature id for the '<em><b>Range Parameters</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_BLOCK_TYPE__RANGE_PARAMETERS = 0;

	/**
	 * The feature id for the '<em><b>Tuple List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_BLOCK_TYPE__TUPLE_LIST = 1;

	/**
	 * The feature id for the '<em><b>Double Or Nil Reason Tuple List</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_BLOCK_TYPE__DOUBLE_OR_NIL_REASON_TUPLE_LIST = 2;

	/**
	 * The number of structural features of the '<em>Data Block Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_BLOCK_TYPE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Data Block Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_BLOCK_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DatumPropertyTypeImpl <em>Datum Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DatumPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDatumPropertyType()
	 * @generated
	 */
	int DATUM_PROPERTY_TYPE = 107;

	/**
	 * The feature id for the '<em><b>Abstract Datum Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATUM_PROPERTY_TYPE__ABSTRACT_DATUM_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATUM_PROPERTY_TYPE__ABSTRACT_DATUM = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATUM_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATUM_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATUM_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATUM_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATUM_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATUM_PROPERTY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATUM_PROPERTY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATUM_PROPERTY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATUM_PROPERTY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Datum Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATUM_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Datum Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATUM_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DefinitionProxyTypeImpl <em>Definition Proxy Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DefinitionProxyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDefinitionProxyType()
	 * @generated
	 */
	int DEFINITION_PROXY_TYPE = 109;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_PROXY_TYPE__META_DATA_PROPERTY = DEFINITION_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_PROXY_TYPE__DESCRIPTION = DEFINITION_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_PROXY_TYPE__DESCRIPTION_REFERENCE = DEFINITION_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_PROXY_TYPE__IDENTIFIER = DEFINITION_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_PROXY_TYPE__NAME = DEFINITION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_PROXY_TYPE__ID = DEFINITION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_PROXY_TYPE__REMARKS = DEFINITION_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Definition Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_PROXY_TYPE__DEFINITION_REF = DEFINITION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Definition Proxy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_PROXY_TYPE_FEATURE_COUNT = DEFINITION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Definition Proxy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFINITION_PROXY_TYPE_OPERATION_COUNT = DEFINITION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DegreesTypeImpl <em>Degrees Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DegreesTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDegreesType()
	 * @generated
	 */
	int DEGREES_TYPE = 111;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEGREES_TYPE__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEGREES_TYPE__DIRECTION = 1;

	/**
	 * The number of structural features of the '<em>Degrees Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEGREES_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Degrees Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEGREES_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DerivationUnitTermTypeImpl <em>Derivation Unit Term Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DerivationUnitTermTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDerivationUnitTermType()
	 * @generated
	 */
	int DERIVATION_UNIT_TERM_TYPE = 112;

	/**
	 * The feature id for the '<em><b>Uom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVATION_UNIT_TERM_TYPE__UOM = UNIT_OF_MEASURE_TYPE__UOM;

	/**
	 * The feature id for the '<em><b>Exponent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVATION_UNIT_TERM_TYPE__EXPONENT = UNIT_OF_MEASURE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Derivation Unit Term Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVATION_UNIT_TERM_TYPE_FEATURE_COUNT = UNIT_OF_MEASURE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Derivation Unit Term Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVATION_UNIT_TERM_TYPE_OPERATION_COUNT = UNIT_OF_MEASURE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DerivedCRSPropertyTypeImpl <em>Derived CRS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DerivedCRSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDerivedCRSPropertyType()
	 * @generated
	 */
	int DERIVED_CRS_PROPERTY_TYPE = 113;

	/**
	 * The feature id for the '<em><b>Derived CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_PROPERTY_TYPE__DERIVED_CRS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Derived CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Derived CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DerivedCRSTypeImpl <em>Derived CRS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DerivedCRSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDerivedCRSType()
	 * @generated
	 */
	int DERIVED_CRS_TYPE = 114;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_TYPE__META_DATA_PROPERTY = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_TYPE__DESCRIPTION = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_TYPE__IDENTIFIER = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_TYPE__NAME = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_TYPE__ID = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_TYPE__REMARKS = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_TYPE__SCOPE = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Conversion Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_TYPE__CONVERSION_GROUP = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__CONVERSION_GROUP;

	/**
	 * The feature id for the '<em><b>Conversion</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_TYPE__CONVERSION = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__CONVERSION;

	/**
	 * The feature id for the '<em><b>Base CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_TYPE__BASE_CRS = ABSTRACT_GENERAL_DERIVED_CRS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Derived CRS Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_TYPE__DERIVED_CRS_TYPE = ABSTRACT_GENERAL_DERIVED_CRS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Coordinate System Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_TYPE__COORDINATE_SYSTEM_GROUP = ABSTRACT_GENERAL_DERIVED_CRS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Coordinate System</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_TYPE__COORDINATE_SYSTEM = ABSTRACT_GENERAL_DERIVED_CRS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Derived CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_TYPE_FEATURE_COUNT = ABSTRACT_GENERAL_DERIVED_CRS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Derived CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_CRS_TYPE_OPERATION_COUNT = ABSTRACT_GENERAL_DERIVED_CRS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DerivedUnitTypeImpl <em>Derived Unit Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DerivedUnitTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDerivedUnitType()
	 * @generated
	 */
	int DERIVED_UNIT_TYPE = 115;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_UNIT_TYPE__META_DATA_PROPERTY = UNIT_DEFINITION_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_UNIT_TYPE__DESCRIPTION = UNIT_DEFINITION_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_UNIT_TYPE__DESCRIPTION_REFERENCE = UNIT_DEFINITION_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_UNIT_TYPE__IDENTIFIER = UNIT_DEFINITION_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_UNIT_TYPE__NAME = UNIT_DEFINITION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_UNIT_TYPE__ID = UNIT_DEFINITION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_UNIT_TYPE__REMARKS = UNIT_DEFINITION_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Quantity Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_UNIT_TYPE__QUANTITY_TYPE = UNIT_DEFINITION_TYPE__QUANTITY_TYPE;

	/**
	 * The feature id for the '<em><b>Quantity Type Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_UNIT_TYPE__QUANTITY_TYPE_REFERENCE = UNIT_DEFINITION_TYPE__QUANTITY_TYPE_REFERENCE;

	/**
	 * The feature id for the '<em><b>Catalog Symbol</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_UNIT_TYPE__CATALOG_SYMBOL = UNIT_DEFINITION_TYPE__CATALOG_SYMBOL;

	/**
	 * The feature id for the '<em><b>Derivation Unit Term</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_UNIT_TYPE__DERIVATION_UNIT_TERM = UNIT_DEFINITION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Derived Unit Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_UNIT_TYPE_FEATURE_COUNT = UNIT_DEFINITION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Derived Unit Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DERIVED_UNIT_TYPE_OPERATION_COUNT = UNIT_DEFINITION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DictionaryEntryTypeImpl <em>Dictionary Entry Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DictionaryEntryTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDictionaryEntryType()
	 * @generated
	 */
	int DICTIONARY_ENTRY_TYPE = 116;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_ENTRY_TYPE__OWNS = ABSTRACT_MEMBER_TYPE__OWNS;

	/**
	 * The feature id for the '<em><b>Definition Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_ENTRY_TYPE__DEFINITION_GROUP = ABSTRACT_MEMBER_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_ENTRY_TYPE__DEFINITION = ABSTRACT_MEMBER_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_ENTRY_TYPE__ACTUATE = ABSTRACT_MEMBER_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_ENTRY_TYPE__ARCROLE = ABSTRACT_MEMBER_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_ENTRY_TYPE__HREF = ABSTRACT_MEMBER_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_ENTRY_TYPE__NIL_REASON = ABSTRACT_MEMBER_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_ENTRY_TYPE__REMOTE_SCHEMA = ABSTRACT_MEMBER_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_ENTRY_TYPE__ROLE = ABSTRACT_MEMBER_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_ENTRY_TYPE__SHOW = ABSTRACT_MEMBER_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_ENTRY_TYPE__TITLE = ABSTRACT_MEMBER_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_ENTRY_TYPE__TYPE = ABSTRACT_MEMBER_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of structural features of the '<em>Dictionary Entry Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_ENTRY_TYPE_FEATURE_COUNT = ABSTRACT_MEMBER_TYPE_FEATURE_COUNT + 11;

	/**
	 * The number of operations of the '<em>Dictionary Entry Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_ENTRY_TYPE_OPERATION_COUNT = ABSTRACT_MEMBER_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DictionaryTypeImpl <em>Dictionary Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DictionaryTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDictionaryType()
	 * @generated
	 */
	int DICTIONARY_TYPE = 117;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_TYPE__META_DATA_PROPERTY = DEFINITION_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_TYPE__DESCRIPTION = DEFINITION_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_TYPE__DESCRIPTION_REFERENCE = DEFINITION_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_TYPE__IDENTIFIER = DEFINITION_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_TYPE__NAME = DEFINITION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_TYPE__ID = DEFINITION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_TYPE__REMARKS = DEFINITION_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_TYPE__GROUP = DEFINITION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Dictionary Entry</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_TYPE__DICTIONARY_ENTRY = DEFINITION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Indirect Entry</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_TYPE__INDIRECT_ENTRY = DEFINITION_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_TYPE__AGGREGATION_TYPE = DEFINITION_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Dictionary Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_TYPE_FEATURE_COUNT = DEFINITION_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Dictionary Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DICTIONARY_TYPE_OPERATION_COUNT = DEFINITION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DirectedEdgePropertyTypeImpl <em>Directed Edge Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DirectedEdgePropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDirectedEdgePropertyType()
	 * @generated
	 */
	int DIRECTED_EDGE_PROPERTY_TYPE = 118;

	/**
	 * The feature id for the '<em><b>Edge</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_EDGE_PROPERTY_TYPE__EDGE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_EDGE_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_EDGE_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_EDGE_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_EDGE_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Orientation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_EDGE_PROPERTY_TYPE__ORIENTATION = 5;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_EDGE_PROPERTY_TYPE__OWNS = 6;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_EDGE_PROPERTY_TYPE__REMOTE_SCHEMA = 7;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_EDGE_PROPERTY_TYPE__ROLE = 8;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_EDGE_PROPERTY_TYPE__SHOW = 9;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_EDGE_PROPERTY_TYPE__TITLE = 10;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_EDGE_PROPERTY_TYPE__TYPE = 11;

	/**
	 * The number of structural features of the '<em>Directed Edge Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_EDGE_PROPERTY_TYPE_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Directed Edge Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_EDGE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DirectedFacePropertyTypeImpl <em>Directed Face Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DirectedFacePropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDirectedFacePropertyType()
	 * @generated
	 */
	int DIRECTED_FACE_PROPERTY_TYPE = 119;

	/**
	 * The feature id for the '<em><b>Face</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_FACE_PROPERTY_TYPE__FACE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_FACE_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_FACE_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_FACE_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_FACE_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Orientation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_FACE_PROPERTY_TYPE__ORIENTATION = 5;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_FACE_PROPERTY_TYPE__OWNS = 6;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_FACE_PROPERTY_TYPE__REMOTE_SCHEMA = 7;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_FACE_PROPERTY_TYPE__ROLE = 8;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_FACE_PROPERTY_TYPE__SHOW = 9;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_FACE_PROPERTY_TYPE__TITLE = 10;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_FACE_PROPERTY_TYPE__TYPE = 11;

	/**
	 * The number of structural features of the '<em>Directed Face Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_FACE_PROPERTY_TYPE_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Directed Face Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_FACE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DirectedNodePropertyTypeImpl <em>Directed Node Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DirectedNodePropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDirectedNodePropertyType()
	 * @generated
	 */
	int DIRECTED_NODE_PROPERTY_TYPE = 120;

	/**
	 * The feature id for the '<em><b>Node</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_NODE_PROPERTY_TYPE__NODE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_NODE_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_NODE_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_NODE_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_NODE_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Orientation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_NODE_PROPERTY_TYPE__ORIENTATION = 5;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_NODE_PROPERTY_TYPE__OWNS = 6;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_NODE_PROPERTY_TYPE__REMOTE_SCHEMA = 7;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_NODE_PROPERTY_TYPE__ROLE = 8;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_NODE_PROPERTY_TYPE__SHOW = 9;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_NODE_PROPERTY_TYPE__TITLE = 10;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_NODE_PROPERTY_TYPE__TYPE = 11;

	/**
	 * The number of structural features of the '<em>Directed Node Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_NODE_PROPERTY_TYPE_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Directed Node Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_NODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ObservationTypeImpl <em>Observation Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ObservationTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getObservationType()
	 * @generated
	 */
	int OBSERVATION_TYPE = 219;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBSERVATION_TYPE__META_DATA_PROPERTY = ABSTRACT_FEATURE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBSERVATION_TYPE__DESCRIPTION = ABSTRACT_FEATURE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBSERVATION_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_FEATURE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBSERVATION_TYPE__IDENTIFIER = ABSTRACT_FEATURE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBSERVATION_TYPE__NAME = ABSTRACT_FEATURE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBSERVATION_TYPE__ID = ABSTRACT_FEATURE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBSERVATION_TYPE__BOUNDED_BY = ABSTRACT_FEATURE_TYPE__BOUNDED_BY;

	/**
	 * The feature id for the '<em><b>Location Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBSERVATION_TYPE__LOCATION_GROUP = ABSTRACT_FEATURE_TYPE__LOCATION_GROUP;

	/**
	 * The feature id for the '<em><b>Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBSERVATION_TYPE__LOCATION = ABSTRACT_FEATURE_TYPE__LOCATION;

	/**
	 * The feature id for the '<em><b>Valid Time</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBSERVATION_TYPE__VALID_TIME = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Using</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBSERVATION_TYPE__USING = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Target Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBSERVATION_TYPE__TARGET_GROUP = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBSERVATION_TYPE__TARGET = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Result Of</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBSERVATION_TYPE__RESULT_OF = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Observation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBSERVATION_TYPE_FEATURE_COUNT = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Observation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBSERVATION_TYPE_OPERATION_COUNT = ABSTRACT_FEATURE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DirectedObservationTypeImpl <em>Directed Observation Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DirectedObservationTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDirectedObservationType()
	 * @generated
	 */
	int DIRECTED_OBSERVATION_TYPE = 122;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_TYPE__META_DATA_PROPERTY = OBSERVATION_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_TYPE__DESCRIPTION = OBSERVATION_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_TYPE__DESCRIPTION_REFERENCE = OBSERVATION_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_TYPE__IDENTIFIER = OBSERVATION_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_TYPE__NAME = OBSERVATION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_TYPE__ID = OBSERVATION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_TYPE__BOUNDED_BY = OBSERVATION_TYPE__BOUNDED_BY;

	/**
	 * The feature id for the '<em><b>Location Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_TYPE__LOCATION_GROUP = OBSERVATION_TYPE__LOCATION_GROUP;

	/**
	 * The feature id for the '<em><b>Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_TYPE__LOCATION = OBSERVATION_TYPE__LOCATION;

	/**
	 * The feature id for the '<em><b>Valid Time</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_TYPE__VALID_TIME = OBSERVATION_TYPE__VALID_TIME;

	/**
	 * The feature id for the '<em><b>Using</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_TYPE__USING = OBSERVATION_TYPE__USING;

	/**
	 * The feature id for the '<em><b>Target Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_TYPE__TARGET_GROUP = OBSERVATION_TYPE__TARGET_GROUP;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_TYPE__TARGET = OBSERVATION_TYPE__TARGET;

	/**
	 * The feature id for the '<em><b>Result Of</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_TYPE__RESULT_OF = OBSERVATION_TYPE__RESULT_OF;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_TYPE__DIRECTION = OBSERVATION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Directed Observation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_TYPE_FEATURE_COUNT = OBSERVATION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Directed Observation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_TYPE_OPERATION_COUNT = OBSERVATION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DirectedObservationAtDistanceTypeImpl <em>Directed Observation At Distance Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DirectedObservationAtDistanceTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDirectedObservationAtDistanceType()
	 * @generated
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE = 121;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__META_DATA_PROPERTY = DIRECTED_OBSERVATION_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__DESCRIPTION = DIRECTED_OBSERVATION_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__DESCRIPTION_REFERENCE = DIRECTED_OBSERVATION_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__IDENTIFIER = DIRECTED_OBSERVATION_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__NAME = DIRECTED_OBSERVATION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__ID = DIRECTED_OBSERVATION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__BOUNDED_BY = DIRECTED_OBSERVATION_TYPE__BOUNDED_BY;

	/**
	 * The feature id for the '<em><b>Location Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__LOCATION_GROUP = DIRECTED_OBSERVATION_TYPE__LOCATION_GROUP;

	/**
	 * The feature id for the '<em><b>Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__LOCATION = DIRECTED_OBSERVATION_TYPE__LOCATION;

	/**
	 * The feature id for the '<em><b>Valid Time</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__VALID_TIME = DIRECTED_OBSERVATION_TYPE__VALID_TIME;

	/**
	 * The feature id for the '<em><b>Using</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__USING = DIRECTED_OBSERVATION_TYPE__USING;

	/**
	 * The feature id for the '<em><b>Target Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__TARGET_GROUP = DIRECTED_OBSERVATION_TYPE__TARGET_GROUP;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__TARGET = DIRECTED_OBSERVATION_TYPE__TARGET;

	/**
	 * The feature id for the '<em><b>Result Of</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__RESULT_OF = DIRECTED_OBSERVATION_TYPE__RESULT_OF;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__DIRECTION = DIRECTED_OBSERVATION_TYPE__DIRECTION;

	/**
	 * The feature id for the '<em><b>Distance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE__DISTANCE = DIRECTED_OBSERVATION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Directed Observation At Distance Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE_FEATURE_COUNT = DIRECTED_OBSERVATION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Directed Observation At Distance Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_OBSERVATION_AT_DISTANCE_TYPE_OPERATION_COUNT = DIRECTED_OBSERVATION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DirectedTopoSolidPropertyTypeImpl <em>Directed Topo Solid Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DirectedTopoSolidPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDirectedTopoSolidPropertyType()
	 * @generated
	 */
	int DIRECTED_TOPO_SOLID_PROPERTY_TYPE = 123;

	/**
	 * The feature id for the '<em><b>Topo Solid</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__TOPO_SOLID = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Orientation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__ORIENTATION = 5;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__OWNS = 6;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__REMOTE_SCHEMA = 7;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__ROLE = 8;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__SHOW = 9;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__TITLE = 10;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_TOPO_SOLID_PROPERTY_TYPE__TYPE = 11;

	/**
	 * The number of structural features of the '<em>Directed Topo Solid Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_TOPO_SOLID_PROPERTY_TYPE_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Directed Topo Solid Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTED_TOPO_SOLID_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DirectionDescriptionTypeImpl <em>Direction Description Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DirectionDescriptionTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDirectionDescriptionType()
	 * @generated
	 */
	int DIRECTION_DESCRIPTION_TYPE = 124;

	/**
	 * The feature id for the '<em><b>Compass Point</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_DESCRIPTION_TYPE__COMPASS_POINT = 0;

	/**
	 * The feature id for the '<em><b>Keyword</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_DESCRIPTION_TYPE__KEYWORD = 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_DESCRIPTION_TYPE__DESCRIPTION = 2;

	/**
	 * The feature id for the '<em><b>Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_DESCRIPTION_TYPE__REFERENCE = 3;

	/**
	 * The number of structural features of the '<em>Direction Description Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_DESCRIPTION_TYPE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Direction Description Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_DESCRIPTION_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DirectionPropertyTypeImpl <em>Direction Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DirectionPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDirectionPropertyType()
	 * @generated
	 */
	int DIRECTION_PROPERTY_TYPE = 125;

	/**
	 * The feature id for the '<em><b>Direction Vector</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_PROPERTY_TYPE__DIRECTION_VECTOR = 0;

	/**
	 * The feature id for the '<em><b>Direction Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_PROPERTY_TYPE__DIRECTION_DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Compass Point</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_PROPERTY_TYPE__COMPASS_POINT = 2;

	/**
	 * The feature id for the '<em><b>Direction Keyword</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_PROPERTY_TYPE__DIRECTION_KEYWORD = 3;

	/**
	 * The feature id for the '<em><b>Direction String</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_PROPERTY_TYPE__DIRECTION_STRING = 4;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_PROPERTY_TYPE__ACTUATE = 5;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_PROPERTY_TYPE__ARCROLE = 6;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_PROPERTY_TYPE__HREF = 7;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_PROPERTY_TYPE__NIL_REASON = 8;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_PROPERTY_TYPE__OWNS = 9;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_PROPERTY_TYPE__REMOTE_SCHEMA = 10;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_PROPERTY_TYPE__ROLE = 11;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_PROPERTY_TYPE__SHOW = 12;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_PROPERTY_TYPE__TITLE = 13;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_PROPERTY_TYPE__TYPE = 14;

	/**
	 * The number of structural features of the '<em>Direction Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_PROPERTY_TYPE_FEATURE_COUNT = 15;

	/**
	 * The number of operations of the '<em>Direction Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DirectionVectorTypeImpl <em>Direction Vector Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DirectionVectorTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDirectionVectorType()
	 * @generated
	 */
	int DIRECTION_VECTOR_TYPE = 126;

	/**
	 * The feature id for the '<em><b>Vector</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_VECTOR_TYPE__VECTOR = 0;

	/**
	 * The feature id for the '<em><b>Horizontal Angle</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_VECTOR_TYPE__HORIZONTAL_ANGLE = 1;

	/**
	 * The feature id for the '<em><b>Vertical Angle</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_VECTOR_TYPE__VERTICAL_ANGLE = 2;

	/**
	 * The number of structural features of the '<em>Direction Vector Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_VECTOR_TYPE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Direction Vector Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECTION_VECTOR_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DirectPositionListTypeImpl <em>Direct Position List Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DirectPositionListTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDirectPositionListType()
	 * @generated
	 */
	int DIRECT_POSITION_LIST_TYPE = 127;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_POSITION_LIST_TYPE__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_POSITION_LIST_TYPE__AXIS_LABELS = 1;

	/**
	 * The feature id for the '<em><b>Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_POSITION_LIST_TYPE__COUNT = 2;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_POSITION_LIST_TYPE__SRS_DIMENSION = 3;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_POSITION_LIST_TYPE__SRS_NAME = 4;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_POSITION_LIST_TYPE__UOM_LABELS = 5;

	/**
	 * The number of structural features of the '<em>Direct Position List Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_POSITION_LIST_TYPE_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>Direct Position List Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_POSITION_LIST_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DirectPositionTypeImpl <em>Direct Position Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DirectPositionTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDirectPositionType()
	 * @generated
	 */
	int DIRECT_POSITION_TYPE = 128;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_POSITION_TYPE__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_POSITION_TYPE__AXIS_LABELS = 1;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_POSITION_TYPE__SRS_DIMENSION = 2;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_POSITION_TYPE__SRS_NAME = 3;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_POSITION_TYPE__UOM_LABELS = 4;

	/**
	 * The number of structural features of the '<em>Direct Position Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_POSITION_TYPE_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Direct Position Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DIRECT_POSITION_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DiscreteCoverageTypeImpl <em>Discrete Coverage Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DiscreteCoverageTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDiscreteCoverageType()
	 * @generated
	 */
	int DISCRETE_COVERAGE_TYPE = 129;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_COVERAGE_TYPE__META_DATA_PROPERTY = ABSTRACT_COVERAGE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_COVERAGE_TYPE__DESCRIPTION = ABSTRACT_COVERAGE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_COVERAGE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_COVERAGE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_COVERAGE_TYPE__IDENTIFIER = ABSTRACT_COVERAGE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_COVERAGE_TYPE__NAME = ABSTRACT_COVERAGE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_COVERAGE_TYPE__ID = ABSTRACT_COVERAGE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_COVERAGE_TYPE__BOUNDED_BY = ABSTRACT_COVERAGE_TYPE__BOUNDED_BY;

	/**
	 * The feature id for the '<em><b>Location Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_COVERAGE_TYPE__LOCATION_GROUP = ABSTRACT_COVERAGE_TYPE__LOCATION_GROUP;

	/**
	 * The feature id for the '<em><b>Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_COVERAGE_TYPE__LOCATION = ABSTRACT_COVERAGE_TYPE__LOCATION;

	/**
	 * The feature id for the '<em><b>Domain Set Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_COVERAGE_TYPE__DOMAIN_SET_GROUP = ABSTRACT_COVERAGE_TYPE__DOMAIN_SET_GROUP;

	/**
	 * The feature id for the '<em><b>Domain Set</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_COVERAGE_TYPE__DOMAIN_SET = ABSTRACT_COVERAGE_TYPE__DOMAIN_SET;

	/**
	 * The feature id for the '<em><b>Range Set</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_COVERAGE_TYPE__RANGE_SET = ABSTRACT_COVERAGE_TYPE__RANGE_SET;

	/**
	 * The feature id for the '<em><b>Coverage Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_COVERAGE_TYPE__COVERAGE_FUNCTION = ABSTRACT_COVERAGE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Discrete Coverage Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_COVERAGE_TYPE_FEATURE_COUNT = ABSTRACT_COVERAGE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Discrete Coverage Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISCRETE_COVERAGE_TYPE_OPERATION_COUNT = ABSTRACT_COVERAGE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DMSAngleTypeImpl <em>DMS Angle Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DMSAngleTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDMSAngleType()
	 * @generated
	 */
	int DMS_ANGLE_TYPE = 130;

	/**
	 * The feature id for the '<em><b>Degrees</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DMS_ANGLE_TYPE__DEGREES = 0;

	/**
	 * The feature id for the '<em><b>Decimal Minutes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DMS_ANGLE_TYPE__DECIMAL_MINUTES = 1;

	/**
	 * The feature id for the '<em><b>Minutes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DMS_ANGLE_TYPE__MINUTES = 2;

	/**
	 * The feature id for the '<em><b>Seconds</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DMS_ANGLE_TYPE__SECONDS = 3;

	/**
	 * The number of structural features of the '<em>DMS Angle Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DMS_ANGLE_TYPE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>DMS Angle Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DMS_ANGLE_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GMLDocumentRootImpl <em>Document Root</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GMLDocumentRootImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGMLDocumentRoot()
	 * @generated
	 */
	int GML_DOCUMENT_ROOT = 131;

	/**
	 * The feature id for the '<em><b>Mixed</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MIXED = 0;

	/**
	 * The feature id for the '<em><b>XMLNS Prefix Map</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__XMLNS_PREFIX_MAP = 1;

	/**
	 * The feature id for the '<em><b>XSI Schema Location</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__XSI_SCHEMA_LOCATION = 2;

	/**
	 * The feature id for the '<em><b>Abstract Association Role</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_ASSOCIATION_ROLE = 3;

	/**
	 * The feature id for the '<em><b>Abstract Continuous Coverage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_CONTINUOUS_COVERAGE = 4;

	/**
	 * The feature id for the '<em><b>Abstract Feature</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_FEATURE = 5;

	/**
	 * The feature id for the '<em><b>Abstract GML</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_GML = 6;

	/**
	 * The feature id for the '<em><b>Abstract Object</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_OBJECT = 7;

	/**
	 * The feature id for the '<em><b>Abstract Coordinate Operation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_COORDINATE_OPERATION = 8;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DEFINITION = 9;

	/**
	 * The feature id for the '<em><b>Abstract Coordinate System</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_COORDINATE_SYSTEM = 10;

	/**
	 * The feature id for the '<em><b>Abstract Coverage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_COVERAGE = 11;

	/**
	 * The feature id for the '<em><b>Abstract CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_CRS = 12;

	/**
	 * The feature id for the '<em><b>Abstract Curve</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_CURVE = 13;

	/**
	 * The feature id for the '<em><b>Abstract Geometric Primitive</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_GEOMETRIC_PRIMITIVE = 14;

	/**
	 * The feature id for the '<em><b>Abstract Geometry</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_GEOMETRY = 15;

	/**
	 * The feature id for the '<em><b>Abstract Curve Segment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_CURVE_SEGMENT = 16;

	/**
	 * The feature id for the '<em><b>Abstract Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_DATUM = 17;

	/**
	 * The feature id for the '<em><b>Abstract Discrete Coverage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_DISCRETE_COVERAGE = 18;

	/**
	 * The feature id for the '<em><b>Abstract Feature Collection</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_FEATURE_COLLECTION = 19;

	/**
	 * The feature id for the '<em><b>Abstract General Conversion</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_GENERAL_CONVERSION = 20;

	/**
	 * The feature id for the '<em><b>Abstract Operation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_OPERATION = 21;

	/**
	 * The feature id for the '<em><b>Abstract Single Operation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_SINGLE_OPERATION = 22;

	/**
	 * The feature id for the '<em><b>Abstract General Derived CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_GENERAL_DERIVED_CRS = 23;

	/**
	 * The feature id for the '<em><b>Abstract Single CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_SINGLE_CRS = 24;

	/**
	 * The feature id for the '<em><b>Abstract General Operation Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_GENERAL_OPERATION_PARAMETER = 25;

	/**
	 * The feature id for the '<em><b>Abstract General Operation Parameter Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_GENERAL_OPERATION_PARAMETER_REF = 26;

	/**
	 * The feature id for the '<em><b>Abstract General Parameter Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_GENERAL_PARAMETER_VALUE = 27;

	/**
	 * The feature id for the '<em><b>Abstract General Transformation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_GENERAL_TRANSFORMATION = 28;

	/**
	 * The feature id for the '<em><b>Abstract Geometric Aggregate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_GEOMETRIC_AGGREGATE = 29;

	/**
	 * The feature id for the '<em><b>Abstract Gridded Surface</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_GRIDDED_SURFACE = 30;

	/**
	 * The feature id for the '<em><b>Abstract Parametric Curve Surface</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_PARAMETRIC_CURVE_SURFACE = 31;

	/**
	 * The feature id for the '<em><b>Abstract Surface Patch</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_SURFACE_PATCH = 32;

	/**
	 * The feature id for the '<em><b>Abstract Implicit Geometry</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_IMPLICIT_GEOMETRY = 33;

	/**
	 * The feature id for the '<em><b>Abstract Inline Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_INLINE_PROPERTY = 34;

	/**
	 * The feature id for the '<em><b>Abstract Meta Data</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_META_DATA = 35;

	/**
	 * The feature id for the '<em><b>Abstract Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_REFERENCE = 36;

	/**
	 * The feature id for the '<em><b>Abstract Ring</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_RING = 37;

	/**
	 * The feature id for the '<em><b>Abstract Scalar Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_SCALAR_VALUE = 38;

	/**
	 * The feature id for the '<em><b>Abstract Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_VALUE = 39;

	/**
	 * The feature id for the '<em><b>Abstract Scalar Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_SCALAR_VALUE_LIST = 40;

	/**
	 * The feature id for the '<em><b>Abstract Solid</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_SOLID = 41;

	/**
	 * The feature id for the '<em><b>Abstract Strict Association Role</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_STRICT_ASSOCIATION_ROLE = 42;

	/**
	 * The feature id for the '<em><b>Abstract Surface</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_SURFACE = 43;

	/**
	 * The feature id for the '<em><b>Abstract Time Complex</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_TIME_COMPLEX = 44;

	/**
	 * The feature id for the '<em><b>Abstract Time Object</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_TIME_OBJECT = 45;

	/**
	 * The feature id for the '<em><b>Abstract Time Geometric Primitive</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_TIME_GEOMETRIC_PRIMITIVE = 46;

	/**
	 * The feature id for the '<em><b>Abstract Time Primitive</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_TIME_PRIMITIVE = 47;

	/**
	 * The feature id for the '<em><b>Abstract Time Slice</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_TIME_SLICE = 48;

	/**
	 * The feature id for the '<em><b>Abstract Time Topology Primitive</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_TIME_TOPOLOGY_PRIMITIVE = 49;

	/**
	 * The feature id for the '<em><b>Abstract Topology</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_TOPOLOGY = 50;

	/**
	 * The feature id for the '<em><b>Abstract Topo Primitive</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ABSTRACT_TOPO_PRIMITIVE = 51;

	/**
	 * The feature id for the '<em><b>Affine CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__AFFINE_CS = 52;

	/**
	 * The feature id for the '<em><b>Affine CS1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__AFFINE_CS1 = 53;

	/**
	 * The feature id for the '<em><b>Affine CS2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__AFFINE_CS2 = 54;

	/**
	 * The feature id for the '<em><b>Affine CS3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__AFFINE_CS3 = 55;

	/**
	 * The feature id for the '<em><b>Affine Placement</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__AFFINE_PLACEMENT = 56;

	/**
	 * The feature id for the '<em><b>Anchor Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ANCHOR_DEFINITION = 57;

	/**
	 * The feature id for the '<em><b>Anchor Point</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ANCHOR_POINT = 58;

	/**
	 * The feature id for the '<em><b>Angle</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ANGLE = 59;

	/**
	 * The feature id for the '<em><b>Arc</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ARC = 60;

	/**
	 * The feature id for the '<em><b>Arc String</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ARC_STRING = 61;

	/**
	 * The feature id for the '<em><b>Arc By Bulge</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ARC_BY_BULGE = 62;

	/**
	 * The feature id for the '<em><b>Arc String By Bulge</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ARC_STRING_BY_BULGE = 63;

	/**
	 * The feature id for the '<em><b>Arc By Center Point</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ARC_BY_CENTER_POINT = 64;

	/**
	 * The feature id for the '<em><b>Array</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ARRAY = 65;

	/**
	 * The feature id for the '<em><b>Association Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ASSOCIATION_NAME = 66;

	/**
	 * The feature id for the '<em><b>Axis</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__AXIS = 67;

	/**
	 * The feature id for the '<em><b>Axis Abbrev</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__AXIS_ABBREV = 68;

	/**
	 * The feature id for the '<em><b>Axis Direction</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__AXIS_DIRECTION = 69;

	/**
	 * The feature id for the '<em><b>Bag</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__BAG = 70;

	/**
	 * The feature id for the '<em><b>Base CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__BASE_CRS = 71;

	/**
	 * The feature id for the '<em><b>Base Curve</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__BASE_CURVE = 72;

	/**
	 * The feature id for the '<em><b>Base Geodetic CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__BASE_GEODETIC_CRS = 73;

	/**
	 * The feature id for the '<em><b>Base Geographic CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__BASE_GEOGRAPHIC_CRS = 74;

	/**
	 * The feature id for the '<em><b>Base Surface</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__BASE_SURFACE = 75;

	/**
	 * The feature id for the '<em><b>Base Unit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__BASE_UNIT = 76;

	/**
	 * The feature id for the '<em><b>Unit Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__UNIT_DEFINITION = 77;

	/**
	 * The feature id for the '<em><b>Bezier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__BEZIER = 78;

	/**
	 * The feature id for the '<em><b>BSpline</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__BSPLINE = 79;

	/**
	 * The feature id for the '<em><b>Boolean</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__BOOLEAN = 80;

	/**
	 * The feature id for the '<em><b>Boolean List</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__BOOLEAN_LIST = 81;

	/**
	 * The feature id for the '<em><b>Boolean Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__BOOLEAN_VALUE = 82;

	/**
	 * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__BOUNDED_BY = 83;

	/**
	 * The feature id for the '<em><b>Cartesian CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CARTESIAN_CS = 84;

	/**
	 * The feature id for the '<em><b>Cartesian CS1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CARTESIAN_CS1 = 85;

	/**
	 * The feature id for the '<em><b>Cartesian CS2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CARTESIAN_CS2 = 86;

	/**
	 * The feature id for the '<em><b>Cartesian CS3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CARTESIAN_CS3 = 87;

	/**
	 * The feature id for the '<em><b>Cartesian CS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CARTESIAN_CS_REF = 88;

	/**
	 * The feature id for the '<em><b>Catalog Symbol</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CATALOG_SYMBOL = 89;

	/**
	 * The feature id for the '<em><b>Category</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CATEGORY = 90;

	/**
	 * The feature id for the '<em><b>Category Extent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CATEGORY_EXTENT = 91;

	/**
	 * The feature id for the '<em><b>Category List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CATEGORY_LIST = 92;

	/**
	 * The feature id for the '<em><b>Center Line Of</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CENTER_LINE_OF = 93;

	/**
	 * The feature id for the '<em><b>Center Of</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CENTER_OF = 94;

	/**
	 * The feature id for the '<em><b>Circle</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CIRCLE = 95;

	/**
	 * The feature id for the '<em><b>Circle By Center Point</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CIRCLE_BY_CENTER_POINT = 96;

	/**
	 * The feature id for the '<em><b>Clothoid</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CLOTHOID = 97;

	/**
	 * The feature id for the '<em><b>Component Reference System</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COMPONENT_REFERENCE_SYSTEM = 98;

	/**
	 * The feature id for the '<em><b>Composite Curve</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COMPOSITE_CURVE = 99;

	/**
	 * The feature id for the '<em><b>Composite Solid</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COMPOSITE_SOLID = 100;

	/**
	 * The feature id for the '<em><b>Composite Surface</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COMPOSITE_SURFACE = 101;

	/**
	 * The feature id for the '<em><b>Composite Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COMPOSITE_VALUE = 102;

	/**
	 * The feature id for the '<em><b>Compound CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COMPOUND_CRS = 103;

	/**
	 * The feature id for the '<em><b>Compound CRS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COMPOUND_CRS_REF = 104;

	/**
	 * The feature id for the '<em><b>Concatenated Operation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CONCATENATED_OPERATION = 105;

	/**
	 * The feature id for the '<em><b>Concatenated Operation Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CONCATENATED_OPERATION_REF = 106;

	/**
	 * The feature id for the '<em><b>Cone</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CONE = 107;

	/**
	 * The feature id for the '<em><b>Conventional Unit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CONVENTIONAL_UNIT = 108;

	/**
	 * The feature id for the '<em><b>Conversion</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CONVERSION = 109;

	/**
	 * The feature id for the '<em><b>Conversion1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CONVERSION1 = 110;

	/**
	 * The feature id for the '<em><b>Conversion2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CONVERSION2 = 111;

	/**
	 * The feature id for the '<em><b>Conversion3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CONVERSION3 = 112;

	/**
	 * The feature id for the '<em><b>Conversion Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CONVERSION_REF = 113;

	/**
	 * The feature id for the '<em><b>Conversion To Preferred Unit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CONVERSION_TO_PREFERRED_UNIT = 114;

	/**
	 * The feature id for the '<em><b>Coordinate Operation Accuracy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COORDINATE_OPERATION_ACCURACY = 115;

	/**
	 * The feature id for the '<em><b>Coordinate Operation Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COORDINATE_OPERATION_REF = 116;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COORDINATES = 117;

	/**
	 * The feature id for the '<em><b>Coordinate System</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COORDINATE_SYSTEM = 118;

	/**
	 * The feature id for the '<em><b>Coordinate System Axis</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COORDINATE_SYSTEM_AXIS = 119;

	/**
	 * The feature id for the '<em><b>Coordinate System Axis Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COORDINATE_SYSTEM_AXIS_REF = 120;

	/**
	 * The feature id for the '<em><b>Coordinate System Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COORDINATE_SYSTEM_REF = 121;

	/**
	 * The feature id for the '<em><b>Coord Operation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COORD_OPERATION = 122;

	/**
	 * The feature id for the '<em><b>Count</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COUNT = 123;

	/**
	 * The feature id for the '<em><b>Count Extent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COUNT_EXTENT = 124;

	/**
	 * The feature id for the '<em><b>Count List</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COUNT_LIST = 125;

	/**
	 * The feature id for the '<em><b>Coverage Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COVERAGE_FUNCTION = 126;

	/**
	 * The feature id for the '<em><b>Coverage Mapping Rule</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__COVERAGE_MAPPING_RULE = 127;

	/**
	 * The feature id for the '<em><b>Crs Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CRS_REF = 128;

	/**
	 * The feature id for the '<em><b>Cubic Spline</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CUBIC_SPLINE = 129;

	/**
	 * The feature id for the '<em><b>Curve</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CURVE = 130;

	/**
	 * The feature id for the '<em><b>Curve Array Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CURVE_ARRAY_PROPERTY = 131;

	/**
	 * The feature id for the '<em><b>Curve Member</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CURVE_MEMBER = 132;

	/**
	 * The feature id for the '<em><b>Curve Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CURVE_MEMBERS = 133;

	/**
	 * The feature id for the '<em><b>Curve Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CURVE_PROPERTY = 134;

	/**
	 * The feature id for the '<em><b>Cylinder</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CYLINDER = 135;

	/**
	 * The feature id for the '<em><b>Cylindrical CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CYLINDRICAL_CS = 136;

	/**
	 * The feature id for the '<em><b>Cylindrical CS1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CYLINDRICAL_CS1 = 137;

	/**
	 * The feature id for the '<em><b>Cylindrical CS2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CYLINDRICAL_CS2 = 138;

	/**
	 * The feature id for the '<em><b>Cylindrical CS3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CYLINDRICAL_CS3 = 139;

	/**
	 * The feature id for the '<em><b>Cylindrical CS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__CYLINDRICAL_CS_REF = 140;

	/**
	 * The feature id for the '<em><b>Data Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DATA_BLOCK = 141;

	/**
	 * The feature id for the '<em><b>Data Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DATA_SOURCE = 142;

	/**
	 * The feature id for the '<em><b>Data Source Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DATA_SOURCE_REFERENCE = 143;

	/**
	 * The feature id for the '<em><b>Datum Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DATUM_REF = 144;

	/**
	 * The feature id for the '<em><b>Decimal Minutes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DECIMAL_MINUTES = 145;

	/**
	 * The feature id for the '<em><b>Default Code Space</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DEFAULT_CODE_SPACE = 146;

	/**
	 * The feature id for the '<em><b>Defined By Conversion</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DEFINED_BY_CONVERSION = 147;

	/**
	 * The feature id for the '<em><b>Definition Collection</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DEFINITION_COLLECTION = 148;

	/**
	 * The feature id for the '<em><b>Definition Member</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DEFINITION_MEMBER = 149;

	/**
	 * The feature id for the '<em><b>Dictionary Entry</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DICTIONARY_ENTRY = 150;

	/**
	 * The feature id for the '<em><b>Definition Proxy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DEFINITION_PROXY = 151;

	/**
	 * The feature id for the '<em><b>Definition Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DEFINITION_REF = 152;

	/**
	 * The feature id for the '<em><b>Degrees</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DEGREES = 153;

	/**
	 * The feature id for the '<em><b>Derivation Unit Term</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DERIVATION_UNIT_TERM = 154;

	/**
	 * The feature id for the '<em><b>Derived CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DERIVED_CRS = 155;

	/**
	 * The feature id for the '<em><b>Derived CRS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DERIVED_CRS_REF = 156;

	/**
	 * The feature id for the '<em><b>Derived CRS Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DERIVED_CRS_TYPE = 157;

	/**
	 * The feature id for the '<em><b>Derived Unit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DERIVED_UNIT = 158;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DESCRIPTION = 159;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DESCRIPTION_REFERENCE = 160;

	/**
	 * The feature id for the '<em><b>Dictionary</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DICTIONARY = 161;

	/**
	 * The feature id for the '<em><b>Directed Edge</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DIRECTED_EDGE = 162;

	/**
	 * The feature id for the '<em><b>Directed Face</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DIRECTED_FACE = 163;

	/**
	 * The feature id for the '<em><b>Directed Node</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DIRECTED_NODE = 164;

	/**
	 * The feature id for the '<em><b>Directed Observation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DIRECTED_OBSERVATION = 165;

	/**
	 * The feature id for the '<em><b>Observation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__OBSERVATION = 166;

	/**
	 * The feature id for the '<em><b>Directed Observation At Distance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DIRECTED_OBSERVATION_AT_DISTANCE = 167;

	/**
	 * The feature id for the '<em><b>Directed Topo Solid</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DIRECTED_TOPO_SOLID = 168;

	/**
	 * The feature id for the '<em><b>Direction</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DIRECTION = 169;

	/**
	 * The feature id for the '<em><b>Dms Angle</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DMS_ANGLE = 170;

	/**
	 * The feature id for the '<em><b>Dms Angle Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DMS_ANGLE_VALUE = 171;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DOMAIN_OF_VALIDITY = 172;

	/**
	 * The feature id for the '<em><b>Domain Set</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DOMAIN_SET = 173;

	/**
	 * The feature id for the '<em><b>Double Or Nil Reason Tuple List</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DOUBLE_OR_NIL_REASON_TUPLE_LIST = 174;

	/**
	 * The feature id for the '<em><b>Duration</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DURATION = 175;

	/**
	 * The feature id for the '<em><b>Dynamic Feature</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DYNAMIC_FEATURE = 176;

	/**
	 * The feature id for the '<em><b>Dynamic Feature Collection</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DYNAMIC_FEATURE_COLLECTION = 177;

	/**
	 * The feature id for the '<em><b>Dynamic Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__DYNAMIC_MEMBERS = 178;

	/**
	 * The feature id for the '<em><b>Edge</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__EDGE = 179;

	/**
	 * The feature id for the '<em><b>Edge Of</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__EDGE_OF = 180;

	/**
	 * The feature id for the '<em><b>Ellipsoid</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ELLIPSOID = 181;

	/**
	 * The feature id for the '<em><b>Ellipsoid1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ELLIPSOID1 = 182;

	/**
	 * The feature id for the '<em><b>Ellipsoid2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ELLIPSOID2 = 183;

	/**
	 * The feature id for the '<em><b>Ellipsoid3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ELLIPSOID3 = 184;

	/**
	 * The feature id for the '<em><b>Ellipsoidal CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ELLIPSOIDAL_CS = 185;

	/**
	 * The feature id for the '<em><b>Ellipsoidal CS1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ELLIPSOIDAL_CS1 = 186;

	/**
	 * The feature id for the '<em><b>Ellipsoidal CS2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ELLIPSOIDAL_CS2 = 187;

	/**
	 * The feature id for the '<em><b>Ellipsoidal CS3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ELLIPSOIDAL_CS3 = 188;

	/**
	 * The feature id for the '<em><b>Ellipsoidal CS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ELLIPSOIDAL_CS_REF = 189;

	/**
	 * The feature id for the '<em><b>Ellipsoid Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ELLIPSOID_REF = 190;

	/**
	 * The feature id for the '<em><b>Engineering CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ENGINEERING_CRS = 191;

	/**
	 * The feature id for the '<em><b>Engineering CRS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ENGINEERING_CRS_REF = 192;

	/**
	 * The feature id for the '<em><b>Engineering Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ENGINEERING_DATUM = 193;

	/**
	 * The feature id for the '<em><b>Engineering Datum1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ENGINEERING_DATUM1 = 194;

	/**
	 * The feature id for the '<em><b>Engineering Datum2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ENGINEERING_DATUM2 = 195;

	/**
	 * The feature id for the '<em><b>Engineering Datum3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ENGINEERING_DATUM3 = 196;

	/**
	 * The feature id for the '<em><b>Engineering Datum Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ENGINEERING_DATUM_REF = 197;

	/**
	 * The feature id for the '<em><b>Envelope</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ENVELOPE = 198;

	/**
	 * The feature id for the '<em><b>Envelope With Time Period</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ENVELOPE_WITH_TIME_PERIOD = 199;

	/**
	 * The feature id for the '<em><b>Extent Of</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__EXTENT_OF = 200;

	/**
	 * The feature id for the '<em><b>Exterior</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__EXTERIOR = 201;

	/**
	 * The feature id for the '<em><b>Face</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__FACE = 202;

	/**
	 * The feature id for the '<em><b>Feature Collection</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__FEATURE_COLLECTION = 203;

	/**
	 * The feature id for the '<em><b>Feature Member</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__FEATURE_MEMBER = 204;

	/**
	 * The feature id for the '<em><b>Feature Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__FEATURE_MEMBERS = 205;

	/**
	 * The feature id for the '<em><b>Feature Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__FEATURE_PROPERTY = 206;

	/**
	 * The feature id for the '<em><b>File</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__FILE = 207;

	/**
	 * The feature id for the '<em><b>Formula</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__FORMULA = 208;

	/**
	 * The feature id for the '<em><b>Formula Citation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__FORMULA_CITATION = 209;

	/**
	 * The feature id for the '<em><b>General Conversion Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GENERAL_CONVERSION_REF = 210;

	/**
	 * The feature id for the '<em><b>General Operation Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GENERAL_OPERATION_PARAMETER = 211;

	/**
	 * The feature id for the '<em><b>General Operation Parameter1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GENERAL_OPERATION_PARAMETER1 = 212;

	/**
	 * The feature id for the '<em><b>General Transformation Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GENERAL_TRANSFORMATION_REF = 213;

	/**
	 * The feature id for the '<em><b>Generic Meta Data</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GENERIC_META_DATA = 214;

	/**
	 * The feature id for the '<em><b>Geocentric CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GEOCENTRIC_CRS = 215;

	/**
	 * The feature id for the '<em><b>Geocentric CRS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GEOCENTRIC_CRS_REF = 216;

	/**
	 * The feature id for the '<em><b>Geodesic</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GEODESIC = 217;

	/**
	 * The feature id for the '<em><b>Geodesic String</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GEODESIC_STRING = 218;

	/**
	 * The feature id for the '<em><b>Geodetic CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GEODETIC_CRS = 219;

	/**
	 * The feature id for the '<em><b>Geodetic Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GEODETIC_DATUM = 220;

	/**
	 * The feature id for the '<em><b>Geodetic Datum1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GEODETIC_DATUM1 = 221;

	/**
	 * The feature id for the '<em><b>Geodetic Datum2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GEODETIC_DATUM2 = 222;

	/**
	 * The feature id for the '<em><b>Geodetic Datum3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GEODETIC_DATUM3 = 223;

	/**
	 * The feature id for the '<em><b>Geodetic Datum Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GEODETIC_DATUM_REF = 224;

	/**
	 * The feature id for the '<em><b>Geographic CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GEOGRAPHIC_CRS = 225;

	/**
	 * The feature id for the '<em><b>Geographic CRS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GEOGRAPHIC_CRS_REF = 226;

	/**
	 * The feature id for the '<em><b>Geometric Complex</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GEOMETRIC_COMPLEX = 227;

	/**
	 * The feature id for the '<em><b>Geometry Member</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GEOMETRY_MEMBER = 228;

	/**
	 * The feature id for the '<em><b>Geometry Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GEOMETRY_MEMBERS = 229;

	/**
	 * The feature id for the '<em><b>Gml Profile Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GML_PROFILE_SCHEMA = 230;

	/**
	 * The feature id for the '<em><b>Greenwich Longitude</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GREENWICH_LONGITUDE = 231;

	/**
	 * The feature id for the '<em><b>Grid</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GRID = 232;

	/**
	 * The feature id for the '<em><b>Grid Coverage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GRID_COVERAGE = 233;

	/**
	 * The feature id for the '<em><b>Grid Domain</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GRID_DOMAIN = 234;

	/**
	 * The feature id for the '<em><b>Grid Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GRID_FUNCTION = 235;

	/**
	 * The feature id for the '<em><b>Group</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__GROUP = 236;

	/**
	 * The feature id for the '<em><b>History</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__HISTORY = 237;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__IDENTIFIER = 238;

	/**
	 * The feature id for the '<em><b>Image CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__IMAGE_CRS = 239;

	/**
	 * The feature id for the '<em><b>Image CRS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__IMAGE_CRS_REF = 240;

	/**
	 * The feature id for the '<em><b>Image Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__IMAGE_DATUM = 241;

	/**
	 * The feature id for the '<em><b>Image Datum1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__IMAGE_DATUM1 = 242;

	/**
	 * The feature id for the '<em><b>Image Datum2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__IMAGE_DATUM2 = 243;

	/**
	 * The feature id for the '<em><b>Image Datum3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__IMAGE_DATUM3 = 244;

	/**
	 * The feature id for the '<em><b>Image Datum Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__IMAGE_DATUM_REF = 245;

	/**
	 * The feature id for the '<em><b>Includes Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__INCLUDES_PARAMETER = 246;

	/**
	 * The feature id for the '<em><b>Includes Single CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__INCLUDES_SINGLE_CRS = 247;

	/**
	 * The feature id for the '<em><b>Includes Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__INCLUDES_VALUE = 248;

	/**
	 * The feature id for the '<em><b>Parameter Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__PARAMETER_VALUE = 249;

	/**
	 * The feature id for the '<em><b>Indirect Entry</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__INDIRECT_ENTRY = 250;

	/**
	 * The feature id for the '<em><b>Integer Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__INTEGER_VALUE = 251;

	/**
	 * The feature id for the '<em><b>Integer Value List</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__INTEGER_VALUE_LIST = 252;

	/**
	 * The feature id for the '<em><b>Interior</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__INTERIOR = 253;

	/**
	 * The feature id for the '<em><b>Linear CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__LINEAR_CS = 254;

	/**
	 * The feature id for the '<em><b>Linear CS1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__LINEAR_CS1 = 255;

	/**
	 * The feature id for the '<em><b>Linear CS2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__LINEAR_CS2 = 256;

	/**
	 * The feature id for the '<em><b>Linear CS3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__LINEAR_CS3 = 257;

	/**
	 * The feature id for the '<em><b>Linear CS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__LINEAR_CS_REF = 258;

	/**
	 * The feature id for the '<em><b>Linear Ring</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__LINEAR_RING = 259;

	/**
	 * The feature id for the '<em><b>Line String</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__LINE_STRING = 260;

	/**
	 * The feature id for the '<em><b>Line String Segment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__LINE_STRING_SEGMENT = 261;

	/**
	 * The feature id for the '<em><b>Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__LOCATION = 262;

	/**
	 * The feature id for the '<em><b>Location Key Word</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__LOCATION_KEY_WORD = 263;

	/**
	 * The feature id for the '<em><b>Location Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__LOCATION_NAME = 264;

	/**
	 * The feature id for the '<em><b>Location Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__LOCATION_REFERENCE = 265;

	/**
	 * The feature id for the '<em><b>Location String</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__LOCATION_STRING = 266;

	/**
	 * The feature id for the '<em><b>Mapping Rule</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MAPPING_RULE = 267;

	/**
	 * The feature id for the '<em><b>Maximal Complex</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MAXIMAL_COMPLEX = 268;

	/**
	 * The feature id for the '<em><b>Maximum Occurs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MAXIMUM_OCCURS = 269;

	/**
	 * The feature id for the '<em><b>Maximum Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MAXIMUM_VALUE = 270;

	/**
	 * The feature id for the '<em><b>Measure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MEASURE = 271;

	/**
	 * The feature id for the '<em><b>Member</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MEMBER = 272;

	/**
	 * The feature id for the '<em><b>Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MEMBERS = 273;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__META_DATA_PROPERTY = 274;

	/**
	 * The feature id for the '<em><b>Method</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__METHOD = 275;

	/**
	 * The feature id for the '<em><b>Method Formula</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__METHOD_FORMULA = 276;

	/**
	 * The feature id for the '<em><b>Minimum Occurs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MINIMUM_OCCURS = 277;

	/**
	 * The feature id for the '<em><b>Minimum Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MINIMUM_VALUE = 278;

	/**
	 * The feature id for the '<em><b>Minutes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MINUTES = 279;

	/**
	 * The feature id for the '<em><b>Modified Coordinate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MODIFIED_COORDINATE = 280;

	/**
	 * The feature id for the '<em><b>Moving Object Status</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MOVING_OBJECT_STATUS = 281;

	/**
	 * The feature id for the '<em><b>Multi Center Line Of</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_CENTER_LINE_OF = 282;

	/**
	 * The feature id for the '<em><b>Multi Center Of</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_CENTER_OF = 283;

	/**
	 * The feature id for the '<em><b>Multi Coverage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_COVERAGE = 284;

	/**
	 * The feature id for the '<em><b>Multi Curve</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_CURVE = 285;

	/**
	 * The feature id for the '<em><b>Multi Curve Coverage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_CURVE_COVERAGE = 286;

	/**
	 * The feature id for the '<em><b>Multi Curve Domain</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_CURVE_DOMAIN = 287;

	/**
	 * The feature id for the '<em><b>Multi Curve Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_CURVE_PROPERTY = 288;

	/**
	 * The feature id for the '<em><b>Multi Edge Of</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_EDGE_OF = 289;

	/**
	 * The feature id for the '<em><b>Multi Extent Of</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_EXTENT_OF = 290;

	/**
	 * The feature id for the '<em><b>Multi Geometry</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_GEOMETRY = 291;

	/**
	 * The feature id for the '<em><b>Multi Geometry Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_GEOMETRY_PROPERTY = 292;

	/**
	 * The feature id for the '<em><b>Multi Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_LOCATION = 293;

	/**
	 * The feature id for the '<em><b>Multi Point</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_POINT = 294;

	/**
	 * The feature id for the '<em><b>Multi Point Coverage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_POINT_COVERAGE = 295;

	/**
	 * The feature id for the '<em><b>Multi Point Domain</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_POINT_DOMAIN = 296;

	/**
	 * The feature id for the '<em><b>Multi Point Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_POINT_PROPERTY = 297;

	/**
	 * The feature id for the '<em><b>Multi Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_POSITION = 298;

	/**
	 * The feature id for the '<em><b>Multi Solid</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_SOLID = 299;

	/**
	 * The feature id for the '<em><b>Multi Solid Coverage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_SOLID_COVERAGE = 300;

	/**
	 * The feature id for the '<em><b>Multi Solid Domain</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_SOLID_DOMAIN = 301;

	/**
	 * The feature id for the '<em><b>Multi Solid Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_SOLID_PROPERTY = 302;

	/**
	 * The feature id for the '<em><b>Multi Surface</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_SURFACE = 303;

	/**
	 * The feature id for the '<em><b>Multi Surface Coverage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_SURFACE_COVERAGE = 304;

	/**
	 * The feature id for the '<em><b>Multi Surface Domain</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_SURFACE_DOMAIN = 305;

	/**
	 * The feature id for the '<em><b>Multi Surface Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__MULTI_SURFACE_PROPERTY = 306;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__NAME = 307;

	/**
	 * The feature id for the '<em><b>Node</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__NODE = 308;

	/**
	 * The feature id for the '<em><b>Null</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__NULL = 309;

	/**
	 * The feature id for the '<em><b>Oblique Cartesian CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__OBLIQUE_CARTESIAN_CS = 310;

	/**
	 * The feature id for the '<em><b>Oblique Cartesian CS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__OBLIQUE_CARTESIAN_CS_REF = 311;

	/**
	 * The feature id for the '<em><b>Offset Curve</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__OFFSET_CURVE = 312;

	/**
	 * The feature id for the '<em><b>Operation Method</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__OPERATION_METHOD = 313;

	/**
	 * The feature id for the '<em><b>Operation Method Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__OPERATION_METHOD_REF = 314;

	/**
	 * The feature id for the '<em><b>Operation Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__OPERATION_PARAMETER = 315;

	/**
	 * The feature id for the '<em><b>Operation Parameter1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__OPERATION_PARAMETER1 = 316;

	/**
	 * The feature id for the '<em><b>Operation Parameter2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__OPERATION_PARAMETER2 = 317;

	/**
	 * The feature id for the '<em><b>Operation Parameter3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__OPERATION_PARAMETER3 = 318;

	/**
	 * The feature id for the '<em><b>Operation Parameter Group</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__OPERATION_PARAMETER_GROUP = 319;

	/**
	 * The feature id for the '<em><b>Operation Parameter Group Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__OPERATION_PARAMETER_GROUP_REF = 320;

	/**
	 * The feature id for the '<em><b>Operation Parameter Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__OPERATION_PARAMETER_REF = 321;

	/**
	 * The feature id for the '<em><b>Operation Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__OPERATION_REF = 322;

	/**
	 * The feature id for the '<em><b>Operation Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__OPERATION_VERSION = 323;

	/**
	 * The feature id for the '<em><b>Orientable Curve</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ORIENTABLE_CURVE = 324;

	/**
	 * The feature id for the '<em><b>Orientable Surface</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ORIENTABLE_SURFACE = 325;

	/**
	 * The feature id for the '<em><b>Origin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ORIGIN = 326;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__PARAMETER = 327;

	/**
	 * The feature id for the '<em><b>Parameter Value1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__PARAMETER_VALUE1 = 328;

	/**
	 * The feature id for the '<em><b>Parameter Value2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__PARAMETER_VALUE2 = 329;

	/**
	 * The feature id for the '<em><b>Parameter Value3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__PARAMETER_VALUE3 = 330;

	/**
	 * The feature id for the '<em><b>Parameter Value Group</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__PARAMETER_VALUE_GROUP = 331;

	/**
	 * The feature id for the '<em><b>Pass Through Operation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__PASS_THROUGH_OPERATION = 332;

	/**
	 * The feature id for the '<em><b>Pass Through Operation Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__PASS_THROUGH_OPERATION_REF = 333;

	/**
	 * The feature id for the '<em><b>Patches</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__PATCHES = 334;

	/**
	 * The feature id for the '<em><b>Pixel In Cell</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__PIXEL_IN_CELL = 335;

	/**
	 * The feature id for the '<em><b>Point</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__POINT = 336;

	/**
	 * The feature id for the '<em><b>Point Array Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__POINT_ARRAY_PROPERTY = 337;

	/**
	 * The feature id for the '<em><b>Point Member</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__POINT_MEMBER = 338;

	/**
	 * The feature id for the '<em><b>Point Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__POINT_MEMBERS = 339;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__POINT_PROPERTY = 340;

	/**
	 * The feature id for the '<em><b>Point Rep</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__POINT_REP = 341;

	/**
	 * The feature id for the '<em><b>Polar CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__POLAR_CS = 342;

	/**
	 * The feature id for the '<em><b>Polar CS1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__POLAR_CS1 = 343;

	/**
	 * The feature id for the '<em><b>Polar CS2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__POLAR_CS2 = 344;

	/**
	 * The feature id for the '<em><b>Polar CS3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__POLAR_CS3 = 345;

	/**
	 * The feature id for the '<em><b>Polar CS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__POLAR_CS_REF = 346;

	/**
	 * The feature id for the '<em><b>Polygon</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__POLYGON = 347;

	/**
	 * The feature id for the '<em><b>Polygon Patch</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__POLYGON_PATCH = 348;

	/**
	 * The feature id for the '<em><b>Polygon Patches</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__POLYGON_PATCHES = 349;

	/**
	 * The feature id for the '<em><b>Polyhedral Surface</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__POLYHEDRAL_SURFACE = 350;

	/**
	 * The feature id for the '<em><b>Surface</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SURFACE = 351;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__POS = 352;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__POSITION = 353;

	/**
	 * The feature id for the '<em><b>Pos List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__POS_LIST = 354;

	/**
	 * The feature id for the '<em><b>Prime Meridian</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__PRIME_MERIDIAN = 355;

	/**
	 * The feature id for the '<em><b>Prime Meridian1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__PRIME_MERIDIAN1 = 356;

	/**
	 * The feature id for the '<em><b>Prime Meridian2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__PRIME_MERIDIAN2 = 357;

	/**
	 * The feature id for the '<em><b>Prime Meridian3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__PRIME_MERIDIAN3 = 358;

	/**
	 * The feature id for the '<em><b>Prime Meridian Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__PRIME_MERIDIAN_REF = 359;

	/**
	 * The feature id for the '<em><b>Priority Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__PRIORITY_LOCATION = 360;

	/**
	 * The feature id for the '<em><b>Projected CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__PROJECTED_CRS = 361;

	/**
	 * The feature id for the '<em><b>Projected CRS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__PROJECTED_CRS_REF = 362;

	/**
	 * The feature id for the '<em><b>Quantity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__QUANTITY = 363;

	/**
	 * The feature id for the '<em><b>Quantity Extent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__QUANTITY_EXTENT = 364;

	/**
	 * The feature id for the '<em><b>Quantity List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__QUANTITY_LIST = 365;

	/**
	 * The feature id for the '<em><b>Quantity Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__QUANTITY_TYPE = 366;

	/**
	 * The feature id for the '<em><b>Quantity Type Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__QUANTITY_TYPE_REFERENCE = 367;

	/**
	 * The feature id for the '<em><b>Range Meaning</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__RANGE_MEANING = 368;

	/**
	 * The feature id for the '<em><b>Range Parameters</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__RANGE_PARAMETERS = 369;

	/**
	 * The feature id for the '<em><b>Range Set</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__RANGE_SET = 370;

	/**
	 * The feature id for the '<em><b>Realization Epoch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__REALIZATION_EPOCH = 371;

	/**
	 * The feature id for the '<em><b>Rectangle</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__RECTANGLE = 372;

	/**
	 * The feature id for the '<em><b>Rectified Grid</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__RECTIFIED_GRID = 373;

	/**
	 * The feature id for the '<em><b>Rectified Grid Coverage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__RECTIFIED_GRID_COVERAGE = 374;

	/**
	 * The feature id for the '<em><b>Rectified Grid Domain</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__RECTIFIED_GRID_DOMAIN = 375;

	/**
	 * The feature id for the '<em><b>Reference System Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__REFERENCE_SYSTEM_REF = 376;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__REMARKS = 377;

	/**
	 * The feature id for the '<em><b>Result Of</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__RESULT_OF = 378;

	/**
	 * The feature id for the '<em><b>Reverse Property Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__REVERSE_PROPERTY_NAME = 379;

	/**
	 * The feature id for the '<em><b>Ring</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__RING = 380;

	/**
	 * The feature id for the '<em><b>Rough Conversion To Preferred Unit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ROUGH_CONVERSION_TO_PREFERRED_UNIT = 381;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SCOPE = 382;

	/**
	 * The feature id for the '<em><b>Second Defining Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SECOND_DEFINING_PARAMETER = 383;

	/**
	 * The feature id for the '<em><b>Second Defining Parameter1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SECOND_DEFINING_PARAMETER1 = 384;

	/**
	 * The feature id for the '<em><b>Second Defining Parameter2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SECOND_DEFINING_PARAMETER2 = 385;

	/**
	 * The feature id for the '<em><b>Second Defining Parameter3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SECOND_DEFINING_PARAMETER3 = 386;

	/**
	 * The feature id for the '<em><b>Seconds</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SECONDS = 387;

	/**
	 * The feature id for the '<em><b>Segments</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SEGMENTS = 388;

	/**
	 * The feature id for the '<em><b>Semi Major Axis</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SEMI_MAJOR_AXIS = 389;

	/**
	 * The feature id for the '<em><b>Shell</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SHELL = 390;

	/**
	 * The feature id for the '<em><b>Single CRS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SINGLE_CRS_REF = 391;

	/**
	 * The feature id for the '<em><b>Single Operation Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SINGLE_OPERATION_REF = 392;

	/**
	 * The feature id for the '<em><b>Solid</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SOLID = 393;

	/**
	 * The feature id for the '<em><b>Solid Array Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SOLID_ARRAY_PROPERTY = 394;

	/**
	 * The feature id for the '<em><b>Solid Member</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SOLID_MEMBER = 395;

	/**
	 * The feature id for the '<em><b>Solid Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SOLID_MEMBERS = 396;

	/**
	 * The feature id for the '<em><b>Solid Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SOLID_PROPERTY = 397;

	/**
	 * The feature id for the '<em><b>Source CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SOURCE_CRS = 398;

	/**
	 * The feature id for the '<em><b>Source Dimensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SOURCE_DIMENSIONS = 399;

	/**
	 * The feature id for the '<em><b>Sphere</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SPHERE = 400;

	/**
	 * The feature id for the '<em><b>Spherical CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SPHERICAL_CS = 401;

	/**
	 * The feature id for the '<em><b>Spherical CS1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SPHERICAL_CS1 = 402;

	/**
	 * The feature id for the '<em><b>Spherical CS2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SPHERICAL_CS2 = 403;

	/**
	 * The feature id for the '<em><b>Spherical CS3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SPHERICAL_CS3 = 404;

	/**
	 * The feature id for the '<em><b>Spherical CS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SPHERICAL_CS_REF = 405;

	/**
	 * The feature id for the '<em><b>Status</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__STATUS = 406;

	/**
	 * The feature id for the '<em><b>Status Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__STATUS_REFERENCE = 407;

	/**
	 * The feature id for the '<em><b>String Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__STRING_VALUE = 408;

	/**
	 * The feature id for the '<em><b>Sub Complex</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SUB_COMPLEX = 409;

	/**
	 * The feature id for the '<em><b>Subject</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SUBJECT = 410;

	/**
	 * The feature id for the '<em><b>Target</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TARGET = 411;

	/**
	 * The feature id for the '<em><b>Super Complex</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SUPER_COMPLEX = 412;

	/**
	 * The feature id for the '<em><b>Surface Array Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SURFACE_ARRAY_PROPERTY = 413;

	/**
	 * The feature id for the '<em><b>Surface Member</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SURFACE_MEMBER = 414;

	/**
	 * The feature id for the '<em><b>Surface Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SURFACE_MEMBERS = 415;

	/**
	 * The feature id for the '<em><b>Surface Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__SURFACE_PROPERTY = 416;

	/**
	 * The feature id for the '<em><b>Target CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TARGET_CRS = 417;

	/**
	 * The feature id for the '<em><b>Target Dimensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TARGET_DIMENSIONS = 418;

	/**
	 * The feature id for the '<em><b>Target Element</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TARGET_ELEMENT = 419;

	/**
	 * The feature id for the '<em><b>Temporal CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TEMPORAL_CRS = 420;

	/**
	 * The feature id for the '<em><b>Temporal CRS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TEMPORAL_CRS_REF = 421;

	/**
	 * The feature id for the '<em><b>Temporal CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TEMPORAL_CS = 422;

	/**
	 * The feature id for the '<em><b>Temporal CS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TEMPORAL_CS_REF = 423;

	/**
	 * The feature id for the '<em><b>Temporal Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TEMPORAL_DATUM = 424;

	/**
	 * The feature id for the '<em><b>Temporal Datum1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TEMPORAL_DATUM1 = 425;

	/**
	 * The feature id for the '<em><b>Temporal Datum2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TEMPORAL_DATUM2 = 426;

	/**
	 * The feature id for the '<em><b>Temporal Datum3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TEMPORAL_DATUM3 = 427;

	/**
	 * The feature id for the '<em><b>Temporal Datum Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TEMPORAL_DATUM_REF = 428;

	/**
	 * The feature id for the '<em><b>Time Calendar</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIME_CALENDAR = 429;

	/**
	 * The feature id for the '<em><b>Time Reference System</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIME_REFERENCE_SYSTEM = 430;

	/**
	 * The feature id for the '<em><b>Time Calendar Era</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIME_CALENDAR_ERA = 431;

	/**
	 * The feature id for the '<em><b>Time Clock</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIME_CLOCK = 432;

	/**
	 * The feature id for the '<em><b>Time Coordinate System</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIME_COORDINATE_SYSTEM = 433;

	/**
	 * The feature id for the '<em><b>Time CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIME_CS = 434;

	/**
	 * The feature id for the '<em><b>Time CS1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIME_CS1 = 435;

	/**
	 * The feature id for the '<em><b>Time CS2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIME_CS2 = 436;

	/**
	 * The feature id for the '<em><b>Time CS3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIME_CS3 = 437;

	/**
	 * The feature id for the '<em><b>Time Edge</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIME_EDGE = 438;

	/**
	 * The feature id for the '<em><b>Time Instant</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIME_INSTANT = 439;

	/**
	 * The feature id for the '<em><b>Time Interval</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIME_INTERVAL = 440;

	/**
	 * The feature id for the '<em><b>Time Node</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIME_NODE = 441;

	/**
	 * The feature id for the '<em><b>Time Ordinal Era</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIME_ORDINAL_ERA = 442;

	/**
	 * The feature id for the '<em><b>Time Ordinal Reference System</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIME_ORDINAL_REFERENCE_SYSTEM = 443;

	/**
	 * The feature id for the '<em><b>Time Period</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIME_PERIOD = 444;

	/**
	 * The feature id for the '<em><b>Time Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIME_POSITION = 445;

	/**
	 * The feature id for the '<em><b>Time Topology Complex</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIME_TOPOLOGY_COMPLEX = 446;

	/**
	 * The feature id for the '<em><b>Tin</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TIN = 447;

	/**
	 * The feature id for the '<em><b>Triangulated Surface</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TRIANGULATED_SURFACE = 448;

	/**
	 * The feature id for the '<em><b>Topo Complex</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TOPO_COMPLEX = 449;

	/**
	 * The feature id for the '<em><b>Topo Complex Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TOPO_COMPLEX_PROPERTY = 450;

	/**
	 * The feature id for the '<em><b>Topo Curve</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TOPO_CURVE = 451;

	/**
	 * The feature id for the '<em><b>Topo Curve Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TOPO_CURVE_PROPERTY = 452;

	/**
	 * The feature id for the '<em><b>Topo Point</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TOPO_POINT = 453;

	/**
	 * The feature id for the '<em><b>Topo Point Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TOPO_POINT_PROPERTY = 454;

	/**
	 * The feature id for the '<em><b>Topo Primitive Member</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TOPO_PRIMITIVE_MEMBER = 455;

	/**
	 * The feature id for the '<em><b>Topo Primitive Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TOPO_PRIMITIVE_MEMBERS = 456;

	/**
	 * The feature id for the '<em><b>Topo Solid</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TOPO_SOLID = 457;

	/**
	 * The feature id for the '<em><b>Topo Surface</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TOPO_SURFACE = 458;

	/**
	 * The feature id for the '<em><b>Topo Surface Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TOPO_SURFACE_PROPERTY = 459;

	/**
	 * The feature id for the '<em><b>Topo Volume</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TOPO_VOLUME = 460;

	/**
	 * The feature id for the '<em><b>Topo Volume Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TOPO_VOLUME_PROPERTY = 461;

	/**
	 * The feature id for the '<em><b>Track</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TRACK = 462;

	/**
	 * The feature id for the '<em><b>Transformation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TRANSFORMATION = 463;

	/**
	 * The feature id for the '<em><b>Transformation Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TRANSFORMATION_REF = 464;

	/**
	 * The feature id for the '<em><b>Triangle</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TRIANGLE = 465;

	/**
	 * The feature id for the '<em><b>Triangle Patches</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TRIANGLE_PATCHES = 466;

	/**
	 * The feature id for the '<em><b>Tuple List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__TUPLE_LIST = 467;

	/**
	 * The feature id for the '<em><b>Unit Of Measure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__UNIT_OF_MEASURE = 468;

	/**
	 * The feature id for the '<em><b>User Defined CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USER_DEFINED_CS = 469;

	/**
	 * The feature id for the '<em><b>User Defined CS1</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USER_DEFINED_CS1 = 470;

	/**
	 * The feature id for the '<em><b>User Defined CS2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USER_DEFINED_CS2 = 471;

	/**
	 * The feature id for the '<em><b>User Defined CS3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USER_DEFINED_CS3 = 472;

	/**
	 * The feature id for the '<em><b>User Defined CS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USER_DEFINED_CS_REF = 473;

	/**
	 * The feature id for the '<em><b>Uses Affine CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_AFFINE_CS = 474;

	/**
	 * The feature id for the '<em><b>Uses Axis</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_AXIS = 475;

	/**
	 * The feature id for the '<em><b>Uses Cartesian CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_CARTESIAN_CS = 476;

	/**
	 * The feature id for the '<em><b>Uses CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_CS = 477;

	/**
	 * The feature id for the '<em><b>Uses Ellipsoid</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_ELLIPSOID = 478;

	/**
	 * The feature id for the '<em><b>Uses Ellipsoidal CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_ELLIPSOIDAL_CS = 479;

	/**
	 * The feature id for the '<em><b>Uses Engineering Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_ENGINEERING_DATUM = 480;

	/**
	 * The feature id for the '<em><b>Uses Geodetic Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_GEODETIC_DATUM = 481;

	/**
	 * The feature id for the '<em><b>Uses Image Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_IMAGE_DATUM = 482;

	/**
	 * The feature id for the '<em><b>Uses Method</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_METHOD = 483;

	/**
	 * The feature id for the '<em><b>Uses Oblique Cartesian CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_OBLIQUE_CARTESIAN_CS = 484;

	/**
	 * The feature id for the '<em><b>Uses Operation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_OPERATION = 485;

	/**
	 * The feature id for the '<em><b>Uses Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_PARAMETER = 486;

	/**
	 * The feature id for the '<em><b>Uses Prime Meridian</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_PRIME_MERIDIAN = 487;

	/**
	 * The feature id for the '<em><b>Uses Single Operation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_SINGLE_OPERATION = 488;

	/**
	 * The feature id for the '<em><b>Uses Spherical CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_SPHERICAL_CS = 489;

	/**
	 * The feature id for the '<em><b>Uses Temporal CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_TEMPORAL_CS = 490;

	/**
	 * The feature id for the '<em><b>Uses Temporal Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_TEMPORAL_DATUM = 491;

	/**
	 * The feature id for the '<em><b>Uses Time CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_TIME_CS = 492;

	/**
	 * The feature id for the '<em><b>Uses Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_VALUE = 493;

	/**
	 * The feature id for the '<em><b>Uses Vertical CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_VERTICAL_CS = 494;

	/**
	 * The feature id for the '<em><b>Vertical CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VERTICAL_CS = 495;

	/**
	 * The feature id for the '<em><b>Uses Vertical Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USES_VERTICAL_DATUM = 496;

	/**
	 * The feature id for the '<em><b>Vertical Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VERTICAL_DATUM = 497;

	/**
	 * The feature id for the '<em><b>Using</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__USING = 498;

	/**
	 * The feature id for the '<em><b>Valid Time</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VALID_TIME = 499;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VALUE = 500;

	/**
	 * The feature id for the '<em><b>Value Array</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VALUE_ARRAY = 501;

	/**
	 * The feature id for the '<em><b>Value Component</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VALUE_COMPONENT = 502;

	/**
	 * The feature id for the '<em><b>Value Components</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VALUE_COMPONENTS = 503;

	/**
	 * The feature id for the '<em><b>Value File</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VALUE_FILE = 504;

	/**
	 * The feature id for the '<em><b>Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VALUE_LIST = 505;

	/**
	 * The feature id for the '<em><b>Value Of Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VALUE_OF_PARAMETER = 506;

	/**
	 * The feature id for the '<em><b>Value Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VALUE_PROPERTY = 507;

	/**
	 * The feature id for the '<em><b>Values Of Group</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VALUES_OF_GROUP = 508;

	/**
	 * The feature id for the '<em><b>Vector</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VECTOR = 509;

	/**
	 * The feature id for the '<em><b>Vertical CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VERTICAL_CRS = 510;

	/**
	 * The feature id for the '<em><b>Vertical CRS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VERTICAL_CRS_REF = 511;

	/**
	 * The feature id for the '<em><b>Vertical CS2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VERTICAL_CS2 = 512;

	/**
	 * The feature id for the '<em><b>Vertical CS3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VERTICAL_CS3 = 513;

	/**
	 * The feature id for the '<em><b>Vertical CS Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VERTICAL_CS_REF = 514;

	/**
	 * The feature id for the '<em><b>Vertical Datum2</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VERTICAL_DATUM2 = 515;

	/**
	 * The feature id for the '<em><b>Vertical Datum3</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VERTICAL_DATUM3 = 516;

	/**
	 * The feature id for the '<em><b>Vertical Datum Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__VERTICAL_DATUM_REF = 517;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__ID = 518;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__REMOTE_SCHEMA = 519;

	/**
	 * The feature id for the '<em><b>Uom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT__UOM = 520;

	/**
	 * The number of structural features of the '<em>Document Root</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT_FEATURE_COUNT = 521;

	/**
	 * The number of operations of the '<em>Document Root</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GML_DOCUMENT_ROOT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DomainOfValidityTypeImpl <em>Domain Of Validity Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DomainOfValidityTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDomainOfValidityType()
	 * @generated
	 */
	int DOMAIN_OF_VALIDITY_TYPE = 132;

	/**
	 * The feature id for the '<em><b>EX Extent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_OF_VALIDITY_TYPE__EX_EXTENT = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_OF_VALIDITY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_OF_VALIDITY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_OF_VALIDITY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_OF_VALIDITY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_OF_VALIDITY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_OF_VALIDITY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_OF_VALIDITY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_OF_VALIDITY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_OF_VALIDITY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Domain Of Validity Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_OF_VALIDITY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Domain Of Validity Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_OF_VALIDITY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DomainSetTypeImpl <em>Domain Set Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DomainSetTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDomainSetType()
	 * @generated
	 */
	int DOMAIN_SET_TYPE = 133;

	/**
	 * The feature id for the '<em><b>Abstract Geometry Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_SET_TYPE__ABSTRACT_GEOMETRY_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Geometry</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_SET_TYPE__ABSTRACT_GEOMETRY = 1;

	/**
	 * The feature id for the '<em><b>Abstract Time Object Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_SET_TYPE__ABSTRACT_TIME_OBJECT_GROUP = 2;

	/**
	 * The feature id for the '<em><b>Abstract Time Object</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_SET_TYPE__ABSTRACT_TIME_OBJECT = 3;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_SET_TYPE__ACTUATE = 4;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_SET_TYPE__ARCROLE = 5;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_SET_TYPE__HREF = 6;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_SET_TYPE__NIL_REASON = 7;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_SET_TYPE__OWNS = 8;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_SET_TYPE__REMOTE_SCHEMA = 9;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_SET_TYPE__ROLE = 10;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_SET_TYPE__SHOW = 11;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_SET_TYPE__TITLE = 12;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_SET_TYPE__TYPE = 13;

	/**
	 * The number of structural features of the '<em>Domain Set Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_SET_TYPE_FEATURE_COUNT = 14;

	/**
	 * The number of operations of the '<em>Domain Set Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOMAIN_SET_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DynamicFeatureTypeImpl <em>Dynamic Feature Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DynamicFeatureTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDynamicFeatureType()
	 * @generated
	 */
	int DYNAMIC_FEATURE_TYPE = 136;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_TYPE__META_DATA_PROPERTY = ABSTRACT_FEATURE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_TYPE__DESCRIPTION = ABSTRACT_FEATURE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_FEATURE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_TYPE__IDENTIFIER = ABSTRACT_FEATURE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_TYPE__NAME = ABSTRACT_FEATURE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_TYPE__ID = ABSTRACT_FEATURE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_TYPE__BOUNDED_BY = ABSTRACT_FEATURE_TYPE__BOUNDED_BY;

	/**
	 * The feature id for the '<em><b>Location Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_TYPE__LOCATION_GROUP = ABSTRACT_FEATURE_TYPE__LOCATION_GROUP;

	/**
	 * The feature id for the '<em><b>Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_TYPE__LOCATION = ABSTRACT_FEATURE_TYPE__LOCATION;

	/**
	 * The feature id for the '<em><b>Valid Time</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_TYPE__VALID_TIME = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>History Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_TYPE__HISTORY_GROUP = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>History</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_TYPE__HISTORY = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Data Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_TYPE__DATA_SOURCE = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Data Source Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_TYPE__DATA_SOURCE_REFERENCE = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Dynamic Feature Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_TYPE_FEATURE_COUNT = ABSTRACT_FEATURE_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Dynamic Feature Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_TYPE_OPERATION_COUNT = ABSTRACT_FEATURE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DynamicFeatureCollectionTypeImpl <em>Dynamic Feature Collection Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DynamicFeatureCollectionTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDynamicFeatureCollectionType()
	 * @generated
	 */
	int DYNAMIC_FEATURE_COLLECTION_TYPE = 134;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_COLLECTION_TYPE__META_DATA_PROPERTY = DYNAMIC_FEATURE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_COLLECTION_TYPE__DESCRIPTION = DYNAMIC_FEATURE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_COLLECTION_TYPE__DESCRIPTION_REFERENCE = DYNAMIC_FEATURE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_COLLECTION_TYPE__IDENTIFIER = DYNAMIC_FEATURE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_COLLECTION_TYPE__NAME = DYNAMIC_FEATURE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_COLLECTION_TYPE__ID = DYNAMIC_FEATURE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_COLLECTION_TYPE__BOUNDED_BY = DYNAMIC_FEATURE_TYPE__BOUNDED_BY;

	/**
	 * The feature id for the '<em><b>Location Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_COLLECTION_TYPE__LOCATION_GROUP = DYNAMIC_FEATURE_TYPE__LOCATION_GROUP;

	/**
	 * The feature id for the '<em><b>Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_COLLECTION_TYPE__LOCATION = DYNAMIC_FEATURE_TYPE__LOCATION;

	/**
	 * The feature id for the '<em><b>Valid Time</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_COLLECTION_TYPE__VALID_TIME = DYNAMIC_FEATURE_TYPE__VALID_TIME;

	/**
	 * The feature id for the '<em><b>History Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_COLLECTION_TYPE__HISTORY_GROUP = DYNAMIC_FEATURE_TYPE__HISTORY_GROUP;

	/**
	 * The feature id for the '<em><b>History</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_COLLECTION_TYPE__HISTORY = DYNAMIC_FEATURE_TYPE__HISTORY;

	/**
	 * The feature id for the '<em><b>Data Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_COLLECTION_TYPE__DATA_SOURCE = DYNAMIC_FEATURE_TYPE__DATA_SOURCE;

	/**
	 * The feature id for the '<em><b>Data Source Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_COLLECTION_TYPE__DATA_SOURCE_REFERENCE = DYNAMIC_FEATURE_TYPE__DATA_SOURCE_REFERENCE;

	/**
	 * The feature id for the '<em><b>Dynamic Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_COLLECTION_TYPE__DYNAMIC_MEMBERS = DYNAMIC_FEATURE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Dynamic Feature Collection Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_COLLECTION_TYPE_FEATURE_COUNT = DYNAMIC_FEATURE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Dynamic Feature Collection Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_COLLECTION_TYPE_OPERATION_COUNT = DYNAMIC_FEATURE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.DynamicFeatureMemberTypeImpl <em>Dynamic Feature Member Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.DynamicFeatureMemberTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getDynamicFeatureMemberType()
	 * @generated
	 */
	int DYNAMIC_FEATURE_MEMBER_TYPE = 135;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_MEMBER_TYPE__OWNS = ABSTRACT_FEATURE_MEMBER_TYPE__OWNS;

	/**
	 * The feature id for the '<em><b>Dynamic Feature Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_MEMBER_TYPE__DYNAMIC_FEATURE_GROUP = ABSTRACT_FEATURE_MEMBER_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Dynamic Feature</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_MEMBER_TYPE__DYNAMIC_FEATURE = ABSTRACT_FEATURE_MEMBER_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_MEMBER_TYPE__ACTUATE = ABSTRACT_FEATURE_MEMBER_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_MEMBER_TYPE__ARCROLE = ABSTRACT_FEATURE_MEMBER_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_MEMBER_TYPE__HREF = ABSTRACT_FEATURE_MEMBER_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_MEMBER_TYPE__NIL_REASON = ABSTRACT_FEATURE_MEMBER_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_MEMBER_TYPE__REMOTE_SCHEMA = ABSTRACT_FEATURE_MEMBER_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_MEMBER_TYPE__ROLE = ABSTRACT_FEATURE_MEMBER_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_MEMBER_TYPE__SHOW = ABSTRACT_FEATURE_MEMBER_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_MEMBER_TYPE__TITLE = ABSTRACT_FEATURE_MEMBER_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_MEMBER_TYPE__TYPE = ABSTRACT_FEATURE_MEMBER_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of structural features of the '<em>Dynamic Feature Member Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_MEMBER_TYPE_FEATURE_COUNT = ABSTRACT_FEATURE_MEMBER_TYPE_FEATURE_COUNT + 11;

	/**
	 * The number of operations of the '<em>Dynamic Feature Member Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DYNAMIC_FEATURE_MEMBER_TYPE_OPERATION_COUNT = ABSTRACT_FEATURE_MEMBER_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.EdgeTypeImpl <em>Edge Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.EdgeTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getEdgeType()
	 * @generated
	 */
	int EDGE_TYPE = 137;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_TYPE__META_DATA_PROPERTY = ABSTRACT_TOPO_PRIMITIVE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_TYPE__DESCRIPTION = ABSTRACT_TOPO_PRIMITIVE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_TOPO_PRIMITIVE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_TYPE__IDENTIFIER = ABSTRACT_TOPO_PRIMITIVE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_TYPE__NAME = ABSTRACT_TOPO_PRIMITIVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_TYPE__ID = ABSTRACT_TOPO_PRIMITIVE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Container</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_TYPE__CONTAINER = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Directed Node</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_TYPE__DIRECTED_NODE = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Directed Face</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_TYPE__DIRECTED_FACE = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Curve Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_TYPE__CURVE_PROPERTY = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_TYPE__AGGREGATION_TYPE = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Edge Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_TYPE_FEATURE_COUNT = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Edge Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_TYPE_OPERATION_COUNT = ABSTRACT_TOPO_PRIMITIVE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.EllipsoidalCSPropertyTypeImpl <em>Ellipsoidal CS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.EllipsoidalCSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getEllipsoidalCSPropertyType()
	 * @generated
	 */
	int ELLIPSOIDAL_CS_PROPERTY_TYPE = 138;

	/**
	 * The feature id for the '<em><b>Ellipsoidal CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_PROPERTY_TYPE__ELLIPSOIDAL_CS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Ellipsoidal CS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Ellipsoidal CS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.EllipsoidalCSTypeImpl <em>Ellipsoidal CS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.EllipsoidalCSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getEllipsoidalCSType()
	 * @generated
	 */
	int ELLIPSOIDAL_CS_TYPE = 139;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_SYSTEM_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_TYPE__IDENTIFIER = ABSTRACT_COORDINATE_SYSTEM_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_TYPE__NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_TYPE__ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_TYPE__REMARKS = ABSTRACT_COORDINATE_SYSTEM_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Axis Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_TYPE__AXIS_GROUP = ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS_GROUP;

	/**
	 * The feature id for the '<em><b>Axis</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_TYPE__AXIS = ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_TYPE__AGGREGATION_TYPE = ABSTRACT_COORDINATE_SYSTEM_TYPE__AGGREGATION_TYPE;

	/**
	 * The number of structural features of the '<em>Ellipsoidal CS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Ellipsoidal CS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOIDAL_CS_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.EllipsoidPropertyTypeImpl <em>Ellipsoid Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.EllipsoidPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getEllipsoidPropertyType()
	 * @generated
	 */
	int ELLIPSOID_PROPERTY_TYPE = 140;

	/**
	 * The feature id for the '<em><b>Ellipsoid</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_PROPERTY_TYPE__ELLIPSOID = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Ellipsoid Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Ellipsoid Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.EllipsoidTypeImpl <em>Ellipsoid Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.EllipsoidTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getEllipsoidType()
	 * @generated
	 */
	int ELLIPSOID_TYPE = 141;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_TYPE__META_DATA_PROPERTY = IDENTIFIED_OBJECT_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_TYPE__DESCRIPTION = IDENTIFIED_OBJECT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_TYPE__DESCRIPTION_REFERENCE = IDENTIFIED_OBJECT_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_TYPE__IDENTIFIER = IDENTIFIED_OBJECT_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_TYPE__NAME = IDENTIFIED_OBJECT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_TYPE__ID = IDENTIFIED_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_TYPE__REMARKS = IDENTIFIED_OBJECT_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Semi Major Axis</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_TYPE__SEMI_MAJOR_AXIS = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Second Defining Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_TYPE__SECOND_DEFINING_PARAMETER = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ellipsoid Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_TYPE_FEATURE_COUNT = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Ellipsoid Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ELLIPSOID_TYPE_OPERATION_COUNT = IDENTIFIED_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.EngineeringCRSPropertyTypeImpl <em>Engineering CRS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.EngineeringCRSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getEngineeringCRSPropertyType()
	 * @generated
	 */
	int ENGINEERING_CRS_PROPERTY_TYPE = 142;

	/**
	 * The feature id for the '<em><b>Engineering CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_PROPERTY_TYPE__ENGINEERING_CRS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Engineering CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Engineering CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.EngineeringCRSTypeImpl <em>Engineering CRS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.EngineeringCRSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getEngineeringCRSType()
	 * @generated
	 */
	int ENGINEERING_CRS_TYPE = 143;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__META_DATA_PROPERTY = ABSTRACT_CRS_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__DESCRIPTION = ABSTRACT_CRS_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_CRS_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__IDENTIFIER = ABSTRACT_CRS_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__NAME = ABSTRACT_CRS_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__ID = ABSTRACT_CRS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__REMARKS = ABSTRACT_CRS_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_CRS_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__SCOPE = ABSTRACT_CRS_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Affine CS Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__AFFINE_CS_GROUP = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Affine CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__AFFINE_CS = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Cartesian CS Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__CARTESIAN_CS_GROUP = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Cartesian CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__CARTESIAN_CS = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Cylindrical CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__CYLINDRICAL_CS = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Linear CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__LINEAR_CS = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Polar CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__POLAR_CS = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Spherical CS Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__SPHERICAL_CS_GROUP = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Spherical CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__SPHERICAL_CS = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>User Defined CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__USER_DEFINED_CS = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Coordinate System Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__COORDINATE_SYSTEM_GROUP = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Coordinate System</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__COORDINATE_SYSTEM = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Engineering Datum Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__ENGINEERING_DATUM_GROUP = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Engineering Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE__ENGINEERING_DATUM = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 13;

	/**
	 * The number of structural features of the '<em>Engineering CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE_FEATURE_COUNT = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 14;

	/**
	 * The number of operations of the '<em>Engineering CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_CRS_TYPE_OPERATION_COUNT = ABSTRACT_CRS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.EngineeringDatumPropertyTypeImpl <em>Engineering Datum Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.EngineeringDatumPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getEngineeringDatumPropertyType()
	 * @generated
	 */
	int ENGINEERING_DATUM_PROPERTY_TYPE = 144;

	/**
	 * The feature id for the '<em><b>Engineering Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_PROPERTY_TYPE__ENGINEERING_DATUM = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Engineering Datum Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Engineering Datum Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.EngineeringDatumTypeImpl <em>Engineering Datum Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.EngineeringDatumTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getEngineeringDatumType()
	 * @generated
	 */
	int ENGINEERING_DATUM_TYPE = 145;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_TYPE__META_DATA_PROPERTY = ABSTRACT_DATUM_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_TYPE__DESCRIPTION = ABSTRACT_DATUM_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_DATUM_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_TYPE__IDENTIFIER = ABSTRACT_DATUM_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_TYPE__NAME = ABSTRACT_DATUM_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_TYPE__ID = ABSTRACT_DATUM_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_TYPE__REMARKS = ABSTRACT_DATUM_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_DATUM_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_TYPE__SCOPE = ABSTRACT_DATUM_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Anchor Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_TYPE__ANCHOR_DEFINITION = ABSTRACT_DATUM_TYPE__ANCHOR_DEFINITION;

	/**
	 * The feature id for the '<em><b>Realization Epoch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_TYPE__REALIZATION_EPOCH = ABSTRACT_DATUM_TYPE__REALIZATION_EPOCH;

	/**
	 * The number of structural features of the '<em>Engineering Datum Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_TYPE_FEATURE_COUNT = ABSTRACT_DATUM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Engineering Datum Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENGINEERING_DATUM_TYPE_OPERATION_COUNT = ABSTRACT_DATUM_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.EnvelopeTypeImpl <em>Envelope Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.EnvelopeTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getEnvelopeType()
	 * @generated
	 */
	int ENVELOPE_TYPE = 146;

	/**
	 * The feature id for the '<em><b>Lower Corner</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_TYPE__LOWER_CORNER = 0;

	/**
	 * The feature id for the '<em><b>Upper Corner</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_TYPE__UPPER_CORNER = 1;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_TYPE__POS = 2;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_TYPE__COORDINATES = 3;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_TYPE__AXIS_LABELS = 4;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_TYPE__SRS_DIMENSION = 5;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_TYPE__SRS_NAME = 6;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_TYPE__UOM_LABELS = 7;

	/**
	 * The number of structural features of the '<em>Envelope Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_TYPE_FEATURE_COUNT = 8;

	/**
	 * The number of operations of the '<em>Envelope Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.EnvelopeWithTimePeriodTypeImpl <em>Envelope With Time Period Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.EnvelopeWithTimePeriodTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getEnvelopeWithTimePeriodType()
	 * @generated
	 */
	int ENVELOPE_WITH_TIME_PERIOD_TYPE = 147;

	/**
	 * The feature id for the '<em><b>Lower Corner</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_WITH_TIME_PERIOD_TYPE__LOWER_CORNER = ENVELOPE_TYPE__LOWER_CORNER;

	/**
	 * The feature id for the '<em><b>Upper Corner</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_WITH_TIME_PERIOD_TYPE__UPPER_CORNER = ENVELOPE_TYPE__UPPER_CORNER;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_WITH_TIME_PERIOD_TYPE__POS = ENVELOPE_TYPE__POS;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_WITH_TIME_PERIOD_TYPE__COORDINATES = ENVELOPE_TYPE__COORDINATES;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_WITH_TIME_PERIOD_TYPE__AXIS_LABELS = ENVELOPE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_WITH_TIME_PERIOD_TYPE__SRS_DIMENSION = ENVELOPE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_WITH_TIME_PERIOD_TYPE__SRS_NAME = ENVELOPE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_WITH_TIME_PERIOD_TYPE__UOM_LABELS = ENVELOPE_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Begin Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_WITH_TIME_PERIOD_TYPE__BEGIN_POSITION = ENVELOPE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_WITH_TIME_PERIOD_TYPE__END_POSITION = ENVELOPE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Frame</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_WITH_TIME_PERIOD_TYPE__FRAME = ENVELOPE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Envelope With Time Period Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_WITH_TIME_PERIOD_TYPE_FEATURE_COUNT = ENVELOPE_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Envelope With Time Period Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ENVELOPE_WITH_TIME_PERIOD_TYPE_OPERATION_COUNT = ENVELOPE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.FaceOrTopoSolidPropertyTypeImpl <em>Face Or Topo Solid Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.FaceOrTopoSolidPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getFaceOrTopoSolidPropertyType()
	 * @generated
	 */
	int FACE_OR_TOPO_SOLID_PROPERTY_TYPE = 148;

	/**
	 * The feature id for the '<em><b>Face</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_OR_TOPO_SOLID_PROPERTY_TYPE__FACE = 0;

	/**
	 * The feature id for the '<em><b>Topo Solid</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_OR_TOPO_SOLID_PROPERTY_TYPE__TOPO_SOLID = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_OR_TOPO_SOLID_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_OR_TOPO_SOLID_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_OR_TOPO_SOLID_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_OR_TOPO_SOLID_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_OR_TOPO_SOLID_PROPERTY_TYPE__OWNS = 6;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_OR_TOPO_SOLID_PROPERTY_TYPE__REMOTE_SCHEMA = 7;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_OR_TOPO_SOLID_PROPERTY_TYPE__ROLE = 8;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_OR_TOPO_SOLID_PROPERTY_TYPE__SHOW = 9;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_OR_TOPO_SOLID_PROPERTY_TYPE__TITLE = 10;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_OR_TOPO_SOLID_PROPERTY_TYPE__TYPE = 11;

	/**
	 * The number of structural features of the '<em>Face Or Topo Solid Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_OR_TOPO_SOLID_PROPERTY_TYPE_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Face Or Topo Solid Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_OR_TOPO_SOLID_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.FaceTypeImpl <em>Face Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.FaceTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getFaceType()
	 * @generated
	 */
	int FACE_TYPE = 149;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_TYPE__META_DATA_PROPERTY = ABSTRACT_TOPO_PRIMITIVE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_TYPE__DESCRIPTION = ABSTRACT_TOPO_PRIMITIVE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_TOPO_PRIMITIVE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_TYPE__IDENTIFIER = ABSTRACT_TOPO_PRIMITIVE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_TYPE__NAME = ABSTRACT_TOPO_PRIMITIVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_TYPE__ID = ABSTRACT_TOPO_PRIMITIVE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Isolated</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_TYPE__ISOLATED = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Directed Edge</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_TYPE__DIRECTED_EDGE = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Directed Topo Solid</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_TYPE__DIRECTED_TOPO_SOLID = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Surface Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_TYPE__SURFACE_PROPERTY = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_TYPE__AGGREGATION_TYPE = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Universal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_TYPE__UNIVERSAL = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Face Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_TYPE_FEATURE_COUNT = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>Face Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FACE_TYPE_OPERATION_COUNT = ABSTRACT_TOPO_PRIMITIVE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.FeatureArrayPropertyTypeImpl <em>Feature Array Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.FeatureArrayPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getFeatureArrayPropertyType()
	 * @generated
	 */
	int FEATURE_ARRAY_PROPERTY_TYPE = 150;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_ARRAY_PROPERTY_TYPE__GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Feature Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_ARRAY_PROPERTY_TYPE__ABSTRACT_FEATURE_GROUP = 1;

	/**
	 * The feature id for the '<em><b>Abstract Feature</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_ARRAY_PROPERTY_TYPE__ABSTRACT_FEATURE = 2;

	/**
	 * The number of structural features of the '<em>Feature Array Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_ARRAY_PROPERTY_TYPE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Feature Array Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_ARRAY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.FeatureCollectionTypeImpl <em>Feature Collection Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.FeatureCollectionTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getFeatureCollectionType()
	 * @generated
	 */
	int FEATURE_COLLECTION_TYPE = 151;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLLECTION_TYPE__META_DATA_PROPERTY = ABSTRACT_FEATURE_COLLECTION_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLLECTION_TYPE__DESCRIPTION = ABSTRACT_FEATURE_COLLECTION_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLLECTION_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_FEATURE_COLLECTION_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLLECTION_TYPE__IDENTIFIER = ABSTRACT_FEATURE_COLLECTION_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLLECTION_TYPE__NAME = ABSTRACT_FEATURE_COLLECTION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLLECTION_TYPE__ID = ABSTRACT_FEATURE_COLLECTION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Bounded By</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLLECTION_TYPE__BOUNDED_BY = ABSTRACT_FEATURE_COLLECTION_TYPE__BOUNDED_BY;

	/**
	 * The feature id for the '<em><b>Location Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLLECTION_TYPE__LOCATION_GROUP = ABSTRACT_FEATURE_COLLECTION_TYPE__LOCATION_GROUP;

	/**
	 * The feature id for the '<em><b>Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLLECTION_TYPE__LOCATION = ABSTRACT_FEATURE_COLLECTION_TYPE__LOCATION;

	/**
	 * The feature id for the '<em><b>Feature Member</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLLECTION_TYPE__FEATURE_MEMBER = ABSTRACT_FEATURE_COLLECTION_TYPE__FEATURE_MEMBER;

	/**
	 * The feature id for the '<em><b>Feature Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLLECTION_TYPE__FEATURE_MEMBERS = ABSTRACT_FEATURE_COLLECTION_TYPE__FEATURE_MEMBERS;

	/**
	 * The number of structural features of the '<em>Feature Collection Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLLECTION_TYPE_FEATURE_COUNT = ABSTRACT_FEATURE_COLLECTION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Feature Collection Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLLECTION_TYPE_OPERATION_COUNT = ABSTRACT_FEATURE_COLLECTION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.FeaturePropertyTypeImpl <em>Feature Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.FeaturePropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getFeaturePropertyType()
	 * @generated
	 */
	int FEATURE_PROPERTY_TYPE = 152;

	/**
	 * The feature id for the '<em><b>Abstract Feature Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY_TYPE__ABSTRACT_FEATURE_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Feature</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY_TYPE__ABSTRACT_FEATURE = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY_TYPE__OWNS = 6;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY_TYPE__REMOTE_SCHEMA = 7;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY_TYPE__ROLE = 8;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY_TYPE__SHOW = 9;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY_TYPE__TITLE = 10;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY_TYPE__TYPE = 11;

	/**
	 * The number of structural features of the '<em>Feature Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY_TYPE_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Feature Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.FileTypeImpl <em>File Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.FileTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getFileType()
	 * @generated
	 */
	int FILE_TYPE = 153;

	/**
	 * The feature id for the '<em><b>Range Parameters</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE_TYPE__RANGE_PARAMETERS = 0;

	/**
	 * The feature id for the '<em><b>File Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE_TYPE__FILE_NAME = 1;

	/**
	 * The feature id for the '<em><b>File Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE_TYPE__FILE_REFERENCE = 2;

	/**
	 * The feature id for the '<em><b>File Structure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE_TYPE__FILE_STRUCTURE = 3;

	/**
	 * The feature id for the '<em><b>Mime Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE_TYPE__MIME_TYPE = 4;

	/**
	 * The feature id for the '<em><b>Compression</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE_TYPE__COMPRESSION = 5;

	/**
	 * The number of structural features of the '<em>File Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE_TYPE_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>File Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.FormulaCitationTypeImpl <em>Formula Citation Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.FormulaCitationTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getFormulaCitationType()
	 * @generated
	 */
	int FORMULA_CITATION_TYPE = 154;

	/**
	 * The feature id for the '<em><b>CI Citation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_CITATION_TYPE__CI_CITATION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_CITATION_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_CITATION_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_CITATION_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_CITATION_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_CITATION_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_CITATION_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_CITATION_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_CITATION_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_CITATION_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Formula Citation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_CITATION_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Formula Citation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_CITATION_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.FormulaTypeImpl <em>Formula Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.FormulaTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getFormulaType()
	 * @generated
	 */
	int FORMULA_TYPE = 155;

	/**
	 * The feature id for the '<em><b>A</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_TYPE__A = 0;

	/**
	 * The feature id for the '<em><b>B</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_TYPE__B = 1;

	/**
	 * The feature id for the '<em><b>C</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_TYPE__C = 2;

	/**
	 * The feature id for the '<em><b>D</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_TYPE__D = 3;

	/**
	 * The number of structural features of the '<em>Formula Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_TYPE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Formula Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GeneralConversionPropertyTypeImpl <em>General Conversion Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GeneralConversionPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGeneralConversionPropertyType()
	 * @generated
	 */
	int GENERAL_CONVERSION_PROPERTY_TYPE = 156;

	/**
	 * The feature id for the '<em><b>Abstract General Conversion Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_CONVERSION_PROPERTY_TYPE__ABSTRACT_GENERAL_CONVERSION_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract General Conversion</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_CONVERSION_PROPERTY_TYPE__ABSTRACT_GENERAL_CONVERSION = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_CONVERSION_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_CONVERSION_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_CONVERSION_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_CONVERSION_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_CONVERSION_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_CONVERSION_PROPERTY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_CONVERSION_PROPERTY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_CONVERSION_PROPERTY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_CONVERSION_PROPERTY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>General Conversion Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_CONVERSION_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>General Conversion Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_CONVERSION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GeneralTransformationPropertyTypeImpl <em>General Transformation Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GeneralTransformationPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGeneralTransformationPropertyType()
	 * @generated
	 */
	int GENERAL_TRANSFORMATION_PROPERTY_TYPE = 157;

	/**
	 * The feature id for the '<em><b>Abstract General Transformation Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_TRANSFORMATION_PROPERTY_TYPE__ABSTRACT_GENERAL_TRANSFORMATION_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract General Transformation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_TRANSFORMATION_PROPERTY_TYPE__ABSTRACT_GENERAL_TRANSFORMATION = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_TRANSFORMATION_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_TRANSFORMATION_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_TRANSFORMATION_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_TRANSFORMATION_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_TRANSFORMATION_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_TRANSFORMATION_PROPERTY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_TRANSFORMATION_PROPERTY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_TRANSFORMATION_PROPERTY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_TRANSFORMATION_PROPERTY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>General Transformation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_TRANSFORMATION_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>General Transformation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERAL_TRANSFORMATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GenericMetaDataTypeImpl <em>Generic Meta Data Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GenericMetaDataTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGenericMetaDataType()
	 * @generated
	 */
	int GENERIC_META_DATA_TYPE = 158;

	/**
	 * The feature id for the '<em><b>Mixed</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_META_DATA_TYPE__MIXED = ABSTRACT_META_DATA_TYPE__MIXED;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_META_DATA_TYPE__ID = ABSTRACT_META_DATA_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Any</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_META_DATA_TYPE__ANY = ABSTRACT_META_DATA_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Generic Meta Data Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_META_DATA_TYPE_FEATURE_COUNT = ABSTRACT_META_DATA_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Generic Meta Data Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_META_DATA_TYPE_OPERATION_COUNT = ABSTRACT_META_DATA_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GeocentricCRSPropertyTypeImpl <em>Geocentric CRS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GeocentricCRSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGeocentricCRSPropertyType()
	 * @generated
	 */
	int GEOCENTRIC_CRS_PROPERTY_TYPE = 159;

	/**
	 * The feature id for the '<em><b>Geocentric CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_PROPERTY_TYPE__GEOCENTRIC_CRS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Geocentric CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Geocentric CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GeocentricCRSTypeImpl <em>Geocentric CRS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GeocentricCRSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGeocentricCRSType()
	 * @generated
	 */
	int GEOCENTRIC_CRS_TYPE = 160;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_TYPE__META_DATA_PROPERTY = ABSTRACT_CRS_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_TYPE__DESCRIPTION = ABSTRACT_CRS_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_CRS_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_TYPE__IDENTIFIER = ABSTRACT_CRS_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_TYPE__NAME = ABSTRACT_CRS_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_TYPE__ID = ABSTRACT_CRS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_TYPE__REMARKS = ABSTRACT_CRS_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_CRS_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_TYPE__SCOPE = ABSTRACT_CRS_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Uses Cartesian CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_TYPE__USES_CARTESIAN_CS = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Uses Spherical CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_TYPE__USES_SPHERICAL_CS = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Uses Geodetic Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_TYPE__USES_GEODETIC_DATUM = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Geocentric CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_TYPE_FEATURE_COUNT = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Geocentric CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOCENTRIC_CRS_TYPE_OPERATION_COUNT = ABSTRACT_CRS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GeodesicStringTypeImpl <em>Geodesic String Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GeodesicStringTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGeodesicStringType()
	 * @generated
	 */
	int GEODESIC_STRING_TYPE = 161;

	/**
	 * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_STRING_TYPE__NUM_DERIVATIVE_INTERIOR = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR;

	/**
	 * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_STRING_TYPE__NUM_DERIVATIVES_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END;

	/**
	 * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_STRING_TYPE__NUM_DERIVATIVES_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START;

	/**
	 * The feature id for the '<em><b>Pos List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_STRING_TYPE__POS_LIST = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Geometric Position Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_STRING_TYPE__GEOMETRIC_POSITION_GROUP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_STRING_TYPE__POS = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_STRING_TYPE__POINT_PROPERTY = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_STRING_TYPE__INTERPOLATION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Geodesic String Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_STRING_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Geodesic String Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_STRING_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GeodesicTypeImpl <em>Geodesic Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GeodesicTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGeodesicType()
	 * @generated
	 */
	int GEODESIC_TYPE = 162;

	/**
	 * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_TYPE__NUM_DERIVATIVE_INTERIOR = GEODESIC_STRING_TYPE__NUM_DERIVATIVE_INTERIOR;

	/**
	 * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_TYPE__NUM_DERIVATIVES_AT_END = GEODESIC_STRING_TYPE__NUM_DERIVATIVES_AT_END;

	/**
	 * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_TYPE__NUM_DERIVATIVES_AT_START = GEODESIC_STRING_TYPE__NUM_DERIVATIVES_AT_START;

	/**
	 * The feature id for the '<em><b>Pos List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_TYPE__POS_LIST = GEODESIC_STRING_TYPE__POS_LIST;

	/**
	 * The feature id for the '<em><b>Geometric Position Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_TYPE__GEOMETRIC_POSITION_GROUP = GEODESIC_STRING_TYPE__GEOMETRIC_POSITION_GROUP;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_TYPE__POS = GEODESIC_STRING_TYPE__POS;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_TYPE__POINT_PROPERTY = GEODESIC_STRING_TYPE__POINT_PROPERTY;

	/**
	 * The feature id for the '<em><b>Interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_TYPE__INTERPOLATION = GEODESIC_STRING_TYPE__INTERPOLATION;

	/**
	 * The number of structural features of the '<em>Geodesic Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_TYPE_FEATURE_COUNT = GEODESIC_STRING_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Geodesic Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODESIC_TYPE_OPERATION_COUNT = GEODESIC_STRING_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GeodeticCRSPropertyTypeImpl <em>Geodetic CRS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GeodeticCRSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGeodeticCRSPropertyType()
	 * @generated
	 */
	int GEODETIC_CRS_PROPERTY_TYPE = 163;

	/**
	 * The feature id for the '<em><b>Geodetic CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_PROPERTY_TYPE__GEODETIC_CRS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Geodetic CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Geodetic CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GeodeticCRSTypeImpl <em>Geodetic CRS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GeodeticCRSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGeodeticCRSType()
	 * @generated
	 */
	int GEODETIC_CRS_TYPE = 164;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE__META_DATA_PROPERTY = ABSTRACT_CRS_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE__DESCRIPTION = ABSTRACT_CRS_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_CRS_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE__IDENTIFIER = ABSTRACT_CRS_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE__NAME = ABSTRACT_CRS_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE__ID = ABSTRACT_CRS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE__REMARKS = ABSTRACT_CRS_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_CRS_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE__SCOPE = ABSTRACT_CRS_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Ellipsoidal CS Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE__ELLIPSOIDAL_CS_GROUP = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Ellipsoidal CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE__ELLIPSOIDAL_CS = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Cartesian CS Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE__CARTESIAN_CS_GROUP = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Cartesian CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE__CARTESIAN_CS = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Spherical CS Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE__SPHERICAL_CS_GROUP = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Spherical CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE__SPHERICAL_CS = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Geodetic Datum Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE__GEODETIC_DATUM_GROUP = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Geodetic Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE__GEODETIC_DATUM = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Geodetic CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE_FEATURE_COUNT = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>Geodetic CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_CRS_TYPE_OPERATION_COUNT = ABSTRACT_CRS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GeodeticDatumPropertyTypeImpl <em>Geodetic Datum Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GeodeticDatumPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGeodeticDatumPropertyType()
	 * @generated
	 */
	int GEODETIC_DATUM_PROPERTY_TYPE = 165;

	/**
	 * The feature id for the '<em><b>Geodetic Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_PROPERTY_TYPE__GEODETIC_DATUM = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Geodetic Datum Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Geodetic Datum Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GeodeticDatumTypeImpl <em>Geodetic Datum Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GeodeticDatumTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGeodeticDatumType()
	 * @generated
	 */
	int GEODETIC_DATUM_TYPE = 166;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_TYPE__META_DATA_PROPERTY = ABSTRACT_DATUM_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_TYPE__DESCRIPTION = ABSTRACT_DATUM_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_DATUM_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_TYPE__IDENTIFIER = ABSTRACT_DATUM_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_TYPE__NAME = ABSTRACT_DATUM_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_TYPE__ID = ABSTRACT_DATUM_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_TYPE__REMARKS = ABSTRACT_DATUM_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_DATUM_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_TYPE__SCOPE = ABSTRACT_DATUM_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Anchor Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_TYPE__ANCHOR_DEFINITION = ABSTRACT_DATUM_TYPE__ANCHOR_DEFINITION;

	/**
	 * The feature id for the '<em><b>Realization Epoch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_TYPE__REALIZATION_EPOCH = ABSTRACT_DATUM_TYPE__REALIZATION_EPOCH;

	/**
	 * The feature id for the '<em><b>Prime Meridian</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_TYPE__PRIME_MERIDIAN = ABSTRACT_DATUM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Ellipsoid</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_TYPE__ELLIPSOID = ABSTRACT_DATUM_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Geodetic Datum Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_TYPE_FEATURE_COUNT = ABSTRACT_DATUM_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Geodetic Datum Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEODETIC_DATUM_TYPE_OPERATION_COUNT = ABSTRACT_DATUM_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GeographicCRSPropertyTypeImpl <em>Geographic CRS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GeographicCRSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGeographicCRSPropertyType()
	 * @generated
	 */
	int GEOGRAPHIC_CRS_PROPERTY_TYPE = 167;

	/**
	 * The feature id for the '<em><b>Geographic CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_PROPERTY_TYPE__GEOGRAPHIC_CRS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Geographic CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Geographic CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GeographicCRSTypeImpl <em>Geographic CRS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GeographicCRSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGeographicCRSType()
	 * @generated
	 */
	int GEOGRAPHIC_CRS_TYPE = 168;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_TYPE__META_DATA_PROPERTY = ABSTRACT_CRS_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_TYPE__DESCRIPTION = ABSTRACT_CRS_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_CRS_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_TYPE__IDENTIFIER = ABSTRACT_CRS_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_TYPE__NAME = ABSTRACT_CRS_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_TYPE__ID = ABSTRACT_CRS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_TYPE__REMARKS = ABSTRACT_CRS_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_CRS_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_TYPE__SCOPE = ABSTRACT_CRS_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Uses Ellipsoidal CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_TYPE__USES_ELLIPSOIDAL_CS = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Uses Geodetic Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_TYPE__USES_GEODETIC_DATUM = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Geographic CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_TYPE_FEATURE_COUNT = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Geographic CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOGRAPHIC_CRS_TYPE_OPERATION_COUNT = ABSTRACT_CRS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GeometricComplexPropertyTypeImpl <em>Geometric Complex Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GeometricComplexPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGeometricComplexPropertyType()
	 * @generated
	 */
	int GEOMETRIC_COMPLEX_PROPERTY_TYPE = 169;

	/**
	 * The feature id for the '<em><b>Geometric Complex</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_PROPERTY_TYPE__GEOMETRIC_COMPLEX = 0;

	/**
	 * The feature id for the '<em><b>Composite Curve</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_PROPERTY_TYPE__COMPOSITE_CURVE = 1;

	/**
	 * The feature id for the '<em><b>Composite Surface</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_PROPERTY_TYPE__COMPOSITE_SURFACE = 2;

	/**
	 * The feature id for the '<em><b>Composite Solid</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_PROPERTY_TYPE__COMPOSITE_SOLID = 3;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_PROPERTY_TYPE__ACTUATE = 4;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_PROPERTY_TYPE__ARCROLE = 5;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_PROPERTY_TYPE__HREF = 6;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_PROPERTY_TYPE__NIL_REASON = 7;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_PROPERTY_TYPE__OWNS = 8;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_PROPERTY_TYPE__REMOTE_SCHEMA = 9;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_PROPERTY_TYPE__ROLE = 10;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_PROPERTY_TYPE__SHOW = 11;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_PROPERTY_TYPE__TITLE = 12;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_PROPERTY_TYPE__TYPE = 13;

	/**
	 * The number of structural features of the '<em>Geometric Complex Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_PROPERTY_TYPE_FEATURE_COUNT = 14;

	/**
	 * The number of operations of the '<em>Geometric Complex Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GeometricComplexTypeImpl <em>Geometric Complex Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GeometricComplexTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGeometricComplexType()
	 * @generated
	 */
	int GEOMETRIC_COMPLEX_TYPE = 170;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRY_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_TYPE__DESCRIPTION = ABSTRACT_GEOMETRY_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GEOMETRY_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_TYPE__IDENTIFIER = ABSTRACT_GEOMETRY_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_TYPE__NAME = ABSTRACT_GEOMETRY_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_TYPE__ID = ABSTRACT_GEOMETRY_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRY_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRY_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_TYPE__SRS_NAME = ABSTRACT_GEOMETRY_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_TYPE__UOM_LABELS = ABSTRACT_GEOMETRY_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_TYPE__ELEMENT = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_TYPE__AGGREGATION_TYPE = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Geometric Complex Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Geometric Complex Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_COMPLEX_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GeometricPrimitivePropertyTypeImpl <em>Geometric Primitive Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GeometricPrimitivePropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGeometricPrimitivePropertyType()
	 * @generated
	 */
	int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE = 171;

	/**
	 * The feature id for the '<em><b>Abstract Geometric Primitive Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__ABSTRACT_GEOMETRIC_PRIMITIVE_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Geometric Primitive</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__ABSTRACT_GEOMETRIC_PRIMITIVE = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__OWNS = 6;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__REMOTE_SCHEMA = 7;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__ROLE = 8;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__SHOW = 9;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__TITLE = 10;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE__TYPE = 11;

	/**
	 * The number of structural features of the '<em>Geometric Primitive Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Geometric Primitive Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRIC_PRIMITIVE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GeometryArrayPropertyTypeImpl <em>Geometry Array Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GeometryArrayPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGeometryArrayPropertyType()
	 * @generated
	 */
	int GEOMETRY_ARRAY_PROPERTY_TYPE = 172;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_ARRAY_PROPERTY_TYPE__GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Geometry Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_ARRAY_PROPERTY_TYPE__ABSTRACT_GEOMETRY_GROUP = 1;

	/**
	 * The feature id for the '<em><b>Abstract Geometry</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_ARRAY_PROPERTY_TYPE__ABSTRACT_GEOMETRY = 2;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_ARRAY_PROPERTY_TYPE__OWNS = 3;

	/**
	 * The number of structural features of the '<em>Geometry Array Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_ARRAY_PROPERTY_TYPE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Geometry Array Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_ARRAY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GeometryPropertyTypeImpl <em>Geometry Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GeometryPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGeometryPropertyType()
	 * @generated
	 */
	int GEOMETRY_PROPERTY_TYPE = 173;

	/**
	 * The feature id for the '<em><b>Abstract Geometry Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_PROPERTY_TYPE__ABSTRACT_GEOMETRY_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Geometry</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_PROPERTY_TYPE__ABSTRACT_GEOMETRY = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_PROPERTY_TYPE__OWNS = 6;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_PROPERTY_TYPE__REMOTE_SCHEMA = 7;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_PROPERTY_TYPE__ROLE = 8;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_PROPERTY_TYPE__SHOW = 9;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_PROPERTY_TYPE__TITLE = 10;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_PROPERTY_TYPE__TYPE = 11;

	/**
	 * The number of structural features of the '<em>Geometry Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_PROPERTY_TYPE_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Geometry Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GridEnvelopeTypeImpl <em>Grid Envelope Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GridEnvelopeTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGridEnvelopeType()
	 * @generated
	 */
	int GRID_ENVELOPE_TYPE = 174;

	/**
	 * The feature id for the '<em><b>Low</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_ENVELOPE_TYPE__LOW = 0;

	/**
	 * The feature id for the '<em><b>High</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_ENVELOPE_TYPE__HIGH = 1;

	/**
	 * The number of structural features of the '<em>Grid Envelope Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_ENVELOPE_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Grid Envelope Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_ENVELOPE_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GridFunctionTypeImpl <em>Grid Function Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GridFunctionTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGridFunctionType()
	 * @generated
	 */
	int GRID_FUNCTION_TYPE = 175;

	/**
	 * The feature id for the '<em><b>Sequence Rule</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_FUNCTION_TYPE__SEQUENCE_RULE = 0;

	/**
	 * The feature id for the '<em><b>Start Point</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_FUNCTION_TYPE__START_POINT = 1;

	/**
	 * The number of structural features of the '<em>Grid Function Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_FUNCTION_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Grid Function Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_FUNCTION_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GridLengthTypeImpl <em>Grid Length Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GridLengthTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGridLengthType()
	 * @generated
	 */
	int GRID_LENGTH_TYPE = 176;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_LENGTH_TYPE__VALUE = MEASURE_TYPE__VALUE;

	/**
	 * The feature id for the '<em><b>Uom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_LENGTH_TYPE__UOM = MEASURE_TYPE__UOM;

	/**
	 * The number of structural features of the '<em>Grid Length Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_LENGTH_TYPE_FEATURE_COUNT = MEASURE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Grid Length Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_LENGTH_TYPE_OPERATION_COUNT = MEASURE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GridLimitsTypeImpl <em>Grid Limits Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GridLimitsTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGridLimitsType()
	 * @generated
	 */
	int GRID_LIMITS_TYPE = 177;

	/**
	 * The feature id for the '<em><b>Grid Envelope</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_LIMITS_TYPE__GRID_ENVELOPE = 0;

	/**
	 * The number of structural features of the '<em>Grid Limits Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_LIMITS_TYPE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Grid Limits Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_LIMITS_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.GridTypeImpl <em>Grid Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.GridTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getGridType()
	 * @generated
	 */
	int GRID_TYPE = 178;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRY_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_TYPE__DESCRIPTION = ABSTRACT_GEOMETRY_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GEOMETRY_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_TYPE__IDENTIFIER = ABSTRACT_GEOMETRY_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_TYPE__NAME = ABSTRACT_GEOMETRY_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_TYPE__ID = ABSTRACT_GEOMETRY_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRY_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRY_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_TYPE__SRS_NAME = ABSTRACT_GEOMETRY_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_TYPE__UOM_LABELS = ABSTRACT_GEOMETRY_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Limits</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_TYPE__LIMITS = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Axis Labels1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_TYPE__AXIS_LABELS1 = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Axis Name</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_TYPE__AXIS_NAME = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_TYPE__DIMENSION = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Grid Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRY_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Grid Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRID_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.HistoryPropertyTypeImpl <em>History Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.HistoryPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getHistoryPropertyType()
	 * @generated
	 */
	int HISTORY_PROPERTY_TYPE = 179;

	/**
	 * The feature id for the '<em><b>Abstract Time Slice Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HISTORY_PROPERTY_TYPE__ABSTRACT_TIME_SLICE_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Time Slice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HISTORY_PROPERTY_TYPE__ABSTRACT_TIME_SLICE = 1;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HISTORY_PROPERTY_TYPE__OWNS = 2;

	/**
	 * The number of structural features of the '<em>History Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HISTORY_PROPERTY_TYPE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>History Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HISTORY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ImageCRSPropertyTypeImpl <em>Image CRS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ImageCRSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getImageCRSPropertyType()
	 * @generated
	 */
	int IMAGE_CRS_PROPERTY_TYPE = 181;

	/**
	 * The feature id for the '<em><b>Image CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_PROPERTY_TYPE__IMAGE_CRS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Image CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Image CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ImageCRSTypeImpl <em>Image CRS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ImageCRSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getImageCRSType()
	 * @generated
	 */
	int IMAGE_CRS_TYPE = 182;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_TYPE__META_DATA_PROPERTY = ABSTRACT_CRS_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_TYPE__DESCRIPTION = ABSTRACT_CRS_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_CRS_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_TYPE__IDENTIFIER = ABSTRACT_CRS_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_TYPE__NAME = ABSTRACT_CRS_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_TYPE__ID = ABSTRACT_CRS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_TYPE__REMARKS = ABSTRACT_CRS_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_CRS_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_TYPE__SCOPE = ABSTRACT_CRS_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Cartesian CS Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_TYPE__CARTESIAN_CS_GROUP = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Cartesian CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_TYPE__CARTESIAN_CS = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Affine CS Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_TYPE__AFFINE_CS_GROUP = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Affine CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_TYPE__AFFINE_CS = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Uses Oblique Cartesian CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_TYPE__USES_OBLIQUE_CARTESIAN_CS = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Image Datum Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_TYPE__IMAGE_DATUM_GROUP = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Image Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_TYPE__IMAGE_DATUM = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Image CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_TYPE_FEATURE_COUNT = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of operations of the '<em>Image CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_CRS_TYPE_OPERATION_COUNT = ABSTRACT_CRS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ImageDatumPropertyTypeImpl <em>Image Datum Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ImageDatumPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getImageDatumPropertyType()
	 * @generated
	 */
	int IMAGE_DATUM_PROPERTY_TYPE = 183;

	/**
	 * The feature id for the '<em><b>Image Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_PROPERTY_TYPE__IMAGE_DATUM = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Image Datum Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Image Datum Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ImageDatumTypeImpl <em>Image Datum Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ImageDatumTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getImageDatumType()
	 * @generated
	 */
	int IMAGE_DATUM_TYPE = 184;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_TYPE__META_DATA_PROPERTY = ABSTRACT_DATUM_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_TYPE__DESCRIPTION = ABSTRACT_DATUM_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_DATUM_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_TYPE__IDENTIFIER = ABSTRACT_DATUM_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_TYPE__NAME = ABSTRACT_DATUM_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_TYPE__ID = ABSTRACT_DATUM_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_TYPE__REMARKS = ABSTRACT_DATUM_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_DATUM_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_TYPE__SCOPE = ABSTRACT_DATUM_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Anchor Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_TYPE__ANCHOR_DEFINITION = ABSTRACT_DATUM_TYPE__ANCHOR_DEFINITION;

	/**
	 * The feature id for the '<em><b>Realization Epoch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_TYPE__REALIZATION_EPOCH = ABSTRACT_DATUM_TYPE__REALIZATION_EPOCH;

	/**
	 * The feature id for the '<em><b>Pixel In Cell</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_TYPE__PIXEL_IN_CELL = ABSTRACT_DATUM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Image Datum Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_TYPE_FEATURE_COUNT = ABSTRACT_DATUM_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Image Datum Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_DATUM_TYPE_OPERATION_COUNT = ABSTRACT_DATUM_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.IndirectEntryTypeImpl <em>Indirect Entry Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.IndirectEntryTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getIndirectEntryType()
	 * @generated
	 */
	int INDIRECT_ENTRY_TYPE = 185;

	/**
	 * The feature id for the '<em><b>Definition Proxy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDIRECT_ENTRY_TYPE__DEFINITION_PROXY = 0;

	/**
	 * The number of structural features of the '<em>Indirect Entry Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDIRECT_ENTRY_TYPE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Indirect Entry Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INDIRECT_ENTRY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.InlinePropertyTypeImpl <em>Inline Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.InlinePropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getInlinePropertyType()
	 * @generated
	 */
	int INLINE_PROPERTY_TYPE = 186;

	/**
	 * The feature id for the '<em><b>Any</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_PROPERTY_TYPE__ANY = 0;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_PROPERTY_TYPE__OWNS = 1;

	/**
	 * The number of structural features of the '<em>Inline Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Inline Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INLINE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.KnotPropertyTypeImpl <em>Knot Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.KnotPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getKnotPropertyType()
	 * @generated
	 */
	int KNOT_PROPERTY_TYPE = 187;

	/**
	 * The feature id for the '<em><b>Knot</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KNOT_PROPERTY_TYPE__KNOT = 0;

	/**
	 * The number of structural features of the '<em>Knot Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KNOT_PROPERTY_TYPE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Knot Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KNOT_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.KnotTypeImpl <em>Knot Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.KnotTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getKnotType()
	 * @generated
	 */
	int KNOT_TYPE = 188;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KNOT_TYPE__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Multiplicity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KNOT_TYPE__MULTIPLICITY = 1;

	/**
	 * The feature id for the '<em><b>Weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KNOT_TYPE__WEIGHT = 2;

	/**
	 * The number of structural features of the '<em>Knot Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KNOT_TYPE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Knot Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int KNOT_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.LengthTypeImpl <em>Length Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.LengthTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getLengthType()
	 * @generated
	 */
	int LENGTH_TYPE = 189;

	/**
	 * The number of structural features of the '<em>Length Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LENGTH_TYPE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Length Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LENGTH_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.LinearCSPropertyTypeImpl <em>Linear CS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.LinearCSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getLinearCSPropertyType()
	 * @generated
	 */
	int LINEAR_CS_PROPERTY_TYPE = 190;

	/**
	 * The feature id for the '<em><b>Linear CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_PROPERTY_TYPE__LINEAR_CS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Linear CS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Linear CS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.LinearCSTypeImpl <em>Linear CS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.LinearCSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getLinearCSType()
	 * @generated
	 */
	int LINEAR_CS_TYPE = 191;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_SYSTEM_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_TYPE__IDENTIFIER = ABSTRACT_COORDINATE_SYSTEM_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_TYPE__NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_TYPE__ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_TYPE__REMARKS = ABSTRACT_COORDINATE_SYSTEM_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Axis Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_TYPE__AXIS_GROUP = ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS_GROUP;

	/**
	 * The feature id for the '<em><b>Axis</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_TYPE__AXIS = ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_TYPE__AGGREGATION_TYPE = ABSTRACT_COORDINATE_SYSTEM_TYPE__AGGREGATION_TYPE;

	/**
	 * The number of structural features of the '<em>Linear CS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Linear CS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_CS_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.LinearRingPropertyTypeImpl <em>Linear Ring Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.LinearRingPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getLinearRingPropertyType()
	 * @generated
	 */
	int LINEAR_RING_PROPERTY_TYPE = 192;

	/**
	 * The feature id for the '<em><b>Linear Ring</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_PROPERTY_TYPE__LINEAR_RING = 0;

	/**
	 * The number of structural features of the '<em>Linear Ring Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_PROPERTY_TYPE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Linear Ring Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.LinearRingTypeImpl <em>Linear Ring Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.LinearRingTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getLinearRingType()
	 * @generated
	 */
	int LINEAR_RING_TYPE = 193;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_TYPE__META_DATA_PROPERTY = ABSTRACT_RING_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_TYPE__DESCRIPTION = ABSTRACT_RING_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_RING_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_TYPE__IDENTIFIER = ABSTRACT_RING_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_TYPE__NAME = ABSTRACT_RING_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_TYPE__ID = ABSTRACT_RING_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_TYPE__AXIS_LABELS = ABSTRACT_RING_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_TYPE__SRS_DIMENSION = ABSTRACT_RING_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_TYPE__SRS_NAME = ABSTRACT_RING_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_TYPE__UOM_LABELS = ABSTRACT_RING_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_TYPE__GROUP = ABSTRACT_RING_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_TYPE__POS = ABSTRACT_RING_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_TYPE__POINT_PROPERTY = ABSTRACT_RING_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_TYPE__POINT_REP = ABSTRACT_RING_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Pos List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_TYPE__POS_LIST = ABSTRACT_RING_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_TYPE__COORDINATES = ABSTRACT_RING_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Linear Ring Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_TYPE_FEATURE_COUNT = ABSTRACT_RING_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>Linear Ring Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINEAR_RING_TYPE_OPERATION_COUNT = ABSTRACT_RING_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.LineStringSegmentArrayPropertyTypeImpl <em>Line String Segment Array Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.LineStringSegmentArrayPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getLineStringSegmentArrayPropertyType()
	 * @generated
	 */
	int LINE_STRING_SEGMENT_ARRAY_PROPERTY_TYPE = 194;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_SEGMENT_ARRAY_PROPERTY_TYPE__GROUP = 0;

	/**
	 * The feature id for the '<em><b>Line String Segment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_SEGMENT_ARRAY_PROPERTY_TYPE__LINE_STRING_SEGMENT = 1;

	/**
	 * The number of structural features of the '<em>Line String Segment Array Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_SEGMENT_ARRAY_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Line String Segment Array Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_SEGMENT_ARRAY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.LineStringSegmentTypeImpl <em>Line String Segment Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.LineStringSegmentTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getLineStringSegmentType()
	 * @generated
	 */
	int LINE_STRING_SEGMENT_TYPE = 195;

	/**
	 * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR;

	/**
	 * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END;

	/**
	 * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_SEGMENT_TYPE__GROUP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_SEGMENT_TYPE__POS = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_SEGMENT_TYPE__POINT_PROPERTY = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_SEGMENT_TYPE__POINT_REP = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Pos List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_SEGMENT_TYPE__POS_LIST = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_SEGMENT_TYPE__COORDINATES = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_SEGMENT_TYPE__INTERPOLATION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Line String Segment Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_SEGMENT_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of operations of the '<em>Line String Segment Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_SEGMENT_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.LineStringTypeImpl <em>Line String Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.LineStringTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getLineStringType()
	 * @generated
	 */
	int LINE_STRING_TYPE = 196;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_TYPE__META_DATA_PROPERTY = ABSTRACT_CURVE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_TYPE__DESCRIPTION = ABSTRACT_CURVE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_CURVE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_TYPE__IDENTIFIER = ABSTRACT_CURVE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_TYPE__NAME = ABSTRACT_CURVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_TYPE__ID = ABSTRACT_CURVE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_TYPE__AXIS_LABELS = ABSTRACT_CURVE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_TYPE__SRS_DIMENSION = ABSTRACT_CURVE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_TYPE__SRS_NAME = ABSTRACT_CURVE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_TYPE__UOM_LABELS = ABSTRACT_CURVE_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_TYPE__GROUP = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_TYPE__POS = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_TYPE__POINT_PROPERTY = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Point Rep</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_TYPE__POINT_REP = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Pos List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_TYPE__POS_LIST = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_TYPE__COORDINATES = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Line String Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>Line String Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.LocationPropertyTypeImpl <em>Location Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.LocationPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getLocationPropertyType()
	 * @generated
	 */
	int LOCATION_PROPERTY_TYPE = 197;

	/**
	 * The feature id for the '<em><b>Abstract Geometry Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_PROPERTY_TYPE__ABSTRACT_GEOMETRY_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Geometry</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_PROPERTY_TYPE__ABSTRACT_GEOMETRY = 1;

	/**
	 * The feature id for the '<em><b>Location Key Word</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_PROPERTY_TYPE__LOCATION_KEY_WORD = 2;

	/**
	 * The feature id for the '<em><b>Location String</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_PROPERTY_TYPE__LOCATION_STRING = 3;

	/**
	 * The feature id for the '<em><b>Null</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_PROPERTY_TYPE__NULL = 4;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_PROPERTY_TYPE__ACTUATE = 5;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_PROPERTY_TYPE__ARCROLE = 6;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_PROPERTY_TYPE__HREF = 7;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_PROPERTY_TYPE__NIL_REASON = 8;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_PROPERTY_TYPE__REMOTE_SCHEMA = 9;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_PROPERTY_TYPE__ROLE = 10;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_PROPERTY_TYPE__SHOW = 11;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_PROPERTY_TYPE__TITLE = 12;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_PROPERTY_TYPE__TYPE = 13;

	/**
	 * The number of structural features of the '<em>Location Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_PROPERTY_TYPE_FEATURE_COUNT = 14;

	/**
	 * The number of operations of the '<em>Location Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.MappingRuleTypeImpl <em>Mapping Rule Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.MappingRuleTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getMappingRuleType()
	 * @generated
	 */
	int MAPPING_RULE_TYPE = 198;

	/**
	 * The feature id for the '<em><b>Rule Definition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_RULE_TYPE__RULE_DEFINITION = 0;

	/**
	 * The feature id for the '<em><b>Rule Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_RULE_TYPE__RULE_REFERENCE = 1;

	/**
	 * The number of structural features of the '<em>Mapping Rule Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_RULE_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Mapping Rule Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAPPING_RULE_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.MeasureListTypeImpl <em>Measure List Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.MeasureListTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getMeasureListType()
	 * @generated
	 */
	int MEASURE_LIST_TYPE = 199;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASURE_LIST_TYPE__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Uom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASURE_LIST_TYPE__UOM = 1;

	/**
	 * The number of structural features of the '<em>Measure List Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASURE_LIST_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Measure List Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASURE_LIST_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.MeasureOrNilReasonListTypeImpl <em>Measure Or Nil Reason List Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.MeasureOrNilReasonListTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getMeasureOrNilReasonListType()
	 * @generated
	 */
	int MEASURE_OR_NIL_REASON_LIST_TYPE = 200;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASURE_OR_NIL_REASON_LIST_TYPE__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Uom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASURE_OR_NIL_REASON_LIST_TYPE__UOM = 1;

	/**
	 * The number of structural features of the '<em>Measure Or Nil Reason List Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASURE_OR_NIL_REASON_LIST_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Measure Or Nil Reason List Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEASURE_OR_NIL_REASON_LIST_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.MetaDataPropertyTypeImpl <em>Meta Data Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.MetaDataPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getMetaDataPropertyType()
	 * @generated
	 */
	int META_DATA_PROPERTY_TYPE = 202;

	/**
	 * The feature id for the '<em><b>Abstract Meta Data Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_DATA_PROPERTY_TYPE__ABSTRACT_META_DATA_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Meta Data</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_DATA_PROPERTY_TYPE__ABSTRACT_META_DATA = 1;

	/**
	 * The feature id for the '<em><b>About</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_DATA_PROPERTY_TYPE__ABOUT = 2;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_DATA_PROPERTY_TYPE__ACTUATE = 3;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_DATA_PROPERTY_TYPE__ARCROLE = 4;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_DATA_PROPERTY_TYPE__HREF = 5;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_DATA_PROPERTY_TYPE__NIL_REASON = 6;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_DATA_PROPERTY_TYPE__REMOTE_SCHEMA = 7;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_DATA_PROPERTY_TYPE__ROLE = 8;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_DATA_PROPERTY_TYPE__SHOW = 9;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_DATA_PROPERTY_TYPE__TITLE = 10;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_DATA_PROPERTY_TYPE__TYPE = 11;

	/**
	 * The number of structural features of the '<em>Meta Data Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_DATA_PROPERTY_TYPE_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Meta Data Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int META_DATA_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.MovingObjectStatusTypeImpl <em>Moving Object Status Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.MovingObjectStatusTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getMovingObjectStatusType()
	 * @generated
	 */
	int MOVING_OBJECT_STATUS_TYPE = 203;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__META_DATA_PROPERTY = ABSTRACT_TIME_SLICE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__DESCRIPTION = ABSTRACT_TIME_SLICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_TIME_SLICE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__IDENTIFIER = ABSTRACT_TIME_SLICE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__NAME = ABSTRACT_TIME_SLICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__ID = ABSTRACT_TIME_SLICE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Valid Time</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__VALID_TIME = ABSTRACT_TIME_SLICE_TYPE__VALID_TIME;

	/**
	 * The feature id for the '<em><b>Data Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__DATA_SOURCE = ABSTRACT_TIME_SLICE_TYPE__DATA_SOURCE;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__POSITION = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__POS = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Location Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__LOCATION_NAME = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Location Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__LOCATION_REFERENCE = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Location Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__LOCATION_GROUP = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Location</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__LOCATION = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Speed</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__SPEED = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Bearing</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__BEARING = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Acceleration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__ACCELERATION = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Elevation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__ELEVATION = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Status</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__STATUS = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Status Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE__STATUS_REFERENCE = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>Moving Object Status Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE_FEATURE_COUNT = ABSTRACT_TIME_SLICE_TYPE_FEATURE_COUNT + 12;

	/**
	 * The number of operations of the '<em>Moving Object Status Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOVING_OBJECT_STATUS_TYPE_OPERATION_COUNT = ABSTRACT_TIME_SLICE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.MultiCurvePropertyTypeImpl <em>Multi Curve Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.MultiCurvePropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getMultiCurvePropertyType()
	 * @generated
	 */
	int MULTI_CURVE_PROPERTY_TYPE = 204;

	/**
	 * The feature id for the '<em><b>Multi Curve</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_PROPERTY_TYPE__MULTI_CURVE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_PROPERTY_TYPE__OWNS = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_PROPERTY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_PROPERTY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_PROPERTY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_PROPERTY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Multi Curve Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Multi Curve Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.MultiCurveTypeImpl <em>Multi Curve Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.MultiCurveTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getMultiCurveType()
	 * @generated
	 */
	int MULTI_CURVE_TYPE = 205;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_TYPE__IDENTIFIER = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_TYPE__NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_TYPE__ID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_TYPE__AGGREGATION_TYPE = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AGGREGATION_TYPE;

	/**
	 * The feature id for the '<em><b>Curve Member</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_TYPE__CURVE_MEMBER = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Curve Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_TYPE__CURVE_MEMBERS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Multi Curve Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Multi Curve Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_CURVE_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.MultiGeometryPropertyTypeImpl <em>Multi Geometry Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.MultiGeometryPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getMultiGeometryPropertyType()
	 * @generated
	 */
	int MULTI_GEOMETRY_PROPERTY_TYPE = 206;

	/**
	 * The feature id for the '<em><b>Abstract Geometric Aggregate Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_PROPERTY_TYPE__ABSTRACT_GEOMETRIC_AGGREGATE_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Geometric Aggregate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_PROPERTY_TYPE__ABSTRACT_GEOMETRIC_AGGREGATE = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_PROPERTY_TYPE__OWNS = 6;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_PROPERTY_TYPE__REMOTE_SCHEMA = 7;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_PROPERTY_TYPE__ROLE = 8;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_PROPERTY_TYPE__SHOW = 9;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_PROPERTY_TYPE__TITLE = 10;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_PROPERTY_TYPE__TYPE = 11;

	/**
	 * The number of structural features of the '<em>Multi Geometry Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_PROPERTY_TYPE_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Multi Geometry Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.MultiGeometryTypeImpl <em>Multi Geometry Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.MultiGeometryTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getMultiGeometryType()
	 * @generated
	 */
	int MULTI_GEOMETRY_TYPE = 207;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_TYPE__IDENTIFIER = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_TYPE__NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_TYPE__ID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_TYPE__AGGREGATION_TYPE = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AGGREGATION_TYPE;

	/**
	 * The feature id for the '<em><b>Geometry Member</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_TYPE__GEOMETRY_MEMBER = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Geometry Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_TYPE__GEOMETRY_MEMBERS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Multi Geometry Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Multi Geometry Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_GEOMETRY_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.MultiPointPropertyTypeImpl <em>Multi Point Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.MultiPointPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getMultiPointPropertyType()
	 * @generated
	 */
	int MULTI_POINT_PROPERTY_TYPE = 208;

	/**
	 * The feature id for the '<em><b>Multi Point</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_PROPERTY_TYPE__MULTI_POINT = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_PROPERTY_TYPE__OWNS = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_PROPERTY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_PROPERTY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_PROPERTY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_PROPERTY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Multi Point Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Multi Point Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.MultiPointTypeImpl <em>Multi Point Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.MultiPointTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getMultiPointType()
	 * @generated
	 */
	int MULTI_POINT_TYPE = 209;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_TYPE__IDENTIFIER = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_TYPE__NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_TYPE__ID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_TYPE__AGGREGATION_TYPE = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AGGREGATION_TYPE;

	/**
	 * The feature id for the '<em><b>Point Member</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_TYPE__POINT_MEMBER = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Point Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_TYPE__POINT_MEMBERS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Multi Point Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Multi Point Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.MultiSolidPropertyTypeImpl <em>Multi Solid Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.MultiSolidPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getMultiSolidPropertyType()
	 * @generated
	 */
	int MULTI_SOLID_PROPERTY_TYPE = 210;

	/**
	 * The feature id for the '<em><b>Multi Solid</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_PROPERTY_TYPE__MULTI_SOLID = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_PROPERTY_TYPE__OWNS = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_PROPERTY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_PROPERTY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_PROPERTY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_PROPERTY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Multi Solid Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Multi Solid Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.MultiSolidTypeImpl <em>Multi Solid Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.MultiSolidTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getMultiSolidType()
	 * @generated
	 */
	int MULTI_SOLID_TYPE = 211;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_TYPE__IDENTIFIER = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_TYPE__NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_TYPE__ID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_TYPE__AGGREGATION_TYPE = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AGGREGATION_TYPE;

	/**
	 * The feature id for the '<em><b>Solid Member</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_TYPE__SOLID_MEMBER = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Solid Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_TYPE__SOLID_MEMBERS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Multi Solid Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Multi Solid Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SOLID_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.MultiSurfacePropertyTypeImpl <em>Multi Surface Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.MultiSurfacePropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getMultiSurfacePropertyType()
	 * @generated
	 */
	int MULTI_SURFACE_PROPERTY_TYPE = 212;

	/**
	 * The feature id for the '<em><b>Multi Surface</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_PROPERTY_TYPE__MULTI_SURFACE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_PROPERTY_TYPE__OWNS = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_PROPERTY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_PROPERTY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_PROPERTY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_PROPERTY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Multi Surface Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Multi Surface Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.MultiSurfaceTypeImpl <em>Multi Surface Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.MultiSurfaceTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getMultiSurfaceType()
	 * @generated
	 */
	int MULTI_SURFACE_TYPE = 213;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_TYPE__IDENTIFIER = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_TYPE__NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_TYPE__ID = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_TYPE__AGGREGATION_TYPE = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE__AGGREGATION_TYPE;

	/**
	 * The feature id for the '<em><b>Surface Member</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_TYPE__SURFACE_MEMBER = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Surface Members</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_TYPE__SURFACE_MEMBERS = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Multi Surface Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Multi Surface Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_SURFACE_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_AGGREGATE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.NodeOrEdgePropertyTypeImpl <em>Node Or Edge Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.NodeOrEdgePropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getNodeOrEdgePropertyType()
	 * @generated
	 */
	int NODE_OR_EDGE_PROPERTY_TYPE = 214;

	/**
	 * The feature id for the '<em><b>Node</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_OR_EDGE_PROPERTY_TYPE__NODE = 0;

	/**
	 * The feature id for the '<em><b>Edge</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_OR_EDGE_PROPERTY_TYPE__EDGE = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_OR_EDGE_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_OR_EDGE_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_OR_EDGE_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_OR_EDGE_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_OR_EDGE_PROPERTY_TYPE__OWNS = 6;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_OR_EDGE_PROPERTY_TYPE__REMOTE_SCHEMA = 7;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_OR_EDGE_PROPERTY_TYPE__ROLE = 8;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_OR_EDGE_PROPERTY_TYPE__SHOW = 9;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_OR_EDGE_PROPERTY_TYPE__TITLE = 10;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_OR_EDGE_PROPERTY_TYPE__TYPE = 11;

	/**
	 * The number of structural features of the '<em>Node Or Edge Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_OR_EDGE_PROPERTY_TYPE_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Node Or Edge Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_OR_EDGE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.NodePropertyTypeImpl <em>Node Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.NodePropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getNodePropertyType()
	 * @generated
	 */
	int NODE_PROPERTY_TYPE = 215;

	/**
	 * The feature id for the '<em><b>Node</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_PROPERTY_TYPE__NODE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_PROPERTY_TYPE__OWNS = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_PROPERTY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_PROPERTY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_PROPERTY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_PROPERTY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Node Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Node Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.NodeTypeImpl <em>Node Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.NodeTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getNodeType()
	 * @generated
	 */
	int NODE_TYPE = 216;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_TYPE__META_DATA_PROPERTY = ABSTRACT_TOPO_PRIMITIVE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_TYPE__DESCRIPTION = ABSTRACT_TOPO_PRIMITIVE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_TOPO_PRIMITIVE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_TYPE__IDENTIFIER = ABSTRACT_TOPO_PRIMITIVE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_TYPE__NAME = ABSTRACT_TOPO_PRIMITIVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_TYPE__ID = ABSTRACT_TOPO_PRIMITIVE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Container</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_TYPE__CONTAINER = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Directed Edge</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_TYPE__DIRECTED_EDGE = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_TYPE__POINT_PROPERTY = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_TYPE__AGGREGATION_TYPE = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Node Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_TYPE_FEATURE_COUNT = ABSTRACT_TOPO_PRIMITIVE_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Node Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_TYPE_OPERATION_COUNT = ABSTRACT_TOPO_PRIMITIVE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ObliqueCartesianCSPropertyTypeImpl <em>Oblique Cartesian CS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ObliqueCartesianCSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getObliqueCartesianCSPropertyType()
	 * @generated
	 */
	int OBLIQUE_CARTESIAN_CS_PROPERTY_TYPE = 217;

	/**
	 * The feature id for the '<em><b>Oblique Cartesian CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_PROPERTY_TYPE__OBLIQUE_CARTESIAN_CS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Oblique Cartesian CS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Oblique Cartesian CS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ObliqueCartesianCSTypeImpl <em>Oblique Cartesian CS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ObliqueCartesianCSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getObliqueCartesianCSType()
	 * @generated
	 */
	int OBLIQUE_CARTESIAN_CS_TYPE = 218;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_SYSTEM_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_TYPE__IDENTIFIER = ABSTRACT_COORDINATE_SYSTEM_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_TYPE__NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_TYPE__ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_TYPE__REMARKS = ABSTRACT_COORDINATE_SYSTEM_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Axis Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_TYPE__AXIS_GROUP = ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS_GROUP;

	/**
	 * The feature id for the '<em><b>Axis</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_TYPE__AXIS = ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_TYPE__AGGREGATION_TYPE = ABSTRACT_COORDINATE_SYSTEM_TYPE__AGGREGATION_TYPE;

	/**
	 * The number of structural features of the '<em>Oblique Cartesian CS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Oblique Cartesian CS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBLIQUE_CARTESIAN_CS_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.OffsetCurveTypeImpl <em>Offset Curve Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.OffsetCurveTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getOffsetCurveType()
	 * @generated
	 */
	int OFFSET_CURVE_TYPE = 220;

	/**
	 * The feature id for the '<em><b>Num Derivative Interior</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OFFSET_CURVE_TYPE__NUM_DERIVATIVE_INTERIOR = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVE_INTERIOR;

	/**
	 * The feature id for the '<em><b>Num Derivatives At End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OFFSET_CURVE_TYPE__NUM_DERIVATIVES_AT_END = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_END;

	/**
	 * The feature id for the '<em><b>Num Derivatives At Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OFFSET_CURVE_TYPE__NUM_DERIVATIVES_AT_START = ABSTRACT_CURVE_SEGMENT_TYPE__NUM_DERIVATIVES_AT_START;

	/**
	 * The feature id for the '<em><b>Offset Base</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OFFSET_CURVE_TYPE__OFFSET_BASE = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Distance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OFFSET_CURVE_TYPE__DISTANCE = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Ref Direction</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OFFSET_CURVE_TYPE__REF_DIRECTION = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Offset Curve Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OFFSET_CURVE_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Offset Curve Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OFFSET_CURVE_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_SEGMENT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.OperationMethodPropertyTypeImpl <em>Operation Method Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.OperationMethodPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getOperationMethodPropertyType()
	 * @generated
	 */
	int OPERATION_METHOD_PROPERTY_TYPE = 221;

	/**
	 * The feature id for the '<em><b>Operation Method</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_PROPERTY_TYPE__OPERATION_METHOD = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Operation Method Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Operation Method Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.OperationMethodTypeImpl <em>Operation Method Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.OperationMethodTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getOperationMethodType()
	 * @generated
	 */
	int OPERATION_METHOD_TYPE = 222;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_TYPE__META_DATA_PROPERTY = IDENTIFIED_OBJECT_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_TYPE__DESCRIPTION = IDENTIFIED_OBJECT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_TYPE__DESCRIPTION_REFERENCE = IDENTIFIED_OBJECT_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_TYPE__IDENTIFIER = IDENTIFIED_OBJECT_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_TYPE__NAME = IDENTIFIED_OBJECT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_TYPE__ID = IDENTIFIED_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_TYPE__REMARKS = IDENTIFIED_OBJECT_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Formula Citation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_TYPE__FORMULA_CITATION = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Formula Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_TYPE__FORMULA_GROUP = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Formula</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_TYPE__FORMULA = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Source Dimensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_TYPE__SOURCE_DIMENSIONS = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Target Dimensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_TYPE__TARGET_DIMENSIONS = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Parameter Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_TYPE__PARAMETER_GROUP = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_TYPE__PARAMETER = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Operation Method Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_TYPE_FEATURE_COUNT = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of operations of the '<em>Operation Method Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_METHOD_TYPE_OPERATION_COUNT = IDENTIFIED_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.OperationParameterGroupPropertyTypeImpl <em>Operation Parameter Group Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.OperationParameterGroupPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getOperationParameterGroupPropertyType()
	 * @generated
	 */
	int OPERATION_PARAMETER_GROUP_PROPERTY_TYPE = 223;

	/**
	 * The feature id for the '<em><b>Operation Parameter Group</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_PROPERTY_TYPE__OPERATION_PARAMETER_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Operation Parameter Group Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Operation Parameter Group Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.OperationParameterGroupTypeImpl <em>Operation Parameter Group Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.OperationParameterGroupTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getOperationParameterGroupType()
	 * @generated
	 */
	int OPERATION_PARAMETER_GROUP_TYPE = 224;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_TYPE__META_DATA_PROPERTY = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_TYPE__DESCRIPTION = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_TYPE__IDENTIFIER = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_TYPE__NAME = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_TYPE__ID = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_TYPE__REMARKS = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Minimum Occurs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_TYPE__MINIMUM_OCCURS = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__MINIMUM_OCCURS;

	/**
	 * The feature id for the '<em><b>Maximum Occurs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_TYPE__MAXIMUM_OCCURS = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parameter Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_TYPE__PARAMETER_GROUP = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_TYPE__PARAMETER = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Operation Parameter Group Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_TYPE_FEATURE_COUNT = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Operation Parameter Group Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_GROUP_TYPE_OPERATION_COUNT = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.OperationParameterPropertyTypeImpl <em>Operation Parameter Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.OperationParameterPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getOperationParameterPropertyType()
	 * @generated
	 */
	int OPERATION_PARAMETER_PROPERTY_TYPE = 225;

	/**
	 * The feature id for the '<em><b>Operation Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_PROPERTY_TYPE__OPERATION_PARAMETER = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Operation Parameter Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Operation Parameter Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.OperationParameterTypeImpl <em>Operation Parameter Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.OperationParameterTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getOperationParameterType()
	 * @generated
	 */
	int OPERATION_PARAMETER_TYPE = 226;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_TYPE__META_DATA_PROPERTY = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_TYPE__DESCRIPTION = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_TYPE__IDENTIFIER = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_TYPE__NAME = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_TYPE__ID = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_TYPE__REMARKS = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Minimum Occurs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_TYPE__MINIMUM_OCCURS = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE__MINIMUM_OCCURS;

	/**
	 * The number of structural features of the '<em>Operation Parameter Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_TYPE_FEATURE_COUNT = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Operation Parameter Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PARAMETER_TYPE_OPERATION_COUNT = ABSTRACT_GENERAL_OPERATION_PARAMETER_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.OperationPropertyTypeImpl <em>Operation Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.OperationPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getOperationPropertyType()
	 * @generated
	 */
	int OPERATION_PROPERTY_TYPE = 227;

	/**
	 * The feature id for the '<em><b>Abstract Operation Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PROPERTY_TYPE__ABSTRACT_OPERATION_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Operation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PROPERTY_TYPE__ABSTRACT_OPERATION = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PROPERTY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PROPERTY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PROPERTY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PROPERTY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Operation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Operation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.OrientableCurveTypeImpl <em>Orientable Curve Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.OrientableCurveTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getOrientableCurveType()
	 * @generated
	 */
	int ORIENTABLE_CURVE_TYPE = 228;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_CURVE_TYPE__META_DATA_PROPERTY = ABSTRACT_CURVE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_CURVE_TYPE__DESCRIPTION = ABSTRACT_CURVE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_CURVE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_CURVE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_CURVE_TYPE__IDENTIFIER = ABSTRACT_CURVE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_CURVE_TYPE__NAME = ABSTRACT_CURVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_CURVE_TYPE__ID = ABSTRACT_CURVE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_CURVE_TYPE__AXIS_LABELS = ABSTRACT_CURVE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_CURVE_TYPE__SRS_DIMENSION = ABSTRACT_CURVE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_CURVE_TYPE__SRS_NAME = ABSTRACT_CURVE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_CURVE_TYPE__UOM_LABELS = ABSTRACT_CURVE_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Base Curve</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_CURVE_TYPE__BASE_CURVE = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Orientation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_CURVE_TYPE__ORIENTATION = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Orientable Curve Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_CURVE_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Orientable Curve Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_CURVE_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.OrientableSurfaceTypeImpl <em>Orientable Surface Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.OrientableSurfaceTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getOrientableSurfaceType()
	 * @generated
	 */
	int ORIENTABLE_SURFACE_TYPE = 229;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_SURFACE_TYPE__META_DATA_PROPERTY = ABSTRACT_CURVE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_SURFACE_TYPE__DESCRIPTION = ABSTRACT_CURVE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_SURFACE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_CURVE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_SURFACE_TYPE__IDENTIFIER = ABSTRACT_CURVE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_SURFACE_TYPE__NAME = ABSTRACT_CURVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_SURFACE_TYPE__ID = ABSTRACT_CURVE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_SURFACE_TYPE__AXIS_LABELS = ABSTRACT_CURVE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_SURFACE_TYPE__SRS_DIMENSION = ABSTRACT_CURVE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_SURFACE_TYPE__SRS_NAME = ABSTRACT_CURVE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_SURFACE_TYPE__UOM_LABELS = ABSTRACT_CURVE_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Base Surface</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_SURFACE_TYPE__BASE_SURFACE = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Orientation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_SURFACE_TYPE__ORIENTATION = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Orientable Surface Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_SURFACE_TYPE_FEATURE_COUNT = ABSTRACT_CURVE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Orientable Surface Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ORIENTABLE_SURFACE_TYPE_OPERATION_COUNT = ABSTRACT_CURVE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ParameterValueGroupTypeImpl <em>Parameter Value Group Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ParameterValueGroupTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getParameterValueGroupType()
	 * @generated
	 */
	int PARAMETER_VALUE_GROUP_TYPE = 230;

	/**
	 * The feature id for the '<em><b>Parameter Value Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_VALUE_GROUP_TYPE__PARAMETER_VALUE_GROUP = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parameter Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_VALUE_GROUP_TYPE__PARAMETER_VALUE = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Group Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_VALUE_GROUP_TYPE__GROUP_GROUP = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Group</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_VALUE_GROUP_TYPE__GROUP = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Parameter Value Group Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_VALUE_GROUP_TYPE_FEATURE_COUNT = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Parameter Value Group Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_VALUE_GROUP_TYPE_OPERATION_COUNT = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ParameterValueTypeImpl <em>Parameter Value Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ParameterValueTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getParameterValueType()
	 * @generated
	 */
	int PARAMETER_VALUE_TYPE = 231;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_VALUE_TYPE__VALUE = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Dms Angle Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_VALUE_TYPE__DMS_ANGLE_VALUE = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>String Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_VALUE_TYPE__STRING_VALUE = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Integer Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_VALUE_TYPE__INTEGER_VALUE = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Boolean Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_VALUE_TYPE__BOOLEAN_VALUE = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Value List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_VALUE_TYPE__VALUE_LIST = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Integer Value List</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_VALUE_TYPE__INTEGER_VALUE_LIST = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Value File</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_VALUE_TYPE__VALUE_FILE = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Operation Parameter Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_VALUE_TYPE__OPERATION_PARAMETER_GROUP = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Operation Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_VALUE_TYPE__OPERATION_PARAMETER = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>Parameter Value Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_VALUE_TYPE_FEATURE_COUNT = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_FEATURE_COUNT + 10;

	/**
	 * The number of operations of the '<em>Parameter Value Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_VALUE_TYPE_OPERATION_COUNT = ABSTRACT_GENERAL_PARAMETER_VALUE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.PassThroughOperationPropertyTypeImpl <em>Pass Through Operation Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.PassThroughOperationPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getPassThroughOperationPropertyType()
	 * @generated
	 */
	int PASS_THROUGH_OPERATION_PROPERTY_TYPE = 232;

	/**
	 * The feature id for the '<em><b>Pass Through Operation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_PROPERTY_TYPE__PASS_THROUGH_OPERATION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Pass Through Operation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Pass Through Operation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.PassThroughOperationTypeImpl <em>Pass Through Operation Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.PassThroughOperationTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getPassThroughOperationType()
	 * @generated
	 */
	int PASS_THROUGH_OPERATION_TYPE = 233;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_OPERATION_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_OPERATION_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_COORDINATE_OPERATION_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE__IDENTIFIER = ABSTRACT_COORDINATE_OPERATION_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE__NAME = ABSTRACT_COORDINATE_OPERATION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE__ID = ABSTRACT_COORDINATE_OPERATION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE__REMARKS = ABSTRACT_COORDINATE_OPERATION_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_COORDINATE_OPERATION_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE__SCOPE = ABSTRACT_COORDINATE_OPERATION_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Operation Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE__OPERATION_VERSION = ABSTRACT_COORDINATE_OPERATION_TYPE__OPERATION_VERSION;

	/**
	 * The feature id for the '<em><b>Coordinate Operation Accuracy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE__COORDINATE_OPERATION_ACCURACY = ABSTRACT_COORDINATE_OPERATION_TYPE__COORDINATE_OPERATION_ACCURACY;

	/**
	 * The feature id for the '<em><b>Source CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE__SOURCE_CRS = ABSTRACT_COORDINATE_OPERATION_TYPE__SOURCE_CRS;

	/**
	 * The feature id for the '<em><b>Target CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE__TARGET_CRS = ABSTRACT_COORDINATE_OPERATION_TYPE__TARGET_CRS;

	/**
	 * The feature id for the '<em><b>Modified Coordinate</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE__MODIFIED_COORDINATE = ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Coord Operation Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE__COORD_OPERATION_GROUP = ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Coord Operation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE__COORD_OPERATION = ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE__AGGREGATION_TYPE = ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Pass Through Operation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_OPERATION_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Pass Through Operation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASS_THROUGH_OPERATION_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_OPERATION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.PointArrayPropertyTypeImpl <em>Point Array Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.PointArrayPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getPointArrayPropertyType()
	 * @generated
	 */
	int POINT_ARRAY_PROPERTY_TYPE = 234;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_ARRAY_PROPERTY_TYPE__GROUP = 0;

	/**
	 * The feature id for the '<em><b>Point</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_ARRAY_PROPERTY_TYPE__POINT = 1;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_ARRAY_PROPERTY_TYPE__OWNS = 2;

	/**
	 * The number of structural features of the '<em>Point Array Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_ARRAY_PROPERTY_TYPE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Point Array Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_ARRAY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.PointPropertyTypeImpl <em>Point Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.PointPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getPointPropertyType()
	 * @generated
	 */
	int POINT_PROPERTY_TYPE = 235;

	/**
	 * The feature id for the '<em><b>Point</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_PROPERTY_TYPE__POINT = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_PROPERTY_TYPE__OWNS = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_PROPERTY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_PROPERTY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_PROPERTY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_PROPERTY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Point Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Point Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.PointTypeImpl <em>Point Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.PointTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getPointType()
	 * @generated
	 */
	int POINT_TYPE = 236;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_TYPE__META_DATA_PROPERTY = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_TYPE__DESCRIPTION = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_TYPE__IDENTIFIER = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_TYPE__NAME = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_TYPE__ID = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_TYPE__AXIS_LABELS = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_TYPE__SRS_DIMENSION = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_TYPE__SRS_NAME = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_TYPE__UOM_LABELS = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_TYPE__POS = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_TYPE__COORDINATES = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Point Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_TYPE_FEATURE_COUNT = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Point Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_TYPE_OPERATION_COUNT = ABSTRACT_GEOMETRIC_PRIMITIVE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.PolarCSPropertyTypeImpl <em>Polar CS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.PolarCSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getPolarCSPropertyType()
	 * @generated
	 */
	int POLAR_CS_PROPERTY_TYPE = 237;

	/**
	 * The feature id for the '<em><b>Polar CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_PROPERTY_TYPE__POLAR_CS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Polar CS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Polar CS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.PolarCSTypeImpl <em>Polar CS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.PolarCSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getPolarCSType()
	 * @generated
	 */
	int POLAR_CS_TYPE = 238;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_SYSTEM_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_TYPE__IDENTIFIER = ABSTRACT_COORDINATE_SYSTEM_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_TYPE__NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_TYPE__ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_TYPE__REMARKS = ABSTRACT_COORDINATE_SYSTEM_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Axis Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_TYPE__AXIS_GROUP = ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS_GROUP;

	/**
	 * The feature id for the '<em><b>Axis</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_TYPE__AXIS = ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_TYPE__AGGREGATION_TYPE = ABSTRACT_COORDINATE_SYSTEM_TYPE__AGGREGATION_TYPE;

	/**
	 * The number of structural features of the '<em>Polar CS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Polar CS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLAR_CS_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.PolygonPatchTypeImpl <em>Polygon Patch Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.PolygonPatchTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getPolygonPatchType()
	 * @generated
	 */
	int POLYGON_PATCH_TYPE = 239;

	/**
	 * The feature id for the '<em><b>Exterior</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_PATCH_TYPE__EXTERIOR = ABSTRACT_SURFACE_PATCH_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Interior</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_PATCH_TYPE__INTERIOR = ABSTRACT_SURFACE_PATCH_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_PATCH_TYPE__INTERPOLATION = ABSTRACT_SURFACE_PATCH_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Polygon Patch Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_PATCH_TYPE_FEATURE_COUNT = ABSTRACT_SURFACE_PATCH_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Polygon Patch Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_PATCH_TYPE_OPERATION_COUNT = ABSTRACT_SURFACE_PATCH_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.PolygonTypeImpl <em>Polygon Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.PolygonTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getPolygonType()
	 * @generated
	 */
	int POLYGON_TYPE = 240;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_TYPE__META_DATA_PROPERTY = ABSTRACT_SURFACE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_TYPE__DESCRIPTION = ABSTRACT_SURFACE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_SURFACE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_TYPE__IDENTIFIER = ABSTRACT_SURFACE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_TYPE__NAME = ABSTRACT_SURFACE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_TYPE__ID = ABSTRACT_SURFACE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_TYPE__AXIS_LABELS = ABSTRACT_SURFACE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_TYPE__SRS_DIMENSION = ABSTRACT_SURFACE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_TYPE__SRS_NAME = ABSTRACT_SURFACE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_TYPE__UOM_LABELS = ABSTRACT_SURFACE_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Exterior</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_TYPE__EXTERIOR = ABSTRACT_SURFACE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Interior</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_TYPE__INTERIOR = ABSTRACT_SURFACE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Polygon Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_TYPE_FEATURE_COUNT = ABSTRACT_SURFACE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Polygon Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_TYPE_OPERATION_COUNT = ABSTRACT_SURFACE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.PrimeMeridianPropertyTypeImpl <em>Prime Meridian Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.PrimeMeridianPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getPrimeMeridianPropertyType()
	 * @generated
	 */
	int PRIME_MERIDIAN_PROPERTY_TYPE = 241;

	/**
	 * The feature id for the '<em><b>Prime Meridian</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_PROPERTY_TYPE__PRIME_MERIDIAN = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Prime Meridian Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Prime Meridian Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.PrimeMeridianTypeImpl <em>Prime Meridian Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.PrimeMeridianTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getPrimeMeridianType()
	 * @generated
	 */
	int PRIME_MERIDIAN_TYPE = 242;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_TYPE__META_DATA_PROPERTY = IDENTIFIED_OBJECT_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_TYPE__DESCRIPTION = IDENTIFIED_OBJECT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_TYPE__DESCRIPTION_REFERENCE = IDENTIFIED_OBJECT_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_TYPE__IDENTIFIER = IDENTIFIED_OBJECT_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_TYPE__NAME = IDENTIFIED_OBJECT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_TYPE__ID = IDENTIFIED_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_TYPE__REMARKS = IDENTIFIED_OBJECT_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Greenwich Longitude</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_TYPE__GREENWICH_LONGITUDE = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Prime Meridian Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_TYPE_FEATURE_COUNT = IDENTIFIED_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Prime Meridian Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIME_MERIDIAN_TYPE_OPERATION_COUNT = IDENTIFIED_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.PriorityLocationPropertyTypeImpl <em>Priority Location Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.PriorityLocationPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getPriorityLocationPropertyType()
	 * @generated
	 */
	int PRIORITY_LOCATION_PROPERTY_TYPE = 243;

	/**
	 * The feature id for the '<em><b>Abstract Geometry Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_LOCATION_PROPERTY_TYPE__ABSTRACT_GEOMETRY_GROUP = LOCATION_PROPERTY_TYPE__ABSTRACT_GEOMETRY_GROUP;

	/**
	 * The feature id for the '<em><b>Abstract Geometry</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_LOCATION_PROPERTY_TYPE__ABSTRACT_GEOMETRY = LOCATION_PROPERTY_TYPE__ABSTRACT_GEOMETRY;

	/**
	 * The feature id for the '<em><b>Location Key Word</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_LOCATION_PROPERTY_TYPE__LOCATION_KEY_WORD = LOCATION_PROPERTY_TYPE__LOCATION_KEY_WORD;

	/**
	 * The feature id for the '<em><b>Location String</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_LOCATION_PROPERTY_TYPE__LOCATION_STRING = LOCATION_PROPERTY_TYPE__LOCATION_STRING;

	/**
	 * The feature id for the '<em><b>Null</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_LOCATION_PROPERTY_TYPE__NULL = LOCATION_PROPERTY_TYPE__NULL;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_LOCATION_PROPERTY_TYPE__ACTUATE = LOCATION_PROPERTY_TYPE__ACTUATE;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_LOCATION_PROPERTY_TYPE__ARCROLE = LOCATION_PROPERTY_TYPE__ARCROLE;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_LOCATION_PROPERTY_TYPE__HREF = LOCATION_PROPERTY_TYPE__HREF;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_LOCATION_PROPERTY_TYPE__NIL_REASON = LOCATION_PROPERTY_TYPE__NIL_REASON;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_LOCATION_PROPERTY_TYPE__REMOTE_SCHEMA = LOCATION_PROPERTY_TYPE__REMOTE_SCHEMA;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_LOCATION_PROPERTY_TYPE__ROLE = LOCATION_PROPERTY_TYPE__ROLE;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_LOCATION_PROPERTY_TYPE__SHOW = LOCATION_PROPERTY_TYPE__SHOW;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_LOCATION_PROPERTY_TYPE__TITLE = LOCATION_PROPERTY_TYPE__TITLE;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_LOCATION_PROPERTY_TYPE__TYPE = LOCATION_PROPERTY_TYPE__TYPE;

	/**
	 * The feature id for the '<em><b>Priority</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_LOCATION_PROPERTY_TYPE__PRIORITY = LOCATION_PROPERTY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Priority Location Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_LOCATION_PROPERTY_TYPE_FEATURE_COUNT = LOCATION_PROPERTY_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Priority Location Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIORITY_LOCATION_PROPERTY_TYPE_OPERATION_COUNT = LOCATION_PROPERTY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ProcedurePropertyTypeImpl <em>Procedure Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ProcedurePropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getProcedurePropertyType()
	 * @generated
	 */
	int PROCEDURE_PROPERTY_TYPE = 244;

	/**
	 * The feature id for the '<em><b>Abstract Feature Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PROPERTY_TYPE__ABSTRACT_FEATURE_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Feature</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PROPERTY_TYPE__ABSTRACT_FEATURE = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PROPERTY_TYPE__OWNS = 6;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PROPERTY_TYPE__REMOTE_SCHEMA = 7;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PROPERTY_TYPE__ROLE = 8;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PROPERTY_TYPE__SHOW = 9;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PROPERTY_TYPE__TITLE = 10;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PROPERTY_TYPE__TYPE = 11;

	/**
	 * The number of structural features of the '<em>Procedure Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PROPERTY_TYPE_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Procedure Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCEDURE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ProjectedCRSPropertyTypeImpl <em>Projected CRS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ProjectedCRSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getProjectedCRSPropertyType()
	 * @generated
	 */
	int PROJECTED_CRS_PROPERTY_TYPE = 245;

	/**
	 * The feature id for the '<em><b>Projected CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_PROPERTY_TYPE__PROJECTED_CRS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Projected CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Projected CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ProjectedCRSTypeImpl <em>Projected CRS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ProjectedCRSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getProjectedCRSType()
	 * @generated
	 */
	int PROJECTED_CRS_TYPE = 246;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_TYPE__META_DATA_PROPERTY = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_TYPE__DESCRIPTION = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_TYPE__IDENTIFIER = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_TYPE__NAME = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_TYPE__ID = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_TYPE__REMARKS = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_TYPE__SCOPE = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Conversion Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_TYPE__CONVERSION_GROUP = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__CONVERSION_GROUP;

	/**
	 * The feature id for the '<em><b>Conversion</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_TYPE__CONVERSION = ABSTRACT_GENERAL_DERIVED_CRS_TYPE__CONVERSION;

	/**
	 * The feature id for the '<em><b>Base Geodetic CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_TYPE__BASE_GEODETIC_CRS = ABSTRACT_GENERAL_DERIVED_CRS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Base Geographic CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_TYPE__BASE_GEOGRAPHIC_CRS = ABSTRACT_GENERAL_DERIVED_CRS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Cartesian CS Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_TYPE__CARTESIAN_CS_GROUP = ABSTRACT_GENERAL_DERIVED_CRS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Cartesian CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_TYPE__CARTESIAN_CS = ABSTRACT_GENERAL_DERIVED_CRS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Projected CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_TYPE_FEATURE_COUNT = ABSTRACT_GENERAL_DERIVED_CRS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Projected CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECTED_CRS_TYPE_OPERATION_COUNT = ABSTRACT_GENERAL_DERIVED_CRS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.QuantityExtentTypeImpl <em>Quantity Extent Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.QuantityExtentTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getQuantityExtentType()
	 * @generated
	 */
	int QUANTITY_EXTENT_TYPE = 247;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_EXTENT_TYPE__VALUE = MEASURE_OR_NIL_REASON_LIST_TYPE__VALUE;

	/**
	 * The feature id for the '<em><b>Uom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_EXTENT_TYPE__UOM = MEASURE_OR_NIL_REASON_LIST_TYPE__UOM;

	/**
	 * The number of structural features of the '<em>Quantity Extent Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_EXTENT_TYPE_FEATURE_COUNT = MEASURE_OR_NIL_REASON_LIST_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Quantity Extent Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_EXTENT_TYPE_OPERATION_COUNT = MEASURE_OR_NIL_REASON_LIST_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.QuantityPropertyTypeImpl <em>Quantity Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.QuantityPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getQuantityPropertyType()
	 * @generated
	 */
	int QUANTITY_PROPERTY_TYPE = 248;

	/**
	 * The feature id for the '<em><b>Quantity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PROPERTY_TYPE__QUANTITY = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Quantity Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Quantity Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.QuantityTypeImpl <em>Quantity Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.QuantityTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getQuantityType()
	 * @generated
	 */
	int QUANTITY_TYPE = 249;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_TYPE__VALUE = MEASURE_TYPE__VALUE;

	/**
	 * The feature id for the '<em><b>Uom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_TYPE__UOM = MEASURE_TYPE__UOM;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_TYPE__NIL_REASON = MEASURE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Quantity Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_TYPE_FEATURE_COUNT = MEASURE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Quantity Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QUANTITY_TYPE_OPERATION_COUNT = MEASURE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.RangeSetTypeImpl <em>Range Set Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.RangeSetTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getRangeSetType()
	 * @generated
	 */
	int RANGE_SET_TYPE = 250;

	/**
	 * The feature id for the '<em><b>Value Array</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANGE_SET_TYPE__VALUE_ARRAY = 0;

	/**
	 * The feature id for the '<em><b>Abstract Scalar Value List Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANGE_SET_TYPE__ABSTRACT_SCALAR_VALUE_LIST_GROUP = 1;

	/**
	 * The feature id for the '<em><b>Abstract Scalar Value List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANGE_SET_TYPE__ABSTRACT_SCALAR_VALUE_LIST = 2;

	/**
	 * The feature id for the '<em><b>Data Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANGE_SET_TYPE__DATA_BLOCK = 3;

	/**
	 * The feature id for the '<em><b>File</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANGE_SET_TYPE__FILE = 4;

	/**
	 * The number of structural features of the '<em>Range Set Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANGE_SET_TYPE_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Range Set Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANGE_SET_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.RectangleTypeImpl <em>Rectangle Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.RectangleTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getRectangleType()
	 * @generated
	 */
	int RECTANGLE_TYPE = 251;

	/**
	 * The feature id for the '<em><b>Exterior</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTANGLE_TYPE__EXTERIOR = ABSTRACT_SURFACE_PATCH_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Interpolation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTANGLE_TYPE__INTERPOLATION = ABSTRACT_SURFACE_PATCH_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Rectangle Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTANGLE_TYPE_FEATURE_COUNT = ABSTRACT_SURFACE_PATCH_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Rectangle Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTANGLE_TYPE_OPERATION_COUNT = ABSTRACT_SURFACE_PATCH_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.RectifiedGridTypeImpl <em>Rectified Grid Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.RectifiedGridTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getRectifiedGridType()
	 * @generated
	 */
	int RECTIFIED_GRID_TYPE = 252;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTIFIED_GRID_TYPE__META_DATA_PROPERTY = GRID_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTIFIED_GRID_TYPE__DESCRIPTION = GRID_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTIFIED_GRID_TYPE__DESCRIPTION_REFERENCE = GRID_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTIFIED_GRID_TYPE__IDENTIFIER = GRID_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTIFIED_GRID_TYPE__NAME = GRID_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTIFIED_GRID_TYPE__ID = GRID_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTIFIED_GRID_TYPE__AXIS_LABELS = GRID_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTIFIED_GRID_TYPE__SRS_DIMENSION = GRID_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTIFIED_GRID_TYPE__SRS_NAME = GRID_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTIFIED_GRID_TYPE__UOM_LABELS = GRID_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Limits</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTIFIED_GRID_TYPE__LIMITS = GRID_TYPE__LIMITS;

	/**
	 * The feature id for the '<em><b>Axis Labels1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTIFIED_GRID_TYPE__AXIS_LABELS1 = GRID_TYPE__AXIS_LABELS1;

	/**
	 * The feature id for the '<em><b>Axis Name</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTIFIED_GRID_TYPE__AXIS_NAME = GRID_TYPE__AXIS_NAME;

	/**
	 * The feature id for the '<em><b>Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTIFIED_GRID_TYPE__DIMENSION = GRID_TYPE__DIMENSION;

	/**
	 * The feature id for the '<em><b>Origin</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTIFIED_GRID_TYPE__ORIGIN = GRID_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Offset Vector</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTIFIED_GRID_TYPE__OFFSET_VECTOR = GRID_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Rectified Grid Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTIFIED_GRID_TYPE_FEATURE_COUNT = GRID_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Rectified Grid Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECTIFIED_GRID_TYPE_OPERATION_COUNT = GRID_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ReferenceTypeImpl <em>Reference Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ReferenceTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getReferenceType()
	 * @generated
	 */
	int REFERENCE_TYPE = 253;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_TYPE__ACTUATE = 0;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_TYPE__ARCROLE = 1;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_TYPE__HREF = 2;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_TYPE__NIL_REASON = 3;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_TYPE__OWNS = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Reference Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Reference Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.RefLocationTypeImpl <em>Ref Location Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.RefLocationTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getRefLocationType()
	 * @generated
	 */
	int REF_LOCATION_TYPE = 254;

	/**
	 * The feature id for the '<em><b>Affine Placement</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REF_LOCATION_TYPE__AFFINE_PLACEMENT = 0;

	/**
	 * The number of structural features of the '<em>Ref Location Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REF_LOCATION_TYPE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Ref Location Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REF_LOCATION_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.TimePrimitivePropertyTypeImpl <em>Time Primitive Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.TimePrimitivePropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getTimePrimitivePropertyType()
	 * @generated
	 */
	int TIME_PRIMITIVE_PROPERTY_TYPE = 313;

	/**
	 * The feature id for the '<em><b>Abstract Time Primitive Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PRIMITIVE_PROPERTY_TYPE__ABSTRACT_TIME_PRIMITIVE_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Time Primitive</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PRIMITIVE_PROPERTY_TYPE__ABSTRACT_TIME_PRIMITIVE = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PRIMITIVE_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PRIMITIVE_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PRIMITIVE_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PRIMITIVE_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PRIMITIVE_PROPERTY_TYPE__OWNS = 6;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PRIMITIVE_PROPERTY_TYPE__REMOTE_SCHEMA = 7;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PRIMITIVE_PROPERTY_TYPE__ROLE = 8;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PRIMITIVE_PROPERTY_TYPE__SHOW = 9;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PRIMITIVE_PROPERTY_TYPE__TITLE = 10;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PRIMITIVE_PROPERTY_TYPE__TYPE = 11;

	/**
	 * The number of structural features of the '<em>Time Primitive Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PRIMITIVE_PROPERTY_TYPE_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Time Primitive Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_PRIMITIVE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.RelatedTimeTypeImpl <em>Related Time Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.RelatedTimeTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getRelatedTimeType()
	 * @generated
	 */
	int RELATED_TIME_TYPE = 255;

	/**
	 * The feature id for the '<em><b>Abstract Time Primitive Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATED_TIME_TYPE__ABSTRACT_TIME_PRIMITIVE_GROUP = TIME_PRIMITIVE_PROPERTY_TYPE__ABSTRACT_TIME_PRIMITIVE_GROUP;

	/**
	 * The feature id for the '<em><b>Abstract Time Primitive</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATED_TIME_TYPE__ABSTRACT_TIME_PRIMITIVE = TIME_PRIMITIVE_PROPERTY_TYPE__ABSTRACT_TIME_PRIMITIVE;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATED_TIME_TYPE__ACTUATE = TIME_PRIMITIVE_PROPERTY_TYPE__ACTUATE;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATED_TIME_TYPE__ARCROLE = TIME_PRIMITIVE_PROPERTY_TYPE__ARCROLE;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATED_TIME_TYPE__HREF = TIME_PRIMITIVE_PROPERTY_TYPE__HREF;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATED_TIME_TYPE__NIL_REASON = TIME_PRIMITIVE_PROPERTY_TYPE__NIL_REASON;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATED_TIME_TYPE__OWNS = TIME_PRIMITIVE_PROPERTY_TYPE__OWNS;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATED_TIME_TYPE__REMOTE_SCHEMA = TIME_PRIMITIVE_PROPERTY_TYPE__REMOTE_SCHEMA;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATED_TIME_TYPE__ROLE = TIME_PRIMITIVE_PROPERTY_TYPE__ROLE;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATED_TIME_TYPE__SHOW = TIME_PRIMITIVE_PROPERTY_TYPE__SHOW;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATED_TIME_TYPE__TITLE = TIME_PRIMITIVE_PROPERTY_TYPE__TITLE;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATED_TIME_TYPE__TYPE = TIME_PRIMITIVE_PROPERTY_TYPE__TYPE;

	/**
	 * The feature id for the '<em><b>Relative Position</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATED_TIME_TYPE__RELATIVE_POSITION = TIME_PRIMITIVE_PROPERTY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Related Time Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATED_TIME_TYPE_FEATURE_COUNT = TIME_PRIMITIVE_PROPERTY_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Related Time Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELATED_TIME_TYPE_OPERATION_COUNT = TIME_PRIMITIVE_PROPERTY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ResultTypeImpl <em>Result Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ResultTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getResultType()
	 * @generated
	 */
	int RESULT_TYPE = 256;

	/**
	 * The feature id for the '<em><b>Any</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_TYPE__ANY = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_TYPE__OWNS = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Result Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Result Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.RingPropertyTypeImpl <em>Ring Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.RingPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getRingPropertyType()
	 * @generated
	 */
	int RING_PROPERTY_TYPE = 257;

	/**
	 * The feature id for the '<em><b>Ring</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RING_PROPERTY_TYPE__RING = 0;

	/**
	 * The number of structural features of the '<em>Ring Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RING_PROPERTY_TYPE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Ring Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RING_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.RingTypeImpl <em>Ring Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.RingTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getRingType()
	 * @generated
	 */
	int RING_TYPE = 258;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RING_TYPE__META_DATA_PROPERTY = ABSTRACT_RING_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RING_TYPE__DESCRIPTION = ABSTRACT_RING_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RING_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_RING_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RING_TYPE__IDENTIFIER = ABSTRACT_RING_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RING_TYPE__NAME = ABSTRACT_RING_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RING_TYPE__ID = ABSTRACT_RING_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RING_TYPE__AXIS_LABELS = ABSTRACT_RING_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RING_TYPE__SRS_DIMENSION = ABSTRACT_RING_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RING_TYPE__SRS_NAME = ABSTRACT_RING_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RING_TYPE__UOM_LABELS = ABSTRACT_RING_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Curve Member</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RING_TYPE__CURVE_MEMBER = ABSTRACT_RING_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RING_TYPE__AGGREGATION_TYPE = ABSTRACT_RING_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ring Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RING_TYPE_FEATURE_COUNT = ABSTRACT_RING_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Ring Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RING_TYPE_OPERATION_COUNT = ABSTRACT_RING_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.RowsTypeImpl <em>Rows Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.RowsTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getRowsType()
	 * @generated
	 */
	int ROWS_TYPE = 259;

	/**
	 * The feature id for the '<em><b>Row</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROWS_TYPE__ROW = 0;

	/**
	 * The number of structural features of the '<em>Rows Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROWS_TYPE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Rows Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROWS_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.RowTypeImpl <em>Row Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.RowTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getRowType()
	 * @generated
	 */
	int ROW_TYPE = 260;

	/**
	 * The feature id for the '<em><b>Pos List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROW_TYPE__POS_LIST = 0;

	/**
	 * The feature id for the '<em><b>Geometric Position Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROW_TYPE__GEOMETRIC_POSITION_GROUP = 1;

	/**
	 * The feature id for the '<em><b>Pos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROW_TYPE__POS = 2;

	/**
	 * The feature id for the '<em><b>Point Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROW_TYPE__POINT_PROPERTY = 3;

	/**
	 * The number of structural features of the '<em>Row Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROW_TYPE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Row Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ROW_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ScaleTypeImpl <em>Scale Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ScaleTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getScaleType()
	 * @generated
	 */
	int SCALE_TYPE = 261;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCALE_TYPE__VALUE = MEASURE_TYPE__VALUE;

	/**
	 * The feature id for the '<em><b>Uom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCALE_TYPE__UOM = MEASURE_TYPE__UOM;

	/**
	 * The number of structural features of the '<em>Scale Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCALE_TYPE_FEATURE_COUNT = MEASURE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Scale Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCALE_TYPE_OPERATION_COUNT = MEASURE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.SecondDefiningParameterTypeImpl <em>Second Defining Parameter Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.SecondDefiningParameterTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getSecondDefiningParameterType()
	 * @generated
	 */
	int SECOND_DEFINING_PARAMETER_TYPE = 262;

	/**
	 * The feature id for the '<em><b>Second Defining Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECOND_DEFINING_PARAMETER_TYPE__SECOND_DEFINING_PARAMETER = 0;

	/**
	 * The number of structural features of the '<em>Second Defining Parameter Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECOND_DEFINING_PARAMETER_TYPE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Second Defining Parameter Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECOND_DEFINING_PARAMETER_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.SecondDefiningParameterType1Impl <em>Second Defining Parameter Type1</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.SecondDefiningParameterType1Impl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getSecondDefiningParameterType1()
	 * @generated
	 */
	int SECOND_DEFINING_PARAMETER_TYPE1 = 263;

	/**
	 * The feature id for the '<em><b>Inverse Flattening</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECOND_DEFINING_PARAMETER_TYPE1__INVERSE_FLATTENING = 0;

	/**
	 * The feature id for the '<em><b>Semi Minor Axis</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECOND_DEFINING_PARAMETER_TYPE1__SEMI_MINOR_AXIS = 1;

	/**
	 * The feature id for the '<em><b>Is Sphere</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECOND_DEFINING_PARAMETER_TYPE1__IS_SPHERE = 2;

	/**
	 * The number of structural features of the '<em>Second Defining Parameter Type1</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECOND_DEFINING_PARAMETER_TYPE1_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Second Defining Parameter Type1</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECOND_DEFINING_PARAMETER_TYPE1_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.SecondDefiningParameterType2Impl <em>Second Defining Parameter Type2</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.SecondDefiningParameterType2Impl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getSecondDefiningParameterType2()
	 * @generated
	 */
	int SECOND_DEFINING_PARAMETER_TYPE2 = 264;

	/**
	 * The feature id for the '<em><b>Inverse Flattening</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECOND_DEFINING_PARAMETER_TYPE2__INVERSE_FLATTENING = 0;

	/**
	 * The feature id for the '<em><b>Semi Minor Axis</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECOND_DEFINING_PARAMETER_TYPE2__SEMI_MINOR_AXIS = 1;

	/**
	 * The feature id for the '<em><b>Is Sphere</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECOND_DEFINING_PARAMETER_TYPE2__IS_SPHERE = 2;

	/**
	 * The number of structural features of the '<em>Second Defining Parameter Type2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECOND_DEFINING_PARAMETER_TYPE2_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Second Defining Parameter Type2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECOND_DEFINING_PARAMETER_TYPE2_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.SecondDefiningParameterType3Impl <em>Second Defining Parameter Type3</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.SecondDefiningParameterType3Impl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getSecondDefiningParameterType3()
	 * @generated
	 */
	int SECOND_DEFINING_PARAMETER_TYPE3 = 265;

	/**
	 * The feature id for the '<em><b>Second Defining Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECOND_DEFINING_PARAMETER_TYPE3__SECOND_DEFINING_PARAMETER = 0;

	/**
	 * The number of structural features of the '<em>Second Defining Parameter Type3</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECOND_DEFINING_PARAMETER_TYPE3_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Second Defining Parameter Type3</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SECOND_DEFINING_PARAMETER_TYPE3_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.SequenceRuleTypeImpl <em>Sequence Rule Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.SequenceRuleTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getSequenceRuleType()
	 * @generated
	 */
	int SEQUENCE_RULE_TYPE = 266;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_RULE_TYPE__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Axis Order</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_RULE_TYPE__AXIS_ORDER = 1;

	/**
	 * The feature id for the '<em><b>Order</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_RULE_TYPE__ORDER = 2;

	/**
	 * The number of structural features of the '<em>Sequence Rule Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_RULE_TYPE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Sequence Rule Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_RULE_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ShellPropertyTypeImpl <em>Shell Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ShellPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getShellPropertyType()
	 * @generated
	 */
	int SHELL_PROPERTY_TYPE = 267;

	/**
	 * The feature id for the '<em><b>Shell</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHELL_PROPERTY_TYPE__SHELL = 0;

	/**
	 * The number of structural features of the '<em>Shell Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHELL_PROPERTY_TYPE_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Shell Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHELL_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.ShellTypeImpl <em>Shell Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.ShellTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getShellType()
	 * @generated
	 */
	int SHELL_TYPE = 268;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHELL_TYPE__META_DATA_PROPERTY = ABSTRACT_SURFACE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHELL_TYPE__DESCRIPTION = ABSTRACT_SURFACE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHELL_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_SURFACE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHELL_TYPE__IDENTIFIER = ABSTRACT_SURFACE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHELL_TYPE__NAME = ABSTRACT_SURFACE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHELL_TYPE__ID = ABSTRACT_SURFACE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHELL_TYPE__AXIS_LABELS = ABSTRACT_SURFACE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHELL_TYPE__SRS_DIMENSION = ABSTRACT_SURFACE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHELL_TYPE__SRS_NAME = ABSTRACT_SURFACE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHELL_TYPE__UOM_LABELS = ABSTRACT_SURFACE_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Surface Member</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHELL_TYPE__SURFACE_MEMBER = ABSTRACT_SURFACE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHELL_TYPE__AGGREGATION_TYPE = ABSTRACT_SURFACE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Shell Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHELL_TYPE_FEATURE_COUNT = ABSTRACT_SURFACE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Shell Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHELL_TYPE_OPERATION_COUNT = ABSTRACT_SURFACE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.SingleCRSPropertyTypeImpl <em>Single CRS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.SingleCRSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getSingleCRSPropertyType()
	 * @generated
	 */
	int SINGLE_CRS_PROPERTY_TYPE = 269;

	/**
	 * The feature id for the '<em><b>Abstract Single CRS Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_CRS_PROPERTY_TYPE__ABSTRACT_SINGLE_CRS_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Single CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_CRS_PROPERTY_TYPE__ABSTRACT_SINGLE_CRS = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_CRS_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_CRS_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_CRS_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_CRS_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_CRS_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_CRS_PROPERTY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_CRS_PROPERTY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_CRS_PROPERTY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_CRS_PROPERTY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Single CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_CRS_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Single CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_CRS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.SingleOperationPropertyTypeImpl <em>Single Operation Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.SingleOperationPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getSingleOperationPropertyType()
	 * @generated
	 */
	int SINGLE_OPERATION_PROPERTY_TYPE = 270;

	/**
	 * The feature id for the '<em><b>Abstract Single Operation Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_OPERATION_PROPERTY_TYPE__ABSTRACT_SINGLE_OPERATION_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Single Operation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_OPERATION_PROPERTY_TYPE__ABSTRACT_SINGLE_OPERATION = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_OPERATION_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_OPERATION_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_OPERATION_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_OPERATION_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_OPERATION_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_OPERATION_PROPERTY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_OPERATION_PROPERTY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_OPERATION_PROPERTY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_OPERATION_PROPERTY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Single Operation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_OPERATION_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Single Operation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SINGLE_OPERATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.SolidArrayPropertyTypeImpl <em>Solid Array Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.SolidArrayPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getSolidArrayPropertyType()
	 * @generated
	 */
	int SOLID_ARRAY_PROPERTY_TYPE = 271;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_ARRAY_PROPERTY_TYPE__GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Solid Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_ARRAY_PROPERTY_TYPE__ABSTRACT_SOLID_GROUP = 1;

	/**
	 * The feature id for the '<em><b>Abstract Solid</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_ARRAY_PROPERTY_TYPE__ABSTRACT_SOLID = 2;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_ARRAY_PROPERTY_TYPE__OWNS = 3;

	/**
	 * The number of structural features of the '<em>Solid Array Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_ARRAY_PROPERTY_TYPE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Solid Array Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_ARRAY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.SolidPropertyTypeImpl <em>Solid Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.SolidPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getSolidPropertyType()
	 * @generated
	 */
	int SOLID_PROPERTY_TYPE = 272;

	/**
	 * The feature id for the '<em><b>Abstract Solid Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_PROPERTY_TYPE__ABSTRACT_SOLID_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Solid</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_PROPERTY_TYPE__ABSTRACT_SOLID = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_PROPERTY_TYPE__OWNS = 6;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_PROPERTY_TYPE__REMOTE_SCHEMA = 7;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_PROPERTY_TYPE__ROLE = 8;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_PROPERTY_TYPE__SHOW = 9;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_PROPERTY_TYPE__TITLE = 10;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_PROPERTY_TYPE__TYPE = 11;

	/**
	 * The number of structural features of the '<em>Solid Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_PROPERTY_TYPE_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Solid Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.SolidTypeImpl <em>Solid Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.SolidTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getSolidType()
	 * @generated
	 */
	int SOLID_TYPE = 273;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_TYPE__META_DATA_PROPERTY = ABSTRACT_SOLID_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_TYPE__DESCRIPTION = ABSTRACT_SOLID_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_SOLID_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_TYPE__IDENTIFIER = ABSTRACT_SOLID_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_TYPE__NAME = ABSTRACT_SOLID_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_TYPE__ID = ABSTRACT_SOLID_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_TYPE__AXIS_LABELS = ABSTRACT_SOLID_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_TYPE__SRS_DIMENSION = ABSTRACT_SOLID_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_TYPE__SRS_NAME = ABSTRACT_SOLID_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_TYPE__UOM_LABELS = ABSTRACT_SOLID_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Exterior</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_TYPE__EXTERIOR = ABSTRACT_SOLID_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Interior</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_TYPE__INTERIOR = ABSTRACT_SOLID_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Solid Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_TYPE_FEATURE_COUNT = ABSTRACT_SOLID_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Solid Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOLID_TYPE_OPERATION_COUNT = ABSTRACT_SOLID_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.SpeedTypeImpl <em>Speed Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.SpeedTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getSpeedType()
	 * @generated
	 */
	int SPEED_TYPE = 274;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPEED_TYPE__VALUE = MEASURE_TYPE__VALUE;

	/**
	 * The feature id for the '<em><b>Uom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPEED_TYPE__UOM = MEASURE_TYPE__UOM;

	/**
	 * The number of structural features of the '<em>Speed Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPEED_TYPE_FEATURE_COUNT = MEASURE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Speed Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPEED_TYPE_OPERATION_COUNT = MEASURE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.SphereTypeImpl <em>Sphere Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.SphereTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getSphereType()
	 * @generated
	 */
	int SPHERE_TYPE = 275;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERE_TYPE__AGGREGATION_TYPE = ABSTRACT_GRIDDED_SURFACE_TYPE__AGGREGATION_TYPE;

	/**
	 * The feature id for the '<em><b>Rows</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERE_TYPE__ROWS = ABSTRACT_GRIDDED_SURFACE_TYPE__ROWS;

	/**
	 * The feature id for the '<em><b>Columns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERE_TYPE__COLUMNS = ABSTRACT_GRIDDED_SURFACE_TYPE__COLUMNS;

	/**
	 * The feature id for the '<em><b>Rows1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERE_TYPE__ROWS1 = ABSTRACT_GRIDDED_SURFACE_TYPE__ROWS1;

	/**
	 * The feature id for the '<em><b>Horizontal Curve Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERE_TYPE__HORIZONTAL_CURVE_TYPE = ABSTRACT_GRIDDED_SURFACE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Vertical Curve Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERE_TYPE__VERTICAL_CURVE_TYPE = ABSTRACT_GRIDDED_SURFACE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Sphere Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERE_TYPE_FEATURE_COUNT = ABSTRACT_GRIDDED_SURFACE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Sphere Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERE_TYPE_OPERATION_COUNT = ABSTRACT_GRIDDED_SURFACE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.SphericalCSPropertyTypeImpl <em>Spherical CS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.SphericalCSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getSphericalCSPropertyType()
	 * @generated
	 */
	int SPHERICAL_CS_PROPERTY_TYPE = 276;

	/**
	 * The feature id for the '<em><b>Spherical CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_PROPERTY_TYPE__SPHERICAL_CS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Spherical CS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Spherical CS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.SphericalCSTypeImpl <em>Spherical CS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.SphericalCSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getSphericalCSType()
	 * @generated
	 */
	int SPHERICAL_CS_TYPE = 277;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_SYSTEM_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_TYPE__IDENTIFIER = ABSTRACT_COORDINATE_SYSTEM_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_TYPE__NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_TYPE__ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_TYPE__REMARKS = ABSTRACT_COORDINATE_SYSTEM_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Axis Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_TYPE__AXIS_GROUP = ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS_GROUP;

	/**
	 * The feature id for the '<em><b>Axis</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_TYPE__AXIS = ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_TYPE__AGGREGATION_TYPE = ABSTRACT_COORDINATE_SYSTEM_TYPE__AGGREGATION_TYPE;

	/**
	 * The number of structural features of the '<em>Spherical CS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Spherical CS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SPHERICAL_CS_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.StringOrRefTypeImpl <em>String Or Ref Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.StringOrRefTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getStringOrRefType()
	 * @generated
	 */
	int STRING_OR_REF_TYPE = 278;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_OR_REF_TYPE__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_OR_REF_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_OR_REF_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_OR_REF_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_OR_REF_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_OR_REF_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_OR_REF_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_OR_REF_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_OR_REF_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_OR_REF_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>String Or Ref Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_OR_REF_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>String Or Ref Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_OR_REF_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.SurfaceArrayPropertyTypeImpl <em>Surface Array Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.SurfaceArrayPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getSurfaceArrayPropertyType()
	 * @generated
	 */
	int SURFACE_ARRAY_PROPERTY_TYPE = 279;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_ARRAY_PROPERTY_TYPE__GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Surface Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_ARRAY_PROPERTY_TYPE__ABSTRACT_SURFACE_GROUP = 1;

	/**
	 * The feature id for the '<em><b>Abstract Surface</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_ARRAY_PROPERTY_TYPE__ABSTRACT_SURFACE = 2;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_ARRAY_PROPERTY_TYPE__OWNS = 3;

	/**
	 * The number of structural features of the '<em>Surface Array Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_ARRAY_PROPERTY_TYPE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Surface Array Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_ARRAY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.SurfacePatchArrayPropertyTypeImpl <em>Surface Patch Array Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.SurfacePatchArrayPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getSurfacePatchArrayPropertyType()
	 * @generated
	 */
	int SURFACE_PATCH_ARRAY_PROPERTY_TYPE = 280;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PATCH_ARRAY_PROPERTY_TYPE__GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Surface Patch Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PATCH_ARRAY_PROPERTY_TYPE__ABSTRACT_SURFACE_PATCH_GROUP = 1;

	/**
	 * The feature id for the '<em><b>Abstract Surface Patch</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PATCH_ARRAY_PROPERTY_TYPE__ABSTRACT_SURFACE_PATCH = 2;

	/**
	 * The number of structural features of the '<em>Surface Patch Array Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PATCH_ARRAY_PROPERTY_TYPE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Surface Patch Array Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PATCH_ARRAY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.SurfacePropertyTypeImpl <em>Surface Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.SurfacePropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getSurfacePropertyType()
	 * @generated
	 */
	int SURFACE_PROPERTY_TYPE = 281;

	/**
	 * The feature id for the '<em><b>Abstract Surface Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PROPERTY_TYPE__ABSTRACT_SURFACE_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Surface</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PROPERTY_TYPE__ABSTRACT_SURFACE = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PROPERTY_TYPE__OWNS = 6;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PROPERTY_TYPE__REMOTE_SCHEMA = 7;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PROPERTY_TYPE__ROLE = 8;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PROPERTY_TYPE__SHOW = 9;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PROPERTY_TYPE__TITLE = 10;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PROPERTY_TYPE__TYPE = 11;

	/**
	 * The number of structural features of the '<em>Surface Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PROPERTY_TYPE_FEATURE_COUNT = 12;

	/**
	 * The number of operations of the '<em>Surface Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.SurfaceTypeImpl <em>Surface Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.SurfaceTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getSurfaceType()
	 * @generated
	 */
	int SURFACE_TYPE = 282;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_TYPE__META_DATA_PROPERTY = ABSTRACT_SURFACE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_TYPE__DESCRIPTION = ABSTRACT_SURFACE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_SURFACE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_TYPE__IDENTIFIER = ABSTRACT_SURFACE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_TYPE__NAME = ABSTRACT_SURFACE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_TYPE__ID = ABSTRACT_SURFACE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Axis Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_TYPE__AXIS_LABELS = ABSTRACT_SURFACE_TYPE__AXIS_LABELS;

	/**
	 * The feature id for the '<em><b>Srs Dimension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_TYPE__SRS_DIMENSION = ABSTRACT_SURFACE_TYPE__SRS_DIMENSION;

	/**
	 * The feature id for the '<em><b>Srs Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_TYPE__SRS_NAME = ABSTRACT_SURFACE_TYPE__SRS_NAME;

	/**
	 * The feature id for the '<em><b>Uom Labels</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_TYPE__UOM_LABELS = ABSTRACT_SURFACE_TYPE__UOM_LABELS;

	/**
	 * The feature id for the '<em><b>Patches Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_TYPE__PATCHES_GROUP = ABSTRACT_SURFACE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Patches</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_TYPE__PATCHES = ABSTRACT_SURFACE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Surface Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_TYPE_FEATURE_COUNT = ABSTRACT_SURFACE_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Surface Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SURFACE_TYPE_OPERATION_COUNT = ABSTRACT_SURFACE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.TargetPropertyTypeImpl <em>Target Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.TargetPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getTargetPropertyType()
	 * @generated
	 */
	int TARGET_PROPERTY_TYPE = 283;

	/**
	 * The feature id for the '<em><b>Abstract Feature Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_PROPERTY_TYPE__ABSTRACT_FEATURE_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Feature</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_PROPERTY_TYPE__ABSTRACT_FEATURE = 1;

	/**
	 * The feature id for the '<em><b>Abstract Geometry Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_PROPERTY_TYPE__ABSTRACT_GEOMETRY_GROUP = 2;

	/**
	 * The feature id for the '<em><b>Abstract Geometry</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_PROPERTY_TYPE__ABSTRACT_GEOMETRY = 3;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_PROPERTY_TYPE__ACTUATE = 4;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_PROPERTY_TYPE__ARCROLE = 5;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_PROPERTY_TYPE__HREF = 6;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_PROPERTY_TYPE__NIL_REASON = 7;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_PROPERTY_TYPE__OWNS = 8;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_PROPERTY_TYPE__REMOTE_SCHEMA = 9;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_PROPERTY_TYPE__ROLE = 10;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_PROPERTY_TYPE__SHOW = 11;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_PROPERTY_TYPE__TITLE = 12;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_PROPERTY_TYPE__TYPE = 13;

	/**
	 * The number of structural features of the '<em>Target Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_PROPERTY_TYPE_FEATURE_COUNT = 14;

	/**
	 * The number of operations of the '<em>Target Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.TemporalCRSPropertyTypeImpl <em>Temporal CRS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.TemporalCRSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getTemporalCRSPropertyType()
	 * @generated
	 */
	int TEMPORAL_CRS_PROPERTY_TYPE = 284;

	/**
	 * The feature id for the '<em><b>Temporal CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_PROPERTY_TYPE__TEMPORAL_CRS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Temporal CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Temporal CRS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.TemporalCRSTypeImpl <em>Temporal CRS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.TemporalCRSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getTemporalCRSType()
	 * @generated
	 */
	int TEMPORAL_CRS_TYPE = 285;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_TYPE__META_DATA_PROPERTY = ABSTRACT_CRS_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_TYPE__DESCRIPTION = ABSTRACT_CRS_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_CRS_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_TYPE__IDENTIFIER = ABSTRACT_CRS_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_TYPE__NAME = ABSTRACT_CRS_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_TYPE__ID = ABSTRACT_CRS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_TYPE__REMARKS = ABSTRACT_CRS_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_CRS_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_TYPE__SCOPE = ABSTRACT_CRS_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Time CS Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_TYPE__TIME_CS_GROUP = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Time CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_TYPE__TIME_CS = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Uses Temporal CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_TYPE__USES_TEMPORAL_CS = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Temporal Datum Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_TYPE__TEMPORAL_DATUM_GROUP = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Temporal Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_TYPE__TEMPORAL_DATUM = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Temporal CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_TYPE_FEATURE_COUNT = ABSTRACT_CRS_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Temporal CRS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CRS_TYPE_OPERATION_COUNT = ABSTRACT_CRS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.TemporalCSPropertyTypeImpl <em>Temporal CS Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.TemporalCSPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getTemporalCSPropertyType()
	 * @generated
	 */
	int TEMPORAL_CS_PROPERTY_TYPE = 286;

	/**
	 * The feature id for the '<em><b>Temporal CS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_PROPERTY_TYPE__TEMPORAL_CS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Temporal CS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Temporal CS Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.TemporalCSTypeImpl <em>Temporal CS Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.TemporalCSTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getTemporalCSType()
	 * @generated
	 */
	int TEMPORAL_CS_TYPE = 287;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_TYPE__META_DATA_PROPERTY = ABSTRACT_COORDINATE_SYSTEM_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_TYPE__DESCRIPTION = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_COORDINATE_SYSTEM_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_TYPE__IDENTIFIER = ABSTRACT_COORDINATE_SYSTEM_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_TYPE__NAME = ABSTRACT_COORDINATE_SYSTEM_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_TYPE__ID = ABSTRACT_COORDINATE_SYSTEM_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_TYPE__REMARKS = ABSTRACT_COORDINATE_SYSTEM_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Axis Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_TYPE__AXIS_GROUP = ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS_GROUP;

	/**
	 * The feature id for the '<em><b>Axis</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_TYPE__AXIS = ABSTRACT_COORDINATE_SYSTEM_TYPE__AXIS;

	/**
	 * The feature id for the '<em><b>Aggregation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_TYPE__AGGREGATION_TYPE = ABSTRACT_COORDINATE_SYSTEM_TYPE__AGGREGATION_TYPE;

	/**
	 * The number of structural features of the '<em>Temporal CS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_TYPE_FEATURE_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Temporal CS Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_CS_TYPE_OPERATION_COUNT = ABSTRACT_COORDINATE_SYSTEM_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.TemporalDatumBaseTypeImpl <em>Temporal Datum Base Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.TemporalDatumBaseTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getTemporalDatumBaseType()
	 * @generated
	 */
	int TEMPORAL_DATUM_BASE_TYPE = 288;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_BASE_TYPE__META_DATA_PROPERTY = ABSTRACT_DATUM_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_BASE_TYPE__DESCRIPTION = ABSTRACT_DATUM_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_BASE_TYPE__DESCRIPTION_REFERENCE = ABSTRACT_DATUM_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_BASE_TYPE__IDENTIFIER = ABSTRACT_DATUM_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_BASE_TYPE__NAME = ABSTRACT_DATUM_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_BASE_TYPE__ID = ABSTRACT_DATUM_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_BASE_TYPE__REMARKS = ABSTRACT_DATUM_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_BASE_TYPE__DOMAIN_OF_VALIDITY = ABSTRACT_DATUM_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_BASE_TYPE__SCOPE = ABSTRACT_DATUM_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Anchor Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_BASE_TYPE__ANCHOR_DEFINITION = ABSTRACT_DATUM_TYPE__ANCHOR_DEFINITION;

	/**
	 * The feature id for the '<em><b>Realization Epoch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_BASE_TYPE__REALIZATION_EPOCH = ABSTRACT_DATUM_TYPE__REALIZATION_EPOCH;

	/**
	 * The number of structural features of the '<em>Temporal Datum Base Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_BASE_TYPE_FEATURE_COUNT = ABSTRACT_DATUM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Temporal Datum Base Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_BASE_TYPE_OPERATION_COUNT = ABSTRACT_DATUM_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.TemporalDatumPropertyTypeImpl <em>Temporal Datum Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.TemporalDatumPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getTemporalDatumPropertyType()
	 * @generated
	 */
	int TEMPORAL_DATUM_PROPERTY_TYPE = 289;

	/**
	 * The feature id for the '<em><b>Temporal Datum</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_PROPERTY_TYPE__TEMPORAL_DATUM = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_PROPERTY_TYPE__REMOTE_SCHEMA = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The number of structural features of the '<em>Temporal Datum Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Temporal Datum Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.TemporalDatumTypeImpl <em>Temporal Datum Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.TemporalDatumTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getTemporalDatumType()
	 * @generated
	 */
	int TEMPORAL_DATUM_TYPE = 290;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_TYPE__META_DATA_PROPERTY = TEMPORAL_DATUM_BASE_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_TYPE__DESCRIPTION = TEMPORAL_DATUM_BASE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_TYPE__DESCRIPTION_REFERENCE = TEMPORAL_DATUM_BASE_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_TYPE__IDENTIFIER = TEMPORAL_DATUM_BASE_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_TYPE__NAME = TEMPORAL_DATUM_BASE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_TYPE__ID = TEMPORAL_DATUM_BASE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_TYPE__REMARKS = TEMPORAL_DATUM_BASE_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_TYPE__DOMAIN_OF_VALIDITY = TEMPORAL_DATUM_BASE_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_TYPE__SCOPE = TEMPORAL_DATUM_BASE_TYPE__SCOPE;

	/**
	 * The feature id for the '<em><b>Anchor Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_TYPE__ANCHOR_DEFINITION = TEMPORAL_DATUM_BASE_TYPE__ANCHOR_DEFINITION;

	/**
	 * The feature id for the '<em><b>Realization Epoch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_TYPE__REALIZATION_EPOCH = TEMPORAL_DATUM_BASE_TYPE__REALIZATION_EPOCH;

	/**
	 * The feature id for the '<em><b>Origin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_TYPE__ORIGIN = TEMPORAL_DATUM_BASE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Temporal Datum Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_TYPE_FEATURE_COUNT = TEMPORAL_DATUM_BASE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Temporal Datum Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEMPORAL_DATUM_TYPE_OPERATION_COUNT = TEMPORAL_DATUM_BASE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.TimeCalendarEraPropertyTypeImpl <em>Time Calendar Era Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.TimeCalendarEraPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getTimeCalendarEraPropertyType()
	 * @generated
	 */
	int TIME_CALENDAR_ERA_PROPERTY_TYPE = 291;

	/**
	 * The feature id for the '<em><b>Time Calendar Era</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_PROPERTY_TYPE__TIME_CALENDAR_ERA = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_PROPERTY_TYPE__OWNS = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_PROPERTY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_PROPERTY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_PROPERTY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_PROPERTY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Time Calendar Era Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Time Calendar Era Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.TimeCalendarEraTypeImpl <em>Time Calendar Era Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.TimeCalendarEraTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getTimeCalendarEraType()
	 * @generated
	 */
	int TIME_CALENDAR_ERA_TYPE = 292;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_TYPE__META_DATA_PROPERTY = DEFINITION_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_TYPE__DESCRIPTION = DEFINITION_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_TYPE__DESCRIPTION_REFERENCE = DEFINITION_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_TYPE__IDENTIFIER = DEFINITION_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_TYPE__NAME = DEFINITION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_TYPE__ID = DEFINITION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_TYPE__REMARKS = DEFINITION_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Reference Event</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_TYPE__REFERENCE_EVENT = DEFINITION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Reference Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_TYPE__REFERENCE_DATE = DEFINITION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Julian Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_TYPE__JULIAN_REFERENCE = DEFINITION_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Epoch Of Use</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_TYPE__EPOCH_OF_USE = DEFINITION_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Time Calendar Era Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_TYPE_FEATURE_COUNT = DEFINITION_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Time Calendar Era Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_ERA_TYPE_OPERATION_COUNT = DEFINITION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.TimeCalendarPropertyTypeImpl <em>Time Calendar Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.TimeCalendarPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getTimeCalendarPropertyType()
	 * @generated
	 */
	int TIME_CALENDAR_PROPERTY_TYPE = 293;

	/**
	 * The feature id for the '<em><b>Time Calendar</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_PROPERTY_TYPE__TIME_CALENDAR = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_PROPERTY_TYPE__OWNS = 5;

	/**
	 * The feature id for the '<em><b>Remote Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_PROPERTY_TYPE__REMOTE_SCHEMA = 6;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_PROPERTY_TYPE__ROLE = 7;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_PROPERTY_TYPE__SHOW = 8;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_PROPERTY_TYPE__TITLE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_PROPERTY_TYPE__TYPE = 10;

	/**
	 * The number of structural features of the '<em>Time Calendar Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Time Calendar Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.TimeReferenceSystemTypeImpl <em>Time Reference System Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.TimeReferenceSystemTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getTimeReferenceSystemType()
	 * @generated
	 */
	int TIME_REFERENCE_SYSTEM_TYPE = 314;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REFERENCE_SYSTEM_TYPE__META_DATA_PROPERTY = DEFINITION_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REFERENCE_SYSTEM_TYPE__DESCRIPTION = DEFINITION_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REFERENCE_SYSTEM_TYPE__DESCRIPTION_REFERENCE = DEFINITION_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REFERENCE_SYSTEM_TYPE__IDENTIFIER = DEFINITION_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REFERENCE_SYSTEM_TYPE__NAME = DEFINITION_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REFERENCE_SYSTEM_TYPE__ID = DEFINITION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REFERENCE_SYSTEM_TYPE__REMARKS = DEFINITION_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REFERENCE_SYSTEM_TYPE__DOMAIN_OF_VALIDITY = DEFINITION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Time Reference System Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT = DEFINITION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Time Reference System Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_REFERENCE_SYSTEM_TYPE_OPERATION_COUNT = DEFINITION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.TimeCalendarTypeImpl <em>Time Calendar Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.TimeCalendarTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getTimeCalendarType()
	 * @generated
	 */
	int TIME_CALENDAR_TYPE = 294;

	/**
	 * The feature id for the '<em><b>Meta Data Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_TYPE__META_DATA_PROPERTY = TIME_REFERENCE_SYSTEM_TYPE__META_DATA_PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_TYPE__DESCRIPTION = TIME_REFERENCE_SYSTEM_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Description Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_TYPE__DESCRIPTION_REFERENCE = TIME_REFERENCE_SYSTEM_TYPE__DESCRIPTION_REFERENCE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_TYPE__IDENTIFIER = TIME_REFERENCE_SYSTEM_TYPE__IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_TYPE__NAME = TIME_REFERENCE_SYSTEM_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_TYPE__ID = TIME_REFERENCE_SYSTEM_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Remarks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_TYPE__REMARKS = TIME_REFERENCE_SYSTEM_TYPE__REMARKS;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_TYPE__DOMAIN_OF_VALIDITY = TIME_REFERENCE_SYSTEM_TYPE__DOMAIN_OF_VALIDITY;

	/**
	 * The feature id for the '<em><b>Reference Frame</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_TYPE__REFERENCE_FRAME = TIME_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Time Calendar Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_TYPE_FEATURE_COUNT = TIME_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Time Calendar Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CALENDAR_TYPE_OPERATION_COUNT = TIME_REFERENCE_SYSTEM_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link net.opengis.gml.gml.impl.TimeClockPropertyTypeImpl <em>Time Clock Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see net.opengis.gml.gml.impl.TimeClockPropertyTypeImpl
	 * @see net.opengis.gml.gml.impl.GMLPackageImpl#getTimeClockPropertyType()
	 * @generated
	 */
	int TIME_CLOCK_PROPERTY_TYPE = 295;

	/**
	 * The feature id for the '<em><b>Time Clock</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CLOCK_PROPERTY_TYPE__TIME_CLOCK = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CLOCK_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CLOCK_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CLOCK_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CLOCK_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Owns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TIME_CLOCK_PROPERTY_TYPE__OWN