/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.isotc211._2005.gmd;

import org.eclipse.emf.ecore.EFactory;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.isotc211._2005.gmd.GMDPackage
 * @generated
 */
@ProviderType
public interface GMDFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	GMDFactory eINSTANCE = org.isotc211._2005.gmd.impl.GMDFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>CI Address Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Address Property Type</em>'.
	 * @generated
	 */
	CIAddressPropertyType createCIAddressPropertyType();

	/**
	 * Returns a new object of class '<em>CI Address Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Address Type</em>'.
	 * @generated
	 */
	CIAddressType createCIAddressType();

	/**
	 * Returns a new object of class '<em>CI Citation Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Citation Property Type</em>'.
	 * @generated
	 */
	CICitationPropertyType createCICitationPropertyType();

	/**
	 * Returns a new object of class '<em>CI Citation Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Citation Type</em>'.
	 * @generated
	 */
	CICitationType createCICitationType();

	/**
	 * Returns a new object of class '<em>CI Contact Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Contact Property Type</em>'.
	 * @generated
	 */
	CIContactPropertyType createCIContactPropertyType();

	/**
	 * Returns a new object of class '<em>CI Contact Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Contact Type</em>'.
	 * @generated
	 */
	CIContactType createCIContactType();

	/**
	 * Returns a new object of class '<em>CI Date Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Date Property Type</em>'.
	 * @generated
	 */
	CIDatePropertyType createCIDatePropertyType();

	/**
	 * Returns a new object of class '<em>CI Date Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Date Type</em>'.
	 * @generated
	 */
	CIDateType createCIDateType();

	/**
	 * Returns a new object of class '<em>CI Date Type Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Date Type Code Property Type</em>'.
	 * @generated
	 */
	CIDateTypeCodePropertyType createCIDateTypeCodePropertyType();

	/**
	 * Returns a new object of class '<em>CI On Line Function Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI On Line Function Code Property Type</em>'.
	 * @generated
	 */
	CIOnLineFunctionCodePropertyType createCIOnLineFunctionCodePropertyType();

	/**
	 * Returns a new object of class '<em>CI Online Resource Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Online Resource Property Type</em>'.
	 * @generated
	 */
	CIOnlineResourcePropertyType createCIOnlineResourcePropertyType();

	/**
	 * Returns a new object of class '<em>CI Online Resource Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Online Resource Type</em>'.
	 * @generated
	 */
	CIOnlineResourceType createCIOnlineResourceType();

	/**
	 * Returns a new object of class '<em>CI Presentation Form Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Presentation Form Code Property Type</em>'.
	 * @generated
	 */
	CIPresentationFormCodePropertyType createCIPresentationFormCodePropertyType();

	/**
	 * Returns a new object of class '<em>CI Responsible Party Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Responsible Party Property Type</em>'.
	 * @generated
	 */
	CIResponsiblePartyPropertyType createCIResponsiblePartyPropertyType();

	/**
	 * Returns a new object of class '<em>CI Responsible Party Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Responsible Party Type</em>'.
	 * @generated
	 */
	CIResponsiblePartyType createCIResponsiblePartyType();

	/**
	 * Returns a new object of class '<em>CI Role Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Role Code Property Type</em>'.
	 * @generated
	 */
	CIRoleCodePropertyType createCIRoleCodePropertyType();

	/**
	 * Returns a new object of class '<em>CI Series Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Series Property Type</em>'.
	 * @generated
	 */
	CISeriesPropertyType createCISeriesPropertyType();

	/**
	 * Returns a new object of class '<em>CI Series Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Series Type</em>'.
	 * @generated
	 */
	CISeriesType createCISeriesType();

	/**
	 * Returns a new object of class '<em>CI Telephone Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Telephone Property Type</em>'.
	 * @generated
	 */
	CITelephonePropertyType createCITelephonePropertyType();

	/**
	 * Returns a new object of class '<em>CI Telephone Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CI Telephone Type</em>'.
	 * @generated
	 */
	CITelephoneType createCITelephoneType();

	/**
	 * Returns a new object of class '<em>Country Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Country Property Type</em>'.
	 * @generated
	 */
	CountryPropertyType createCountryPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Absolute External Positional Accuracy Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Absolute External Positional Accuracy Property Type</em>'.
	 * @generated
	 */
	DQAbsoluteExternalPositionalAccuracyPropertyType createDQAbsoluteExternalPositionalAccuracyPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Absolute External Positional Accuracy Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Absolute External Positional Accuracy Type</em>'.
	 * @generated
	 */
	DQAbsoluteExternalPositionalAccuracyType createDQAbsoluteExternalPositionalAccuracyType();

	/**
	 * Returns a new object of class '<em>DQ Accuracy Of ATime Measurement Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Accuracy Of ATime Measurement Property Type</em>'.
	 * @generated
	 */
	DQAccuracyOfATimeMeasurementPropertyType createDQAccuracyOfATimeMeasurementPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Accuracy Of ATime Measurement Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Accuracy Of ATime Measurement Type</em>'.
	 * @generated
	 */
	DQAccuracyOfATimeMeasurementType createDQAccuracyOfATimeMeasurementType();

	/**
	 * Returns a new object of class '<em>DQ Completeness Commission Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Completeness Commission Property Type</em>'.
	 * @generated
	 */
	DQCompletenessCommissionPropertyType createDQCompletenessCommissionPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Completeness Commission Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Completeness Commission Type</em>'.
	 * @generated
	 */
	DQCompletenessCommissionType createDQCompletenessCommissionType();

	/**
	 * Returns a new object of class '<em>DQ Completeness Omission Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Completeness Omission Property Type</em>'.
	 * @generated
	 */
	DQCompletenessOmissionPropertyType createDQCompletenessOmissionPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Completeness Omission Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Completeness Omission Type</em>'.
	 * @generated
	 */
	DQCompletenessOmissionType createDQCompletenessOmissionType();

	/**
	 * Returns a new object of class '<em>DQ Completeness Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Completeness Property Type</em>'.
	 * @generated
	 */
	DQCompletenessPropertyType createDQCompletenessPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Conceptual Consistency Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Conceptual Consistency Property Type</em>'.
	 * @generated
	 */
	DQConceptualConsistencyPropertyType createDQConceptualConsistencyPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Conceptual Consistency Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Conceptual Consistency Type</em>'.
	 * @generated
	 */
	DQConceptualConsistencyType createDQConceptualConsistencyType();

	/**
	 * Returns a new object of class '<em>DQ Conformance Result Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Conformance Result Property Type</em>'.
	 * @generated
	 */
	DQConformanceResultPropertyType createDQConformanceResultPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Conformance Result Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Conformance Result Type</em>'.
	 * @generated
	 */
	DQConformanceResultType createDQConformanceResultType();

	/**
	 * Returns a new object of class '<em>DQ Data Quality Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Data Quality Property Type</em>'.
	 * @generated
	 */
	DQDataQualityPropertyType createDQDataQualityPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Data Quality Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Data Quality Type</em>'.
	 * @generated
	 */
	DQDataQualityType createDQDataQualityType();

	/**
	 * Returns a new object of class '<em>DQ Domain Consistency Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Domain Consistency Property Type</em>'.
	 * @generated
	 */
	DQDomainConsistencyPropertyType createDQDomainConsistencyPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Domain Consistency Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Domain Consistency Type</em>'.
	 * @generated
	 */
	DQDomainConsistencyType createDQDomainConsistencyType();

	/**
	 * Returns a new object of class '<em>DQ Element Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Element Property Type</em>'.
	 * @generated
	 */
	DQElementPropertyType createDQElementPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Evaluation Method Type Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Evaluation Method Type Code Property Type</em>'.
	 * @generated
	 */
	DQEvaluationMethodTypeCodePropertyType createDQEvaluationMethodTypeCodePropertyType();

	/**
	 * Returns a new object of class '<em>DQ Format Consistency Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Format Consistency Property Type</em>'.
	 * @generated
	 */
	DQFormatConsistencyPropertyType createDQFormatConsistencyPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Format Consistency Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Format Consistency Type</em>'.
	 * @generated
	 */
	DQFormatConsistencyType createDQFormatConsistencyType();

	/**
	 * Returns a new object of class '<em>DQ Gridded Data Positional Accuracy Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Gridded Data Positional Accuracy Property Type</em>'.
	 * @generated
	 */
	DQGriddedDataPositionalAccuracyPropertyType createDQGriddedDataPositionalAccuracyPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Gridded Data Positional Accuracy Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Gridded Data Positional Accuracy Type</em>'.
	 * @generated
	 */
	DQGriddedDataPositionalAccuracyType createDQGriddedDataPositionalAccuracyType();

	/**
	 * Returns a new object of class '<em>DQ Logical Consistency Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Logical Consistency Property Type</em>'.
	 * @generated
	 */
	DQLogicalConsistencyPropertyType createDQLogicalConsistencyPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Non Quantitative Attribute Accuracy Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Non Quantitative Attribute Accuracy Property Type</em>'.
	 * @generated
	 */
	DQNonQuantitativeAttributeAccuracyPropertyType createDQNonQuantitativeAttributeAccuracyPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Non Quantitative Attribute Accuracy Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Non Quantitative Attribute Accuracy Type</em>'.
	 * @generated
	 */
	DQNonQuantitativeAttributeAccuracyType createDQNonQuantitativeAttributeAccuracyType();

	/**
	 * Returns a new object of class '<em>DQ Positional Accuracy Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Positional Accuracy Property Type</em>'.
	 * @generated
	 */
	DQPositionalAccuracyPropertyType createDQPositionalAccuracyPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Quantitative Attribute Accuracy Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Quantitative Attribute Accuracy Property Type</em>'.
	 * @generated
	 */
	DQQuantitativeAttributeAccuracyPropertyType createDQQuantitativeAttributeAccuracyPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Quantitative Attribute Accuracy Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Quantitative Attribute Accuracy Type</em>'.
	 * @generated
	 */
	DQQuantitativeAttributeAccuracyType createDQQuantitativeAttributeAccuracyType();

	/**
	 * Returns a new object of class '<em>DQ Quantitative Result Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Quantitative Result Property Type</em>'.
	 * @generated
	 */
	DQQuantitativeResultPropertyType createDQQuantitativeResultPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Quantitative Result Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Quantitative Result Type</em>'.
	 * @generated
	 */
	DQQuantitativeResultType createDQQuantitativeResultType();

	/**
	 * Returns a new object of class '<em>DQ Relative Internal Positional Accuracy Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Relative Internal Positional Accuracy Property Type</em>'.
	 * @generated
	 */
	DQRelativeInternalPositionalAccuracyPropertyType createDQRelativeInternalPositionalAccuracyPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Relative Internal Positional Accuracy Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Relative Internal Positional Accuracy Type</em>'.
	 * @generated
	 */
	DQRelativeInternalPositionalAccuracyType createDQRelativeInternalPositionalAccuracyType();

	/**
	 * Returns a new object of class '<em>DQ Result Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Result Property Type</em>'.
	 * @generated
	 */
	DQResultPropertyType createDQResultPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Scope Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Scope Property Type</em>'.
	 * @generated
	 */
	DQScopePropertyType createDQScopePropertyType();

	/**
	 * Returns a new object of class '<em>DQ Scope Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Scope Type</em>'.
	 * @generated
	 */
	DQScopeType createDQScopeType();

	/**
	 * Returns a new object of class '<em>DQ Temporal Accuracy Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Temporal Accuracy Property Type</em>'.
	 * @generated
	 */
	DQTemporalAccuracyPropertyType createDQTemporalAccuracyPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Temporal Consistency Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Temporal Consistency Property Type</em>'.
	 * @generated
	 */
	DQTemporalConsistencyPropertyType createDQTemporalConsistencyPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Temporal Consistency Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Temporal Consistency Type</em>'.
	 * @generated
	 */
	DQTemporalConsistencyType createDQTemporalConsistencyType();

	/**
	 * Returns a new object of class '<em>DQ Temporal Validity Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Temporal Validity Property Type</em>'.
	 * @generated
	 */
	DQTemporalValidityPropertyType createDQTemporalValidityPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Thematic Accuracy Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Thematic Accuracy Property Type</em>'.
	 * @generated
	 */
	DQThematicAccuracyPropertyType createDQThematicAccuracyPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Thematic Classification Correctness Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Thematic Classification Correctness Property Type</em>'.
	 * @generated
	 */
	DQThematicClassificationCorrectnessPropertyType createDQThematicClassificationCorrectnessPropertyType();

	/**
	 * Returns a new object of class '<em>DQ Topological Consistency Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Topological Consistency Property Type</em>'.
	 * @generated
	 */
	DQTopologicalConsistencyPropertyType createDQTopologicalConsistencyPropertyType();

	/**
	 * Returns a new object of class '<em>DS Aggregate Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Aggregate Property Type</em>'.
	 * @generated
	 */
	DSAggregatePropertyType createDSAggregatePropertyType();

	/**
	 * Returns a new object of class '<em>DS Association Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Association Property Type</em>'.
	 * @generated
	 */
	DSAssociationPropertyType createDSAssociationPropertyType();

	/**
	 * Returns a new object of class '<em>DS Association Type Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Association Type Code Property Type</em>'.
	 * @generated
	 */
	DSAssociationTypeCodePropertyType createDSAssociationTypeCodePropertyType();

	/**
	 * Returns a new object of class '<em>DS Data Set Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Data Set Property Type</em>'.
	 * @generated
	 */
	DSDataSetPropertyType createDSDataSetPropertyType();

	/**
	 * Returns a new object of class '<em>DS Data Set Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Data Set Type</em>'.
	 * @generated
	 */
	DSDataSetType createDSDataSetType();

	/**
	 * Returns a new object of class '<em>DS Initiative Type Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Initiative Type Code Property Type</em>'.
	 * @generated
	 */
	DSInitiativeTypeCodePropertyType createDSInitiativeTypeCodePropertyType();

	/**
	 * Returns a new object of class '<em>EX Extent Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>EX Extent Property Type</em>'.
	 * @generated
	 */
	EXExtentPropertyType createEXExtentPropertyType();

	/**
	 * Returns a new object of class '<em>EX Extent Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>EX Extent Type</em>'.
	 * @generated
	 */
	EXExtentType createEXExtentType();

	/**
	 * Returns a new object of class '<em>EX Geographic Extent Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>EX Geographic Extent Property Type</em>'.
	 * @generated
	 */
	EXGeographicExtentPropertyType createEXGeographicExtentPropertyType();

	/**
	 * Returns a new object of class '<em>EX Temporal Extent Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>EX Temporal Extent Property Type</em>'.
	 * @generated
	 */
	EXTemporalExtentPropertyType createEXTemporalExtentPropertyType();

	/**
	 * Returns a new object of class '<em>EX Temporal Extent Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>EX Temporal Extent Type</em>'.
	 * @generated
	 */
	EXTemporalExtentType createEXTemporalExtentType();

	/**
	 * Returns a new object of class '<em>EX Vertical Extent Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>EX Vertical Extent Property Type</em>'.
	 * @generated
	 */
	EXVerticalExtentPropertyType createEXVerticalExtentPropertyType();

	/**
	 * Returns a new object of class '<em>EX Vertical Extent Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>EX Vertical Extent Type</em>'.
	 * @generated
	 */
	EXVerticalExtentType createEXVerticalExtentType();

	/**
	 * Returns a new object of class '<em>Document Root</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Document Root</em>'.
	 * @generated
	 */
	DocumentRoot createDocumentRoot();

	/**
	 * Returns a new object of class '<em>DQ Temporal Validity Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Temporal Validity Type</em>'.
	 * @generated
	 */
	DQTemporalValidityType createDQTemporalValidityType();

	/**
	 * Returns a new object of class '<em>DQ Thematic Classification Correctness Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Thematic Classification Correctness Type</em>'.
	 * @generated
	 */
	DQThematicClassificationCorrectnessType createDQThematicClassificationCorrectnessType();

	/**
	 * Returns a new object of class '<em>DQ Topological Consistency Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DQ Topological Consistency Type</em>'.
	 * @generated
	 */
	DQTopologicalConsistencyType createDQTopologicalConsistencyType();

	/**
	 * Returns a new object of class '<em>DS Association Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Association Type</em>'.
	 * @generated
	 */
	DSAssociationType createDSAssociationType();

	/**
	 * Returns a new object of class '<em>DS Initiative Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Initiative Property Type</em>'.
	 * @generated
	 */
	DSInitiativePropertyType createDSInitiativePropertyType();

	/**
	 * Returns a new object of class '<em>DS Initiative Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Initiative Type</em>'.
	 * @generated
	 */
	DSInitiativeType createDSInitiativeType();

	/**
	 * Returns a new object of class '<em>DS Other Aggregate Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Other Aggregate Property Type</em>'.
	 * @generated
	 */
	DSOtherAggregatePropertyType createDSOtherAggregatePropertyType();

	/**
	 * Returns a new object of class '<em>DS Other Aggregate Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Other Aggregate Type</em>'.
	 * @generated
	 */
	DSOtherAggregateType createDSOtherAggregateType();

	/**
	 * Returns a new object of class '<em>DS Platform Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Platform Property Type</em>'.
	 * @generated
	 */
	DSPlatformPropertyType createDSPlatformPropertyType();

	/**
	 * Returns a new object of class '<em>DS Platform Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Platform Type</em>'.
	 * @generated
	 */
	DSPlatformType createDSPlatformType();

	/**
	 * Returns a new object of class '<em>DS Production Series Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Production Series Property Type</em>'.
	 * @generated
	 */
	DSProductionSeriesPropertyType createDSProductionSeriesPropertyType();

	/**
	 * Returns a new object of class '<em>DS Production Series Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Production Series Type</em>'.
	 * @generated
	 */
	DSProductionSeriesType createDSProductionSeriesType();

	/**
	 * Returns a new object of class '<em>DS Sensor Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Sensor Property Type</em>'.
	 * @generated
	 */
	DSSensorPropertyType createDSSensorPropertyType();

	/**
	 * Returns a new object of class '<em>DS Sensor Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Sensor Type</em>'.
	 * @generated
	 */
	DSSensorType createDSSensorType();

	/**
	 * Returns a new object of class '<em>DS Series Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Series Property Type</em>'.
	 * @generated
	 */
	DSSeriesPropertyType createDSSeriesPropertyType();

	/**
	 * Returns a new object of class '<em>DS Series Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Series Type</em>'.
	 * @generated
	 */
	DSSeriesType createDSSeriesType();

	/**
	 * Returns a new object of class '<em>DS Stereo Mate Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Stereo Mate Property Type</em>'.
	 * @generated
	 */
	DSStereoMatePropertyType createDSStereoMatePropertyType();

	/**
	 * Returns a new object of class '<em>DS Stereo Mate Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DS Stereo Mate Type</em>'.
	 * @generated
	 */
	DSStereoMateType createDSStereoMateType();

	/**
	 * Returns a new object of class '<em>EX Bounding Polygon Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>EX Bounding Polygon Property Type</em>'.
	 * @generated
	 */
	EXBoundingPolygonPropertyType createEXBoundingPolygonPropertyType();

	/**
	 * Returns a new object of class '<em>EX Bounding Polygon Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>EX Bounding Polygon Type</em>'.
	 * @generated
	 */
	EXBoundingPolygonType createEXBoundingPolygonType();

	/**
	 * Returns a new object of class '<em>EX Geographic Bounding Box Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>EX Geographic Bounding Box Property Type</em>'.
	 * @generated
	 */
	EXGeographicBoundingBoxPropertyType createEXGeographicBoundingBoxPropertyType();

	/**
	 * Returns a new object of class '<em>EX Geographic Bounding Box Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>EX Geographic Bounding Box Type</em>'.
	 * @generated
	 */
	EXGeographicBoundingBoxType createEXGeographicBoundingBoxType();

	/**
	 * Returns a new object of class '<em>EX Geographic Description Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>EX Geographic Description Property Type</em>'.
	 * @generated
	 */
	EXGeographicDescriptionPropertyType createEXGeographicDescriptionPropertyType();

	/**
	 * Returns a new object of class '<em>EX Geographic Description Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>EX Geographic Description Type</em>'.
	 * @generated
	 */
	EXGeographicDescriptionType createEXGeographicDescriptionType();

	/**
	 * Returns a new object of class '<em>EX Spatial Temporal Extent Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>EX Spatial Temporal Extent Property Type</em>'.
	 * @generated
	 */
	EXSpatialTemporalExtentPropertyType createEXSpatialTemporalExtentPropertyType();

	/**
	 * Returns a new object of class '<em>EX Spatial Temporal Extent Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>EX Spatial Temporal Extent Type</em>'.
	 * @generated
	 */
	EXSpatialTemporalExtentType createEXSpatialTemporalExtentType();

	/**
	 * Returns a new object of class '<em>Language Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Language Code Property Type</em>'.
	 * @generated
	 */
	LanguageCodePropertyType createLanguageCodePropertyType();

	/**
	 * Returns a new object of class '<em>LI Lineage Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>LI Lineage Property Type</em>'.
	 * @generated
	 */
	LILineagePropertyType createLILineagePropertyType();

	/**
	 * Returns a new object of class '<em>LI Lineage Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>LI Lineage Type</em>'.
	 * @generated
	 */
	LILineageType createLILineageType();

	/**
	 * Returns a new object of class '<em>LI Process Step Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>LI Process Step Property Type</em>'.
	 * @generated
	 */
	LIProcessStepPropertyType createLIProcessStepPropertyType();

	/**
	 * Returns a new object of class '<em>LI Process Step Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>LI Process Step Type</em>'.
	 * @generated
	 */
	LIProcessStepType createLIProcessStepType();

	/**
	 * Returns a new object of class '<em>LI Source Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>LI Source Property Type</em>'.
	 * @generated
	 */
	LISourcePropertyType createLISourcePropertyType();

	/**
	 * Returns a new object of class '<em>LI Source Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>LI Source Type</em>'.
	 * @generated
	 */
	LISourceType createLISourceType();

	/**
	 * Returns a new object of class '<em>Localised Character String Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Localised Character String Property Type</em>'.
	 * @generated
	 */
	LocalisedCharacterStringPropertyType createLocalisedCharacterStringPropertyType();

	/**
	 * Returns a new object of class '<em>Localised Character String Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Localised Character String Type</em>'.
	 * @generated
	 */
	LocalisedCharacterStringType createLocalisedCharacterStringType();

	/**
	 * Returns a new object of class '<em>MD Aggregate Information Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Aggregate Information Property Type</em>'.
	 * @generated
	 */
	MDAggregateInformationPropertyType createMDAggregateInformationPropertyType();

	/**
	 * Returns a new object of class '<em>MD Aggregate Information Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Aggregate Information Type</em>'.
	 * @generated
	 */
	MDAggregateInformationType createMDAggregateInformationType();

	/**
	 * Returns a new object of class '<em>MD Application Schema Information Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Application Schema Information Property Type</em>'.
	 * @generated
	 */
	MDApplicationSchemaInformationPropertyType createMDApplicationSchemaInformationPropertyType();

	/**
	 * Returns a new object of class '<em>MD Application Schema Information Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Application Schema Information Type</em>'.
	 * @generated
	 */
	MDApplicationSchemaInformationType createMDApplicationSchemaInformationType();

	/**
	 * Returns a new object of class '<em>MD Band Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Band Property Type</em>'.
	 * @generated
	 */
	MDBandPropertyType createMDBandPropertyType();

	/**
	 * Returns a new object of class '<em>MD Band Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Band Type</em>'.
	 * @generated
	 */
	MDBandType createMDBandType();

	/**
	 * Returns a new object of class '<em>MD Browse Graphic Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Browse Graphic Property Type</em>'.
	 * @generated
	 */
	MDBrowseGraphicPropertyType createMDBrowseGraphicPropertyType();

	/**
	 * Returns a new object of class '<em>MD Browse Graphic Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Browse Graphic Type</em>'.
	 * @generated
	 */
	MDBrowseGraphicType createMDBrowseGraphicType();

	/**
	 * Returns a new object of class '<em>MD Cell Geometry Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Cell Geometry Code Property Type</em>'.
	 * @generated
	 */
	MDCellGeometryCodePropertyType createMDCellGeometryCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Character Set Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Character Set Code Property Type</em>'.
	 * @generated
	 */
	MDCharacterSetCodePropertyType createMDCharacterSetCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Classification Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Classification Code Property Type</em>'.
	 * @generated
	 */
	MDClassificationCodePropertyType createMDClassificationCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Constraints Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Constraints Property Type</em>'.
	 * @generated
	 */
	MDConstraintsPropertyType createMDConstraintsPropertyType();

	/**
	 * Returns a new object of class '<em>MD Constraints Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Constraints Type</em>'.
	 * @generated
	 */
	MDConstraintsType createMDConstraintsType();

	/**
	 * Returns a new object of class '<em>MD Content Information Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Content Information Property Type</em>'.
	 * @generated
	 */
	MDContentInformationPropertyType createMDContentInformationPropertyType();

	/**
	 * Returns a new object of class '<em>MD Coverage Content Type Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Coverage Content Type Code Property Type</em>'.
	 * @generated
	 */
	MDCoverageContentTypeCodePropertyType createMDCoverageContentTypeCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Coverage Description Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Coverage Description Property Type</em>'.
	 * @generated
	 */
	MDCoverageDescriptionPropertyType createMDCoverageDescriptionPropertyType();

	/**
	 * Returns a new object of class '<em>MD Coverage Description Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Coverage Description Type</em>'.
	 * @generated
	 */
	MDCoverageDescriptionType createMDCoverageDescriptionType();

	/**
	 * Returns a new object of class '<em>MD Data Identification Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Data Identification Property Type</em>'.
	 * @generated
	 */
	MDDataIdentificationPropertyType createMDDataIdentificationPropertyType();

	/**
	 * Returns a new object of class '<em>MD Data Identification Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Data Identification Type</em>'.
	 * @generated
	 */
	MDDataIdentificationType createMDDataIdentificationType();

	/**
	 * Returns a new object of class '<em>MD Datatype Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Datatype Code Property Type</em>'.
	 * @generated
	 */
	MDDatatypeCodePropertyType createMDDatatypeCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Digital Transfer Options Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Digital Transfer Options Property Type</em>'.
	 * @generated
	 */
	MDDigitalTransferOptionsPropertyType createMDDigitalTransferOptionsPropertyType();

	/**
	 * Returns a new object of class '<em>MD Digital Transfer Options Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Digital Transfer Options Type</em>'.
	 * @generated
	 */
	MDDigitalTransferOptionsType createMDDigitalTransferOptionsType();

	/**
	 * Returns a new object of class '<em>MD Dimension Name Type Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Dimension Name Type Code Property Type</em>'.
	 * @generated
	 */
	MDDimensionNameTypeCodePropertyType createMDDimensionNameTypeCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Dimension Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Dimension Property Type</em>'.
	 * @generated
	 */
	MDDimensionPropertyType createMDDimensionPropertyType();

	/**
	 * Returns a new object of class '<em>MD Dimension Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Dimension Type</em>'.
	 * @generated
	 */
	MDDimensionType createMDDimensionType();

	/**
	 * Returns a new object of class '<em>MD Distribution Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Distribution Property Type</em>'.
	 * @generated
	 */
	MDDistributionPropertyType createMDDistributionPropertyType();

	/**
	 * Returns a new object of class '<em>MD Distribution Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Distribution Type</em>'.
	 * @generated
	 */
	MDDistributionType createMDDistributionType();

	/**
	 * Returns a new object of class '<em>MD Distribution Units Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Distribution Units Property Type</em>'.
	 * @generated
	 */
	MDDistributionUnitsPropertyType createMDDistributionUnitsPropertyType();

	/**
	 * Returns a new object of class '<em>MD Distributor Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Distributor Property Type</em>'.
	 * @generated
	 */
	MDDistributorPropertyType createMDDistributorPropertyType();

	/**
	 * Returns a new object of class '<em>MD Distributor Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Distributor Type</em>'.
	 * @generated
	 */
	MDDistributorType createMDDistributorType();

	/**
	 * Returns a new object of class '<em>MD Extended Element Information Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Extended Element Information Property Type</em>'.
	 * @generated
	 */
	MDExtendedElementInformationPropertyType createMDExtendedElementInformationPropertyType();

	/**
	 * Returns a new object of class '<em>MD Extended Element Information Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Extended Element Information Type</em>'.
	 * @generated
	 */
	MDExtendedElementInformationType createMDExtendedElementInformationType();

	/**
	 * Returns a new object of class '<em>MD Feature Catalogue Description Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Feature Catalogue Description Property Type</em>'.
	 * @generated
	 */
	MDFeatureCatalogueDescriptionPropertyType createMDFeatureCatalogueDescriptionPropertyType();

	/**
	 * Returns a new object of class '<em>MD Feature Catalogue Description Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Feature Catalogue Description Type</em>'.
	 * @generated
	 */
	MDFeatureCatalogueDescriptionType createMDFeatureCatalogueDescriptionType();

	/**
	 * Returns a new object of class '<em>MD Format Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Format Property Type</em>'.
	 * @generated
	 */
	MDFormatPropertyType createMDFormatPropertyType();

	/**
	 * Returns a new object of class '<em>MD Format Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Format Type</em>'.
	 * @generated
	 */
	MDFormatType createMDFormatType();

	/**
	 * Returns a new object of class '<em>MD Geometric Objects Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Geometric Objects Property Type</em>'.
	 * @generated
	 */
	MDGeometricObjectsPropertyType createMDGeometricObjectsPropertyType();

	/**
	 * Returns a new object of class '<em>MD Geometric Objects Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Geometric Objects Type</em>'.
	 * @generated
	 */
	MDGeometricObjectsType createMDGeometricObjectsType();

	/**
	 * Returns a new object of class '<em>MD Geometric Object Type Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Geometric Object Type Code Property Type</em>'.
	 * @generated
	 */
	MDGeometricObjectTypeCodePropertyType createMDGeometricObjectTypeCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Georectified Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Georectified Property Type</em>'.
	 * @generated
	 */
	MDGeorectifiedPropertyType createMDGeorectifiedPropertyType();

	/**
	 * Returns a new object of class '<em>MD Georectified Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Georectified Type</em>'.
	 * @generated
	 */
	MDGeorectifiedType createMDGeorectifiedType();

	/**
	 * Returns a new object of class '<em>MD Georeferenceable Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Georeferenceable Property Type</em>'.
	 * @generated
	 */
	MDGeoreferenceablePropertyType createMDGeoreferenceablePropertyType();

	/**
	 * Returns a new object of class '<em>MD Georeferenceable Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Georeferenceable Type</em>'.
	 * @generated
	 */
	MDGeoreferenceableType createMDGeoreferenceableType();

	/**
	 * Returns a new object of class '<em>MD Grid Spatial Representation Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Grid Spatial Representation Property Type</em>'.
	 * @generated
	 */
	MDGridSpatialRepresentationPropertyType createMDGridSpatialRepresentationPropertyType();

	/**
	 * Returns a new object of class '<em>MD Grid Spatial Representation Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Grid Spatial Representation Type</em>'.
	 * @generated
	 */
	MDGridSpatialRepresentationType createMDGridSpatialRepresentationType();

	/**
	 * Returns a new object of class '<em>MD Identification Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Identification Property Type</em>'.
	 * @generated
	 */
	MDIdentificationPropertyType createMDIdentificationPropertyType();

	/**
	 * Returns a new object of class '<em>MD Identifier Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Identifier Property Type</em>'.
	 * @generated
	 */
	MDIdentifierPropertyType createMDIdentifierPropertyType();

	/**
	 * Returns a new object of class '<em>MD Identifier Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Identifier Type</em>'.
	 * @generated
	 */
	MDIdentifierType createMDIdentifierType();

	/**
	 * Returns a new object of class '<em>MD Image Description Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Image Description Property Type</em>'.
	 * @generated
	 */
	MDImageDescriptionPropertyType createMDImageDescriptionPropertyType();

	/**
	 * Returns a new object of class '<em>MD Image Description Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Image Description Type</em>'.
	 * @generated
	 */
	MDImageDescriptionType createMDImageDescriptionType();

	/**
	 * Returns a new object of class '<em>MD Imaging Condition Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Imaging Condition Code Property Type</em>'.
	 * @generated
	 */
	MDImagingConditionCodePropertyType createMDImagingConditionCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Keywords Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Keywords Property Type</em>'.
	 * @generated
	 */
	MDKeywordsPropertyType createMDKeywordsPropertyType();

	/**
	 * Returns a new object of class '<em>MD Keywords Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Keywords Type</em>'.
	 * @generated
	 */
	MDKeywordsType createMDKeywordsType();

	/**
	 * Returns a new object of class '<em>MD Keyword Type Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Keyword Type Code Property Type</em>'.
	 * @generated
	 */
	MDKeywordTypeCodePropertyType createMDKeywordTypeCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Legal Constraints Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Legal Constraints Property Type</em>'.
	 * @generated
	 */
	MDLegalConstraintsPropertyType createMDLegalConstraintsPropertyType();

	/**
	 * Returns a new object of class '<em>MD Legal Constraints Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Legal Constraints Type</em>'.
	 * @generated
	 */
	MDLegalConstraintsType createMDLegalConstraintsType();

	/**
	 * Returns a new object of class '<em>MD Maintenance Frequency Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Maintenance Frequency Code Property Type</em>'.
	 * @generated
	 */
	MDMaintenanceFrequencyCodePropertyType createMDMaintenanceFrequencyCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Maintenance Information Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Maintenance Information Property Type</em>'.
	 * @generated
	 */
	MDMaintenanceInformationPropertyType createMDMaintenanceInformationPropertyType();

	/**
	 * Returns a new object of class '<em>MD Maintenance Information Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Maintenance Information Type</em>'.
	 * @generated
	 */
	MDMaintenanceInformationType createMDMaintenanceInformationType();

	/**
	 * Returns a new object of class '<em>MD Medium Format Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Medium Format Code Property Type</em>'.
	 * @generated
	 */
	MDMediumFormatCodePropertyType createMDMediumFormatCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Medium Name Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Medium Name Code Property Type</em>'.
	 * @generated
	 */
	MDMediumNameCodePropertyType createMDMediumNameCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Medium Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Medium Property Type</em>'.
	 * @generated
	 */
	MDMediumPropertyType createMDMediumPropertyType();

	/**
	 * Returns a new object of class '<em>MD Medium Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Medium Type</em>'.
	 * @generated
	 */
	MDMediumType createMDMediumType();

	/**
	 * Returns a new object of class '<em>MD Metadata Extension Information Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Metadata Extension Information Property Type</em>'.
	 * @generated
	 */
	MDMetadataExtensionInformationPropertyType createMDMetadataExtensionInformationPropertyType();

	/**
	 * Returns a new object of class '<em>MD Metadata Extension Information Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Metadata Extension Information Type</em>'.
	 * @generated
	 */
	MDMetadataExtensionInformationType createMDMetadataExtensionInformationType();

	/**
	 * Returns a new object of class '<em>MD Metadata Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Metadata Property Type</em>'.
	 * @generated
	 */
	MDMetadataPropertyType createMDMetadataPropertyType();

	/**
	 * Returns a new object of class '<em>MD Metadata Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Metadata Type</em>'.
	 * @generated
	 */
	MDMetadataType createMDMetadataType();

	/**
	 * Returns a new object of class '<em>MD Obligation Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Obligation Code Property Type</em>'.
	 * @generated
	 */
	MDObligationCodePropertyType createMDObligationCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Pixel Orientation Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Pixel Orientation Code Property Type</em>'.
	 * @generated
	 */
	MDPixelOrientationCodePropertyType createMDPixelOrientationCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Portrayal Catalogue Reference Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Portrayal Catalogue Reference Property Type</em>'.
	 * @generated
	 */
	MDPortrayalCatalogueReferencePropertyType createMDPortrayalCatalogueReferencePropertyType();

	/**
	 * Returns a new object of class '<em>MD Portrayal Catalogue Reference Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Portrayal Catalogue Reference Type</em>'.
	 * @generated
	 */
	MDPortrayalCatalogueReferenceType createMDPortrayalCatalogueReferenceType();

	/**
	 * Returns a new object of class '<em>MD Progress Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Progress Code Property Type</em>'.
	 * @generated
	 */
	MDProgressCodePropertyType createMDProgressCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Range Dimension Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Range Dimension Property Type</em>'.
	 * @generated
	 */
	MDRangeDimensionPropertyType createMDRangeDimensionPropertyType();

	/**
	 * Returns a new object of class '<em>MD Range Dimension Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Range Dimension Type</em>'.
	 * @generated
	 */
	MDRangeDimensionType createMDRangeDimensionType();

	/**
	 * Returns a new object of class '<em>MD Reference System Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Reference System Property Type</em>'.
	 * @generated
	 */
	MDReferenceSystemPropertyType createMDReferenceSystemPropertyType();

	/**
	 * Returns a new object of class '<em>MD Reference System Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Reference System Type</em>'.
	 * @generated
	 */
	MDReferenceSystemType createMDReferenceSystemType();

	/**
	 * Returns a new object of class '<em>MD Representative Fraction Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Representative Fraction Property Type</em>'.
	 * @generated
	 */
	MDRepresentativeFractionPropertyType createMDRepresentativeFractionPropertyType();

	/**
	 * Returns a new object of class '<em>MD Representative Fraction Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Representative Fraction Type</em>'.
	 * @generated
	 */
	MDRepresentativeFractionType createMDRepresentativeFractionType();

	/**
	 * Returns a new object of class '<em>MD Resolution Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Resolution Property Type</em>'.
	 * @generated
	 */
	MDResolutionPropertyType createMDResolutionPropertyType();

	/**
	 * Returns a new object of class '<em>MD Resolution Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Resolution Type</em>'.
	 * @generated
	 */
	MDResolutionType createMDResolutionType();

	/**
	 * Returns a new object of class '<em>MD Restriction Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Restriction Code Property Type</em>'.
	 * @generated
	 */
	MDRestrictionCodePropertyType createMDRestrictionCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Scope Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Scope Code Property Type</em>'.
	 * @generated
	 */
	MDScopeCodePropertyType createMDScopeCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Scope Description Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Scope Description Property Type</em>'.
	 * @generated
	 */
	MDScopeDescriptionPropertyType createMDScopeDescriptionPropertyType();

	/**
	 * Returns a new object of class '<em>MD Scope Description Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Scope Description Type</em>'.
	 * @generated
	 */
	MDScopeDescriptionType createMDScopeDescriptionType();

	/**
	 * Returns a new object of class '<em>MD Security Constraints Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Security Constraints Property Type</em>'.
	 * @generated
	 */
	MDSecurityConstraintsPropertyType createMDSecurityConstraintsPropertyType();

	/**
	 * Returns a new object of class '<em>MD Security Constraints Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Security Constraints Type</em>'.
	 * @generated
	 */
	MDSecurityConstraintsType createMDSecurityConstraintsType();

	/**
	 * Returns a new object of class '<em>MD Service Identification Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Service Identification Property Type</em>'.
	 * @generated
	 */
	MDServiceIdentificationPropertyType createMDServiceIdentificationPropertyType();

	/**
	 * Returns a new object of class '<em>MD Service Identification Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Service Identification Type</em>'.
	 * @generated
	 */
	MDServiceIdentificationType createMDServiceIdentificationType();

	/**
	 * Returns a new object of class '<em>MD Spatial Representation Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Spatial Representation Property Type</em>'.
	 * @generated
	 */
	MDSpatialRepresentationPropertyType createMDSpatialRepresentationPropertyType();

	/**
	 * Returns a new object of class '<em>MD Spatial Representation Type Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Spatial Representation Type Code Property Type</em>'.
	 * @generated
	 */
	MDSpatialRepresentationTypeCodePropertyType createMDSpatialRepresentationTypeCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Standard Order Process Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Standard Order Process Property Type</em>'.
	 * @generated
	 */
	MDStandardOrderProcessPropertyType createMDStandardOrderProcessPropertyType();

	/**
	 * Returns a new object of class '<em>MD Standard Order Process Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Standard Order Process Type</em>'.
	 * @generated
	 */
	MDStandardOrderProcessType createMDStandardOrderProcessType();

	/**
	 * Returns a new object of class '<em>MD Topic Category Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Topic Category Code Property Type</em>'.
	 * @generated
	 */
	MDTopicCategoryCodePropertyType createMDTopicCategoryCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Topology Level Code Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Topology Level Code Property Type</em>'.
	 * @generated
	 */
	MDTopologyLevelCodePropertyType createMDTopologyLevelCodePropertyType();

	/**
	 * Returns a new object of class '<em>MD Usage Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Usage Property Type</em>'.
	 * @generated
	 */
	MDUsagePropertyType createMDUsagePropertyType();

	/**
	 * Returns a new object of class '<em>MD Usage Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Usage Type</em>'.
	 * @generated
	 */
	MDUsageType createMDUsageType();

	/**
	 * Returns a new object of class '<em>MD Vector Spatial Representation Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Vector Spatial Representation Property Type</em>'.
	 * @generated
	 */
	MDVectorSpatialRepresentationPropertyType createMDVectorSpatialRepresentationPropertyType();

	/**
	 * Returns a new object of class '<em>MD Vector Spatial Representation Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MD Vector Spatial Representation Type</em>'.
	 * @generated
	 */
	MDVectorSpatialRepresentationType createMDVectorSpatialRepresentationType();

	/**
	 * Returns a new object of class '<em>PT Free Text Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>PT Free Text Property Type</em>'.
	 * @generated
	 */
	PTFreeTextPropertyType createPTFreeTextPropertyType();

	/**
	 * Returns a new object of class '<em>PT Free Text Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>PT Free Text Type</em>'.
	 * @generated
	 */
	PTFreeTextType createPTFreeTextType();

	/**
	 * Returns a new object of class '<em>PT Locale Container Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>PT Locale Container Property Type</em>'.
	 * @generated
	 */
	PTLocaleContainerPropertyType createPTLocaleContainerPropertyType();

	/**
	 * Returns a new object of class '<em>PT Locale Container Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>PT Locale Container Type</em>'.
	 * @generated
	 */
	PTLocaleContainerType createPTLocaleContainerType();

	/**
	 * Returns a new object of class '<em>PT Locale Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>PT Locale Property Type</em>'.
	 * @generated
	 */
	PTLocalePropertyType createPTLocalePropertyType();

	/**
	 * Returns a new object of class '<em>PT Locale Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>PT Locale Type</em>'.
	 * @generated
	 */
	PTLocaleType createPTLocaleType();

	/**
	 * Returns a new object of class '<em>RS Identifier Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>RS Identifier Property Type</em>'.
	 * @generated
	 */
	RSIdentifierPropertyType createRSIdentifierPropertyType();

	/**
	 * Returns a new object of class '<em>RS Identifier Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>RS Identifier Type</em>'.
	 * @generated
	 */
	RSIdentifierType createRSIdentifierType();

	/**
	 * Returns a new object of class '<em>RS Reference System Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>RS Reference System Property Type</em>'.
	 * @generated
	 */
	RSReferenceSystemPropertyType createRSReferenceSystemPropertyType();

	/**
	 * Returns a new object of class '<em>URL Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>URL Property Type</em>'.
	 * @generated
	 */
	URLPropertyType createURLPropertyType();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	GMDPackage getGMDPackage();

} //GMDFactory
