/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.isotc211._2005.gmd;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.isotc211._2005.gco.GCOPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * Geographic MetaData (GMD) extensible markup language is a component of the XML Schema Implementation of Geographic Information Metadata documented in ISO/TS 19139:2007. GMD includes all the definitions of http://www.isotc211.org/2005/gmd namespace. The root document of this namespace is the file gmd.xsd. This extent.xsd schema implements the UML conceptual schema defined in A.3.1 of ISO 19115:2003 and the associated corrigendum. It contains the implementation of the following classes: EX_TemporalExtent, EX_VerticalExtent, EX_BoundingPolygon, EX_Extent, EX_GeographicExtent, EX_GeographicBoundingBox, EX_SpatialTemporalExtent, EX_GeographicDescription.
 * Geographic MetaData (GMD) extensible markup language is a component of the XML Schema Implementation of Geographic Information Metadata documented in ISO/TS 19139:2007. GMD includes all the definitions of http://www.isotc211.org/2005/gmd namespace. The root document of this namespace is the file gmd.xsd.
 * Geographic MetaData (GMD) extensible markup language is a component of the XML Schema Implementation of Geographic Information Metadata documented in ISO/TS 19139:2007. GMD includes all the definitions of http://www.isotc211.org/2005/gmd namespace. The root document of this namespace is the file gmd.xsd. This metadataApplication.xsd schema implements the UML conceptual schema defined in A.2.12 of ISO 19115:2003. It contains the implementation of the class: MD_ApplicationSchemaInformation.
 * Geographic MetaData (GMD) extensible markup language is a component of the XML Schema Implementation of Geographic Information Metadata documented in ISO/TS 19139:2007. GMD includes all the definitions of http://www.isotc211.org/2005/gmd namespace. The root document of this namespace is the file gmd.xsd. This referenceSystem.xsd schema implements the UML conceptual schema defined in A.2.7 of ISO 19115:2003 and ISO 19115:2003/Cor. 1:2006. It contains the implementation of the following classes: RS_Identifier, MD_ReferenceSystem, MD_Identifier and RS_Reference System.
 * Geographic MetaData (GMD) extensible markup language is a component of the XML Schema Implementation of Geographic Information Metadata documented in ISO/TS 19139:2007. GMD includes all the definitions of http://www.isotc211.org/2005/gmd namespace. The root document of this namespace is the file gmd.xsd. This citation.xsd schema implements the UML conceptual schema defined in A.3.2 of ISO 19115:2003. It contains the implementation of the following classes: CI_ResponsibleParty, CI_Citation, CI_Address, CI_OnlineResource, CI_Contact, CI_Telephone, URL, CI_Date, CI_Series, CI_RoleCode, CI_PresentationFormCode, CI_OnLineFunctionCode, CI_DateTypeCode.
 * Geographic Temporal Schema (GTS) extensible markup language is a component of the XML Schema Implementation of Geographic Information Metadata documented in ISO/TS 19139:2007. GTS includes all the definitions of http://www.isotc211.org/2005/gts namespace. The root document of this namespace is the file gts.xsd.
 * Geographic Temporal Schema (GTS) extensible markup language is a component of the XML Schema Implementation of Geographic Information Metadata documented in ISO/TS 19139:2007. GTS includes all the definitions of http://www.isotc211.org/2005/gts namespace. The root document of this namespace is the file gts.xsd. The temporalObjects.xsd schema contains the XML implementation of TM_Object, TM_Primitive and TM_PeriodDuration from ISO 19108. The encoding of these classes is mapped to ISO 19136 temporal types and W3C built-in types.
 * 
 * 			GML is an OGC Standard.
 * 			Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * 			To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 15.6.
 * A number of types and relationships are defined to represent the time-varying properties of geographic features. 
 * In a comprehensive treatment of spatiotemporal modeling, Langran (see Bibliography) distinguished three principal temporal entities: states, events, and evidence; the schema specified in the following Subclauses incorporates elements for each.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 Clause 14.
 * Topology is the branch of mathematics describing the properties of objects which are invariant under continuous deformation. For example, a circle is topologically equivalent to an ellipse because one can be transformed into the other by stretching. In geographic modelling, the foremost use of topology is in accelerating computational geometry. The constructs of topology allow characterisation of the spatial relationships between objects using simple combinatorial or algebraic algorithms. Topology, realised by the appropriate geometry, also allows a compact and unambiguous mechanism for expressing shared geometry among geographic features.
 * There are four instantiable classes of primitive topology objects, one for each dimension up to 3D. In addition, topological complexes are supported, too. 
 * There is strong symmetry in the (topological boundary and coboundary) relationships between topology primitives of adjacent dimensions. Topology primitives are bounded by directed primitives of one lower dimension. The coboundary of each topology primitive is formed from directed topology primitives of one higher dimension.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 20.3.
 * A coverage incorporates a mapping from a spatiotemporal domain to a range set, the latter providing the set in which the attribute values live.  The range set may be an arbitrary set including discrete lists, integer or floating point ranges, and multi-dimensional vector spaces.
 * A coverage can be viewed as the graph of the coverage function f:A à B, that is as the set of ordered pairs {(x, f(x)) | where x is in A}. This view is especially applicable to the GML encoding of a coverage.  In the case of a discrete coverage, the domain set A is partitioned into a collection of subsets (typically a disjoint collection) A = UAi and the function f is constant on each Ai. For a spatial domain, the Ai are geometry elements, hence the coverage can be viewed as a collection of (geometry,value) pairs, where the value is an element of the range set.  If the spatial domain A is a topological space then the coverage can be viewed as a collection of (topology,value) pairs, where the topology element in the pair is a topological n-chain (in GML terms this is a gml:TopoPoint, gml:TopoCurve, gml:TopoSurface or gml:TopoSolid). 
 * A coverage is implemented as a GML feature. We can thus speak of a "temperature distribution feature", or a "remotely sensed image feature", or a "soil distribution feature".
 * As is the case for any GML object, a coverage object may also be the value of a property of a feature.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 13.3.
 * The spatial-temporal coordinate reference systems schema components are divided into two logical parts. One part defines elements and types for XML encoding of abstract coordinate reference systems definitions. The larger part defines specialized constructs for XML encoding of definitions of the multiple concrete types of spatial-temporal coordinate reference systems.
 * These schema components encode the Coordinate Reference System packages of the UML Models of ISO 19111 Clause 8 and ISO/DIS 19136 D.3.10, with the exception of the abstract "SC_CRS" class.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 Clause 19.
 * A GML observation models the act of observing, often with a camera, a person or some form of instrument.  An observation feature describes the "metadata" associated with an information capture event, together with a value for the result of the observation.  This covers a broad range of cases, from a tourist photo (not the photo but the act of taking the photo), to images acquired by space borne sensors or the measurement of a temperature 5 meters below the surfaces of a lake.
 * The basic structures introduced in this schema are intended to serve as the foundation for more comprehensive schemas for scientific, technical and engineering measurement schemas.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 15.5.
 * A value in the time domain is measured relative to a temporal reference system. Common types of reference systems include calendars, ordinal temporal reference systems, and temporal coordinate systems (time elapsed since some epoch).  The primary temporal reference system for use with geographic information is the Gregorian Calendar and 24 hour local or Coordinated Universal Time (UTC), but special applications may entail the use of alternative reference systems.  The Julian day numbering system is a temporal coordinate system that has an origin earlier than any known calendar, at noon on 1 January 4713 BC in the Julian proleptic calendar, and is useful in transformations between dates in different calendars.    
 * In GML seven concrete elements are used to describe temporal reference systems: gml:TimeReferenceSystem, gml:TimeCoordinateSystem, gml:TimeCalendar, gml:TimeCalendarEra, gml:TimeClock, gml:TimeOrdinalReferenceSystem, and gml:TimeOrdinalEra.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * All global schema components that are part of the GML schema, but were deprecated. See Annex I.
 * 			
 * 			GML is an OGC Standard.
 * 			Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * 			To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 15.3.
 * Temporal topology is described in terms of time complexes, nodes, and edges, and the connectivity between these. Temporal topology does not directly provide information about temporal position. It is used in the case of describing a lineage or a history (e.g. a family tree expressing evolution of species, an ecological cycle, a lineage of lands or buildings, or a history of separation and merger of administrative boundaries). The following Subclauses specifies the temporal topology as temporal characteristics of features in compliance with ISO 19108.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 Clause 16.
 * Many applications require definitions of terms which are used within instance documents as the values of certain properties or as reference information to tie properties to standard information values in some way.  Units of measure and descriptions of measurable phenomena are two particular examples. 
 * It will often be convenient to use definitions provided by external authorities. These may already be packaged for delivery in various ways, both online and offline. In order that they may be referred to from GML documents it is generally necessary that a URI be available for each definition. Where this is the case then it is usually preferable to refer to these directly. 
 * Alternatively, it may be convenient or necessary to capture definitions in XML, either embedded within an instance document containing features or as a separate document. The definitions may be transcriptions from an external source, or may be new definitions for a local purpose. In order to support this case, some simple components are provided in GML in the form of 
 * -	a generic gml:Definition, which may serve as the basis for more specialized definitions
 * -	a generic gml:Dictionary, which allows a set of definitions or references to definitions to be collected 
 * These components may be used directly, but also serve as the basis for more specialised definition elements in GML, in particular: coordinate operations, coordinate reference systems, datums, temporal reference systems, and units of measure.  
 * Note that the GML definition and dictionary components implement a simple nested hierarchy of definitions with identifiers. The latter provide handles which may be used in the description of more complex relationships between terms. However, the GML dictionary components are not intended to provide direct support for complex taxonomies, ontologies or thesauri.  Specialised XML tools are available to satisfy the more sophisticated requirements.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 7.2.
 * The gmlBase schema components establish the GML model and syntax, in particular
 * -	a root XML type from which XML types for all GML objects should be derived,
 * -	a pattern and components for GML properties,
 * -	patterns for collections and arrays, and components for generic collections and arrays,
 * -	components for associating metadata with GML objects,
 * -	components for constructing definitions and dictionaries.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 15.2.
 * The GML temporal schemas include components for describing temporal geometry and topology, temporal reference systems, and the temporal characteristics of geographic data. The model underlying the representation constitutes a profile of the conceptual schema described in ISO 19108. The underlying spatiotemporal model strives to accommodate both feature-level and attribute-level time stamping; basic support for tracking moving objects is also included. 
 * Time is measured on two types of scales: interval and ordinal.  An interval scale offers a basis for measuring duration, an ordinal scale provides information only about relative position in time.
 * Two other ISO standards are relevant to describing temporal objects:  ISO 8601 describes encodings for time instants and time periods, as text strings with particular structure and punctuation; ISO 11404 provides a detailed description of time intervals as part of a general discussion of language independent datatypes.  
 * The temporal schemas cover two interrelated topics and provide basic schema components for representing temporal instants and periods, temporal topology, and reference systems; more specialized schema components defines components used for dynamic features. Instances of temporal geometric types are used as values for the temporal properties of geographic features.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 Clause 9.
 * A GML feature is a (representation of a) identifiable real-world object in a selected domain of discourse. The feature schema provides a framework for the creation of GML features and feature collections.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 Clause 18.
 * The direction schema components provide the GML Application Schema developer with a standard property element to describe direction, and associated objects that may be used to express orientation, direction, heading, bearing or other directional aspects of geographic features.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 17.5.
 * The elements declared in this Clause build on other GML schema components, in particular gml:AbstractTimeObject, gml:AbstractGeometry, and the following types:  gml:MeasureType, gml:MeasureListType, gml:CodeType, gml:CodeOrNilReasonListType, gml:BooleanOrNilReasonListType, gml:IntegerOrNilReasonList.  
 * Of particular interest are elements that are the heads of substitution groups, and one named choice group. These are the primary reasons for the value objects schema, since they may act as variables in the definition of content models, such as Observations, when it is desired to permit alternative value types to occur some of which may have complex content such as arrays, geometry and time objects, and where it is useful not to prescribe the actual value type in advance. The members of the groups include quantities, category classifications, boolean, count, temporal and spatial values, and aggregates of these.  
 * The value objects are defined in a hierarchy. The following relationships are defined:
 * -	Concrete elements gml:Quantity, gml:Category, gml:Count and gml:Boolean are substitutable for the abstract element gml:AbstractScalarValue.  
 * -	Concrete elements gml:QuantityList, gml:CategoryList, gml:CountList and gml:BooleanList are substitutable for the abstract element gml:AbstractScalarValueList.  
 * -	Concrete element gml:ValueArray is substitutable for the concrete element gml:CompositeValue.  
 * -	Abstract elements gml:AbstractScalarValue and gml:AbstractScalarValueList, and concrete elements gml:CompositeValue, gml:ValueExtent, gml:CategoryExtent, gml:CountExtent and gml:QuantityExtent are substitutable for abstract element gml:AbstractValue.  
 * -	Abstract elements gml:AbstractValue, gml:AbstractTimeObject and gml:AbstractGeometry are all in a choice group named gml:Value, which is used for compositing in gml:CompositeValue and gml:ValueExtent.  
 * -	Schemas which need values may use the abstract element gml:AbstractValue in a content model in order to permit any of the gml:AbstractScalarValues, gml:AbstractScalarValueLists, gml:CompositeValue or gml:ValueExtent to occur in an instance, or the named group gml:Value to also permit gml:AbstractTimeObjects, gml:AbstractGeometrys.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 Clause 10.
 * Any geometry element that inherits the semantics of AbstractGeometryType may be viewed as a set of direct positions. 
 * All of the classes derived from AbstractGeometryType inherit an optional association to a coordinate reference system. All direct positions shall directly or indirectly be associated with a coordinate reference system. When geometry elements are aggregated in another geometry element (such as a MultiGeometry or GeometricComplex), which already has a coordinate reference system specified, then these elements are assumed to be in that same coordinate reference system unless otherwise specified.
 * The geometry model distinguishes geometric primitives, aggregates and complexes. 
 * Geometric primitives, i.e. instances of a subtype of AbstractGeometricPrimitiveType, will be open, that is, they will not contain their boundary points; curves will not contain their end points, surfaces will not contain their boundary curves, and solids will not contain their bounding surfaces.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 13.4.
 * The coordinate systems schema components can be divded into  three logical parts, which define elements and types for XML encoding of the definitions of:
 * -	Coordinate system axes
 * -	Abstract coordinate system
 * -	Multiple concrete types of spatial-temporal coordinate systems
 * These schema components encode the Coordinate System packages of the UML Models of ISO 19111 Clause 9 and ISO/DIS 19136 D.3.10.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 13.5
 * The datums schema components can be divided into three logical parts, which define elements and types for XML encoding of the definitions of:
 * -	Abstract datum
 * -	Geodetic datums, including ellipsoid and prime meridian
 * -	Multiple other concrete types of spatial or temporal datums
 * These schema components encode the Datum packages of the UML Models of ISO 19111 Clause 10 and ISO/DIS 19136 D.3.10.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 13.6.
 * The spatial or temporal coordinate operations schema components can be divided into five logical parts, which define elements and types for XML encoding of the definitions of:
 * -	Multiple abstract coordinate operations
 * -	Multiple concrete types of coordinate operations, including Transformations and Conversions
 * -	Abstract and concrete parameter values and groups
 * -	Operation methods
 * -	Abstract and concrete operation parameters and groups
 * These schema component encodes the Coordinate Operation package of the UML Model for ISO 19111 Clause 11.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 13.2.
 * The reference systems schema components have two logical parts, which define elements and types for XML encoding of the definitions of:
 * -	Identified Object, inherited by the ten types of GML objects used for coordinate reference systems and coordinate operations
 * -	High-level part of the definitions of coordinate reference systems
 * This schema encodes the Identified Object and Reference System packages of the UML Model for ISO 19111.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 17.3.
 * gml:MeasureType is defined in the basicTypes schema.  The measure types defined here correspond with a set of convenience measure types described in ISO/TS 19103.  The XML implementation is based on the XML Schema simple type "double" which supports both decimal and scientific notation, and includes an XML attribute "uom" which refers to the units of measure for the value.  Note that, there is no requirement to store values using any particular format, and applications receiving elements of this type may choose to coerce the data to any other type as convenient.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 17.2.
 * Several GML Schema components concern or require a reference scale or units of measure.  Units are required for quantities that may occur as values of properties of feature types, as the results of observations, in the range parameters of a coverage, and for measures used in Coordinate Reference System definitions. 
 * The basic unit definition is an extension of the general gml:Definition element defined in 16.2.1.  Three specialized elements for unit definition are further derived from this. 
 * This model is based on the SI system of units [ISO 1000], which distinguishes between Base Units and Derived Units.  
 * -	Base Units are the preferred units for a set of orthogonal fundamental quantities which define the particular system of units, which may not be derived by combination of other base units.  
 * -	Derived Units are the preferred units for other quantities in the system, which may be defined by algebraic combination of the base units.  
 * In some application areas Conventional units are used, which may be converted to the preferred units using a scaling factor or a formula which defines a re-scaling and offset.  The set of preferred units for all physical quantity types in a particular system of units is composed of the union of its base units and derived units.  
 * Unit definitions are substitutable for the gml:Definition element declared as part of the dictionary model.  A dictionary that contains only unit definitions and references to unit definitions is a units dictionary.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 20.2.
 * An implicit description of geometry is one in which the items of the geometry do not explicitly appear in the encoding.  Instead, a compact notation records a set of parameters, and a set of objects may be generated using a rule with these parameters.  This Clause provides grid geometries that are used in the description of gridded coverages and other applications.
 * In GML two grid structures are defined, namely gml:Grid and gml:RectifiedGrid.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 12.3.
 * Geometric aggregates (i.e. instances of a subtype of gml:AbstractGeometricAggregateType) are arbitrary aggregations of geometry elements. They are not assumed to have any additional internal structure and are used to "collect" pieces of geometry of a specified type. Application schemas may use aggregates for features that use multiple geometric objects in their representations.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 Clause 11.
 * Beside the "simple" geometric primitives specified in the previous Clause, this Clause specifies additional primitives to describe real world situations which require a more expressive geometry model.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 12.2.
 * Geometric complexes (i.e. instances of gml:GeometricComplexType) are closed collections of geometric primitives, i.e. they will contain their boundaries. 
 * A geometric complex (gml:GeometricComplex) is defined by ISO 19107:2003, 6.6.1 as "a set of primitive geometric objects (in a common coordinate system) whose interiors are disjoint. Further, if a primitive is in a geometric complex, then there exists a set of primitives in that complex whose point-wise union is the boundary of this first primitive."
 * A geometric composite (gml:CompositeCurve, gml:CompositeSurface and gml:CompositeSolid) represents a geometric complex with an underlying core geometry that is isomorphic to a primitive, i.e. it can be viewed as a primitive and as a complex. See ISO 19107:2003, 6.1 and 6.6.3 for more details on the nature of composite geometries.
 * Geometric complexes and composites are intended to be used in application schemas where the sharing of geometry is important.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * See ISO/DIS 19136 8.2.
 * W3C XML Schema provides a set of built-in "simple" types which define methods for representing values as literals without internal markup.  These are described in W3C XML Schema Part 2:2001.  Because GML is an XML encoding in which instances are described using XML Schema, these simple types shall be used as far as possible and practical for the representation of data types.  W3C XML Schema also provides methods for defining 
 * -	new simple types by restriction and combination of the built-in types, and 
 * -	complex types, with simple content, but which also have XML attributes.  
 * In many places where a suitable built-in simple type is not available, simple content types derived using the XML Schema mechanisms are used for the representation of data types in GML.  
 * A set of these simple content types that are required by several GML components are defined in the basicTypes schema, as well as some elements based on them. These are primarily based around components needed to record amounts, counts, flags and terms, together with support for exceptions or null values.
 * 
 * GML is an OGC Standard.
 * Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * This schema document provides attribute declarations and
 * attribute group, complex type and simple type definitions which can be used in
 * the construction of user schemas to define the structure of particular linking
 * constructs, e.g.
 * 
 * <xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema"
 *            xmlns:xl="http://www.w3.org/1999/xlink">
 * 
 *  <xs:import namespace="http://www.w3.org/1999/xlink"
 *             location="http://www.w3.org/1999/xlink.xsd">
 * 
 *  <xs:element name="mySimple">
 *   <xs:complexType>
 *    ...
 *    <xs:attributeGroup ref="xl:simpleAttrs"/>
 *    ...
 *   </xs:complexType>
 *  </xs:element>
 *  ...
 * </xs:schema>
 * 
 *      
 *   <div xmlns="http://www.w3.org/1999/xhtml">
 *         
 *     <h1>About the XML namespace</h1>
 *         
 *     <div class="bodytext">
 *            
 *       <p>
 *       This schema document describes the XML namespace, in a form
 *       suitable for import by other schema documents.
 *      </p>
 *            
 *       <p>
 *               See 
 *         <a href="http://www.w3.org/XML/1998/namespace.html">
 *       http://www.w3.org/XML/1998/namespace.html</a>
 *          and
 *       
 *         <a href="http://www.w3.org/TR/REC-xml">
 *       http://www.w3.org/TR/REC-xml</a>
 *          for information 
 *       about this namespace.
 *      
 *       </p>
 *            
 *       <p>
 *       Note that local names in this namespace are intended to be
 *       defined only by the World Wide Web Consortium or its subgroups.
 *       The names currently defined in this namespace are listed below.
 *       They should not be used with conflicting semantics by any Working
 *       Group, specification, or document instance.
 *      </p>
 *            
 *       <p>
 *            
 *       See further below in this document for more information about 
 *         <a href="#usage">how to refer to this schema document from your own
 *       XSD schema documents</a>
 *          and about 
 *         <a href="#nsversioning">the
 *       namespace-versioning policy governing this schema document</a>
 *         .
 *      
 *       </p>
 *           
 *     </div>
 *        
 *   </div>
 *     
 * 
 * 
 *      
 *   <div xmlns="http://www.w3.org/1999/xhtml">
 *        
 *     
 *     <h3>Father (in any context at all)</h3>
 *      
 * 
 *     
 *     <div class="bodytext">
 *            
 *       <p>
 *       denotes Jon Bosak, the chair of 
 *       the original XML Working Group.  This name is reserved by 
 *       the following decision of the W3C XML Plenary and 
 *       XML Coordination groups:
 *      </p>
 *            
 *       <blockquote>
 *                
 *         <p>
 * 	In appreciation for his vision, leadership and
 * 	dedication the W3C XML Plenary on this 10th day of
 * 	February, 2000, reserves for Jon Bosak in perpetuity
 * 	the XML name "xml:Father".
 *        </p>
 *              
 *       </blockquote>
 *           
 *     </div>
 *        
 *   </div>
 *     
 * 
 * 
 *      
 *   <div id="usage" xml:id="usage" xmlns="http://www.w3.org/1999/xhtml">
 *         
 *     <h2>
 *       <a name="usage">About this schema document</a>
 *     </h2>
 *         
 *     <div class="bodytext">
 *            
 *       <p>
 *               This schema defines attributes and an attribute group suitable
 *       for use by schemas wishing to allow 
 *         <code>xml:base</code>
 *         ,
 *       
 *         <code>xml:lang</code>
 *         , 
 *         <code>xml:space</code>
 *          or
 *       
 *         <code>xml:id</code>
 *          attributes on elements they define.
 *      
 *       </p>
 *            
 *       <p>
 *       To enable this, such a schema must import this schema for
 *       the XML namespace, e.g. as follows:
 *      </p>
 *            
 *       <pre>
 *           &lt;schema . . .&gt;
 *            . . .
 *            &lt;import namespace="http://www.w3.org/XML/1998/namespace"
 *                       schemaLocation="http://www.w3.org/2001/xml.xsd"/&gt;
 *      </pre>
 *            
 *       <p>
 *       or
 *      </p>
 *            
 *       <pre>
 *            &lt;import namespace="http://www.w3.org/XML/1998/namespace"
 *                       schemaLocation="http://www.w3.org/2009/01/xml.xsd"/&gt;
 *      </pre>
 *            
 *       <p>
 *       Subsequently, qualified reference to any of the attributes or the
 *       group defined below will have the desired effect, e.g.
 *      </p>
 *            
 *       <pre>
 *           &lt;type . . .&gt;
 *            . . .
 *            &lt;attributeGroup ref="xml:specialAttrs"/&gt;
 *      </pre>
 *            
 *       <p>
 *       will define a type which will schema-validate an instance element
 *       with any of those attributes.
 *      </p>
 *           
 *     </div>
 *        
 *   </div>
 *     
 * 
 * 
 *      
 *   <div id="nsversioning" xml:id="nsversioning" xmlns="http://www.w3.org/1999/xhtml">
 *         
 *     <h2>
 *       <a name="nsversioning">Versioning policy for this schema document</a>
 *     </h2>
 *         
 *     <div class="bodytext">
 *            
 *       <p>
 *               In keeping with the XML Schema WG's standard versioning
 *       policy, this schema document will persist at
 *       
 *         <a href="http://www.w3.org/2009/01/xml.xsd">
 *        http://www.w3.org/2009/01/xml.xsd</a>
 *         .
 *      
 *       </p>
 *            
 *       <p>
 *               At the date of issue it can also be found at
 *       
 *         <a href="http://www.w3.org/2001/xml.xsd">
 *        http://www.w3.org/2001/xml.xsd</a>
 *         .
 *      
 *       </p>
 *            
 *       <p>
 *               The schema document at that URI may however change in the future,
 *       in order to remain compatible with the latest version of XML
 *       Schema itself, or with the XML namespace itself.  In other words,
 *       if the XML Schema or XML namespaces change, the version of this
 *       document at 
 *         <a href="http://www.w3.org/2001/xml.xsd">
 *        http://www.w3.org/2001/xml.xsd 
 *       </a>
 *          
 *       will change accordingly; the version at 
 *       
 *         <a href="http://www.w3.org/2009/01/xml.xsd">
 *        http://www.w3.org/2009/01/xml.xsd 
 *       </a>
 *          
 *       will not change.
 *      
 *       </p>
 *            
 *       <p>
 *       Previous dated (and unchanging) versions of this schema 
 *       document are at:
 *      </p>
 *            
 *       <ul>
 *               
 *         <li>
 *           <a href="http://www.w3.org/2009/01/xml.xsd">
 * 	http://www.w3.org/2009/01/xml.xsd</a>
 *         </li>
 *               
 *         <li>
 *           <a href="http://www.w3.org/2007/08/xml.xsd">
 * 	http://www.w3.org/2007/08/xml.xsd</a>
 *         </li>
 *               
 *         <li>
 *           <a href="http://www.w3.org/2004/10/xml.xsd">
 * 	http://www.w3.org/2004/10/xml.xsd</a>
 *         </li>
 *               
 *         <li>
 *           <a href="http://www.w3.org/2001/03/xml.xsd">
 * 	http://www.w3.org/2001/03/xml.xsd</a>
 *         </li>
 *              
 *       </ul>
 *           
 *     </div>
 *        
 *   </div>
 *     
 * 
 * See ISO/DIS 19136 Clause 10.
 * 			
 * 			GML is an OGC Standard.
 * 			Copyright (c) 2007, 2010, 2016, 2018 Open Geospatial Consortium.
 * 			To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
 * 		
 * Geographic COmmon (GCO) extensible markup language is a component of the XML Schema Implementation of Geographic Information Metadata documented in ISO/TS 19139:2007. GCO includes all the definitions of http://www.isotc211.org/2005/gco namespace. The root document of this namespace is the file gco.xsd.
 * Geographic COmmon (GCO) extensible markup language is a component of the XML Schema Implementation of Geographic
 * Information Metadata documented in ISO/TS 19139:2007. GCO includes all the definitions of http://www.isotc211.org/2005/gco namespace. The root document of this namespace is the file gco.xsd. This basicTypes.xsd schema implements concepts from the "basic types" package of ISO/TS 19103.
 * Geographic COmmon (GCO) extensible markup language is a component of the XML Schema Implementation of Geographic
 * Information Metadata documented in ISO/TS 19139:2007. GCO includes all the definitions of http://www.isotc211.org/2005/gco namespace. The root document of this namespace is the file gco.xsd. This gcoBase.xsd schema provides:
 * 		1.  tools to handle specific objects like "code lists" and "record";
 * 		2. Some XML types representing that do not follow the general encoding rules.
 * Geographic Spatial Referencing (GSR) extensible markup language is a component of the XML Schema Implementation of Geographic Information Metadata documented in ISO/TS 19139:2007. GSR includes all the definitions of http://www.isotc211.org/2005/gsr namespace. The root document of this namespace is the file gsr.xsd.
 * Geographic Spatial Referencing (GSR) extensible markup language is a component of the XML Schema Implementation of Geographic Information Metadata documented in ISO/TS 19139:2007. GSR includes all the definitions of http://www.isotc211.org/2005/gsr namespace. The root document of this namespace is the file gsr.xsd. This spatialReferencing.xsd schema contains the implementation of SC_CRS. The encoding of this class is mapped to an ISO 19136 XML type.
 * Geographic Spatial Schema (GSS) extensible markup language is a component of the XML Schema Implementation of Geographic Information Metadata documented in ISO/TS 19139:2007. GSS includes all the definitions of http://www.isotc211.org/2005/gss namespace. The root document of this namespace is the file gss.xsd.
 * Geographic Spatial Schema (GSS) extensible markup language is a component of the XML Schema Implementation of Geographic Information Metadata documented in ISO/TS 19139:2007. GSS includes all the definitions of http://www.isotc211.org/2005/gss namespace. The root document of this namespace is the file gss.xsd. This geometry.xsd schema contains the implementation of GM_Object and GM_Point. The encoding of these classes is mapped to ISO 19136 geometric types.
 * <!-- end-model-doc -->
 * @see org.isotc211._2005.gmd.GMDFactory
 * @model kind="package"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:gml:3.2.2 appinfo='gml.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:dynamicFeature:3.2.2 appinfo='dynamicFeature.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:topology:3.2.2 appinfo='topology.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:coverage:3.2.2 appinfo='coverage.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:coordinateReferenceSystems:3.2.2 appinfo='coordinateReferenceSystems.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:observation:3.2.2 appinfo='observation.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:temporalReferenceSystems:3.2.2 appinfo='temporalReferenceSystems.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:deprecatedTypes:3.2.2 appinfo='deprecatedTypes.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:temporalTopology:3.2.2 appinfo='temporalTopology.xsd'"
 *        annotation="urn:opengis:specification:gml:schema-xsd:dictionary:v3.2.1 appinfo='dictionary.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:gmlBase:3.2.2 appinfo='gmlBase.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:temporal:3.2.2 appinfo='temporal.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:feature:3.2.2 appinfo='feature.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:direction:3.2.2 appinfo='direction.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:valueObjects:3.2.2 appinfo='valueObjects.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:geometryBasic0d1d:3.2.2 appinfo='geometryBasic0d1d.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:coordinateSystems:3.2.2 appinfo='coordinateSystems.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:datums:3.2.2 appinfo='datums.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:coordinateOperations:3.2.2 appinfo='coordinateOperations.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:referenceSystems:3.2.2 appinfo='referenceSystems.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:measures:3.2.2 appinfo='measures.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:units:3.2.2 appinfo='units.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:grids:3.2.2 appinfo='grids.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:geometryAggregates:3.2.2 appinfo='geometryAggregates.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:geometryPrimitives:3.2.2 appinfo='geometryPrimitives.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:geometryComplexes:3.2.2 appinfo='geometryComplexes.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:basicTypes:3.2.2 appinfo='basicTypes.xsd'"
 *        annotation="urn:x-ogc:specification:gml:schema-xsd:geometryBasic2d:3.2.2 appinfo='geometryBasic2d.xsd'"
 * @generated
 */
@ProviderType
@EPackage(uri = GMDPackage.eNS_URI, genModel = "/model/gml.genmodel", genModelSourceLocations = {"model/gml.genmodel","net.opengis.gml3.model/model/gml.genmodel"}, ecore="/model/gmd.ecore", ecoreSourceLocations="/model/gmd.ecore")
public interface GMDPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "gmd";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.isotc211.org/2005/gmd";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "gmd";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	GMDPackage eINSTANCE = org.isotc211._2005.gmd.impl.GMDPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.AbstractDQElementTypeImpl <em>Abstract DQ Element Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.AbstractDQElementTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getAbstractDQElementType()
	 * @generated
	 */
	int ABSTRACT_DQ_ELEMENT_TYPE = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_ELEMENT_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_ELEMENT_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_ELEMENT_TYPE__NAME_OF_MEASURE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_ELEMENT_TYPE__MEASURE_IDENTIFICATION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_ELEMENT_TYPE__MEASURE_DESCRIPTION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_ELEMENT_TYPE__EVALUATION_METHOD_TYPE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_ELEMENT_TYPE__EVALUATION_METHOD_DESCRIPTION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_ELEMENT_TYPE__EVALUATION_PROCEDURE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_ELEMENT_TYPE__DATE_TIME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_ELEMENT_TYPE__RESULT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Abstract DQ Element Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_ELEMENT_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>Abstract DQ Element Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_ELEMENT_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.AbstractDQCompletenessTypeImpl <em>Abstract DQ Completeness Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.AbstractDQCompletenessTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getAbstractDQCompletenessType()
	 * @generated
	 */
	int ABSTRACT_DQ_COMPLETENESS_TYPE = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_COMPLETENESS_TYPE__ID = ABSTRACT_DQ_ELEMENT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_COMPLETENESS_TYPE__UUID = ABSTRACT_DQ_ELEMENT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_COMPLETENESS_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_ELEMENT_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_COMPLETENESS_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_ELEMENT_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_COMPLETENESS_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_ELEMENT_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_COMPLETENESS_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_ELEMENT_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_COMPLETENESS_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_ELEMENT_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_COMPLETENESS_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_ELEMENT_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_COMPLETENESS_TYPE__DATE_TIME = ABSTRACT_DQ_ELEMENT_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_COMPLETENESS_TYPE__RESULT = ABSTRACT_DQ_ELEMENT_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>Abstract DQ Completeness Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_COMPLETENESS_TYPE_FEATURE_COUNT = ABSTRACT_DQ_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract DQ Completeness Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_COMPLETENESS_TYPE_OPERATION_COUNT = ABSTRACT_DQ_ELEMENT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.AbstractDQLogicalConsistencyTypeImpl <em>Abstract DQ Logical Consistency Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.AbstractDQLogicalConsistencyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getAbstractDQLogicalConsistencyType()
	 * @generated
	 */
	int ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__ID = ABSTRACT_DQ_ELEMENT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__UUID = ABSTRACT_DQ_ELEMENT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_ELEMENT_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_ELEMENT_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_ELEMENT_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_ELEMENT_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_ELEMENT_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_ELEMENT_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__DATE_TIME = ABSTRACT_DQ_ELEMENT_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__RESULT = ABSTRACT_DQ_ELEMENT_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>Abstract DQ Logical Consistency Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE_FEATURE_COUNT = ABSTRACT_DQ_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract DQ Logical Consistency Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE_OPERATION_COUNT = ABSTRACT_DQ_ELEMENT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.AbstractDQPositionalAccuracyTypeImpl <em>Abstract DQ Positional Accuracy Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.AbstractDQPositionalAccuracyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getAbstractDQPositionalAccuracyType()
	 * @generated
	 */
	int ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__ID = ABSTRACT_DQ_ELEMENT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__UUID = ABSTRACT_DQ_ELEMENT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_ELEMENT_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_ELEMENT_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_ELEMENT_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_ELEMENT_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_ELEMENT_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_ELEMENT_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__DATE_TIME = ABSTRACT_DQ_ELEMENT_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__RESULT = ABSTRACT_DQ_ELEMENT_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>Abstract DQ Positional Accuracy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE_FEATURE_COUNT = ABSTRACT_DQ_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract DQ Positional Accuracy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE_OPERATION_COUNT = ABSTRACT_DQ_ELEMENT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.AbstractDQResultTypeImpl <em>Abstract DQ Result Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.AbstractDQResultTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getAbstractDQResultType()
	 * @generated
	 */
	int ABSTRACT_DQ_RESULT_TYPE = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_RESULT_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_RESULT_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The number of structural features of the '<em>Abstract DQ Result Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_RESULT_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract DQ Result Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_RESULT_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.AbstractDQTemporalAccuracyTypeImpl <em>Abstract DQ Temporal Accuracy Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.AbstractDQTemporalAccuracyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getAbstractDQTemporalAccuracyType()
	 * @generated
	 */
	int ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE = 5;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__ID = ABSTRACT_DQ_ELEMENT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__UUID = ABSTRACT_DQ_ELEMENT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_ELEMENT_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_ELEMENT_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_ELEMENT_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_ELEMENT_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_ELEMENT_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_ELEMENT_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__DATE_TIME = ABSTRACT_DQ_ELEMENT_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__RESULT = ABSTRACT_DQ_ELEMENT_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>Abstract DQ Temporal Accuracy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE_FEATURE_COUNT = ABSTRACT_DQ_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract DQ Temporal Accuracy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE_OPERATION_COUNT = ABSTRACT_DQ_ELEMENT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.AbstractDQThematicAccuracyTypeImpl <em>Abstract DQ Thematic Accuracy Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.AbstractDQThematicAccuracyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getAbstractDQThematicAccuracyType()
	 * @generated
	 */
	int ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__ID = ABSTRACT_DQ_ELEMENT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__UUID = ABSTRACT_DQ_ELEMENT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_ELEMENT_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_ELEMENT_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_ELEMENT_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_ELEMENT_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_ELEMENT_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_ELEMENT_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__DATE_TIME = ABSTRACT_DQ_ELEMENT_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__RESULT = ABSTRACT_DQ_ELEMENT_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>Abstract DQ Thematic Accuracy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE_FEATURE_COUNT = ABSTRACT_DQ_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract DQ Thematic Accuracy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE_OPERATION_COUNT = ABSTRACT_DQ_ELEMENT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.AbstractDSAggregateTypeImpl <em>Abstract DS Aggregate Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.AbstractDSAggregateTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getAbstractDSAggregateType()
	 * @generated
	 */
	int ABSTRACT_DS_AGGREGATE_TYPE = 7;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DS_AGGREGATE_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DS_AGGREGATE_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Composed Of</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DS_AGGREGATE_TYPE__COMPOSED_OF = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Series Metadata</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DS_AGGREGATE_TYPE__SERIES_METADATA = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Subset</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DS_AGGREGATE_TYPE__SUBSET = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Superset</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DS_AGGREGATE_TYPE__SUPERSET = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Abstract DS Aggregate Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DS_AGGREGATE_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Abstract DS Aggregate Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DS_AGGREGATE_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.AbstractEXGeographicExtentTypeImpl <em>Abstract EX Geographic Extent Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.AbstractEXGeographicExtentTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getAbstractEXGeographicExtentType()
	 * @generated
	 */
	int ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE = 8;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Extent Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE__EXTENT_TYPE_CODE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Abstract EX Geographic Extent Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Abstract EX Geographic Extent Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.AbstractMDContentInformationTypeImpl <em>Abstract MD Content Information Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.AbstractMDContentInformationTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getAbstractMDContentInformationType()
	 * @generated
	 */
	int ABSTRACT_MD_CONTENT_INFORMATION_TYPE = 9;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_CONTENT_INFORMATION_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_CONTENT_INFORMATION_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The number of structural features of the '<em>Abstract MD Content Information Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_CONTENT_INFORMATION_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract MD Content Information Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_CONTENT_INFORMATION_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.AbstractMDIdentificationTypeImpl <em>Abstract MD Identification Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.AbstractMDIdentificationTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getAbstractMDIdentificationType()
	 * @generated
	 */
	int ABSTRACT_MD_IDENTIFICATION_TYPE = 10;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_IDENTIFICATION_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_IDENTIFICATION_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Citation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_IDENTIFICATION_TYPE__CITATION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_IDENTIFICATION_TYPE__ABSTRACT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Purpose</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_IDENTIFICATION_TYPE__PURPOSE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Credit</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_IDENTIFICATION_TYPE__CREDIT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Status</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_IDENTIFICATION_TYPE__STATUS = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Point Of Contact</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_IDENTIFICATION_TYPE__POINT_OF_CONTACT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Resource Maintenance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_IDENTIFICATION_TYPE__RESOURCE_MAINTENANCE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Graphic Overview</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_IDENTIFICATION_TYPE__GRAPHIC_OVERVIEW = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Resource Format</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_IDENTIFICATION_TYPE__RESOURCE_FORMAT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Descriptive Keywords</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_IDENTIFICATION_TYPE__DESCRIPTIVE_KEYWORDS = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Resource Specific Usage</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_IDENTIFICATION_TYPE__RESOURCE_SPECIFIC_USAGE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Resource Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_IDENTIFICATION_TYPE__RESOURCE_CONSTRAINTS = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Aggregation Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_IDENTIFICATION_TYPE__AGGREGATION_INFO = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 12;

	/**
	 * The number of structural features of the '<em>Abstract MD Identification Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_IDENTIFICATION_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 13;

	/**
	 * The number of operations of the '<em>Abstract MD Identification Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_IDENTIFICATION_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.AbstractMDSpatialRepresentationTypeImpl <em>Abstract MD Spatial Representation Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.AbstractMDSpatialRepresentationTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getAbstractMDSpatialRepresentationType()
	 * @generated
	 */
	int ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE = 11;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The number of structural features of the '<em>Abstract MD Spatial Representation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Abstract MD Spatial Representation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.AbstractRSReferenceSystemTypeImpl <em>Abstract RS Reference System Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.AbstractRSReferenceSystemTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getAbstractRSReferenceSystemType()
	 * @generated
	 */
	int ABSTRACT_RS_REFERENCE_SYSTEM_TYPE = 12;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RS_REFERENCE_SYSTEM_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RS_REFERENCE_SYSTEM_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RS_REFERENCE_SYSTEM_TYPE__NAME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Domain Of Validity</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RS_REFERENCE_SYSTEM_TYPE__DOMAIN_OF_VALIDITY = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Abstract RS Reference System Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RS_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Abstract RS Reference System Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_RS_REFERENCE_SYSTEM_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CIAddressPropertyTypeImpl <em>CI Address Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CIAddressPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCIAddressPropertyType()
	 * @generated
	 */
	int CI_ADDRESS_PROPERTY_TYPE = 13;

	/**
	 * The feature id for the '<em><b>CI Address</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_PROPERTY_TYPE__CI_ADDRESS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>CI Address Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>CI Address Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CIAddressTypeImpl <em>CI Address Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CIAddressTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCIAddressType()
	 * @generated
	 */
	int CI_ADDRESS_TYPE = 14;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Delivery Point</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_TYPE__DELIVERY_POINT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>City</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_TYPE__CITY = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Administrative Area</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_TYPE__ADMINISTRATIVE_AREA = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Postal Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_TYPE__POSTAL_CODE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Country</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_TYPE__COUNTRY = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Electronic Mail Address</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_TYPE__ELECTRONIC_MAIL_ADDRESS = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>CI Address Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>CI Address Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ADDRESS_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CICitationPropertyTypeImpl <em>CI Citation Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CICitationPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCICitationPropertyType()
	 * @generated
	 */
	int CI_CITATION_PROPERTY_TYPE = 15;

	/**
	 * The feature id for the '<em><b>CI Citation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_PROPERTY_TYPE__CI_CITATION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>CI Citation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>CI Citation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CICitationTypeImpl <em>CI Citation Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CICitationTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCICitationType()
	 * @generated
	 */
	int CI_CITATION_TYPE = 16;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Title</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_TYPE__TITLE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Alternate Title</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_TYPE__ALTERNATE_TITLE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Date</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_TYPE__DATE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Edition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_TYPE__EDITION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Edition Date</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_TYPE__EDITION_DATE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_TYPE__IDENTIFIER = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Cited Responsible Party</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_TYPE__CITED_RESPONSIBLE_PARTY = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Presentation Form</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_TYPE__PRESENTATION_FORM = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Series</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_TYPE__SERIES = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Other Citation Details</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_TYPE__OTHER_CITATION_DETAILS = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Collective Title</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_TYPE__COLLECTIVE_TITLE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>ISBN</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_TYPE__ISBN = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>ISSN</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_TYPE__ISSN = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 12;

	/**
	 * The number of structural features of the '<em>CI Citation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 13;

	/**
	 * The number of operations of the '<em>CI Citation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CITATION_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CIContactPropertyTypeImpl <em>CI Contact Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CIContactPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCIContactPropertyType()
	 * @generated
	 */
	int CI_CONTACT_PROPERTY_TYPE = 17;

	/**
	 * The feature id for the '<em><b>CI Contact</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_PROPERTY_TYPE__CI_CONTACT = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>CI Contact Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>CI Contact Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CIContactTypeImpl <em>CI Contact Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CIContactTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCIContactType()
	 * @generated
	 */
	int CI_CONTACT_TYPE = 18;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Phone</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_TYPE__PHONE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Address</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_TYPE__ADDRESS = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Online Resource</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_TYPE__ONLINE_RESOURCE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Hours Of Service</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_TYPE__HOURS_OF_SERVICE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Contact Instructions</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_TYPE__CONTACT_INSTRUCTIONS = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>CI Contact Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>CI Contact Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_CONTACT_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CIDatePropertyTypeImpl <em>CI Date Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CIDatePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCIDatePropertyType()
	 * @generated
	 */
	int CI_DATE_PROPERTY_TYPE = 19;

	/**
	 * The feature id for the '<em><b>CI Date</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_PROPERTY_TYPE__CI_DATE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>CI Date Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>CI Date Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CIDateTypeImpl <em>CI Date Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CIDateTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCIDateType()
	 * @generated
	 */
	int CI_DATE_TYPE = 20;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Date</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_TYPE__DATE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Date Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_TYPE__DATE_TYPE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>CI Date Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>CI Date Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CIDateTypeCodePropertyTypeImpl <em>CI Date Type Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CIDateTypeCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCIDateTypeCodePropertyType()
	 * @generated
	 */
	int CI_DATE_TYPE_CODE_PROPERTY_TYPE = 21;

	/**
	 * The feature id for the '<em><b>CI Date Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_TYPE_CODE_PROPERTY_TYPE__CI_DATE_TYPE_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_TYPE_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>CI Date Type Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_TYPE_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>CI Date Type Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_DATE_TYPE_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CIOnLineFunctionCodePropertyTypeImpl <em>CI On Line Function Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CIOnLineFunctionCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCIOnLineFunctionCodePropertyType()
	 * @generated
	 */
	int CI_ON_LINE_FUNCTION_CODE_PROPERTY_TYPE = 22;

	/**
	 * The feature id for the '<em><b>CI On Line Function Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ON_LINE_FUNCTION_CODE_PROPERTY_TYPE__CI_ON_LINE_FUNCTION_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ON_LINE_FUNCTION_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>CI On Line Function Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ON_LINE_FUNCTION_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>CI On Line Function Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ON_LINE_FUNCTION_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CIOnlineResourcePropertyTypeImpl <em>CI Online Resource Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CIOnlineResourcePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCIOnlineResourcePropertyType()
	 * @generated
	 */
	int CI_ONLINE_RESOURCE_PROPERTY_TYPE = 23;

	/**
	 * The feature id for the '<em><b>CI Online Resource</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_PROPERTY_TYPE__CI_ONLINE_RESOURCE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>CI Online Resource Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>CI Online Resource Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CIOnlineResourceTypeImpl <em>CI Online Resource Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CIOnlineResourceTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCIOnlineResourceType()
	 * @generated
	 */
	int CI_ONLINE_RESOURCE_TYPE = 24;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Linkage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_TYPE__LINKAGE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Protocol</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_TYPE__PROTOCOL = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Application Profile</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_TYPE__APPLICATION_PROFILE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_TYPE__NAME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_TYPE__DESCRIPTION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Function</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_TYPE__FUNCTION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>CI Online Resource Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>CI Online Resource Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ONLINE_RESOURCE_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CIPresentationFormCodePropertyTypeImpl <em>CI Presentation Form Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CIPresentationFormCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCIPresentationFormCodePropertyType()
	 * @generated
	 */
	int CI_PRESENTATION_FORM_CODE_PROPERTY_TYPE = 25;

	/**
	 * The feature id for the '<em><b>CI Presentation Form Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_PRESENTATION_FORM_CODE_PROPERTY_TYPE__CI_PRESENTATION_FORM_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_PRESENTATION_FORM_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>CI Presentation Form Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_PRESENTATION_FORM_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>CI Presentation Form Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_PRESENTATION_FORM_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CIResponsiblePartyPropertyTypeImpl <em>CI Responsible Party Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CIResponsiblePartyPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCIResponsiblePartyPropertyType()
	 * @generated
	 */
	int CI_RESPONSIBLE_PARTY_PROPERTY_TYPE = 26;

	/**
	 * The feature id for the '<em><b>CI Responsible Party</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_PROPERTY_TYPE__CI_RESPONSIBLE_PARTY = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>CI Responsible Party Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>CI Responsible Party Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CIResponsiblePartyTypeImpl <em>CI Responsible Party Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CIResponsiblePartyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCIResponsiblePartyType()
	 * @generated
	 */
	int CI_RESPONSIBLE_PARTY_TYPE = 27;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Individual Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_TYPE__INDIVIDUAL_NAME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Organisation Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_TYPE__ORGANISATION_NAME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Position Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_TYPE__POSITION_NAME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Contact Info</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_TYPE__CONTACT_INFO = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Role</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_TYPE__ROLE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>CI Responsible Party Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>CI Responsible Party Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_RESPONSIBLE_PARTY_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CIRoleCodePropertyTypeImpl <em>CI Role Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CIRoleCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCIRoleCodePropertyType()
	 * @generated
	 */
	int CI_ROLE_CODE_PROPERTY_TYPE = 28;

	/**
	 * The feature id for the '<em><b>CI Role Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ROLE_CODE_PROPERTY_TYPE__CI_ROLE_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ROLE_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>CI Role Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ROLE_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>CI Role Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_ROLE_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CISeriesPropertyTypeImpl <em>CI Series Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CISeriesPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCISeriesPropertyType()
	 * @generated
	 */
	int CI_SERIES_PROPERTY_TYPE = 29;

	/**
	 * The feature id for the '<em><b>CI Series</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_PROPERTY_TYPE__CI_SERIES = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>CI Series Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>CI Series Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CISeriesTypeImpl <em>CI Series Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CISeriesTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCISeriesType()
	 * @generated
	 */
	int CI_SERIES_TYPE = 30;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_TYPE__NAME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Issue Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_TYPE__ISSUE_IDENTIFICATION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Page</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_TYPE__PAGE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>CI Series Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>CI Series Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_SERIES_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CITelephonePropertyTypeImpl <em>CI Telephone Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CITelephonePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCITelephonePropertyType()
	 * @generated
	 */
	int CI_TELEPHONE_PROPERTY_TYPE = 31;

	/**
	 * The feature id for the '<em><b>CI Telephone</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_TELEPHONE_PROPERTY_TYPE__CI_TELEPHONE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_TELEPHONE_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_TELEPHONE_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_TELEPHONE_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_TELEPHONE_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_TELEPHONE_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_TELEPHONE_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_TELEPHONE_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_TELEPHONE_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_TELEPHONE_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>CI Telephone Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_TELEPHONE_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>CI Telephone Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_TELEPHONE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CITelephoneTypeImpl <em>CI Telephone Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CITelephoneTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCITelephoneType()
	 * @generated
	 */
	int CI_TELEPHONE_TYPE = 32;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_TELEPHONE_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_TELEPHONE_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Voice</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_TELEPHONE_TYPE__VOICE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Facsimile</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_TELEPHONE_TYPE__FACSIMILE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>CI Telephone Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_TELEPHONE_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>CI Telephone Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CI_TELEPHONE_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.CountryPropertyTypeImpl <em>Country Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.CountryPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getCountryPropertyType()
	 * @generated
	 */
	int COUNTRY_PROPERTY_TYPE = 33;

	/**
	 * The feature id for the '<em><b>Country</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_PROPERTY_TYPE__COUNTRY = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>Country Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Country Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQAbsoluteExternalPositionalAccuracyPropertyTypeImpl <em>DQ Absolute External Positional Accuracy Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQAbsoluteExternalPositionalAccuracyPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQAbsoluteExternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE = 34;

	/**
	 * The feature id for the '<em><b>DQ Absolute External Positional Accuracy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Absolute External Positional Accuracy Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Absolute External Positional Accuracy Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQAbsoluteExternalPositionalAccuracyTypeImpl <em>DQ Absolute External Positional Accuracy Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQAbsoluteExternalPositionalAccuracyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQAbsoluteExternalPositionalAccuracyType()
	 * @generated
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_TYPE = 35;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_TYPE__ID = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_TYPE__UUID = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_TYPE__DATE_TIME = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_TYPE__RESULT = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>DQ Absolute External Positional Accuracy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_TYPE_FEATURE_COUNT = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DQ Absolute External Positional Accuracy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY_TYPE_OPERATION_COUNT = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQAccuracyOfATimeMeasurementPropertyTypeImpl <em>DQ Accuracy Of ATime Measurement Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQAccuracyOfATimeMeasurementPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQAccuracyOfATimeMeasurementPropertyType()
	 * @generated
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_PROPERTY_TYPE = 36;

	/**
	 * The feature id for the '<em><b>DQ Accuracy Of ATime Measurement</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_PROPERTY_TYPE__DQ_ACCURACY_OF_ATIME_MEASUREMENT = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Accuracy Of ATime Measurement Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Accuracy Of ATime Measurement Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQAccuracyOfATimeMeasurementTypeImpl <em>DQ Accuracy Of ATime Measurement Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQAccuracyOfATimeMeasurementTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQAccuracyOfATimeMeasurementType()
	 * @generated
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_TYPE = 37;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_TYPE__ID = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_TYPE__UUID = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_TYPE__DATE_TIME = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_TYPE__RESULT = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>DQ Accuracy Of ATime Measurement Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_TYPE_FEATURE_COUNT = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DQ Accuracy Of ATime Measurement Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ACCURACY_OF_ATIME_MEASUREMENT_TYPE_OPERATION_COUNT = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQCompletenessCommissionPropertyTypeImpl <em>DQ Completeness Commission Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQCompletenessCommissionPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQCompletenessCommissionPropertyType()
	 * @generated
	 */
	int DQ_COMPLETENESS_COMMISSION_PROPERTY_TYPE = 38;

	/**
	 * The feature id for the '<em><b>DQ Completeness Commission</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_PROPERTY_TYPE__DQ_COMPLETENESS_COMMISSION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Completeness Commission Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Completeness Commission Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQCompletenessCommissionTypeImpl <em>DQ Completeness Commission Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQCompletenessCommissionTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQCompletenessCommissionType()
	 * @generated
	 */
	int DQ_COMPLETENESS_COMMISSION_TYPE = 39;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_TYPE__ID = ABSTRACT_DQ_COMPLETENESS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_TYPE__UUID = ABSTRACT_DQ_COMPLETENESS_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_COMPLETENESS_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_COMPLETENESS_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_COMPLETENESS_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_COMPLETENESS_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_COMPLETENESS_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_COMPLETENESS_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_TYPE__DATE_TIME = ABSTRACT_DQ_COMPLETENESS_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_TYPE__RESULT = ABSTRACT_DQ_COMPLETENESS_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>DQ Completeness Commission Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_TYPE_FEATURE_COUNT = ABSTRACT_DQ_COMPLETENESS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DQ Completeness Commission Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_COMMISSION_TYPE_OPERATION_COUNT = ABSTRACT_DQ_COMPLETENESS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQCompletenessOmissionPropertyTypeImpl <em>DQ Completeness Omission Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQCompletenessOmissionPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQCompletenessOmissionPropertyType()
	 * @generated
	 */
	int DQ_COMPLETENESS_OMISSION_PROPERTY_TYPE = 40;

	/**
	 * The feature id for the '<em><b>DQ Completeness Omission</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_PROPERTY_TYPE__DQ_COMPLETENESS_OMISSION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Completeness Omission Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Completeness Omission Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQCompletenessOmissionTypeImpl <em>DQ Completeness Omission Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQCompletenessOmissionTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQCompletenessOmissionType()
	 * @generated
	 */
	int DQ_COMPLETENESS_OMISSION_TYPE = 41;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_TYPE__ID = ABSTRACT_DQ_COMPLETENESS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_TYPE__UUID = ABSTRACT_DQ_COMPLETENESS_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_COMPLETENESS_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_COMPLETENESS_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_COMPLETENESS_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_COMPLETENESS_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_COMPLETENESS_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_COMPLETENESS_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_TYPE__DATE_TIME = ABSTRACT_DQ_COMPLETENESS_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_TYPE__RESULT = ABSTRACT_DQ_COMPLETENESS_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>DQ Completeness Omission Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_TYPE_FEATURE_COUNT = ABSTRACT_DQ_COMPLETENESS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DQ Completeness Omission Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_OMISSION_TYPE_OPERATION_COUNT = ABSTRACT_DQ_COMPLETENESS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQCompletenessPropertyTypeImpl <em>DQ Completeness Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQCompletenessPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQCompletenessPropertyType()
	 * @generated
	 */
	int DQ_COMPLETENESS_PROPERTY_TYPE = 42;

	/**
	 * The feature id for the '<em><b>Abstract DQ Completeness Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_PROPERTY_TYPE__ABSTRACT_DQ_COMPLETENESS_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract DQ Completeness</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_PROPERTY_TYPE__ABSTRACT_DQ_COMPLETENESS = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>DQ Completeness Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>DQ Completeness Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_COMPLETENESS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQConceptualConsistencyPropertyTypeImpl <em>DQ Conceptual Consistency Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQConceptualConsistencyPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQConceptualConsistencyPropertyType()
	 * @generated
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_PROPERTY_TYPE = 43;

	/**
	 * The feature id for the '<em><b>DQ Conceptual Consistency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_PROPERTY_TYPE__DQ_CONCEPTUAL_CONSISTENCY = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Conceptual Consistency Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Conceptual Consistency Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQConceptualConsistencyTypeImpl <em>DQ Conceptual Consistency Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQConceptualConsistencyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQConceptualConsistencyType()
	 * @generated
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_TYPE = 44;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_TYPE__ID = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_TYPE__UUID = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_TYPE__DATE_TIME = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_TYPE__RESULT = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>DQ Conceptual Consistency Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_TYPE_FEATURE_COUNT = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DQ Conceptual Consistency Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONCEPTUAL_CONSISTENCY_TYPE_OPERATION_COUNT = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQConformanceResultPropertyTypeImpl <em>DQ Conformance Result Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQConformanceResultPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQConformanceResultPropertyType()
	 * @generated
	 */
	int DQ_CONFORMANCE_RESULT_PROPERTY_TYPE = 45;

	/**
	 * The feature id for the '<em><b>DQ Conformance Result</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_PROPERTY_TYPE__DQ_CONFORMANCE_RESULT = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Conformance Result Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Conformance Result Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQConformanceResultTypeImpl <em>DQ Conformance Result Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQConformanceResultTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQConformanceResultType()
	 * @generated
	 */
	int DQ_CONFORMANCE_RESULT_TYPE = 46;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_TYPE__ID = ABSTRACT_DQ_RESULT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_TYPE__UUID = ABSTRACT_DQ_RESULT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Specification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_TYPE__SPECIFICATION = ABSTRACT_DQ_RESULT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Explanation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_TYPE__EXPLANATION = ABSTRACT_DQ_RESULT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Pass</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_TYPE__PASS = ABSTRACT_DQ_RESULT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>DQ Conformance Result Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_TYPE_FEATURE_COUNT = ABSTRACT_DQ_RESULT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>DQ Conformance Result Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_CONFORMANCE_RESULT_TYPE_OPERATION_COUNT = ABSTRACT_DQ_RESULT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQDataQualityPropertyTypeImpl <em>DQ Data Quality Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQDataQualityPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQDataQualityPropertyType()
	 * @generated
	 */
	int DQ_DATA_QUALITY_PROPERTY_TYPE = 47;

	/**
	 * The feature id for the '<em><b>DQ Data Quality</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_PROPERTY_TYPE__DQ_DATA_QUALITY = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Data Quality Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Data Quality Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQDataQualityTypeImpl <em>DQ Data Quality Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQDataQualityTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQDataQualityType()
	 * @generated
	 */
	int DQ_DATA_QUALITY_TYPE = 48;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_TYPE__SCOPE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Report</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_TYPE__REPORT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Lineage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_TYPE__LINEAGE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>DQ Data Quality Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>DQ Data Quality Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DATA_QUALITY_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQDomainConsistencyPropertyTypeImpl <em>DQ Domain Consistency Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQDomainConsistencyPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQDomainConsistencyPropertyType()
	 * @generated
	 */
	int DQ_DOMAIN_CONSISTENCY_PROPERTY_TYPE = 49;

	/**
	 * The feature id for the '<em><b>DQ Domain Consistency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_PROPERTY_TYPE__DQ_DOMAIN_CONSISTENCY = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Domain Consistency Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Domain Consistency Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQDomainConsistencyTypeImpl <em>DQ Domain Consistency Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQDomainConsistencyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQDomainConsistencyType()
	 * @generated
	 */
	int DQ_DOMAIN_CONSISTENCY_TYPE = 50;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_TYPE__ID = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_TYPE__UUID = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_TYPE__DATE_TIME = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_TYPE__RESULT = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>DQ Domain Consistency Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_TYPE_FEATURE_COUNT = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DQ Domain Consistency Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_DOMAIN_CONSISTENCY_TYPE_OPERATION_COUNT = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQElementPropertyTypeImpl <em>DQ Element Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQElementPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQElementPropertyType()
	 * @generated
	 */
	int DQ_ELEMENT_PROPERTY_TYPE = 51;

	/**
	 * The feature id for the '<em><b>Abstract DQ Element Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ELEMENT_PROPERTY_TYPE__ABSTRACT_DQ_ELEMENT_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract DQ Element</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ELEMENT_PROPERTY_TYPE__ABSTRACT_DQ_ELEMENT = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ELEMENT_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ELEMENT_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ELEMENT_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ELEMENT_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ELEMENT_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ELEMENT_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ELEMENT_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ELEMENT_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ELEMENT_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>DQ Element Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ELEMENT_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>DQ Element Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_ELEMENT_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQEvaluationMethodTypeCodePropertyTypeImpl <em>DQ Evaluation Method Type Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQEvaluationMethodTypeCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQEvaluationMethodTypeCodePropertyType()
	 * @generated
	 */
	int DQ_EVALUATION_METHOD_TYPE_CODE_PROPERTY_TYPE = 52;

	/**
	 * The feature id for the '<em><b>DQ Evaluation Method Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_EVALUATION_METHOD_TYPE_CODE_PROPERTY_TYPE__DQ_EVALUATION_METHOD_TYPE_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_EVALUATION_METHOD_TYPE_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>DQ Evaluation Method Type Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_EVALUATION_METHOD_TYPE_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>DQ Evaluation Method Type Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_EVALUATION_METHOD_TYPE_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQFormatConsistencyPropertyTypeImpl <em>DQ Format Consistency Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQFormatConsistencyPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQFormatConsistencyPropertyType()
	 * @generated
	 */
	int DQ_FORMAT_CONSISTENCY_PROPERTY_TYPE = 53;

	/**
	 * The feature id for the '<em><b>DQ Format Consistency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_PROPERTY_TYPE__DQ_FORMAT_CONSISTENCY = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Format Consistency Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Format Consistency Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQFormatConsistencyTypeImpl <em>DQ Format Consistency Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQFormatConsistencyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQFormatConsistencyType()
	 * @generated
	 */
	int DQ_FORMAT_CONSISTENCY_TYPE = 54;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_TYPE__ID = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_TYPE__UUID = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_TYPE__DATE_TIME = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_TYPE__RESULT = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>DQ Format Consistency Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_TYPE_FEATURE_COUNT = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DQ Format Consistency Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_FORMAT_CONSISTENCY_TYPE_OPERATION_COUNT = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQGriddedDataPositionalAccuracyPropertyTypeImpl <em>DQ Gridded Data Positional Accuracy Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQGriddedDataPositionalAccuracyPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQGriddedDataPositionalAccuracyPropertyType()
	 * @generated
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_PROPERTY_TYPE = 55;

	/**
	 * The feature id for the '<em><b>DQ Gridded Data Positional Accuracy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_PROPERTY_TYPE__DQ_GRIDDED_DATA_POSITIONAL_ACCURACY = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Gridded Data Positional Accuracy Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Gridded Data Positional Accuracy Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQGriddedDataPositionalAccuracyTypeImpl <em>DQ Gridded Data Positional Accuracy Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQGriddedDataPositionalAccuracyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQGriddedDataPositionalAccuracyType()
	 * @generated
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_TYPE = 56;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_TYPE__ID = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_TYPE__UUID = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_TYPE__DATE_TIME = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_TYPE__RESULT = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>DQ Gridded Data Positional Accuracy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_TYPE_FEATURE_COUNT = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DQ Gridded Data Positional Accuracy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_GRIDDED_DATA_POSITIONAL_ACCURACY_TYPE_OPERATION_COUNT = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQLogicalConsistencyPropertyTypeImpl <em>DQ Logical Consistency Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQLogicalConsistencyPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQLogicalConsistencyPropertyType()
	 * @generated
	 */
	int DQ_LOGICAL_CONSISTENCY_PROPERTY_TYPE = 57;

	/**
	 * The feature id for the '<em><b>Abstract DQ Logical Consistency Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_LOGICAL_CONSISTENCY_PROPERTY_TYPE__ABSTRACT_DQ_LOGICAL_CONSISTENCY_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract DQ Logical Consistency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_LOGICAL_CONSISTENCY_PROPERTY_TYPE__ABSTRACT_DQ_LOGICAL_CONSISTENCY = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_LOGICAL_CONSISTENCY_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_LOGICAL_CONSISTENCY_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_LOGICAL_CONSISTENCY_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_LOGICAL_CONSISTENCY_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_LOGICAL_CONSISTENCY_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_LOGICAL_CONSISTENCY_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_LOGICAL_CONSISTENCY_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_LOGICAL_CONSISTENCY_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_LOGICAL_CONSISTENCY_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>DQ Logical Consistency Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_LOGICAL_CONSISTENCY_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>DQ Logical Consistency Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_LOGICAL_CONSISTENCY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQNonQuantitativeAttributeAccuracyPropertyTypeImpl <em>DQ Non Quantitative Attribute Accuracy Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQNonQuantitativeAttributeAccuracyPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQNonQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE = 58;

	/**
	 * The feature id for the '<em><b>DQ Non Quantitative Attribute Accuracy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Non Quantitative Attribute Accuracy Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Non Quantitative Attribute Accuracy Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQNonQuantitativeAttributeAccuracyTypeImpl <em>DQ Non Quantitative Attribute Accuracy Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQNonQuantitativeAttributeAccuracyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQNonQuantitativeAttributeAccuracyType()
	 * @generated
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE = 59;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__ID = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__UUID = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__DATE_TIME = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__RESULT = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>DQ Non Quantitative Attribute Accuracy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE_FEATURE_COUNT = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DQ Non Quantitative Attribute Accuracy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE_OPERATION_COUNT = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQPositionalAccuracyPropertyTypeImpl <em>DQ Positional Accuracy Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQPositionalAccuracyPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQPositionalAccuracyPropertyType()
	 * @generated
	 */
	int DQ_POSITIONAL_ACCURACY_PROPERTY_TYPE = 60;

	/**
	 * The feature id for the '<em><b>Abstract DQ Positional Accuracy Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_POSITIONAL_ACCURACY_PROPERTY_TYPE__ABSTRACT_DQ_POSITIONAL_ACCURACY_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract DQ Positional Accuracy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_POSITIONAL_ACCURACY_PROPERTY_TYPE__ABSTRACT_DQ_POSITIONAL_ACCURACY = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_POSITIONAL_ACCURACY_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_POSITIONAL_ACCURACY_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_POSITIONAL_ACCURACY_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_POSITIONAL_ACCURACY_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_POSITIONAL_ACCURACY_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_POSITIONAL_ACCURACY_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_POSITIONAL_ACCURACY_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_POSITIONAL_ACCURACY_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_POSITIONAL_ACCURACY_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>DQ Positional Accuracy Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_POSITIONAL_ACCURACY_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>DQ Positional Accuracy Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_POSITIONAL_ACCURACY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQQuantitativeAttributeAccuracyPropertyTypeImpl <em>DQ Quantitative Attribute Accuracy Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQQuantitativeAttributeAccuracyPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE = 61;

	/**
	 * The feature id for the '<em><b>DQ Quantitative Attribute Accuracy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Quantitative Attribute Accuracy Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Quantitative Attribute Accuracy Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQQuantitativeAttributeAccuracyTypeImpl <em>DQ Quantitative Attribute Accuracy Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQQuantitativeAttributeAccuracyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQQuantitativeAttributeAccuracyType()
	 * @generated
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE = 62;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__ID = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__UUID = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__DATE_TIME = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE__RESULT = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>DQ Quantitative Attribute Accuracy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE_FEATURE_COUNT = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DQ Quantitative Attribute Accuracy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY_TYPE_OPERATION_COUNT = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQQuantitativeResultPropertyTypeImpl <em>DQ Quantitative Result Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQQuantitativeResultPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQQuantitativeResultPropertyType()
	 * @generated
	 */
	int DQ_QUANTITATIVE_RESULT_PROPERTY_TYPE = 63;

	/**
	 * The feature id for the '<em><b>DQ Quantitative Result</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_PROPERTY_TYPE__DQ_QUANTITATIVE_RESULT = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Quantitative Result Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Quantitative Result Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQQuantitativeResultTypeImpl <em>DQ Quantitative Result Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQQuantitativeResultTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQQuantitativeResultType()
	 * @generated
	 */
	int DQ_QUANTITATIVE_RESULT_TYPE = 64;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_TYPE__ID = ABSTRACT_DQ_RESULT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_TYPE__UUID = ABSTRACT_DQ_RESULT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Value Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_TYPE__VALUE_TYPE = ABSTRACT_DQ_RESULT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Value Unit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_TYPE__VALUE_UNIT = ABSTRACT_DQ_RESULT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Error Statistic</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_TYPE__ERROR_STATISTIC = ABSTRACT_DQ_RESULT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_TYPE__VALUE = ABSTRACT_DQ_RESULT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>DQ Quantitative Result Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_TYPE_FEATURE_COUNT = ABSTRACT_DQ_RESULT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>DQ Quantitative Result Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_QUANTITATIVE_RESULT_TYPE_OPERATION_COUNT = ABSTRACT_DQ_RESULT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQRelativeInternalPositionalAccuracyPropertyTypeImpl <em>DQ Relative Internal Positional Accuracy Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQRelativeInternalPositionalAccuracyPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQRelativeInternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE = 65;

	/**
	 * The feature id for the '<em><b>DQ Relative Internal Positional Accuracy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Relative Internal Positional Accuracy Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Relative Internal Positional Accuracy Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQRelativeInternalPositionalAccuracyTypeImpl <em>DQ Relative Internal Positional Accuracy Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQRelativeInternalPositionalAccuracyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQRelativeInternalPositionalAccuracyType()
	 * @generated
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_TYPE = 66;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_TYPE__ID = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_TYPE__UUID = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_TYPE__DATE_TIME = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_TYPE__RESULT = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>DQ Relative Internal Positional Accuracy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_TYPE_FEATURE_COUNT = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DQ Relative Internal Positional Accuracy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY_TYPE_OPERATION_COUNT = ABSTRACT_DQ_POSITIONAL_ACCURACY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQResultPropertyTypeImpl <em>DQ Result Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQResultPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQResultPropertyType()
	 * @generated
	 */
	int DQ_RESULT_PROPERTY_TYPE = 67;

	/**
	 * The feature id for the '<em><b>Abstract DQ Result Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RESULT_PROPERTY_TYPE__ABSTRACT_DQ_RESULT_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract DQ Result</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RESULT_PROPERTY_TYPE__ABSTRACT_DQ_RESULT = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RESULT_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RESULT_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RESULT_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RESULT_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RESULT_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RESULT_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RESULT_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RESULT_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RESULT_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>DQ Result Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RESULT_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>DQ Result Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_RESULT_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQScopePropertyTypeImpl <em>DQ Scope Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQScopePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQScopePropertyType()
	 * @generated
	 */
	int DQ_SCOPE_PROPERTY_TYPE = 68;

	/**
	 * The feature id for the '<em><b>DQ Scope</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_PROPERTY_TYPE__DQ_SCOPE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Scope Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Scope Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQScopeTypeImpl <em>DQ Scope Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQScopeTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQScopeType()
	 * @generated
	 */
	int DQ_SCOPE_TYPE = 69;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Level</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_TYPE__LEVEL = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Extent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_TYPE__EXTENT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Level Description</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_TYPE__LEVEL_DESCRIPTION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>DQ Scope Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>DQ Scope Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_SCOPE_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQTemporalAccuracyPropertyTypeImpl <em>DQ Temporal Accuracy Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQTemporalAccuracyPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQTemporalAccuracyPropertyType()
	 * @generated
	 */
	int DQ_TEMPORAL_ACCURACY_PROPERTY_TYPE = 70;

	/**
	 * The feature id for the '<em><b>Abstract DQ Temporal Accuracy Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_ACCURACY_PROPERTY_TYPE__ABSTRACT_DQ_TEMPORAL_ACCURACY_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract DQ Temporal Accuracy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_ACCURACY_PROPERTY_TYPE__ABSTRACT_DQ_TEMPORAL_ACCURACY = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_ACCURACY_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_ACCURACY_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_ACCURACY_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_ACCURACY_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_ACCURACY_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_ACCURACY_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_ACCURACY_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_ACCURACY_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_ACCURACY_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>DQ Temporal Accuracy Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_ACCURACY_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>DQ Temporal Accuracy Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_ACCURACY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQTemporalConsistencyPropertyTypeImpl <em>DQ Temporal Consistency Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQTemporalConsistencyPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQTemporalConsistencyPropertyType()
	 * @generated
	 */
	int DQ_TEMPORAL_CONSISTENCY_PROPERTY_TYPE = 71;

	/**
	 * The feature id for the '<em><b>DQ Temporal Consistency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_PROPERTY_TYPE__DQ_TEMPORAL_CONSISTENCY = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Temporal Consistency Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Temporal Consistency Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQTemporalConsistencyTypeImpl <em>DQ Temporal Consistency Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQTemporalConsistencyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQTemporalConsistencyType()
	 * @generated
	 */
	int DQ_TEMPORAL_CONSISTENCY_TYPE = 72;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_TYPE__ID = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_TYPE__UUID = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_TYPE__DATE_TIME = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_TYPE__RESULT = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>DQ Temporal Consistency Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_TYPE_FEATURE_COUNT = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DQ Temporal Consistency Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_CONSISTENCY_TYPE_OPERATION_COUNT = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQTemporalValidityPropertyTypeImpl <em>DQ Temporal Validity Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQTemporalValidityPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQTemporalValidityPropertyType()
	 * @generated
	 */
	int DQ_TEMPORAL_VALIDITY_PROPERTY_TYPE = 73;

	/**
	 * The feature id for the '<em><b>DQ Temporal Validity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_PROPERTY_TYPE__DQ_TEMPORAL_VALIDITY = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Temporal Validity Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Temporal Validity Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQThematicAccuracyPropertyTypeImpl <em>DQ Thematic Accuracy Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQThematicAccuracyPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQThematicAccuracyPropertyType()
	 * @generated
	 */
	int DQ_THEMATIC_ACCURACY_PROPERTY_TYPE = 74;

	/**
	 * The feature id for the '<em><b>Abstract DQ Thematic Accuracy Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_ACCURACY_PROPERTY_TYPE__ABSTRACT_DQ_THEMATIC_ACCURACY_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract DQ Thematic Accuracy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_ACCURACY_PROPERTY_TYPE__ABSTRACT_DQ_THEMATIC_ACCURACY = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_ACCURACY_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_ACCURACY_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_ACCURACY_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_ACCURACY_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_ACCURACY_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_ACCURACY_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_ACCURACY_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_ACCURACY_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_ACCURACY_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>DQ Thematic Accuracy Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_ACCURACY_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>DQ Thematic Accuracy Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_ACCURACY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQThematicClassificationCorrectnessPropertyTypeImpl <em>DQ Thematic Classification Correctness Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQThematicClassificationCorrectnessPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQThematicClassificationCorrectnessPropertyType()
	 * @generated
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_PROPERTY_TYPE = 75;

	/**
	 * The feature id for the '<em><b>DQ Thematic Classification Correctness</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_PROPERTY_TYPE__DQ_THEMATIC_CLASSIFICATION_CORRECTNESS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Thematic Classification Correctness Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Thematic Classification Correctness Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQTopologicalConsistencyPropertyTypeImpl <em>DQ Topological Consistency Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQTopologicalConsistencyPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQTopologicalConsistencyPropertyType()
	 * @generated
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_PROPERTY_TYPE = 76;

	/**
	 * The feature id for the '<em><b>DQ Topological Consistency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_PROPERTY_TYPE__DQ_TOPOLOGICAL_CONSISTENCY = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DQ Topological Consistency Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DQ Topological Consistency Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSAggregatePropertyTypeImpl <em>DS Aggregate Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSAggregatePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSAggregatePropertyType()
	 * @generated
	 */
	int DS_AGGREGATE_PROPERTY_TYPE = 77;

	/**
	 * The feature id for the '<em><b>Abstract DS Aggregate Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_AGGREGATE_PROPERTY_TYPE__ABSTRACT_DS_AGGREGATE_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract DS Aggregate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_AGGREGATE_PROPERTY_TYPE__ABSTRACT_DS_AGGREGATE = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_AGGREGATE_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_AGGREGATE_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_AGGREGATE_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_AGGREGATE_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_AGGREGATE_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_AGGREGATE_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_AGGREGATE_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_AGGREGATE_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_AGGREGATE_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>DS Aggregate Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_AGGREGATE_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>DS Aggregate Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_AGGREGATE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSAssociationPropertyTypeImpl <em>DS Association Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSAssociationPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSAssociationPropertyType()
	 * @generated
	 */
	int DS_ASSOCIATION_PROPERTY_TYPE = 78;

	/**
	 * The feature id for the '<em><b>DS Association</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_PROPERTY_TYPE__DS_ASSOCIATION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DS Association Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DS Association Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSAssociationTypeCodePropertyTypeImpl <em>DS Association Type Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSAssociationTypeCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSAssociationTypeCodePropertyType()
	 * @generated
	 */
	int DS_ASSOCIATION_TYPE_CODE_PROPERTY_TYPE = 79;

	/**
	 * The feature id for the '<em><b>DS Association Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_TYPE_CODE_PROPERTY_TYPE__DS_ASSOCIATION_TYPE_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_TYPE_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>DS Association Type Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_TYPE_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>DS Association Type Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_TYPE_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSDataSetPropertyTypeImpl <em>DS Data Set Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSDataSetPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSDataSetPropertyType()
	 * @generated
	 */
	int DS_DATA_SET_PROPERTY_TYPE = 80;

	/**
	 * The feature id for the '<em><b>DS Data Set</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_DATA_SET_PROPERTY_TYPE__DS_DATA_SET = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_DATA_SET_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_DATA_SET_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_DATA_SET_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_DATA_SET_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_DATA_SET_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_DATA_SET_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_DATA_SET_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_DATA_SET_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_DATA_SET_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DS Data Set Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_DATA_SET_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DS Data Set Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_DATA_SET_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSDataSetTypeImpl <em>DS Data Set Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSDataSetTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSDataSetType()
	 * @generated
	 */
	int DS_DATA_SET_TYPE = 81;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_DATA_SET_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_DATA_SET_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Has</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_DATA_SET_TYPE__HAS = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Part Of</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_DATA_SET_TYPE__PART_OF = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>DS Data Set Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_DATA_SET_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>DS Data Set Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_DATA_SET_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSInitiativeTypeCodePropertyTypeImpl <em>DS Initiative Type Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSInitiativeTypeCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSInitiativeTypeCodePropertyType()
	 * @generated
	 */
	int DS_INITIATIVE_TYPE_CODE_PROPERTY_TYPE = 82;

	/**
	 * The feature id for the '<em><b>DS Initiative Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_TYPE_CODE_PROPERTY_TYPE__DS_INITIATIVE_TYPE_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_TYPE_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>DS Initiative Type Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_TYPE_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>DS Initiative Type Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_TYPE_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.EXExtentPropertyTypeImpl <em>EX Extent Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.EXExtentPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getEXExtentPropertyType()
	 * @generated
	 */
	int EX_EXTENT_PROPERTY_TYPE = 83;

	/**
	 * The feature id for the '<em><b>EX Extent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_PROPERTY_TYPE__EX_EXTENT = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>EX Extent Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>EX Extent Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.EXExtentTypeImpl <em>EX Extent Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.EXExtentTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getEXExtentType()
	 * @generated
	 */
	int EX_EXTENT_TYPE = 84;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_TYPE__DESCRIPTION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Geographic Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_TYPE__GEOGRAPHIC_ELEMENT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Temporal Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_TYPE__TEMPORAL_ELEMENT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Vertical Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_TYPE__VERTICAL_ELEMENT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>EX Extent Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>EX Extent Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_EXTENT_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.EXGeographicExtentPropertyTypeImpl <em>EX Geographic Extent Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.EXGeographicExtentPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getEXGeographicExtentPropertyType()
	 * @generated
	 */
	int EX_GEOGRAPHIC_EXTENT_PROPERTY_TYPE = 85;

	/**
	 * The feature id for the '<em><b>Abstract EX Geographic Extent Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_EXTENT_PROPERTY_TYPE__ABSTRACT_EX_GEOGRAPHIC_EXTENT_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract EX Geographic Extent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_EXTENT_PROPERTY_TYPE__ABSTRACT_EX_GEOGRAPHIC_EXTENT = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_EXTENT_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_EXTENT_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_EXTENT_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_EXTENT_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_EXTENT_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_EXTENT_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_EXTENT_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_EXTENT_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_EXTENT_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>EX Geographic Extent Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_EXTENT_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>EX Geographic Extent Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_EXTENT_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.EXTemporalExtentPropertyTypeImpl <em>EX Temporal Extent Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.EXTemporalExtentPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getEXTemporalExtentPropertyType()
	 * @generated
	 */
	int EX_TEMPORAL_EXTENT_PROPERTY_TYPE = 86;

	/**
	 * The feature id for the '<em><b>EX Temporal Extent Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_TEMPORAL_EXTENT_PROPERTY_TYPE__EX_TEMPORAL_EXTENT_GROUP = 0;

	/**
	 * The feature id for the '<em><b>EX Temporal Extent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_TEMPORAL_EXTENT_PROPERTY_TYPE__EX_TEMPORAL_EXTENT = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_TEMPORAL_EXTENT_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_TEMPORAL_EXTENT_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_TEMPORAL_EXTENT_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_TEMPORAL_EXTENT_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_TEMPORAL_EXTENT_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_TEMPORAL_EXTENT_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_TEMPORAL_EXTENT_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_TEMPORAL_EXTENT_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_TEMPORAL_EXTENT_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>EX Temporal Extent Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_TEMPORAL_EXTENT_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>EX Temporal Extent Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_TEMPORAL_EXTENT_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.EXTemporalExtentTypeImpl <em>EX Temporal Extent Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.EXTemporalExtentTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getEXTemporalExtentType()
	 * @generated
	 */
	int EX_TEMPORAL_EXTENT_TYPE = 87;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_TEMPORAL_EXTENT_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_TEMPORAL_EXTENT_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Extent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_TEMPORAL_EXTENT_TYPE__EXTENT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>EX Temporal Extent Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_TEMPORAL_EXTENT_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>EX Temporal Extent Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_TEMPORAL_EXTENT_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.EXVerticalExtentPropertyTypeImpl <em>EX Vertical Extent Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.EXVerticalExtentPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getEXVerticalExtentPropertyType()
	 * @generated
	 */
	int EX_VERTICAL_EXTENT_PROPERTY_TYPE = 88;

	/**
	 * The feature id for the '<em><b>EX Vertical Extent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_PROPERTY_TYPE__EX_VERTICAL_EXTENT = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>EX Vertical Extent Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>EX Vertical Extent Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.EXVerticalExtentTypeImpl <em>EX Vertical Extent Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.EXVerticalExtentTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getEXVerticalExtentType()
	 * @generated
	 */
	int EX_VERTICAL_EXTENT_TYPE = 89;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Minimum Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_TYPE__MINIMUM_VALUE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Maximum Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_TYPE__MAXIMUM_VALUE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Vertical CRS</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_TYPE__VERTICAL_CRS = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>EX Vertical Extent Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>EX Vertical Extent Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_VERTICAL_EXTENT_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DocumentRootImpl <em>Document Root</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DocumentRootImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDocumentRoot()
	 * @generated
	 */
	int DOCUMENT_ROOT = 90;

	/**
	 * The feature id for the '<em><b>Mixed</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MIXED = 0;

	/**
	 * The feature id for the '<em><b>XMLNS Prefix Map</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__XMLNS_PREFIX_MAP = 1;

	/**
	 * The feature id for the '<em><b>XSI Schema Location</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__XSI_SCHEMA_LOCATION = 2;

	/**
	 * The feature id for the '<em><b>Abstract DQ Completeness</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ABSTRACT_DQ_COMPLETENESS = 3;

	/**
	 * The feature id for the '<em><b>Abstract DQ Element</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ABSTRACT_DQ_ELEMENT = 4;

	/**
	 * The feature id for the '<em><b>Abstract DQ Logical Consistency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ABSTRACT_DQ_LOGICAL_CONSISTENCY = 5;

	/**
	 * The feature id for the '<em><b>Abstract DQ Positional Accuracy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ABSTRACT_DQ_POSITIONAL_ACCURACY = 6;

	/**
	 * The feature id for the '<em><b>Abstract DQ Result</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ABSTRACT_DQ_RESULT = 7;

	/**
	 * The feature id for the '<em><b>Abstract DQ Temporal Accuracy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ABSTRACT_DQ_TEMPORAL_ACCURACY = 8;

	/**
	 * The feature id for the '<em><b>Abstract DQ Thematic Accuracy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ABSTRACT_DQ_THEMATIC_ACCURACY = 9;

	/**
	 * The feature id for the '<em><b>Abstract DS Aggregate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ABSTRACT_DS_AGGREGATE = 10;

	/**
	 * The feature id for the '<em><b>Abstract EX Geographic Extent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ABSTRACT_EX_GEOGRAPHIC_EXTENT = 11;

	/**
	 * The feature id for the '<em><b>Abstract MD Content Information</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ABSTRACT_MD_CONTENT_INFORMATION = 12;

	/**
	 * The feature id for the '<em><b>Abstract MD Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ABSTRACT_MD_IDENTIFICATION = 13;

	/**
	 * The feature id for the '<em><b>Abstract MD Spatial Representation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ABSTRACT_MD_SPATIAL_REPRESENTATION = 14;

	/**
	 * The feature id for the '<em><b>Abstract RS Reference System</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__ABSTRACT_RS_REFERENCE_SYSTEM = 15;

	/**
	 * The feature id for the '<em><b>CI Address</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CI_ADDRESS = 16;

	/**
	 * The feature id for the '<em><b>CI Citation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CI_CITATION = 17;

	/**
	 * The feature id for the '<em><b>CI Contact</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CI_CONTACT = 18;

	/**
	 * The feature id for the '<em><b>CI Date</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CI_DATE = 19;

	/**
	 * The feature id for the '<em><b>CI Date Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CI_DATE_TYPE_CODE = 20;

	/**
	 * The feature id for the '<em><b>CI On Line Function Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CI_ON_LINE_FUNCTION_CODE = 21;

	/**
	 * The feature id for the '<em><b>CI Online Resource</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CI_ONLINE_RESOURCE = 22;

	/**
	 * The feature id for the '<em><b>CI Presentation Form Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CI_PRESENTATION_FORM_CODE = 23;

	/**
	 * The feature id for the '<em><b>CI Responsible Party</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CI_RESPONSIBLE_PARTY = 24;

	/**
	 * The feature id for the '<em><b>CI Role Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CI_ROLE_CODE = 25;

	/**
	 * The feature id for the '<em><b>CI Series</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CI_SERIES = 26;

	/**
	 * The feature id for the '<em><b>CI Telephone</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CI_TELEPHONE = 27;

	/**
	 * The feature id for the '<em><b>Country</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__COUNTRY = 28;

	/**
	 * The feature id for the '<em><b>DQ Absolute External Positional Accuracy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_ABSOLUTE_EXTERNAL_POSITIONAL_ACCURACY = 29;

	/**
	 * The feature id for the '<em><b>DQ Accuracy Of ATime Measurement</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_ACCURACY_OF_ATIME_MEASUREMENT = 30;

	/**
	 * The feature id for the '<em><b>DQ Completeness Commission</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_COMPLETENESS_COMMISSION = 31;

	/**
	 * The feature id for the '<em><b>DQ Completeness Omission</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_COMPLETENESS_OMISSION = 32;

	/**
	 * The feature id for the '<em><b>DQ Conceptual Consistency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_CONCEPTUAL_CONSISTENCY = 33;

	/**
	 * The feature id for the '<em><b>DQ Conformance Result</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_CONFORMANCE_RESULT = 34;

	/**
	 * The feature id for the '<em><b>DQ Data Quality</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_DATA_QUALITY = 35;

	/**
	 * The feature id for the '<em><b>DQ Domain Consistency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_DOMAIN_CONSISTENCY = 36;

	/**
	 * The feature id for the '<em><b>DQ Evaluation Method Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_EVALUATION_METHOD_TYPE_CODE = 37;

	/**
	 * The feature id for the '<em><b>DQ Format Consistency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_FORMAT_CONSISTENCY = 38;

	/**
	 * The feature id for the '<em><b>DQ Gridded Data Positional Accuracy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_GRIDDED_DATA_POSITIONAL_ACCURACY = 39;

	/**
	 * The feature id for the '<em><b>DQ Non Quantitative Attribute Accuracy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_NON_QUANTITATIVE_ATTRIBUTE_ACCURACY = 40;

	/**
	 * The feature id for the '<em><b>DQ Quantitative Attribute Accuracy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_QUANTITATIVE_ATTRIBUTE_ACCURACY = 41;

	/**
	 * The feature id for the '<em><b>DQ Quantitative Result</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_QUANTITATIVE_RESULT = 42;

	/**
	 * The feature id for the '<em><b>DQ Relative Internal Positional Accuracy</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_RELATIVE_INTERNAL_POSITIONAL_ACCURACY = 43;

	/**
	 * The feature id for the '<em><b>DQ Scope</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_SCOPE = 44;

	/**
	 * The feature id for the '<em><b>DQ Temporal Consistency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_TEMPORAL_CONSISTENCY = 45;

	/**
	 * The feature id for the '<em><b>DQ Temporal Validity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_TEMPORAL_VALIDITY = 46;

	/**
	 * The feature id for the '<em><b>DQ Thematic Classification Correctness</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_THEMATIC_CLASSIFICATION_CORRECTNESS = 47;

	/**
	 * The feature id for the '<em><b>DQ Topological Consistency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DQ_TOPOLOGICAL_CONSISTENCY = 48;

	/**
	 * The feature id for the '<em><b>DS Association</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DS_ASSOCIATION = 49;

	/**
	 * The feature id for the '<em><b>DS Association Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DS_ASSOCIATION_TYPE_CODE = 50;

	/**
	 * The feature id for the '<em><b>DS Data Set</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DS_DATA_SET = 51;

	/**
	 * The feature id for the '<em><b>DS Initiative</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DS_INITIATIVE = 52;

	/**
	 * The feature id for the '<em><b>DS Initiative Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DS_INITIATIVE_TYPE_CODE = 53;

	/**
	 * The feature id for the '<em><b>DS Other Aggregate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DS_OTHER_AGGREGATE = 54;

	/**
	 * The feature id for the '<em><b>DS Platform</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DS_PLATFORM = 55;

	/**
	 * The feature id for the '<em><b>DS Series</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DS_SERIES = 56;

	/**
	 * The feature id for the '<em><b>DS Production Series</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DS_PRODUCTION_SERIES = 57;

	/**
	 * The feature id for the '<em><b>DS Sensor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DS_SENSOR = 58;

	/**
	 * The feature id for the '<em><b>DS Stereo Mate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__DS_STEREO_MATE = 59;

	/**
	 * The feature id for the '<em><b>EX Bounding Polygon</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__EX_BOUNDING_POLYGON = 60;

	/**
	 * The feature id for the '<em><b>EX Extent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__EX_EXTENT = 61;

	/**
	 * The feature id for the '<em><b>EX Geographic Bounding Box</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__EX_GEOGRAPHIC_BOUNDING_BOX = 62;

	/**
	 * The feature id for the '<em><b>EX Geographic Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__EX_GEOGRAPHIC_DESCRIPTION = 63;

	/**
	 * The feature id for the '<em><b>EX Spatial Temporal Extent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__EX_SPATIAL_TEMPORAL_EXTENT = 64;

	/**
	 * The feature id for the '<em><b>EX Temporal Extent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__EX_TEMPORAL_EXTENT = 65;

	/**
	 * The feature id for the '<em><b>EX Vertical Extent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__EX_VERTICAL_EXTENT = 66;

	/**
	 * The feature id for the '<em><b>Language Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__LANGUAGE_CODE = 67;

	/**
	 * The feature id for the '<em><b>LI Lineage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__LI_LINEAGE = 68;

	/**
	 * The feature id for the '<em><b>LI Process Step</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__LI_PROCESS_STEP = 69;

	/**
	 * The feature id for the '<em><b>LI Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__LI_SOURCE = 70;

	/**
	 * The feature id for the '<em><b>Localised Character String</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__LOCALISED_CHARACTER_STRING = 71;

	/**
	 * The feature id for the '<em><b>MD Aggregate Information</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_AGGREGATE_INFORMATION = 72;

	/**
	 * The feature id for the '<em><b>MD Application Schema Information</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_APPLICATION_SCHEMA_INFORMATION = 73;

	/**
	 * The feature id for the '<em><b>MD Band</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_BAND = 74;

	/**
	 * The feature id for the '<em><b>MD Range Dimension</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_RANGE_DIMENSION = 75;

	/**
	 * The feature id for the '<em><b>MD Browse Graphic</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_BROWSE_GRAPHIC = 76;

	/**
	 * The feature id for the '<em><b>MD Cell Geometry Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_CELL_GEOMETRY_CODE = 77;

	/**
	 * The feature id for the '<em><b>MD Character Set Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_CHARACTER_SET_CODE = 78;

	/**
	 * The feature id for the '<em><b>MD Classification Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_CLASSIFICATION_CODE = 79;

	/**
	 * The feature id for the '<em><b>MD Constraints</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_CONSTRAINTS = 80;

	/**
	 * The feature id for the '<em><b>MD Coverage Content Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_COVERAGE_CONTENT_TYPE_CODE = 81;

	/**
	 * The feature id for the '<em><b>MD Coverage Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_COVERAGE_DESCRIPTION = 82;

	/**
	 * The feature id for the '<em><b>MD Data Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_DATA_IDENTIFICATION = 83;

	/**
	 * The feature id for the '<em><b>MD Datatype Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_DATATYPE_CODE = 84;

	/**
	 * The feature id for the '<em><b>MD Digital Transfer Options</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_DIGITAL_TRANSFER_OPTIONS = 85;

	/**
	 * The feature id for the '<em><b>MD Dimension</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_DIMENSION = 86;

	/**
	 * The feature id for the '<em><b>MD Dimension Name Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_DIMENSION_NAME_TYPE_CODE = 87;

	/**
	 * The feature id for the '<em><b>MD Distribution</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_DISTRIBUTION = 88;

	/**
	 * The feature id for the '<em><b>MD Distribution Units</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_DISTRIBUTION_UNITS = 89;

	/**
	 * The feature id for the '<em><b>MD Distributor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_DISTRIBUTOR = 90;

	/**
	 * The feature id for the '<em><b>MD Extended Element Information</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_EXTENDED_ELEMENT_INFORMATION = 91;

	/**
	 * The feature id for the '<em><b>MD Feature Catalogue Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_FEATURE_CATALOGUE_DESCRIPTION = 92;

	/**
	 * The feature id for the '<em><b>MD Format</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_FORMAT = 93;

	/**
	 * The feature id for the '<em><b>MD Geometric Objects</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_GEOMETRIC_OBJECTS = 94;

	/**
	 * The feature id for the '<em><b>MD Geometric Object Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_GEOMETRIC_OBJECT_TYPE_CODE = 95;

	/**
	 * The feature id for the '<em><b>MD Georectified</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_GEORECTIFIED = 96;

	/**
	 * The feature id for the '<em><b>MD Grid Spatial Representation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_GRID_SPATIAL_REPRESENTATION = 97;

	/**
	 * The feature id for the '<em><b>MD Georeferenceable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_GEOREFERENCEABLE = 98;

	/**
	 * The feature id for the '<em><b>MD Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_IDENTIFIER = 99;

	/**
	 * The feature id for the '<em><b>MD Image Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_IMAGE_DESCRIPTION = 100;

	/**
	 * The feature id for the '<em><b>MD Imaging Condition Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_IMAGING_CONDITION_CODE = 101;

	/**
	 * The feature id for the '<em><b>MD Keywords</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_KEYWORDS = 102;

	/**
	 * The feature id for the '<em><b>MD Keyword Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_KEYWORD_TYPE_CODE = 103;

	/**
	 * The feature id for the '<em><b>MD Legal Constraints</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_LEGAL_CONSTRAINTS = 104;

	/**
	 * The feature id for the '<em><b>MD Maintenance Frequency Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_MAINTENANCE_FREQUENCY_CODE = 105;

	/**
	 * The feature id for the '<em><b>MD Maintenance Information</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_MAINTENANCE_INFORMATION = 106;

	/**
	 * The feature id for the '<em><b>MD Medium</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_MEDIUM = 107;

	/**
	 * The feature id for the '<em><b>MD Medium Format Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_MEDIUM_FORMAT_CODE = 108;

	/**
	 * The feature id for the '<em><b>MD Medium Name Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_MEDIUM_NAME_CODE = 109;

	/**
	 * The feature id for the '<em><b>MD Metadata</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_METADATA = 110;

	/**
	 * The feature id for the '<em><b>MD Metadata Extension Information</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_METADATA_EXTENSION_INFORMATION = 111;

	/**
	 * The feature id for the '<em><b>MD Obligation Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_OBLIGATION_CODE = 112;

	/**
	 * The feature id for the '<em><b>MD Pixel Orientation Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_PIXEL_ORIENTATION_CODE = 113;

	/**
	 * The feature id for the '<em><b>MD Portrayal Catalogue Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_PORTRAYAL_CATALOGUE_REFERENCE = 114;

	/**
	 * The feature id for the '<em><b>MD Progress Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_PROGRESS_CODE = 115;

	/**
	 * The feature id for the '<em><b>MD Reference System</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_REFERENCE_SYSTEM = 116;

	/**
	 * The feature id for the '<em><b>MD Representative Fraction</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_REPRESENTATIVE_FRACTION = 117;

	/**
	 * The feature id for the '<em><b>MD Resolution</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_RESOLUTION = 118;

	/**
	 * The feature id for the '<em><b>MD Restriction Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_RESTRICTION_CODE = 119;

	/**
	 * The feature id for the '<em><b>MD Scope Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_SCOPE_CODE = 120;

	/**
	 * The feature id for the '<em><b>MD Scope Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_SCOPE_DESCRIPTION = 121;

	/**
	 * The feature id for the '<em><b>MD Security Constraints</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_SECURITY_CONSTRAINTS = 122;

	/**
	 * The feature id for the '<em><b>MD Service Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_SERVICE_IDENTIFICATION = 123;

	/**
	 * The feature id for the '<em><b>MD Spatial Representation Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_SPATIAL_REPRESENTATION_TYPE_CODE = 124;

	/**
	 * The feature id for the '<em><b>MD Standard Order Process</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_STANDARD_ORDER_PROCESS = 125;

	/**
	 * The feature id for the '<em><b>MD Topic Category Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_TOPIC_CATEGORY_CODE = 126;

	/**
	 * The feature id for the '<em><b>MD Topology Level Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_TOPOLOGY_LEVEL_CODE = 127;

	/**
	 * The feature id for the '<em><b>MD Usage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_USAGE = 128;

	/**
	 * The feature id for the '<em><b>MD Vector Spatial Representation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MD_VECTOR_SPATIAL_REPRESENTATION = 129;

	/**
	 * The feature id for the '<em><b>PT Free Text</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PT_FREE_TEXT = 130;

	/**
	 * The feature id for the '<em><b>PT Locale</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PT_LOCALE = 131;

	/**
	 * The feature id for the '<em><b>PT Locale Container</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__PT_LOCALE_CONTAINER = 132;

	/**
	 * The feature id for the '<em><b>RS Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__RS_IDENTIFIER = 133;

	/**
	 * The feature id for the '<em><b>URL</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__URL = 134;

	/**
	 * The number of structural features of the '<em>Document Root</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT_FEATURE_COUNT = 135;

	/**
	 * The number of operations of the '<em>Document Root</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQTemporalValidityTypeImpl <em>DQ Temporal Validity Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQTemporalValidityTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQTemporalValidityType()
	 * @generated
	 */
	int DQ_TEMPORAL_VALIDITY_TYPE = 91;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_TYPE__ID = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_TYPE__UUID = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_TYPE__DATE_TIME = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_TYPE__RESULT = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>DQ Temporal Validity Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_TYPE_FEATURE_COUNT = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DQ Temporal Validity Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TEMPORAL_VALIDITY_TYPE_OPERATION_COUNT = ABSTRACT_DQ_TEMPORAL_ACCURACY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQThematicClassificationCorrectnessTypeImpl <em>DQ Thematic Classification Correctness Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQThematicClassificationCorrectnessTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQThematicClassificationCorrectnessType()
	 * @generated
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_TYPE = 92;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_TYPE__ID = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_TYPE__UUID = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_TYPE__DATE_TIME = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_TYPE__RESULT = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>DQ Thematic Classification Correctness Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_TYPE_FEATURE_COUNT = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DQ Thematic Classification Correctness Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_THEMATIC_CLASSIFICATION_CORRECTNESS_TYPE_OPERATION_COUNT = ABSTRACT_DQ_THEMATIC_ACCURACY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DQTopologicalConsistencyTypeImpl <em>DQ Topological Consistency Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DQTopologicalConsistencyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDQTopologicalConsistencyType()
	 * @generated
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_TYPE = 93;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_TYPE__ID = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_TYPE__UUID = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name Of Measure</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_TYPE__NAME_OF_MEASURE = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__NAME_OF_MEASURE;

	/**
	 * The feature id for the '<em><b>Measure Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_TYPE__MEASURE_IDENTIFICATION = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__MEASURE_IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Measure Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_TYPE__MEASURE_DESCRIPTION = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__MEASURE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Method Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_TYPE__EVALUATION_METHOD_TYPE = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__EVALUATION_METHOD_TYPE;

	/**
	 * The feature id for the '<em><b>Evaluation Method Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_TYPE__EVALUATION_METHOD_DESCRIPTION = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__EVALUATION_METHOD_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Evaluation Procedure</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_TYPE__EVALUATION_PROCEDURE = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__EVALUATION_PROCEDURE;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_TYPE__DATE_TIME = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__DATE_TIME;

	/**
	 * The feature id for the '<em><b>Result</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_TYPE__RESULT = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE__RESULT;

	/**
	 * The number of structural features of the '<em>DQ Topological Consistency Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_TYPE_FEATURE_COUNT = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DQ Topological Consistency Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DQ_TOPOLOGICAL_CONSISTENCY_TYPE_OPERATION_COUNT = ABSTRACT_DQ_LOGICAL_CONSISTENCY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSAssociationTypeImpl <em>DS Association Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSAssociationTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSAssociationType()
	 * @generated
	 */
	int DS_ASSOCIATION_TYPE = 94;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The number of structural features of the '<em>DS Association Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DS Association Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_ASSOCIATION_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSInitiativePropertyTypeImpl <em>DS Initiative Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSInitiativePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSInitiativePropertyType()
	 * @generated
	 */
	int DS_INITIATIVE_PROPERTY_TYPE = 95;

	/**
	 * The feature id for the '<em><b>DS Initiative</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_PROPERTY_TYPE__DS_INITIATIVE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DS Initiative Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DS Initiative Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSInitiativeTypeImpl <em>DS Initiative Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSInitiativeTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSInitiativeType()
	 * @generated
	 */
	int DS_INITIATIVE_TYPE = 96;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_TYPE__ID = ABSTRACT_DS_AGGREGATE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_TYPE__UUID = ABSTRACT_DS_AGGREGATE_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Composed Of</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_TYPE__COMPOSED_OF = ABSTRACT_DS_AGGREGATE_TYPE__COMPOSED_OF;

	/**
	 * The feature id for the '<em><b>Series Metadata</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_TYPE__SERIES_METADATA = ABSTRACT_DS_AGGREGATE_TYPE__SERIES_METADATA;

	/**
	 * The feature id for the '<em><b>Subset</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_TYPE__SUBSET = ABSTRACT_DS_AGGREGATE_TYPE__SUBSET;

	/**
	 * The feature id for the '<em><b>Superset</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_TYPE__SUPERSET = ABSTRACT_DS_AGGREGATE_TYPE__SUPERSET;

	/**
	 * The number of structural features of the '<em>DS Initiative Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_TYPE_FEATURE_COUNT = ABSTRACT_DS_AGGREGATE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DS Initiative Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_INITIATIVE_TYPE_OPERATION_COUNT = ABSTRACT_DS_AGGREGATE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSOtherAggregatePropertyTypeImpl <em>DS Other Aggregate Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSOtherAggregatePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSOtherAggregatePropertyType()
	 * @generated
	 */
	int DS_OTHER_AGGREGATE_PROPERTY_TYPE = 97;

	/**
	 * The feature id for the '<em><b>DS Other Aggregate Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_PROPERTY_TYPE__DS_OTHER_AGGREGATE_GROUP = 0;

	/**
	 * The feature id for the '<em><b>DS Other Aggregate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_PROPERTY_TYPE__DS_OTHER_AGGREGATE = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>DS Other Aggregate Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>DS Other Aggregate Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSOtherAggregateTypeImpl <em>DS Other Aggregate Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSOtherAggregateTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSOtherAggregateType()
	 * @generated
	 */
	int DS_OTHER_AGGREGATE_TYPE = 98;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_TYPE__ID = ABSTRACT_DS_AGGREGATE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_TYPE__UUID = ABSTRACT_DS_AGGREGATE_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Composed Of</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_TYPE__COMPOSED_OF = ABSTRACT_DS_AGGREGATE_TYPE__COMPOSED_OF;

	/**
	 * The feature id for the '<em><b>Series Metadata</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_TYPE__SERIES_METADATA = ABSTRACT_DS_AGGREGATE_TYPE__SERIES_METADATA;

	/**
	 * The feature id for the '<em><b>Subset</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_TYPE__SUBSET = ABSTRACT_DS_AGGREGATE_TYPE__SUBSET;

	/**
	 * The feature id for the '<em><b>Superset</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_TYPE__SUPERSET = ABSTRACT_DS_AGGREGATE_TYPE__SUPERSET;

	/**
	 * The number of structural features of the '<em>DS Other Aggregate Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_TYPE_FEATURE_COUNT = ABSTRACT_DS_AGGREGATE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DS Other Aggregate Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_OTHER_AGGREGATE_TYPE_OPERATION_COUNT = ABSTRACT_DS_AGGREGATE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSPlatformPropertyTypeImpl <em>DS Platform Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSPlatformPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSPlatformPropertyType()
	 * @generated
	 */
	int DS_PLATFORM_PROPERTY_TYPE = 99;

	/**
	 * The feature id for the '<em><b>DS Platform</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_PROPERTY_TYPE__DS_PLATFORM = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DS Platform Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DS Platform Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSSeriesTypeImpl <em>DS Series Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSSeriesTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSSeriesType()
	 * @generated
	 */
	int DS_SERIES_TYPE = 106;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_TYPE__ID = ABSTRACT_DS_AGGREGATE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_TYPE__UUID = ABSTRACT_DS_AGGREGATE_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Composed Of</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_TYPE__COMPOSED_OF = ABSTRACT_DS_AGGREGATE_TYPE__COMPOSED_OF;

	/**
	 * The feature id for the '<em><b>Series Metadata</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_TYPE__SERIES_METADATA = ABSTRACT_DS_AGGREGATE_TYPE__SERIES_METADATA;

	/**
	 * The feature id for the '<em><b>Subset</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_TYPE__SUBSET = ABSTRACT_DS_AGGREGATE_TYPE__SUBSET;

	/**
	 * The feature id for the '<em><b>Superset</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_TYPE__SUPERSET = ABSTRACT_DS_AGGREGATE_TYPE__SUPERSET;

	/**
	 * The number of structural features of the '<em>DS Series Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_TYPE_FEATURE_COUNT = ABSTRACT_DS_AGGREGATE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DS Series Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_TYPE_OPERATION_COUNT = ABSTRACT_DS_AGGREGATE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSPlatformTypeImpl <em>DS Platform Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSPlatformTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSPlatformType()
	 * @generated
	 */
	int DS_PLATFORM_TYPE = 100;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_TYPE__ID = DS_SERIES_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_TYPE__UUID = DS_SERIES_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Composed Of</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_TYPE__COMPOSED_OF = DS_SERIES_TYPE__COMPOSED_OF;

	/**
	 * The feature id for the '<em><b>Series Metadata</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_TYPE__SERIES_METADATA = DS_SERIES_TYPE__SERIES_METADATA;

	/**
	 * The feature id for the '<em><b>Subset</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_TYPE__SUBSET = DS_SERIES_TYPE__SUBSET;

	/**
	 * The feature id for the '<em><b>Superset</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_TYPE__SUPERSET = DS_SERIES_TYPE__SUPERSET;

	/**
	 * The number of structural features of the '<em>DS Platform Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_TYPE_FEATURE_COUNT = DS_SERIES_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DS Platform Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PLATFORM_TYPE_OPERATION_COUNT = DS_SERIES_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSProductionSeriesPropertyTypeImpl <em>DS Production Series Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSProductionSeriesPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSProductionSeriesPropertyType()
	 * @generated
	 */
	int DS_PRODUCTION_SERIES_PROPERTY_TYPE = 101;

	/**
	 * The feature id for the '<em><b>DS Production Series</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_PROPERTY_TYPE__DS_PRODUCTION_SERIES = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DS Production Series Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DS Production Series Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSProductionSeriesTypeImpl <em>DS Production Series Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSProductionSeriesTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSProductionSeriesType()
	 * @generated
	 */
	int DS_PRODUCTION_SERIES_TYPE = 102;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_TYPE__ID = DS_SERIES_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_TYPE__UUID = DS_SERIES_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Composed Of</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_TYPE__COMPOSED_OF = DS_SERIES_TYPE__COMPOSED_OF;

	/**
	 * The feature id for the '<em><b>Series Metadata</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_TYPE__SERIES_METADATA = DS_SERIES_TYPE__SERIES_METADATA;

	/**
	 * The feature id for the '<em><b>Subset</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_TYPE__SUBSET = DS_SERIES_TYPE__SUBSET;

	/**
	 * The feature id for the '<em><b>Superset</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_TYPE__SUPERSET = DS_SERIES_TYPE__SUPERSET;

	/**
	 * The number of structural features of the '<em>DS Production Series Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_TYPE_FEATURE_COUNT = DS_SERIES_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DS Production Series Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_PRODUCTION_SERIES_TYPE_OPERATION_COUNT = DS_SERIES_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSSensorPropertyTypeImpl <em>DS Sensor Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSSensorPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSSensorPropertyType()
	 * @generated
	 */
	int DS_SENSOR_PROPERTY_TYPE = 103;

	/**
	 * The feature id for the '<em><b>DS Sensor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_PROPERTY_TYPE__DS_SENSOR = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DS Sensor Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DS Sensor Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSSensorTypeImpl <em>DS Sensor Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSSensorTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSSensorType()
	 * @generated
	 */
	int DS_SENSOR_TYPE = 104;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_TYPE__ID = DS_SERIES_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_TYPE__UUID = DS_SERIES_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Composed Of</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_TYPE__COMPOSED_OF = DS_SERIES_TYPE__COMPOSED_OF;

	/**
	 * The feature id for the '<em><b>Series Metadata</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_TYPE__SERIES_METADATA = DS_SERIES_TYPE__SERIES_METADATA;

	/**
	 * The feature id for the '<em><b>Subset</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_TYPE__SUBSET = DS_SERIES_TYPE__SUBSET;

	/**
	 * The feature id for the '<em><b>Superset</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_TYPE__SUPERSET = DS_SERIES_TYPE__SUPERSET;

	/**
	 * The number of structural features of the '<em>DS Sensor Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_TYPE_FEATURE_COUNT = DS_SERIES_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DS Sensor Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SENSOR_TYPE_OPERATION_COUNT = DS_SERIES_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSSeriesPropertyTypeImpl <em>DS Series Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSSeriesPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSSeriesPropertyType()
	 * @generated
	 */
	int DS_SERIES_PROPERTY_TYPE = 105;

	/**
	 * The feature id for the '<em><b>DS Series Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_PROPERTY_TYPE__DS_SERIES_GROUP = 0;

	/**
	 * The feature id for the '<em><b>DS Series</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_PROPERTY_TYPE__DS_SERIES = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>DS Series Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>DS Series Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_SERIES_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSStereoMatePropertyTypeImpl <em>DS Stereo Mate Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSStereoMatePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSStereoMatePropertyType()
	 * @generated
	 */
	int DS_STEREO_MATE_PROPERTY_TYPE = 107;

	/**
	 * The feature id for the '<em><b>DS Stereo Mate</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_PROPERTY_TYPE__DS_STEREO_MATE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>DS Stereo Mate Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>DS Stereo Mate Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.DSStereoMateTypeImpl <em>DS Stereo Mate Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.DSStereoMateTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getDSStereoMateType()
	 * @generated
	 */
	int DS_STEREO_MATE_TYPE = 108;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_TYPE__ID = DS_OTHER_AGGREGATE_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_TYPE__UUID = DS_OTHER_AGGREGATE_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Composed Of</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_TYPE__COMPOSED_OF = DS_OTHER_AGGREGATE_TYPE__COMPOSED_OF;

	/**
	 * The feature id for the '<em><b>Series Metadata</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_TYPE__SERIES_METADATA = DS_OTHER_AGGREGATE_TYPE__SERIES_METADATA;

	/**
	 * The feature id for the '<em><b>Subset</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_TYPE__SUBSET = DS_OTHER_AGGREGATE_TYPE__SUBSET;

	/**
	 * The feature id for the '<em><b>Superset</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_TYPE__SUPERSET = DS_OTHER_AGGREGATE_TYPE__SUPERSET;

	/**
	 * The number of structural features of the '<em>DS Stereo Mate Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_TYPE_FEATURE_COUNT = DS_OTHER_AGGREGATE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>DS Stereo Mate Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DS_STEREO_MATE_TYPE_OPERATION_COUNT = DS_OTHER_AGGREGATE_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.EXBoundingPolygonPropertyTypeImpl <em>EX Bounding Polygon Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.EXBoundingPolygonPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getEXBoundingPolygonPropertyType()
	 * @generated
	 */
	int EX_BOUNDING_POLYGON_PROPERTY_TYPE = 109;

	/**
	 * The feature id for the '<em><b>EX Bounding Polygon</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_BOUNDING_POLYGON_PROPERTY_TYPE__EX_BOUNDING_POLYGON = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_BOUNDING_POLYGON_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_BOUNDING_POLYGON_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_BOUNDING_POLYGON_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_BOUNDING_POLYGON_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_BOUNDING_POLYGON_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_BOUNDING_POLYGON_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_BOUNDING_POLYGON_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_BOUNDING_POLYGON_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_BOUNDING_POLYGON_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>EX Bounding Polygon Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_BOUNDING_POLYGON_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>EX Bounding Polygon Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_BOUNDING_POLYGON_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.EXBoundingPolygonTypeImpl <em>EX Bounding Polygon Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.EXBoundingPolygonTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getEXBoundingPolygonType()
	 * @generated
	 */
	int EX_BOUNDING_POLYGON_TYPE = 110;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_BOUNDING_POLYGON_TYPE__ID = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_BOUNDING_POLYGON_TYPE__UUID = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Extent Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_BOUNDING_POLYGON_TYPE__EXTENT_TYPE_CODE = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE__EXTENT_TYPE_CODE;

	/**
	 * The feature id for the '<em><b>Polygon</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_BOUNDING_POLYGON_TYPE__POLYGON = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>EX Bounding Polygon Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_BOUNDING_POLYGON_TYPE_FEATURE_COUNT = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>EX Bounding Polygon Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_BOUNDING_POLYGON_TYPE_OPERATION_COUNT = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.EXGeographicBoundingBoxPropertyTypeImpl <em>EX Geographic Bounding Box Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.EXGeographicBoundingBoxPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getEXGeographicBoundingBoxPropertyType()
	 * @generated
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_PROPERTY_TYPE = 111;

	/**
	 * The feature id for the '<em><b>EX Geographic Bounding Box</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_PROPERTY_TYPE__EX_GEOGRAPHIC_BOUNDING_BOX = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>EX Geographic Bounding Box Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>EX Geographic Bounding Box Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.EXGeographicBoundingBoxTypeImpl <em>EX Geographic Bounding Box Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.EXGeographicBoundingBoxTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getEXGeographicBoundingBoxType()
	 * @generated
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_TYPE = 112;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_TYPE__ID = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_TYPE__UUID = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Extent Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_TYPE__EXTENT_TYPE_CODE = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE__EXTENT_TYPE_CODE;

	/**
	 * The feature id for the '<em><b>West Bound Longitude</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_TYPE__WEST_BOUND_LONGITUDE = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>East Bound Longitude</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_TYPE__EAST_BOUND_LONGITUDE = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>South Bound Latitude</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_TYPE__SOUTH_BOUND_LATITUDE = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>North Bound Latitude</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_TYPE__NORTH_BOUND_LATITUDE = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>EX Geographic Bounding Box Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_TYPE_FEATURE_COUNT = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>EX Geographic Bounding Box Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_BOUNDING_BOX_TYPE_OPERATION_COUNT = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.EXGeographicDescriptionPropertyTypeImpl <em>EX Geographic Description Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.EXGeographicDescriptionPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getEXGeographicDescriptionPropertyType()
	 * @generated
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_PROPERTY_TYPE = 113;

	/**
	 * The feature id for the '<em><b>EX Geographic Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_PROPERTY_TYPE__EX_GEOGRAPHIC_DESCRIPTION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>EX Geographic Description Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>EX Geographic Description Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.EXGeographicDescriptionTypeImpl <em>EX Geographic Description Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.EXGeographicDescriptionTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getEXGeographicDescriptionType()
	 * @generated
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_TYPE = 114;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_TYPE__ID = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_TYPE__UUID = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Extent Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_TYPE__EXTENT_TYPE_CODE = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE__EXTENT_TYPE_CODE;

	/**
	 * The feature id for the '<em><b>Geographic Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_TYPE__GEOGRAPHIC_IDENTIFIER = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>EX Geographic Description Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_TYPE_FEATURE_COUNT = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>EX Geographic Description Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_GEOGRAPHIC_DESCRIPTION_TYPE_OPERATION_COUNT = ABSTRACT_EX_GEOGRAPHIC_EXTENT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.EXSpatialTemporalExtentPropertyTypeImpl <em>EX Spatial Temporal Extent Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.EXSpatialTemporalExtentPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getEXSpatialTemporalExtentPropertyType()
	 * @generated
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_PROPERTY_TYPE = 115;

	/**
	 * The feature id for the '<em><b>EX Spatial Temporal Extent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_PROPERTY_TYPE__EX_SPATIAL_TEMPORAL_EXTENT = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>EX Spatial Temporal Extent Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>EX Spatial Temporal Extent Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.EXSpatialTemporalExtentTypeImpl <em>EX Spatial Temporal Extent Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.EXSpatialTemporalExtentTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getEXSpatialTemporalExtentType()
	 * @generated
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_TYPE = 116;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_TYPE__ID = EX_TEMPORAL_EXTENT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_TYPE__UUID = EX_TEMPORAL_EXTENT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Extent</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_TYPE__EXTENT = EX_TEMPORAL_EXTENT_TYPE__EXTENT;

	/**
	 * The feature id for the '<em><b>Spatial Extent</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_TYPE__SPATIAL_EXTENT = EX_TEMPORAL_EXTENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>EX Spatial Temporal Extent Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_TYPE_FEATURE_COUNT = EX_TEMPORAL_EXTENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>EX Spatial Temporal Extent Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EX_SPATIAL_TEMPORAL_EXTENT_TYPE_OPERATION_COUNT = EX_TEMPORAL_EXTENT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.LanguageCodePropertyTypeImpl <em>Language Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.LanguageCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getLanguageCodePropertyType()
	 * @generated
	 */
	int LANGUAGE_CODE_PROPERTY_TYPE = 117;

	/**
	 * The feature id for the '<em><b>Language Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANGUAGE_CODE_PROPERTY_TYPE__LANGUAGE_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANGUAGE_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>Language Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANGUAGE_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Language Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LANGUAGE_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.LILineagePropertyTypeImpl <em>LI Lineage Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.LILineagePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getLILineagePropertyType()
	 * @generated
	 */
	int LI_LINEAGE_PROPERTY_TYPE = 118;

	/**
	 * The feature id for the '<em><b>LI Lineage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_PROPERTY_TYPE__LI_LINEAGE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>LI Lineage Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>LI Lineage Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.LILineageTypeImpl <em>LI Lineage Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.LILineageTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getLILineageType()
	 * @generated
	 */
	int LI_LINEAGE_TYPE = 119;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Statement</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_TYPE__STATEMENT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Process Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_TYPE__PROCESS_STEP = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_TYPE__SOURCE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>LI Lineage Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>LI Lineage Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_LINEAGE_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.LIProcessStepPropertyTypeImpl <em>LI Process Step Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.LIProcessStepPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getLIProcessStepPropertyType()
	 * @generated
	 */
	int LI_PROCESS_STEP_PROPERTY_TYPE = 120;

	/**
	 * The feature id for the '<em><b>LI Process Step</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_PROPERTY_TYPE__LI_PROCESS_STEP = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>LI Process Step Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>LI Process Step Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.LIProcessStepTypeImpl <em>LI Process Step Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.LIProcessStepTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getLIProcessStepType()
	 * @generated
	 */
	int LI_PROCESS_STEP_TYPE = 121;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_TYPE__DESCRIPTION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Rationale</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_TYPE__RATIONALE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Date Time</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_TYPE__DATE_TIME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Processor</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_TYPE__PROCESSOR = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_TYPE__SOURCE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>LI Process Step Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>LI Process Step Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_PROCESS_STEP_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.LISourcePropertyTypeImpl <em>LI Source Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.LISourcePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getLISourcePropertyType()
	 * @generated
	 */
	int LI_SOURCE_PROPERTY_TYPE = 122;

	/**
	 * The feature id for the '<em><b>LI Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_PROPERTY_TYPE__LI_SOURCE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>LI Source Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>LI Source Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.LISourceTypeImpl <em>LI Source Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.LISourceTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getLISourceType()
	 * @generated
	 */
	int LI_SOURCE_TYPE = 123;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_TYPE__DESCRIPTION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Scale Denominator</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_TYPE__SCALE_DENOMINATOR = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Source Reference System</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_TYPE__SOURCE_REFERENCE_SYSTEM = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Source Citation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_TYPE__SOURCE_CITATION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Source Extent</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_TYPE__SOURCE_EXTENT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Source Step</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_TYPE__SOURCE_STEP = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>LI Source Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>LI Source Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LI_SOURCE_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.LocalisedCharacterStringPropertyTypeImpl <em>Localised Character String Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.LocalisedCharacterStringPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getLocalisedCharacterStringPropertyType()
	 * @generated
	 */
	int LOCALISED_CHARACTER_STRING_PROPERTY_TYPE = 124;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCALISED_CHARACTER_STRING_PROPERTY_TYPE__ACTUATE = GCOPackage.OBJECT_REFERENCE_PROPERTY_TYPE__ACTUATE;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCALISED_CHARACTER_STRING_PROPERTY_TYPE__ARCROLE = GCOPackage.OBJECT_REFERENCE_PROPERTY_TYPE__ARCROLE;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCALISED_CHARACTER_STRING_PROPERTY_TYPE__HREF = GCOPackage.OBJECT_REFERENCE_PROPERTY_TYPE__HREF;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCALISED_CHARACTER_STRING_PROPERTY_TYPE__NIL_REASON = GCOPackage.OBJECT_REFERENCE_PROPERTY_TYPE__NIL_REASON;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCALISED_CHARACTER_STRING_PROPERTY_TYPE__ROLE = GCOPackage.OBJECT_REFERENCE_PROPERTY_TYPE__ROLE;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCALISED_CHARACTER_STRING_PROPERTY_TYPE__SHOW = GCOPackage.OBJECT_REFERENCE_PROPERTY_TYPE__SHOW;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCALISED_CHARACTER_STRING_PROPERTY_TYPE__TITLE = GCOPackage.OBJECT_REFERENCE_PROPERTY_TYPE__TITLE;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCALISED_CHARACTER_STRING_PROPERTY_TYPE__TYPE = GCOPackage.OBJECT_REFERENCE_PROPERTY_TYPE__TYPE;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCALISED_CHARACTER_STRING_PROPERTY_TYPE__UUIDREF = GCOPackage.OBJECT_REFERENCE_PROPERTY_TYPE__UUIDREF;

	/**
	 * The feature id for the '<em><b>Localised Character String</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCALISED_CHARACTER_STRING_PROPERTY_TYPE__LOCALISED_CHARACTER_STRING = GCOPackage.OBJECT_REFERENCE_PROPERTY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Localised Character String Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCALISED_CHARACTER_STRING_PROPERTY_TYPE_FEATURE_COUNT = GCOPackage.OBJECT_REFERENCE_PROPERTY_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Localised Character String Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCALISED_CHARACTER_STRING_PROPERTY_TYPE_OPERATION_COUNT = GCOPackage.OBJECT_REFERENCE_PROPERTY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.LocalisedCharacterStringTypeImpl <em>Localised Character String Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.LocalisedCharacterStringTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getLocalisedCharacterStringType()
	 * @generated
	 */
	int LOCALISED_CHARACTER_STRING_TYPE = 125;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCALISED_CHARACTER_STRING_TYPE__VALUE = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCALISED_CHARACTER_STRING_TYPE__ID = 1;

	/**
	 * The feature id for the '<em><b>Locale</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCALISED_CHARACTER_STRING_TYPE__LOCALE = 2;

	/**
	 * The number of structural features of the '<em>Localised Character String Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCALISED_CHARACTER_STRING_TYPE_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Localised Character String Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOCALISED_CHARACTER_STRING_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDAggregateInformationPropertyTypeImpl <em>MD Aggregate Information Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDAggregateInformationPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDAggregateInformationPropertyType()
	 * @generated
	 */
	int MD_AGGREGATE_INFORMATION_PROPERTY_TYPE = 126;

	/**
	 * The feature id for the '<em><b>MD Aggregate Information</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_PROPERTY_TYPE__MD_AGGREGATE_INFORMATION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Aggregate Information Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Aggregate Information Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDAggregateInformationTypeImpl <em>MD Aggregate Information Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDAggregateInformationTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDAggregateInformationType()
	 * @generated
	 */
	int MD_AGGREGATE_INFORMATION_TYPE = 127;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Aggregate Data Set Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_TYPE__AGGREGATE_DATA_SET_NAME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Aggregate Data Set Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_TYPE__AGGREGATE_DATA_SET_IDENTIFIER = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Association Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_TYPE__ASSOCIATION_TYPE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Initiative Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_TYPE__INITIATIVE_TYPE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>MD Aggregate Information Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>MD Aggregate Information Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_AGGREGATE_INFORMATION_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDApplicationSchemaInformationPropertyTypeImpl <em>MD Application Schema Information Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDApplicationSchemaInformationPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDApplicationSchemaInformationPropertyType()
	 * @generated
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_PROPERTY_TYPE = 128;

	/**
	 * The feature id for the '<em><b>MD Application Schema Information</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_PROPERTY_TYPE__MD_APPLICATION_SCHEMA_INFORMATION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Application Schema Information Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Application Schema Information Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDApplicationSchemaInformationTypeImpl <em>MD Application Schema Information Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDApplicationSchemaInformationTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDApplicationSchemaInformationType()
	 * @generated
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_TYPE = 129;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_TYPE__NAME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Schema Language</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_TYPE__SCHEMA_LANGUAGE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Constraint Language</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_TYPE__CONSTRAINT_LANGUAGE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Schema Ascii</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_TYPE__SCHEMA_ASCII = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Graphics File</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_TYPE__GRAPHICS_FILE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Software Development File</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_TYPE__SOFTWARE_DEVELOPMENT_FILE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Software Development File Format</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_TYPE__SOFTWARE_DEVELOPMENT_FILE_FORMAT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>MD Application Schema Information Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of operations of the '<em>MD Application Schema Information Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_APPLICATION_SCHEMA_INFORMATION_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDBandPropertyTypeImpl <em>MD Band Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDBandPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDBandPropertyType()
	 * @generated
	 */
	int MD_BAND_PROPERTY_TYPE = 130;

	/**
	 * The feature id for the '<em><b>MD Band</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_PROPERTY_TYPE__MD_BAND = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Band Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Band Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDRangeDimensionTypeImpl <em>MD Range Dimension Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDRangeDimensionTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDRangeDimensionType()
	 * @generated
	 */
	int MD_RANGE_DIMENSION_TYPE = 199;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Sequence Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_TYPE__SEQUENCE_IDENTIFIER = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Descriptor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_TYPE__DESCRIPTOR = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>MD Range Dimension Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>MD Range Dimension Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDBandTypeImpl <em>MD Band Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDBandTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDBandType()
	 * @generated
	 */
	int MD_BAND_TYPE = 131;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_TYPE__ID = MD_RANGE_DIMENSION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_TYPE__UUID = MD_RANGE_DIMENSION_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Sequence Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_TYPE__SEQUENCE_IDENTIFIER = MD_RANGE_DIMENSION_TYPE__SEQUENCE_IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Descriptor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_TYPE__DESCRIPTOR = MD_RANGE_DIMENSION_TYPE__DESCRIPTOR;

	/**
	 * The feature id for the '<em><b>Max Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_TYPE__MAX_VALUE = MD_RANGE_DIMENSION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Min Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_TYPE__MIN_VALUE = MD_RANGE_DIMENSION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Units</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_TYPE__UNITS = MD_RANGE_DIMENSION_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Peak Response</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_TYPE__PEAK_RESPONSE = MD_RANGE_DIMENSION_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Bits Per Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_TYPE__BITS_PER_VALUE = MD_RANGE_DIMENSION_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Tone Gradation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_TYPE__TONE_GRADATION = MD_RANGE_DIMENSION_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Scale Factor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_TYPE__SCALE_FACTOR = MD_RANGE_DIMENSION_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Offset</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_TYPE__OFFSET = MD_RANGE_DIMENSION_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>MD Band Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_TYPE_FEATURE_COUNT = MD_RANGE_DIMENSION_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>MD Band Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BAND_TYPE_OPERATION_COUNT = MD_RANGE_DIMENSION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDBrowseGraphicPropertyTypeImpl <em>MD Browse Graphic Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDBrowseGraphicPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDBrowseGraphicPropertyType()
	 * @generated
	 */
	int MD_BROWSE_GRAPHIC_PROPERTY_TYPE = 132;

	/**
	 * The feature id for the '<em><b>MD Browse Graphic</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_PROPERTY_TYPE__MD_BROWSE_GRAPHIC = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Browse Graphic Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Browse Graphic Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDBrowseGraphicTypeImpl <em>MD Browse Graphic Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDBrowseGraphicTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDBrowseGraphicType()
	 * @generated
	 */
	int MD_BROWSE_GRAPHIC_TYPE = 133;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>File Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_TYPE__FILE_NAME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>File Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_TYPE__FILE_DESCRIPTION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>File Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_TYPE__FILE_TYPE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>MD Browse Graphic Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>MD Browse Graphic Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_BROWSE_GRAPHIC_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDCellGeometryCodePropertyTypeImpl <em>MD Cell Geometry Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDCellGeometryCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDCellGeometryCodePropertyType()
	 * @generated
	 */
	int MD_CELL_GEOMETRY_CODE_PROPERTY_TYPE = 134;

	/**
	 * The feature id for the '<em><b>MD Cell Geometry Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CELL_GEOMETRY_CODE_PROPERTY_TYPE__MD_CELL_GEOMETRY_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CELL_GEOMETRY_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Cell Geometry Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CELL_GEOMETRY_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Cell Geometry Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CELL_GEOMETRY_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDCharacterSetCodePropertyTypeImpl <em>MD Character Set Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDCharacterSetCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDCharacterSetCodePropertyType()
	 * @generated
	 */
	int MD_CHARACTER_SET_CODE_PROPERTY_TYPE = 135;

	/**
	 * The feature id for the '<em><b>MD Character Set Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CHARACTER_SET_CODE_PROPERTY_TYPE__MD_CHARACTER_SET_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CHARACTER_SET_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Character Set Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CHARACTER_SET_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Character Set Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CHARACTER_SET_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDClassificationCodePropertyTypeImpl <em>MD Classification Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDClassificationCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDClassificationCodePropertyType()
	 * @generated
	 */
	int MD_CLASSIFICATION_CODE_PROPERTY_TYPE = 136;

	/**
	 * The feature id for the '<em><b>MD Classification Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CLASSIFICATION_CODE_PROPERTY_TYPE__MD_CLASSIFICATION_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CLASSIFICATION_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Classification Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CLASSIFICATION_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Classification Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CLASSIFICATION_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDConstraintsPropertyTypeImpl <em>MD Constraints Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDConstraintsPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDConstraintsPropertyType()
	 * @generated
	 */
	int MD_CONSTRAINTS_PROPERTY_TYPE = 137;

	/**
	 * The feature id for the '<em><b>MD Constraints Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONSTRAINTS_PROPERTY_TYPE__MD_CONSTRAINTS_GROUP = 0;

	/**
	 * The feature id for the '<em><b>MD Constraints</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONSTRAINTS_PROPERTY_TYPE__MD_CONSTRAINTS = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONSTRAINTS_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONSTRAINTS_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONSTRAINTS_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONSTRAINTS_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONSTRAINTS_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONSTRAINTS_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONSTRAINTS_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONSTRAINTS_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONSTRAINTS_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>MD Constraints Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONSTRAINTS_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>MD Constraints Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONSTRAINTS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDConstraintsTypeImpl <em>MD Constraints Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDConstraintsTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDConstraintsType()
	 * @generated
	 */
	int MD_CONSTRAINTS_TYPE = 138;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONSTRAINTS_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONSTRAINTS_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Use Limitation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONSTRAINTS_TYPE__USE_LIMITATION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>MD Constraints Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONSTRAINTS_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>MD Constraints Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONSTRAINTS_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDContentInformationPropertyTypeImpl <em>MD Content Information Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDContentInformationPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDContentInformationPropertyType()
	 * @generated
	 */
	int MD_CONTENT_INFORMATION_PROPERTY_TYPE = 139;

	/**
	 * The feature id for the '<em><b>Abstract MD Content Information Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONTENT_INFORMATION_PROPERTY_TYPE__ABSTRACT_MD_CONTENT_INFORMATION_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract MD Content Information</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONTENT_INFORMATION_PROPERTY_TYPE__ABSTRACT_MD_CONTENT_INFORMATION = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONTENT_INFORMATION_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONTENT_INFORMATION_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONTENT_INFORMATION_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONTENT_INFORMATION_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONTENT_INFORMATION_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONTENT_INFORMATION_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONTENT_INFORMATION_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONTENT_INFORMATION_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONTENT_INFORMATION_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>MD Content Information Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONTENT_INFORMATION_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>MD Content Information Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_CONTENT_INFORMATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDCoverageContentTypeCodePropertyTypeImpl <em>MD Coverage Content Type Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDCoverageContentTypeCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDCoverageContentTypeCodePropertyType()
	 * @generated
	 */
	int MD_COVERAGE_CONTENT_TYPE_CODE_PROPERTY_TYPE = 140;

	/**
	 * The feature id for the '<em><b>MD Coverage Content Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_CONTENT_TYPE_CODE_PROPERTY_TYPE__MD_COVERAGE_CONTENT_TYPE_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_CONTENT_TYPE_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Coverage Content Type Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_CONTENT_TYPE_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Coverage Content Type Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_CONTENT_TYPE_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDCoverageDescriptionPropertyTypeImpl <em>MD Coverage Description Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDCoverageDescriptionPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDCoverageDescriptionPropertyType()
	 * @generated
	 */
	int MD_COVERAGE_DESCRIPTION_PROPERTY_TYPE = 141;

	/**
	 * The feature id for the '<em><b>MD Coverage Description Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_PROPERTY_TYPE__MD_COVERAGE_DESCRIPTION_GROUP = 0;

	/**
	 * The feature id for the '<em><b>MD Coverage Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_PROPERTY_TYPE__MD_COVERAGE_DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>MD Coverage Description Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>MD Coverage Description Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDCoverageDescriptionTypeImpl <em>MD Coverage Description Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDCoverageDescriptionTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDCoverageDescriptionType()
	 * @generated
	 */
	int MD_COVERAGE_DESCRIPTION_TYPE = 142;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_TYPE__ID = ABSTRACT_MD_CONTENT_INFORMATION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_TYPE__UUID = ABSTRACT_MD_CONTENT_INFORMATION_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Attribute Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_TYPE__ATTRIBUTE_DESCRIPTION = ABSTRACT_MD_CONTENT_INFORMATION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Content Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_TYPE__CONTENT_TYPE = ABSTRACT_MD_CONTENT_INFORMATION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Dimension</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_TYPE__DIMENSION = ABSTRACT_MD_CONTENT_INFORMATION_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>MD Coverage Description Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_TYPE_FEATURE_COUNT = ABSTRACT_MD_CONTENT_INFORMATION_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>MD Coverage Description Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_COVERAGE_DESCRIPTION_TYPE_OPERATION_COUNT = ABSTRACT_MD_CONTENT_INFORMATION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDDataIdentificationPropertyTypeImpl <em>MD Data Identification Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDDataIdentificationPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDDataIdentificationPropertyType()
	 * @generated
	 */
	int MD_DATA_IDENTIFICATION_PROPERTY_TYPE = 143;

	/**
	 * The feature id for the '<em><b>MD Data Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_PROPERTY_TYPE__MD_DATA_IDENTIFICATION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Data Identification Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Data Identification Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDDataIdentificationTypeImpl <em>MD Data Identification Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDDataIdentificationTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDDataIdentificationType()
	 * @generated
	 */
	int MD_DATA_IDENTIFICATION_TYPE = 144;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__ID = ABSTRACT_MD_IDENTIFICATION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__UUID = ABSTRACT_MD_IDENTIFICATION_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Citation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__CITATION = ABSTRACT_MD_IDENTIFICATION_TYPE__CITATION;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__ABSTRACT = ABSTRACT_MD_IDENTIFICATION_TYPE__ABSTRACT;

	/**
	 * The feature id for the '<em><b>Purpose</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__PURPOSE = ABSTRACT_MD_IDENTIFICATION_TYPE__PURPOSE;

	/**
	 * The feature id for the '<em><b>Credit</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__CREDIT = ABSTRACT_MD_IDENTIFICATION_TYPE__CREDIT;

	/**
	 * The feature id for the '<em><b>Status</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__STATUS = ABSTRACT_MD_IDENTIFICATION_TYPE__STATUS;

	/**
	 * The feature id for the '<em><b>Point Of Contact</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__POINT_OF_CONTACT = ABSTRACT_MD_IDENTIFICATION_TYPE__POINT_OF_CONTACT;

	/**
	 * The feature id for the '<em><b>Resource Maintenance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__RESOURCE_MAINTENANCE = ABSTRACT_MD_IDENTIFICATION_TYPE__RESOURCE_MAINTENANCE;

	/**
	 * The feature id for the '<em><b>Graphic Overview</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__GRAPHIC_OVERVIEW = ABSTRACT_MD_IDENTIFICATION_TYPE__GRAPHIC_OVERVIEW;

	/**
	 * The feature id for the '<em><b>Resource Format</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__RESOURCE_FORMAT = ABSTRACT_MD_IDENTIFICATION_TYPE__RESOURCE_FORMAT;

	/**
	 * The feature id for the '<em><b>Descriptive Keywords</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__DESCRIPTIVE_KEYWORDS = ABSTRACT_MD_IDENTIFICATION_TYPE__DESCRIPTIVE_KEYWORDS;

	/**
	 * The feature id for the '<em><b>Resource Specific Usage</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__RESOURCE_SPECIFIC_USAGE = ABSTRACT_MD_IDENTIFICATION_TYPE__RESOURCE_SPECIFIC_USAGE;

	/**
	 * The feature id for the '<em><b>Resource Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__RESOURCE_CONSTRAINTS = ABSTRACT_MD_IDENTIFICATION_TYPE__RESOURCE_CONSTRAINTS;

	/**
	 * The feature id for the '<em><b>Aggregation Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__AGGREGATION_INFO = ABSTRACT_MD_IDENTIFICATION_TYPE__AGGREGATION_INFO;

	/**
	 * The feature id for the '<em><b>Spatial Representation Type</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__SPATIAL_REPRESENTATION_TYPE = ABSTRACT_MD_IDENTIFICATION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Spatial Resolution</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__SPATIAL_RESOLUTION = ABSTRACT_MD_IDENTIFICATION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Language</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__LANGUAGE = ABSTRACT_MD_IDENTIFICATION_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Character Set</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__CHARACTER_SET = ABSTRACT_MD_IDENTIFICATION_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Topic Category</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__TOPIC_CATEGORY = ABSTRACT_MD_IDENTIFICATION_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Environment Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__ENVIRONMENT_DESCRIPTION = ABSTRACT_MD_IDENTIFICATION_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Extent</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__EXTENT = ABSTRACT_MD_IDENTIFICATION_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Supplemental Information</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE__SUPPLEMENTAL_INFORMATION = ABSTRACT_MD_IDENTIFICATION_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>MD Data Identification Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE_FEATURE_COUNT = ABSTRACT_MD_IDENTIFICATION_TYPE_FEATURE_COUNT + 8;

	/**
	 * The number of operations of the '<em>MD Data Identification Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATA_IDENTIFICATION_TYPE_OPERATION_COUNT = ABSTRACT_MD_IDENTIFICATION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDDatatypeCodePropertyTypeImpl <em>MD Datatype Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDDatatypeCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDDatatypeCodePropertyType()
	 * @generated
	 */
	int MD_DATATYPE_CODE_PROPERTY_TYPE = 145;

	/**
	 * The feature id for the '<em><b>MD Datatype Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATATYPE_CODE_PROPERTY_TYPE__MD_DATATYPE_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATATYPE_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Datatype Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATATYPE_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Datatype Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DATATYPE_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDDigitalTransferOptionsPropertyTypeImpl <em>MD Digital Transfer Options Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDDigitalTransferOptionsPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDDigitalTransferOptionsPropertyType()
	 * @generated
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_PROPERTY_TYPE = 146;

	/**
	 * The feature id for the '<em><b>MD Digital Transfer Options</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_PROPERTY_TYPE__MD_DIGITAL_TRANSFER_OPTIONS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Digital Transfer Options Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Digital Transfer Options Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDDigitalTransferOptionsTypeImpl <em>MD Digital Transfer Options Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDDigitalTransferOptionsTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDDigitalTransferOptionsType()
	 * @generated
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_TYPE = 147;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Units Of Distribution</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_TYPE__UNITS_OF_DISTRIBUTION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Transfer Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_TYPE__TRANSFER_SIZE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>On Line</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_TYPE__ON_LINE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Off Line</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_TYPE__OFF_LINE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>MD Digital Transfer Options Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>MD Digital Transfer Options Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIGITAL_TRANSFER_OPTIONS_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDDimensionNameTypeCodePropertyTypeImpl <em>MD Dimension Name Type Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDDimensionNameTypeCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDDimensionNameTypeCodePropertyType()
	 * @generated
	 */
	int MD_DIMENSION_NAME_TYPE_CODE_PROPERTY_TYPE = 148;

	/**
	 * The feature id for the '<em><b>MD Dimension Name Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_NAME_TYPE_CODE_PROPERTY_TYPE__MD_DIMENSION_NAME_TYPE_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_NAME_TYPE_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Dimension Name Type Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_NAME_TYPE_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Dimension Name Type Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_NAME_TYPE_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDDimensionPropertyTypeImpl <em>MD Dimension Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDDimensionPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDDimensionPropertyType()
	 * @generated
	 */
	int MD_DIMENSION_PROPERTY_TYPE = 149;

	/**
	 * The feature id for the '<em><b>MD Dimension</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_PROPERTY_TYPE__MD_DIMENSION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Dimension Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Dimension Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDDimensionTypeImpl <em>MD Dimension Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDDimensionTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDDimensionType()
	 * @generated
	 */
	int MD_DIMENSION_TYPE = 150;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Dimension Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_TYPE__DIMENSION_NAME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Dimension Size</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_TYPE__DIMENSION_SIZE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Resolution</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_TYPE__RESOLUTION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>MD Dimension Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>MD Dimension Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DIMENSION_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDDistributionPropertyTypeImpl <em>MD Distribution Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDDistributionPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDDistributionPropertyType()
	 * @generated
	 */
	int MD_DISTRIBUTION_PROPERTY_TYPE = 151;

	/**
	 * The feature id for the '<em><b>MD Distribution</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_PROPERTY_TYPE__MD_DISTRIBUTION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Distribution Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Distribution Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDDistributionTypeImpl <em>MD Distribution Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDDistributionTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDDistributionType()
	 * @generated
	 */
	int MD_DISTRIBUTION_TYPE = 152;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Distribution Format</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_TYPE__DISTRIBUTION_FORMAT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Distributor</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_TYPE__DISTRIBUTOR = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Transfer Options</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_TYPE__TRANSFER_OPTIONS = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>MD Distribution Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>MD Distribution Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDDistributionUnitsPropertyTypeImpl <em>MD Distribution Units Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDDistributionUnitsPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDDistributionUnitsPropertyType()
	 * @generated
	 */
	int MD_DISTRIBUTION_UNITS_PROPERTY_TYPE = 153;

	/**
	 * The feature id for the '<em><b>MD Distribution Units</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_UNITS_PROPERTY_TYPE__MD_DISTRIBUTION_UNITS = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_UNITS_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Distribution Units Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_UNITS_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Distribution Units Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTION_UNITS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDDistributorPropertyTypeImpl <em>MD Distributor Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDDistributorPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDDistributorPropertyType()
	 * @generated
	 */
	int MD_DISTRIBUTOR_PROPERTY_TYPE = 154;

	/**
	 * The feature id for the '<em><b>MD Distributor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_PROPERTY_TYPE__MD_DISTRIBUTOR = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Distributor Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Distributor Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDDistributorTypeImpl <em>MD Distributor Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDDistributorTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDDistributorType()
	 * @generated
	 */
	int MD_DISTRIBUTOR_TYPE = 155;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Distributor Contact</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_TYPE__DISTRIBUTOR_CONTACT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Distribution Order Process</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_TYPE__DISTRIBUTION_ORDER_PROCESS = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Distributor Format</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_TYPE__DISTRIBUTOR_FORMAT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Distributor Transfer Options</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_TYPE__DISTRIBUTOR_TRANSFER_OPTIONS = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>MD Distributor Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>MD Distributor Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_DISTRIBUTOR_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDExtendedElementInformationPropertyTypeImpl <em>MD Extended Element Information Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDExtendedElementInformationPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDExtendedElementInformationPropertyType()
	 * @generated
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_PROPERTY_TYPE = 156;

	/**
	 * The feature id for the '<em><b>MD Extended Element Information</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_PROPERTY_TYPE__MD_EXTENDED_ELEMENT_INFORMATION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Extended Element Information Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Extended Element Information Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDExtendedElementInformationTypeImpl <em>MD Extended Element Information Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDExtendedElementInformationTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDExtendedElementInformationType()
	 * @generated
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_TYPE = 157;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_TYPE__NAME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Short Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_TYPE__SHORT_NAME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Domain Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_TYPE__DOMAIN_CODE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_TYPE__DEFINITION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Obligation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_TYPE__OBLIGATION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_TYPE__CONDITION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Data Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_TYPE__DATA_TYPE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Maximum Occurrence</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_TYPE__MAXIMUM_OCCURRENCE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Domain Value</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_TYPE__DOMAIN_VALUE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Parent Entity</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_TYPE__PARENT_ENTITY = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Rule</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_TYPE__RULE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Rationale</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_TYPE__RATIONALE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_TYPE__SOURCE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 12;

	/**
	 * The number of structural features of the '<em>MD Extended Element Information Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 13;

	/**
	 * The number of operations of the '<em>MD Extended Element Information Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_EXTENDED_ELEMENT_INFORMATION_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDFeatureCatalogueDescriptionPropertyTypeImpl <em>MD Feature Catalogue Description Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDFeatureCatalogueDescriptionPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDFeatureCatalogueDescriptionPropertyType()
	 * @generated
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_PROPERTY_TYPE = 158;

	/**
	 * The feature id for the '<em><b>MD Feature Catalogue Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_PROPERTY_TYPE__MD_FEATURE_CATALOGUE_DESCRIPTION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Feature Catalogue Description Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Feature Catalogue Description Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDFeatureCatalogueDescriptionTypeImpl <em>MD Feature Catalogue Description Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDFeatureCatalogueDescriptionTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDFeatureCatalogueDescriptionType()
	 * @generated
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_TYPE = 159;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_TYPE__ID = ABSTRACT_MD_CONTENT_INFORMATION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_TYPE__UUID = ABSTRACT_MD_CONTENT_INFORMATION_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Compliance Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_TYPE__COMPLIANCE_CODE = ABSTRACT_MD_CONTENT_INFORMATION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Language</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_TYPE__LANGUAGE = ABSTRACT_MD_CONTENT_INFORMATION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Included With Dataset</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_TYPE__INCLUDED_WITH_DATASET = ABSTRACT_MD_CONTENT_INFORMATION_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Feature Types</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_TYPE__FEATURE_TYPES = ABSTRACT_MD_CONTENT_INFORMATION_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Feature Catalogue Citation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_TYPE__FEATURE_CATALOGUE_CITATION = ABSTRACT_MD_CONTENT_INFORMATION_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>MD Feature Catalogue Description Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_TYPE_FEATURE_COUNT = ABSTRACT_MD_CONTENT_INFORMATION_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>MD Feature Catalogue Description Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FEATURE_CATALOGUE_DESCRIPTION_TYPE_OPERATION_COUNT = ABSTRACT_MD_CONTENT_INFORMATION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDFormatPropertyTypeImpl <em>MD Format Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDFormatPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDFormatPropertyType()
	 * @generated
	 */
	int MD_FORMAT_PROPERTY_TYPE = 160;

	/**
	 * The feature id for the '<em><b>MD Format</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_PROPERTY_TYPE__MD_FORMAT = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Format Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Format Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDFormatTypeImpl <em>MD Format Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDFormatTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDFormatType()
	 * @generated
	 */
	int MD_FORMAT_TYPE = 161;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_TYPE__NAME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Version</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_TYPE__VERSION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Amendment Number</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_TYPE__AMENDMENT_NUMBER = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Specification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_TYPE__SPECIFICATION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>File Decompression Technique</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_TYPE__FILE_DECOMPRESSION_TECHNIQUE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Format Distributor</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_TYPE__FORMAT_DISTRIBUTOR = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>MD Format Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>MD Format Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_FORMAT_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDGeometricObjectsPropertyTypeImpl <em>MD Geometric Objects Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDGeometricObjectsPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDGeometricObjectsPropertyType()
	 * @generated
	 */
	int MD_GEOMETRIC_OBJECTS_PROPERTY_TYPE = 162;

	/**
	 * The feature id for the '<em><b>MD Geometric Objects</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECTS_PROPERTY_TYPE__MD_GEOMETRIC_OBJECTS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECTS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECTS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECTS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECTS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECTS_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECTS_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECTS_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECTS_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECTS_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Geometric Objects Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECTS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Geometric Objects Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECTS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDGeometricObjectsTypeImpl <em>MD Geometric Objects Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDGeometricObjectsTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDGeometricObjectsType()
	 * @generated
	 */
	int MD_GEOMETRIC_OBJECTS_TYPE = 163;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECTS_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECTS_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Geometric Object Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECTS_TYPE__GEOMETRIC_OBJECT_TYPE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Geometric Object Count</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECTS_TYPE__GEOMETRIC_OBJECT_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>MD Geometric Objects Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECTS_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>MD Geometric Objects Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECTS_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDGeometricObjectTypeCodePropertyTypeImpl <em>MD Geometric Object Type Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDGeometricObjectTypeCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDGeometricObjectTypeCodePropertyType()
	 * @generated
	 */
	int MD_GEOMETRIC_OBJECT_TYPE_CODE_PROPERTY_TYPE = 164;

	/**
	 * The feature id for the '<em><b>MD Geometric Object Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECT_TYPE_CODE_PROPERTY_TYPE__MD_GEOMETRIC_OBJECT_TYPE_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECT_TYPE_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Geometric Object Type Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECT_TYPE_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Geometric Object Type Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOMETRIC_OBJECT_TYPE_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDGeorectifiedPropertyTypeImpl <em>MD Georectified Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDGeorectifiedPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDGeorectifiedPropertyType()
	 * @generated
	 */
	int MD_GEORECTIFIED_PROPERTY_TYPE = 165;

	/**
	 * The feature id for the '<em><b>MD Georectified</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_PROPERTY_TYPE__MD_GEORECTIFIED = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Georectified Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Georectified Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDGridSpatialRepresentationTypeImpl <em>MD Grid Spatial Representation Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDGridSpatialRepresentationTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDGridSpatialRepresentationType()
	 * @generated
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_TYPE = 170;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_TYPE__ID = ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_TYPE__UUID = ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Number Of Dimensions</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_TYPE__NUMBER_OF_DIMENSIONS = ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Axis Dimension Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_TYPE__AXIS_DIMENSION_PROPERTIES = ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Cell Geometry</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_TYPE__CELL_GEOMETRY = ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Transformation Parameter Availability</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_TYPE__TRANSFORMATION_PARAMETER_AVAILABILITY = ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>MD Grid Spatial Representation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT = ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>MD Grid Spatial Representation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_TYPE_OPERATION_COUNT = ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDGeorectifiedTypeImpl <em>MD Georectified Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDGeorectifiedTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDGeorectifiedType()
	 * @generated
	 */
	int MD_GEORECTIFIED_TYPE = 166;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_TYPE__ID = MD_GRID_SPATIAL_REPRESENTATION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_TYPE__UUID = MD_GRID_SPATIAL_REPRESENTATION_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Number Of Dimensions</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_TYPE__NUMBER_OF_DIMENSIONS = MD_GRID_SPATIAL_REPRESENTATION_TYPE__NUMBER_OF_DIMENSIONS;

	/**
	 * The feature id for the '<em><b>Axis Dimension Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_TYPE__AXIS_DIMENSION_PROPERTIES = MD_GRID_SPATIAL_REPRESENTATION_TYPE__AXIS_DIMENSION_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Cell Geometry</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_TYPE__CELL_GEOMETRY = MD_GRID_SPATIAL_REPRESENTATION_TYPE__CELL_GEOMETRY;

	/**
	 * The feature id for the '<em><b>Transformation Parameter Availability</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_TYPE__TRANSFORMATION_PARAMETER_AVAILABILITY = MD_GRID_SPATIAL_REPRESENTATION_TYPE__TRANSFORMATION_PARAMETER_AVAILABILITY;

	/**
	 * The feature id for the '<em><b>Check Point Availability</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_TYPE__CHECK_POINT_AVAILABILITY = MD_GRID_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Check Point Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_TYPE__CHECK_POINT_DESCRIPTION = MD_GRID_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Corner Points</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_TYPE__CORNER_POINTS = MD_GRID_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Center Point</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_TYPE__CENTER_POINT = MD_GRID_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Point In Pixel</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_TYPE__POINT_IN_PIXEL = MD_GRID_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Transformation Dimension Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_TYPE__TRANSFORMATION_DIMENSION_DESCRIPTION = MD_GRID_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Transformation Dimension Mapping</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_TYPE__TRANSFORMATION_DIMENSION_MAPPING = MD_GRID_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>MD Georectified Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_TYPE_FEATURE_COUNT = MD_GRID_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of operations of the '<em>MD Georectified Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEORECTIFIED_TYPE_OPERATION_COUNT = MD_GRID_SPATIAL_REPRESENTATION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDGeoreferenceablePropertyTypeImpl <em>MD Georeferenceable Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDGeoreferenceablePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDGeoreferenceablePropertyType()
	 * @generated
	 */
	int MD_GEOREFERENCEABLE_PROPERTY_TYPE = 167;

	/**
	 * The feature id for the '<em><b>MD Georeferenceable</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_PROPERTY_TYPE__MD_GEOREFERENCEABLE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Georeferenceable Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Georeferenceable Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDGeoreferenceableTypeImpl <em>MD Georeferenceable Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDGeoreferenceableTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDGeoreferenceableType()
	 * @generated
	 */
	int MD_GEOREFERENCEABLE_TYPE = 168;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_TYPE__ID = MD_GRID_SPATIAL_REPRESENTATION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_TYPE__UUID = MD_GRID_SPATIAL_REPRESENTATION_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Number Of Dimensions</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_TYPE__NUMBER_OF_DIMENSIONS = MD_GRID_SPATIAL_REPRESENTATION_TYPE__NUMBER_OF_DIMENSIONS;

	/**
	 * The feature id for the '<em><b>Axis Dimension Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_TYPE__AXIS_DIMENSION_PROPERTIES = MD_GRID_SPATIAL_REPRESENTATION_TYPE__AXIS_DIMENSION_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Cell Geometry</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_TYPE__CELL_GEOMETRY = MD_GRID_SPATIAL_REPRESENTATION_TYPE__CELL_GEOMETRY;

	/**
	 * The feature id for the '<em><b>Transformation Parameter Availability</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_TYPE__TRANSFORMATION_PARAMETER_AVAILABILITY = MD_GRID_SPATIAL_REPRESENTATION_TYPE__TRANSFORMATION_PARAMETER_AVAILABILITY;

	/**
	 * The feature id for the '<em><b>Control Point Availability</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_TYPE__CONTROL_POINT_AVAILABILITY = MD_GRID_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Orientation Parameter Availability</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_TYPE__ORIENTATION_PARAMETER_AVAILABILITY = MD_GRID_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Orientation Parameter Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_TYPE__ORIENTATION_PARAMETER_DESCRIPTION = MD_GRID_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Georeferenced Parameters</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_TYPE__GEOREFERENCED_PARAMETERS = MD_GRID_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Parameter Citation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_TYPE__PARAMETER_CITATION = MD_GRID_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>MD Georeferenceable Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_TYPE_FEATURE_COUNT = MD_GRID_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>MD Georeferenceable Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GEOREFERENCEABLE_TYPE_OPERATION_COUNT = MD_GRID_SPATIAL_REPRESENTATION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDGridSpatialRepresentationPropertyTypeImpl <em>MD Grid Spatial Representation Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDGridSpatialRepresentationPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDGridSpatialRepresentationPropertyType()
	 * @generated
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_PROPERTY_TYPE = 169;

	/**
	 * The feature id for the '<em><b>MD Grid Spatial Representation Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_PROPERTY_TYPE__MD_GRID_SPATIAL_REPRESENTATION_GROUP = 0;

	/**
	 * The feature id for the '<em><b>MD Grid Spatial Representation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_PROPERTY_TYPE__MD_GRID_SPATIAL_REPRESENTATION = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>MD Grid Spatial Representation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>MD Grid Spatial Representation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_GRID_SPATIAL_REPRESENTATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDIdentificationPropertyTypeImpl <em>MD Identification Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDIdentificationPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDIdentificationPropertyType()
	 * @generated
	 */
	int MD_IDENTIFICATION_PROPERTY_TYPE = 171;

	/**
	 * The feature id for the '<em><b>Abstract MD Identification Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFICATION_PROPERTY_TYPE__ABSTRACT_MD_IDENTIFICATION_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract MD Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFICATION_PROPERTY_TYPE__ABSTRACT_MD_IDENTIFICATION = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFICATION_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFICATION_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFICATION_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFICATION_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFICATION_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFICATION_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFICATION_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFICATION_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFICATION_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>MD Identification Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFICATION_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>MD Identification Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFICATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDIdentifierPropertyTypeImpl <em>MD Identifier Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDIdentifierPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDIdentifierPropertyType()
	 * @generated
	 */
	int MD_IDENTIFIER_PROPERTY_TYPE = 172;

	/**
	 * The feature id for the '<em><b>MD Identifier Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_PROPERTY_TYPE__MD_IDENTIFIER_GROUP = 0;

	/**
	 * The feature id for the '<em><b>MD Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_PROPERTY_TYPE__MD_IDENTIFIER = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>MD Identifier Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>MD Identifier Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDIdentifierTypeImpl <em>MD Identifier Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDIdentifierTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDIdentifierType()
	 * @generated
	 */
	int MD_IDENTIFIER_TYPE = 173;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Authority</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_TYPE__AUTHORITY = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_TYPE__CODE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>MD Identifier Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>MD Identifier Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IDENTIFIER_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDImageDescriptionPropertyTypeImpl <em>MD Image Description Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDImageDescriptionPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDImageDescriptionPropertyType()
	 * @generated
	 */
	int MD_IMAGE_DESCRIPTION_PROPERTY_TYPE = 174;

	/**
	 * The feature id for the '<em><b>MD Image Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_PROPERTY_TYPE__MD_IMAGE_DESCRIPTION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Image Description Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Image Description Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDImageDescriptionTypeImpl <em>MD Image Description Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDImageDescriptionTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDImageDescriptionType()
	 * @generated
	 */
	int MD_IMAGE_DESCRIPTION_TYPE = 175;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE__ID = MD_COVERAGE_DESCRIPTION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE__UUID = MD_COVERAGE_DESCRIPTION_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Attribute Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE__ATTRIBUTE_DESCRIPTION = MD_COVERAGE_DESCRIPTION_TYPE__ATTRIBUTE_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Content Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE__CONTENT_TYPE = MD_COVERAGE_DESCRIPTION_TYPE__CONTENT_TYPE;

	/**
	 * The feature id for the '<em><b>Dimension</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE__DIMENSION = MD_COVERAGE_DESCRIPTION_TYPE__DIMENSION;

	/**
	 * The feature id for the '<em><b>Illumination Elevation Angle</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE__ILLUMINATION_ELEVATION_ANGLE = MD_COVERAGE_DESCRIPTION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Illumination Azimuth Angle</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE__ILLUMINATION_AZIMUTH_ANGLE = MD_COVERAGE_DESCRIPTION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Imaging Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE__IMAGING_CONDITION = MD_COVERAGE_DESCRIPTION_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Image Quality Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE__IMAGE_QUALITY_CODE = MD_COVERAGE_DESCRIPTION_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Cloud Cover Percentage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE__CLOUD_COVER_PERCENTAGE = MD_COVERAGE_DESCRIPTION_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Processing Level Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE__PROCESSING_LEVEL_CODE = MD_COVERAGE_DESCRIPTION_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Compression Generation Quantity</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE__COMPRESSION_GENERATION_QUANTITY = MD_COVERAGE_DESCRIPTION_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Triangulation Indicator</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE__TRIANGULATION_INDICATOR = MD_COVERAGE_DESCRIPTION_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Radiometric Calibration Data Availability</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE__RADIOMETRIC_CALIBRATION_DATA_AVAILABILITY = MD_COVERAGE_DESCRIPTION_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Camera Calibration Information Availability</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE__CAMERA_CALIBRATION_INFORMATION_AVAILABILITY = MD_COVERAGE_DESCRIPTION_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Film Distortion Information Availability</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE__FILM_DISTORTION_INFORMATION_AVAILABILITY = MD_COVERAGE_DESCRIPTION_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Lens Distortion Information Availability</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE__LENS_DISTORTION_INFORMATION_AVAILABILITY = MD_COVERAGE_DESCRIPTION_TYPE_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>MD Image Description Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE_FEATURE_COUNT = MD_COVERAGE_DESCRIPTION_TYPE_FEATURE_COUNT + 12;

	/**
	 * The number of operations of the '<em>MD Image Description Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGE_DESCRIPTION_TYPE_OPERATION_COUNT = MD_COVERAGE_DESCRIPTION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDImagingConditionCodePropertyTypeImpl <em>MD Imaging Condition Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDImagingConditionCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDImagingConditionCodePropertyType()
	 * @generated
	 */
	int MD_IMAGING_CONDITION_CODE_PROPERTY_TYPE = 176;

	/**
	 * The feature id for the '<em><b>MD Imaging Condition Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGING_CONDITION_CODE_PROPERTY_TYPE__MD_IMAGING_CONDITION_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGING_CONDITION_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Imaging Condition Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGING_CONDITION_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Imaging Condition Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_IMAGING_CONDITION_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDKeywordsPropertyTypeImpl <em>MD Keywords Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDKeywordsPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDKeywordsPropertyType()
	 * @generated
	 */
	int MD_KEYWORDS_PROPERTY_TYPE = 177;

	/**
	 * The feature id for the '<em><b>MD Keywords</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_PROPERTY_TYPE__MD_KEYWORDS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Keywords Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Keywords Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDKeywordsTypeImpl <em>MD Keywords Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDKeywordsTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDKeywordsType()
	 * @generated
	 */
	int MD_KEYWORDS_TYPE = 178;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Keyword</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_TYPE__KEYWORD = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_TYPE__TYPE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Thesaurus Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_TYPE__THESAURUS_NAME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>MD Keywords Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>MD Keywords Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORDS_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDKeywordTypeCodePropertyTypeImpl <em>MD Keyword Type Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDKeywordTypeCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDKeywordTypeCodePropertyType()
	 * @generated
	 */
	int MD_KEYWORD_TYPE_CODE_PROPERTY_TYPE = 179;

	/**
	 * The feature id for the '<em><b>MD Keyword Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORD_TYPE_CODE_PROPERTY_TYPE__MD_KEYWORD_TYPE_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORD_TYPE_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Keyword Type Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORD_TYPE_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Keyword Type Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_KEYWORD_TYPE_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDLegalConstraintsPropertyTypeImpl <em>MD Legal Constraints Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDLegalConstraintsPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDLegalConstraintsPropertyType()
	 * @generated
	 */
	int MD_LEGAL_CONSTRAINTS_PROPERTY_TYPE = 180;

	/**
	 * The feature id for the '<em><b>MD Legal Constraints</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_PROPERTY_TYPE__MD_LEGAL_CONSTRAINTS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Legal Constraints Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Legal Constraints Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDLegalConstraintsTypeImpl <em>MD Legal Constraints Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDLegalConstraintsTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDLegalConstraintsType()
	 * @generated
	 */
	int MD_LEGAL_CONSTRAINTS_TYPE = 181;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_TYPE__ID = MD_CONSTRAINTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_TYPE__UUID = MD_CONSTRAINTS_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Use Limitation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_TYPE__USE_LIMITATION = MD_CONSTRAINTS_TYPE__USE_LIMITATION;

	/**
	 * The feature id for the '<em><b>Access Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_TYPE__ACCESS_CONSTRAINTS = MD_CONSTRAINTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Use Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_TYPE__USE_CONSTRAINTS = MD_CONSTRAINTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Other Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_TYPE__OTHER_CONSTRAINTS = MD_CONSTRAINTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>MD Legal Constraints Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_TYPE_FEATURE_COUNT = MD_CONSTRAINTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>MD Legal Constraints Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_LEGAL_CONSTRAINTS_TYPE_OPERATION_COUNT = MD_CONSTRAINTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDMaintenanceFrequencyCodePropertyTypeImpl <em>MD Maintenance Frequency Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDMaintenanceFrequencyCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDMaintenanceFrequencyCodePropertyType()
	 * @generated
	 */
	int MD_MAINTENANCE_FREQUENCY_CODE_PROPERTY_TYPE = 182;

	/**
	 * The feature id for the '<em><b>MD Maintenance Frequency Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_FREQUENCY_CODE_PROPERTY_TYPE__MD_MAINTENANCE_FREQUENCY_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_FREQUENCY_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Maintenance Frequency Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_FREQUENCY_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Maintenance Frequency Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_FREQUENCY_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDMaintenanceInformationPropertyTypeImpl <em>MD Maintenance Information Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDMaintenanceInformationPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDMaintenanceInformationPropertyType()
	 * @generated
	 */
	int MD_MAINTENANCE_INFORMATION_PROPERTY_TYPE = 183;

	/**
	 * The feature id for the '<em><b>MD Maintenance Information</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_PROPERTY_TYPE__MD_MAINTENANCE_INFORMATION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Maintenance Information Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Maintenance Information Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDMaintenanceInformationTypeImpl <em>MD Maintenance Information Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDMaintenanceInformationTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDMaintenanceInformationType()
	 * @generated
	 */
	int MD_MAINTENANCE_INFORMATION_TYPE = 184;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Maintenance And Update Frequency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_TYPE__MAINTENANCE_AND_UPDATE_FREQUENCY = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Date Of Next Update</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_TYPE__DATE_OF_NEXT_UPDATE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>User Defined Maintenance Frequency</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_TYPE__USER_DEFINED_MAINTENANCE_FREQUENCY = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Update Scope</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_TYPE__UPDATE_SCOPE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Update Scope Description</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_TYPE__UPDATE_SCOPE_DESCRIPTION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Maintenance Note</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_TYPE__MAINTENANCE_NOTE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Contact</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_TYPE__CONTACT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>MD Maintenance Information Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 7;

	/**
	 * The number of operations of the '<em>MD Maintenance Information Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MAINTENANCE_INFORMATION_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDMediumFormatCodePropertyTypeImpl <em>MD Medium Format Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDMediumFormatCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDMediumFormatCodePropertyType()
	 * @generated
	 */
	int MD_MEDIUM_FORMAT_CODE_PROPERTY_TYPE = 185;

	/**
	 * The feature id for the '<em><b>MD Medium Format Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_FORMAT_CODE_PROPERTY_TYPE__MD_MEDIUM_FORMAT_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_FORMAT_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Medium Format Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_FORMAT_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Medium Format Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_FORMAT_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDMediumNameCodePropertyTypeImpl <em>MD Medium Name Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDMediumNameCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDMediumNameCodePropertyType()
	 * @generated
	 */
	int MD_MEDIUM_NAME_CODE_PROPERTY_TYPE = 186;

	/**
	 * The feature id for the '<em><b>MD Medium Name Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_NAME_CODE_PROPERTY_TYPE__MD_MEDIUM_NAME_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_NAME_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Medium Name Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_NAME_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Medium Name Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_NAME_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDMediumPropertyTypeImpl <em>MD Medium Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDMediumPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDMediumPropertyType()
	 * @generated
	 */
	int MD_MEDIUM_PROPERTY_TYPE = 187;

	/**
	 * The feature id for the '<em><b>MD Medium</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_PROPERTY_TYPE__MD_MEDIUM = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Medium Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Medium Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDMediumTypeImpl <em>MD Medium Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDMediumTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDMediumType()
	 * @generated
	 */
	int MD_MEDIUM_TYPE = 188;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_TYPE__NAME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Density</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_TYPE__DENSITY = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Density Units</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_TYPE__DENSITY_UNITS = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Volumes</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_TYPE__VOLUMES = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Medium Format</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_TYPE__MEDIUM_FORMAT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Medium Note</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_TYPE__MEDIUM_NOTE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>MD Medium Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>MD Medium Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_MEDIUM_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDMetadataExtensionInformationPropertyTypeImpl <em>MD Metadata Extension Information Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDMetadataExtensionInformationPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDMetadataExtensionInformationPropertyType()
	 * @generated
	 */
	int MD_METADATA_EXTENSION_INFORMATION_PROPERTY_TYPE = 189;

	/**
	 * The feature id for the '<em><b>MD Metadata Extension Information</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_EXTENSION_INFORMATION_PROPERTY_TYPE__MD_METADATA_EXTENSION_INFORMATION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_EXTENSION_INFORMATION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_EXTENSION_INFORMATION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_EXTENSION_INFORMATION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_EXTENSION_INFORMATION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_EXTENSION_INFORMATION_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_EXTENSION_INFORMATION_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_EXTENSION_INFORMATION_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_EXTENSION_INFORMATION_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_EXTENSION_INFORMATION_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Metadata Extension Information Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_EXTENSION_INFORMATION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Metadata Extension Information Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_EXTENSION_INFORMATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDMetadataExtensionInformationTypeImpl <em>MD Metadata Extension Information Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDMetadataExtensionInformationTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDMetadataExtensionInformationType()
	 * @generated
	 */
	int MD_METADATA_EXTENSION_INFORMATION_TYPE = 190;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_EXTENSION_INFORMATION_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_EXTENSION_INFORMATION_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Extension On Line Resource</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_EXTENSION_INFORMATION_TYPE__EXTENSION_ON_LINE_RESOURCE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Extended Element Information</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_EXTENSION_INFORMATION_TYPE__EXTENDED_ELEMENT_INFORMATION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>MD Metadata Extension Information Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_EXTENSION_INFORMATION_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>MD Metadata Extension Information Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_EXTENSION_INFORMATION_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDMetadataPropertyTypeImpl <em>MD Metadata Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDMetadataPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDMetadataPropertyType()
	 * @generated
	 */
	int MD_METADATA_PROPERTY_TYPE = 191;

	/**
	 * The feature id for the '<em><b>MD Metadata</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_PROPERTY_TYPE__MD_METADATA = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Metadata Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Metadata Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDMetadataTypeImpl <em>MD Metadata Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDMetadataTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDMetadataType()
	 * @generated
	 */
	int MD_METADATA_TYPE = 192;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>File Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__FILE_IDENTIFIER = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Language</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__LANGUAGE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Character Set</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__CHARACTER_SET = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Parent Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__PARENT_IDENTIFIER = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Hierarchy Level</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__HIERARCHY_LEVEL = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Hierarchy Level Name</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__HIERARCHY_LEVEL_NAME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Contact</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__CONTACT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Date Stamp</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__DATE_STAMP = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Metadata Standard Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__METADATA_STANDARD_NAME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Metadata Standard Version</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__METADATA_STANDARD_VERSION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Data Set URI</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__DATA_SET_URI = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Locale</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__LOCALE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Spatial Representation Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__SPATIAL_REPRESENTATION_INFO = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Reference System Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__REFERENCE_SYSTEM_INFO = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Metadata Extension Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__METADATA_EXTENSION_INFO = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Identification Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__IDENTIFICATION_INFO = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Content Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__CONTENT_INFO = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Distribution Info</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__DISTRIBUTION_INFO = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Data Quality Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__DATA_QUALITY_INFO = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Portrayal Catalogue Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__PORTRAYAL_CATALOGUE_INFO = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Metadata Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__METADATA_CONSTRAINTS = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Application Schema Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__APPLICATION_SCHEMA_INFO = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Metadata Maintenance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__METADATA_MAINTENANCE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Series</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__SERIES = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Describes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__DESCRIBES = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Property Type</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__PROPERTY_TYPE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Feature Type</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__FEATURE_TYPE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Feature Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE__FEATURE_ATTRIBUTE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 27;

	/**
	 * The number of structural features of the '<em>MD Metadata Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 28;

	/**
	 * The number of operations of the '<em>MD Metadata Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_METADATA_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDObligationCodePropertyTypeImpl <em>MD Obligation Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDObligationCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDObligationCodePropertyType()
	 * @generated
	 */
	int MD_OBLIGATION_CODE_PROPERTY_TYPE = 193;

	/**
	 * The feature id for the '<em><b>MD Obligation Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_OBLIGATION_CODE_PROPERTY_TYPE__MD_OBLIGATION_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_OBLIGATION_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Obligation Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_OBLIGATION_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Obligation Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_OBLIGATION_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDPixelOrientationCodePropertyTypeImpl <em>MD Pixel Orientation Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDPixelOrientationCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDPixelOrientationCodePropertyType()
	 * @generated
	 */
	int MD_PIXEL_ORIENTATION_CODE_PROPERTY_TYPE = 194;

	/**
	 * The feature id for the '<em><b>MD Pixel Orientation Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PIXEL_ORIENTATION_CODE_PROPERTY_TYPE__MD_PIXEL_ORIENTATION_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PIXEL_ORIENTATION_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Pixel Orientation Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PIXEL_ORIENTATION_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Pixel Orientation Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PIXEL_ORIENTATION_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDPortrayalCatalogueReferencePropertyTypeImpl <em>MD Portrayal Catalogue Reference Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDPortrayalCatalogueReferencePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDPortrayalCatalogueReferencePropertyType()
	 * @generated
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_PROPERTY_TYPE = 195;

	/**
	 * The feature id for the '<em><b>MD Portrayal Catalogue Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_PROPERTY_TYPE__MD_PORTRAYAL_CATALOGUE_REFERENCE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Portrayal Catalogue Reference Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Portrayal Catalogue Reference Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDPortrayalCatalogueReferenceTypeImpl <em>MD Portrayal Catalogue Reference Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDPortrayalCatalogueReferenceTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDPortrayalCatalogueReferenceType()
	 * @generated
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_TYPE = 196;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Portrayal Catalogue Citation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_TYPE__PORTRAYAL_CATALOGUE_CITATION = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>MD Portrayal Catalogue Reference Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>MD Portrayal Catalogue Reference Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PORTRAYAL_CATALOGUE_REFERENCE_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDProgressCodePropertyTypeImpl <em>MD Progress Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDProgressCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDProgressCodePropertyType()
	 * @generated
	 */
	int MD_PROGRESS_CODE_PROPERTY_TYPE = 197;

	/**
	 * The feature id for the '<em><b>MD Progress Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PROGRESS_CODE_PROPERTY_TYPE__MD_PROGRESS_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PROGRESS_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Progress Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PROGRESS_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Progress Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_PROGRESS_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDRangeDimensionPropertyTypeImpl <em>MD Range Dimension Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDRangeDimensionPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDRangeDimensionPropertyType()
	 * @generated
	 */
	int MD_RANGE_DIMENSION_PROPERTY_TYPE = 198;

	/**
	 * The feature id for the '<em><b>MD Range Dimension Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_PROPERTY_TYPE__MD_RANGE_DIMENSION_GROUP = 0;

	/**
	 * The feature id for the '<em><b>MD Range Dimension</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_PROPERTY_TYPE__MD_RANGE_DIMENSION = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>MD Range Dimension Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>MD Range Dimension Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RANGE_DIMENSION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDReferenceSystemPropertyTypeImpl <em>MD Reference System Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDReferenceSystemPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDReferenceSystemPropertyType()
	 * @generated
	 */
	int MD_REFERENCE_SYSTEM_PROPERTY_TYPE = 200;

	/**
	 * The feature id for the '<em><b>MD Reference System</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REFERENCE_SYSTEM_PROPERTY_TYPE__MD_REFERENCE_SYSTEM = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REFERENCE_SYSTEM_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REFERENCE_SYSTEM_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REFERENCE_SYSTEM_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REFERENCE_SYSTEM_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REFERENCE_SYSTEM_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REFERENCE_SYSTEM_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REFERENCE_SYSTEM_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REFERENCE_SYSTEM_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REFERENCE_SYSTEM_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Reference System Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REFERENCE_SYSTEM_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Reference System Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REFERENCE_SYSTEM_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDReferenceSystemTypeImpl <em>MD Reference System Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDReferenceSystemTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDReferenceSystemType()
	 * @generated
	 */
	int MD_REFERENCE_SYSTEM_TYPE = 201;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REFERENCE_SYSTEM_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REFERENCE_SYSTEM_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Reference System Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REFERENCE_SYSTEM_TYPE__REFERENCE_SYSTEM_IDENTIFIER = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>MD Reference System Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REFERENCE_SYSTEM_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>MD Reference System Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REFERENCE_SYSTEM_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDRepresentativeFractionPropertyTypeImpl <em>MD Representative Fraction Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDRepresentativeFractionPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDRepresentativeFractionPropertyType()
	 * @generated
	 */
	int MD_REPRESENTATIVE_FRACTION_PROPERTY_TYPE = 202;

	/**
	 * The feature id for the '<em><b>MD Representative Fraction</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REPRESENTATIVE_FRACTION_PROPERTY_TYPE__MD_REPRESENTATIVE_FRACTION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REPRESENTATIVE_FRACTION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REPRESENTATIVE_FRACTION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REPRESENTATIVE_FRACTION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REPRESENTATIVE_FRACTION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REPRESENTATIVE_FRACTION_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REPRESENTATIVE_FRACTION_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REPRESENTATIVE_FRACTION_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REPRESENTATIVE_FRACTION_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REPRESENTATIVE_FRACTION_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Representative Fraction Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REPRESENTATIVE_FRACTION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Representative Fraction Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REPRESENTATIVE_FRACTION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDRepresentativeFractionTypeImpl <em>MD Representative Fraction Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDRepresentativeFractionTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDRepresentativeFractionType()
	 * @generated
	 */
	int MD_REPRESENTATIVE_FRACTION_TYPE = 203;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REPRESENTATIVE_FRACTION_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REPRESENTATIVE_FRACTION_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Denominator</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REPRESENTATIVE_FRACTION_TYPE__DENOMINATOR = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>MD Representative Fraction Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REPRESENTATIVE_FRACTION_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>MD Representative Fraction Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_REPRESENTATIVE_FRACTION_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDResolutionPropertyTypeImpl <em>MD Resolution Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDResolutionPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDResolutionPropertyType()
	 * @generated
	 */
	int MD_RESOLUTION_PROPERTY_TYPE = 204;

	/**
	 * The feature id for the '<em><b>MD Resolution</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RESOLUTION_PROPERTY_TYPE__MD_RESOLUTION = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RESOLUTION_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Resolution Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RESOLUTION_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Resolution Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RESOLUTION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDResolutionTypeImpl <em>MD Resolution Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDResolutionTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDResolutionType()
	 * @generated
	 */
	int MD_RESOLUTION_TYPE = 205;

	/**
	 * The feature id for the '<em><b>Equivalent Scale</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RESOLUTION_TYPE__EQUIVALENT_SCALE = 0;

	/**
	 * The feature id for the '<em><b>Distance</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RESOLUTION_TYPE__DISTANCE = 1;

	/**
	 * The number of structural features of the '<em>MD Resolution Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RESOLUTION_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Resolution Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RESOLUTION_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDRestrictionCodePropertyTypeImpl <em>MD Restriction Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDRestrictionCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDRestrictionCodePropertyType()
	 * @generated
	 */
	int MD_RESTRICTION_CODE_PROPERTY_TYPE = 206;

	/**
	 * The feature id for the '<em><b>MD Restriction Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RESTRICTION_CODE_PROPERTY_TYPE__MD_RESTRICTION_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RESTRICTION_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Restriction Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RESTRICTION_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Restriction Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_RESTRICTION_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDScopeCodePropertyTypeImpl <em>MD Scope Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDScopeCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDScopeCodePropertyType()
	 * @generated
	 */
	int MD_SCOPE_CODE_PROPERTY_TYPE = 207;

	/**
	 * The feature id for the '<em><b>MD Scope Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SCOPE_CODE_PROPERTY_TYPE__MD_SCOPE_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SCOPE_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Scope Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SCOPE_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Scope Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SCOPE_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDScopeDescriptionPropertyTypeImpl <em>MD Scope Description Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDScopeDescriptionPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDScopeDescriptionPropertyType()
	 * @generated
	 */
	int MD_SCOPE_DESCRIPTION_PROPERTY_TYPE = 208;

	/**
	 * The feature id for the '<em><b>MD Scope Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SCOPE_DESCRIPTION_PROPERTY_TYPE__MD_SCOPE_DESCRIPTION = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SCOPE_DESCRIPTION_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Scope Description Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SCOPE_DESCRIPTION_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Scope Description Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SCOPE_DESCRIPTION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDScopeDescriptionTypeImpl <em>MD Scope Description Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDScopeDescriptionTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDScopeDescriptionType()
	 * @generated
	 */
	int MD_SCOPE_DESCRIPTION_TYPE = 209;

	/**
	 * The feature id for the '<em><b>Attributes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SCOPE_DESCRIPTION_TYPE__ATTRIBUTES = 0;

	/**
	 * The feature id for the '<em><b>Features</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SCOPE_DESCRIPTION_TYPE__FEATURES = 1;

	/**
	 * The feature id for the '<em><b>Feature Instances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SCOPE_DESCRIPTION_TYPE__FEATURE_INSTANCES = 2;

	/**
	 * The feature id for the '<em><b>Attribute Instances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SCOPE_DESCRIPTION_TYPE__ATTRIBUTE_INSTANCES = 3;

	/**
	 * The feature id for the '<em><b>Dataset</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SCOPE_DESCRIPTION_TYPE__DATASET = 4;

	/**
	 * The feature id for the '<em><b>Other</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SCOPE_DESCRIPTION_TYPE__OTHER = 5;

	/**
	 * The number of structural features of the '<em>MD Scope Description Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SCOPE_DESCRIPTION_TYPE_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>MD Scope Description Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SCOPE_DESCRIPTION_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDSecurityConstraintsPropertyTypeImpl <em>MD Security Constraints Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDSecurityConstraintsPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDSecurityConstraintsPropertyType()
	 * @generated
	 */
	int MD_SECURITY_CONSTRAINTS_PROPERTY_TYPE = 210;

	/**
	 * The feature id for the '<em><b>MD Security Constraints</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_PROPERTY_TYPE__MD_SECURITY_CONSTRAINTS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Security Constraints Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Security Constraints Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDSecurityConstraintsTypeImpl <em>MD Security Constraints Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDSecurityConstraintsTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDSecurityConstraintsType()
	 * @generated
	 */
	int MD_SECURITY_CONSTRAINTS_TYPE = 211;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_TYPE__ID = MD_CONSTRAINTS_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_TYPE__UUID = MD_CONSTRAINTS_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Use Limitation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_TYPE__USE_LIMITATION = MD_CONSTRAINTS_TYPE__USE_LIMITATION;

	/**
	 * The feature id for the '<em><b>Classification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_TYPE__CLASSIFICATION = MD_CONSTRAINTS_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>User Note</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_TYPE__USER_NOTE = MD_CONSTRAINTS_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Classification System</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_TYPE__CLASSIFICATION_SYSTEM = MD_CONSTRAINTS_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Handling Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_TYPE__HANDLING_DESCRIPTION = MD_CONSTRAINTS_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>MD Security Constraints Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_TYPE_FEATURE_COUNT = MD_CONSTRAINTS_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>MD Security Constraints Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SECURITY_CONSTRAINTS_TYPE_OPERATION_COUNT = MD_CONSTRAINTS_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDServiceIdentificationPropertyTypeImpl <em>MD Service Identification Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDServiceIdentificationPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDServiceIdentificationPropertyType()
	 * @generated
	 */
	int MD_SERVICE_IDENTIFICATION_PROPERTY_TYPE = 212;

	/**
	 * The feature id for the '<em><b>MD Service Identification</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_PROPERTY_TYPE__MD_SERVICE_IDENTIFICATION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Service Identification Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Service Identification Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDServiceIdentificationTypeImpl <em>MD Service Identification Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDServiceIdentificationTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDServiceIdentificationType()
	 * @generated
	 */
	int MD_SERVICE_IDENTIFICATION_TYPE = 213;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_TYPE__ID = ABSTRACT_MD_IDENTIFICATION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_TYPE__UUID = ABSTRACT_MD_IDENTIFICATION_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Citation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_TYPE__CITATION = ABSTRACT_MD_IDENTIFICATION_TYPE__CITATION;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_TYPE__ABSTRACT = ABSTRACT_MD_IDENTIFICATION_TYPE__ABSTRACT;

	/**
	 * The feature id for the '<em><b>Purpose</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_TYPE__PURPOSE = ABSTRACT_MD_IDENTIFICATION_TYPE__PURPOSE;

	/**
	 * The feature id for the '<em><b>Credit</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_TYPE__CREDIT = ABSTRACT_MD_IDENTIFICATION_TYPE__CREDIT;

	/**
	 * The feature id for the '<em><b>Status</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_TYPE__STATUS = ABSTRACT_MD_IDENTIFICATION_TYPE__STATUS;

	/**
	 * The feature id for the '<em><b>Point Of Contact</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_TYPE__POINT_OF_CONTACT = ABSTRACT_MD_IDENTIFICATION_TYPE__POINT_OF_CONTACT;

	/**
	 * The feature id for the '<em><b>Resource Maintenance</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_TYPE__RESOURCE_MAINTENANCE = ABSTRACT_MD_IDENTIFICATION_TYPE__RESOURCE_MAINTENANCE;

	/**
	 * The feature id for the '<em><b>Graphic Overview</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_TYPE__GRAPHIC_OVERVIEW = ABSTRACT_MD_IDENTIFICATION_TYPE__GRAPHIC_OVERVIEW;

	/**
	 * The feature id for the '<em><b>Resource Format</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_TYPE__RESOURCE_FORMAT = ABSTRACT_MD_IDENTIFICATION_TYPE__RESOURCE_FORMAT;

	/**
	 * The feature id for the '<em><b>Descriptive Keywords</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_TYPE__DESCRIPTIVE_KEYWORDS = ABSTRACT_MD_IDENTIFICATION_TYPE__DESCRIPTIVE_KEYWORDS;

	/**
	 * The feature id for the '<em><b>Resource Specific Usage</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_TYPE__RESOURCE_SPECIFIC_USAGE = ABSTRACT_MD_IDENTIFICATION_TYPE__RESOURCE_SPECIFIC_USAGE;

	/**
	 * The feature id for the '<em><b>Resource Constraints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_TYPE__RESOURCE_CONSTRAINTS = ABSTRACT_MD_IDENTIFICATION_TYPE__RESOURCE_CONSTRAINTS;

	/**
	 * The feature id for the '<em><b>Aggregation Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_TYPE__AGGREGATION_INFO = ABSTRACT_MD_IDENTIFICATION_TYPE__AGGREGATION_INFO;

	/**
	 * The number of structural features of the '<em>MD Service Identification Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_TYPE_FEATURE_COUNT = ABSTRACT_MD_IDENTIFICATION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>MD Service Identification Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SERVICE_IDENTIFICATION_TYPE_OPERATION_COUNT = ABSTRACT_MD_IDENTIFICATION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDSpatialRepresentationPropertyTypeImpl <em>MD Spatial Representation Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDSpatialRepresentationPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDSpatialRepresentationPropertyType()
	 * @generated
	 */
	int MD_SPATIAL_REPRESENTATION_PROPERTY_TYPE = 214;

	/**
	 * The feature id for the '<em><b>Abstract MD Spatial Representation Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SPATIAL_REPRESENTATION_PROPERTY_TYPE__ABSTRACT_MD_SPATIAL_REPRESENTATION_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract MD Spatial Representation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SPATIAL_REPRESENTATION_PROPERTY_TYPE__ABSTRACT_MD_SPATIAL_REPRESENTATION = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SPATIAL_REPRESENTATION_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SPATIAL_REPRESENTATION_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SPATIAL_REPRESENTATION_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SPATIAL_REPRESENTATION_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SPATIAL_REPRESENTATION_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SPATIAL_REPRESENTATION_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SPATIAL_REPRESENTATION_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SPATIAL_REPRESENTATION_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SPATIAL_REPRESENTATION_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>MD Spatial Representation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SPATIAL_REPRESENTATION_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>MD Spatial Representation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SPATIAL_REPRESENTATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDSpatialRepresentationTypeCodePropertyTypeImpl <em>MD Spatial Representation Type Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDSpatialRepresentationTypeCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDSpatialRepresentationTypeCodePropertyType()
	 * @generated
	 */
	int MD_SPATIAL_REPRESENTATION_TYPE_CODE_PROPERTY_TYPE = 215;

	/**
	 * The feature id for the '<em><b>MD Spatial Representation Type Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SPATIAL_REPRESENTATION_TYPE_CODE_PROPERTY_TYPE__MD_SPATIAL_REPRESENTATION_TYPE_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SPATIAL_REPRESENTATION_TYPE_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Spatial Representation Type Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SPATIAL_REPRESENTATION_TYPE_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Spatial Representation Type Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_SPATIAL_REPRESENTATION_TYPE_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDStandardOrderProcessPropertyTypeImpl <em>MD Standard Order Process Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDStandardOrderProcessPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDStandardOrderProcessPropertyType()
	 * @generated
	 */
	int MD_STANDARD_ORDER_PROCESS_PROPERTY_TYPE = 216;

	/**
	 * The feature id for the '<em><b>MD Standard Order Process</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_PROPERTY_TYPE__MD_STANDARD_ORDER_PROCESS = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Standard Order Process Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Standard Order Process Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDStandardOrderProcessTypeImpl <em>MD Standard Order Process Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDStandardOrderProcessTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDStandardOrderProcessType()
	 * @generated
	 */
	int MD_STANDARD_ORDER_PROCESS_TYPE = 217;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Fees</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_TYPE__FEES = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Planned Available Date Time</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_TYPE__PLANNED_AVAILABLE_DATE_TIME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Ordering Instructions</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_TYPE__ORDERING_INSTRUCTIONS = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Turnaround</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_TYPE__TURNAROUND = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>MD Standard Order Process Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>MD Standard Order Process Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_STANDARD_ORDER_PROCESS_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDTopicCategoryCodePropertyTypeImpl <em>MD Topic Category Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDTopicCategoryCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDTopicCategoryCodePropertyType()
	 * @generated
	 */
	int MD_TOPIC_CATEGORY_CODE_PROPERTY_TYPE = 218;

	/**
	 * The feature id for the '<em><b>MD Topic Category Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_TOPIC_CATEGORY_CODE_PROPERTY_TYPE__MD_TOPIC_CATEGORY_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_TOPIC_CATEGORY_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Topic Category Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_TOPIC_CATEGORY_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Topic Category Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_TOPIC_CATEGORY_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDTopologyLevelCodePropertyTypeImpl <em>MD Topology Level Code Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDTopologyLevelCodePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDTopologyLevelCodePropertyType()
	 * @generated
	 */
	int MD_TOPOLOGY_LEVEL_CODE_PROPERTY_TYPE = 219;

	/**
	 * The feature id for the '<em><b>MD Topology Level Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_TOPOLOGY_LEVEL_CODE_PROPERTY_TYPE__MD_TOPOLOGY_LEVEL_CODE = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_TOPOLOGY_LEVEL_CODE_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>MD Topology Level Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_TOPOLOGY_LEVEL_CODE_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MD Topology Level Code Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_TOPOLOGY_LEVEL_CODE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDUsagePropertyTypeImpl <em>MD Usage Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDUsagePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDUsagePropertyType()
	 * @generated
	 */
	int MD_USAGE_PROPERTY_TYPE = 220;

	/**
	 * The feature id for the '<em><b>MD Usage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_PROPERTY_TYPE__MD_USAGE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Usage Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Usage Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDUsageTypeImpl <em>MD Usage Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDUsageTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDUsageType()
	 * @generated
	 */
	int MD_USAGE_TYPE = 221;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Specific Usage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_TYPE__SPECIFIC_USAGE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Usage Date Time</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_TYPE__USAGE_DATE_TIME = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>User Determined Limitations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_TYPE__USER_DETERMINED_LIMITATIONS = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>User Contact Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_TYPE__USER_CONTACT_INFO = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>MD Usage Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>MD Usage Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_USAGE_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDVectorSpatialRepresentationPropertyTypeImpl <em>MD Vector Spatial Representation Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDVectorSpatialRepresentationPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDVectorSpatialRepresentationPropertyType()
	 * @generated
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_PROPERTY_TYPE = 222;

	/**
	 * The feature id for the '<em><b>MD Vector Spatial Representation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_PROPERTY_TYPE__MD_VECTOR_SPATIAL_REPRESENTATION = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>MD Vector Spatial Representation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>MD Vector Spatial Representation Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.MDVectorSpatialRepresentationTypeImpl <em>MD Vector Spatial Representation Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.MDVectorSpatialRepresentationTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDVectorSpatialRepresentationType()
	 * @generated
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_TYPE = 223;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_TYPE__ID = ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_TYPE__UUID = ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Topology Level</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_TYPE__TOPOLOGY_LEVEL = ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Geometric Objects</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_TYPE__GEOMETRIC_OBJECTS = ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>MD Vector Spatial Representation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT = ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>MD Vector Spatial Representation Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MD_VECTOR_SPATIAL_REPRESENTATION_TYPE_OPERATION_COUNT = ABSTRACT_MD_SPATIAL_REPRESENTATION_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.PTFreeTextPropertyTypeImpl <em>PT Free Text Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.PTFreeTextPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getPTFreeTextPropertyType()
	 * @generated
	 */
	int PT_FREE_TEXT_PROPERTY_TYPE = 224;

	/**
	 * The feature id for the '<em><b>Character String Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_FREE_TEXT_PROPERTY_TYPE__CHARACTER_STRING_GROUP = GCOPackage.CHARACTER_STRING_PROPERTY_TYPE__CHARACTER_STRING_GROUP;

	/**
	 * The feature id for the '<em><b>Character String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_FREE_TEXT_PROPERTY_TYPE__CHARACTER_STRING = GCOPackage.CHARACTER_STRING_PROPERTY_TYPE__CHARACTER_STRING;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_FREE_TEXT_PROPERTY_TYPE__NIL_REASON = GCOPackage.CHARACTER_STRING_PROPERTY_TYPE__NIL_REASON;

	/**
	 * The feature id for the '<em><b>PT Free Text</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_FREE_TEXT_PROPERTY_TYPE__PT_FREE_TEXT = GCOPackage.CHARACTER_STRING_PROPERTY_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>PT Free Text Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_FREE_TEXT_PROPERTY_TYPE_FEATURE_COUNT = GCOPackage.CHARACTER_STRING_PROPERTY_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>PT Free Text Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_FREE_TEXT_PROPERTY_TYPE_OPERATION_COUNT = GCOPackage.CHARACTER_STRING_PROPERTY_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.PTFreeTextTypeImpl <em>PT Free Text Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.PTFreeTextTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getPTFreeTextType()
	 * @generated
	 */
	int PT_FREE_TEXT_TYPE = 225;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_FREE_TEXT_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_FREE_TEXT_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Text Group</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_FREE_TEXT_TYPE__TEXT_GROUP = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>PT Free Text Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_FREE_TEXT_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>PT Free Text Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_FREE_TEXT_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.PTLocaleContainerPropertyTypeImpl <em>PT Locale Container Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.PTLocaleContainerPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getPTLocaleContainerPropertyType()
	 * @generated
	 */
	int PT_LOCALE_CONTAINER_PROPERTY_TYPE = 226;

	/**
	 * The feature id for the '<em><b>PT Locale Container</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_PROPERTY_TYPE__PT_LOCALE_CONTAINER = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>PT Locale Container Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>PT Locale Container Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.PTLocaleContainerTypeImpl <em>PT Locale Container Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.PTLocaleContainerTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getPTLocaleContainerType()
	 * @generated
	 */
	int PT_LOCALE_CONTAINER_TYPE = 227;

	/**
	 * The feature id for the '<em><b>Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_TYPE__DESCRIPTION = 0;

	/**
	 * The feature id for the '<em><b>Locale</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_TYPE__LOCALE = 1;

	/**
	 * The feature id for the '<em><b>Date</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_TYPE__DATE = 2;

	/**
	 * The feature id for the '<em><b>Responsible Party</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_TYPE__RESPONSIBLE_PARTY = 3;

	/**
	 * The feature id for the '<em><b>Localised String</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_TYPE__LOCALISED_STRING = 4;

	/**
	 * The number of structural features of the '<em>PT Locale Container Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_TYPE_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>PT Locale Container Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_CONTAINER_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.PTLocalePropertyTypeImpl <em>PT Locale Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.PTLocalePropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getPTLocalePropertyType()
	 * @generated
	 */
	int PT_LOCALE_PROPERTY_TYPE = 228;

	/**
	 * The feature id for the '<em><b>PT Locale</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_PROPERTY_TYPE__PT_LOCALE = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>PT Locale Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>PT Locale Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.PTLocaleTypeImpl <em>PT Locale Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.PTLocaleTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getPTLocaleType()
	 * @generated
	 */
	int PT_LOCALE_TYPE = 229;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_TYPE__ID = GCOPackage.ABSTRACT_OBJECT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_TYPE__UUID = GCOPackage.ABSTRACT_OBJECT_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Language Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_TYPE__LANGUAGE_CODE = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Country</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_TYPE__COUNTRY = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Character Encoding</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_TYPE__CHARACTER_ENCODING = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>PT Locale Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_TYPE_FEATURE_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>PT Locale Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PT_LOCALE_TYPE_OPERATION_COUNT = GCOPackage.ABSTRACT_OBJECT_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.RSIdentifierPropertyTypeImpl <em>RS Identifier Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.RSIdentifierPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getRSIdentifierPropertyType()
	 * @generated
	 */
	int RS_IDENTIFIER_PROPERTY_TYPE = 230;

	/**
	 * The feature id for the '<em><b>RS Identifier</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_PROPERTY_TYPE__RS_IDENTIFIER = 0;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_PROPERTY_TYPE__ACTUATE = 1;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_PROPERTY_TYPE__ARCROLE = 2;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_PROPERTY_TYPE__HREF = 3;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_PROPERTY_TYPE__NIL_REASON = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_PROPERTY_TYPE__ROLE = 5;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_PROPERTY_TYPE__SHOW = 6;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_PROPERTY_TYPE__TITLE = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_PROPERTY_TYPE__TYPE = 8;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_PROPERTY_TYPE__UUIDREF = 9;

	/**
	 * The number of structural features of the '<em>RS Identifier Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_PROPERTY_TYPE_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>RS Identifier Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.RSIdentifierTypeImpl <em>RS Identifier Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.RSIdentifierTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getRSIdentifierType()
	 * @generated
	 */
	int RS_IDENTIFIER_TYPE = 231;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_TYPE__ID = MD_IDENTIFIER_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Uuid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_TYPE__UUID = MD_IDENTIFIER_TYPE__UUID;

	/**
	 * The feature id for the '<em><b>Authority</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_TYPE__AUTHORITY = MD_IDENTIFIER_TYPE__AUTHORITY;

	/**
	 * The feature id for the '<em><b>Code</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_TYPE__CODE = MD_IDENTIFIER_TYPE__CODE;

	/**
	 * The feature id for the '<em><b>Code Space</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_TYPE__CODE_SPACE = MD_IDENTIFIER_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Version</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_TYPE__VERSION = MD_IDENTIFIER_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>RS Identifier Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_TYPE_FEATURE_COUNT = MD_IDENTIFIER_TYPE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>RS Identifier Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_IDENTIFIER_TYPE_OPERATION_COUNT = MD_IDENTIFIER_TYPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.RSReferenceSystemPropertyTypeImpl <em>RS Reference System Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.RSReferenceSystemPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getRSReferenceSystemPropertyType()
	 * @generated
	 */
	int RS_REFERENCE_SYSTEM_PROPERTY_TYPE = 232;

	/**
	 * The feature id for the '<em><b>Abstract RS Reference System Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_REFERENCE_SYSTEM_PROPERTY_TYPE__ABSTRACT_RS_REFERENCE_SYSTEM_GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract RS Reference System</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_REFERENCE_SYSTEM_PROPERTY_TYPE__ABSTRACT_RS_REFERENCE_SYSTEM = 1;

	/**
	 * The feature id for the '<em><b>Actuate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_REFERENCE_SYSTEM_PROPERTY_TYPE__ACTUATE = 2;

	/**
	 * The feature id for the '<em><b>Arcrole</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_REFERENCE_SYSTEM_PROPERTY_TYPE__ARCROLE = 3;

	/**
	 * The feature id for the '<em><b>Href</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_REFERENCE_SYSTEM_PROPERTY_TYPE__HREF = 4;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_REFERENCE_SYSTEM_PROPERTY_TYPE__NIL_REASON = 5;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_REFERENCE_SYSTEM_PROPERTY_TYPE__ROLE = 6;

	/**
	 * The feature id for the '<em><b>Show</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_REFERENCE_SYSTEM_PROPERTY_TYPE__SHOW = 7;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_REFERENCE_SYSTEM_PROPERTY_TYPE__TITLE = 8;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_REFERENCE_SYSTEM_PROPERTY_TYPE__TYPE = 9;

	/**
	 * The feature id for the '<em><b>Uuidref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_REFERENCE_SYSTEM_PROPERTY_TYPE__UUIDREF = 10;

	/**
	 * The number of structural features of the '<em>RS Reference System Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_REFERENCE_SYSTEM_PROPERTY_TYPE_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>RS Reference System Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RS_REFERENCE_SYSTEM_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.impl.URLPropertyTypeImpl <em>URL Property Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.impl.URLPropertyTypeImpl
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getURLPropertyType()
	 * @generated
	 */
	int URL_PROPERTY_TYPE = 233;

	/**
	 * The feature id for the '<em><b>URL</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URL_PROPERTY_TYPE__URL = 0;

	/**
	 * The feature id for the '<em><b>Nil Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URL_PROPERTY_TYPE__NIL_REASON = 1;

	/**
	 * The number of structural features of the '<em>URL Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URL_PROPERTY_TYPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>URL Property Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URL_PROPERTY_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.MDObligationCodeType <em>MD Obligation Code Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.MDObligationCodeType
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDObligationCodeType()
	 * @generated
	 */
	int MD_OBLIGATION_CODE_TYPE = 234;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.MDPixelOrientationCodeType <em>MD Pixel Orientation Code Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.MDPixelOrientationCodeType
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDPixelOrientationCodeType()
	 * @generated
	 */
	int MD_PIXEL_ORIENTATION_CODE_TYPE = 235;

	/**
	 * The meta object id for the '{@link org.isotc211._2005.gmd.MDTopicCategoryCodeType <em>MD Topic Category Code Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.MDTopicCategoryCodeType
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDTopicCategoryCodeType()
	 * @generated
	 */
	int MD_TOPIC_CATEGORY_CODE_TYPE = 236;

	/**
	 * The meta object id for the '<em>MD Obligation Code Type Object</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.MDObligationCodeType
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDObligationCodeTypeObject()
	 * @generated
	 */
	int MD_OBLIGATION_CODE_TYPE_OBJECT = 237;

	/**
	 * The meta object id for the '<em>MD Pixel Orientation Code Type Object</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.MDPixelOrientationCodeType
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDPixelOrientationCodeTypeObject()
	 * @generated
	 */
	int MD_PIXEL_ORIENTATION_CODE_TYPE_OBJECT = 238;

	/**
	 * The meta object id for the '<em>MD Topic Category Code Type Object</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.isotc211._2005.gmd.MDTopicCategoryCodeType
	 * @see org.isotc211._2005.gmd.impl.GMDPackageImpl#getMDTopicCategoryCodeTypeObject()
	 * @generated
	 */
	int MD_TOPIC_CATEGORY_CODE_TYPE_OBJECT = 239;


	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.AbstractDQCompletenessType <em>Abstract DQ Completeness Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract DQ Completeness Type</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDQCompletenessType
	 * @generated
	 */
	EClass getAbstractDQCompletenessType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.AbstractDQElementType <em>Abstract DQ Element Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract DQ Element Type</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDQElementType
	 * @generated
	 */
	EClass getAbstractDQElementType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.AbstractDQElementType#getNameOfMeasure <em>Name Of Measure</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Name Of Measure</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDQElementType#getNameOfMeasure()
	 * @see #getAbstractDQElementType()
	 * @generated
	 */
	EReference getAbstractDQElementType_NameOfMeasure();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.AbstractDQElementType#getMeasureIdentification <em>Measure Identification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Measure Identification</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDQElementType#getMeasureIdentification()
	 * @see #getAbstractDQElementType()
	 * @generated
	 */
	EReference getAbstractDQElementType_MeasureIdentification();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.AbstractDQElementType#getMeasureDescription <em>Measure Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Measure Description</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDQElementType#getMeasureDescription()
	 * @see #getAbstractDQElementType()
	 * @generated
	 */
	EReference getAbstractDQElementType_MeasureDescription();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.AbstractDQElementType#getEvaluationMethodType <em>Evaluation Method Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Evaluation Method Type</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDQElementType#getEvaluationMethodType()
	 * @see #getAbstractDQElementType()
	 * @generated
	 */
	EReference getAbstractDQElementType_EvaluationMethodType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.AbstractDQElementType#getEvaluationMethodDescription <em>Evaluation Method Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Evaluation Method Description</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDQElementType#getEvaluationMethodDescription()
	 * @see #getAbstractDQElementType()
	 * @generated
	 */
	EReference getAbstractDQElementType_EvaluationMethodDescription();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.AbstractDQElementType#getEvaluationProcedure <em>Evaluation Procedure</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Evaluation Procedure</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDQElementType#getEvaluationProcedure()
	 * @see #getAbstractDQElementType()
	 * @generated
	 */
	EReference getAbstractDQElementType_EvaluationProcedure();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.AbstractDQElementType#getDateTime <em>Date Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Date Time</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDQElementType#getDateTime()
	 * @see #getAbstractDQElementType()
	 * @generated
	 */
	EReference getAbstractDQElementType_DateTime();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.AbstractDQElementType#getResult <em>Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Result</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDQElementType#getResult()
	 * @see #getAbstractDQElementType()
	 * @generated
	 */
	EReference getAbstractDQElementType_Result();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.AbstractDQLogicalConsistencyType <em>Abstract DQ Logical Consistency Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract DQ Logical Consistency Type</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDQLogicalConsistencyType
	 * @generated
	 */
	EClass getAbstractDQLogicalConsistencyType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.AbstractDQPositionalAccuracyType <em>Abstract DQ Positional Accuracy Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract DQ Positional Accuracy Type</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDQPositionalAccuracyType
	 * @generated
	 */
	EClass getAbstractDQPositionalAccuracyType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.AbstractDQResultType <em>Abstract DQ Result Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract DQ Result Type</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDQResultType
	 * @generated
	 */
	EClass getAbstractDQResultType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.AbstractDQTemporalAccuracyType <em>Abstract DQ Temporal Accuracy Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract DQ Temporal Accuracy Type</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDQTemporalAccuracyType
	 * @generated
	 */
	EClass getAbstractDQTemporalAccuracyType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.AbstractDQThematicAccuracyType <em>Abstract DQ Thematic Accuracy Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract DQ Thematic Accuracy Type</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDQThematicAccuracyType
	 * @generated
	 */
	EClass getAbstractDQThematicAccuracyType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.AbstractDSAggregateType <em>Abstract DS Aggregate Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract DS Aggregate Type</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDSAggregateType
	 * @generated
	 */
	EClass getAbstractDSAggregateType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.AbstractDSAggregateType#getComposedOf <em>Composed Of</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Composed Of</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDSAggregateType#getComposedOf()
	 * @see #getAbstractDSAggregateType()
	 * @generated
	 */
	EReference getAbstractDSAggregateType_ComposedOf();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.AbstractDSAggregateType#getSeriesMetadata <em>Series Metadata</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Series Metadata</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDSAggregateType#getSeriesMetadata()
	 * @see #getAbstractDSAggregateType()
	 * @generated
	 */
	EReference getAbstractDSAggregateType_SeriesMetadata();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.AbstractDSAggregateType#getSubset <em>Subset</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Subset</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDSAggregateType#getSubset()
	 * @see #getAbstractDSAggregateType()
	 * @generated
	 */
	EReference getAbstractDSAggregateType_Subset();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.AbstractDSAggregateType#getSuperset <em>Superset</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Superset</em>'.
	 * @see org.isotc211._2005.gmd.AbstractDSAggregateType#getSuperset()
	 * @see #getAbstractDSAggregateType()
	 * @generated
	 */
	EReference getAbstractDSAggregateType_Superset();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.AbstractEXGeographicExtentType <em>Abstract EX Geographic Extent Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract EX Geographic Extent Type</em>'.
	 * @see org.isotc211._2005.gmd.AbstractEXGeographicExtentType
	 * @generated
	 */
	EClass getAbstractEXGeographicExtentType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.AbstractEXGeographicExtentType#getExtentTypeCode <em>Extent Type Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Extent Type Code</em>'.
	 * @see org.isotc211._2005.gmd.AbstractEXGeographicExtentType#getExtentTypeCode()
	 * @see #getAbstractEXGeographicExtentType()
	 * @generated
	 */
	EReference getAbstractEXGeographicExtentType_ExtentTypeCode();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.AbstractMDContentInformationType <em>Abstract MD Content Information Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract MD Content Information Type</em>'.
	 * @see org.isotc211._2005.gmd.AbstractMDContentInformationType
	 * @generated
	 */
	EClass getAbstractMDContentInformationType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.AbstractMDIdentificationType <em>Abstract MD Identification Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract MD Identification Type</em>'.
	 * @see org.isotc211._2005.gmd.AbstractMDIdentificationType
	 * @generated
	 */
	EClass getAbstractMDIdentificationType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.AbstractMDIdentificationType#getCitation <em>Citation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Citation</em>'.
	 * @see org.isotc211._2005.gmd.AbstractMDIdentificationType#getCitation()
	 * @see #getAbstractMDIdentificationType()
	 * @generated
	 */
	EReference getAbstractMDIdentificationType_Citation();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.AbstractMDIdentificationType#getAbstract <em>Abstract</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Abstract</em>'.
	 * @see org.isotc211._2005.gmd.AbstractMDIdentificationType#getAbstract()
	 * @see #getAbstractMDIdentificationType()
	 * @generated
	 */
	EReference getAbstractMDIdentificationType_Abstract();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.AbstractMDIdentificationType#getPurpose <em>Purpose</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Purpose</em>'.
	 * @see org.isotc211._2005.gmd.AbstractMDIdentificationType#getPurpose()
	 * @see #getAbstractMDIdentificationType()
	 * @generated
	 */
	EReference getAbstractMDIdentificationType_Purpose();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.AbstractMDIdentificationType#getCredit <em>Credit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Credit</em>'.
	 * @see org.isotc211._2005.gmd.AbstractMDIdentificationType#getCredit()
	 * @see #getAbstractMDIdentificationType()
	 * @generated
	 */
	EReference getAbstractMDIdentificationType_Credit();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.AbstractMDIdentificationType#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Status</em>'.
	 * @see org.isotc211._2005.gmd.AbstractMDIdentificationType#getStatus()
	 * @see #getAbstractMDIdentificationType()
	 * @generated
	 */
	EReference getAbstractMDIdentificationType_Status();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.AbstractMDIdentificationType#getPointOfContact <em>Point Of Contact</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Point Of Contact</em>'.
	 * @see org.isotc211._2005.gmd.AbstractMDIdentificationType#getPointOfContact()
	 * @see #getAbstractMDIdentificationType()
	 * @generated
	 */
	EReference getAbstractMDIdentificationType_PointOfContact();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.AbstractMDIdentificationType#getResourceMaintenance <em>Resource Maintenance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Resource Maintenance</em>'.
	 * @see org.isotc211._2005.gmd.AbstractMDIdentificationType#getResourceMaintenance()
	 * @see #getAbstractMDIdentificationType()
	 * @generated
	 */
	EReference getAbstractMDIdentificationType_ResourceMaintenance();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.AbstractMDIdentificationType#getGraphicOverview <em>Graphic Overview</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Graphic Overview</em>'.
	 * @see org.isotc211._2005.gmd.AbstractMDIdentificationType#getGraphicOverview()
	 * @see #getAbstractMDIdentificationType()
	 * @generated
	 */
	EReference getAbstractMDIdentificationType_GraphicOverview();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.AbstractMDIdentificationType#getResourceFormat <em>Resource Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Resource Format</em>'.
	 * @see org.isotc211._2005.gmd.AbstractMDIdentificationType#getResourceFormat()
	 * @see #getAbstractMDIdentificationType()
	 * @generated
	 */
	EReference getAbstractMDIdentificationType_ResourceFormat();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.AbstractMDIdentificationType#getDescriptiveKeywords <em>Descriptive Keywords</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Descriptive Keywords</em>'.
	 * @see org.isotc211._2005.gmd.AbstractMDIdentificationType#getDescriptiveKeywords()
	 * @see #getAbstractMDIdentificationType()
	 * @generated
	 */
	EReference getAbstractMDIdentificationType_DescriptiveKeywords();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.AbstractMDIdentificationType#getResourceSpecificUsage <em>Resource Specific Usage</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Resource Specific Usage</em>'.
	 * @see org.isotc211._2005.gmd.AbstractMDIdentificationType#getResourceSpecificUsage()
	 * @see #getAbstractMDIdentificationType()
	 * @generated
	 */
	EReference getAbstractMDIdentificationType_ResourceSpecificUsage();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.AbstractMDIdentificationType#getResourceConstraints <em>Resource Constraints</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Resource Constraints</em>'.
	 * @see org.isotc211._2005.gmd.AbstractMDIdentificationType#getResourceConstraints()
	 * @see #getAbstractMDIdentificationType()
	 * @generated
	 */
	EReference getAbstractMDIdentificationType_ResourceConstraints();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.AbstractMDIdentificationType#getAggregationInfo <em>Aggregation Info</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Aggregation Info</em>'.
	 * @see org.isotc211._2005.gmd.AbstractMDIdentificationType#getAggregationInfo()
	 * @see #getAbstractMDIdentificationType()
	 * @generated
	 */
	EReference getAbstractMDIdentificationType_AggregationInfo();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.AbstractMDSpatialRepresentationType <em>Abstract MD Spatial Representation Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract MD Spatial Representation Type</em>'.
	 * @see org.isotc211._2005.gmd.AbstractMDSpatialRepresentationType
	 * @generated
	 */
	EClass getAbstractMDSpatialRepresentationType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.AbstractRSReferenceSystemType <em>Abstract RS Reference System Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract RS Reference System Type</em>'.
	 * @see org.isotc211._2005.gmd.AbstractRSReferenceSystemType
	 * @generated
	 */
	EClass getAbstractRSReferenceSystemType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.AbstractRSReferenceSystemType#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Name</em>'.
	 * @see org.isotc211._2005.gmd.AbstractRSReferenceSystemType#getName()
	 * @see #getAbstractRSReferenceSystemType()
	 * @generated
	 */
	EReference getAbstractRSReferenceSystemType_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.AbstractRSReferenceSystemType#getDomainOfValidity <em>Domain Of Validity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Domain Of Validity</em>'.
	 * @see org.isotc211._2005.gmd.AbstractRSReferenceSystemType#getDomainOfValidity()
	 * @see #getAbstractRSReferenceSystemType()
	 * @generated
	 */
	EReference getAbstractRSReferenceSystemType_DomainOfValidity();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CIAddressPropertyType <em>CI Address Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Address Property Type</em>'.
	 * @see org.isotc211._2005.gmd.CIAddressPropertyType
	 * @generated
	 */
	EClass getCIAddressPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIAddressPropertyType#getCIAddress <em>CI Address</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>CI Address</em>'.
	 * @see org.isotc211._2005.gmd.CIAddressPropertyType#getCIAddress()
	 * @see #getCIAddressPropertyType()
	 * @generated
	 */
	EReference getCIAddressPropertyType_CIAddress();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIAddressPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.CIAddressPropertyType#getActuate()
	 * @see #getCIAddressPropertyType()
	 * @generated
	 */
	EAttribute getCIAddressPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIAddressPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.CIAddressPropertyType#getArcrole()
	 * @see #getCIAddressPropertyType()
	 * @generated
	 */
	EAttribute getCIAddressPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIAddressPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.CIAddressPropertyType#getHref()
	 * @see #getCIAddressPropertyType()
	 * @generated
	 */
	EAttribute getCIAddressPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIAddressPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.CIAddressPropertyType#getNilReason()
	 * @see #getCIAddressPropertyType()
	 * @generated
	 */
	EAttribute getCIAddressPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIAddressPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.CIAddressPropertyType#getRole()
	 * @see #getCIAddressPropertyType()
	 * @generated
	 */
	EAttribute getCIAddressPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIAddressPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.CIAddressPropertyType#getShow()
	 * @see #getCIAddressPropertyType()
	 * @generated
	 */
	EAttribute getCIAddressPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIAddressPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.CIAddressPropertyType#getTitle()
	 * @see #getCIAddressPropertyType()
	 * @generated
	 */
	EAttribute getCIAddressPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIAddressPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.CIAddressPropertyType#getType()
	 * @see #getCIAddressPropertyType()
	 * @generated
	 */
	EAttribute getCIAddressPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIAddressPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.CIAddressPropertyType#getUuidref()
	 * @see #getCIAddressPropertyType()
	 * @generated
	 */
	EAttribute getCIAddressPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CIAddressType <em>CI Address Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Address Type</em>'.
	 * @see org.isotc211._2005.gmd.CIAddressType
	 * @generated
	 */
	EClass getCIAddressType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.CIAddressType#getDeliveryPoint <em>Delivery Point</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Delivery Point</em>'.
	 * @see org.isotc211._2005.gmd.CIAddressType#getDeliveryPoint()
	 * @see #getCIAddressType()
	 * @generated
	 */
	EReference getCIAddressType_DeliveryPoint();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIAddressType#getCity <em>City</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>City</em>'.
	 * @see org.isotc211._2005.gmd.CIAddressType#getCity()
	 * @see #getCIAddressType()
	 * @generated
	 */
	EReference getCIAddressType_City();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIAddressType#getAdministrativeArea <em>Administrative Area</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Administrative Area</em>'.
	 * @see org.isotc211._2005.gmd.CIAddressType#getAdministrativeArea()
	 * @see #getCIAddressType()
	 * @generated
	 */
	EReference getCIAddressType_AdministrativeArea();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIAddressType#getPostalCode <em>Postal Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Postal Code</em>'.
	 * @see org.isotc211._2005.gmd.CIAddressType#getPostalCode()
	 * @see #getCIAddressType()
	 * @generated
	 */
	EReference getCIAddressType_PostalCode();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIAddressType#getCountry <em>Country</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Country</em>'.
	 * @see org.isotc211._2005.gmd.CIAddressType#getCountry()
	 * @see #getCIAddressType()
	 * @generated
	 */
	EReference getCIAddressType_Country();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.CIAddressType#getElectronicMailAddress <em>Electronic Mail Address</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Electronic Mail Address</em>'.
	 * @see org.isotc211._2005.gmd.CIAddressType#getElectronicMailAddress()
	 * @see #getCIAddressType()
	 * @generated
	 */
	EReference getCIAddressType_ElectronicMailAddress();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CICitationPropertyType <em>CI Citation Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Citation Property Type</em>'.
	 * @see org.isotc211._2005.gmd.CICitationPropertyType
	 * @generated
	 */
	EClass getCICitationPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CICitationPropertyType#getCICitation <em>CI Citation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>CI Citation</em>'.
	 * @see org.isotc211._2005.gmd.CICitationPropertyType#getCICitation()
	 * @see #getCICitationPropertyType()
	 * @generated
	 */
	EReference getCICitationPropertyType_CICitation();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CICitationPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.CICitationPropertyType#getActuate()
	 * @see #getCICitationPropertyType()
	 * @generated
	 */
	EAttribute getCICitationPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CICitationPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.CICitationPropertyType#getArcrole()
	 * @see #getCICitationPropertyType()
	 * @generated
	 */
	EAttribute getCICitationPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CICitationPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.CICitationPropertyType#getHref()
	 * @see #getCICitationPropertyType()
	 * @generated
	 */
	EAttribute getCICitationPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CICitationPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.CICitationPropertyType#getNilReason()
	 * @see #getCICitationPropertyType()
	 * @generated
	 */
	EAttribute getCICitationPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CICitationPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.CICitationPropertyType#getRole()
	 * @see #getCICitationPropertyType()
	 * @generated
	 */
	EAttribute getCICitationPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CICitationPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.CICitationPropertyType#getShow()
	 * @see #getCICitationPropertyType()
	 * @generated
	 */
	EAttribute getCICitationPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CICitationPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.CICitationPropertyType#getTitle()
	 * @see #getCICitationPropertyType()
	 * @generated
	 */
	EAttribute getCICitationPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CICitationPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.CICitationPropertyType#getType()
	 * @see #getCICitationPropertyType()
	 * @generated
	 */
	EAttribute getCICitationPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CICitationPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.CICitationPropertyType#getUuidref()
	 * @see #getCICitationPropertyType()
	 * @generated
	 */
	EAttribute getCICitationPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CICitationType <em>CI Citation Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Citation Type</em>'.
	 * @see org.isotc211._2005.gmd.CICitationType
	 * @generated
	 */
	EClass getCICitationType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CICitationType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.CICitationType#getTitle()
	 * @see #getCICitationType()
	 * @generated
	 */
	EReference getCICitationType_Title();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.CICitationType#getAlternateTitle <em>Alternate Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Alternate Title</em>'.
	 * @see org.isotc211._2005.gmd.CICitationType#getAlternateTitle()
	 * @see #getCICitationType()
	 * @generated
	 */
	EReference getCICitationType_AlternateTitle();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.CICitationType#getDate <em>Date</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Date</em>'.
	 * @see org.isotc211._2005.gmd.CICitationType#getDate()
	 * @see #getCICitationType()
	 * @generated
	 */
	EReference getCICitationType_Date();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CICitationType#getEdition <em>Edition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Edition</em>'.
	 * @see org.isotc211._2005.gmd.CICitationType#getEdition()
	 * @see #getCICitationType()
	 * @generated
	 */
	EReference getCICitationType_Edition();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CICitationType#getEditionDate <em>Edition Date</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Edition Date</em>'.
	 * @see org.isotc211._2005.gmd.CICitationType#getEditionDate()
	 * @see #getCICitationType()
	 * @generated
	 */
	EReference getCICitationType_EditionDate();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.CICitationType#getIdentifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Identifier</em>'.
	 * @see org.isotc211._2005.gmd.CICitationType#getIdentifier()
	 * @see #getCICitationType()
	 * @generated
	 */
	EReference getCICitationType_Identifier();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.CICitationType#getCitedResponsibleParty <em>Cited Responsible Party</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Cited Responsible Party</em>'.
	 * @see org.isotc211._2005.gmd.CICitationType#getCitedResponsibleParty()
	 * @see #getCICitationType()
	 * @generated
	 */
	EReference getCICitationType_CitedResponsibleParty();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.CICitationType#getPresentationForm <em>Presentation Form</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Presentation Form</em>'.
	 * @see org.isotc211._2005.gmd.CICitationType#getPresentationForm()
	 * @see #getCICitationType()
	 * @generated
	 */
	EReference getCICitationType_PresentationForm();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CICitationType#getSeries <em>Series</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Series</em>'.
	 * @see org.isotc211._2005.gmd.CICitationType#getSeries()
	 * @see #getCICitationType()
	 * @generated
	 */
	EReference getCICitationType_Series();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CICitationType#getOtherCitationDetails <em>Other Citation Details</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Other Citation Details</em>'.
	 * @see org.isotc211._2005.gmd.CICitationType#getOtherCitationDetails()
	 * @see #getCICitationType()
	 * @generated
	 */
	EReference getCICitationType_OtherCitationDetails();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CICitationType#getCollectiveTitle <em>Collective Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Collective Title</em>'.
	 * @see org.isotc211._2005.gmd.CICitationType#getCollectiveTitle()
	 * @see #getCICitationType()
	 * @generated
	 */
	EReference getCICitationType_CollectiveTitle();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CICitationType#getISBN <em>ISBN</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>ISBN</em>'.
	 * @see org.isotc211._2005.gmd.CICitationType#getISBN()
	 * @see #getCICitationType()
	 * @generated
	 */
	EReference getCICitationType_ISBN();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CICitationType#getISSN <em>ISSN</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>ISSN</em>'.
	 * @see org.isotc211._2005.gmd.CICitationType#getISSN()
	 * @see #getCICitationType()
	 * @generated
	 */
	EReference getCICitationType_ISSN();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CIContactPropertyType <em>CI Contact Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Contact Property Type</em>'.
	 * @see org.isotc211._2005.gmd.CIContactPropertyType
	 * @generated
	 */
	EClass getCIContactPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIContactPropertyType#getCIContact <em>CI Contact</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>CI Contact</em>'.
	 * @see org.isotc211._2005.gmd.CIContactPropertyType#getCIContact()
	 * @see #getCIContactPropertyType()
	 * @generated
	 */
	EReference getCIContactPropertyType_CIContact();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIContactPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.CIContactPropertyType#getActuate()
	 * @see #getCIContactPropertyType()
	 * @generated
	 */
	EAttribute getCIContactPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIContactPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.CIContactPropertyType#getArcrole()
	 * @see #getCIContactPropertyType()
	 * @generated
	 */
	EAttribute getCIContactPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIContactPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.CIContactPropertyType#getHref()
	 * @see #getCIContactPropertyType()
	 * @generated
	 */
	EAttribute getCIContactPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIContactPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.CIContactPropertyType#getNilReason()
	 * @see #getCIContactPropertyType()
	 * @generated
	 */
	EAttribute getCIContactPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIContactPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.CIContactPropertyType#getRole()
	 * @see #getCIContactPropertyType()
	 * @generated
	 */
	EAttribute getCIContactPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIContactPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.CIContactPropertyType#getShow()
	 * @see #getCIContactPropertyType()
	 * @generated
	 */
	EAttribute getCIContactPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIContactPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.CIContactPropertyType#getTitle()
	 * @see #getCIContactPropertyType()
	 * @generated
	 */
	EAttribute getCIContactPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIContactPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.CIContactPropertyType#getType()
	 * @see #getCIContactPropertyType()
	 * @generated
	 */
	EAttribute getCIContactPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIContactPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.CIContactPropertyType#getUuidref()
	 * @see #getCIContactPropertyType()
	 * @generated
	 */
	EAttribute getCIContactPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CIContactType <em>CI Contact Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Contact Type</em>'.
	 * @see org.isotc211._2005.gmd.CIContactType
	 * @generated
	 */
	EClass getCIContactType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIContactType#getPhone <em>Phone</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Phone</em>'.
	 * @see org.isotc211._2005.gmd.CIContactType#getPhone()
	 * @see #getCIContactType()
	 * @generated
	 */
	EReference getCIContactType_Phone();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIContactType#getAddress <em>Address</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Address</em>'.
	 * @see org.isotc211._2005.gmd.CIContactType#getAddress()
	 * @see #getCIContactType()
	 * @generated
	 */
	EReference getCIContactType_Address();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIContactType#getOnlineResource <em>Online Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Online Resource</em>'.
	 * @see org.isotc211._2005.gmd.CIContactType#getOnlineResource()
	 * @see #getCIContactType()
	 * @generated
	 */
	EReference getCIContactType_OnlineResource();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIContactType#getHoursOfService <em>Hours Of Service</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Hours Of Service</em>'.
	 * @see org.isotc211._2005.gmd.CIContactType#getHoursOfService()
	 * @see #getCIContactType()
	 * @generated
	 */
	EReference getCIContactType_HoursOfService();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIContactType#getContactInstructions <em>Contact Instructions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Contact Instructions</em>'.
	 * @see org.isotc211._2005.gmd.CIContactType#getContactInstructions()
	 * @see #getCIContactType()
	 * @generated
	 */
	EReference getCIContactType_ContactInstructions();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CIDatePropertyType <em>CI Date Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Date Property Type</em>'.
	 * @see org.isotc211._2005.gmd.CIDatePropertyType
	 * @generated
	 */
	EClass getCIDatePropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIDatePropertyType#getCIDate <em>CI Date</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>CI Date</em>'.
	 * @see org.isotc211._2005.gmd.CIDatePropertyType#getCIDate()
	 * @see #getCIDatePropertyType()
	 * @generated
	 */
	EReference getCIDatePropertyType_CIDate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIDatePropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.CIDatePropertyType#getActuate()
	 * @see #getCIDatePropertyType()
	 * @generated
	 */
	EAttribute getCIDatePropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIDatePropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.CIDatePropertyType#getArcrole()
	 * @see #getCIDatePropertyType()
	 * @generated
	 */
	EAttribute getCIDatePropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIDatePropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.CIDatePropertyType#getHref()
	 * @see #getCIDatePropertyType()
	 * @generated
	 */
	EAttribute getCIDatePropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIDatePropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.CIDatePropertyType#getNilReason()
	 * @see #getCIDatePropertyType()
	 * @generated
	 */
	EAttribute getCIDatePropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIDatePropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.CIDatePropertyType#getRole()
	 * @see #getCIDatePropertyType()
	 * @generated
	 */
	EAttribute getCIDatePropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIDatePropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.CIDatePropertyType#getShow()
	 * @see #getCIDatePropertyType()
	 * @generated
	 */
	EAttribute getCIDatePropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIDatePropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.CIDatePropertyType#getTitle()
	 * @see #getCIDatePropertyType()
	 * @generated
	 */
	EAttribute getCIDatePropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIDatePropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.CIDatePropertyType#getType()
	 * @see #getCIDatePropertyType()
	 * @generated
	 */
	EAttribute getCIDatePropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIDatePropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.CIDatePropertyType#getUuidref()
	 * @see #getCIDatePropertyType()
	 * @generated
	 */
	EAttribute getCIDatePropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CIDateType <em>CI Date Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Date Type</em>'.
	 * @see org.isotc211._2005.gmd.CIDateType
	 * @generated
	 */
	EClass getCIDateType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIDateType#getDate <em>Date</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Date</em>'.
	 * @see org.isotc211._2005.gmd.CIDateType#getDate()
	 * @see #getCIDateType()
	 * @generated
	 */
	EReference getCIDateType_Date();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIDateType#getDateType <em>Date Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Date Type</em>'.
	 * @see org.isotc211._2005.gmd.CIDateType#getDateType()
	 * @see #getCIDateType()
	 * @generated
	 */
	EReference getCIDateType_DateType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CIDateTypeCodePropertyType <em>CI Date Type Code Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Date Type Code Property Type</em>'.
	 * @see org.isotc211._2005.gmd.CIDateTypeCodePropertyType
	 * @generated
	 */
	EClass getCIDateTypeCodePropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIDateTypeCodePropertyType#getCIDateTypeCode <em>CI Date Type Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>CI Date Type Code</em>'.
	 * @see org.isotc211._2005.gmd.CIDateTypeCodePropertyType#getCIDateTypeCode()
	 * @see #getCIDateTypeCodePropertyType()
	 * @generated
	 */
	EReference getCIDateTypeCodePropertyType_CIDateTypeCode();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIDateTypeCodePropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.CIDateTypeCodePropertyType#getNilReason()
	 * @see #getCIDateTypeCodePropertyType()
	 * @generated
	 */
	EAttribute getCIDateTypeCodePropertyType_NilReason();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CIOnLineFunctionCodePropertyType <em>CI On Line Function Code Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI On Line Function Code Property Type</em>'.
	 * @see org.isotc211._2005.gmd.CIOnLineFunctionCodePropertyType
	 * @generated
	 */
	EClass getCIOnLineFunctionCodePropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIOnLineFunctionCodePropertyType#getCIOnLineFunctionCode <em>CI On Line Function Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>CI On Line Function Code</em>'.
	 * @see org.isotc211._2005.gmd.CIOnLineFunctionCodePropertyType#getCIOnLineFunctionCode()
	 * @see #getCIOnLineFunctionCodePropertyType()
	 * @generated
	 */
	EReference getCIOnLineFunctionCodePropertyType_CIOnLineFunctionCode();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIOnLineFunctionCodePropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.CIOnLineFunctionCodePropertyType#getNilReason()
	 * @see #getCIOnLineFunctionCodePropertyType()
	 * @generated
	 */
	EAttribute getCIOnLineFunctionCodePropertyType_NilReason();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CIOnlineResourcePropertyType <em>CI Online Resource Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Online Resource Property Type</em>'.
	 * @see org.isotc211._2005.gmd.CIOnlineResourcePropertyType
	 * @generated
	 */
	EClass getCIOnlineResourcePropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getCIOnlineResource <em>CI Online Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>CI Online Resource</em>'.
	 * @see org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getCIOnlineResource()
	 * @see #getCIOnlineResourcePropertyType()
	 * @generated
	 */
	EReference getCIOnlineResourcePropertyType_CIOnlineResource();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getActuate()
	 * @see #getCIOnlineResourcePropertyType()
	 * @generated
	 */
	EAttribute getCIOnlineResourcePropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getArcrole()
	 * @see #getCIOnlineResourcePropertyType()
	 * @generated
	 */
	EAttribute getCIOnlineResourcePropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getHref()
	 * @see #getCIOnlineResourcePropertyType()
	 * @generated
	 */
	EAttribute getCIOnlineResourcePropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getNilReason()
	 * @see #getCIOnlineResourcePropertyType()
	 * @generated
	 */
	EAttribute getCIOnlineResourcePropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getRole()
	 * @see #getCIOnlineResourcePropertyType()
	 * @generated
	 */
	EAttribute getCIOnlineResourcePropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getShow()
	 * @see #getCIOnlineResourcePropertyType()
	 * @generated
	 */
	EAttribute getCIOnlineResourcePropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getTitle()
	 * @see #getCIOnlineResourcePropertyType()
	 * @generated
	 */
	EAttribute getCIOnlineResourcePropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getType()
	 * @see #getCIOnlineResourcePropertyType()
	 * @generated
	 */
	EAttribute getCIOnlineResourcePropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.CIOnlineResourcePropertyType#getUuidref()
	 * @see #getCIOnlineResourcePropertyType()
	 * @generated
	 */
	EAttribute getCIOnlineResourcePropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CIOnlineResourceType <em>CI Online Resource Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Online Resource Type</em>'.
	 * @see org.isotc211._2005.gmd.CIOnlineResourceType
	 * @generated
	 */
	EClass getCIOnlineResourceType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIOnlineResourceType#getLinkage <em>Linkage</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Linkage</em>'.
	 * @see org.isotc211._2005.gmd.CIOnlineResourceType#getLinkage()
	 * @see #getCIOnlineResourceType()
	 * @generated
	 */
	EReference getCIOnlineResourceType_Linkage();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIOnlineResourceType#getProtocol <em>Protocol</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Protocol</em>'.
	 * @see org.isotc211._2005.gmd.CIOnlineResourceType#getProtocol()
	 * @see #getCIOnlineResourceType()
	 * @generated
	 */
	EReference getCIOnlineResourceType_Protocol();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIOnlineResourceType#getApplicationProfile <em>Application Profile</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Application Profile</em>'.
	 * @see org.isotc211._2005.gmd.CIOnlineResourceType#getApplicationProfile()
	 * @see #getCIOnlineResourceType()
	 * @generated
	 */
	EReference getCIOnlineResourceType_ApplicationProfile();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIOnlineResourceType#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Name</em>'.
	 * @see org.isotc211._2005.gmd.CIOnlineResourceType#getName()
	 * @see #getCIOnlineResourceType()
	 * @generated
	 */
	EReference getCIOnlineResourceType_Name();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIOnlineResourceType#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Description</em>'.
	 * @see org.isotc211._2005.gmd.CIOnlineResourceType#getDescription()
	 * @see #getCIOnlineResourceType()
	 * @generated
	 */
	EReference getCIOnlineResourceType_Description();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIOnlineResourceType#getFunction <em>Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Function</em>'.
	 * @see org.isotc211._2005.gmd.CIOnlineResourceType#getFunction()
	 * @see #getCIOnlineResourceType()
	 * @generated
	 */
	EReference getCIOnlineResourceType_Function();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CIPresentationFormCodePropertyType <em>CI Presentation Form Code Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Presentation Form Code Property Type</em>'.
	 * @see org.isotc211._2005.gmd.CIPresentationFormCodePropertyType
	 * @generated
	 */
	EClass getCIPresentationFormCodePropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIPresentationFormCodePropertyType#getCIPresentationFormCode <em>CI Presentation Form Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>CI Presentation Form Code</em>'.
	 * @see org.isotc211._2005.gmd.CIPresentationFormCodePropertyType#getCIPresentationFormCode()
	 * @see #getCIPresentationFormCodePropertyType()
	 * @generated
	 */
	EReference getCIPresentationFormCodePropertyType_CIPresentationFormCode();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIPresentationFormCodePropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.CIPresentationFormCodePropertyType#getNilReason()
	 * @see #getCIPresentationFormCodePropertyType()
	 * @generated
	 */
	EAttribute getCIPresentationFormCodePropertyType_NilReason();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CIResponsiblePartyPropertyType <em>CI Responsible Party Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Responsible Party Property Type</em>'.
	 * @see org.isotc211._2005.gmd.CIResponsiblePartyPropertyType
	 * @generated
	 */
	EClass getCIResponsiblePartyPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getCIResponsibleParty <em>CI Responsible Party</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>CI Responsible Party</em>'.
	 * @see org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getCIResponsibleParty()
	 * @see #getCIResponsiblePartyPropertyType()
	 * @generated
	 */
	EReference getCIResponsiblePartyPropertyType_CIResponsibleParty();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getActuate()
	 * @see #getCIResponsiblePartyPropertyType()
	 * @generated
	 */
	EAttribute getCIResponsiblePartyPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getArcrole()
	 * @see #getCIResponsiblePartyPropertyType()
	 * @generated
	 */
	EAttribute getCIResponsiblePartyPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getHref()
	 * @see #getCIResponsiblePartyPropertyType()
	 * @generated
	 */
	EAttribute getCIResponsiblePartyPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getNilReason()
	 * @see #getCIResponsiblePartyPropertyType()
	 * @generated
	 */
	EAttribute getCIResponsiblePartyPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getRole()
	 * @see #getCIResponsiblePartyPropertyType()
	 * @generated
	 */
	EAttribute getCIResponsiblePartyPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getShow()
	 * @see #getCIResponsiblePartyPropertyType()
	 * @generated
	 */
	EAttribute getCIResponsiblePartyPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getTitle()
	 * @see #getCIResponsiblePartyPropertyType()
	 * @generated
	 */
	EAttribute getCIResponsiblePartyPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getType()
	 * @see #getCIResponsiblePartyPropertyType()
	 * @generated
	 */
	EAttribute getCIResponsiblePartyPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.CIResponsiblePartyPropertyType#getUuidref()
	 * @see #getCIResponsiblePartyPropertyType()
	 * @generated
	 */
	EAttribute getCIResponsiblePartyPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CIResponsiblePartyType <em>CI Responsible Party Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Responsible Party Type</em>'.
	 * @see org.isotc211._2005.gmd.CIResponsiblePartyType
	 * @generated
	 */
	EClass getCIResponsiblePartyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIResponsiblePartyType#getIndividualName <em>Individual Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Individual Name</em>'.
	 * @see org.isotc211._2005.gmd.CIResponsiblePartyType#getIndividualName()
	 * @see #getCIResponsiblePartyType()
	 * @generated
	 */
	EReference getCIResponsiblePartyType_IndividualName();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIResponsiblePartyType#getOrganisationName <em>Organisation Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Organisation Name</em>'.
	 * @see org.isotc211._2005.gmd.CIResponsiblePartyType#getOrganisationName()
	 * @see #getCIResponsiblePartyType()
	 * @generated
	 */
	EReference getCIResponsiblePartyType_OrganisationName();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIResponsiblePartyType#getPositionName <em>Position Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Position Name</em>'.
	 * @see org.isotc211._2005.gmd.CIResponsiblePartyType#getPositionName()
	 * @see #getCIResponsiblePartyType()
	 * @generated
	 */
	EReference getCIResponsiblePartyType_PositionName();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIResponsiblePartyType#getContactInfo <em>Contact Info</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Contact Info</em>'.
	 * @see org.isotc211._2005.gmd.CIResponsiblePartyType#getContactInfo()
	 * @see #getCIResponsiblePartyType()
	 * @generated
	 */
	EReference getCIResponsiblePartyType_ContactInfo();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIResponsiblePartyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.CIResponsiblePartyType#getRole()
	 * @see #getCIResponsiblePartyType()
	 * @generated
	 */
	EReference getCIResponsiblePartyType_Role();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CIRoleCodePropertyType <em>CI Role Code Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Role Code Property Type</em>'.
	 * @see org.isotc211._2005.gmd.CIRoleCodePropertyType
	 * @generated
	 */
	EClass getCIRoleCodePropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CIRoleCodePropertyType#getCIRoleCode <em>CI Role Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>CI Role Code</em>'.
	 * @see org.isotc211._2005.gmd.CIRoleCodePropertyType#getCIRoleCode()
	 * @see #getCIRoleCodePropertyType()
	 * @generated
	 */
	EReference getCIRoleCodePropertyType_CIRoleCode();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CIRoleCodePropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.CIRoleCodePropertyType#getNilReason()
	 * @see #getCIRoleCodePropertyType()
	 * @generated
	 */
	EAttribute getCIRoleCodePropertyType_NilReason();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CISeriesPropertyType <em>CI Series Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Series Property Type</em>'.
	 * @see org.isotc211._2005.gmd.CISeriesPropertyType
	 * @generated
	 */
	EClass getCISeriesPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CISeriesPropertyType#getCISeries <em>CI Series</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>CI Series</em>'.
	 * @see org.isotc211._2005.gmd.CISeriesPropertyType#getCISeries()
	 * @see #getCISeriesPropertyType()
	 * @generated
	 */
	EReference getCISeriesPropertyType_CISeries();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CISeriesPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.CISeriesPropertyType#getActuate()
	 * @see #getCISeriesPropertyType()
	 * @generated
	 */
	EAttribute getCISeriesPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CISeriesPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.CISeriesPropertyType#getArcrole()
	 * @see #getCISeriesPropertyType()
	 * @generated
	 */
	EAttribute getCISeriesPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CISeriesPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.CISeriesPropertyType#getHref()
	 * @see #getCISeriesPropertyType()
	 * @generated
	 */
	EAttribute getCISeriesPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CISeriesPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.CISeriesPropertyType#getNilReason()
	 * @see #getCISeriesPropertyType()
	 * @generated
	 */
	EAttribute getCISeriesPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CISeriesPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.CISeriesPropertyType#getRole()
	 * @see #getCISeriesPropertyType()
	 * @generated
	 */
	EAttribute getCISeriesPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CISeriesPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.CISeriesPropertyType#getShow()
	 * @see #getCISeriesPropertyType()
	 * @generated
	 */
	EAttribute getCISeriesPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CISeriesPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.CISeriesPropertyType#getTitle()
	 * @see #getCISeriesPropertyType()
	 * @generated
	 */
	EAttribute getCISeriesPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CISeriesPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.CISeriesPropertyType#getType()
	 * @see #getCISeriesPropertyType()
	 * @generated
	 */
	EAttribute getCISeriesPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CISeriesPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.CISeriesPropertyType#getUuidref()
	 * @see #getCISeriesPropertyType()
	 * @generated
	 */
	EAttribute getCISeriesPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CISeriesType <em>CI Series Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Series Type</em>'.
	 * @see org.isotc211._2005.gmd.CISeriesType
	 * @generated
	 */
	EClass getCISeriesType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CISeriesType#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Name</em>'.
	 * @see org.isotc211._2005.gmd.CISeriesType#getName()
	 * @see #getCISeriesType()
	 * @generated
	 */
	EReference getCISeriesType_Name();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CISeriesType#getIssueIdentification <em>Issue Identification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Issue Identification</em>'.
	 * @see org.isotc211._2005.gmd.CISeriesType#getIssueIdentification()
	 * @see #getCISeriesType()
	 * @generated
	 */
	EReference getCISeriesType_IssueIdentification();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CISeriesType#getPage <em>Page</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Page</em>'.
	 * @see org.isotc211._2005.gmd.CISeriesType#getPage()
	 * @see #getCISeriesType()
	 * @generated
	 */
	EReference getCISeriesType_Page();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CITelephonePropertyType <em>CI Telephone Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Telephone Property Type</em>'.
	 * @see org.isotc211._2005.gmd.CITelephonePropertyType
	 * @generated
	 */
	EClass getCITelephonePropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CITelephonePropertyType#getCITelephone <em>CI Telephone</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>CI Telephone</em>'.
	 * @see org.isotc211._2005.gmd.CITelephonePropertyType#getCITelephone()
	 * @see #getCITelephonePropertyType()
	 * @generated
	 */
	EReference getCITelephonePropertyType_CITelephone();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CITelephonePropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.CITelephonePropertyType#getActuate()
	 * @see #getCITelephonePropertyType()
	 * @generated
	 */
	EAttribute getCITelephonePropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CITelephonePropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.CITelephonePropertyType#getArcrole()
	 * @see #getCITelephonePropertyType()
	 * @generated
	 */
	EAttribute getCITelephonePropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CITelephonePropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.CITelephonePropertyType#getHref()
	 * @see #getCITelephonePropertyType()
	 * @generated
	 */
	EAttribute getCITelephonePropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CITelephonePropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.CITelephonePropertyType#getNilReason()
	 * @see #getCITelephonePropertyType()
	 * @generated
	 */
	EAttribute getCITelephonePropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CITelephonePropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.CITelephonePropertyType#getRole()
	 * @see #getCITelephonePropertyType()
	 * @generated
	 */
	EAttribute getCITelephonePropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CITelephonePropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.CITelephonePropertyType#getShow()
	 * @see #getCITelephonePropertyType()
	 * @generated
	 */
	EAttribute getCITelephonePropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CITelephonePropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.CITelephonePropertyType#getTitle()
	 * @see #getCITelephonePropertyType()
	 * @generated
	 */
	EAttribute getCITelephonePropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CITelephonePropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.CITelephonePropertyType#getType()
	 * @see #getCITelephonePropertyType()
	 * @generated
	 */
	EAttribute getCITelephonePropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CITelephonePropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.CITelephonePropertyType#getUuidref()
	 * @see #getCITelephonePropertyType()
	 * @generated
	 */
	EAttribute getCITelephonePropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CITelephoneType <em>CI Telephone Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CI Telephone Type</em>'.
	 * @see org.isotc211._2005.gmd.CITelephoneType
	 * @generated
	 */
	EClass getCITelephoneType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.CITelephoneType#getVoice <em>Voice</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Voice</em>'.
	 * @see org.isotc211._2005.gmd.CITelephoneType#getVoice()
	 * @see #getCITelephoneType()
	 * @generated
	 */
	EReference getCITelephoneType_Voice();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.CITelephoneType#getFacsimile <em>Facsimile</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Facsimile</em>'.
	 * @see org.isotc211._2005.gmd.CITelephoneType#getFacsimile()
	 * @see #getCITelephoneType()
	 * @generated
	 */
	EReference getCITelephoneType_Facsimile();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.CountryPropertyType <em>Country Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Country Property Type</em>'.
	 * @see org.isotc211._2005.gmd.CountryPropertyType
	 * @generated
	 */
	EClass getCountryPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.CountryPropertyType#getCountry <em>Country</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Country</em>'.
	 * @see org.isotc211._2005.gmd.CountryPropertyType#getCountry()
	 * @see #getCountryPropertyType()
	 * @generated
	 */
	EReference getCountryPropertyType_Country();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.CountryPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.CountryPropertyType#getNilReason()
	 * @see #getCountryPropertyType()
	 * @generated
	 */
	EAttribute getCountryPropertyType_NilReason();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType <em>DQ Absolute External Positional Accuracy Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Absolute External Positional Accuracy Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType
	 * @generated
	 */
	EClass getDQAbsoluteExternalPositionalAccuracyPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getDQAbsoluteExternalPositionalAccuracy <em>DQ Absolute External Positional Accuracy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Absolute External Positional Accuracy</em>'.
	 * @see org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getDQAbsoluteExternalPositionalAccuracy()
	 * @see #getDQAbsoluteExternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EReference getDQAbsoluteExternalPositionalAccuracyPropertyType_DQAbsoluteExternalPositionalAccuracy();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getActuate()
	 * @see #getDQAbsoluteExternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQAbsoluteExternalPositionalAccuracyPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getArcrole()
	 * @see #getDQAbsoluteExternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQAbsoluteExternalPositionalAccuracyPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getHref()
	 * @see #getDQAbsoluteExternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQAbsoluteExternalPositionalAccuracyPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getNilReason()
	 * @see #getDQAbsoluteExternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQAbsoluteExternalPositionalAccuracyPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getRole()
	 * @see #getDQAbsoluteExternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQAbsoluteExternalPositionalAccuracyPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getShow()
	 * @see #getDQAbsoluteExternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQAbsoluteExternalPositionalAccuracyPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getTitle()
	 * @see #getDQAbsoluteExternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQAbsoluteExternalPositionalAccuracyPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getType()
	 * @see #getDQAbsoluteExternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQAbsoluteExternalPositionalAccuracyPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyPropertyType#getUuidref()
	 * @see #getDQAbsoluteExternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQAbsoluteExternalPositionalAccuracyPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyType <em>DQ Absolute External Positional Accuracy Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Absolute External Positional Accuracy Type</em>'.
	 * @see org.isotc211._2005.gmd.DQAbsoluteExternalPositionalAccuracyType
	 * @generated
	 */
	EClass getDQAbsoluteExternalPositionalAccuracyType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType <em>DQ Accuracy Of ATime Measurement Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Accuracy Of ATime Measurement Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType
	 * @generated
	 */
	EClass getDQAccuracyOfATimeMeasurementPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getDQAccuracyOfATimeMeasurement <em>DQ Accuracy Of ATime Measurement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Accuracy Of ATime Measurement</em>'.
	 * @see org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getDQAccuracyOfATimeMeasurement()
	 * @see #getDQAccuracyOfATimeMeasurementPropertyType()
	 * @generated
	 */
	EReference getDQAccuracyOfATimeMeasurementPropertyType_DQAccuracyOfATimeMeasurement();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getActuate()
	 * @see #getDQAccuracyOfATimeMeasurementPropertyType()
	 * @generated
	 */
	EAttribute getDQAccuracyOfATimeMeasurementPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getArcrole()
	 * @see #getDQAccuracyOfATimeMeasurementPropertyType()
	 * @generated
	 */
	EAttribute getDQAccuracyOfATimeMeasurementPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getHref()
	 * @see #getDQAccuracyOfATimeMeasurementPropertyType()
	 * @generated
	 */
	EAttribute getDQAccuracyOfATimeMeasurementPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getNilReason()
	 * @see #getDQAccuracyOfATimeMeasurementPropertyType()
	 * @generated
	 */
	EAttribute getDQAccuracyOfATimeMeasurementPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getRole()
	 * @see #getDQAccuracyOfATimeMeasurementPropertyType()
	 * @generated
	 */
	EAttribute getDQAccuracyOfATimeMeasurementPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getShow()
	 * @see #getDQAccuracyOfATimeMeasurementPropertyType()
	 * @generated
	 */
	EAttribute getDQAccuracyOfATimeMeasurementPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getTitle()
	 * @see #getDQAccuracyOfATimeMeasurementPropertyType()
	 * @generated
	 */
	EAttribute getDQAccuracyOfATimeMeasurementPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getType()
	 * @see #getDQAccuracyOfATimeMeasurementPropertyType()
	 * @generated
	 */
	EAttribute getDQAccuracyOfATimeMeasurementPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementPropertyType#getUuidref()
	 * @see #getDQAccuracyOfATimeMeasurementPropertyType()
	 * @generated
	 */
	EAttribute getDQAccuracyOfATimeMeasurementPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementType <em>DQ Accuracy Of ATime Measurement Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Accuracy Of ATime Measurement Type</em>'.
	 * @see org.isotc211._2005.gmd.DQAccuracyOfATimeMeasurementType
	 * @generated
	 */
	EClass getDQAccuracyOfATimeMeasurementType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType <em>DQ Completeness Commission Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Completeness Commission Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType
	 * @generated
	 */
	EClass getDQCompletenessCommissionPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getDQCompletenessCommission <em>DQ Completeness Commission</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Completeness Commission</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getDQCompletenessCommission()
	 * @see #getDQCompletenessCommissionPropertyType()
	 * @generated
	 */
	EReference getDQCompletenessCommissionPropertyType_DQCompletenessCommission();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getActuate()
	 * @see #getDQCompletenessCommissionPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessCommissionPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getArcrole()
	 * @see #getDQCompletenessCommissionPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessCommissionPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getHref()
	 * @see #getDQCompletenessCommissionPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessCommissionPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getNilReason()
	 * @see #getDQCompletenessCommissionPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessCommissionPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getRole()
	 * @see #getDQCompletenessCommissionPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessCommissionPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getShow()
	 * @see #getDQCompletenessCommissionPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessCommissionPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getTitle()
	 * @see #getDQCompletenessCommissionPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessCommissionPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getType()
	 * @see #getDQCompletenessCommissionPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessCommissionPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessCommissionPropertyType#getUuidref()
	 * @see #getDQCompletenessCommissionPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessCommissionPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQCompletenessCommissionType <em>DQ Completeness Commission Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Completeness Commission Type</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessCommissionType
	 * @generated
	 */
	EClass getDQCompletenessCommissionType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType <em>DQ Completeness Omission Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Completeness Omission Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType
	 * @generated
	 */
	EClass getDQCompletenessOmissionPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getDQCompletenessOmission <em>DQ Completeness Omission</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Completeness Omission</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getDQCompletenessOmission()
	 * @see #getDQCompletenessOmissionPropertyType()
	 * @generated
	 */
	EReference getDQCompletenessOmissionPropertyType_DQCompletenessOmission();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getActuate()
	 * @see #getDQCompletenessOmissionPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessOmissionPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getArcrole()
	 * @see #getDQCompletenessOmissionPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessOmissionPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getHref()
	 * @see #getDQCompletenessOmissionPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessOmissionPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getNilReason()
	 * @see #getDQCompletenessOmissionPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessOmissionPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getRole()
	 * @see #getDQCompletenessOmissionPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessOmissionPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getShow()
	 * @see #getDQCompletenessOmissionPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessOmissionPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getTitle()
	 * @see #getDQCompletenessOmissionPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessOmissionPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getType()
	 * @see #getDQCompletenessOmissionPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessOmissionPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessOmissionPropertyType#getUuidref()
	 * @see #getDQCompletenessOmissionPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessOmissionPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQCompletenessOmissionType <em>DQ Completeness Omission Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Completeness Omission Type</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessOmissionType
	 * @generated
	 */
	EClass getDQCompletenessOmissionType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQCompletenessPropertyType <em>DQ Completeness Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Completeness Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessPropertyType
	 * @generated
	 */
	EClass getDQCompletenessPropertyType();

	/**
	 * Returns the meta object for the attribute list '{@link org.isotc211._2005.gmd.DQCompletenessPropertyType#getAbstractDQCompletenessGroup <em>Abstract DQ Completeness Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Abstract DQ Completeness Group</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessPropertyType#getAbstractDQCompletenessGroup()
	 * @see #getDQCompletenessPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessPropertyType_AbstractDQCompletenessGroup();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQCompletenessPropertyType#getAbstractDQCompleteness <em>Abstract DQ Completeness</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Abstract DQ Completeness</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessPropertyType#getAbstractDQCompleteness()
	 * @see #getDQCompletenessPropertyType()
	 * @generated
	 */
	EReference getDQCompletenessPropertyType_AbstractDQCompleteness();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessPropertyType#getActuate()
	 * @see #getDQCompletenessPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessPropertyType#getArcrole()
	 * @see #getDQCompletenessPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessPropertyType#getHref()
	 * @see #getDQCompletenessPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessPropertyType#getNilReason()
	 * @see #getDQCompletenessPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessPropertyType#getRole()
	 * @see #getDQCompletenessPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessPropertyType#getShow()
	 * @see #getDQCompletenessPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessPropertyType#getTitle()
	 * @see #getDQCompletenessPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessPropertyType#getType()
	 * @see #getDQCompletenessPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQCompletenessPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQCompletenessPropertyType#getUuidref()
	 * @see #getDQCompletenessPropertyType()
	 * @generated
	 */
	EAttribute getDQCompletenessPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType <em>DQ Conceptual Consistency Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Conceptual Consistency Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType
	 * @generated
	 */
	EClass getDQConceptualConsistencyPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getDQConceptualConsistency <em>DQ Conceptual Consistency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Conceptual Consistency</em>'.
	 * @see org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getDQConceptualConsistency()
	 * @see #getDQConceptualConsistencyPropertyType()
	 * @generated
	 */
	EReference getDQConceptualConsistencyPropertyType_DQConceptualConsistency();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getActuate()
	 * @see #getDQConceptualConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQConceptualConsistencyPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getArcrole()
	 * @see #getDQConceptualConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQConceptualConsistencyPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getHref()
	 * @see #getDQConceptualConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQConceptualConsistencyPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getNilReason()
	 * @see #getDQConceptualConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQConceptualConsistencyPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getRole()
	 * @see #getDQConceptualConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQConceptualConsistencyPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getShow()
	 * @see #getDQConceptualConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQConceptualConsistencyPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getTitle()
	 * @see #getDQConceptualConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQConceptualConsistencyPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getType()
	 * @see #getDQConceptualConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQConceptualConsistencyPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQConceptualConsistencyPropertyType#getUuidref()
	 * @see #getDQConceptualConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQConceptualConsistencyPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQConceptualConsistencyType <em>DQ Conceptual Consistency Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Conceptual Consistency Type</em>'.
	 * @see org.isotc211._2005.gmd.DQConceptualConsistencyType
	 * @generated
	 */
	EClass getDQConceptualConsistencyType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQConformanceResultPropertyType <em>DQ Conformance Result Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Conformance Result Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQConformanceResultPropertyType
	 * @generated
	 */
	EClass getDQConformanceResultPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQConformanceResultPropertyType#getDQConformanceResult <em>DQ Conformance Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Conformance Result</em>'.
	 * @see org.isotc211._2005.gmd.DQConformanceResultPropertyType#getDQConformanceResult()
	 * @see #getDQConformanceResultPropertyType()
	 * @generated
	 */
	EReference getDQConformanceResultPropertyType_DQConformanceResult();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQConformanceResultPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQConformanceResultPropertyType#getActuate()
	 * @see #getDQConformanceResultPropertyType()
	 * @generated
	 */
	EAttribute getDQConformanceResultPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQConformanceResultPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQConformanceResultPropertyType#getArcrole()
	 * @see #getDQConformanceResultPropertyType()
	 * @generated
	 */
	EAttribute getDQConformanceResultPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQConformanceResultPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQConformanceResultPropertyType#getHref()
	 * @see #getDQConformanceResultPropertyType()
	 * @generated
	 */
	EAttribute getDQConformanceResultPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQConformanceResultPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQConformanceResultPropertyType#getNilReason()
	 * @see #getDQConformanceResultPropertyType()
	 * @generated
	 */
	EAttribute getDQConformanceResultPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQConformanceResultPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQConformanceResultPropertyType#getRole()
	 * @see #getDQConformanceResultPropertyType()
	 * @generated
	 */
	EAttribute getDQConformanceResultPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQConformanceResultPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQConformanceResultPropertyType#getShow()
	 * @see #getDQConformanceResultPropertyType()
	 * @generated
	 */
	EAttribute getDQConformanceResultPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQConformanceResultPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQConformanceResultPropertyType#getTitle()
	 * @see #getDQConformanceResultPropertyType()
	 * @generated
	 */
	EAttribute getDQConformanceResultPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQConformanceResultPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQConformanceResultPropertyType#getType()
	 * @see #getDQConformanceResultPropertyType()
	 * @generated
	 */
	EAttribute getDQConformanceResultPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQConformanceResultPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQConformanceResultPropertyType#getUuidref()
	 * @see #getDQConformanceResultPropertyType()
	 * @generated
	 */
	EAttribute getDQConformanceResultPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQConformanceResultType <em>DQ Conformance Result Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Conformance Result Type</em>'.
	 * @see org.isotc211._2005.gmd.DQConformanceResultType
	 * @generated
	 */
	EClass getDQConformanceResultType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQConformanceResultType#getSpecification <em>Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Specification</em>'.
	 * @see org.isotc211._2005.gmd.DQConformanceResultType#getSpecification()
	 * @see #getDQConformanceResultType()
	 * @generated
	 */
	EReference getDQConformanceResultType_Specification();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQConformanceResultType#getExplanation <em>Explanation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Explanation</em>'.
	 * @see org.isotc211._2005.gmd.DQConformanceResultType#getExplanation()
	 * @see #getDQConformanceResultType()
	 * @generated
	 */
	EReference getDQConformanceResultType_Explanation();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQConformanceResultType#getPass <em>Pass</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Pass</em>'.
	 * @see org.isotc211._2005.gmd.DQConformanceResultType#getPass()
	 * @see #getDQConformanceResultType()
	 * @generated
	 */
	EReference getDQConformanceResultType_Pass();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQDataQualityPropertyType <em>DQ Data Quality Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Data Quality Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQDataQualityPropertyType
	 * @generated
	 */
	EClass getDQDataQualityPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQDataQualityPropertyType#getDQDataQuality <em>DQ Data Quality</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Data Quality</em>'.
	 * @see org.isotc211._2005.gmd.DQDataQualityPropertyType#getDQDataQuality()
	 * @see #getDQDataQualityPropertyType()
	 * @generated
	 */
	EReference getDQDataQualityPropertyType_DQDataQuality();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQDataQualityPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQDataQualityPropertyType#getActuate()
	 * @see #getDQDataQualityPropertyType()
	 * @generated
	 */
	EAttribute getDQDataQualityPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQDataQualityPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQDataQualityPropertyType#getArcrole()
	 * @see #getDQDataQualityPropertyType()
	 * @generated
	 */
	EAttribute getDQDataQualityPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQDataQualityPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQDataQualityPropertyType#getHref()
	 * @see #getDQDataQualityPropertyType()
	 * @generated
	 */
	EAttribute getDQDataQualityPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQDataQualityPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQDataQualityPropertyType#getNilReason()
	 * @see #getDQDataQualityPropertyType()
	 * @generated
	 */
	EAttribute getDQDataQualityPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQDataQualityPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQDataQualityPropertyType#getRole()
	 * @see #getDQDataQualityPropertyType()
	 * @generated
	 */
	EAttribute getDQDataQualityPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQDataQualityPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQDataQualityPropertyType#getShow()
	 * @see #getDQDataQualityPropertyType()
	 * @generated
	 */
	EAttribute getDQDataQualityPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQDataQualityPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQDataQualityPropertyType#getTitle()
	 * @see #getDQDataQualityPropertyType()
	 * @generated
	 */
	EAttribute getDQDataQualityPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQDataQualityPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQDataQualityPropertyType#getType()
	 * @see #getDQDataQualityPropertyType()
	 * @generated
	 */
	EAttribute getDQDataQualityPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQDataQualityPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQDataQualityPropertyType#getUuidref()
	 * @see #getDQDataQualityPropertyType()
	 * @generated
	 */
	EAttribute getDQDataQualityPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQDataQualityType <em>DQ Data Quality Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Data Quality Type</em>'.
	 * @see org.isotc211._2005.gmd.DQDataQualityType
	 * @generated
	 */
	EClass getDQDataQualityType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQDataQualityType#getScope <em>Scope</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Scope</em>'.
	 * @see org.isotc211._2005.gmd.DQDataQualityType#getScope()
	 * @see #getDQDataQualityType()
	 * @generated
	 */
	EReference getDQDataQualityType_Scope();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.DQDataQualityType#getReport <em>Report</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Report</em>'.
	 * @see org.isotc211._2005.gmd.DQDataQualityType#getReport()
	 * @see #getDQDataQualityType()
	 * @generated
	 */
	EReference getDQDataQualityType_Report();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQDataQualityType#getLineage <em>Lineage</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Lineage</em>'.
	 * @see org.isotc211._2005.gmd.DQDataQualityType#getLineage()
	 * @see #getDQDataQualityType()
	 * @generated
	 */
	EReference getDQDataQualityType_Lineage();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQDomainConsistencyPropertyType <em>DQ Domain Consistency Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Domain Consistency Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQDomainConsistencyPropertyType
	 * @generated
	 */
	EClass getDQDomainConsistencyPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getDQDomainConsistency <em>DQ Domain Consistency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Domain Consistency</em>'.
	 * @see org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getDQDomainConsistency()
	 * @see #getDQDomainConsistencyPropertyType()
	 * @generated
	 */
	EReference getDQDomainConsistencyPropertyType_DQDomainConsistency();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getActuate()
	 * @see #getDQDomainConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQDomainConsistencyPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getArcrole()
	 * @see #getDQDomainConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQDomainConsistencyPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getHref()
	 * @see #getDQDomainConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQDomainConsistencyPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getNilReason()
	 * @see #getDQDomainConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQDomainConsistencyPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getRole()
	 * @see #getDQDomainConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQDomainConsistencyPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getShow()
	 * @see #getDQDomainConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQDomainConsistencyPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getTitle()
	 * @see #getDQDomainConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQDomainConsistencyPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getType()
	 * @see #getDQDomainConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQDomainConsistencyPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQDomainConsistencyPropertyType#getUuidref()
	 * @see #getDQDomainConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQDomainConsistencyPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQDomainConsistencyType <em>DQ Domain Consistency Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Domain Consistency Type</em>'.
	 * @see org.isotc211._2005.gmd.DQDomainConsistencyType
	 * @generated
	 */
	EClass getDQDomainConsistencyType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQElementPropertyType <em>DQ Element Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Element Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQElementPropertyType
	 * @generated
	 */
	EClass getDQElementPropertyType();

	/**
	 * Returns the meta object for the attribute list '{@link org.isotc211._2005.gmd.DQElementPropertyType#getAbstractDQElementGroup <em>Abstract DQ Element Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Abstract DQ Element Group</em>'.
	 * @see org.isotc211._2005.gmd.DQElementPropertyType#getAbstractDQElementGroup()
	 * @see #getDQElementPropertyType()
	 * @generated
	 */
	EAttribute getDQElementPropertyType_AbstractDQElementGroup();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQElementPropertyType#getAbstractDQElement <em>Abstract DQ Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Abstract DQ Element</em>'.
	 * @see org.isotc211._2005.gmd.DQElementPropertyType#getAbstractDQElement()
	 * @see #getDQElementPropertyType()
	 * @generated
	 */
	EReference getDQElementPropertyType_AbstractDQElement();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQElementPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQElementPropertyType#getActuate()
	 * @see #getDQElementPropertyType()
	 * @generated
	 */
	EAttribute getDQElementPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQElementPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQElementPropertyType#getArcrole()
	 * @see #getDQElementPropertyType()
	 * @generated
	 */
	EAttribute getDQElementPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQElementPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQElementPropertyType#getHref()
	 * @see #getDQElementPropertyType()
	 * @generated
	 */
	EAttribute getDQElementPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQElementPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQElementPropertyType#getNilReason()
	 * @see #getDQElementPropertyType()
	 * @generated
	 */
	EAttribute getDQElementPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQElementPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQElementPropertyType#getRole()
	 * @see #getDQElementPropertyType()
	 * @generated
	 */
	EAttribute getDQElementPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQElementPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQElementPropertyType#getShow()
	 * @see #getDQElementPropertyType()
	 * @generated
	 */
	EAttribute getDQElementPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQElementPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQElementPropertyType#getTitle()
	 * @see #getDQElementPropertyType()
	 * @generated
	 */
	EAttribute getDQElementPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQElementPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQElementPropertyType#getType()
	 * @see #getDQElementPropertyType()
	 * @generated
	 */
	EAttribute getDQElementPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQElementPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQElementPropertyType#getUuidref()
	 * @see #getDQElementPropertyType()
	 * @generated
	 */
	EAttribute getDQElementPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQEvaluationMethodTypeCodePropertyType <em>DQ Evaluation Method Type Code Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Evaluation Method Type Code Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQEvaluationMethodTypeCodePropertyType
	 * @generated
	 */
	EClass getDQEvaluationMethodTypeCodePropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQEvaluationMethodTypeCodePropertyType#getDQEvaluationMethodTypeCode <em>DQ Evaluation Method Type Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Evaluation Method Type Code</em>'.
	 * @see org.isotc211._2005.gmd.DQEvaluationMethodTypeCodePropertyType#getDQEvaluationMethodTypeCode()
	 * @see #getDQEvaluationMethodTypeCodePropertyType()
	 * @generated
	 */
	EReference getDQEvaluationMethodTypeCodePropertyType_DQEvaluationMethodTypeCode();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQEvaluationMethodTypeCodePropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQEvaluationMethodTypeCodePropertyType#getNilReason()
	 * @see #getDQEvaluationMethodTypeCodePropertyType()
	 * @generated
	 */
	EAttribute getDQEvaluationMethodTypeCodePropertyType_NilReason();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQFormatConsistencyPropertyType <em>DQ Format Consistency Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Format Consistency Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQFormatConsistencyPropertyType
	 * @generated
	 */
	EClass getDQFormatConsistencyPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getDQFormatConsistency <em>DQ Format Consistency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Format Consistency</em>'.
	 * @see org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getDQFormatConsistency()
	 * @see #getDQFormatConsistencyPropertyType()
	 * @generated
	 */
	EReference getDQFormatConsistencyPropertyType_DQFormatConsistency();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getActuate()
	 * @see #getDQFormatConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQFormatConsistencyPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getArcrole()
	 * @see #getDQFormatConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQFormatConsistencyPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getHref()
	 * @see #getDQFormatConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQFormatConsistencyPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getNilReason()
	 * @see #getDQFormatConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQFormatConsistencyPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getRole()
	 * @see #getDQFormatConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQFormatConsistencyPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getShow()
	 * @see #getDQFormatConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQFormatConsistencyPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getTitle()
	 * @see #getDQFormatConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQFormatConsistencyPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getType()
	 * @see #getDQFormatConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQFormatConsistencyPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQFormatConsistencyPropertyType#getUuidref()
	 * @see #getDQFormatConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQFormatConsistencyPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQFormatConsistencyType <em>DQ Format Consistency Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Format Consistency Type</em>'.
	 * @see org.isotc211._2005.gmd.DQFormatConsistencyType
	 * @generated
	 */
	EClass getDQFormatConsistencyType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType <em>DQ Gridded Data Positional Accuracy Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Gridded Data Positional Accuracy Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType
	 * @generated
	 */
	EClass getDQGriddedDataPositionalAccuracyPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getDQGriddedDataPositionalAccuracy <em>DQ Gridded Data Positional Accuracy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Gridded Data Positional Accuracy</em>'.
	 * @see org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getDQGriddedDataPositionalAccuracy()
	 * @see #getDQGriddedDataPositionalAccuracyPropertyType()
	 * @generated
	 */
	EReference getDQGriddedDataPositionalAccuracyPropertyType_DQGriddedDataPositionalAccuracy();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getActuate()
	 * @see #getDQGriddedDataPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQGriddedDataPositionalAccuracyPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getArcrole()
	 * @see #getDQGriddedDataPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQGriddedDataPositionalAccuracyPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getHref()
	 * @see #getDQGriddedDataPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQGriddedDataPositionalAccuracyPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getNilReason()
	 * @see #getDQGriddedDataPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQGriddedDataPositionalAccuracyPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getRole()
	 * @see #getDQGriddedDataPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQGriddedDataPositionalAccuracyPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getShow()
	 * @see #getDQGriddedDataPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQGriddedDataPositionalAccuracyPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getTitle()
	 * @see #getDQGriddedDataPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQGriddedDataPositionalAccuracyPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getType()
	 * @see #getDQGriddedDataPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQGriddedDataPositionalAccuracyPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyPropertyType#getUuidref()
	 * @see #getDQGriddedDataPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQGriddedDataPositionalAccuracyPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyType <em>DQ Gridded Data Positional Accuracy Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Gridded Data Positional Accuracy Type</em>'.
	 * @see org.isotc211._2005.gmd.DQGriddedDataPositionalAccuracyType
	 * @generated
	 */
	EClass getDQGriddedDataPositionalAccuracyType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType <em>DQ Logical Consistency Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Logical Consistency Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType
	 * @generated
	 */
	EClass getDQLogicalConsistencyPropertyType();

	/**
	 * Returns the meta object for the attribute list '{@link org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getAbstractDQLogicalConsistencyGroup <em>Abstract DQ Logical Consistency Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Abstract DQ Logical Consistency Group</em>'.
	 * @see org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getAbstractDQLogicalConsistencyGroup()
	 * @see #getDQLogicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQLogicalConsistencyPropertyType_AbstractDQLogicalConsistencyGroup();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getAbstractDQLogicalConsistency <em>Abstract DQ Logical Consistency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Abstract DQ Logical Consistency</em>'.
	 * @see org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getAbstractDQLogicalConsistency()
	 * @see #getDQLogicalConsistencyPropertyType()
	 * @generated
	 */
	EReference getDQLogicalConsistencyPropertyType_AbstractDQLogicalConsistency();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getActuate()
	 * @see #getDQLogicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQLogicalConsistencyPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getArcrole()
	 * @see #getDQLogicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQLogicalConsistencyPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getHref()
	 * @see #getDQLogicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQLogicalConsistencyPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getNilReason()
	 * @see #getDQLogicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQLogicalConsistencyPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getRole()
	 * @see #getDQLogicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQLogicalConsistencyPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getShow()
	 * @see #getDQLogicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQLogicalConsistencyPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getTitle()
	 * @see #getDQLogicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQLogicalConsistencyPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getType()
	 * @see #getDQLogicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQLogicalConsistencyPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQLogicalConsistencyPropertyType#getUuidref()
	 * @see #getDQLogicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQLogicalConsistencyPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType <em>DQ Non Quantitative Attribute Accuracy Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Non Quantitative Attribute Accuracy Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType
	 * @generated
	 */
	EClass getDQNonQuantitativeAttributeAccuracyPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getDQNonQuantitativeAttributeAccuracy <em>DQ Non Quantitative Attribute Accuracy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Non Quantitative Attribute Accuracy</em>'.
	 * @see org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getDQNonQuantitativeAttributeAccuracy()
	 * @see #getDQNonQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EReference getDQNonQuantitativeAttributeAccuracyPropertyType_DQNonQuantitativeAttributeAccuracy();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getActuate()
	 * @see #getDQNonQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQNonQuantitativeAttributeAccuracyPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getArcrole()
	 * @see #getDQNonQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQNonQuantitativeAttributeAccuracyPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getHref()
	 * @see #getDQNonQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQNonQuantitativeAttributeAccuracyPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getNilReason()
	 * @see #getDQNonQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQNonQuantitativeAttributeAccuracyPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getRole()
	 * @see #getDQNonQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQNonQuantitativeAttributeAccuracyPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getShow()
	 * @see #getDQNonQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQNonQuantitativeAttributeAccuracyPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getTitle()
	 * @see #getDQNonQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQNonQuantitativeAttributeAccuracyPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getType()
	 * @see #getDQNonQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQNonQuantitativeAttributeAccuracyPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyPropertyType#getUuidref()
	 * @see #getDQNonQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQNonQuantitativeAttributeAccuracyPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyType <em>DQ Non Quantitative Attribute Accuracy Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Non Quantitative Attribute Accuracy Type</em>'.
	 * @see org.isotc211._2005.gmd.DQNonQuantitativeAttributeAccuracyType
	 * @generated
	 */
	EClass getDQNonQuantitativeAttributeAccuracyType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType <em>DQ Positional Accuracy Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Positional Accuracy Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType
	 * @generated
	 */
	EClass getDQPositionalAccuracyPropertyType();

	/**
	 * Returns the meta object for the attribute list '{@link org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getAbstractDQPositionalAccuracyGroup <em>Abstract DQ Positional Accuracy Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Abstract DQ Positional Accuracy Group</em>'.
	 * @see org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getAbstractDQPositionalAccuracyGroup()
	 * @see #getDQPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQPositionalAccuracyPropertyType_AbstractDQPositionalAccuracyGroup();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getAbstractDQPositionalAccuracy <em>Abstract DQ Positional Accuracy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Abstract DQ Positional Accuracy</em>'.
	 * @see org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getAbstractDQPositionalAccuracy()
	 * @see #getDQPositionalAccuracyPropertyType()
	 * @generated
	 */
	EReference getDQPositionalAccuracyPropertyType_AbstractDQPositionalAccuracy();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getActuate()
	 * @see #getDQPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQPositionalAccuracyPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getArcrole()
	 * @see #getDQPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQPositionalAccuracyPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getHref()
	 * @see #getDQPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQPositionalAccuracyPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getNilReason()
	 * @see #getDQPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQPositionalAccuracyPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getRole()
	 * @see #getDQPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQPositionalAccuracyPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getShow()
	 * @see #getDQPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQPositionalAccuracyPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getTitle()
	 * @see #getDQPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQPositionalAccuracyPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getType()
	 * @see #getDQPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQPositionalAccuracyPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQPositionalAccuracyPropertyType#getUuidref()
	 * @see #getDQPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQPositionalAccuracyPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType <em>DQ Quantitative Attribute Accuracy Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Quantitative Attribute Accuracy Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType
	 * @generated
	 */
	EClass getDQQuantitativeAttributeAccuracyPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getDQQuantitativeAttributeAccuracy <em>DQ Quantitative Attribute Accuracy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Quantitative Attribute Accuracy</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getDQQuantitativeAttributeAccuracy()
	 * @see #getDQQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EReference getDQQuantitativeAttributeAccuracyPropertyType_DQQuantitativeAttributeAccuracy();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getActuate()
	 * @see #getDQQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQQuantitativeAttributeAccuracyPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getArcrole()
	 * @see #getDQQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQQuantitativeAttributeAccuracyPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getHref()
	 * @see #getDQQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQQuantitativeAttributeAccuracyPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getNilReason()
	 * @see #getDQQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQQuantitativeAttributeAccuracyPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getRole()
	 * @see #getDQQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQQuantitativeAttributeAccuracyPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getShow()
	 * @see #getDQQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQQuantitativeAttributeAccuracyPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getTitle()
	 * @see #getDQQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQQuantitativeAttributeAccuracyPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getType()
	 * @see #getDQQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQQuantitativeAttributeAccuracyPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyPropertyType#getUuidref()
	 * @see #getDQQuantitativeAttributeAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQQuantitativeAttributeAccuracyPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyType <em>DQ Quantitative Attribute Accuracy Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Quantitative Attribute Accuracy Type</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeAttributeAccuracyType
	 * @generated
	 */
	EClass getDQQuantitativeAttributeAccuracyType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQQuantitativeResultPropertyType <em>DQ Quantitative Result Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Quantitative Result Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeResultPropertyType
	 * @generated
	 */
	EClass getDQQuantitativeResultPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getDQQuantitativeResult <em>DQ Quantitative Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Quantitative Result</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getDQQuantitativeResult()
	 * @see #getDQQuantitativeResultPropertyType()
	 * @generated
	 */
	EReference getDQQuantitativeResultPropertyType_DQQuantitativeResult();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getActuate()
	 * @see #getDQQuantitativeResultPropertyType()
	 * @generated
	 */
	EAttribute getDQQuantitativeResultPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getArcrole()
	 * @see #getDQQuantitativeResultPropertyType()
	 * @generated
	 */
	EAttribute getDQQuantitativeResultPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getHref()
	 * @see #getDQQuantitativeResultPropertyType()
	 * @generated
	 */
	EAttribute getDQQuantitativeResultPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getNilReason()
	 * @see #getDQQuantitativeResultPropertyType()
	 * @generated
	 */
	EAttribute getDQQuantitativeResultPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getRole()
	 * @see #getDQQuantitativeResultPropertyType()
	 * @generated
	 */
	EAttribute getDQQuantitativeResultPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getShow()
	 * @see #getDQQuantitativeResultPropertyType()
	 * @generated
	 */
	EAttribute getDQQuantitativeResultPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getTitle()
	 * @see #getDQQuantitativeResultPropertyType()
	 * @generated
	 */
	EAttribute getDQQuantitativeResultPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getType()
	 * @see #getDQQuantitativeResultPropertyType()
	 * @generated
	 */
	EAttribute getDQQuantitativeResultPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeResultPropertyType#getUuidref()
	 * @see #getDQQuantitativeResultPropertyType()
	 * @generated
	 */
	EAttribute getDQQuantitativeResultPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQQuantitativeResultType <em>DQ Quantitative Result Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Quantitative Result Type</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeResultType
	 * @generated
	 */
	EClass getDQQuantitativeResultType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQQuantitativeResultType#getValueType <em>Value Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Value Type</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeResultType#getValueType()
	 * @see #getDQQuantitativeResultType()
	 * @generated
	 */
	EReference getDQQuantitativeResultType_ValueType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQQuantitativeResultType#getValueUnit <em>Value Unit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Value Unit</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeResultType#getValueUnit()
	 * @see #getDQQuantitativeResultType()
	 * @generated
	 */
	EReference getDQQuantitativeResultType_ValueUnit();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQQuantitativeResultType#getErrorStatistic <em>Error Statistic</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Error Statistic</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeResultType#getErrorStatistic()
	 * @see #getDQQuantitativeResultType()
	 * @generated
	 */
	EReference getDQQuantitativeResultType_ErrorStatistic();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.DQQuantitativeResultType#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Value</em>'.
	 * @see org.isotc211._2005.gmd.DQQuantitativeResultType#getValue()
	 * @see #getDQQuantitativeResultType()
	 * @generated
	 */
	EReference getDQQuantitativeResultType_Value();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType <em>DQ Relative Internal Positional Accuracy Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Relative Internal Positional Accuracy Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType
	 * @generated
	 */
	EClass getDQRelativeInternalPositionalAccuracyPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getDQRelativeInternalPositionalAccuracy <em>DQ Relative Internal Positional Accuracy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Relative Internal Positional Accuracy</em>'.
	 * @see org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getDQRelativeInternalPositionalAccuracy()
	 * @see #getDQRelativeInternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EReference getDQRelativeInternalPositionalAccuracyPropertyType_DQRelativeInternalPositionalAccuracy();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getActuate()
	 * @see #getDQRelativeInternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQRelativeInternalPositionalAccuracyPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getArcrole()
	 * @see #getDQRelativeInternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQRelativeInternalPositionalAccuracyPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getHref()
	 * @see #getDQRelativeInternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQRelativeInternalPositionalAccuracyPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getNilReason()
	 * @see #getDQRelativeInternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQRelativeInternalPositionalAccuracyPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getRole()
	 * @see #getDQRelativeInternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQRelativeInternalPositionalAccuracyPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getShow()
	 * @see #getDQRelativeInternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQRelativeInternalPositionalAccuracyPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getTitle()
	 * @see #getDQRelativeInternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQRelativeInternalPositionalAccuracyPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getType()
	 * @see #getDQRelativeInternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQRelativeInternalPositionalAccuracyPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyPropertyType#getUuidref()
	 * @see #getDQRelativeInternalPositionalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQRelativeInternalPositionalAccuracyPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyType <em>DQ Relative Internal Positional Accuracy Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Relative Internal Positional Accuracy Type</em>'.
	 * @see org.isotc211._2005.gmd.DQRelativeInternalPositionalAccuracyType
	 * @generated
	 */
	EClass getDQRelativeInternalPositionalAccuracyType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQResultPropertyType <em>DQ Result Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Result Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQResultPropertyType
	 * @generated
	 */
	EClass getDQResultPropertyType();

	/**
	 * Returns the meta object for the attribute list '{@link org.isotc211._2005.gmd.DQResultPropertyType#getAbstractDQResultGroup <em>Abstract DQ Result Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Abstract DQ Result Group</em>'.
	 * @see org.isotc211._2005.gmd.DQResultPropertyType#getAbstractDQResultGroup()
	 * @see #getDQResultPropertyType()
	 * @generated
	 */
	EAttribute getDQResultPropertyType_AbstractDQResultGroup();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQResultPropertyType#getAbstractDQResult <em>Abstract DQ Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Abstract DQ Result</em>'.
	 * @see org.isotc211._2005.gmd.DQResultPropertyType#getAbstractDQResult()
	 * @see #getDQResultPropertyType()
	 * @generated
	 */
	EReference getDQResultPropertyType_AbstractDQResult();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQResultPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQResultPropertyType#getActuate()
	 * @see #getDQResultPropertyType()
	 * @generated
	 */
	EAttribute getDQResultPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQResultPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQResultPropertyType#getArcrole()
	 * @see #getDQResultPropertyType()
	 * @generated
	 */
	EAttribute getDQResultPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQResultPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQResultPropertyType#getHref()
	 * @see #getDQResultPropertyType()
	 * @generated
	 */
	EAttribute getDQResultPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQResultPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQResultPropertyType#getNilReason()
	 * @see #getDQResultPropertyType()
	 * @generated
	 */
	EAttribute getDQResultPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQResultPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQResultPropertyType#getRole()
	 * @see #getDQResultPropertyType()
	 * @generated
	 */
	EAttribute getDQResultPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQResultPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQResultPropertyType#getShow()
	 * @see #getDQResultPropertyType()
	 * @generated
	 */
	EAttribute getDQResultPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQResultPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQResultPropertyType#getTitle()
	 * @see #getDQResultPropertyType()
	 * @generated
	 */
	EAttribute getDQResultPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQResultPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQResultPropertyType#getType()
	 * @see #getDQResultPropertyType()
	 * @generated
	 */
	EAttribute getDQResultPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQResultPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQResultPropertyType#getUuidref()
	 * @see #getDQResultPropertyType()
	 * @generated
	 */
	EAttribute getDQResultPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQScopePropertyType <em>DQ Scope Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Scope Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQScopePropertyType
	 * @generated
	 */
	EClass getDQScopePropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQScopePropertyType#getDQScope <em>DQ Scope</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Scope</em>'.
	 * @see org.isotc211._2005.gmd.DQScopePropertyType#getDQScope()
	 * @see #getDQScopePropertyType()
	 * @generated
	 */
	EReference getDQScopePropertyType_DQScope();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQScopePropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQScopePropertyType#getActuate()
	 * @see #getDQScopePropertyType()
	 * @generated
	 */
	EAttribute getDQScopePropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQScopePropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQScopePropertyType#getArcrole()
	 * @see #getDQScopePropertyType()
	 * @generated
	 */
	EAttribute getDQScopePropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQScopePropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQScopePropertyType#getHref()
	 * @see #getDQScopePropertyType()
	 * @generated
	 */
	EAttribute getDQScopePropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQScopePropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQScopePropertyType#getNilReason()
	 * @see #getDQScopePropertyType()
	 * @generated
	 */
	EAttribute getDQScopePropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQScopePropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQScopePropertyType#getRole()
	 * @see #getDQScopePropertyType()
	 * @generated
	 */
	EAttribute getDQScopePropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQScopePropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQScopePropertyType#getShow()
	 * @see #getDQScopePropertyType()
	 * @generated
	 */
	EAttribute getDQScopePropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQScopePropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQScopePropertyType#getTitle()
	 * @see #getDQScopePropertyType()
	 * @generated
	 */
	EAttribute getDQScopePropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQScopePropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQScopePropertyType#getType()
	 * @see #getDQScopePropertyType()
	 * @generated
	 */
	EAttribute getDQScopePropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQScopePropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQScopePropertyType#getUuidref()
	 * @see #getDQScopePropertyType()
	 * @generated
	 */
	EAttribute getDQScopePropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQScopeType <em>DQ Scope Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Scope Type</em>'.
	 * @see org.isotc211._2005.gmd.DQScopeType
	 * @generated
	 */
	EClass getDQScopeType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQScopeType#getLevel <em>Level</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Level</em>'.
	 * @see org.isotc211._2005.gmd.DQScopeType#getLevel()
	 * @see #getDQScopeType()
	 * @generated
	 */
	EReference getDQScopeType_Level();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQScopeType#getExtent <em>Extent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Extent</em>'.
	 * @see org.isotc211._2005.gmd.DQScopeType#getExtent()
	 * @see #getDQScopeType()
	 * @generated
	 */
	EReference getDQScopeType_Extent();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.DQScopeType#getLevelDescription <em>Level Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Level Description</em>'.
	 * @see org.isotc211._2005.gmd.DQScopeType#getLevelDescription()
	 * @see #getDQScopeType()
	 * @generated
	 */
	EReference getDQScopeType_LevelDescription();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType <em>DQ Temporal Accuracy Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Temporal Accuracy Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType
	 * @generated
	 */
	EClass getDQTemporalAccuracyPropertyType();

	/**
	 * Returns the meta object for the attribute list '{@link org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getAbstractDQTemporalAccuracyGroup <em>Abstract DQ Temporal Accuracy Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Abstract DQ Temporal Accuracy Group</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getAbstractDQTemporalAccuracyGroup()
	 * @see #getDQTemporalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalAccuracyPropertyType_AbstractDQTemporalAccuracyGroup();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getAbstractDQTemporalAccuracy <em>Abstract DQ Temporal Accuracy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Abstract DQ Temporal Accuracy</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getAbstractDQTemporalAccuracy()
	 * @see #getDQTemporalAccuracyPropertyType()
	 * @generated
	 */
	EReference getDQTemporalAccuracyPropertyType_AbstractDQTemporalAccuracy();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getActuate()
	 * @see #getDQTemporalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalAccuracyPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getArcrole()
	 * @see #getDQTemporalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalAccuracyPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getHref()
	 * @see #getDQTemporalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalAccuracyPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getNilReason()
	 * @see #getDQTemporalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalAccuracyPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getRole()
	 * @see #getDQTemporalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalAccuracyPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getShow()
	 * @see #getDQTemporalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalAccuracyPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getTitle()
	 * @see #getDQTemporalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalAccuracyPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getType()
	 * @see #getDQTemporalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalAccuracyPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalAccuracyPropertyType#getUuidref()
	 * @see #getDQTemporalAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalAccuracyPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType <em>DQ Temporal Consistency Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Temporal Consistency Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType
	 * @generated
	 */
	EClass getDQTemporalConsistencyPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getDQTemporalConsistency <em>DQ Temporal Consistency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Temporal Consistency</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getDQTemporalConsistency()
	 * @see #getDQTemporalConsistencyPropertyType()
	 * @generated
	 */
	EReference getDQTemporalConsistencyPropertyType_DQTemporalConsistency();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getActuate()
	 * @see #getDQTemporalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalConsistencyPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getArcrole()
	 * @see #getDQTemporalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalConsistencyPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getHref()
	 * @see #getDQTemporalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalConsistencyPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getNilReason()
	 * @see #getDQTemporalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalConsistencyPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getRole()
	 * @see #getDQTemporalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalConsistencyPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getShow()
	 * @see #getDQTemporalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalConsistencyPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getTitle()
	 * @see #getDQTemporalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalConsistencyPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getType()
	 * @see #getDQTemporalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalConsistencyPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalConsistencyPropertyType#getUuidref()
	 * @see #getDQTemporalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalConsistencyPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQTemporalConsistencyType <em>DQ Temporal Consistency Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Temporal Consistency Type</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalConsistencyType
	 * @generated
	 */
	EClass getDQTemporalConsistencyType();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQTemporalValidityPropertyType <em>DQ Temporal Validity Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Temporal Validity Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalValidityPropertyType
	 * @generated
	 */
	EClass getDQTemporalValidityPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getDQTemporalValidity <em>DQ Temporal Validity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Temporal Validity</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getDQTemporalValidity()
	 * @see #getDQTemporalValidityPropertyType()
	 * @generated
	 */
	EReference getDQTemporalValidityPropertyType_DQTemporalValidity();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getActuate()
	 * @see #getDQTemporalValidityPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalValidityPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getArcrole()
	 * @see #getDQTemporalValidityPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalValidityPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getHref()
	 * @see #getDQTemporalValidityPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalValidityPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getNilReason()
	 * @see #getDQTemporalValidityPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalValidityPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getRole()
	 * @see #getDQTemporalValidityPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalValidityPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getShow()
	 * @see #getDQTemporalValidityPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalValidityPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getTitle()
	 * @see #getDQTemporalValidityPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalValidityPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getType()
	 * @see #getDQTemporalValidityPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalValidityPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQTemporalValidityPropertyType#getUuidref()
	 * @see #getDQTemporalValidityPropertyType()
	 * @generated
	 */
	EAttribute getDQTemporalValidityPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQThematicAccuracyPropertyType <em>DQ Thematic Accuracy Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Thematic Accuracy Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicAccuracyPropertyType
	 * @generated
	 */
	EClass getDQThematicAccuracyPropertyType();

	/**
	 * Returns the meta object for the attribute list '{@link org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getAbstractDQThematicAccuracyGroup <em>Abstract DQ Thematic Accuracy Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Abstract DQ Thematic Accuracy Group</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getAbstractDQThematicAccuracyGroup()
	 * @see #getDQThematicAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicAccuracyPropertyType_AbstractDQThematicAccuracyGroup();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getAbstractDQThematicAccuracy <em>Abstract DQ Thematic Accuracy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Abstract DQ Thematic Accuracy</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getAbstractDQThematicAccuracy()
	 * @see #getDQThematicAccuracyPropertyType()
	 * @generated
	 */
	EReference getDQThematicAccuracyPropertyType_AbstractDQThematicAccuracy();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getActuate()
	 * @see #getDQThematicAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicAccuracyPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getArcrole()
	 * @see #getDQThematicAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicAccuracyPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getHref()
	 * @see #getDQThematicAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicAccuracyPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getNilReason()
	 * @see #getDQThematicAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicAccuracyPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getRole()
	 * @see #getDQThematicAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicAccuracyPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getShow()
	 * @see #getDQThematicAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicAccuracyPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getTitle()
	 * @see #getDQThematicAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicAccuracyPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getType()
	 * @see #getDQThematicAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicAccuracyPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicAccuracyPropertyType#getUuidref()
	 * @see #getDQThematicAccuracyPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicAccuracyPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType <em>DQ Thematic Classification Correctness Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Thematic Classification Correctness Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType
	 * @generated
	 */
	EClass getDQThematicClassificationCorrectnessPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getDQThematicClassificationCorrectness <em>DQ Thematic Classification Correctness</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Thematic Classification Correctness</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getDQThematicClassificationCorrectness()
	 * @see #getDQThematicClassificationCorrectnessPropertyType()
	 * @generated
	 */
	EReference getDQThematicClassificationCorrectnessPropertyType_DQThematicClassificationCorrectness();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getActuate()
	 * @see #getDQThematicClassificationCorrectnessPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicClassificationCorrectnessPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getArcrole()
	 * @see #getDQThematicClassificationCorrectnessPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicClassificationCorrectnessPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getHref()
	 * @see #getDQThematicClassificationCorrectnessPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicClassificationCorrectnessPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getNilReason()
	 * @see #getDQThematicClassificationCorrectnessPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicClassificationCorrectnessPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getRole()
	 * @see #getDQThematicClassificationCorrectnessPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicClassificationCorrectnessPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getShow()
	 * @see #getDQThematicClassificationCorrectnessPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicClassificationCorrectnessPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getTitle()
	 * @see #getDQThematicClassificationCorrectnessPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicClassificationCorrectnessPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getType()
	 * @see #getDQThematicClassificationCorrectnessPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicClassificationCorrectnessPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQThematicClassificationCorrectnessPropertyType#getUuidref()
	 * @see #getDQThematicClassificationCorrectnessPropertyType()
	 * @generated
	 */
	EAttribute getDQThematicClassificationCorrectnessPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType <em>DQ Topological Consistency Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DQ Topological Consistency Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType
	 * @generated
	 */
	EClass getDQTopologicalConsistencyPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getDQTopologicalConsistency <em>DQ Topological Consistency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DQ Topological Consistency</em>'.
	 * @see org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getDQTopologicalConsistency()
	 * @see #getDQTopologicalConsistencyPropertyType()
	 * @generated
	 */
	EReference getDQTopologicalConsistencyPropertyType_DQTopologicalConsistency();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getActuate()
	 * @see #getDQTopologicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQTopologicalConsistencyPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getArcrole()
	 * @see #getDQTopologicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQTopologicalConsistencyPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getHref()
	 * @see #getDQTopologicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQTopologicalConsistencyPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getNilReason()
	 * @see #getDQTopologicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQTopologicalConsistencyPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getRole()
	 * @see #getDQTopologicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQTopologicalConsistencyPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getShow()
	 * @see #getDQTopologicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQTopologicalConsistencyPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getTitle()
	 * @see #getDQTopologicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQTopologicalConsistencyPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getType()
	 * @see #getDQTopologicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQTopologicalConsistencyPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DQTopologicalConsistencyPropertyType#getUuidref()
	 * @see #getDQTopologicalConsistencyPropertyType()
	 * @generated
	 */
	EAttribute getDQTopologicalConsistencyPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DSAggregatePropertyType <em>DS Aggregate Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DS Aggregate Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DSAggregatePropertyType
	 * @generated
	 */
	EClass getDSAggregatePropertyType();

	/**
	 * Returns the meta object for the attribute list '{@link org.isotc211._2005.gmd.DSAggregatePropertyType#getAbstractDSAggregateGroup <em>Abstract DS Aggregate Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Abstract DS Aggregate Group</em>'.
	 * @see org.isotc211._2005.gmd.DSAggregatePropertyType#getAbstractDSAggregateGroup()
	 * @see #getDSAggregatePropertyType()
	 * @generated
	 */
	EAttribute getDSAggregatePropertyType_AbstractDSAggregateGroup();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DSAggregatePropertyType#getAbstractDSAggregate <em>Abstract DS Aggregate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Abstract DS Aggregate</em>'.
	 * @see org.isotc211._2005.gmd.DSAggregatePropertyType#getAbstractDSAggregate()
	 * @see #getDSAggregatePropertyType()
	 * @generated
	 */
	EReference getDSAggregatePropertyType_AbstractDSAggregate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAggregatePropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DSAggregatePropertyType#getActuate()
	 * @see #getDSAggregatePropertyType()
	 * @generated
	 */
	EAttribute getDSAggregatePropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAggregatePropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DSAggregatePropertyType#getArcrole()
	 * @see #getDSAggregatePropertyType()
	 * @generated
	 */
	EAttribute getDSAggregatePropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAggregatePropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DSAggregatePropertyType#getHref()
	 * @see #getDSAggregatePropertyType()
	 * @generated
	 */
	EAttribute getDSAggregatePropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAggregatePropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DSAggregatePropertyType#getNilReason()
	 * @see #getDSAggregatePropertyType()
	 * @generated
	 */
	EAttribute getDSAggregatePropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAggregatePropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DSAggregatePropertyType#getRole()
	 * @see #getDSAggregatePropertyType()
	 * @generated
	 */
	EAttribute getDSAggregatePropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAggregatePropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DSAggregatePropertyType#getShow()
	 * @see #getDSAggregatePropertyType()
	 * @generated
	 */
	EAttribute getDSAggregatePropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAggregatePropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DSAggregatePropertyType#getTitle()
	 * @see #getDSAggregatePropertyType()
	 * @generated
	 */
	EAttribute getDSAggregatePropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAggregatePropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DSAggregatePropertyType#getType()
	 * @see #getDSAggregatePropertyType()
	 * @generated
	 */
	EAttribute getDSAggregatePropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAggregatePropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DSAggregatePropertyType#getUuidref()
	 * @see #getDSAggregatePropertyType()
	 * @generated
	 */
	EAttribute getDSAggregatePropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DSAssociationPropertyType <em>DS Association Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DS Association Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DSAssociationPropertyType
	 * @generated
	 */
	EClass getDSAssociationPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DSAssociationPropertyType#getDSAssociation <em>DS Association</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DS Association</em>'.
	 * @see org.isotc211._2005.gmd.DSAssociationPropertyType#getDSAssociation()
	 * @see #getDSAssociationPropertyType()
	 * @generated
	 */
	EReference getDSAssociationPropertyType_DSAssociation();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAssociationPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DSAssociationPropertyType#getActuate()
	 * @see #getDSAssociationPropertyType()
	 * @generated
	 */
	EAttribute getDSAssociationPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAssociationPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DSAssociationPropertyType#getArcrole()
	 * @see #getDSAssociationPropertyType()
	 * @generated
	 */
	EAttribute getDSAssociationPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAssociationPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DSAssociationPropertyType#getHref()
	 * @see #getDSAssociationPropertyType()
	 * @generated
	 */
	EAttribute getDSAssociationPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAssociationPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DSAssociationPropertyType#getNilReason()
	 * @see #getDSAssociationPropertyType()
	 * @generated
	 */
	EAttribute getDSAssociationPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAssociationPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DSAssociationPropertyType#getRole()
	 * @see #getDSAssociationPropertyType()
	 * @generated
	 */
	EAttribute getDSAssociationPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAssociationPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DSAssociationPropertyType#getShow()
	 * @see #getDSAssociationPropertyType()
	 * @generated
	 */
	EAttribute getDSAssociationPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAssociationPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DSAssociationPropertyType#getTitle()
	 * @see #getDSAssociationPropertyType()
	 * @generated
	 */
	EAttribute getDSAssociationPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAssociationPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DSAssociationPropertyType#getType()
	 * @see #getDSAssociationPropertyType()
	 * @generated
	 */
	EAttribute getDSAssociationPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAssociationPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DSAssociationPropertyType#getUuidref()
	 * @see #getDSAssociationPropertyType()
	 * @generated
	 */
	EAttribute getDSAssociationPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DSAssociationTypeCodePropertyType <em>DS Association Type Code Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DS Association Type Code Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DSAssociationTypeCodePropertyType
	 * @generated
	 */
	EClass getDSAssociationTypeCodePropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DSAssociationTypeCodePropertyType#getDSAssociationTypeCode <em>DS Association Type Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DS Association Type Code</em>'.
	 * @see org.isotc211._2005.gmd.DSAssociationTypeCodePropertyType#getDSAssociationTypeCode()
	 * @see #getDSAssociationTypeCodePropertyType()
	 * @generated
	 */
	EReference getDSAssociationTypeCodePropertyType_DSAssociationTypeCode();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSAssociationTypeCodePropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DSAssociationTypeCodePropertyType#getNilReason()
	 * @see #getDSAssociationTypeCodePropertyType()
	 * @generated
	 */
	EAttribute getDSAssociationTypeCodePropertyType_NilReason();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DSDataSetPropertyType <em>DS Data Set Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DS Data Set Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DSDataSetPropertyType
	 * @generated
	 */
	EClass getDSDataSetPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DSDataSetPropertyType#getDSDataSet <em>DS Data Set</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DS Data Set</em>'.
	 * @see org.isotc211._2005.gmd.DSDataSetPropertyType#getDSDataSet()
	 * @see #getDSDataSetPropertyType()
	 * @generated
	 */
	EReference getDSDataSetPropertyType_DSDataSet();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSDataSetPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.DSDataSetPropertyType#getActuate()
	 * @see #getDSDataSetPropertyType()
	 * @generated
	 */
	EAttribute getDSDataSetPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSDataSetPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.DSDataSetPropertyType#getArcrole()
	 * @see #getDSDataSetPropertyType()
	 * @generated
	 */
	EAttribute getDSDataSetPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSDataSetPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.DSDataSetPropertyType#getHref()
	 * @see #getDSDataSetPropertyType()
	 * @generated
	 */
	EAttribute getDSDataSetPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSDataSetPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DSDataSetPropertyType#getNilReason()
	 * @see #getDSDataSetPropertyType()
	 * @generated
	 */
	EAttribute getDSDataSetPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSDataSetPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.DSDataSetPropertyType#getRole()
	 * @see #getDSDataSetPropertyType()
	 * @generated
	 */
	EAttribute getDSDataSetPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSDataSetPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.DSDataSetPropertyType#getShow()
	 * @see #getDSDataSetPropertyType()
	 * @generated
	 */
	EAttribute getDSDataSetPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSDataSetPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.DSDataSetPropertyType#getTitle()
	 * @see #getDSDataSetPropertyType()
	 * @generated
	 */
	EAttribute getDSDataSetPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSDataSetPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.DSDataSetPropertyType#getType()
	 * @see #getDSDataSetPropertyType()
	 * @generated
	 */
	EAttribute getDSDataSetPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSDataSetPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.DSDataSetPropertyType#getUuidref()
	 * @see #getDSDataSetPropertyType()
	 * @generated
	 */
	EAttribute getDSDataSetPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DSDataSetType <em>DS Data Set Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DS Data Set Type</em>'.
	 * @see org.isotc211._2005.gmd.DSDataSetType
	 * @generated
	 */
	EClass getDSDataSetType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.DSDataSetType#getHas <em>Has</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Has</em>'.
	 * @see org.isotc211._2005.gmd.DSDataSetType#getHas()
	 * @see #getDSDataSetType()
	 * @generated
	 */
	EReference getDSDataSetType_Has();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.DSDataSetType#getPartOf <em>Part Of</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Part Of</em>'.
	 * @see org.isotc211._2005.gmd.DSDataSetType#getPartOf()
	 * @see #getDSDataSetType()
	 * @generated
	 */
	EReference getDSDataSetType_PartOf();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.DSInitiativeTypeCodePropertyType <em>DS Initiative Type Code Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>DS Initiative Type Code Property Type</em>'.
	 * @see org.isotc211._2005.gmd.DSInitiativeTypeCodePropertyType
	 * @generated
	 */
	EClass getDSInitiativeTypeCodePropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.DSInitiativeTypeCodePropertyType#getDSInitiativeTypeCode <em>DS Initiative Type Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>DS Initiative Type Code</em>'.
	 * @see org.isotc211._2005.gmd.DSInitiativeTypeCodePropertyType#getDSInitiativeTypeCode()
	 * @see #getDSInitiativeTypeCodePropertyType()
	 * @generated
	 */
	EReference getDSInitiativeTypeCodePropertyType_DSInitiativeTypeCode();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.DSInitiativeTypeCodePropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.DSInitiativeTypeCodePropertyType#getNilReason()
	 * @see #getDSInitiativeTypeCodePropertyType()
	 * @generated
	 */
	EAttribute getDSInitiativeTypeCodePropertyType_NilReason();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.EXExtentPropertyType <em>EX Extent Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>EX Extent Property Type</em>'.
	 * @see org.isotc211._2005.gmd.EXExtentPropertyType
	 * @generated
	 */
	EClass getEXExtentPropertyType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.EXExtentPropertyType#getEXExtent <em>EX Extent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>EX Extent</em>'.
	 * @see org.isotc211._2005.gmd.EXExtentPropertyType#getEXExtent()
	 * @see #getEXExtentPropertyType()
	 * @generated
	 */
	EReference getEXExtentPropertyType_EXExtent();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.EXExtentPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.EXExtentPropertyType#getActuate()
	 * @see #getEXExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXExtentPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.EXExtentPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.EXExtentPropertyType#getArcrole()
	 * @see #getEXExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXExtentPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.EXExtentPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.EXExtentPropertyType#getHref()
	 * @see #getEXExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXExtentPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.EXExtentPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.EXExtentPropertyType#getNilReason()
	 * @see #getEXExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXExtentPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.EXExtentPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.EXExtentPropertyType#getRole()
	 * @see #getEXExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXExtentPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.EXExtentPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.EXExtentPropertyType#getShow()
	 * @see #getEXExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXExtentPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.EXExtentPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.EXExtentPropertyType#getTitle()
	 * @see #getEXExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXExtentPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.EXExtentPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.EXExtentPropertyType#getType()
	 * @see #getEXExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXExtentPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.EXExtentPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.EXExtentPropertyType#getUuidref()
	 * @see #getEXExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXExtentPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.EXExtentType <em>EX Extent Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>EX Extent Type</em>'.
	 * @see org.isotc211._2005.gmd.EXExtentType
	 * @generated
	 */
	EClass getEXExtentType();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.EXExtentType#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Description</em>'.
	 * @see org.isotc211._2005.gmd.EXExtentType#getDescription()
	 * @see #getEXExtentType()
	 * @generated
	 */
	EReference getEXExtentType_Description();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.EXExtentType#getGeographicElement <em>Geographic Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Geographic Element</em>'.
	 * @see org.isotc211._2005.gmd.EXExtentType#getGeographicElement()
	 * @see #getEXExtentType()
	 * @generated
	 */
	EReference getEXExtentType_GeographicElement();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.EXExtentType#getTemporalElement <em>Temporal Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Temporal Element</em>'.
	 * @see org.isotc211._2005.gmd.EXExtentType#getTemporalElement()
	 * @see #getEXExtentType()
	 * @generated
	 */
	EReference getEXExtentType_TemporalElement();

	/**
	 * Returns the meta object for the containment reference list '{@link org.isotc211._2005.gmd.EXExtentType#getVerticalElement <em>Vertical Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Vertical Element</em>'.
	 * @see org.isotc211._2005.gmd.EXExtentType#getVerticalElement()
	 * @see #getEXExtentType()
	 * @generated
	 */
	EReference getEXExtentType_VerticalElement();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.EXGeographicExtentPropertyType <em>EX Geographic Extent Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>EX Geographic Extent Property Type</em>'.
	 * @see org.isotc211._2005.gmd.EXGeographicExtentPropertyType
	 * @generated
	 */
	EClass getEXGeographicExtentPropertyType();

	/**
	 * Returns the meta object for the attribute list '{@link org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getAbstractEXGeographicExtentGroup <em>Abstract EX Geographic Extent Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Abstract EX Geographic Extent Group</em>'.
	 * @see org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getAbstractEXGeographicExtentGroup()
	 * @see #getEXGeographicExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXGeographicExtentPropertyType_AbstractEXGeographicExtentGroup();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getAbstractEXGeographicExtent <em>Abstract EX Geographic Extent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Abstract EX Geographic Extent</em>'.
	 * @see org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getAbstractEXGeographicExtent()
	 * @see #getEXGeographicExtentPropertyType()
	 * @generated
	 */
	EReference getEXGeographicExtentPropertyType_AbstractEXGeographicExtent();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getActuate <em>Actuate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Actuate</em>'.
	 * @see org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getActuate()
	 * @see #getEXGeographicExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXGeographicExtentPropertyType_Actuate();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getArcrole <em>Arcrole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arcrole</em>'.
	 * @see org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getArcrole()
	 * @see #getEXGeographicExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXGeographicExtentPropertyType_Arcrole();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getHref <em>Href</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Href</em>'.
	 * @see org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getHref()
	 * @see #getEXGeographicExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXGeographicExtentPropertyType_Href();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getNilReason <em>Nil Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nil Reason</em>'.
	 * @see org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getNilReason()
	 * @see #getEXGeographicExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXGeographicExtentPropertyType_NilReason();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getRole()
	 * @see #getEXGeographicExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXGeographicExtentPropertyType_Role();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getShow <em>Show</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Show</em>'.
	 * @see org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getShow()
	 * @see #getEXGeographicExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXGeographicExtentPropertyType_Show();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getTitle()
	 * @see #getEXGeographicExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXGeographicExtentPropertyType_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getType()
	 * @see #getEXGeographicExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXGeographicExtentPropertyType_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getUuidref <em>Uuidref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uuidref</em>'.
	 * @see org.isotc211._2005.gmd.EXGeographicExtentPropertyType#getUuidref()
	 * @see #getEXGeographicExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXGeographicExtentPropertyType_Uuidref();

	/**
	 * Returns the meta object for class '{@link org.isotc211._2005.gmd.EXTemporalExtentPropertyType <em>EX Temporal Extent Property Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>EX Temporal Extent Property Type</em>'.
	 * @see org.isotc211._2005.gmd.EXTemporalExtentPropertyType
	 * @generated
	 */
	EClass getEXTemporalExtentPropertyType();

	/**
	 * Returns the meta object for the attribute list '{@link org.isotc211._2005.gmd.EXTemporalExtentPropertyType#getEXTemporalExtentGroup <em>EX Temporal Extent Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>EX Temporal Extent Group</em>'.
	 * @see org.isotc211._2005.gmd.EXTemporalExtentPropertyType#getEXTemporalExtentGroup()
	 * @see #getEXTemporalExtentPropertyType()
	 * @generated
	 */
	EAttribute getEXTemporalExtentPropertyType_EXTemporalExtentGroup();

	/**
	 * Returns the meta object for the containment reference '{@link org.isotc211._2005.gmd.EXTemporalExtentPropertyType#getEXTemporalExtent <em>EX Temporal Extent</em>}'.
	 * <!-- begin-u