/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package oasis.names.tc.ciq.xsdschema.xAL;

import org.eclipse.emf.ecore.EFactory;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see oasis.names.tc.ciq.xsdschema.xAL.XALPackage
 * @generated
 */
@ProviderType
public interface XALFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	XALFactory eINSTANCE = oasis.names.tc.ciq.xsdschema.xAL.impl.XALFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Address Details</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Address Details</em>'.
	 * @generated
	 */
	AddressDetails createAddressDetails();

	/**
	 * Returns a new object of class '<em>Address Identifier Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Address Identifier Type</em>'.
	 * @generated
	 */
	AddressIdentifierType createAddressIdentifierType();

	/**
	 * Returns a new object of class '<em>Address Latitude Direction Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Address Latitude Direction Type</em>'.
	 * @generated
	 */
	AddressLatitudeDirectionType createAddressLatitudeDirectionType();

	/**
	 * Returns a new object of class '<em>Address Latitude Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Address Latitude Type</em>'.
	 * @generated
	 */
	AddressLatitudeType createAddressLatitudeType();

	/**
	 * Returns a new object of class '<em>Address Lines Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Address Lines Type</em>'.
	 * @generated
	 */
	AddressLinesType createAddressLinesType();

	/**
	 * Returns a new object of class '<em>Address Line Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Address Line Type</em>'.
	 * @generated
	 */
	AddressLineType createAddressLineType();

	/**
	 * Returns a new object of class '<em>Address Longitude Direction Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Address Longitude Direction Type</em>'.
	 * @generated
	 */
	AddressLongitudeDirectionType createAddressLongitudeDirectionType();

	/**
	 * Returns a new object of class '<em>Address Longitude Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Address Longitude Type</em>'.
	 * @generated
	 */
	AddressLongitudeType createAddressLongitudeType();

	/**
	 * Returns a new object of class '<em>Address Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Address Type</em>'.
	 * @generated
	 */
	AddressType createAddressType();

	/**
	 * Returns a new object of class '<em>Administrative Area Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Administrative Area Name Type</em>'.
	 * @generated
	 */
	AdministrativeAreaNameType createAdministrativeAreaNameType();

	/**
	 * Returns a new object of class '<em>Administrative Area Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Administrative Area Type</em>'.
	 * @generated
	 */
	AdministrativeAreaType createAdministrativeAreaType();

	/**
	 * Returns a new object of class '<em>Barcode Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Barcode Type</em>'.
	 * @generated
	 */
	BarcodeType createBarcodeType();

	/**
	 * Returns a new object of class '<em>Building Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Building Name Type</em>'.
	 * @generated
	 */
	BuildingNameType createBuildingNameType();

	/**
	 * Returns a new object of class '<em>Country Name Code Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Country Name Code Type</em>'.
	 * @generated
	 */
	CountryNameCodeType createCountryNameCodeType();

	/**
	 * Returns a new object of class '<em>Country Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Country Name Type</em>'.
	 * @generated
	 */
	CountryNameType createCountryNameType();

	/**
	 * Returns a new object of class '<em>Country Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Country Type</em>'.
	 * @generated
	 */
	CountryType createCountryType();

	/**
	 * Returns a new object of class '<em>Department Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Department Name Type</em>'.
	 * @generated
	 */
	DepartmentNameType createDepartmentNameType();

	/**
	 * Returns a new object of class '<em>Department Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Department Type</em>'.
	 * @generated
	 */
	DepartmentType createDepartmentType();

	/**
	 * Returns a new object of class '<em>Dependent Locality Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dependent Locality Name Type</em>'.
	 * @generated
	 */
	DependentLocalityNameType createDependentLocalityNameType();

	/**
	 * Returns a new object of class '<em>Dependent Locality Number Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dependent Locality Number Type</em>'.
	 * @generated
	 */
	DependentLocalityNumberType createDependentLocalityNumberType();

	/**
	 * Returns a new object of class '<em>Dependent Locality Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dependent Locality Type</em>'.
	 * @generated
	 */
	DependentLocalityType createDependentLocalityType();

	/**
	 * Returns a new object of class '<em>Dependent Thoroughfare Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dependent Thoroughfare Type</em>'.
	 * @generated
	 */
	DependentThoroughfareType createDependentThoroughfareType();

	/**
	 * Returns a new object of class '<em>Endorsement Line Code Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Endorsement Line Code Type</em>'.
	 * @generated
	 */
	EndorsementLineCodeType createEndorsementLineCodeType();

	/**
	 * Returns a new object of class '<em>Firm Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Firm Name Type</em>'.
	 * @generated
	 */
	FirmNameType createFirmNameType();

	/**
	 * Returns a new object of class '<em>Firm Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Firm Type</em>'.
	 * @generated
	 */
	FirmType createFirmType();

	/**
	 * Returns a new object of class '<em>Key Line Code Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Key Line Code Type</em>'.
	 * @generated
	 */
	KeyLineCodeType createKeyLineCodeType();

	/**
	 * Returns a new object of class '<em>Large Mail User Identifier Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Large Mail User Identifier Type</em>'.
	 * @generated
	 */
	LargeMailUserIdentifierType createLargeMailUserIdentifierType();

	/**
	 * Returns a new object of class '<em>Large Mail User Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Large Mail User Name Type</em>'.
	 * @generated
	 */
	LargeMailUserNameType createLargeMailUserNameType();

	/**
	 * Returns a new object of class '<em>Large Mail User Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Large Mail User Type</em>'.
	 * @generated
	 */
	LargeMailUserType createLargeMailUserType();

	/**
	 * Returns a new object of class '<em>Locality Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Locality Name Type</em>'.
	 * @generated
	 */
	LocalityNameType createLocalityNameType();

	/**
	 * Returns a new object of class '<em>Locality Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Locality Type</em>'.
	 * @generated
	 */
	LocalityType createLocalityType();

	/**
	 * Returns a new object of class '<em>Mail Stop Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mail Stop Name Type</em>'.
	 * @generated
	 */
	MailStopNameType createMailStopNameType();

	/**
	 * Returns a new object of class '<em>Mail Stop Number Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mail Stop Number Type</em>'.
	 * @generated
	 */
	MailStopNumberType createMailStopNumberType();

	/**
	 * Returns a new object of class '<em>Mail Stop Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mail Stop Type</em>'.
	 * @generated
	 */
	MailStopType createMailStopType();

	/**
	 * Returns a new object of class '<em>Postal Code Number Extension Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Postal Code Number Extension Type</em>'.
	 * @generated
	 */
	PostalCodeNumberExtensionType createPostalCodeNumberExtensionType();

	/**
	 * Returns a new object of class '<em>Postal Code Number Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Postal Code Number Type</em>'.
	 * @generated
	 */
	PostalCodeNumberType createPostalCodeNumberType();

	/**
	 * Returns a new object of class '<em>Postal Code Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Postal Code Type</em>'.
	 * @generated
	 */
	PostalCodeType createPostalCodeType();

	/**
	 * Returns a new object of class '<em>Postal Route Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Postal Route Name Type</em>'.
	 * @generated
	 */
	PostalRouteNameType createPostalRouteNameType();

	/**
	 * Returns a new object of class '<em>Postal Route Number Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Postal Route Number Type</em>'.
	 * @generated
	 */
	PostalRouteNumberType createPostalRouteNumberType();

	/**
	 * Returns a new object of class '<em>Postal Route Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Postal Route Type</em>'.
	 * @generated
	 */
	PostalRouteType createPostalRouteType();

	/**
	 * Returns a new object of class '<em>Postal Service Elements Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Postal Service Elements Type</em>'.
	 * @generated
	 */
	PostalServiceElementsType createPostalServiceElementsType();

	/**
	 * Returns a new object of class '<em>Post Box Number Extension Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Post Box Number Extension Type</em>'.
	 * @generated
	 */
	PostBoxNumberExtensionType createPostBoxNumberExtensionType();

	/**
	 * Returns a new object of class '<em>Post Box Number Prefix Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Post Box Number Prefix Type</em>'.
	 * @generated
	 */
	PostBoxNumberPrefixType createPostBoxNumberPrefixType();

	/**
	 * Returns a new object of class '<em>Post Box Number Suffix Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Post Box Number Suffix Type</em>'.
	 * @generated
	 */
	PostBoxNumberSuffixType createPostBoxNumberSuffixType();

	/**
	 * Returns a new object of class '<em>Post Box Number Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Post Box Number Type</em>'.
	 * @generated
	 */
	PostBoxNumberType createPostBoxNumberType();

	/**
	 * Returns a new object of class '<em>Post Box Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Post Box Type</em>'.
	 * @generated
	 */
	PostBoxType createPostBoxType();

	/**
	 * Returns a new object of class '<em>Post Office Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Post Office Name Type</em>'.
	 * @generated
	 */
	PostOfficeNameType createPostOfficeNameType();

	/**
	 * Returns a new object of class '<em>Post Office Number Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Post Office Number Type</em>'.
	 * @generated
	 */
	PostOfficeNumberType createPostOfficeNumberType();

	/**
	 * Returns a new object of class '<em>Post Office Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Post Office Type</em>'.
	 * @generated
	 */
	PostOfficeType createPostOfficeType();

	/**
	 * Returns a new object of class '<em>Post Town Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Post Town Name Type</em>'.
	 * @generated
	 */
	PostTownNameType createPostTownNameType();

	/**
	 * Returns a new object of class '<em>Post Town Suffix Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Post Town Suffix Type</em>'.
	 * @generated
	 */
	PostTownSuffixType createPostTownSuffixType();

	/**
	 * Returns a new object of class '<em>Post Town Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Post Town Type</em>'.
	 * @generated
	 */
	PostTownType createPostTownType();

	/**
	 * Returns a new object of class '<em>Premise Location Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Premise Location Type</em>'.
	 * @generated
	 */
	PremiseLocationType createPremiseLocationType();

	/**
	 * Returns a new object of class '<em>Premise Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Premise Name Type</em>'.
	 * @generated
	 */
	PremiseNameType createPremiseNameType();

	/**
	 * Returns a new object of class '<em>Premise Number Prefix Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Premise Number Prefix Type</em>'.
	 * @generated
	 */
	PremiseNumberPrefixType createPremiseNumberPrefixType();

	/**
	 * Returns a new object of class '<em>Premise Number Range From Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Premise Number Range From Type</em>'.
	 * @generated
	 */
	PremiseNumberRangeFromType createPremiseNumberRangeFromType();

	/**
	 * Returns a new object of class '<em>Premise Number Range To Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Premise Number Range To Type</em>'.
	 * @generated
	 */
	PremiseNumberRangeToType createPremiseNumberRangeToType();

	/**
	 * Returns a new object of class '<em>Premise Number Range Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Premise Number Range Type</em>'.
	 * @generated
	 */
	PremiseNumberRangeType createPremiseNumberRangeType();

	/**
	 * Returns a new object of class '<em>Premise Number Suffix Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Premise Number Suffix Type</em>'.
	 * @generated
	 */
	PremiseNumberSuffixType createPremiseNumberSuffixType();

	/**
	 * Returns a new object of class '<em>Premise Number Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Premise Number Type</em>'.
	 * @generated
	 */
	PremiseNumberType createPremiseNumberType();

	/**
	 * Returns a new object of class '<em>Premise Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Premise Type</em>'.
	 * @generated
	 */
	PremiseType createPremiseType();

	/**
	 * Returns a new object of class '<em>Sorting Code Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sorting Code Type</em>'.
	 * @generated
	 */
	SortingCodeType createSortingCodeType();

	/**
	 * Returns a new object of class '<em>Sub Administrative Area Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sub Administrative Area Name Type</em>'.
	 * @generated
	 */
	SubAdministrativeAreaNameType createSubAdministrativeAreaNameType();

	/**
	 * Returns a new object of class '<em>Sub Administrative Area Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sub Administrative Area Type</em>'.
	 * @generated
	 */
	SubAdministrativeAreaType createSubAdministrativeAreaType();

	/**
	 * Returns a new object of class '<em>Sub Premise Location Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sub Premise Location Type</em>'.
	 * @generated
	 */
	SubPremiseLocationType createSubPremiseLocationType();

	/**
	 * Returns a new object of class '<em>Sub Premise Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sub Premise Name Type</em>'.
	 * @generated
	 */
	SubPremiseNameType createSubPremiseNameType();

	/**
	 * Returns a new object of class '<em>Sub Premise Number Prefix Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sub Premise Number Prefix Type</em>'.
	 * @generated
	 */
	SubPremiseNumberPrefixType createSubPremiseNumberPrefixType();

	/**
	 * Returns a new object of class '<em>Sub Premise Number Suffix Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sub Premise Number Suffix Type</em>'.
	 * @generated
	 */
	SubPremiseNumberSuffixType createSubPremiseNumberSuffixType();

	/**
	 * Returns a new object of class '<em>Sub Premise Number Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sub Premise Number Type</em>'.
	 * @generated
	 */
	SubPremiseNumberType createSubPremiseNumberType();

	/**
	 * Returns a new object of class '<em>Sub Premise Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sub Premise Type</em>'.
	 * @generated
	 */
	SubPremiseType createSubPremiseType();

	/**
	 * Returns a new object of class '<em>Supplementary Postal Service Data Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Supplementary Postal Service Data Type</em>'.
	 * @generated
	 */
	SupplementaryPostalServiceDataType createSupplementaryPostalServiceDataType();

	/**
	 * Returns a new object of class '<em>Thoroughfare Leading Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Thoroughfare Leading Type Type</em>'.
	 * @generated
	 */
	ThoroughfareLeadingTypeType createThoroughfareLeadingTypeType();

	/**
	 * Returns a new object of class '<em>Thoroughfare Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Thoroughfare Name Type</em>'.
	 * @generated
	 */
	ThoroughfareNameType createThoroughfareNameType();

	/**
	 * Returns a new object of class '<em>Thoroughfare Number From Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Thoroughfare Number From Type</em>'.
	 * @generated
	 */
	ThoroughfareNumberFromType createThoroughfareNumberFromType();

	/**
	 * Returns a new object of class '<em>Thoroughfare Number Prefix Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Thoroughfare Number Prefix Type</em>'.
	 * @generated
	 */
	ThoroughfareNumberPrefixType createThoroughfareNumberPrefixType();

	/**
	 * Returns a new object of class '<em>Thoroughfare Number Range Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Thoroughfare Number Range Type</em>'.
	 * @generated
	 */
	ThoroughfareNumberRangeType createThoroughfareNumberRangeType();

	/**
	 * Returns a new object of class '<em>Thoroughfare Number Suffix Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Thoroughfare Number Suffix Type</em>'.
	 * @generated
	 */
	ThoroughfareNumberSuffixType createThoroughfareNumberSuffixType();

	/**
	 * Returns a new object of class '<em>Thoroughfare Number To Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Thoroughfare Number To Type</em>'.
	 * @generated
	 */
	ThoroughfareNumberToType createThoroughfareNumberToType();

	/**
	 * Returns a new object of class '<em>Thoroughfare Number Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Thoroughfare Number Type</em>'.
	 * @generated
	 */
	ThoroughfareNumberType createThoroughfareNumberType();

	/**
	 * Returns a new object of class '<em>Thoroughfare Post Direction Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Thoroughfare Post Direction Type</em>'.
	 * @generated
	 */
	ThoroughfarePostDirectionType createThoroughfarePostDirectionType();

	/**
	 * Returns a new object of class '<em>Thoroughfare Pre Direction Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Thoroughfare Pre Direction Type</em>'.
	 * @generated
	 */
	ThoroughfarePreDirectionType createThoroughfarePreDirectionType();

	/**
	 * Returns a new object of class '<em>Thoroughfare Trailing Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Thoroughfare Trailing Type Type</em>'.
	 * @generated
	 */
	ThoroughfareTrailingTypeType createThoroughfareTrailingTypeType();

	/**
	 * Returns a new object of class '<em>Thoroughfare Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Thoroughfare Type</em>'.
	 * @generated
	 */
	ThoroughfareType createThoroughfareType();

	/**
	 * Returns a new object of class '<em>Document Root</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Document Root</em>'.
	 * @generated
	 */
	DocumentRoot createDocumentRoot();

	/**
	 * Returns a new object of class '<em>Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Type</em>'.
	 * @generated
	 */
	XALType createXALType();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	XALPackage getXALPackage();

} //XALFactory
