/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package net.opengis.gml;

import java.math.BigInteger;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Covariance Element Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * An element of a covariance matrix.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link net.opengis.gml.CovarianceElementType#getRowIndex <em>Row Index</em>}</li>
 *   <li>{@link net.opengis.gml.CovarianceElementType#getColumnIndex <em>Column Index</em>}</li>
 *   <li>{@link net.opengis.gml.CovarianceElementType#getCovariance <em>Covariance</em>}</li>
 * </ul>
 *
 * @see net.opengis.gml.GMLPackage#getCovarianceElementType()
 * @model extendedMetaData="name='CovarianceElementType' kind='elementOnly'"
 * @generated
 */
@ProviderType
public interface CovarianceElementType extends EObject {
	/**
	 * Returns the value of the '<em><b>Row Index</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Row number of this covariance element value. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Row Index</em>' attribute.
	 * @see #setRowIndex(BigInteger)
	 * @see net.opengis.gml.GMLPackage#getCovarianceElementType_RowIndex()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.PositiveInteger" required="true"
	 *        extendedMetaData="kind='element' name='rowIndex' namespace='##targetNamespace'"
	 * @generated
	 */
	BigInteger getRowIndex();

	/**
	 * Sets the value of the '{@link net.opengis.gml.CovarianceElementType#getRowIndex <em>Row Index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Row Index</em>' attribute.
	 * @see #getRowIndex()
	 * @generated
	 */
	void setRowIndex(BigInteger value);

	/**
	 * Returns the value of the '<em><b>Column Index</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Column number of this covariance element value. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Column Index</em>' attribute.
	 * @see #setColumnIndex(BigInteger)
	 * @see net.opengis.gml.GMLPackage#getCovarianceElementType_ColumnIndex()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.PositiveInteger" required="true"
	 *        extendedMetaData="kind='element' name='columnIndex' namespace='##targetNamespace'"
	 * @generated
	 */
	BigInteger getColumnIndex();

	/**
	 * Sets the value of the '{@link net.opengis.gml.CovarianceElementType#getColumnIndex <em>Column Index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Column Index</em>' attribute.
	 * @see #getColumnIndex()
	 * @generated
	 */
	void setColumnIndex(BigInteger value);

	/**
	 * Returns the value of the '<em><b>Covariance</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Value of covariance matrix element. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Covariance</em>' attribute.
	 * @see #isSetCovariance()
	 * @see #unsetCovariance()
	 * @see #setCovariance(double)
	 * @see net.opengis.gml.GMLPackage#getCovarianceElementType_Covariance()
	 * @model unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.Double" required="true"
	 *        extendedMetaData="kind='element' name='covariance' namespace='##targetNamespace'"
	 * @generated
	 */
	double getCovariance();

	/**
	 * Sets the value of the '{@link net.opengis.gml.CovarianceElementType#getCovariance <em>Covariance</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Covariance</em>' attribute.
	 * @see #isSetCovariance()
	 * @see #unsetCovariance()
	 * @see #getCovariance()
	 * @generated
	 */
	void setCovariance(double value);

	/**
	 * Unsets the value of the '{@link net.opengis.gml.CovarianceElementType#getCovariance <em>Covariance</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetCovariance()
	 * @see #getCovariance()
	 * @see #setCovariance(double)
	 * @generated
	 */
	void unsetCovariance();

	/**
	 * Returns whether the value of the '{@link net.opengis.gml.CovarianceElementType#getCovariance <em>Covariance</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Covariance</em>' attribute is set.
	 * @see #unsetCovariance()
	 * @see #getCovariance()
	 * @see #setCovariance(double)
	 * @generated
	 */
	boolean isSetCovariance();

} // CovarianceElementType
