/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package net.opengis.gml;

import org.eclipse.emf.ecore.EFactory;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see net.opengis.gml.GMLPackage
 * @generated
 */
@ProviderType
public interface GMLFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	GMLFactory eINSTANCE = net.opengis.gml.impl.GMLFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Absolute External Positional Accuracy Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Absolute External Positional Accuracy Type</em>'.
	 * @generated
	 */
	AbsoluteExternalPositionalAccuracyType createAbsoluteExternalPositionalAccuracyType();

	/**
	 * Returns a new object of class '<em>Abstract General Operation Parameter Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Abstract General Operation Parameter Ref Type</em>'.
	 * @generated
	 */
	AbstractGeneralOperationParameterRefType createAbstractGeneralOperationParameterRefType();

	/**
	 * Returns a new object of class '<em>Abstract Gridded Surface Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Abstract Gridded Surface Type</em>'.
	 * @generated
	 */
	AbstractGriddedSurfaceType createAbstractGriddedSurfaceType();

	/**
	 * Returns a new object of class '<em>Abstract Parametric Curve Surface Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Abstract Parametric Curve Surface Type</em>'.
	 * @generated
	 */
	AbstractParametricCurveSurfaceType createAbstractParametricCurveSurfaceType();

	/**
	 * Returns a new object of class '<em>Abstract Ring Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Abstract Ring Property Type</em>'.
	 * @generated
	 */
	AbstractRingPropertyType createAbstractRingPropertyType();

	/**
	 * Returns a new object of class '<em>Abstract Solid Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Abstract Solid Type</em>'.
	 * @generated
	 */
	AbstractSolidType createAbstractSolidType();

	/**
	 * Returns a new object of class '<em>Abstract Surface Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Abstract Surface Type</em>'.
	 * @generated
	 */
	AbstractSurfaceType createAbstractSurfaceType();

	/**
	 * Returns a new object of class '<em>Affine Placement Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Affine Placement Type</em>'.
	 * @generated
	 */
	AffinePlacementType createAffinePlacementType();

	/**
	 * Returns a new object of class '<em>Angle Choice Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Angle Choice Type</em>'.
	 * @generated
	 */
	AngleChoiceType createAngleChoiceType();

	/**
	 * Returns a new object of class '<em>Angle Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Angle Type</em>'.
	 * @generated
	 */
	AngleType createAngleType();

	/**
	 * Returns a new object of class '<em>Arc By Bulge Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Arc By Bulge Type</em>'.
	 * @generated
	 */
	ArcByBulgeType createArcByBulgeType();

	/**
	 * Returns a new object of class '<em>Arc By Center Point Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Arc By Center Point Type</em>'.
	 * @generated
	 */
	ArcByCenterPointType createArcByCenterPointType();

	/**
	 * Returns a new object of class '<em>Arc String By Bulge Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Arc String By Bulge Type</em>'.
	 * @generated
	 */
	ArcStringByBulgeType createArcStringByBulgeType();

	/**
	 * Returns a new object of class '<em>Arc String Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Arc String Type</em>'.
	 * @generated
	 */
	ArcStringType createArcStringType();

	/**
	 * Returns a new object of class '<em>Arc Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Arc Type</em>'.
	 * @generated
	 */
	ArcType createArcType();

	/**
	 * Returns a new object of class '<em>Area Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Area Type</em>'.
	 * @generated
	 */
	AreaType createAreaType();

	/**
	 * Returns a new object of class '<em>Array Association Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Array Association Type</em>'.
	 * @generated
	 */
	ArrayAssociationType createArrayAssociationType();

	/**
	 * Returns a new object of class '<em>Array Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Array Type</em>'.
	 * @generated
	 */
	ArrayType createArrayType();

	/**
	 * Returns a new object of class '<em>Association Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Association Type</em>'.
	 * @generated
	 */
	AssociationType createAssociationType();

	/**
	 * Returns a new object of class '<em>Bag Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Bag Type</em>'.
	 * @generated
	 */
	BagType createBagType();

	/**
	 * Returns a new object of class '<em>Base Style Descriptor Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Base Style Descriptor Type</em>'.
	 * @generated
	 */
	BaseStyleDescriptorType createBaseStyleDescriptorType();

	/**
	 * Returns a new object of class '<em>Base Unit Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Base Unit Type</em>'.
	 * @generated
	 */
	BaseUnitType createBaseUnitType();

	/**
	 * Returns a new object of class '<em>Bezier Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Bezier Type</em>'.
	 * @generated
	 */
	BezierType createBezierType();

	/**
	 * Returns a new object of class '<em>Boolean Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Boolean Property Type</em>'.
	 * @generated
	 */
	BooleanPropertyType createBooleanPropertyType();

	/**
	 * Returns a new object of class '<em>Bounding Shape Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Bounding Shape Type</em>'.
	 * @generated
	 */
	BoundingShapeType createBoundingShapeType();

	/**
	 * Returns a new object of class '<em>BSpline Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>BSpline Type</em>'.
	 * @generated
	 */
	BSplineType createBSplineType();

	/**
	 * Returns a new object of class '<em>Cartesian CS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cartesian CS Ref Type</em>'.
	 * @generated
	 */
	CartesianCSRefType createCartesianCSRefType();

	/**
	 * Returns a new object of class '<em>Cartesian CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cartesian CS Type</em>'.
	 * @generated
	 */
	CartesianCSType createCartesianCSType();

	/**
	 * Returns a new object of class '<em>Category Extent Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Category Extent Type</em>'.
	 * @generated
	 */
	CategoryExtentType createCategoryExtentType();

	/**
	 * Returns a new object of class '<em>Category Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Category Property Type</em>'.
	 * @generated
	 */
	CategoryPropertyType createCategoryPropertyType();

	/**
	 * Returns a new object of class '<em>Circle By Center Point Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Circle By Center Point Type</em>'.
	 * @generated
	 */
	CircleByCenterPointType createCircleByCenterPointType();

	/**
	 * Returns a new object of class '<em>Circle Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Circle Type</em>'.
	 * @generated
	 */
	CircleType createCircleType();

	/**
	 * Returns a new object of class '<em>Clothoid Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clothoid Type</em>'.
	 * @generated
	 */
	ClothoidType createClothoidType();

	/**
	 * Returns a new object of class '<em>Code List Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Code List Type</em>'.
	 * @generated
	 */
	CodeListType createCodeListType();

	/**
	 * Returns a new object of class '<em>Code Or Null List Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Code Or Null List Type</em>'.
	 * @generated
	 */
	CodeOrNullListType createCodeOrNullListType();

	/**
	 * Returns a new object of class '<em>Code Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Code Type</em>'.
	 * @generated
	 */
	CodeType createCodeType();

	/**
	 * Returns a new object of class '<em>Composite Curve Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Composite Curve Property Type</em>'.
	 * @generated
	 */
	CompositeCurvePropertyType createCompositeCurvePropertyType();

	/**
	 * Returns a new object of class '<em>Composite Curve Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Composite Curve Type</em>'.
	 * @generated
	 */
	CompositeCurveType createCompositeCurveType();

	/**
	 * Returns a new object of class '<em>Composite Solid Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Composite Solid Property Type</em>'.
	 * @generated
	 */
	CompositeSolidPropertyType createCompositeSolidPropertyType();

	/**
	 * Returns a new object of class '<em>Composite Solid Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Composite Solid Type</em>'.
	 * @generated
	 */
	CompositeSolidType createCompositeSolidType();

	/**
	 * Returns a new object of class '<em>Composite Surface Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Composite Surface Property Type</em>'.
	 * @generated
	 */
	CompositeSurfacePropertyType createCompositeSurfacePropertyType();

	/**
	 * Returns a new object of class '<em>Composite Surface Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Composite Surface Type</em>'.
	 * @generated
	 */
	CompositeSurfaceType createCompositeSurfaceType();

	/**
	 * Returns a new object of class '<em>Composite Value Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Composite Value Type</em>'.
	 * @generated
	 */
	CompositeValueType createCompositeValueType();

	/**
	 * Returns a new object of class '<em>Compound CRS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Compound CRS Ref Type</em>'.
	 * @generated
	 */
	CompoundCRSRefType createCompoundCRSRefType();

	/**
	 * Returns a new object of class '<em>Compound CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Compound CRS Type</em>'.
	 * @generated
	 */
	CompoundCRSType createCompoundCRSType();

	/**
	 * Returns a new object of class '<em>Concatenated Operation Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Concatenated Operation Ref Type</em>'.
	 * @generated
	 */
	ConcatenatedOperationRefType createConcatenatedOperationRefType();

	/**
	 * Returns a new object of class '<em>Concatenated Operation Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Concatenated Operation Type</em>'.
	 * @generated
	 */
	ConcatenatedOperationType createConcatenatedOperationType();

	/**
	 * Returns a new object of class '<em>Cone Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cone Type</em>'.
	 * @generated
	 */
	ConeType createConeType();

	/**
	 * Returns a new object of class '<em>Container Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Container Property Type</em>'.
	 * @generated
	 */
	ContainerPropertyType createContainerPropertyType();

	/**
	 * Returns a new object of class '<em>Control Point Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Control Point Type</em>'.
	 * @generated
	 */
	ControlPointType createControlPointType();

	/**
	 * Returns a new object of class '<em>Conventional Unit Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Conventional Unit Type</em>'.
	 * @generated
	 */
	ConventionalUnitType createConventionalUnitType();

	/**
	 * Returns a new object of class '<em>Conversion Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Conversion Ref Type</em>'.
	 * @generated
	 */
	ConversionRefType createConversionRefType();

	/**
	 * Returns a new object of class '<em>Conversion To Preferred Unit Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Conversion To Preferred Unit Type</em>'.
	 * @generated
	 */
	ConversionToPreferredUnitType createConversionToPreferredUnitType();

	/**
	 * Returns a new object of class '<em>Conversion Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Conversion Type</em>'.
	 * @generated
	 */
	ConversionType createConversionType();

	/**
	 * Returns a new object of class '<em>Coordinate Operation Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Coordinate Operation Ref Type</em>'.
	 * @generated
	 */
	CoordinateOperationRefType createCoordinateOperationRefType();

	/**
	 * Returns a new object of class '<em>Coordinate Reference System Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Coordinate Reference System Ref Type</em>'.
	 * @generated
	 */
	CoordinateReferenceSystemRefType createCoordinateReferenceSystemRefType();

	/**
	 * Returns a new object of class '<em>Coordinates Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Coordinates Type</em>'.
	 * @generated
	 */
	CoordinatesType createCoordinatesType();

	/**
	 * Returns a new object of class '<em>Coordinate System Axis Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Coordinate System Axis Ref Type</em>'.
	 * @generated
	 */
	CoordinateSystemAxisRefType createCoordinateSystemAxisRefType();

	/**
	 * Returns a new object of class '<em>Coordinate System Axis Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Coordinate System Axis Type</em>'.
	 * @generated
	 */
	CoordinateSystemAxisType createCoordinateSystemAxisType();

	/**
	 * Returns a new object of class '<em>Coordinate System Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Coordinate System Ref Type</em>'.
	 * @generated
	 */
	CoordinateSystemRefType createCoordinateSystemRefType();

	/**
	 * Returns a new object of class '<em>Coord Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Coord Type</em>'.
	 * @generated
	 */
	CoordType createCoordType();

	/**
	 * Returns a new object of class '<em>Count Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Count Property Type</em>'.
	 * @generated
	 */
	CountPropertyType createCountPropertyType();

	/**
	 * Returns a new object of class '<em>Covariance Element Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Covariance Element Type</em>'.
	 * @generated
	 */
	CovarianceElementType createCovarianceElementType();

	/**
	 * Returns a new object of class '<em>Covariance Matrix Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Covariance Matrix Type</em>'.
	 * @generated
	 */
	CovarianceMatrixType createCovarianceMatrixType();

	/**
	 * Returns a new object of class '<em>Coverage Function Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Coverage Function Type</em>'.
	 * @generated
	 */
	CoverageFunctionType createCoverageFunctionType();

	/**
	 * Returns a new object of class '<em>CRS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CRS Ref Type</em>'.
	 * @generated
	 */
	CRSRefType createCRSRefType();

	/**
	 * Returns a new object of class '<em>Cubic Spline Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cubic Spline Type</em>'.
	 * @generated
	 */
	CubicSplineType createCubicSplineType();

	/**
	 * Returns a new object of class '<em>Curve Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Curve Array Property Type</em>'.
	 * @generated
	 */
	CurveArrayPropertyType createCurveArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Curve Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Curve Property Type</em>'.
	 * @generated
	 */
	CurvePropertyType createCurvePropertyType();

	/**
	 * Returns a new object of class '<em>Curve Segment Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Curve Segment Array Property Type</em>'.
	 * @generated
	 */
	CurveSegmentArrayPropertyType createCurveSegmentArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Curve Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Curve Type</em>'.
	 * @generated
	 */
	CurveType createCurveType();

	/**
	 * Returns a new object of class '<em>Cylinder Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cylinder Type</em>'.
	 * @generated
	 */
	CylinderType createCylinderType();

	/**
	 * Returns a new object of class '<em>Cylindrical CS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cylindrical CS Ref Type</em>'.
	 * @generated
	 */
	CylindricalCSRefType createCylindricalCSRefType();

	/**
	 * Returns a new object of class '<em>Cylindrical CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cylindrical CS Type</em>'.
	 * @generated
	 */
	CylindricalCSType createCylindricalCSType();

	/**
	 * Returns a new object of class '<em>Data Block Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Block Type</em>'.
	 * @generated
	 */
	DataBlockType createDataBlockType();

	/**
	 * Returns a new object of class '<em>Datum Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Datum Ref Type</em>'.
	 * @generated
	 */
	DatumRefType createDatumRefType();

	/**
	 * Returns a new object of class '<em>Default Style Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Default Style Property Type</em>'.
	 * @generated
	 */
	DefaultStylePropertyType createDefaultStylePropertyType();

	/**
	 * Returns a new object of class '<em>Definition Proxy Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Definition Proxy Type</em>'.
	 * @generated
	 */
	DefinitionProxyType createDefinitionProxyType();

	/**
	 * Returns a new object of class '<em>Definition Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Definition Type</em>'.
	 * @generated
	 */
	DefinitionType createDefinitionType();

	/**
	 * Returns a new object of class '<em>Degrees Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Degrees Type</em>'.
	 * @generated
	 */
	DegreesType createDegreesType();

	/**
	 * Returns a new object of class '<em>Derivation Unit Term Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Derivation Unit Term Type</em>'.
	 * @generated
	 */
	DerivationUnitTermType createDerivationUnitTermType();

	/**
	 * Returns a new object of class '<em>Derived CRS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Derived CRS Ref Type</em>'.
	 * @generated
	 */
	DerivedCRSRefType createDerivedCRSRefType();

	/**
	 * Returns a new object of class '<em>Derived CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Derived CRS Type</em>'.
	 * @generated
	 */
	DerivedCRSType createDerivedCRSType();

	/**
	 * Returns a new object of class '<em>Derived CRS Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Derived CRS Type Type</em>'.
	 * @generated
	 */
	DerivedCRSTypeType createDerivedCRSTypeType();

	/**
	 * Returns a new object of class '<em>Derived Unit Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Derived Unit Type</em>'.
	 * @generated
	 */
	DerivedUnitType createDerivedUnitType();

	/**
	 * Returns a new object of class '<em>Dictionary Entry Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dictionary Entry Type</em>'.
	 * @generated
	 */
	DictionaryEntryType createDictionaryEntryType();

	/**
	 * Returns a new object of class '<em>Dictionary Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dictionary Type</em>'.
	 * @generated
	 */
	DictionaryType createDictionaryType();

	/**
	 * Returns a new object of class '<em>Directed Edge Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Directed Edge Property Type</em>'.
	 * @generated
	 */
	DirectedEdgePropertyType createDirectedEdgePropertyType();

	/**
	 * Returns a new object of class '<em>Directed Face Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Directed Face Property Type</em>'.
	 * @generated
	 */
	DirectedFacePropertyType createDirectedFacePropertyType();

	/**
	 * Returns a new object of class '<em>Directed Node Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Directed Node Property Type</em>'.
	 * @generated
	 */
	DirectedNodePropertyType createDirectedNodePropertyType();

	/**
	 * Returns a new object of class '<em>Directed Observation At Distance Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Directed Observation At Distance Type</em>'.
	 * @generated
	 */
	DirectedObservationAtDistanceType createDirectedObservationAtDistanceType();

	/**
	 * Returns a new object of class '<em>Directed Observation Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Directed Observation Type</em>'.
	 * @generated
	 */
	DirectedObservationType createDirectedObservationType();

	/**
	 * Returns a new object of class '<em>Directed Topo Solid Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Directed Topo Solid Property Type</em>'.
	 * @generated
	 */
	DirectedTopoSolidPropertyType createDirectedTopoSolidPropertyType();

	/**
	 * Returns a new object of class '<em>Direction Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Direction Property Type</em>'.
	 * @generated
	 */
	DirectionPropertyType createDirectionPropertyType();

	/**
	 * Returns a new object of class '<em>Direction Vector Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Direction Vector Type</em>'.
	 * @generated
	 */
	DirectionVectorType createDirectionVectorType();

	/**
	 * Returns a new object of class '<em>Direct Position List Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Direct Position List Type</em>'.
	 * @generated
	 */
	DirectPositionListType createDirectPositionListType();

	/**
	 * Returns a new object of class '<em>Direct Position Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Direct Position Type</em>'.
	 * @generated
	 */
	DirectPositionType createDirectPositionType();

	/**
	 * Returns a new object of class '<em>DMS Angle Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>DMS Angle Type</em>'.
	 * @generated
	 */
	DMSAngleType createDMSAngleType();

	/**
	 * Returns a new object of class '<em>Document Root</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Document Root</em>'.
	 * @generated
	 */
	DocumentRoot createDocumentRoot();

	/**
	 * Returns a new object of class '<em>Domain Set Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Domain Set Type</em>'.
	 * @generated
	 */
	DomainSetType createDomainSetType();

	/**
	 * Returns a new object of class '<em>Dynamic Feature Collection Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dynamic Feature Collection Type</em>'.
	 * @generated
	 */
	DynamicFeatureCollectionType createDynamicFeatureCollectionType();

	/**
	 * Returns a new object of class '<em>Dynamic Feature Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dynamic Feature Type</em>'.
	 * @generated
	 */
	DynamicFeatureType createDynamicFeatureType();

	/**
	 * Returns a new object of class '<em>Edge Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Edge Type</em>'.
	 * @generated
	 */
	EdgeType createEdgeType();

	/**
	 * Returns a new object of class '<em>Ellipsoidal CS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ellipsoidal CS Ref Type</em>'.
	 * @generated
	 */
	EllipsoidalCSRefType createEllipsoidalCSRefType();

	/**
	 * Returns a new object of class '<em>Ellipsoidal CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ellipsoidal CS Type</em>'.
	 * @generated
	 */
	EllipsoidalCSType createEllipsoidalCSType();

	/**
	 * Returns a new object of class '<em>Ellipsoid Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ellipsoid Ref Type</em>'.
	 * @generated
	 */
	EllipsoidRefType createEllipsoidRefType();

	/**
	 * Returns a new object of class '<em>Ellipsoid Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ellipsoid Type</em>'.
	 * @generated
	 */
	EllipsoidType createEllipsoidType();

	/**
	 * Returns a new object of class '<em>Engineering CRS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Engineering CRS Ref Type</em>'.
	 * @generated
	 */
	EngineeringCRSRefType createEngineeringCRSRefType();

	/**
	 * Returns a new object of class '<em>Engineering CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Engineering CRS Type</em>'.
	 * @generated
	 */
	EngineeringCRSType createEngineeringCRSType();

	/**
	 * Returns a new object of class '<em>Engineering Datum Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Engineering Datum Ref Type</em>'.
	 * @generated
	 */
	EngineeringDatumRefType createEngineeringDatumRefType();

	/**
	 * Returns a new object of class '<em>Engineering Datum Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Engineering Datum Type</em>'.
	 * @generated
	 */
	EngineeringDatumType createEngineeringDatumType();

	/**
	 * Returns a new object of class '<em>Envelope Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Envelope Type</em>'.
	 * @generated
	 */
	EnvelopeType createEnvelopeType();

	/**
	 * Returns a new object of class '<em>Envelope With Time Period Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Envelope With Time Period Type</em>'.
	 * @generated
	 */
	EnvelopeWithTimePeriodType createEnvelopeWithTimePeriodType();

	/**
	 * Returns a new object of class '<em>Extent Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Extent Type</em>'.
	 * @generated
	 */
	ExtentType createExtentType();

	/**
	 * Returns a new object of class '<em>Face Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Face Type</em>'.
	 * @generated
	 */
	FaceType createFaceType();

	/**
	 * Returns a new object of class '<em>Feature Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Feature Array Property Type</em>'.
	 * @generated
	 */
	FeatureArrayPropertyType createFeatureArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Feature Collection Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Feature Collection Type</em>'.
	 * @generated
	 */
	FeatureCollectionType createFeatureCollectionType();

	/**
	 * Returns a new object of class '<em>Feature Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Feature Property Type</em>'.
	 * @generated
	 */
	FeaturePropertyType createFeaturePropertyType();

	/**
	 * Returns a new object of class '<em>Feature Style Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Feature Style Property Type</em>'.
	 * @generated
	 */
	FeatureStylePropertyType createFeatureStylePropertyType();

	/**
	 * Returns a new object of class '<em>Feature Style Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Feature Style Type</em>'.
	 * @generated
	 */
	FeatureStyleType createFeatureStyleType();

	/**
	 * Returns a new object of class '<em>File Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>File Type</em>'.
	 * @generated
	 */
	FileType createFileType();

	/**
	 * Returns a new object of class '<em>Formula Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Formula Type</em>'.
	 * @generated
	 */
	FormulaType createFormulaType();

	/**
	 * Returns a new object of class '<em>General Conversion Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>General Conversion Ref Type</em>'.
	 * @generated
	 */
	GeneralConversionRefType createGeneralConversionRefType();

	/**
	 * Returns a new object of class '<em>General Transformation Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>General Transformation Ref Type</em>'.
	 * @generated
	 */
	GeneralTransformationRefType createGeneralTransformationRefType();

	/**
	 * Returns a new object of class '<em>Generic Meta Data Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Generic Meta Data Type</em>'.
	 * @generated
	 */
	GenericMetaDataType createGenericMetaDataType();

	/**
	 * Returns a new object of class '<em>Geocentric CRS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geocentric CRS Ref Type</em>'.
	 * @generated
	 */
	GeocentricCRSRefType createGeocentricCRSRefType();

	/**
	 * Returns a new object of class '<em>Geocentric CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geocentric CRS Type</em>'.
	 * @generated
	 */
	GeocentricCRSType createGeocentricCRSType();

	/**
	 * Returns a new object of class '<em>Geodesic String Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geodesic String Type</em>'.
	 * @generated
	 */
	GeodesicStringType createGeodesicStringType();

	/**
	 * Returns a new object of class '<em>Geodesic Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geodesic Type</em>'.
	 * @generated
	 */
	GeodesicType createGeodesicType();

	/**
	 * Returns a new object of class '<em>Geodetic Datum Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geodetic Datum Ref Type</em>'.
	 * @generated
	 */
	GeodeticDatumRefType createGeodeticDatumRefType();

	/**
	 * Returns a new object of class '<em>Geodetic Datum Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geodetic Datum Type</em>'.
	 * @generated
	 */
	GeodeticDatumType createGeodeticDatumType();

	/**
	 * Returns a new object of class '<em>Geographic CRS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geographic CRS Ref Type</em>'.
	 * @generated
	 */
	GeographicCRSRefType createGeographicCRSRefType();

	/**
	 * Returns a new object of class '<em>Geographic CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geographic CRS Type</em>'.
	 * @generated
	 */
	GeographicCRSType createGeographicCRSType();

	/**
	 * Returns a new object of class '<em>Geometric Complex Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geometric Complex Property Type</em>'.
	 * @generated
	 */
	GeometricComplexPropertyType createGeometricComplexPropertyType();

	/**
	 * Returns a new object of class '<em>Geometric Complex Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geometric Complex Type</em>'.
	 * @generated
	 */
	GeometricComplexType createGeometricComplexType();

	/**
	 * Returns a new object of class '<em>Geometric Primitive Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geometric Primitive Property Type</em>'.
	 * @generated
	 */
	GeometricPrimitivePropertyType createGeometricPrimitivePropertyType();

	/**
	 * Returns a new object of class '<em>Geometry Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geometry Array Property Type</em>'.
	 * @generated
	 */
	GeometryArrayPropertyType createGeometryArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Geometry Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geometry Property Type</em>'.
	 * @generated
	 */
	GeometryPropertyType createGeometryPropertyType();

	/**
	 * Returns a new object of class '<em>Geometry Style Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geometry Style Property Type</em>'.
	 * @generated
	 */
	GeometryStylePropertyType createGeometryStylePropertyType();

	/**
	 * Returns a new object of class '<em>Geometry Style Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geometry Style Type</em>'.
	 * @generated
	 */
	GeometryStyleType createGeometryStyleType();

	/**
	 * Returns a new object of class '<em>Graph Style Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Graph Style Property Type</em>'.
	 * @generated
	 */
	GraphStylePropertyType createGraphStylePropertyType();

	/**
	 * Returns a new object of class '<em>Graph Style Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Graph Style Type</em>'.
	 * @generated
	 */
	GraphStyleType createGraphStyleType();

	/**
	 * Returns a new object of class '<em>Grid Coverage Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Grid Coverage Type</em>'.
	 * @generated
	 */
	GridCoverageType createGridCoverageType();

	/**
	 * Returns a new object of class '<em>Grid Domain Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Grid Domain Type</em>'.
	 * @generated
	 */
	GridDomainType createGridDomainType();

	/**
	 * Returns a new object of class '<em>Grid Envelope Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Grid Envelope Type</em>'.
	 * @generated
	 */
	GridEnvelopeType createGridEnvelopeType();

	/**
	 * Returns a new object of class '<em>Grid Function Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Grid Function Type</em>'.
	 * @generated
	 */
	GridFunctionType createGridFunctionType();

	/**
	 * Returns a new object of class '<em>Grid Length Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Grid Length Type</em>'.
	 * @generated
	 */
	GridLengthType createGridLengthType();

	/**
	 * Returns a new object of class '<em>Grid Limits Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Grid Limits Type</em>'.
	 * @generated
	 */
	GridLimitsType createGridLimitsType();

	/**
	 * Returns a new object of class '<em>Grid Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Grid Type</em>'.
	 * @generated
	 */
	GridType createGridType();

	/**
	 * Returns a new object of class '<em>History Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>History Property Type</em>'.
	 * @generated
	 */
	HistoryPropertyType createHistoryPropertyType();

	/**
	 * Returns a new object of class '<em>Identifier Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Identifier Type</em>'.
	 * @generated
	 */
	IdentifierType createIdentifierType();

	/**
	 * Returns a new object of class '<em>Image CRS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Image CRS Ref Type</em>'.
	 * @generated
	 */
	ImageCRSRefType createImageCRSRefType();

	/**
	 * Returns a new object of class '<em>Image CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Image CRS Type</em>'.
	 * @generated
	 */
	ImageCRSType createImageCRSType();

	/**
	 * Returns a new object of class '<em>Image Datum Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Image Datum Ref Type</em>'.
	 * @generated
	 */
	ImageDatumRefType createImageDatumRefType();

	/**
	 * Returns a new object of class '<em>Image Datum Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Image Datum Type</em>'.
	 * @generated
	 */
	ImageDatumType createImageDatumType();

	/**
	 * Returns a new object of class '<em>Index Map Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Index Map Type</em>'.
	 * @generated
	 */
	IndexMapType createIndexMapType();

	/**
	 * Returns a new object of class '<em>Indirect Entry Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Indirect Entry Type</em>'.
	 * @generated
	 */
	IndirectEntryType createIndirectEntryType();

	/**
	 * Returns a new object of class '<em>Isolated Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Isolated Property Type</em>'.
	 * @generated
	 */
	IsolatedPropertyType createIsolatedPropertyType();

	/**
	 * Returns a new object of class '<em>Knot Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Knot Property Type</em>'.
	 * @generated
	 */
	KnotPropertyType createKnotPropertyType();

	/**
	 * Returns a new object of class '<em>Knot Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Knot Type</em>'.
	 * @generated
	 */
	KnotType createKnotType();

	/**
	 * Returns a new object of class '<em>Label Style Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Label Style Property Type</em>'.
	 * @generated
	 */
	LabelStylePropertyType createLabelStylePropertyType();

	/**
	 * Returns a new object of class '<em>Label Style Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Label Style Type</em>'.
	 * @generated
	 */
	LabelStyleType createLabelStyleType();

	/**
	 * Returns a new object of class '<em>Label Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Label Type</em>'.
	 * @generated
	 */
	LabelType createLabelType();

	/**
	 * Returns a new object of class '<em>Length Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Length Type</em>'.
	 * @generated
	 */
	LengthType createLengthType();

	/**
	 * Returns a new object of class '<em>Linear CS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Linear CS Ref Type</em>'.
	 * @generated
	 */
	LinearCSRefType createLinearCSRefType();

	/**
	 * Returns a new object of class '<em>Linear CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Linear CS Type</em>'.
	 * @generated
	 */
	LinearCSType createLinearCSType();

	/**
	 * Returns a new object of class '<em>Linear Ring Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Linear Ring Property Type</em>'.
	 * @generated
	 */
	LinearRingPropertyType createLinearRingPropertyType();

	/**
	 * Returns a new object of class '<em>Linear Ring Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Linear Ring Type</em>'.
	 * @generated
	 */
	LinearRingType createLinearRingType();

	/**
	 * Returns a new object of class '<em>Line String Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Line String Property Type</em>'.
	 * @generated
	 */
	LineStringPropertyType createLineStringPropertyType();

	/**
	 * Returns a new object of class '<em>Line String Segment Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Line String Segment Array Property Type</em>'.
	 * @generated
	 */
	LineStringSegmentArrayPropertyType createLineStringSegmentArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Line String Segment Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Line String Segment Type</em>'.
	 * @generated
	 */
	LineStringSegmentType createLineStringSegmentType();

	/**
	 * Returns a new object of class '<em>Line String Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Line String Type</em>'.
	 * @generated
	 */
	LineStringType createLineStringType();

	/**
	 * Returns a new object of class '<em>Location Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Location Property Type</em>'.
	 * @generated
	 */
	LocationPropertyType createLocationPropertyType();

	/**
	 * Returns a new object of class '<em>Measure List Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Measure List Type</em>'.
	 * @generated
	 */
	MeasureListType createMeasureListType();

	/**
	 * Returns a new object of class '<em>Measure Or Null List Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Measure Or Null List Type</em>'.
	 * @generated
	 */
	MeasureOrNullListType createMeasureOrNullListType();

	/**
	 * Returns a new object of class '<em>Measure Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Measure Type</em>'.
	 * @generated
	 */
	MeasureType createMeasureType();

	/**
	 * Returns a new object of class '<em>Meta Data Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Meta Data Property Type</em>'.
	 * @generated
	 */
	MetaDataPropertyType createMetaDataPropertyType();

	/**
	 * Returns a new object of class '<em>Moving Object Status Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Moving Object Status Type</em>'.
	 * @generated
	 */
	MovingObjectStatusType createMovingObjectStatusType();

	/**
	 * Returns a new object of class '<em>Multi Curve Coverage Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Curve Coverage Type</em>'.
	 * @generated
	 */
	MultiCurveCoverageType createMultiCurveCoverageType();

	/**
	 * Returns a new object of class '<em>Multi Curve Domain Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Curve Domain Type</em>'.
	 * @generated
	 */
	MultiCurveDomainType createMultiCurveDomainType();

	/**
	 * Returns a new object of class '<em>Multi Curve Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Curve Property Type</em>'.
	 * @generated
	 */
	MultiCurvePropertyType createMultiCurvePropertyType();

	/**
	 * Returns a new object of class '<em>Multi Curve Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Curve Type</em>'.
	 * @generated
	 */
	MultiCurveType createMultiCurveType();

	/**
	 * Returns a new object of class '<em>Multi Geometry Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Geometry Property Type</em>'.
	 * @generated
	 */
	MultiGeometryPropertyType createMultiGeometryPropertyType();

	/**
	 * Returns a new object of class '<em>Multi Geometry Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Geometry Type</em>'.
	 * @generated
	 */
	MultiGeometryType createMultiGeometryType();

	/**
	 * Returns a new object of class '<em>Multi Line String Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Line String Property Type</em>'.
	 * @generated
	 */
	MultiLineStringPropertyType createMultiLineStringPropertyType();

	/**
	 * Returns a new object of class '<em>Multi Line String Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Line String Type</em>'.
	 * @generated
	 */
	MultiLineStringType createMultiLineStringType();

	/**
	 * Returns a new object of class '<em>Multi Point Coverage Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Point Coverage Type</em>'.
	 * @generated
	 */
	MultiPointCoverageType createMultiPointCoverageType();

	/**
	 * Returns a new object of class '<em>Multi Point Domain Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Point Domain Type</em>'.
	 * @generated
	 */
	MultiPointDomainType createMultiPointDomainType();

	/**
	 * Returns a new object of class '<em>Multi Point Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Point Property Type</em>'.
	 * @generated
	 */
	MultiPointPropertyType createMultiPointPropertyType();

	/**
	 * Returns a new object of class '<em>Multi Point Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Point Type</em>'.
	 * @generated
	 */
	MultiPointType createMultiPointType();

	/**
	 * Returns a new object of class '<em>Multi Polygon Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Polygon Property Type</em>'.
	 * @generated
	 */
	MultiPolygonPropertyType createMultiPolygonPropertyType();

	/**
	 * Returns a new object of class '<em>Multi Polygon Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Polygon Type</em>'.
	 * @generated
	 */
	MultiPolygonType createMultiPolygonType();

	/**
	 * Returns a new object of class '<em>Multi Solid Coverage Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Solid Coverage Type</em>'.
	 * @generated
	 */
	MultiSolidCoverageType createMultiSolidCoverageType();

	/**
	 * Returns a new object of class '<em>Multi Solid Domain Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Solid Domain Type</em>'.
	 * @generated
	 */
	MultiSolidDomainType createMultiSolidDomainType();

	/**
	 * Returns a new object of class '<em>Multi Solid Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Solid Property Type</em>'.
	 * @generated
	 */
	MultiSolidPropertyType createMultiSolidPropertyType();

	/**
	 * Returns a new object of class '<em>Multi Solid Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Solid Type</em>'.
	 * @generated
	 */
	MultiSolidType createMultiSolidType();

	/**
	 * Returns a new object of class '<em>Multi Surface Coverage Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Surface Coverage Type</em>'.
	 * @generated
	 */
	MultiSurfaceCoverageType createMultiSurfaceCoverageType();

	/**
	 * Returns a new object of class '<em>Multi Surface Domain Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Surface Domain Type</em>'.
	 * @generated
	 */
	MultiSurfaceDomainType createMultiSurfaceDomainType();

	/**
	 * Returns a new object of class '<em>Multi Surface Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Surface Property Type</em>'.
	 * @generated
	 */
	MultiSurfacePropertyType createMultiSurfacePropertyType();

	/**
	 * Returns a new object of class '<em>Multi Surface Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multi Surface Type</em>'.
	 * @generated
	 */
	MultiSurfaceType createMultiSurfaceType();

	/**
	 * Returns a new object of class '<em>Node Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Node Type</em>'.
	 * @generated
	 */
	NodeType createNodeType();

	/**
	 * Returns a new object of class '<em>Oblique Cartesian CS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Oblique Cartesian CS Ref Type</em>'.
	 * @generated
	 */
	ObliqueCartesianCSRefType createObliqueCartesianCSRefType();

	/**
	 * Returns a new object of class '<em>Oblique Cartesian CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Oblique Cartesian CS Type</em>'.
	 * @generated
	 */
	ObliqueCartesianCSType createObliqueCartesianCSType();

	/**
	 * Returns a new object of class '<em>Observation Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Observation Type</em>'.
	 * @generated
	 */
	ObservationType createObservationType();

	/**
	 * Returns a new object of class '<em>Offset Curve Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Offset Curve Type</em>'.
	 * @generated
	 */
	OffsetCurveType createOffsetCurveType();

	/**
	 * Returns a new object of class '<em>Operation Method Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operation Method Ref Type</em>'.
	 * @generated
	 */
	OperationMethodRefType createOperationMethodRefType();

	/**
	 * Returns a new object of class '<em>Operation Method Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operation Method Type</em>'.
	 * @generated
	 */
	OperationMethodType createOperationMethodType();

	/**
	 * Returns a new object of class '<em>Operation Parameter Group Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operation Parameter Group Ref Type</em>'.
	 * @generated
	 */
	OperationParameterGroupRefType createOperationParameterGroupRefType();

	/**
	 * Returns a new object of class '<em>Operation Parameter Group Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operation Parameter Group Type</em>'.
	 * @generated
	 */
	OperationParameterGroupType createOperationParameterGroupType();

	/**
	 * Returns a new object of class '<em>Operation Parameter Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operation Parameter Ref Type</em>'.
	 * @generated
	 */
	OperationParameterRefType createOperationParameterRefType();

	/**
	 * Returns a new object of class '<em>Operation Parameter Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operation Parameter Type</em>'.
	 * @generated
	 */
	OperationParameterType createOperationParameterType();

	/**
	 * Returns a new object of class '<em>Operation Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operation Ref Type</em>'.
	 * @generated
	 */
	OperationRefType createOperationRefType();

	/**
	 * Returns a new object of class '<em>Orientable Curve Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Orientable Curve Type</em>'.
	 * @generated
	 */
	OrientableCurveType createOrientableCurveType();

	/**
	 * Returns a new object of class '<em>Orientable Surface Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Orientable Surface Type</em>'.
	 * @generated
	 */
	OrientableSurfaceType createOrientableSurfaceType();

	/**
	 * Returns a new object of class '<em>Parameter Value Group Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Parameter Value Group Type</em>'.
	 * @generated
	 */
	ParameterValueGroupType createParameterValueGroupType();

	/**
	 * Returns a new object of class '<em>Parameter Value Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Parameter Value Type</em>'.
	 * @generated
	 */
	ParameterValueType createParameterValueType();

	/**
	 * Returns a new object of class '<em>Pass Through Operation Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Pass Through Operation Ref Type</em>'.
	 * @generated
	 */
	PassThroughOperationRefType createPassThroughOperationRefType();

	/**
	 * Returns a new object of class '<em>Pass Through Operation Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Pass Through Operation Type</em>'.
	 * @generated
	 */
	PassThroughOperationType createPassThroughOperationType();

	/**
	 * Returns a new object of class '<em>Pixel In Cell Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Pixel In Cell Type</em>'.
	 * @generated
	 */
	PixelInCellType createPixelInCellType();

	/**
	 * Returns a new object of class '<em>Point Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Point Array Property Type</em>'.
	 * @generated
	 */
	PointArrayPropertyType createPointArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Point Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Point Property Type</em>'.
	 * @generated
	 */
	PointPropertyType createPointPropertyType();

	/**
	 * Returns a new object of class '<em>Point Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Point Type</em>'.
	 * @generated
	 */
	PointType createPointType();

	/**
	 * Returns a new object of class '<em>Polar CS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Polar CS Ref Type</em>'.
	 * @generated
	 */
	PolarCSRefType createPolarCSRefType();

	/**
	 * Returns a new object of class '<em>Polar CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Polar CS Type</em>'.
	 * @generated
	 */
	PolarCSType createPolarCSType();

	/**
	 * Returns a new object of class '<em>Polygon Patch Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Polygon Patch Array Property Type</em>'.
	 * @generated
	 */
	PolygonPatchArrayPropertyType createPolygonPatchArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Polygon Patch Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Polygon Patch Type</em>'.
	 * @generated
	 */
	PolygonPatchType createPolygonPatchType();

	/**
	 * Returns a new object of class '<em>Polygon Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Polygon Property Type</em>'.
	 * @generated
	 */
	PolygonPropertyType createPolygonPropertyType();

	/**
	 * Returns a new object of class '<em>Polygon Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Polygon Type</em>'.
	 * @generated
	 */
	PolygonType createPolygonType();

	/**
	 * Returns a new object of class '<em>Polyhedral Surface Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Polyhedral Surface Type</em>'.
	 * @generated
	 */
	PolyhedralSurfaceType createPolyhedralSurfaceType();

	/**
	 * Returns a new object of class '<em>Prime Meridian Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Prime Meridian Ref Type</em>'.
	 * @generated
	 */
	PrimeMeridianRefType createPrimeMeridianRefType();

	/**
	 * Returns a new object of class '<em>Prime Meridian Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Prime Meridian Type</em>'.
	 * @generated
	 */
	PrimeMeridianType createPrimeMeridianType();

	/**
	 * Returns a new object of class '<em>Priority Location Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Priority Location Property Type</em>'.
	 * @generated
	 */
	PriorityLocationPropertyType createPriorityLocationPropertyType();

	/**
	 * Returns a new object of class '<em>Projected CRS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Projected CRS Ref Type</em>'.
	 * @generated
	 */
	ProjectedCRSRefType createProjectedCRSRefType();

	/**
	 * Returns a new object of class '<em>Projected CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Projected CRS Type</em>'.
	 * @generated
	 */
	ProjectedCRSType createProjectedCRSType();

	/**
	 * Returns a new object of class '<em>Quantity Extent Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Quantity Extent Type</em>'.
	 * @generated
	 */
	QuantityExtentType createQuantityExtentType();

	/**
	 * Returns a new object of class '<em>Quantity Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Quantity Property Type</em>'.
	 * @generated
	 */
	QuantityPropertyType createQuantityPropertyType();

	/**
	 * Returns a new object of class '<em>Range Parameters Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Range Parameters Type</em>'.
	 * @generated
	 */
	RangeParametersType createRangeParametersType();

	/**
	 * Returns a new object of class '<em>Range Set Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Range Set Type</em>'.
	 * @generated
	 */
	RangeSetType createRangeSetType();

	/**
	 * Returns a new object of class '<em>Rectangle Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Rectangle Type</em>'.
	 * @generated
	 */
	RectangleType createRectangleType();

	/**
	 * Returns a new object of class '<em>Rectified Grid Coverage Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Rectified Grid Coverage Type</em>'.
	 * @generated
	 */
	RectifiedGridCoverageType createRectifiedGridCoverageType();

	/**
	 * Returns a new object of class '<em>Rectified Grid Domain Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Rectified Grid Domain Type</em>'.
	 * @generated
	 */
	RectifiedGridDomainType createRectifiedGridDomainType();

	/**
	 * Returns a new object of class '<em>Rectified Grid Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Rectified Grid Type</em>'.
	 * @generated
	 */
	RectifiedGridType createRectifiedGridType();

	/**
	 * Returns a new object of class '<em>Reference System Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Reference System Ref Type</em>'.
	 * @generated
	 */
	ReferenceSystemRefType createReferenceSystemRefType();

	/**
	 * Returns a new object of class '<em>Reference Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Reference Type</em>'.
	 * @generated
	 */
	ReferenceType createReferenceType();

	/**
	 * Returns a new object of class '<em>Ref Location Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ref Location Type</em>'.
	 * @generated
	 */
	RefLocationType createRefLocationType();

	/**
	 * Returns a new object of class '<em>Related Time Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Related Time Type</em>'.
	 * @generated
	 */
	RelatedTimeType createRelatedTimeType();

	/**
	 * Returns a new object of class '<em>Relative Internal Positional Accuracy Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Relative Internal Positional Accuracy Type</em>'.
	 * @generated
	 */
	RelativeInternalPositionalAccuracyType createRelativeInternalPositionalAccuracyType();

	/**
	 * Returns a new object of class '<em>Ring Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ring Property Type</em>'.
	 * @generated
	 */
	RingPropertyType createRingPropertyType();

	/**
	 * Returns a new object of class '<em>Ring Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ring Type</em>'.
	 * @generated
	 */
	RingType createRingType();

	/**
	 * Returns a new object of class '<em>Row Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Row Type</em>'.
	 * @generated
	 */
	RowType createRowType();

	/**
	 * Returns a new object of class '<em>Scalar Value Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Scalar Value Property Type</em>'.
	 * @generated
	 */
	ScalarValuePropertyType createScalarValuePropertyType();

	/**
	 * Returns a new object of class '<em>Scale Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Scale Type</em>'.
	 * @generated
	 */
	ScaleType createScaleType();

	/**
	 * Returns a new object of class '<em>Second Defining Parameter Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Second Defining Parameter Type</em>'.
	 * @generated
	 */
	SecondDefiningParameterType createSecondDefiningParameterType();

	/**
	 * Returns a new object of class '<em>Sequence Rule Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sequence Rule Type</em>'.
	 * @generated
	 */
	SequenceRuleType createSequenceRuleType();

	/**
	 * Returns a new object of class '<em>Single Operation Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Single Operation Ref Type</em>'.
	 * @generated
	 */
	SingleOperationRefType createSingleOperationRefType();

	/**
	 * Returns a new object of class '<em>Solid Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Solid Array Property Type</em>'.
	 * @generated
	 */
	SolidArrayPropertyType createSolidArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Solid Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Solid Property Type</em>'.
	 * @generated
	 */
	SolidPropertyType createSolidPropertyType();

	/**
	 * Returns a new object of class '<em>Solid Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Solid Type</em>'.
	 * @generated
	 */
	SolidType createSolidType();

	/**
	 * Returns a new object of class '<em>Speed Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Speed Type</em>'.
	 * @generated
	 */
	SpeedType createSpeedType();

	/**
	 * Returns a new object of class '<em>Sphere Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sphere Type</em>'.
	 * @generated
	 */
	SphereType createSphereType();

	/**
	 * Returns a new object of class '<em>Spherical CS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Spherical CS Ref Type</em>'.
	 * @generated
	 */
	SphericalCSRefType createSphericalCSRefType();

	/**
	 * Returns a new object of class '<em>Spherical CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Spherical CS Type</em>'.
	 * @generated
	 */
	SphericalCSType createSphericalCSType();

	/**
	 * Returns a new object of class '<em>String Or Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>String Or Ref Type</em>'.
	 * @generated
	 */
	StringOrRefType createStringOrRefType();

	/**
	 * Returns a new object of class '<em>Style Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Style Type</em>'.
	 * @generated
	 */
	StyleType createStyleType();

	/**
	 * Returns a new object of class '<em>Style Variation Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Style Variation Type</em>'.
	 * @generated
	 */
	StyleVariationType createStyleVariationType();

	/**
	 * Returns a new object of class '<em>Surface Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Surface Array Property Type</em>'.
	 * @generated
	 */
	SurfaceArrayPropertyType createSurfaceArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Surface Patch Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Surface Patch Array Property Type</em>'.
	 * @generated
	 */
	SurfacePatchArrayPropertyType createSurfacePatchArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Surface Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Surface Property Type</em>'.
	 * @generated
	 */
	SurfacePropertyType createSurfacePropertyType();

	/**
	 * Returns a new object of class '<em>Surface Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Surface Type</em>'.
	 * @generated
	 */
	SurfaceType createSurfaceType();

	/**
	 * Returns a new object of class '<em>Symbol Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Symbol Type</em>'.
	 * @generated
	 */
	SymbolType createSymbolType();

	/**
	 * Returns a new object of class '<em>Target Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Target Property Type</em>'.
	 * @generated
	 */
	TargetPropertyType createTargetPropertyType();

	/**
	 * Returns a new object of class '<em>Temporal CRS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Temporal CRS Ref Type</em>'.
	 * @generated
	 */
	TemporalCRSRefType createTemporalCRSRefType();

	/**
	 * Returns a new object of class '<em>Temporal CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Temporal CRS Type</em>'.
	 * @generated
	 */
	TemporalCRSType createTemporalCRSType();

	/**
	 * Returns a new object of class '<em>Temporal CS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Temporal CS Ref Type</em>'.
	 * @generated
	 */
	TemporalCSRefType createTemporalCSRefType();

	/**
	 * Returns a new object of class '<em>Temporal CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Temporal CS Type</em>'.
	 * @generated
	 */
	TemporalCSType createTemporalCSType();

	/**
	 * Returns a new object of class '<em>Temporal Datum Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Temporal Datum Ref Type</em>'.
	 * @generated
	 */
	TemporalDatumRefType createTemporalDatumRefType();

	/**
	 * Returns a new object of class '<em>Temporal Datum Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Temporal Datum Type</em>'.
	 * @generated
	 */
	TemporalDatumType createTemporalDatumType();

	/**
	 * Returns a new object of class '<em>Time Calendar Era Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Calendar Era Property Type</em>'.
	 * @generated
	 */
	TimeCalendarEraPropertyType createTimeCalendarEraPropertyType();

	/**
	 * Returns a new object of class '<em>Time Calendar Era Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Calendar Era Type</em>'.
	 * @generated
	 */
	TimeCalendarEraType createTimeCalendarEraType();

	/**
	 * Returns a new object of class '<em>Time Calendar Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Calendar Property Type</em>'.
	 * @generated
	 */
	TimeCalendarPropertyType createTimeCalendarPropertyType();

	/**
	 * Returns a new object of class '<em>Time Calendar Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Calendar Type</em>'.
	 * @generated
	 */
	TimeCalendarType createTimeCalendarType();

	/**
	 * Returns a new object of class '<em>Time Clock Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Clock Property Type</em>'.
	 * @generated
	 */
	TimeClockPropertyType createTimeClockPropertyType();

	/**
	 * Returns a new object of class '<em>Time Clock Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Clock Type</em>'.
	 * @generated
	 */
	TimeClockType createTimeClockType();

	/**
	 * Returns a new object of class '<em>Time Coordinate System Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Coordinate System Type</em>'.
	 * @generated
	 */
	TimeCoordinateSystemType createTimeCoordinateSystemType();

	/**
	 * Returns a new object of class '<em>Time Edge Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Edge Property Type</em>'.
	 * @generated
	 */
	TimeEdgePropertyType createTimeEdgePropertyType();

	/**
	 * Returns a new object of class '<em>Time Edge Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Edge Type</em>'.
	 * @generated
	 */
	TimeEdgeType createTimeEdgeType();

	/**
	 * Returns a new object of class '<em>Time Geometric Primitive Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Geometric Primitive Property Type</em>'.
	 * @generated
	 */
	TimeGeometricPrimitivePropertyType createTimeGeometricPrimitivePropertyType();

	/**
	 * Returns a new object of class '<em>Time Instant Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Instant Property Type</em>'.
	 * @generated
	 */
	TimeInstantPropertyType createTimeInstantPropertyType();

	/**
	 * Returns a new object of class '<em>Time Instant Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Instant Type</em>'.
	 * @generated
	 */
	TimeInstantType createTimeInstantType();

	/**
	 * Returns a new object of class '<em>Time Interval Length Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Interval Length Type</em>'.
	 * @generated
	 */
	TimeIntervalLengthType createTimeIntervalLengthType();

	/**
	 * Returns a new object of class '<em>Time Node Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Node Property Type</em>'.
	 * @generated
	 */
	TimeNodePropertyType createTimeNodePropertyType();

	/**
	 * Returns a new object of class '<em>Time Node Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Node Type</em>'.
	 * @generated
	 */
	TimeNodeType createTimeNodeType();

	/**
	 * Returns a new object of class '<em>Time Ordinal Era Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Ordinal Era Property Type</em>'.
	 * @generated
	 */
	TimeOrdinalEraPropertyType createTimeOrdinalEraPropertyType();

	/**
	 * Returns a new object of class '<em>Time Ordinal Era Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Ordinal Era Type</em>'.
	 * @generated
	 */
	TimeOrdinalEraType createTimeOrdinalEraType();

	/**
	 * Returns a new object of class '<em>Time Ordinal Reference System Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Ordinal Reference System Type</em>'.
	 * @generated
	 */
	TimeOrdinalReferenceSystemType createTimeOrdinalReferenceSystemType();

	/**
	 * Returns a new object of class '<em>Time Period Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Period Property Type</em>'.
	 * @generated
	 */
	TimePeriodPropertyType createTimePeriodPropertyType();

	/**
	 * Returns a new object of class '<em>Time Period Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Period Type</em>'.
	 * @generated
	 */
	TimePeriodType createTimePeriodType();

	/**
	 * Returns a new object of class '<em>Time Position Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Position Type</em>'.
	 * @generated
	 */
	TimePositionType createTimePositionType();

	/**
	 * Returns a new object of class '<em>Time Primitive Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Primitive Property Type</em>'.
	 * @generated
	 */
	TimePrimitivePropertyType createTimePrimitivePropertyType();

	/**
	 * Returns a new object of class '<em>Time Topology Complex Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Topology Complex Property Type</em>'.
	 * @generated
	 */
	TimeTopologyComplexPropertyType createTimeTopologyComplexPropertyType();

	/**
	 * Returns a new object of class '<em>Time Topology Complex Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Topology Complex Type</em>'.
	 * @generated
	 */
	TimeTopologyComplexType createTimeTopologyComplexType();

	/**
	 * Returns a new object of class '<em>Time Topology Primitive Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Topology Primitive Property Type</em>'.
	 * @generated
	 */
	TimeTopologyPrimitivePropertyType createTimeTopologyPrimitivePropertyType();

	/**
	 * Returns a new object of class '<em>Time Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Type</em>'.
	 * @generated
	 */
	TimeType createTimeType();

	/**
	 * Returns a new object of class '<em>Tin Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Tin Type</em>'.
	 * @generated
	 */
	TinType createTinType();

	/**
	 * Returns a new object of class '<em>Topo Complex Member Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Complex Member Type</em>'.
	 * @generated
	 */
	TopoComplexMemberType createTopoComplexMemberType();

	/**
	 * Returns a new object of class '<em>Topo Complex Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Complex Type</em>'.
	 * @generated
	 */
	TopoComplexType createTopoComplexType();

	/**
	 * Returns a new object of class '<em>Topo Curve Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Curve Property Type</em>'.
	 * @generated
	 */
	TopoCurvePropertyType createTopoCurvePropertyType();

	/**
	 * Returns a new object of class '<em>Topo Curve Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Curve Type</em>'.
	 * @generated
	 */
	TopoCurveType createTopoCurveType();

	/**
	 * Returns a new object of class '<em>Topology Style Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topology Style Property Type</em>'.
	 * @generated
	 */
	TopologyStylePropertyType createTopologyStylePropertyType();

	/**
	 * Returns a new object of class '<em>Topology Style Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topology Style Type</em>'.
	 * @generated
	 */
	TopologyStyleType createTopologyStyleType();

	/**
	 * Returns a new object of class '<em>Topo Point Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Point Property Type</em>'.
	 * @generated
	 */
	TopoPointPropertyType createTopoPointPropertyType();

	/**
	 * Returns a new object of class '<em>Topo Point Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Point Type</em>'.
	 * @generated
	 */
	TopoPointType createTopoPointType();

	/**
	 * Returns a new object of class '<em>Topo Primitive Array Association Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Primitive Array Association Type</em>'.
	 * @generated
	 */
	TopoPrimitiveArrayAssociationType createTopoPrimitiveArrayAssociationType();

	/**
	 * Returns a new object of class '<em>Topo Primitive Member Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Primitive Member Type</em>'.
	 * @generated
	 */
	TopoPrimitiveMemberType createTopoPrimitiveMemberType();

	/**
	 * Returns a new object of class '<em>Topo Solid Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Solid Type</em>'.
	 * @generated
	 */
	TopoSolidType createTopoSolidType();

	/**
	 * Returns a new object of class '<em>Topo Surface Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Surface Property Type</em>'.
	 * @generated
	 */
	TopoSurfacePropertyType createTopoSurfacePropertyType();

	/**
	 * Returns a new object of class '<em>Topo Surface Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Surface Type</em>'.
	 * @generated
	 */
	TopoSurfaceType createTopoSurfaceType();

	/**
	 * Returns a new object of class '<em>Topo Volume Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Volume Property Type</em>'.
	 * @generated
	 */
	TopoVolumePropertyType createTopoVolumePropertyType();

	/**
	 * Returns a new object of class '<em>Topo Volume Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Topo Volume Type</em>'.
	 * @generated
	 */
	TopoVolumeType createTopoVolumeType();

	/**
	 * Returns a new object of class '<em>Track Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Track Type</em>'.
	 * @generated
	 */
	TrackType createTrackType();

	/**
	 * Returns a new object of class '<em>Transformation Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Transformation Ref Type</em>'.
	 * @generated
	 */
	TransformationRefType createTransformationRefType();

	/**
	 * Returns a new object of class '<em>Transformation Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Transformation Type</em>'.
	 * @generated
	 */
	TransformationType createTransformationType();

	/**
	 * Returns a new object of class '<em>Triangle Patch Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Triangle Patch Array Property Type</em>'.
	 * @generated
	 */
	TrianglePatchArrayPropertyType createTrianglePatchArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Triangle Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Triangle Type</em>'.
	 * @generated
	 */
	TriangleType createTriangleType();

	/**
	 * Returns a new object of class '<em>Triangulated Surface Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Triangulated Surface Type</em>'.
	 * @generated
	 */
	TriangulatedSurfaceType createTriangulatedSurfaceType();

	/**
	 * Returns a new object of class '<em>Unit Definition Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Unit Definition Type</em>'.
	 * @generated
	 */
	UnitDefinitionType createUnitDefinitionType();

	/**
	 * Returns a new object of class '<em>Unit Of Measure Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Unit Of Measure Type</em>'.
	 * @generated
	 */
	UnitOfMeasureType createUnitOfMeasureType();

	/**
	 * Returns a new object of class '<em>User Defined CS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>User Defined CS Ref Type</em>'.
	 * @generated
	 */
	UserDefinedCSRefType createUserDefinedCSRefType();

	/**
	 * Returns a new object of class '<em>User Defined CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>User Defined CS Type</em>'.
	 * @generated
	 */
	UserDefinedCSType createUserDefinedCSType();

	/**
	 * Returns a new object of class '<em>Value Array Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Value Array Property Type</em>'.
	 * @generated
	 */
	ValueArrayPropertyType createValueArrayPropertyType();

	/**
	 * Returns a new object of class '<em>Value Array Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Value Array Type</em>'.
	 * @generated
	 */
	ValueArrayType createValueArrayType();

	/**
	 * Returns a new object of class '<em>Value Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Value Property Type</em>'.
	 * @generated
	 */
	ValuePropertyType createValuePropertyType();

	/**
	 * Returns a new object of class '<em>Vector Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Vector Type</em>'.
	 * @generated
	 */
	VectorType createVectorType();

	/**
	 * Returns a new object of class '<em>Vertical CRS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Vertical CRS Ref Type</em>'.
	 * @generated
	 */
	VerticalCRSRefType createVerticalCRSRefType();

	/**
	 * Returns a new object of class '<em>Vertical CRS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Vertical CRS Type</em>'.
	 * @generated
	 */
	VerticalCRSType createVerticalCRSType();

	/**
	 * Returns a new object of class '<em>Vertical CS Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Vertical CS Ref Type</em>'.
	 * @generated
	 */
	VerticalCSRefType createVerticalCSRefType();

	/**
	 * Returns a new object of class '<em>Vertical CS Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Vertical CS Type</em>'.
	 * @generated
	 */
	VerticalCSType createVerticalCSType();

	/**
	 * Returns a new object of class '<em>Vertical Datum Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Vertical Datum Ref Type</em>'.
	 * @generated
	 */
	VerticalDatumRefType createVerticalDatumRefType();

	/**
	 * Returns a new object of class '<em>Vertical Datum Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Vertical Datum Type</em>'.
	 * @generated
	 */
	VerticalDatumType createVerticalDatumType();

	/**
	 * Returns a new object of class '<em>Vertical Datum Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Vertical Datum Type Type</em>'.
	 * @generated
	 */
	VerticalDatumTypeType createVerticalDatumTypeType();

	/**
	 * Returns a new object of class '<em>Volume Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Volume Type</em>'.
	 * @generated
	 */
	VolumeType createVolumeType();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	GMLPackage getGMLPackage();

} //GMLFactory
