/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package net.opengis.gml;

import java.math.BigInteger;

import org.eclipse.emf.common.util.EList;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Operation Parameter Group Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The definition of a group of parameters used by an operation method. This complexType is expected to be used or extended for all applicable operation methods, without defining operation-method-specialized element names.  
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link net.opengis.gml.OperationParameterGroupType#getGroupID <em>Group ID</em>}</li>
 *   <li>{@link net.opengis.gml.OperationParameterGroupType#getRemarks <em>Remarks</em>}</li>
 *   <li>{@link net.opengis.gml.OperationParameterGroupType#getMaximumOccurs <em>Maximum Occurs</em>}</li>
 *   <li>{@link net.opengis.gml.OperationParameterGroupType#getIncludesParameter <em>Includes Parameter</em>}</li>
 * </ul>
 *
 * @see net.opengis.gml.GMLPackage#getOperationParameterGroupType()
 * @model extendedMetaData="name='OperationParameterGroupType' kind='elementOnly'"
 * @generated
 */
@ProviderType
public interface OperationParameterGroupType extends OperationParameterGroupBaseType {
	/**
	 * Returns the value of the '<em><b>Group ID</b></em>' containment reference list.
	 * The list contents are of type {@link net.opengis.gml.IdentifierType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Set of alternative identifications of this operation parameter group. The first groupID, if any, is normally the primary identification code, and any others are aliases. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Group ID</em>' containment reference list.
	 * @see net.opengis.gml.GMLPackage#getOperationParameterGroupType_GroupID()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='groupID' namespace='##targetNamespace'"
	 * @generated
	 */
	EList<IdentifierType> getGroupID();

	/**
	 * Returns the value of the '<em><b>Remarks</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Comments on or information about this operation parameter group, including source information. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Remarks</em>' containment reference.
	 * @see #setRemarks(StringOrRefType)
	 * @see net.opengis.gml.GMLPackage#getOperationParameterGroupType_Remarks()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='remarks' namespace='##targetNamespace'"
	 * @generated
	 */
	StringOrRefType getRemarks();

	/**
	 * Sets the value of the '{@link net.opengis.gml.OperationParameterGroupType#getRemarks <em>Remarks</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Remarks</em>' containment reference.
	 * @see #getRemarks()
	 * @generated
	 */
	void setRemarks(StringOrRefType value);

	/**
	 * Returns the value of the '<em><b>Maximum Occurs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The maximum number of times that values for this parameter group can be included. If this attribute is omitted, the maximum number is one. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Maximum Occurs</em>' attribute.
	 * @see #setMaximumOccurs(BigInteger)
	 * @see net.opengis.gml.GMLPackage#getOperationParameterGroupType_MaximumOccurs()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.PositiveInteger"
	 *        extendedMetaData="kind='element' name='maximumOccurs' namespace='##targetNamespace'"
	 * @generated
	 */
	BigInteger getMaximumOccurs();

	/**
	 * Sets the value of the '{@link net.opengis.gml.OperationParameterGroupType#getMaximumOccurs <em>Maximum Occurs</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Maximum Occurs</em>' attribute.
	 * @see #getMaximumOccurs()
	 * @generated
	 */
	void setMaximumOccurs(BigInteger value);

	/**
	 * Returns the value of the '<em><b>Includes Parameter</b></em>' containment reference list.
	 * The list contents are of type {@link net.opengis.gml.AbstractGeneralOperationParameterRefType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Unordered list of associations to the set of operation parameters that are members of this group. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Includes Parameter</em>' containment reference list.
	 * @see net.opengis.gml.GMLPackage#getOperationParameterGroupType_IncludesParameter()
	 * @model containment="true" lower="2"
	 *        extendedMetaData="kind='element' name='includesParameter' namespace='##targetNamespace'"
	 * @generated
	 */
	EList<AbstractGeneralOperationParameterRefType> getIncludesParameter();

} // OperationParameterGroupType
