/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package net.opengis.fes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Comparison Operator Name Type Member0</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see net.opengis.fes.FESPackage#getComparisonOperatorNameTypeMember0()
 * @model extendedMetaData="name='ComparisonOperatorNameType_._member_._0'"
 * @generated
 */
@ProviderType
public enum ComparisonOperatorNameTypeMember0 implements Enumerator {
	/**
	 * The '<em><b>Property Is Equal To</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_EQUAL_TO_VALUE
	 * @generated
	 * @ordered
	 */
	PROPERTY_IS_EQUAL_TO(0, "PropertyIsEqualTo", "PropertyIsEqualTo"),

	/**
	 * The '<em><b>Property Is Not Equal To</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_NOT_EQUAL_TO_VALUE
	 * @generated
	 * @ordered
	 */
	PROPERTY_IS_NOT_EQUAL_TO(1, "PropertyIsNotEqualTo", "PropertyIsNotEqualTo"),

	/**
	 * The '<em><b>Property Is Less Than</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_LESS_THAN_VALUE
	 * @generated
	 * @ordered
	 */
	PROPERTY_IS_LESS_THAN(2, "PropertyIsLessThan", "PropertyIsLessThan"),

	/**
	 * The '<em><b>Property Is Greater Than</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_GREATER_THAN_VALUE
	 * @generated
	 * @ordered
	 */
	PROPERTY_IS_GREATER_THAN(3, "PropertyIsGreaterThan", "PropertyIsGreaterThan"),

	/**
	 * The '<em><b>Property Is Less Than Or Equal To</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_LESS_THAN_OR_EQUAL_TO_VALUE
	 * @generated
	 * @ordered
	 */
	PROPERTY_IS_LESS_THAN_OR_EQUAL_TO(4, "PropertyIsLessThanOrEqualTo", "PropertyIsLessThanOrEqualTo"),

	/**
	 * The '<em><b>Property Is Greater Than Or Equal To</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_GREATER_THAN_OR_EQUAL_TO_VALUE
	 * @generated
	 * @ordered
	 */
	PROPERTY_IS_GREATER_THAN_OR_EQUAL_TO(5, "PropertyIsGreaterThanOrEqualTo", "PropertyIsGreaterThanOrEqualTo"),

	/**
	 * The '<em><b>Property Is Like</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_LIKE_VALUE
	 * @generated
	 * @ordered
	 */
	PROPERTY_IS_LIKE(6, "PropertyIsLike", "PropertyIsLike"),

	/**
	 * The '<em><b>Property Is Null</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_NULL_VALUE
	 * @generated
	 * @ordered
	 */
	PROPERTY_IS_NULL(7, "PropertyIsNull", "PropertyIsNull"),

	/**
	 * The '<em><b>Property Is Nil</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_NIL_VALUE
	 * @generated
	 * @ordered
	 */
	PROPERTY_IS_NIL(8, "PropertyIsNil", "PropertyIsNil"),

	/**
	 * The '<em><b>Property Is Between</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_BETWEEN_VALUE
	 * @generated
	 * @ordered
	 */
	PROPERTY_IS_BETWEEN(9, "PropertyIsBetween", "PropertyIsBetween");

	/**
	 * The '<em><b>Property Is Equal To</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_EQUAL_TO
	 * @model name="PropertyIsEqualTo"
	 * @generated
	 * @ordered
	 */
	public static final int PROPERTY_IS_EQUAL_TO_VALUE = 0;

	/**
	 * The '<em><b>Property Is Not Equal To</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_NOT_EQUAL_TO
	 * @model name="PropertyIsNotEqualTo"
	 * @generated
	 * @ordered
	 */
	public static final int PROPERTY_IS_NOT_EQUAL_TO_VALUE = 1;

	/**
	 * The '<em><b>Property Is Less Than</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_LESS_THAN
	 * @model name="PropertyIsLessThan"
	 * @generated
	 * @ordered
	 */
	public static final int PROPERTY_IS_LESS_THAN_VALUE = 2;

	/**
	 * The '<em><b>Property Is Greater Than</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_GREATER_THAN
	 * @model name="PropertyIsGreaterThan"
	 * @generated
	 * @ordered
	 */
	public static final int PROPERTY_IS_GREATER_THAN_VALUE = 3;

	/**
	 * The '<em><b>Property Is Less Than Or Equal To</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_LESS_THAN_OR_EQUAL_TO
	 * @model name="PropertyIsLessThanOrEqualTo"
	 * @generated
	 * @ordered
	 */
	public static final int PROPERTY_IS_LESS_THAN_OR_EQUAL_TO_VALUE = 4;

	/**
	 * The '<em><b>Property Is Greater Than Or Equal To</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_GREATER_THAN_OR_EQUAL_TO
	 * @model name="PropertyIsGreaterThanOrEqualTo"
	 * @generated
	 * @ordered
	 */
	public static final int PROPERTY_IS_GREATER_THAN_OR_EQUAL_TO_VALUE = 5;

	/**
	 * The '<em><b>Property Is Like</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_LIKE
	 * @model name="PropertyIsLike"
	 * @generated
	 * @ordered
	 */
	public static final int PROPERTY_IS_LIKE_VALUE = 6;

	/**
	 * The '<em><b>Property Is Null</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_NULL
	 * @model name="PropertyIsNull"
	 * @generated
	 * @ordered
	 */
	public static final int PROPERTY_IS_NULL_VALUE = 7;

	/**
	 * The '<em><b>Property Is Nil</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_NIL
	 * @model name="PropertyIsNil"
	 * @generated
	 * @ordered
	 */
	public static final int PROPERTY_IS_NIL_VALUE = 8;

	/**
	 * The '<em><b>Property Is Between</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROPERTY_IS_BETWEEN
	 * @model name="PropertyIsBetween"
	 * @generated
	 * @ordered
	 */
	public static final int PROPERTY_IS_BETWEEN_VALUE = 9;

	/**
	 * An array of all the '<em><b>Comparison Operator Name Type Member0</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ComparisonOperatorNameTypeMember0[] VALUES_ARRAY =
		new ComparisonOperatorNameTypeMember0[] {
			PROPERTY_IS_EQUAL_TO,
			PROPERTY_IS_NOT_EQUAL_TO,
			PROPERTY_IS_LESS_THAN,
			PROPERTY_IS_GREATER_THAN,
			PROPERTY_IS_LESS_THAN_OR_EQUAL_TO,
			PROPERTY_IS_GREATER_THAN_OR_EQUAL_TO,
			PROPERTY_IS_LIKE,
			PROPERTY_IS_NULL,
			PROPERTY_IS_NIL,
			PROPERTY_IS_BETWEEN,
		};

	/**
	 * A public read-only list of all the '<em><b>Comparison Operator Name Type Member0</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ComparisonOperatorNameTypeMember0> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Comparison Operator Name Type Member0</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ComparisonOperatorNameTypeMember0 get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ComparisonOperatorNameTypeMember0 result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Comparison Operator Name Type Member0</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ComparisonOperatorNameTypeMember0 getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ComparisonOperatorNameTypeMember0 result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Comparison Operator Name Type Member0</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ComparisonOperatorNameTypeMember0 get(int value) {
		switch (value) {
			case PROPERTY_IS_EQUAL_TO_VALUE: return PROPERTY_IS_EQUAL_TO;
			case PROPERTY_IS_NOT_EQUAL_TO_VALUE: return PROPERTY_IS_NOT_EQUAL_TO;
			case PROPERTY_IS_LESS_THAN_VALUE: return PROPERTY_IS_LESS_THAN;
			case PROPERTY_IS_GREATER_THAN_VALUE: return PROPERTY_IS_GREATER_THAN;
			case PROPERTY_IS_LESS_THAN_OR_EQUAL_TO_VALUE: return PROPERTY_IS_LESS_THAN_OR_EQUAL_TO;
			case PROPERTY_IS_GREATER_THAN_OR_EQUAL_TO_VALUE: return PROPERTY_IS_GREATER_THAN_OR_EQUAL_TO;
			case PROPERTY_IS_LIKE_VALUE: return PROPERTY_IS_LIKE;
			case PROPERTY_IS_NULL_VALUE: return PROPERTY_IS_NULL;
			case PROPERTY_IS_NIL_VALUE: return PROPERTY_IS_NIL;
			case PROPERTY_IS_BETWEEN_VALUE: return PROPERTY_IS_BETWEEN;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ComparisonOperatorNameTypeMember0(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ComparisonOperatorNameTypeMember0
