/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package net.opengis.ows;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Service Provider Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link net.opengis.ows.ServiceProviderType#getProviderName <em>Provider Name</em>}</li>
 *   <li>{@link net.opengis.ows.ServiceProviderType#getProviderSite <em>Provider Site</em>}</li>
 *   <li>{@link net.opengis.ows.ServiceProviderType#getServiceContact <em>Service Contact</em>}</li>
 * </ul>
 *
 * @see net.opengis.ows.OWSPackage#getServiceProviderType()
 * @model extendedMetaData="name='ServiceProvider_._type' kind='elementOnly'"
 * @generated
 */
@ProviderType
public interface ServiceProviderType extends EObject {
	/**
	 * Returns the value of the '<em><b>Provider Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A unique identifier for the service provider organization. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Provider Name</em>' attribute.
	 * @see #setProviderName(String)
	 * @see net.opengis.ows.OWSPackage#getServiceProviderType_ProviderName()
	 * @model dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 *        extendedMetaData="kind='element' name='ProviderName' namespace='##targetNamespace'"
	 * @generated
	 */
	String getProviderName();

	/**
	 * Sets the value of the '{@link net.opengis.ows.ServiceProviderType#getProviderName <em>Provider Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Provider Name</em>' attribute.
	 * @see #getProviderName()
	 * @generated
	 */
	void setProviderName(String value);

	/**
	 * Returns the value of the '<em><b>Provider Site</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Reference to the most relevant web site of the service provider. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Provider Site</em>' containment reference.
	 * @see #setProviderSite(OnlineResourceType)
	 * @see net.opengis.ows.OWSPackage#getServiceProviderType_ProviderSite()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='ProviderSite' namespace='##targetNamespace'"
	 * @generated
	 */
	OnlineResourceType getProviderSite();

	/**
	 * Sets the value of the '{@link net.opengis.ows.ServiceProviderType#getProviderSite <em>Provider Site</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Provider Site</em>' containment reference.
	 * @see #getProviderSite()
	 * @generated
	 */
	void setProviderSite(OnlineResourceType value);

	/**
	 * Returns the value of the '<em><b>Service Contact</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Information for contacting the service provider. The OnlineResource element within this ServiceContact element should not be used to reference a web site of the service provider. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Service Contact</em>' containment reference.
	 * @see #setServiceContact(ResponsiblePartySubsetType)
	 * @see net.opengis.ows.OWSPackage#getServiceProviderType_ServiceContact()
	 * @model containment="true" required="true"
	 *        extendedMetaData="kind='element' name='ServiceContact' namespace='##targetNamespace'"
	 * @generated
	 */
	ResponsiblePartySubsetType getServiceContact();

	/**
	 * Sets the value of the '{@link net.opengis.ows.ServiceProviderType#getServiceContact <em>Service Contact</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Service Contact</em>' containment reference.
	 * @see #getServiceContact()
	 * @generated
	 */
	void setServiceContact(ResponsiblePartySubsetType value);

} // ServiceProviderType
