/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package net.opengis.fes;

import org.eclipse.emf.ecore.EFactory;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see net.opengis.fes.FESPackage
 * @generated
 */
@ProviderType
public interface FESFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	FESFactory eINSTANCE = net.opengis.fes.impl.FESFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Additional Operators Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Additional Operators Type</em>'.
	 * @generated
	 */
	AdditionalOperatorsType createAdditionalOperatorsType();

	/**
	 * Returns a new object of class '<em>Arguments Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Arguments Type</em>'.
	 * @generated
	 */
	ArgumentsType createArgumentsType();

	/**
	 * Returns a new object of class '<em>Argument Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Argument Type</em>'.
	 * @generated
	 */
	ArgumentType createArgumentType();

	/**
	 * Returns a new object of class '<em>Available Functions Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Available Functions Type</em>'.
	 * @generated
	 */
	AvailableFunctionsType createAvailableFunctionsType();

	/**
	 * Returns a new object of class '<em>Available Function Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Available Function Type</em>'.
	 * @generated
	 */
	AvailableFunctionType createAvailableFunctionType();

	/**
	 * Returns a new object of class '<em>BBOX Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>BBOX Type</em>'.
	 * @generated
	 */
	BBOXType createBBOXType();

	/**
	 * Returns a new object of class '<em>Binary Comparison Op Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Binary Comparison Op Type</em>'.
	 * @generated
	 */
	BinaryComparisonOpType createBinaryComparisonOpType();

	/**
	 * Returns a new object of class '<em>Binary Logic Op Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Binary Logic Op Type</em>'.
	 * @generated
	 */
	BinaryLogicOpType createBinaryLogicOpType();

	/**
	 * Returns a new object of class '<em>Binary Spatial Op Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Binary Spatial Op Type</em>'.
	 * @generated
	 */
	BinarySpatialOpType createBinarySpatialOpType();

	/**
	 * Returns a new object of class '<em>Binary Temporal Op Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Binary Temporal Op Type</em>'.
	 * @generated
	 */
	BinaryTemporalOpType createBinaryTemporalOpType();

	/**
	 * Returns a new object of class '<em>Comparison Operators Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Comparison Operators Type</em>'.
	 * @generated
	 */
	ComparisonOperatorsType createComparisonOperatorsType();

	/**
	 * Returns a new object of class '<em>Comparison Operator Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Comparison Operator Type</em>'.
	 * @generated
	 */
	ComparisonOperatorType createComparisonOperatorType();

	/**
	 * Returns a new object of class '<em>Conformance Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Conformance Type</em>'.
	 * @generated
	 */
	ConformanceType createConformanceType();

	/**
	 * Returns a new object of class '<em>Distance Buffer Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Distance Buffer Type</em>'.
	 * @generated
	 */
	DistanceBufferType createDistanceBufferType();

	/**
	 * Returns a new object of class '<em>Document Root</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Document Root</em>'.
	 * @generated
	 */
	DocumentRoot createDocumentRoot();

	/**
	 * Returns a new object of class '<em>Extended Capabilities Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Extended Capabilities Type</em>'.
	 * @generated
	 */
	ExtendedCapabilitiesType createExtendedCapabilitiesType();

	/**
	 * Returns a new object of class '<em>Extension Operator Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Extension Operator Type</em>'.
	 * @generated
	 */
	ExtensionOperatorType createExtensionOperatorType();

	/**
	 * Returns a new object of class '<em>Filter Capabilities Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Filter Capabilities Type</em>'.
	 * @generated
	 */
	FilterCapabilitiesType createFilterCapabilitiesType();

	/**
	 * Returns a new object of class '<em>Filter Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Filter Type</em>'.
	 * @generated
	 */
	FilterType createFilterType();

	/**
	 * Returns a new object of class '<em>Function Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Function Type</em>'.
	 * @generated
	 */
	FunctionType createFunctionType();

	/**
	 * Returns a new object of class '<em>Geometry Operands Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geometry Operands Type</em>'.
	 * @generated
	 */
	GeometryOperandsType createGeometryOperandsType();

	/**
	 * Returns a new object of class '<em>Geometry Operand Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Geometry Operand Type</em>'.
	 * @generated
	 */
	GeometryOperandType createGeometryOperandType();

	/**
	 * Returns a new object of class '<em>Id Capabilities Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Id Capabilities Type</em>'.
	 * @generated
	 */
	IdCapabilitiesType createIdCapabilitiesType();

	/**
	 * Returns a new object of class '<em>Literal Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Literal Type</em>'.
	 * @generated
	 */
	LiteralType createLiteralType();

	/**
	 * Returns a new object of class '<em>Logical Operators Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Logical Operators Type</em>'.
	 * @generated
	 */
	LogicalOperatorsType createLogicalOperatorsType();

	/**
	 * Returns a new object of class '<em>Lower Boundary Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Lower Boundary Type</em>'.
	 * @generated
	 */
	LowerBoundaryType createLowerBoundaryType();

	/**
	 * Returns a new object of class '<em>Measure Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Measure Type</em>'.
	 * @generated
	 */
	MeasureType createMeasureType();

	/**
	 * Returns a new object of class '<em>Property Is Between Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Property Is Between Type</em>'.
	 * @generated
	 */
	PropertyIsBetweenType createPropertyIsBetweenType();

	/**
	 * Returns a new object of class '<em>Property Is Like Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Property Is Like Type</em>'.
	 * @generated
	 */
	PropertyIsLikeType createPropertyIsLikeType();

	/**
	 * Returns a new object of class '<em>Property Is Nil Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Property Is Nil Type</em>'.
	 * @generated
	 */
	PropertyIsNilType createPropertyIsNilType();

	/**
	 * Returns a new object of class '<em>Property Is Null Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Property Is Null Type</em>'.
	 * @generated
	 */
	PropertyIsNullType createPropertyIsNullType();

	/**
	 * Returns a new object of class '<em>Resource Identifier Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Resource Identifier Type</em>'.
	 * @generated
	 */
	ResourceIdentifierType createResourceIdentifierType();

	/**
	 * Returns a new object of class '<em>Resource Id Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Resource Id Type</em>'.
	 * @generated
	 */
	ResourceIdType createResourceIdType();

	/**
	 * Returns a new object of class '<em>Scalar Capabilities Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Scalar Capabilities Type</em>'.
	 * @generated
	 */
	ScalarCapabilitiesType createScalarCapabilitiesType();

	/**
	 * Returns a new object of class '<em>Sort By Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sort By Type</em>'.
	 * @generated
	 */
	SortByType createSortByType();

	/**
	 * Returns a new object of class '<em>Sort Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sort Property Type</em>'.
	 * @generated
	 */
	SortPropertyType createSortPropertyType();

	/**
	 * Returns a new object of class '<em>Spatial Capabilities Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Spatial Capabilities Type</em>'.
	 * @generated
	 */
	SpatialCapabilitiesType createSpatialCapabilitiesType();

	/**
	 * Returns a new object of class '<em>Spatial Operators Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Spatial Operators Type</em>'.
	 * @generated
	 */
	SpatialOperatorsType createSpatialOperatorsType();

	/**
	 * Returns a new object of class '<em>Spatial Operator Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Spatial Operator Type</em>'.
	 * @generated
	 */
	SpatialOperatorType createSpatialOperatorType();

	/**
	 * Returns a new object of class '<em>Temporal Capabilities Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Temporal Capabilities Type</em>'.
	 * @generated
	 */
	TemporalCapabilitiesType createTemporalCapabilitiesType();

	/**
	 * Returns a new object of class '<em>Temporal Operands Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Temporal Operands Type</em>'.
	 * @generated
	 */
	TemporalOperandsType createTemporalOperandsType();

	/**
	 * Returns a new object of class '<em>Temporal Operand Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Temporal Operand Type</em>'.
	 * @generated
	 */
	TemporalOperandType createTemporalOperandType();

	/**
	 * Returns a new object of class '<em>Temporal Operators Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Temporal Operators Type</em>'.
	 * @generated
	 */
	TemporalOperatorsType createTemporalOperatorsType();

	/**
	 * Returns a new object of class '<em>Temporal Operator Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Temporal Operator Type</em>'.
	 * @generated
	 */
	TemporalOperatorType createTemporalOperatorType();

	/**
	 * Returns a new object of class '<em>Unary Logic Op Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Unary Logic Op Type</em>'.
	 * @generated
	 */
	UnaryLogicOpType createUnaryLogicOpType();

	/**
	 * Returns a new object of class '<em>Upper Boundary Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Upper Boundary Type</em>'.
	 * @generated
	 */
	UpperBoundaryType createUpperBoundaryType();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	FESPackage getFESPackage();

} //FESFactory
