/*
 * Copyright (c) 2012 - 2024 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package net.opengis.wfs;

import net.opengis.fes.FilterCapabilitiesType;

import net.opengis.ows.CapabilitiesBaseType;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Capabilities Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link net.opengis.wfs.WFSCapabilitiesType#getWSDL <em>WSDL</em>}</li>
 *   <li>{@link net.opengis.wfs.WFSCapabilitiesType#getFeatureTypeList <em>Feature Type List</em>}</li>
 *   <li>{@link net.opengis.wfs.WFSCapabilitiesType#getFilterCapabilities <em>Filter Capabilities</em>}</li>
 * </ul>
 *
 * @see net.opengis.wfs.WFSPackage#getWFSCapabilitiesType()
 * @model extendedMetaData="name='WFS_CapabilitiesType' kind='elementOnly'"
 * @generated
 */
@ProviderType
public interface WFSCapabilitiesType extends CapabilitiesBaseType {
	/**
	 * Returns the value of the '<em><b>WSDL</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>WSDL</em>' containment reference.
	 * @see #setWSDL(WSDLType)
	 * @see net.opengis.wfs.WFSPackage#getWFSCapabilitiesType_WSDL()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='WSDL' namespace='##targetNamespace'"
	 * @generated
	 */
	WSDLType getWSDL();

	/**
	 * Sets the value of the '{@link net.opengis.wfs.WFSCapabilitiesType#getWSDL <em>WSDL</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>WSDL</em>' containment reference.
	 * @see #getWSDL()
	 * @generated
	 */
	void setWSDL(WSDLType value);

	/**
	 * Returns the value of the '<em><b>Feature Type List</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Feature Type List</em>' containment reference.
	 * @see #setFeatureTypeList(FeatureTypeListType)
	 * @see net.opengis.wfs.WFSPackage#getWFSCapabilitiesType_FeatureTypeList()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='FeatureTypeList' namespace='##targetNamespace'"
	 * @generated
	 */
	FeatureTypeListType getFeatureTypeList();

	/**
	 * Sets the value of the '{@link net.opengis.wfs.WFSCapabilitiesType#getFeatureTypeList <em>Feature Type List</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Feature Type List</em>' containment reference.
	 * @see #getFeatureTypeList()
	 * @generated
	 */
	void setFeatureTypeList(FeatureTypeListType value);

	/**
	 * Returns the value of the '<em><b>Filter Capabilities</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Filter Capabilities</em>' containment reference.
	 * @see #setFilterCapabilities(FilterCapabilitiesType)
	 * @see net.opengis.wfs.WFSPackage#getWFSCapabilitiesType_FilterCapabilities()
	 * @model containment="true"
	 *        extendedMetaData="kind='element' name='Filter_Capabilities' namespace='http://www.opengis.net/fes/2.0'"
	 * @generated
	 */
	FilterCapabilitiesType getFilterCapabilities();

	/**
	 * Sets the value of the '{@link net.opengis.wfs.WFSCapabilitiesType#getFilterCapabilities <em>Filter Capabilities</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Filter Capabilities</em>' containment reference.
	 * @see #getFilterCapabilities()
	 * @generated
	 */
	void setFilterCapabilities(FilterCapabilitiesType value);

} // WFSCapabilitiesType
