/*
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 *  
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *  
 * Contributors:
 *       Data In Motion - initial API and implementation
 */
package org.gecko.emf.osgi.example.model.extended.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.gecko.emf.osgi.example.model.extended.ExtendedPackage;
import org.gecko.emf.osgi.example.model.extended.TestWithEcoreDep;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Test With Ecore Dep</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.osgi.example.model.extended.impl.TestWithEcoreDepImpl#getAReference <em>AReference</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TestWithEcoreDepImpl extends EClassImpl implements TestWithEcoreDep {
	/**
	 * The cached value of the '{@link #getAReference() <em>AReference</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAReference()
	 * @generated
	 * @ordered
	 */
	protected EReference aReference;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TestWithEcoreDepImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ExtendedPackage.eINSTANCE.getTestWithEcoreDep();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getAReference() {
		if (aReference != null && aReference.eIsProxy()) {
			InternalEObject oldAReference = (InternalEObject)aReference;
			aReference = (EReference)eResolveProxy(oldAReference);
			if (aReference != oldAReference) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ExtendedPackage.TEST_WITH_ECORE_DEP__AREFERENCE, oldAReference, aReference));
			}
		}
		return aReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference basicGetAReference() {
		return aReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAReference(EReference newAReference) {
		EReference oldAReference = aReference;
		aReference = newAReference;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtendedPackage.TEST_WITH_ECORE_DEP__AREFERENCE, oldAReference, aReference));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ExtendedPackage.TEST_WITH_ECORE_DEP__AREFERENCE:
				if (resolve) return getAReference();
				return basicGetAReference();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ExtendedPackage.TEST_WITH_ECORE_DEP__AREFERENCE:
				setAReference((EReference)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ExtendedPackage.TEST_WITH_ECORE_DEP__AREFERENCE:
				setAReference((EReference)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ExtendedPackage.TEST_WITH_ECORE_DEP__AREFERENCE:
				return aReference != null;
		}
		return super.eIsSet(featureID);
	}

} //TestWithEcoreDepImpl
