/*
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 *  
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 *  
 * Contributors:
 *       Data In Motion - initial API and implementation
 */
package org.gecko.emf.osgi.example.model.extended.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.gecko.emf.osgi.example.model.basic.Address;
import org.gecko.emf.osgi.example.model.basic.BasicPackage;

import org.gecko.emf.osgi.example.model.extended.ExtendedAddress;
import org.gecko.emf.osgi.example.model.extended.ExtendedPackage;
import org.gecko.emf.osgi.example.model.extended.InterfaceWithExtendsImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Interface With Extends Impl</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.emf.osgi.example.model.extended.impl.InterfaceWithExtendsImplImpl#getStreet <em>Street</em>}</li>
 *   <li>{@link org.gecko.emf.osgi.example.model.extended.impl.InterfaceWithExtendsImplImpl#getCity <em>City</em>}</li>
 *   <li>{@link org.gecko.emf.osgi.example.model.extended.impl.InterfaceWithExtendsImplImpl#getZip <em>Zip</em>}</li>
 *   <li>{@link org.gecko.emf.osgi.example.model.extended.impl.InterfaceWithExtendsImplImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.gecko.emf.osgi.example.model.extended.impl.InterfaceWithExtendsImplImpl#getNpe <em>Npe</em>}</li>
 *   <li>{@link org.gecko.emf.osgi.example.model.extended.impl.InterfaceWithExtendsImplImpl#getAsdasd <em>Asdasd</em>}</li>
 * </ul>
 *
 * @generated
 */
public class InterfaceWithExtendsImplImpl extends MinimalEObjectImpl.Container implements InterfaceWithExtendsImpl {
	/**
	 * The default value of the '{@link #getStreet() <em>Street</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStreet()
	 * @generated
	 * @ordered
	 */
	protected static final String STREET_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getStreet() <em>Street</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStreet()
	 * @generated
	 * @ordered
	 */
	protected String street = STREET_EDEFAULT;

	/**
	 * The default value of the '{@link #getCity() <em>City</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCity()
	 * @generated
	 * @ordered
	 */
	protected static final String CITY_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCity() <em>City</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCity()
	 * @generated
	 * @ordered
	 */
	protected String city = CITY_EDEFAULT;

	/**
	 * The default value of the '{@link #getZip() <em>Zip</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getZip()
	 * @generated
	 * @ordered
	 */
	protected static final String ZIP_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getZip() <em>Zip</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getZip()
	 * @generated
	 * @ordered
	 */
	protected String zip = ZIP_EDEFAULT;

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getNpe() <em>Npe</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNpe()
	 * @generated
	 * @ordered
	 */
	protected static final NullPointerException NPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getNpe() <em>Npe</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNpe()
	 * @generated
	 * @ordered
	 */
	protected NullPointerException npe = NPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getAsdasd() <em>Asdasd</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAsdasd()
	 * @generated
	 * @ordered
	 */
	protected static final String ASDASD_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAsdasd() <em>Asdasd</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAsdasd()
	 * @generated
	 * @ordered
	 */
	protected String asdasd = ASDASD_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterfaceWithExtendsImplImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ExtendedPackage.eINSTANCE.getInterfaceWithExtendsImpl();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getStreet() {
		return street;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStreet(String newStreet) {
		String oldStreet = street;
		street = newStreet;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__STREET, oldStreet, street));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCity() {
		return city;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCity(String newCity) {
		String oldCity = city;
		city = newCity;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__CITY, oldCity, city));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getZip() {
		return zip;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setZip(String newZip) {
		String oldZip = zip;
		zip = newZip;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ZIP, oldZip, zip));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NullPointerException getNpe() {
		return npe;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setNpe(NullPointerException newNpe) {
		NullPointerException oldNpe = npe;
		npe = newNpe;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__NPE, oldNpe, npe));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getAsdasd() {
		return asdasd;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAsdasd(String newAsdasd) {
		String oldAsdasd = asdasd;
		asdasd = newAsdasd;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ASDASD, oldAsdasd, asdasd));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__STREET:
				return getStreet();
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__CITY:
				return getCity();
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ZIP:
				return getZip();
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ID:
				return getId();
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__NPE:
				return getNpe();
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ASDASD:
				return getAsdasd();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__STREET:
				setStreet((String)newValue);
				return;
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__CITY:
				setCity((String)newValue);
				return;
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ZIP:
				setZip((String)newValue);
				return;
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ID:
				setId((String)newValue);
				return;
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__NPE:
				setNpe((NullPointerException)newValue);
				return;
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ASDASD:
				setAsdasd((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__STREET:
				setStreet(STREET_EDEFAULT);
				return;
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__CITY:
				setCity(CITY_EDEFAULT);
				return;
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ZIP:
				setZip(ZIP_EDEFAULT);
				return;
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ID:
				setId(ID_EDEFAULT);
				return;
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__NPE:
				setNpe(NPE_EDEFAULT);
				return;
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ASDASD:
				setAsdasd(ASDASD_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__STREET:
				return STREET_EDEFAULT == null ? street != null : !STREET_EDEFAULT.equals(street);
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__CITY:
				return CITY_EDEFAULT == null ? city != null : !CITY_EDEFAULT.equals(city);
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ZIP:
				return ZIP_EDEFAULT == null ? zip != null : !ZIP_EDEFAULT.equals(zip);
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__NPE:
				return NPE_EDEFAULT == null ? npe != null : !NPE_EDEFAULT.equals(npe);
			case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ASDASD:
				return ASDASD_EDEFAULT == null ? asdasd != null : !ASDASD_EDEFAULT.equals(asdasd);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == Address.class) {
			switch (derivedFeatureID) {
				case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__STREET: return BasicPackage.ADDRESS__STREET;
				case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__CITY: return BasicPackage.ADDRESS__CITY;
				case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ZIP: return BasicPackage.ADDRESS__ZIP;
				case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ID: return BasicPackage.ADDRESS__ID;
				case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__NPE: return BasicPackage.ADDRESS__NPE;
				default: return -1;
			}
		}
		if (baseClass == ExtendedAddress.class) {
			switch (derivedFeatureID) {
				case ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ASDASD: return ExtendedPackage.EXTENDED_ADDRESS__ASDASD;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == Address.class) {
			switch (baseFeatureID) {
				case BasicPackage.ADDRESS__STREET: return ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__STREET;
				case BasicPackage.ADDRESS__CITY: return ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__CITY;
				case BasicPackage.ADDRESS__ZIP: return ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ZIP;
				case BasicPackage.ADDRESS__ID: return ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ID;
				case BasicPackage.ADDRESS__NPE: return ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__NPE;
				default: return -1;
			}
		}
		if (baseClass == ExtendedAddress.class) {
			switch (baseFeatureID) {
				case ExtendedPackage.EXTENDED_ADDRESS__ASDASD: return ExtendedPackage.INTERFACE_WITH_EXTENDS_IMPL__ASDASD;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (street: ");
		result.append(street);
		result.append(", city: ");
		result.append(city);
		result.append(", zip: ");
		result.append(zip);
		result.append(", id: ");
		result.append(id);
		result.append(", npe: ");
		result.append(npe);
		result.append(", asdasd: ");
		result.append(asdasd);
		result.append(')');
		return result.toString();
	}

} //InterfaceWithExtendsImplImpl
