/**
 */
package org.gecko.notary.model.notary;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Asset</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.notary.model.notary.Asset#getId <em>Id</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.Asset#getAssetLog <em>Asset Log</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.Asset#isInactive <em>Inactive</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.Asset#getCreatorBehalf <em>Creator Behalf</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.Asset#getCreatorId <em>Creator Id</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.Asset#getOwnerId <em>Owner Id</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.Asset#getOwnerName <em>Owner Name</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.Asset#getAsset <em>Asset</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.Asset#getAssetIds <em>Asset Ids</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.Asset#getTransactionDesc <em>Transaction Desc</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.Asset#getInfo <em>Info</em>}</li>
 * </ul>
 *
 * @see org.gecko.notary.model.notary.NotaryPackage#getAsset()
 * @model
 * @generated
 */
public interface Asset extends EObject {
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAsset_Id()
	 * @model id="true" required="true"
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.gecko.notary.model.notary.Asset#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Asset Log</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Asset Log</em>' reference.
	 * @see #setAssetLog(AssetLog)
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAsset_AssetLog()
	 * @model keys="id" required="true"
	 * @generated
	 */
	AssetLog getAssetLog();

	/**
	 * Sets the value of the '{@link org.gecko.notary.model.notary.Asset#getAssetLog <em>Asset Log</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Asset Log</em>' reference.
	 * @see #getAssetLog()
	 * @generated
	 */
	void setAssetLog(AssetLog value);

	/**
	 * Returns the value of the '<em><b>Inactive</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Inactive</em>' attribute.
	 * @see #setInactive(boolean)
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAsset_Inactive()
	 * @model default="false"
	 * @generated
	 */
	boolean isInactive();

	/**
	 * Sets the value of the '{@link org.gecko.notary.model.notary.Asset#isInactive <em>Inactive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Inactive</em>' attribute.
	 * @see #isInactive()
	 * @generated
	 */
	void setInactive(boolean value);

	/**
	 * Returns the value of the '<em><b>Creator Behalf</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Creator Behalf</em>' attribute.
	 * @see #setCreatorBehalf(String)
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAsset_CreatorBehalf()
	 * @model
	 * @generated
	 */
	String getCreatorBehalf();

	/**
	 * Sets the value of the '{@link org.gecko.notary.model.notary.Asset#getCreatorBehalf <em>Creator Behalf</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Creator Behalf</em>' attribute.
	 * @see #getCreatorBehalf()
	 * @generated
	 */
	void setCreatorBehalf(String value);

	/**
	 * Returns the value of the '<em><b>Creator Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The id of the current participant, that created that asset
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Creator Id</em>' attribute.
	 * @see #setCreatorId(String)
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAsset_CreatorId()
	 * @model required="true"
	 * @generated
	 */
	String getCreatorId();

	/**
	 * Sets the value of the '{@link org.gecko.notary.model.notary.Asset#getCreatorId <em>Creator Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Creator Id</em>' attribute.
	 * @see #getCreatorId()
	 * @generated
	 */
	void setCreatorId(String value);

	/**
	 * Returns the value of the '<em><b>Owner Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The id of the current participant, that currently owns the asset
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Owner Id</em>' attribute.
	 * @see #setOwnerId(String)
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAsset_OwnerId()
	 * @model required="true"
	 * @generated
	 */
	String getOwnerId();

	/**
	 * Sets the value of the '{@link org.gecko.notary.model.notary.Asset#getOwnerId <em>Owner Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Owner Id</em>' attribute.
	 * @see #getOwnerId()
	 * @generated
	 */
	void setOwnerId(String value);

	/**
	 * Returns the value of the '<em><b>Owner Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Custom name for the owner
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Owner Name</em>' attribute.
	 * @see #setOwnerName(String)
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAsset_OwnerName()
	 * @model
	 * @generated
	 */
	String getOwnerName();

	/**
	 * Sets the value of the '{@link org.gecko.notary.model.notary.Asset#getOwnerName <em>Owner Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Owner Name</em>' attribute.
	 * @see #getOwnerName()
	 * @generated
	 */
	void setOwnerName(String value);

	/**
	 * Returns the value of the '<em><b>Asset</b></em>' containment reference list.
	 * The list contents are of type {@link org.gecko.notary.model.notary.Asset}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Asset</em>' containment reference list.
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAsset_Asset()
	 * @model containment="true" keys="id"
	 * @generated
	 */
	EList<Asset> getAsset();

	/**
	 * Returns the value of the '<em><b>Asset Ids</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Asset Ids</em>' attribute list.
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAsset_AssetIds()
	 * @model
	 * @generated
	 */
	EList<String> getAssetIds();

	/**
	 * Returns the value of the '<em><b>Transaction Desc</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Optional list of transaction descriptions
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Transaction Desc</em>' attribute list.
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAsset_TransactionDesc()
	 * @model
	 * @generated
	 */
	EList<String> getTransactionDesc();

	/**
	 * Returns the value of the '<em><b>Info</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Info</em>' containment reference.
	 * @see #setInfo(AssetInfo)
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAsset_Info()
	 * @model containment="true"
	 * @generated
	 */
	AssetInfo getInfo();

	/**
	 * Sets the value of the '{@link org.gecko.notary.model.notary.Asset#getInfo <em>Info</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Info</em>' containment reference.
	 * @see #getInfo()
	 * @generated
	 */
	void setInfo(AssetInfo value);

} // Asset
