/**
 */
package org.gecko.notary.model.notary;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Asset Info</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.notary.model.notary.AssetInfo#getAssetTypeLabel <em>Asset Type Label</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.AssetInfo#getLabel <em>Label</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.AssetInfo#getDescription <em>Description</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.AssetInfo#getAssetIdentifier <em>Asset Identifier</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.AssetInfo#getDocumentation <em>Documentation</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.AssetInfo#getTransactionDesc <em>Transaction Desc</em>}</li>
 * </ul>
 *
 * @see org.gecko.notary.model.notary.NotaryPackage#getAssetInfo()
 * @model
 * @generated
 */
public interface AssetInfo extends EObject {
	/**
	 * Returns the value of the '<em><b>Asset Type Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A label for the asset type. This property can be calculated or otherwise stored
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Asset Type Label</em>' attribute.
	 * @see #setAssetTypeLabel(String)
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAssetInfo_AssetTypeLabel()
	 * @model
	 * @generated
	 */
	String getAssetTypeLabel();

	/**
	 * Sets the value of the '{@link org.gecko.notary.model.notary.AssetInfo#getAssetTypeLabel <em>Asset Type Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Asset Type Label</em>' attribute.
	 * @see #getAssetTypeLabel()
	 * @generated
	 */
	void setAssetTypeLabel(String value);

	/**
	 * Returns the value of the '<em><b>Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A label for the asset. This property can be calculated or otherwise stored
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Label</em>' attribute.
	 * @see #setLabel(String)
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAssetInfo_Label()
	 * @model
	 * @generated
	 */
	String getLabel();

	/**
	 * Sets the value of the '{@link org.gecko.notary.model.notary.AssetInfo#getLabel <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Label</em>' attribute.
	 * @see #getLabel()
	 * @generated
	 */
	void setLabel(String value);

	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A more detailled description for an asset
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAssetInfo_Description()
	 * @model
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link org.gecko.notary.model.notary.AssetInfo#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Asset Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * An unique identifier that represents that asset/digital twin (e.g. serial number).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Asset Identifier</em>' attribute.
	 * @see #setAssetIdentifier(String)
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAssetInfo_AssetIdentifier()
	 * @model
	 * @generated
	 */
	String getAssetIdentifier();

	/**
	 * Sets the value of the '{@link org.gecko.notary.model.notary.AssetInfo#getAssetIdentifier <em>Asset Identifier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Asset Identifier</em>' attribute.
	 * @see #getAssetIdentifier()
	 * @generated
	 */
	void setAssetIdentifier(String value);

	/**
	 * Returns the value of the '<em><b>Documentation</b></em>' containment reference list.
	 * The list contents are of type {@link org.gecko.notary.model.notary.DocumentationReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Additional documentation links
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Documentation</em>' containment reference list.
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAssetInfo_Documentation()
	 * @model containment="true"
	 * @generated
	 */
	EList<DocumentationReference> getDocumentation();

	/**
	 * Returns the value of the '<em><b>Transaction Desc</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Optional list of transaction descriptions
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Transaction Desc</em>' attribute list.
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAssetInfo_TransactionDesc()
	 * @model
	 * @generated
	 */
	EList<String> getTransactionDesc();

} // AssetInfo
