/**
 */
package org.gecko.notary.model.notary;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Asset Transaction Entry</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.notary.model.notary.AssetTransactionEntry#getAsset <em>Asset</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.AssetTransactionEntry#getChangeType <em>Change Type</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.AssetTransactionEntry#getParentAssetId <em>Parent Asset Id</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.AssetTransactionEntry#getChangeData <em>Change Data</em>}</li>
 * </ul>
 *
 * @see org.gecko.notary.model.notary.NotaryPackage#getAssetTransactionEntry()
 * @model annotation="http://hyperledger.org/Transaction"
 * @generated
 */
public interface AssetTransactionEntry extends TransactionEntry {
	/**
	 * Returns the value of the '<em><b>Asset</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Asset</em>' containment reference.
	 * @see #setAsset(Asset)
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAssetTransactionEntry_Asset()
	 * @model containment="true"
	 * @generated
	 */
	Asset getAsset();

	/**
	 * Sets the value of the '{@link org.gecko.notary.model.notary.AssetTransactionEntry#getAsset <em>Asset</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Asset</em>' containment reference.
	 * @see #getAsset()
	 * @generated
	 */
	void setAsset(Asset value);

	/**
	 * Returns the value of the '<em><b>Change Type</b></em>' attribute.
	 * The literals are from the enumeration {@link org.gecko.notary.model.notary.AssetChangeType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Change Type</em>' attribute.
	 * @see org.gecko.notary.model.notary.AssetChangeType
	 * @see #setChangeType(AssetChangeType)
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAssetTransactionEntry_ChangeType()
	 * @model
	 * @generated
	 */
	AssetChangeType getChangeType();

	/**
	 * Sets the value of the '{@link org.gecko.notary.model.notary.AssetTransactionEntry#getChangeType <em>Change Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Change Type</em>' attribute.
	 * @see org.gecko.notary.model.notary.AssetChangeType
	 * @see #getChangeType()
	 * @generated
	 */
	void setChangeType(AssetChangeType value);

	/**
	 * Returns the value of the '<em><b>Parent Asset Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * In case of joining an asset to te new one, the parent assert id is the id of the new asset, that contains the current asset.
	 * The same applies to split. The parent assets it, refers to the asset the current asset was split from
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Parent Asset Id</em>' attribute.
	 * @see #setParentAssetId(String)
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAssetTransactionEntry_ParentAssetId()
	 * @model
	 * @generated
	 */
	String getParentAssetId();

	/**
	 * Sets the value of the '{@link org.gecko.notary.model.notary.AssetTransactionEntry#getParentAssetId <em>Parent Asset Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Parent Asset Id</em>' attribute.
	 * @see #getParentAssetId()
	 * @generated
	 */
	void setParentAssetId(String value);

	/**
	 * Returns the value of the '<em><b>Change Data</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Change Data</em>' attribute.
	 * @see #setChangeData(String)
	 * @see org.gecko.notary.model.notary.NotaryPackage#getAssetTransactionEntry_ChangeData()
	 * @model
	 * @generated
	 */
	String getChangeData();

	/**
	 * Sets the value of the '{@link org.gecko.notary.model.notary.AssetTransactionEntry#getChangeData <em>Change Data</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Change Data</em>' attribute.
	 * @see #getChangeData()
	 * @generated
	 */
	void setChangeData(String value);

} // AssetTransactionEntry
