/**
 */
package org.gecko.notary.model.notary;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Documentation Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * Certain types that define a documentation. This can be an URL to a web page, a phone number, e-mail-address, link to a PDF
 * <!-- end-model-doc -->
 * @see org.gecko.notary.model.notary.NotaryPackage#getDocumentationType()
 * @model
 * @generated
 */
public enum DocumentationType implements Enumerator {
	/**
	 * The '<em><b>UNKNOWN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #UNKNOWN_VALUE
	 * @generated
	 * @ordered
	 */
	UNKNOWN(0, "UNKNOWN", "UNKNOWN"),

	/**
	 * The '<em><b>URL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #URL_VALUE
	 * @generated
	 * @ordered
	 */
	URL(1, "URL", "URL"),

	/**
	 * The '<em><b>FAQ</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FAQ_VALUE
	 * @generated
	 * @ordered
	 */
	FAQ(2, "FAQ", "FAQ"),

	/**
	 * The '<em><b>MANUAL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MANUAL_VALUE
	 * @generated
	 * @ordered
	 */
	MANUAL(3, "MANUAL", "MANUAL"),

	/**
	 * The '<em><b>MANUFACTURER PAGE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MANUFACTURER_PAGE_VALUE
	 * @generated
	 * @ordered
	 */
	MANUFACTURER_PAGE(4, "MANUFACTURER_PAGE", "MANUFACTURER_PAGE"),

	/**
	 * The '<em><b>PRODUCT PAGE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PRODUCT_PAGE_VALUE
	 * @generated
	 * @ordered
	 */
	PRODUCT_PAGE(5, "PRODUCT_PAGE", "PRODUCT_PAGE"),

	/**
	 * The '<em><b>CUSTOMER CARE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CUSTOMER_CARE_VALUE
	 * @generated
	 * @ordered
	 */
	CUSTOMER_CARE(6, "CUSTOMER_CARE", "CUSTOMER_CARE"),

	/**
	 * The '<em><b>COMMUNITY PAGE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COMMUNITY_PAGE_VALUE
	 * @generated
	 * @ordered
	 */
	COMMUNITY_PAGE(7, "COMMUNITY_PAGE", "COMMUNITY_PAGE");

	/**
	 * The '<em><b>UNKNOWN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #UNKNOWN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int UNKNOWN_VALUE = 0;

	/**
	 * The '<em><b>URL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #URL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int URL_VALUE = 1;

	/**
	 * The '<em><b>FAQ</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FAQ
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int FAQ_VALUE = 2;

	/**
	 * The '<em><b>MANUAL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MANUAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MANUAL_VALUE = 3;

	/**
	 * The '<em><b>MANUFACTURER PAGE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MANUFACTURER_PAGE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MANUFACTURER_PAGE_VALUE = 4;

	/**
	 * The '<em><b>PRODUCT PAGE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PRODUCT_PAGE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PRODUCT_PAGE_VALUE = 5;

	/**
	 * The '<em><b>CUSTOMER CARE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CUSTOMER_CARE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CUSTOMER_CARE_VALUE = 6;

	/**
	 * The '<em><b>COMMUNITY PAGE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COMMUNITY_PAGE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int COMMUNITY_PAGE_VALUE = 7;

	/**
	 * An array of all the '<em><b>Documentation Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final DocumentationType[] VALUES_ARRAY =
		new DocumentationType[] {
			UNKNOWN,
			URL,
			FAQ,
			MANUAL,
			MANUFACTURER_PAGE,
			PRODUCT_PAGE,
			CUSTOMER_CARE,
			COMMUNITY_PAGE,
		};

	/**
	 * A public read-only list of all the '<em><b>Documentation Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<DocumentationType> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Documentation Type</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static DocumentationType get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			DocumentationType result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Documentation Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static DocumentationType getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			DocumentationType result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Documentation Type</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static DocumentationType get(int value) {
		switch (value) {
			case UNKNOWN_VALUE: return UNKNOWN;
			case URL_VALUE: return URL;
			case FAQ_VALUE: return FAQ;
			case MANUAL_VALUE: return MANUAL;
			case MANUFACTURER_PAGE_VALUE: return MANUFACTURER_PAGE;
			case PRODUCT_PAGE_VALUE: return PRODUCT_PAGE;
			case CUSTOMER_CARE_VALUE: return CUSTOMER_CARE;
			case COMMUNITY_PAGE_VALUE: return COMMUNITY_PAGE;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private DocumentationType(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //DocumentationType
