/**
 */
package org.gecko.notary.model.notary;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.gecko.notary.model.notary.NotaryFactory
 * @model kind="package"
 * @generated
 */
public interface NotaryPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "notary";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "https://geckoprojects.io/notary/1.0.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "notary";

	/**
	 * The package content type ID.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eCONTENT_TYPE = "notary#1.0.0";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	NotaryPackage eINSTANCE = org.gecko.notary.model.notary.impl.NotaryPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.ParticipantImpl <em>Participant</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.ParticipantImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getParticipant()
	 * @generated
	 */
	int PARTICIPANT = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT__ID = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT__NAME = 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT__DESCRIPTION = 2;

	/**
	 * The feature id for the '<em><b>Address</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT__ADDRESS = 3;

	/**
	 * The number of structural features of the '<em>Participant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Participant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.ParticipantDefinitionImpl <em>Participant Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.ParticipantDefinitionImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getParticipantDefinition()
	 * @generated
	 */
	int PARTICIPANT_DEFINITION = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT_DEFINITION__ID = 0;

	/**
	 * The feature id for the '<em><b>Contact</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT_DEFINITION__CONTACT = 1;

	/**
	 * The feature id for the '<em><b>Participant</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT_DEFINITION__PARTICIPANT = 2;

	/**
	 * The feature id for the '<em><b>Transaction</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT_DEFINITION__TRANSACTION = 3;

	/**
	 * The feature id for the '<em><b>Asset</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT_DEFINITION__ASSET = 4;

	/**
	 * The feature id for the '<em><b>Notification</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT_DEFINITION__NOTIFICATION = 5;

	/**
	 * The feature id for the '<em><b>Notification Log</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT_DEFINITION__NOTIFICATION_LOG = 6;

	/**
	 * The number of structural features of the '<em>Participant Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT_DEFINITION_FEATURE_COUNT = 7;

	/**
	 * The number of operations of the '<em>Participant Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT_DEFINITION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.AddressImpl <em>Address</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.AddressImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getAddress()
	 * @generated
	 */
	int ADDRESS = 2;

	/**
	 * The feature id for the '<em><b>Street</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADDRESS__STREET = 0;

	/**
	 * The feature id for the '<em><b>Floor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADDRESS__FLOOR = 1;

	/**
	 * The feature id for the '<em><b>Building</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADDRESS__BUILDING = 2;

	/**
	 * The feature id for the '<em><b>Zip</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADDRESS__ZIP = 3;

	/**
	 * The feature id for the '<em><b>City</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADDRESS__CITY = 4;

	/**
	 * The feature id for the '<em><b>Country</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADDRESS__COUNTRY = 5;

	/**
	 * The feature id for the '<em><b>State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADDRESS__STATE = 6;

	/**
	 * The number of structural features of the '<em>Address</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADDRESS_FEATURE_COUNT = 7;

	/**
	 * The number of operations of the '<em>Address</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ADDRESS_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.ContactImpl <em>Contact</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.ContactImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getContact()
	 * @generated
	 */
	int CONTACT = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTACT__ID = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTACT__VALUE = 1;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTACT__TYPE = 2;

	/**
	 * The number of structural features of the '<em>Contact</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTACT_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Contact</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTACT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.TransactionImpl <em>Transaction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.TransactionImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getTransaction()
	 * @generated
	 */
	int TRANSACTION = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION__ID = 0;

	/**
	 * The feature id for the '<em><b>Participant Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION__PARTICIPANT_ID = 1;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION__TYPE = 2;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION__DESCRIPTION = 3;

	/**
	 * The feature id for the '<em><b>Share</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION__SHARE = 4;

	/**
	 * The number of structural features of the '<em>Transaction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Transaction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.TransactionNotificationImpl <em>Transaction Notification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.TransactionNotificationImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getTransactionNotification()
	 * @generated
	 */
	int TRANSACTION_NOTIFICATION = 5;

	/**
	 * The feature id for the '<em><b>Contact</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_NOTIFICATION__CONTACT = 0;

	/**
	 * The feature id for the '<em><b>Contact Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_NOTIFICATION__CONTACT_ID = 1;

	/**
	 * The feature id for the '<em><b>Transaction</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_NOTIFICATION__TRANSACTION = 2;

	/**
	 * The feature id for the '<em><b>Transaction Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_NOTIFICATION__TRANSACTION_ID = 3;

	/**
	 * The feature id for the '<em><b>Content</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_NOTIFICATION__CONTENT = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_NOTIFICATION__ID = 5;

	/**
	 * The number of structural features of the '<em>Transaction Notification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_NOTIFICATION_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>Transaction Notification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_NOTIFICATION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.TransactionEntryImpl <em>Transaction Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.TransactionEntryImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getTransactionEntry()
	 * @generated
	 */
	int TRANSACTION_ENTRY = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ENTRY__ID = 0;

	/**
	 * The feature id for the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ENTRY__TIMESTAMP = 1;

	/**
	 * The feature id for the '<em><b>Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ENTRY__LABEL = 2;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ENTRY__COMMENT = 3;

	/**
	 * The feature id for the '<em><b>Asset Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ENTRY__ASSET_ID = 4;

	/**
	 * The feature id for the '<em><b>Transaction Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ENTRY__TRANSACTION_ID = 5;

	/**
	 * The feature id for the '<em><b>Participant Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ENTRY__PARTICIPANT_ID = 6;

	/**
	 * The feature id for the '<em><b>Preceding Entry Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ENTRY__PRECEDING_ENTRY_ID = 7;

	/**
	 * The feature id for the '<em><b>Preceding Entry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ENTRY__PRECEDING_ENTRY = 8;

	/**
	 * The feature id for the '<em><b>Source</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ENTRY__SOURCE = 9;

	/**
	 * The number of structural features of the '<em>Transaction Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ENTRY_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Transaction Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSACTION_ENTRY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.AssetTransactionEntryImpl <em>Asset Transaction Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.AssetTransactionEntryImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getAssetTransactionEntry()
	 * @generated
	 */
	int ASSET_TRANSACTION_ENTRY = 7;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION_ENTRY__ID = TRANSACTION_ENTRY__ID;

	/**
	 * The feature id for the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION_ENTRY__TIMESTAMP = TRANSACTION_ENTRY__TIMESTAMP;

	/**
	 * The feature id for the '<em><b>Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION_ENTRY__LABEL = TRANSACTION_ENTRY__LABEL;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION_ENTRY__COMMENT = TRANSACTION_ENTRY__COMMENT;

	/**
	 * The feature id for the '<em><b>Asset Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION_ENTRY__ASSET_ID = TRANSACTION_ENTRY__ASSET_ID;

	/**
	 * The feature id for the '<em><b>Transaction Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION_ENTRY__TRANSACTION_ID = TRANSACTION_ENTRY__TRANSACTION_ID;

	/**
	 * The feature id for the '<em><b>Participant Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION_ENTRY__PARTICIPANT_ID = TRANSACTION_ENTRY__PARTICIPANT_ID;

	/**
	 * The feature id for the '<em><b>Preceding Entry Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION_ENTRY__PRECEDING_ENTRY_ID = TRANSACTION_ENTRY__PRECEDING_ENTRY_ID;

	/**
	 * The feature id for the '<em><b>Preceding Entry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION_ENTRY__PRECEDING_ENTRY = TRANSACTION_ENTRY__PRECEDING_ENTRY;

	/**
	 * The feature id for the '<em><b>Source</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION_ENTRY__SOURCE = TRANSACTION_ENTRY__SOURCE;

	/**
	 * The feature id for the '<em><b>Asset</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION_ENTRY__ASSET = TRANSACTION_ENTRY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Change Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION_ENTRY__CHANGE_TYPE = TRANSACTION_ENTRY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Parent Asset Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION_ENTRY__PARENT_ASSET_ID = TRANSACTION_ENTRY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Change Data</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION_ENTRY__CHANGE_DATA = TRANSACTION_ENTRY_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Asset Transaction Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION_ENTRY_FEATURE_COUNT = TRANSACTION_ENTRY_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Asset Transaction Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION_ENTRY_OPERATION_COUNT = TRANSACTION_ENTRY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.AssetImpl <em>Asset</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.AssetImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getAsset()
	 * @generated
	 */
	int ASSET = 8;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET__ID = 0;

	/**
	 * The feature id for the '<em><b>Asset Log</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET__ASSET_LOG = 1;

	/**
	 * The feature id for the '<em><b>Inactive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET__INACTIVE = 2;

	/**
	 * The feature id for the '<em><b>Creator Behalf</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET__CREATOR_BEHALF = 3;

	/**
	 * The feature id for the '<em><b>Creator Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET__CREATOR_ID = 4;

	/**
	 * The feature id for the '<em><b>Owner Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET__OWNER_ID = 5;

	/**
	 * The feature id for the '<em><b>Owner Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET__OWNER_NAME = 6;

	/**
	 * The feature id for the '<em><b>Asset</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET__ASSET = 7;

	/**
	 * The feature id for the '<em><b>Asset Ids</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET__ASSET_IDS = 8;

	/**
	 * The feature id for the '<em><b>Transaction Desc</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET__TRANSACTION_DESC = 9;

	/**
	 * The feature id for the '<em><b>Info</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET__INFO = 10;

	/**
	 * The number of structural features of the '<em>Asset</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_FEATURE_COUNT = 11;

	/**
	 * The number of operations of the '<em>Asset</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.AssetLogImpl <em>Asset Log</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.AssetLogImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getAssetLog()
	 * @generated
	 */
	int ASSET_LOG = 9;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_LOG__ID = 0;

	/**
	 * The feature id for the '<em><b>Entry</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_LOG__ENTRY = 1;

	/**
	 * The feature id for the '<em><b>Last Entry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_LOG__LAST_ENTRY = 2;

	/**
	 * The feature id for the '<em><b>Asset Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_LOG__ASSET_ID = 3;

	/**
	 * The feature id for the '<em><b>Asset</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_LOG__ASSET = 4;

	/**
	 * The number of structural features of the '<em>Asset Log</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_LOG_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Asset Log</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_LOG_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.NotificationImpl <em>Notification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.NotificationImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getNotification()
	 * @generated
	 */
	int NOTIFICATION = 10;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__ID = 0;

	/**
	 * The feature id for the '<em><b>Read</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__READ = 1;

	/**
	 * The feature id for the '<em><b>Content</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__CONTENT = 2;

	/**
	 * The feature id for the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__TIMESTAMP = 3;

	/**
	 * The feature id for the '<em><b>Sender Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__SENDER_ID = 4;

	/**
	 * The feature id for the '<em><b>Receipient Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__RECEIPIENT_ID = 5;

	/**
	 * The feature id for the '<em><b>Subject</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION__SUBJECT = 6;

	/**
	 * The number of structural features of the '<em>Notification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_FEATURE_COUNT = 7;

	/**
	 * The number of operations of the '<em>Notification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.NotificationLogImpl <em>Notification Log</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.NotificationLogImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getNotificationLog()
	 * @generated
	 */
	int NOTIFICATION_LOG = 11;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_LOG__ID = 0;

	/**
	 * The feature id for the '<em><b>Notification</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_LOG__NOTIFICATION = 1;

	/**
	 * The number of structural features of the '<em>Notification Log</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_LOG_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Notification Log</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NOTIFICATION_LOG_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.ParentAssetEntryImpl <em>Parent Asset Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.ParentAssetEntryImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getParentAssetEntry()
	 * @generated
	 */
	int PARENT_ASSET_ENTRY = 12;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENT_ASSET_ENTRY__ID = TRANSACTION_ENTRY__ID;

	/**
	 * The feature id for the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENT_ASSET_ENTRY__TIMESTAMP = TRANSACTION_ENTRY__TIMESTAMP;

	/**
	 * The feature id for the '<em><b>Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENT_ASSET_ENTRY__LABEL = TRANSACTION_ENTRY__LABEL;

	/**
	 * The feature id for the '<em><b>Comment</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENT_ASSET_ENTRY__COMMENT = TRANSACTION_ENTRY__COMMENT;

	/**
	 * The feature id for the '<em><b>Asset Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENT_ASSET_ENTRY__ASSET_ID = TRANSACTION_ENTRY__ASSET_ID;

	/**
	 * The feature id for the '<em><b>Transaction Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENT_ASSET_ENTRY__TRANSACTION_ID = TRANSACTION_ENTRY__TRANSACTION_ID;

	/**
	 * The feature id for the '<em><b>Participant Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENT_ASSET_ENTRY__PARTICIPANT_ID = TRANSACTION_ENTRY__PARTICIPANT_ID;

	/**
	 * The feature id for the '<em><b>Preceding Entry Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENT_ASSET_ENTRY__PRECEDING_ENTRY_ID = TRANSACTION_ENTRY__PRECEDING_ENTRY_ID;

	/**
	 * The feature id for the '<em><b>Preceding Entry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENT_ASSET_ENTRY__PRECEDING_ENTRY = TRANSACTION_ENTRY__PRECEDING_ENTRY;

	/**
	 * The feature id for the '<em><b>Source</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENT_ASSET_ENTRY__SOURCE = TRANSACTION_ENTRY__SOURCE;

	/**
	 * The feature id for the '<em><b>Parent Asset Log Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENT_ASSET_ENTRY__PARENT_ASSET_LOG_ID = TRANSACTION_ENTRY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parent Asset Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENT_ASSET_ENTRY__PARENT_ASSET_ID = TRANSACTION_ENTRY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Parent Asset Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENT_ASSET_ENTRY_FEATURE_COUNT = TRANSACTION_ENTRY_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Parent Asset Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARENT_ASSET_ENTRY_OPERATION_COUNT = TRANSACTION_ENTRY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.AssetTransactionImpl <em>Asset Transaction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.AssetTransactionImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getAssetTransaction()
	 * @generated
	 */
	int ASSET_TRANSACTION = 13;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION__ID = TRANSACTION__ID;

	/**
	 * The feature id for the '<em><b>Participant Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION__PARTICIPANT_ID = TRANSACTION__PARTICIPANT_ID;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION__TYPE = TRANSACTION__TYPE;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION__DESCRIPTION = TRANSACTION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Share</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION__SHARE = TRANSACTION__SHARE;

	/**
	 * The feature id for the '<em><b>Change Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION__CHANGE_TYPE = TRANSACTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Asset Transaction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION_FEATURE_COUNT = TRANSACTION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Asset Transaction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_TRANSACTION_OPERATION_COUNT = TRANSACTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.AssetInfoImpl <em>Asset Info</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.AssetInfoImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getAssetInfo()
	 * @generated
	 */
	int ASSET_INFO = 14;

	/**
	 * The feature id for the '<em><b>Asset Type Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_INFO__ASSET_TYPE_LABEL = 0;

	/**
	 * The feature id for the '<em><b>Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_INFO__LABEL = 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_INFO__DESCRIPTION = 2;

	/**
	 * The feature id for the '<em><b>Asset Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_INFO__ASSET_IDENTIFIER = 3;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_INFO__DOCUMENTATION = 4;

	/**
	 * The feature id for the '<em><b>Transaction Desc</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_INFO__TRANSACTION_DESC = 5;

	/**
	 * The number of structural features of the '<em>Asset Info</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_INFO_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>Asset Info</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ASSET_INFO_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.DocumentationReferenceImpl <em>Documentation Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.DocumentationReferenceImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getDocumentationReference()
	 * @generated
	 */
	int DOCUMENTATION_REFERENCE = 15;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTATION_REFERENCE__ID = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTATION_REFERENCE__NAME = 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTATION_REFERENCE__DESCRIPTION = 2;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTATION_REFERENCE__TYPE = 3;

	/**
	 * The feature id for the '<em><b>Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTATION_REFERENCE__REFERENCE = 4;

	/**
	 * The number of structural features of the '<em>Documentation Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTATION_REFERENCE_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Documentation Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENTATION_REFERENCE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.FeedbackTransactionImpl <em>Feedback Transaction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.FeedbackTransactionImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getFeedbackTransaction()
	 * @generated
	 */
	int FEEDBACK_TRANSACTION = 16;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_TRANSACTION__ID = TRANSACTION__ID;

	/**
	 * The feature id for the '<em><b>Participant Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_TRANSACTION__PARTICIPANT_ID = TRANSACTION__PARTICIPANT_ID;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_TRANSACTION__TYPE = TRANSACTION__TYPE;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_TRANSACTION__DESCRIPTION = TRANSACTION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Share</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_TRANSACTION__SHARE = TRANSACTION__SHARE;

	/**
	 * The feature id for the '<em><b>Feedback</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_TRANSACTION__FEEDBACK = TRANSACTION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Feedback Transaction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_TRANSACTION_FEATURE_COUNT = TRANSACTION_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Feedback Transaction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_TRANSACTION_OPERATION_COUNT = TRANSACTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.FeedbackImpl <em>Feedback</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.FeedbackImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getFeedback()
	 * @generated
	 */
	int FEEDBACK = 17;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK__ID = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK__NAME = 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK__DESCRIPTION = 2;

	/**
	 * The feature id for the '<em><b>Item</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK__ITEM = 3;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK__TYPE = 4;

	/**
	 * The number of structural features of the '<em>Feedback</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Feedback</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.FeedbackResultImpl <em>Feedback Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.FeedbackResultImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getFeedbackResult()
	 * @generated
	 */
	int FEEDBACK_RESULT = 18;

	/**
	 * The feature id for the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_RESULT__TIMESTAMP = 0;

	/**
	 * The feature id for the '<em><b>Participant Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_RESULT__PARTICIPANT_ID = 1;

	/**
	 * The feature id for the '<em><b>Feedback</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_RESULT__FEEDBACK = 2;

	/**
	 * The feature id for the '<em><b>Feedback Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_RESULT__FEEDBACK_ID = 3;

	/**
	 * The feature id for the '<em><b>Result Item</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_RESULT__RESULT_ITEM = 4;

	/**
	 * The number of structural features of the '<em>Feedback Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_RESULT_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Feedback Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_RESULT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.FeedbackResultItemImpl <em>Feedback Result Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.FeedbackResultItemImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getFeedbackResultItem()
	 * @generated
	 */
	int FEEDBACK_RESULT_ITEM = 19;

	/**
	 * The feature id for the '<em><b>Item</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_RESULT_ITEM__ITEM = 0;

	/**
	 * The feature id for the '<em><b>Item Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_RESULT_ITEM__ITEM_ID = 1;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_RESULT_ITEM__VALUE = 2;

	/**
	 * The number of structural features of the '<em>Feedback Result Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_RESULT_ITEM_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Feedback Result Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_RESULT_ITEM_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.FeedbackItemImpl <em>Feedback Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.FeedbackItemImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getFeedbackItem()
	 * @generated
	 */
	int FEEDBACK_ITEM = 20;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_ITEM__ID = 0;

	/**
	 * The feature id for the '<em><b>Optional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_ITEM__OPTIONAL = 1;

	/**
	 * The feature id for the '<em><b>Question</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_ITEM__QUESTION = 2;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_ITEM__DESCRIPTION = 3;

	/**
	 * The feature id for the '<em><b>Order Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_ITEM__ORDER_COUNT = 4;

	/**
	 * The number of structural features of the '<em>Feedback Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_ITEM_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Feedback Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEEDBACK_ITEM_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.BooleanFeedbackItemImpl <em>Boolean Feedback Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.BooleanFeedbackItemImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getBooleanFeedbackItem()
	 * @generated
	 */
	int BOOLEAN_FEEDBACK_ITEM = 21;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_FEEDBACK_ITEM__ID = FEEDBACK_ITEM__ID;

	/**
	 * The feature id for the '<em><b>Optional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_FEEDBACK_ITEM__OPTIONAL = FEEDBACK_ITEM__OPTIONAL;

	/**
	 * The feature id for the '<em><b>Question</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_FEEDBACK_ITEM__QUESTION = FEEDBACK_ITEM__QUESTION;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_FEEDBACK_ITEM__DESCRIPTION = FEEDBACK_ITEM__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Order Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_FEEDBACK_ITEM__ORDER_COUNT = FEEDBACK_ITEM__ORDER_COUNT;

	/**
	 * The feature id for the '<em><b>Default Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_FEEDBACK_ITEM__DEFAULT_VALUE = FEEDBACK_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Boolean Feedback Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_FEEDBACK_ITEM_FEATURE_COUNT = FEEDBACK_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Boolean Feedback Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_FEEDBACK_ITEM_OPERATION_COUNT = FEEDBACK_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.TextFeedbackItemImpl <em>Text Feedback Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.TextFeedbackItemImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getTextFeedbackItem()
	 * @generated
	 */
	int TEXT_FEEDBACK_ITEM = 22;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_FEEDBACK_ITEM__ID = FEEDBACK_ITEM__ID;

	/**
	 * The feature id for the '<em><b>Optional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_FEEDBACK_ITEM__OPTIONAL = FEEDBACK_ITEM__OPTIONAL;

	/**
	 * The feature id for the '<em><b>Question</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_FEEDBACK_ITEM__QUESTION = FEEDBACK_ITEM__QUESTION;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_FEEDBACK_ITEM__DESCRIPTION = FEEDBACK_ITEM__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Order Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_FEEDBACK_ITEM__ORDER_COUNT = FEEDBACK_ITEM__ORDER_COUNT;

	/**
	 * The feature id for the '<em><b>Default Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_FEEDBACK_ITEM__DEFAULT_VALUE = FEEDBACK_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Text Feedback Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_FEEDBACK_ITEM_FEATURE_COUNT = FEEDBACK_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Text Feedback Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_FEEDBACK_ITEM_OPERATION_COUNT = FEEDBACK_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.ScoreFeedbackItemImpl <em>Score Feedback Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.ScoreFeedbackItemImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getScoreFeedbackItem()
	 * @generated
	 */
	int SCORE_FEEDBACK_ITEM = 23;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_FEEDBACK_ITEM__ID = FEEDBACK_ITEM__ID;

	/**
	 * The feature id for the '<em><b>Optional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_FEEDBACK_ITEM__OPTIONAL = FEEDBACK_ITEM__OPTIONAL;

	/**
	 * The feature id for the '<em><b>Question</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_FEEDBACK_ITEM__QUESTION = FEEDBACK_ITEM__QUESTION;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_FEEDBACK_ITEM__DESCRIPTION = FEEDBACK_ITEM__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Order Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_FEEDBACK_ITEM__ORDER_COUNT = FEEDBACK_ITEM__ORDER_COUNT;

	/**
	 * The feature id for the '<em><b>Default Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_FEEDBACK_ITEM__DEFAULT_VALUE = FEEDBACK_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Min Score</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_FEEDBACK_ITEM__MIN_SCORE = FEEDBACK_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Max Score</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_FEEDBACK_ITEM__MAX_SCORE = FEEDBACK_ITEM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Min Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_FEEDBACK_ITEM__MIN_DESCRIPTION = FEEDBACK_ITEM_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Max Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_FEEDBACK_ITEM__MAX_DESCRIPTION = FEEDBACK_ITEM_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Score Feedback Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_FEEDBACK_ITEM_FEATURE_COUNT = FEEDBACK_ITEM_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Score Feedback Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORE_FEEDBACK_ITEM_OPERATION_COUNT = FEEDBACK_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.impl.OptionFeedbackItemImpl <em>Option Feedback Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.impl.OptionFeedbackItemImpl
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getOptionFeedbackItem()
	 * @generated
	 */
	int OPTION_FEEDBACK_ITEM = 24;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTION_FEEDBACK_ITEM__ID = TEXT_FEEDBACK_ITEM__ID;

	/**
	 * The feature id for the '<em><b>Optional</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTION_FEEDBACK_ITEM__OPTIONAL = TEXT_FEEDBACK_ITEM__OPTIONAL;

	/**
	 * The feature id for the '<em><b>Question</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTION_FEEDBACK_ITEM__QUESTION = TEXT_FEEDBACK_ITEM__QUESTION;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTION_FEEDBACK_ITEM__DESCRIPTION = TEXT_FEEDBACK_ITEM__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Order Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTION_FEEDBACK_ITEM__ORDER_COUNT = TEXT_FEEDBACK_ITEM__ORDER_COUNT;

	/**
	 * The feature id for the '<em><b>Default Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTION_FEEDBACK_ITEM__DEFAULT_VALUE = TEXT_FEEDBACK_ITEM__DEFAULT_VALUE;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTION_FEEDBACK_ITEM__VALUE = TEXT_FEEDBACK_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Multiple Values</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTION_FEEDBACK_ITEM__MULTIPLE_VALUES = TEXT_FEEDBACK_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Option Feedback Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTION_FEEDBACK_ITEM_FEATURE_COUNT = TEXT_FEEDBACK_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Option Feedback Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPTION_FEEDBACK_ITEM_OPERATION_COUNT = TEXT_FEEDBACK_ITEM_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.ContactType <em>Contact Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.ContactType
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getContactType()
	 * @generated
	 */
	int CONTACT_TYPE = 25;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.TransactionType <em>Transaction Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.TransactionType
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getTransactionType()
	 * @generated
	 */
	int TRANSACTION_TYPE = 26;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.AssetChangeType <em>Asset Change Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.AssetChangeType
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getAssetChangeType()
	 * @generated
	 */
	int ASSET_CHANGE_TYPE = 27;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.DocumentationType <em>Documentation Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.DocumentationType
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getDocumentationType()
	 * @generated
	 */
	int DOCUMENTATION_TYPE = 28;

	/**
	 * The meta object id for the '{@link org.gecko.notary.model.notary.FeedbackType <em>Feedback Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.notary.model.notary.FeedbackType
	 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getFeedbackType()
	 * @generated
	 */
	int FEEDBACK_TYPE = 29;


	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.Participant <em>Participant</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Participant</em>'.
	 * @see org.gecko.notary.model.notary.Participant
	 * @generated
	 */
	EClass getParticipant();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Participant#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.notary.model.notary.Participant#getId()
	 * @see #getParticipant()
	 * @generated
	 */
	EAttribute getParticipant_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Participant#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.gecko.notary.model.notary.Participant#getName()
	 * @see #getParticipant()
	 * @generated
	 */
	EAttribute getParticipant_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Participant#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.gecko.notary.model.notary.Participant#getDescription()
	 * @see #getParticipant()
	 * @generated
	 */
	EAttribute getParticipant_Description();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.notary.model.notary.Participant#getAddress <em>Address</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Address</em>'.
	 * @see org.gecko.notary.model.notary.Participant#getAddress()
	 * @see #getParticipant()
	 * @generated
	 */
	EReference getParticipant_Address();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.ParticipantDefinition <em>Participant Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Participant Definition</em>'.
	 * @see org.gecko.notary.model.notary.ParticipantDefinition
	 * @generated
	 */
	EClass getParticipantDefinition();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.ParticipantDefinition#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.notary.model.notary.ParticipantDefinition#getId()
	 * @see #getParticipantDefinition()
	 * @generated
	 */
	EAttribute getParticipantDefinition_Id();

	/**
	 * Returns the meta object for the containment reference list '{@link org.gecko.notary.model.notary.ParticipantDefinition#getContact <em>Contact</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Contact</em>'.
	 * @see org.gecko.notary.model.notary.ParticipantDefinition#getContact()
	 * @see #getParticipantDefinition()
	 * @generated
	 */
	EReference getParticipantDefinition_Contact();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.notary.model.notary.ParticipantDefinition#getParticipant <em>Participant</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Participant</em>'.
	 * @see org.gecko.notary.model.notary.ParticipantDefinition#getParticipant()
	 * @see #getParticipantDefinition()
	 * @generated
	 */
	EReference getParticipantDefinition_Participant();

	/**
	 * Returns the meta object for the reference list '{@link org.gecko.notary.model.notary.ParticipantDefinition#getTransaction <em>Transaction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Transaction</em>'.
	 * @see org.gecko.notary.model.notary.ParticipantDefinition#getTransaction()
	 * @see #getParticipantDefinition()
	 * @generated
	 */
	EReference getParticipantDefinition_Transaction();

	/**
	 * Returns the meta object for the reference list '{@link org.gecko.notary.model.notary.ParticipantDefinition#getAsset <em>Asset</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Asset</em>'.
	 * @see org.gecko.notary.model.notary.ParticipantDefinition#getAsset()
	 * @see #getParticipantDefinition()
	 * @generated
	 */
	EReference getParticipantDefinition_Asset();

	/**
	 * Returns the meta object for the containment reference list '{@link org.gecko.notary.model.notary.ParticipantDefinition#getNotification <em>Notification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Notification</em>'.
	 * @see org.gecko.notary.model.notary.ParticipantDefinition#getNotification()
	 * @see #getParticipantDefinition()
	 * @generated
	 */
	EReference getParticipantDefinition_Notification();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.notary.model.notary.ParticipantDefinition#getNotificationLog <em>Notification Log</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Notification Log</em>'.
	 * @see org.gecko.notary.model.notary.ParticipantDefinition#getNotificationLog()
	 * @see #getParticipantDefinition()
	 * @generated
	 */
	EReference getParticipantDefinition_NotificationLog();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.Address <em>Address</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Address</em>'.
	 * @see org.gecko.notary.model.notary.Address
	 * @generated
	 */
	EClass getAddress();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Address#getStreet <em>Street</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Street</em>'.
	 * @see org.gecko.notary.model.notary.Address#getStreet()
	 * @see #getAddress()
	 * @generated
	 */
	EAttribute getAddress_Street();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Address#getFloor <em>Floor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Floor</em>'.
	 * @see org.gecko.notary.model.notary.Address#getFloor()
	 * @see #getAddress()
	 * @generated
	 */
	EAttribute getAddress_Floor();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Address#getBuilding <em>Building</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Building</em>'.
	 * @see org.gecko.notary.model.notary.Address#getBuilding()
	 * @see #getAddress()
	 * @generated
	 */
	EAttribute getAddress_Building();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Address#getZip <em>Zip</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Zip</em>'.
	 * @see org.gecko.notary.model.notary.Address#getZip()
	 * @see #getAddress()
	 * @generated
	 */
	EAttribute getAddress_Zip();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Address#getCity <em>City</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>City</em>'.
	 * @see org.gecko.notary.model.notary.Address#getCity()
	 * @see #getAddress()
	 * @generated
	 */
	EAttribute getAddress_City();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Address#getCountry <em>Country</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Country</em>'.
	 * @see org.gecko.notary.model.notary.Address#getCountry()
	 * @see #getAddress()
	 * @generated
	 */
	EAttribute getAddress_Country();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Address#getState <em>State</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>State</em>'.
	 * @see org.gecko.notary.model.notary.Address#getState()
	 * @see #getAddress()
	 * @generated
	 */
	EAttribute getAddress_State();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.Contact <em>Contact</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Contact</em>'.
	 * @see org.gecko.notary.model.notary.Contact
	 * @generated
	 */
	EClass getContact();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Contact#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.notary.model.notary.Contact#getId()
	 * @see #getContact()
	 * @generated
	 */
	EAttribute getContact_Id();

	/**
	 * Returns the meta object for the attribute list '{@link org.gecko.notary.model.notary.Contact#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Value</em>'.
	 * @see org.gecko.notary.model.notary.Contact#getValue()
	 * @see #getContact()
	 * @generated
	 */
	EAttribute getContact_Value();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Contact#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.gecko.notary.model.notary.Contact#getType()
	 * @see #getContact()
	 * @generated
	 */
	EAttribute getContact_Type();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.Transaction <em>Transaction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Transaction</em>'.
	 * @see org.gecko.notary.model.notary.Transaction
	 * @generated
	 */
	EClass getTransaction();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Transaction#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.notary.model.notary.Transaction#getId()
	 * @see #getTransaction()
	 * @generated
	 */
	EAttribute getTransaction_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Transaction#getParticipantId <em>Participant Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Participant Id</em>'.
	 * @see org.gecko.notary.model.notary.Transaction#getParticipantId()
	 * @see #getTransaction()
	 * @generated
	 */
	EAttribute getTransaction_ParticipantId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Transaction#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.gecko.notary.model.notary.Transaction#getType()
	 * @see #getTransaction()
	 * @generated
	 */
	EAttribute getTransaction_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Transaction#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.gecko.notary.model.notary.Transaction#getDescription()
	 * @see #getTransaction()
	 * @generated
	 */
	EAttribute getTransaction_Description();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Transaction#isShare <em>Share</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Share</em>'.
	 * @see org.gecko.notary.model.notary.Transaction#isShare()
	 * @see #getTransaction()
	 * @generated
	 */
	EAttribute getTransaction_Share();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.TransactionNotification <em>Transaction Notification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Transaction Notification</em>'.
	 * @see org.gecko.notary.model.notary.TransactionNotification
	 * @generated
	 */
	EClass getTransactionNotification();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.notary.model.notary.TransactionNotification#getContact <em>Contact</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Contact</em>'.
	 * @see org.gecko.notary.model.notary.TransactionNotification#getContact()
	 * @see #getTransactionNotification()
	 * @generated
	 */
	EReference getTransactionNotification_Contact();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.TransactionNotification#getContactId <em>Contact Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Contact Id</em>'.
	 * @see org.gecko.notary.model.notary.TransactionNotification#getContactId()
	 * @see #getTransactionNotification()
	 * @generated
	 */
	EAttribute getTransactionNotification_ContactId();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.notary.model.notary.TransactionNotification#getTransaction <em>Transaction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Transaction</em>'.
	 * @see org.gecko.notary.model.notary.TransactionNotification#getTransaction()
	 * @see #getTransactionNotification()
	 * @generated
	 */
	EReference getTransactionNotification_Transaction();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.TransactionNotification#getTransactionId <em>Transaction Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Transaction Id</em>'.
	 * @see org.gecko.notary.model.notary.TransactionNotification#getTransactionId()
	 * @see #getTransactionNotification()
	 * @generated
	 */
	EAttribute getTransactionNotification_TransactionId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.TransactionNotification#getContent <em>Content</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Content</em>'.
	 * @see org.gecko.notary.model.notary.TransactionNotification#getContent()
	 * @see #getTransactionNotification()
	 * @generated
	 */
	EAttribute getTransactionNotification_Content();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.TransactionNotification#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.notary.model.notary.TransactionNotification#getId()
	 * @see #getTransactionNotification()
	 * @generated
	 */
	EAttribute getTransactionNotification_Id();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.TransactionEntry <em>Transaction Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Transaction Entry</em>'.
	 * @see org.gecko.notary.model.notary.TransactionEntry
	 * @generated
	 */
	EClass getTransactionEntry();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.TransactionEntry#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.notary.model.notary.TransactionEntry#getId()
	 * @see #getTransactionEntry()
	 * @generated
	 */
	EAttribute getTransactionEntry_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.TransactionEntry#getTimestamp <em>Timestamp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Timestamp</em>'.
	 * @see org.gecko.notary.model.notary.TransactionEntry#getTimestamp()
	 * @see #getTransactionEntry()
	 * @generated
	 */
	EAttribute getTransactionEntry_Timestamp();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.TransactionEntry#getLabel <em>Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Label</em>'.
	 * @see org.gecko.notary.model.notary.TransactionEntry#getLabel()
	 * @see #getTransactionEntry()
	 * @generated
	 */
	EAttribute getTransactionEntry_Label();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.TransactionEntry#getComment <em>Comment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Comment</em>'.
	 * @see org.gecko.notary.model.notary.TransactionEntry#getComment()
	 * @see #getTransactionEntry()
	 * @generated
	 */
	EAttribute getTransactionEntry_Comment();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.TransactionEntry#getAssetId <em>Asset Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Asset Id</em>'.
	 * @see org.gecko.notary.model.notary.TransactionEntry#getAssetId()
	 * @see #getTransactionEntry()
	 * @generated
	 */
	EAttribute getTransactionEntry_AssetId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.TransactionEntry#getTransactionId <em>Transaction Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Transaction Id</em>'.
	 * @see org.gecko.notary.model.notary.TransactionEntry#getTransactionId()
	 * @see #getTransactionEntry()
	 * @generated
	 */
	EAttribute getTransactionEntry_TransactionId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.TransactionEntry#getParticipantId <em>Participant Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Participant Id</em>'.
	 * @see org.gecko.notary.model.notary.TransactionEntry#getParticipantId()
	 * @see #getTransactionEntry()
	 * @generated
	 */
	EAttribute getTransactionEntry_ParticipantId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.TransactionEntry#getPrecedingEntryId <em>Preceding Entry Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Preceding Entry Id</em>'.
	 * @see org.gecko.notary.model.notary.TransactionEntry#getPrecedingEntryId()
	 * @see #getTransactionEntry()
	 * @generated
	 */
	EAttribute getTransactionEntry_PrecedingEntryId();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.notary.model.notary.TransactionEntry#getPrecedingEntry <em>Preceding Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Preceding Entry</em>'.
	 * @see org.gecko.notary.model.notary.TransactionEntry#getPrecedingEntry()
	 * @see #getTransactionEntry()
	 * @generated
	 */
	EReference getTransactionEntry_PrecedingEntry();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.TransactionEntry#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Source</em>'.
	 * @see org.gecko.notary.model.notary.TransactionEntry#getSource()
	 * @see #getTransactionEntry()
	 * @generated
	 */
	EAttribute getTransactionEntry_Source();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.AssetTransactionEntry <em>Asset Transaction Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Asset Transaction Entry</em>'.
	 * @see org.gecko.notary.model.notary.AssetTransactionEntry
	 * @generated
	 */
	EClass getAssetTransactionEntry();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.notary.model.notary.AssetTransactionEntry#getAsset <em>Asset</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Asset</em>'.
	 * @see org.gecko.notary.model.notary.AssetTransactionEntry#getAsset()
	 * @see #getAssetTransactionEntry()
	 * @generated
	 */
	EReference getAssetTransactionEntry_Asset();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.AssetTransactionEntry#getChangeType <em>Change Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Change Type</em>'.
	 * @see org.gecko.notary.model.notary.AssetTransactionEntry#getChangeType()
	 * @see #getAssetTransactionEntry()
	 * @generated
	 */
	EAttribute getAssetTransactionEntry_ChangeType();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.AssetTransactionEntry#getParentAssetId <em>Parent Asset Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Parent Asset Id</em>'.
	 * @see org.gecko.notary.model.notary.AssetTransactionEntry#getParentAssetId()
	 * @see #getAssetTransactionEntry()
	 * @generated
	 */
	EAttribute getAssetTransactionEntry_ParentAssetId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.AssetTransactionEntry#getChangeData <em>Change Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Change Data</em>'.
	 * @see org.gecko.notary.model.notary.AssetTransactionEntry#getChangeData()
	 * @see #getAssetTransactionEntry()
	 * @generated
	 */
	EAttribute getAssetTransactionEntry_ChangeData();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.Asset <em>Asset</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Asset</em>'.
	 * @see org.gecko.notary.model.notary.Asset
	 * @generated
	 */
	EClass getAsset();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Asset#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.notary.model.notary.Asset#getId()
	 * @see #getAsset()
	 * @generated
	 */
	EAttribute getAsset_Id();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.notary.model.notary.Asset#getAssetLog <em>Asset Log</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Asset Log</em>'.
	 * @see org.gecko.notary.model.notary.Asset#getAssetLog()
	 * @see #getAsset()
	 * @generated
	 */
	EReference getAsset_AssetLog();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Asset#isInactive <em>Inactive</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Inactive</em>'.
	 * @see org.gecko.notary.model.notary.Asset#isInactive()
	 * @see #getAsset()
	 * @generated
	 */
	EAttribute getAsset_Inactive();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Asset#getCreatorBehalf <em>Creator Behalf</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Creator Behalf</em>'.
	 * @see org.gecko.notary.model.notary.Asset#getCreatorBehalf()
	 * @see #getAsset()
	 * @generated
	 */
	EAttribute getAsset_CreatorBehalf();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Asset#getCreatorId <em>Creator Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Creator Id</em>'.
	 * @see org.gecko.notary.model.notary.Asset#getCreatorId()
	 * @see #getAsset()
	 * @generated
	 */
	EAttribute getAsset_CreatorId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Asset#getOwnerId <em>Owner Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Owner Id</em>'.
	 * @see org.gecko.notary.model.notary.Asset#getOwnerId()
	 * @see #getAsset()
	 * @generated
	 */
	EAttribute getAsset_OwnerId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Asset#getOwnerName <em>Owner Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Owner Name</em>'.
	 * @see org.gecko.notary.model.notary.Asset#getOwnerName()
	 * @see #getAsset()
	 * @generated
	 */
	EAttribute getAsset_OwnerName();

	/**
	 * Returns the meta object for the containment reference list '{@link org.gecko.notary.model.notary.Asset#getAsset <em>Asset</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Asset</em>'.
	 * @see org.gecko.notary.model.notary.Asset#getAsset()
	 * @see #getAsset()
	 * @generated
	 */
	EReference getAsset_Asset();

	/**
	 * Returns the meta object for the attribute list '{@link org.gecko.notary.model.notary.Asset#getAssetIds <em>Asset Ids</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Asset Ids</em>'.
	 * @see org.gecko.notary.model.notary.Asset#getAssetIds()
	 * @see #getAsset()
	 * @generated
	 */
	EAttribute getAsset_AssetIds();

	/**
	 * Returns the meta object for the attribute list '{@link org.gecko.notary.model.notary.Asset#getTransactionDesc <em>Transaction Desc</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Transaction Desc</em>'.
	 * @see org.gecko.notary.model.notary.Asset#getTransactionDesc()
	 * @see #getAsset()
	 * @generated
	 */
	EAttribute getAsset_TransactionDesc();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.notary.model.notary.Asset#getInfo <em>Info</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Info</em>'.
	 * @see org.gecko.notary.model.notary.Asset#getInfo()
	 * @see #getAsset()
	 * @generated
	 */
	EReference getAsset_Info();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.AssetLog <em>Asset Log</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Asset Log</em>'.
	 * @see org.gecko.notary.model.notary.AssetLog
	 * @generated
	 */
	EClass getAssetLog();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.AssetLog#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.notary.model.notary.AssetLog#getId()
	 * @see #getAssetLog()
	 * @generated
	 */
	EAttribute getAssetLog_Id();

	/**
	 * Returns the meta object for the reference list '{@link org.gecko.notary.model.notary.AssetLog#getEntry <em>Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Entry</em>'.
	 * @see org.gecko.notary.model.notary.AssetLog#getEntry()
	 * @see #getAssetLog()
	 * @generated
	 */
	EReference getAssetLog_Entry();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.notary.model.notary.AssetLog#getLastEntry <em>Last Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Last Entry</em>'.
	 * @see org.gecko.notary.model.notary.AssetLog#getLastEntry()
	 * @see #getAssetLog()
	 * @generated
	 */
	EReference getAssetLog_LastEntry();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.AssetLog#getAssetId <em>Asset Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Asset Id</em>'.
	 * @see org.gecko.notary.model.notary.AssetLog#getAssetId()
	 * @see #getAssetLog()
	 * @generated
	 */
	EAttribute getAssetLog_AssetId();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.notary.model.notary.AssetLog#getAsset <em>Asset</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Asset</em>'.
	 * @see org.gecko.notary.model.notary.AssetLog#getAsset()
	 * @see #getAssetLog()
	 * @generated
	 */
	EReference getAssetLog_Asset();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.Notification <em>Notification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Notification</em>'.
	 * @see org.gecko.notary.model.notary.Notification
	 * @generated
	 */
	EClass getNotification();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Notification#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.notary.model.notary.Notification#getId()
	 * @see #getNotification()
	 * @generated
	 */
	EAttribute getNotification_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Notification#isRead <em>Read</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Read</em>'.
	 * @see org.gecko.notary.model.notary.Notification#isRead()
	 * @see #getNotification()
	 * @generated
	 */
	EAttribute getNotification_Read();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Notification#getContent <em>Content</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Content</em>'.
	 * @see org.gecko.notary.model.notary.Notification#getContent()
	 * @see #getNotification()
	 * @generated
	 */
	EAttribute getNotification_Content();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Notification#getTimestamp <em>Timestamp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Timestamp</em>'.
	 * @see org.gecko.notary.model.notary.Notification#getTimestamp()
	 * @see #getNotification()
	 * @generated
	 */
	EAttribute getNotification_Timestamp();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Notification#getSenderId <em>Sender Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Sender Id</em>'.
	 * @see org.gecko.notary.model.notary.Notification#getSenderId()
	 * @see #getNotification()
	 * @generated
	 */
	EAttribute getNotification_SenderId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Notification#getReceipientId <em>Receipient Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Receipient Id</em>'.
	 * @see org.gecko.notary.model.notary.Notification#getReceipientId()
	 * @see #getNotification()
	 * @generated
	 */
	EAttribute getNotification_ReceipientId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Notification#getSubject <em>Subject</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Subject</em>'.
	 * @see org.gecko.notary.model.notary.Notification#getSubject()
	 * @see #getNotification()
	 * @generated
	 */
	EAttribute getNotification_Subject();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.NotificationLog <em>Notification Log</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Notification Log</em>'.
	 * @see org.gecko.notary.model.notary.NotificationLog
	 * @generated
	 */
	EClass getNotificationLog();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.NotificationLog#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.notary.model.notary.NotificationLog#getId()
	 * @see #getNotificationLog()
	 * @generated
	 */
	EAttribute getNotificationLog_Id();

	/**
	 * Returns the meta object for the reference list '{@link org.gecko.notary.model.notary.NotificationLog#getNotification <em>Notification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Notification</em>'.
	 * @see org.gecko.notary.model.notary.NotificationLog#getNotification()
	 * @see #getNotificationLog()
	 * @generated
	 */
	EReference getNotificationLog_Notification();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.ParentAssetEntry <em>Parent Asset Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parent Asset Entry</em>'.
	 * @see org.gecko.notary.model.notary.ParentAssetEntry
	 * @generated
	 */
	EClass getParentAssetEntry();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.ParentAssetEntry#getParentAssetLogId <em>Parent Asset Log Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Parent Asset Log Id</em>'.
	 * @see org.gecko.notary.model.notary.ParentAssetEntry#getParentAssetLogId()
	 * @see #getParentAssetEntry()
	 * @generated
	 */
	EAttribute getParentAssetEntry_ParentAssetLogId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.ParentAssetEntry#getParentAssetId <em>Parent Asset Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Parent Asset Id</em>'.
	 * @see org.gecko.notary.model.notary.ParentAssetEntry#getParentAssetId()
	 * @see #getParentAssetEntry()
	 * @generated
	 */
	EAttribute getParentAssetEntry_ParentAssetId();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.AssetTransaction <em>Asset Transaction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Asset Transaction</em>'.
	 * @see org.gecko.notary.model.notary.AssetTransaction
	 * @generated
	 */
	EClass getAssetTransaction();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.AssetTransaction#getChangeType <em>Change Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Change Type</em>'.
	 * @see org.gecko.notary.model.notary.AssetTransaction#getChangeType()
	 * @see #getAssetTransaction()
	 * @generated
	 */
	EAttribute getAssetTransaction_ChangeType();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.AssetInfo <em>Asset Info</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Asset Info</em>'.
	 * @see org.gecko.notary.model.notary.AssetInfo
	 * @generated
	 */
	EClass getAssetInfo();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.AssetInfo#getAssetTypeLabel <em>Asset Type Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Asset Type Label</em>'.
	 * @see org.gecko.notary.model.notary.AssetInfo#getAssetTypeLabel()
	 * @see #getAssetInfo()
	 * @generated
	 */
	EAttribute getAssetInfo_AssetTypeLabel();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.AssetInfo#getLabel <em>Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Label</em>'.
	 * @see org.gecko.notary.model.notary.AssetInfo#getLabel()
	 * @see #getAssetInfo()
	 * @generated
	 */
	EAttribute getAssetInfo_Label();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.AssetInfo#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.gecko.notary.model.notary.AssetInfo#getDescription()
	 * @see #getAssetInfo()
	 * @generated
	 */
	EAttribute getAssetInfo_Description();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.AssetInfo#getAssetIdentifier <em>Asset Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Asset Identifier</em>'.
	 * @see org.gecko.notary.model.notary.AssetInfo#getAssetIdentifier()
	 * @see #getAssetInfo()
	 * @generated
	 */
	EAttribute getAssetInfo_AssetIdentifier();

	/**
	 * Returns the meta object for the containment reference list '{@link org.gecko.notary.model.notary.AssetInfo#getDocumentation <em>Documentation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Documentation</em>'.
	 * @see org.gecko.notary.model.notary.AssetInfo#getDocumentation()
	 * @see #getAssetInfo()
	 * @generated
	 */
	EReference getAssetInfo_Documentation();

	/**
	 * Returns the meta object for the attribute list '{@link org.gecko.notary.model.notary.AssetInfo#getTransactionDesc <em>Transaction Desc</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Transaction Desc</em>'.
	 * @see org.gecko.notary.model.notary.AssetInfo#getTransactionDesc()
	 * @see #getAssetInfo()
	 * @generated
	 */
	EAttribute getAssetInfo_TransactionDesc();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.DocumentationReference <em>Documentation Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Documentation Reference</em>'.
	 * @see org.gecko.notary.model.notary.DocumentationReference
	 * @generated
	 */
	EClass getDocumentationReference();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.DocumentationReference#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.notary.model.notary.DocumentationReference#getId()
	 * @see #getDocumentationReference()
	 * @generated
	 */
	EAttribute getDocumentationReference_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.DocumentationReference#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.gecko.notary.model.notary.DocumentationReference#getName()
	 * @see #getDocumentationReference()
	 * @generated
	 */
	EAttribute getDocumentationReference_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.DocumentationReference#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.gecko.notary.model.notary.DocumentationReference#getDescription()
	 * @see #getDocumentationReference()
	 * @generated
	 */
	EAttribute getDocumentationReference_Description();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.DocumentationReference#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.gecko.notary.model.notary.DocumentationReference#getType()
	 * @see #getDocumentationReference()
	 * @generated
	 */
	EAttribute getDocumentationReference_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.DocumentationReference#getReference <em>Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Reference</em>'.
	 * @see org.gecko.notary.model.notary.DocumentationReference#getReference()
	 * @see #getDocumentationReference()
	 * @generated
	 */
	EAttribute getDocumentationReference_Reference();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.FeedbackTransaction <em>Feedback Transaction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Feedback Transaction</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackTransaction
	 * @generated
	 */
	EClass getFeedbackTransaction();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.notary.model.notary.FeedbackTransaction#getFeedback <em>Feedback</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Feedback</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackTransaction#getFeedback()
	 * @see #getFeedbackTransaction()
	 * @generated
	 */
	EReference getFeedbackTransaction_Feedback();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.Feedback <em>Feedback</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Feedback</em>'.
	 * @see org.gecko.notary.model.notary.Feedback
	 * @generated
	 */
	EClass getFeedback();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Feedback#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.notary.model.notary.Feedback#getId()
	 * @see #getFeedback()
	 * @generated
	 */
	EAttribute getFeedback_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Feedback#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.gecko.notary.model.notary.Feedback#getName()
	 * @see #getFeedback()
	 * @generated
	 */
	EAttribute getFeedback_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Feedback#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.gecko.notary.model.notary.Feedback#getDescription()
	 * @see #getFeedback()
	 * @generated
	 */
	EAttribute getFeedback_Description();

	/**
	 * Returns the meta object for the containment reference list '{@link org.gecko.notary.model.notary.Feedback#getItem <em>Item</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Item</em>'.
	 * @see org.gecko.notary.model.notary.Feedback#getItem()
	 * @see #getFeedback()
	 * @generated
	 */
	EReference getFeedback_Item();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.Feedback#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.gecko.notary.model.notary.Feedback#getType()
	 * @see #getFeedback()
	 * @generated
	 */
	EAttribute getFeedback_Type();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.FeedbackResult <em>Feedback Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Feedback Result</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackResult
	 * @generated
	 */
	EClass getFeedbackResult();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.FeedbackResult#getTimestamp <em>Timestamp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Timestamp</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackResult#getTimestamp()
	 * @see #getFeedbackResult()
	 * @generated
	 */
	EAttribute getFeedbackResult_Timestamp();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.FeedbackResult#getParticipantId <em>Participant Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Participant Id</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackResult#getParticipantId()
	 * @see #getFeedbackResult()
	 * @generated
	 */
	EAttribute getFeedbackResult_ParticipantId();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.notary.model.notary.FeedbackResult#getFeedback <em>Feedback</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Feedback</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackResult#getFeedback()
	 * @see #getFeedbackResult()
	 * @generated
	 */
	EReference getFeedbackResult_Feedback();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.FeedbackResult#getFeedbackId <em>Feedback Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Feedback Id</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackResult#getFeedbackId()
	 * @see #getFeedbackResult()
	 * @generated
	 */
	EAttribute getFeedbackResult_FeedbackId();

	/**
	 * Returns the meta object for the containment reference list '{@link org.gecko.notary.model.notary.FeedbackResult#getResultItem <em>Result Item</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Result Item</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackResult#getResultItem()
	 * @see #getFeedbackResult()
	 * @generated
	 */
	EReference getFeedbackResult_ResultItem();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.FeedbackResultItem <em>Feedback Result Item</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Feedback Result Item</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackResultItem
	 * @generated
	 */
	EClass getFeedbackResultItem();

	/**
	 * Returns the meta object for the reference '{@link org.gecko.notary.model.notary.FeedbackResultItem#getItem <em>Item</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Item</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackResultItem#getItem()
	 * @see #getFeedbackResultItem()
	 * @generated
	 */
	EReference getFeedbackResultItem_Item();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.FeedbackResultItem#getItemId <em>Item Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Item Id</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackResultItem#getItemId()
	 * @see #getFeedbackResultItem()
	 * @generated
	 */
	EAttribute getFeedbackResultItem_ItemId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.FeedbackResultItem#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackResultItem#getValue()
	 * @see #getFeedbackResultItem()
	 * @generated
	 */
	EAttribute getFeedbackResultItem_Value();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.FeedbackItem <em>Feedback Item</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Feedback Item</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackItem
	 * @generated
	 */
	EClass getFeedbackItem();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.FeedbackItem#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackItem#getId()
	 * @see #getFeedbackItem()
	 * @generated
	 */
	EAttribute getFeedbackItem_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.FeedbackItem#isOptional <em>Optional</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Optional</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackItem#isOptional()
	 * @see #getFeedbackItem()
	 * @generated
	 */
	EAttribute getFeedbackItem_Optional();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.FeedbackItem#getQuestion <em>Question</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Question</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackItem#getQuestion()
	 * @see #getFeedbackItem()
	 * @generated
	 */
	EAttribute getFeedbackItem_Question();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.FeedbackItem#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackItem#getDescription()
	 * @see #getFeedbackItem()
	 * @generated
	 */
	EAttribute getFeedbackItem_Description();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.FeedbackItem#getOrderCount <em>Order Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Order Count</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackItem#getOrderCount()
	 * @see #getFeedbackItem()
	 * @generated
	 */
	EAttribute getFeedbackItem_OrderCount();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.BooleanFeedbackItem <em>Boolean Feedback Item</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Boolean Feedback Item</em>'.
	 * @see org.gecko.notary.model.notary.BooleanFeedbackItem
	 * @generated
	 */
	EClass getBooleanFeedbackItem();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.BooleanFeedbackItem#getDefaultValue <em>Default Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Default Value</em>'.
	 * @see org.gecko.notary.model.notary.BooleanFeedbackItem#getDefaultValue()
	 * @see #getBooleanFeedbackItem()
	 * @generated
	 */
	EAttribute getBooleanFeedbackItem_DefaultValue();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.TextFeedbackItem <em>Text Feedback Item</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Text Feedback Item</em>'.
	 * @see org.gecko.notary.model.notary.TextFeedbackItem
	 * @generated
	 */
	EClass getTextFeedbackItem();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.TextFeedbackItem#getDefaultValue <em>Default Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Default Value</em>'.
	 * @see org.gecko.notary.model.notary.TextFeedbackItem#getDefaultValue()
	 * @see #getTextFeedbackItem()
	 * @generated
	 */
	EAttribute getTextFeedbackItem_DefaultValue();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.ScoreFeedbackItem <em>Score Feedback Item</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Score Feedback Item</em>'.
	 * @see org.gecko.notary.model.notary.ScoreFeedbackItem
	 * @generated
	 */
	EClass getScoreFeedbackItem();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.ScoreFeedbackItem#getDefaultValue <em>Default Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Default Value</em>'.
	 * @see org.gecko.notary.model.notary.ScoreFeedbackItem#getDefaultValue()
	 * @see #getScoreFeedbackItem()
	 * @generated
	 */
	EAttribute getScoreFeedbackItem_DefaultValue();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.ScoreFeedbackItem#getMinScore <em>Min Score</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Min Score</em>'.
	 * @see org.gecko.notary.model.notary.ScoreFeedbackItem#getMinScore()
	 * @see #getScoreFeedbackItem()
	 * @generated
	 */
	EAttribute getScoreFeedbackItem_MinScore();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.ScoreFeedbackItem#getMaxScore <em>Max Score</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Max Score</em>'.
	 * @see org.gecko.notary.model.notary.ScoreFeedbackItem#getMaxScore()
	 * @see #getScoreFeedbackItem()
	 * @generated
	 */
	EAttribute getScoreFeedbackItem_MaxScore();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.ScoreFeedbackItem#getMinDescription <em>Min Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Min Description</em>'.
	 * @see org.gecko.notary.model.notary.ScoreFeedbackItem#getMinDescription()
	 * @see #getScoreFeedbackItem()
	 * @generated
	 */
	EAttribute getScoreFeedbackItem_MinDescription();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.ScoreFeedbackItem#getMaxDescription <em>Max Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Max Description</em>'.
	 * @see org.gecko.notary.model.notary.ScoreFeedbackItem#getMaxDescription()
	 * @see #getScoreFeedbackItem()
	 * @generated
	 */
	EAttribute getScoreFeedbackItem_MaxDescription();

	/**
	 * Returns the meta object for class '{@link org.gecko.notary.model.notary.OptionFeedbackItem <em>Option Feedback Item</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Option Feedback Item</em>'.
	 * @see org.gecko.notary.model.notary.OptionFeedbackItem
	 * @generated
	 */
	EClass getOptionFeedbackItem();

	/**
	 * Returns the meta object for the attribute list '{@link org.gecko.notary.model.notary.OptionFeedbackItem#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Value</em>'.
	 * @see org.gecko.notary.model.notary.OptionFeedbackItem#getValue()
	 * @see #getOptionFeedbackItem()
	 * @generated
	 */
	EAttribute getOptionFeedbackItem_Value();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.notary.model.notary.OptionFeedbackItem#isMultipleValues <em>Multiple Values</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Multiple Values</em>'.
	 * @see org.gecko.notary.model.notary.OptionFeedbackItem#isMultipleValues()
	 * @see #getOptionFeedbackItem()
	 * @generated
	 */
	EAttribute getOptionFeedbackItem_MultipleValues();

	/**
	 * Returns the meta object for enum '{@link org.gecko.notary.model.notary.ContactType <em>Contact Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Contact Type</em>'.
	 * @see org.gecko.notary.model.notary.ContactType
	 * @generated
	 */
	EEnum getContactType();

	/**
	 * Returns the meta object for enum '{@link org.gecko.notary.model.notary.TransactionType <em>Transaction Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Transaction Type</em>'.
	 * @see org.gecko.notary.model.notary.TransactionType
	 * @generated
	 */
	EEnum getTransactionType();

	/**
	 * Returns the meta object for enum '{@link org.gecko.notary.model.notary.AssetChangeType <em>Asset Change Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Asset Change Type</em>'.
	 * @see org.gecko.notary.model.notary.AssetChangeType
	 * @generated
	 */
	EEnum getAssetChangeType();

	/**
	 * Returns the meta object for enum '{@link org.gecko.notary.model.notary.DocumentationType <em>Documentation Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Documentation Type</em>'.
	 * @see org.gecko.notary.model.notary.DocumentationType
	 * @generated
	 */
	EEnum getDocumentationType();

	/**
	 * Returns the meta object for enum '{@link org.gecko.notary.model.notary.FeedbackType <em>Feedback Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Feedback Type</em>'.
	 * @see org.gecko.notary.model.notary.FeedbackType
	 * @generated
	 */
	EEnum getFeedbackType();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	NotaryFactory getNotaryFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.ParticipantImpl <em>Participant</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.ParticipantImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getParticipant()
		 * @generated
		 */
		EClass PARTICIPANT = eINSTANCE.getParticipant();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PARTICIPANT__ID = eINSTANCE.getParticipant_Id();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PARTICIPANT__NAME = eINSTANCE.getParticipant_Name();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PARTICIPANT__DESCRIPTION = eINSTANCE.getParticipant_Description();

		/**
		 * The meta object literal for the '<em><b>Address</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARTICIPANT__ADDRESS = eINSTANCE.getParticipant_Address();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.ParticipantDefinitionImpl <em>Participant Definition</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.ParticipantDefinitionImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getParticipantDefinition()
		 * @generated
		 */
		EClass PARTICIPANT_DEFINITION = eINSTANCE.getParticipantDefinition();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PARTICIPANT_DEFINITION__ID = eINSTANCE.getParticipantDefinition_Id();

		/**
		 * The meta object literal for the '<em><b>Contact</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARTICIPANT_DEFINITION__CONTACT = eINSTANCE.getParticipantDefinition_Contact();

		/**
		 * The meta object literal for the '<em><b>Participant</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARTICIPANT_DEFINITION__PARTICIPANT = eINSTANCE.getParticipantDefinition_Participant();

		/**
		 * The meta object literal for the '<em><b>Transaction</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARTICIPANT_DEFINITION__TRANSACTION = eINSTANCE.getParticipantDefinition_Transaction();

		/**
		 * The meta object literal for the '<em><b>Asset</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARTICIPANT_DEFINITION__ASSET = eINSTANCE.getParticipantDefinition_Asset();

		/**
		 * The meta object literal for the '<em><b>Notification</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARTICIPANT_DEFINITION__NOTIFICATION = eINSTANCE.getParticipantDefinition_Notification();

		/**
		 * The meta object literal for the '<em><b>Notification Log</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARTICIPANT_DEFINITION__NOTIFICATION_LOG = eINSTANCE.getParticipantDefinition_NotificationLog();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.AddressImpl <em>Address</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.AddressImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getAddress()
		 * @generated
		 */
		EClass ADDRESS = eINSTANCE.getAddress();

		/**
		 * The meta object literal for the '<em><b>Street</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ADDRESS__STREET = eINSTANCE.getAddress_Street();

		/**
		 * The meta object literal for the '<em><b>Floor</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ADDRESS__FLOOR = eINSTANCE.getAddress_Floor();

		/**
		 * The meta object literal for the '<em><b>Building</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ADDRESS__BUILDING = eINSTANCE.getAddress_Building();

		/**
		 * The meta object literal for the '<em><b>Zip</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ADDRESS__ZIP = eINSTANCE.getAddress_Zip();

		/**
		 * The meta object literal for the '<em><b>City</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ADDRESS__CITY = eINSTANCE.getAddress_City();

		/**
		 * The meta object literal for the '<em><b>Country</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ADDRESS__COUNTRY = eINSTANCE.getAddress_Country();

		/**
		 * The meta object literal for the '<em><b>State</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ADDRESS__STATE = eINSTANCE.getAddress_State();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.ContactImpl <em>Contact</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.ContactImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getContact()
		 * @generated
		 */
		EClass CONTACT = eINSTANCE.getContact();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTACT__ID = eINSTANCE.getContact_Id();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTACT__VALUE = eINSTANCE.getContact_Value();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTACT__TYPE = eINSTANCE.getContact_Type();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.TransactionImpl <em>Transaction</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.TransactionImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getTransaction()
		 * @generated
		 */
		EClass TRANSACTION = eINSTANCE.getTransaction();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSACTION__ID = eINSTANCE.getTransaction_Id();

		/**
		 * The meta object literal for the '<em><b>Participant Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSACTION__PARTICIPANT_ID = eINSTANCE.getTransaction_ParticipantId();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSACTION__TYPE = eINSTANCE.getTransaction_Type();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSACTION__DESCRIPTION = eINSTANCE.getTransaction_Description();

		/**
		 * The meta object literal for the '<em><b>Share</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSACTION__SHARE = eINSTANCE.getTransaction_Share();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.TransactionNotificationImpl <em>Transaction Notification</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.TransactionNotificationImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getTransactionNotification()
		 * @generated
		 */
		EClass TRANSACTION_NOTIFICATION = eINSTANCE.getTransactionNotification();

		/**
		 * The meta object literal for the '<em><b>Contact</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRANSACTION_NOTIFICATION__CONTACT = eINSTANCE.getTransactionNotification_Contact();

		/**
		 * The meta object literal for the '<em><b>Contact Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSACTION_NOTIFICATION__CONTACT_ID = eINSTANCE.getTransactionNotification_ContactId();

		/**
		 * The meta object literal for the '<em><b>Transaction</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRANSACTION_NOTIFICATION__TRANSACTION = eINSTANCE.getTransactionNotification_Transaction();

		/**
		 * The meta object literal for the '<em><b>Transaction Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSACTION_NOTIFICATION__TRANSACTION_ID = eINSTANCE.getTransactionNotification_TransactionId();

		/**
		 * The meta object literal for the '<em><b>Content</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSACTION_NOTIFICATION__CONTENT = eINSTANCE.getTransactionNotification_Content();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSACTION_NOTIFICATION__ID = eINSTANCE.getTransactionNotification_Id();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.TransactionEntryImpl <em>Transaction Entry</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.TransactionEntryImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getTransactionEntry()
		 * @generated
		 */
		EClass TRANSACTION_ENTRY = eINSTANCE.getTransactionEntry();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSACTION_ENTRY__ID = eINSTANCE.getTransactionEntry_Id();

		/**
		 * The meta object literal for the '<em><b>Timestamp</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSACTION_ENTRY__TIMESTAMP = eINSTANCE.getTransactionEntry_Timestamp();

		/**
		 * The meta object literal for the '<em><b>Label</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSACTION_ENTRY__LABEL = eINSTANCE.getTransactionEntry_Label();

		/**
		 * The meta object literal for the '<em><b>Comment</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSACTION_ENTRY__COMMENT = eINSTANCE.getTransactionEntry_Comment();

		/**
		 * The meta object literal for the '<em><b>Asset Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSACTION_ENTRY__ASSET_ID = eINSTANCE.getTransactionEntry_AssetId();

		/**
		 * The meta object literal for the '<em><b>Transaction Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSACTION_ENTRY__TRANSACTION_ID = eINSTANCE.getTransactionEntry_TransactionId();

		/**
		 * The meta object literal for the '<em><b>Participant Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSACTION_ENTRY__PARTICIPANT_ID = eINSTANCE.getTransactionEntry_ParticipantId();

		/**
		 * The meta object literal for the '<em><b>Preceding Entry Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSACTION_ENTRY__PRECEDING_ENTRY_ID = eINSTANCE.getTransactionEntry_PrecedingEntryId();

		/**
		 * The meta object literal for the '<em><b>Preceding Entry</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRANSACTION_ENTRY__PRECEDING_ENTRY = eINSTANCE.getTransactionEntry_PrecedingEntry();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TRANSACTION_ENTRY__SOURCE = eINSTANCE.getTransactionEntry_Source();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.AssetTransactionEntryImpl <em>Asset Transaction Entry</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.AssetTransactionEntryImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getAssetTransactionEntry()
		 * @generated
		 */
		EClass ASSET_TRANSACTION_ENTRY = eINSTANCE.getAssetTransactionEntry();

		/**
		 * The meta object literal for the '<em><b>Asset</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSET_TRANSACTION_ENTRY__ASSET = eINSTANCE.getAssetTransactionEntry_Asset();

		/**
		 * The meta object literal for the '<em><b>Change Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET_TRANSACTION_ENTRY__CHANGE_TYPE = eINSTANCE.getAssetTransactionEntry_ChangeType();

		/**
		 * The meta object literal for the '<em><b>Parent Asset Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET_TRANSACTION_ENTRY__PARENT_ASSET_ID = eINSTANCE.getAssetTransactionEntry_ParentAssetId();

		/**
		 * The meta object literal for the '<em><b>Change Data</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET_TRANSACTION_ENTRY__CHANGE_DATA = eINSTANCE.getAssetTransactionEntry_ChangeData();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.AssetImpl <em>Asset</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.AssetImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getAsset()
		 * @generated
		 */
		EClass ASSET = eINSTANCE.getAsset();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET__ID = eINSTANCE.getAsset_Id();

		/**
		 * The meta object literal for the '<em><b>Asset Log</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSET__ASSET_LOG = eINSTANCE.getAsset_AssetLog();

		/**
		 * The meta object literal for the '<em><b>Inactive</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET__INACTIVE = eINSTANCE.getAsset_Inactive();

		/**
		 * The meta object literal for the '<em><b>Creator Behalf</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET__CREATOR_BEHALF = eINSTANCE.getAsset_CreatorBehalf();

		/**
		 * The meta object literal for the '<em><b>Creator Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET__CREATOR_ID = eINSTANCE.getAsset_CreatorId();

		/**
		 * The meta object literal for the '<em><b>Owner Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET__OWNER_ID = eINSTANCE.getAsset_OwnerId();

		/**
		 * The meta object literal for the '<em><b>Owner Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET__OWNER_NAME = eINSTANCE.getAsset_OwnerName();

		/**
		 * The meta object literal for the '<em><b>Asset</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSET__ASSET = eINSTANCE.getAsset_Asset();

		/**
		 * The meta object literal for the '<em><b>Asset Ids</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET__ASSET_IDS = eINSTANCE.getAsset_AssetIds();

		/**
		 * The meta object literal for the '<em><b>Transaction Desc</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET__TRANSACTION_DESC = eINSTANCE.getAsset_TransactionDesc();

		/**
		 * The meta object literal for the '<em><b>Info</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSET__INFO = eINSTANCE.getAsset_Info();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.AssetLogImpl <em>Asset Log</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.AssetLogImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getAssetLog()
		 * @generated
		 */
		EClass ASSET_LOG = eINSTANCE.getAssetLog();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET_LOG__ID = eINSTANCE.getAssetLog_Id();

		/**
		 * The meta object literal for the '<em><b>Entry</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSET_LOG__ENTRY = eINSTANCE.getAssetLog_Entry();

		/**
		 * The meta object literal for the '<em><b>Last Entry</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSET_LOG__LAST_ENTRY = eINSTANCE.getAssetLog_LastEntry();

		/**
		 * The meta object literal for the '<em><b>Asset Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET_LOG__ASSET_ID = eINSTANCE.getAssetLog_AssetId();

		/**
		 * The meta object literal for the '<em><b>Asset</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSET_LOG__ASSET = eINSTANCE.getAssetLog_Asset();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.NotificationImpl <em>Notification</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.NotificationImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getNotification()
		 * @generated
		 */
		EClass NOTIFICATION = eINSTANCE.getNotification();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NOTIFICATION__ID = eINSTANCE.getNotification_Id();

		/**
		 * The meta object literal for the '<em><b>Read</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NOTIFICATION__READ = eINSTANCE.getNotification_Read();

		/**
		 * The meta object literal for the '<em><b>Content</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NOTIFICATION__CONTENT = eINSTANCE.getNotification_Content();

		/**
		 * The meta object literal for the '<em><b>Timestamp</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NOTIFICATION__TIMESTAMP = eINSTANCE.getNotification_Timestamp();

		/**
		 * The meta object literal for the '<em><b>Sender Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NOTIFICATION__SENDER_ID = eINSTANCE.getNotification_SenderId();

		/**
		 * The meta object literal for the '<em><b>Receipient Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NOTIFICATION__RECEIPIENT_ID = eINSTANCE.getNotification_ReceipientId();

		/**
		 * The meta object literal for the '<em><b>Subject</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NOTIFICATION__SUBJECT = eINSTANCE.getNotification_Subject();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.NotificationLogImpl <em>Notification Log</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.NotificationLogImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getNotificationLog()
		 * @generated
		 */
		EClass NOTIFICATION_LOG = eINSTANCE.getNotificationLog();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NOTIFICATION_LOG__ID = eINSTANCE.getNotificationLog_Id();

		/**
		 * The meta object literal for the '<em><b>Notification</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NOTIFICATION_LOG__NOTIFICATION = eINSTANCE.getNotificationLog_Notification();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.ParentAssetEntryImpl <em>Parent Asset Entry</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.ParentAssetEntryImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getParentAssetEntry()
		 * @generated
		 */
		EClass PARENT_ASSET_ENTRY = eINSTANCE.getParentAssetEntry();

		/**
		 * The meta object literal for the '<em><b>Parent Asset Log Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PARENT_ASSET_ENTRY__PARENT_ASSET_LOG_ID = eINSTANCE.getParentAssetEntry_ParentAssetLogId();

		/**
		 * The meta object literal for the '<em><b>Parent Asset Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PARENT_ASSET_ENTRY__PARENT_ASSET_ID = eINSTANCE.getParentAssetEntry_ParentAssetId();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.AssetTransactionImpl <em>Asset Transaction</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.AssetTransactionImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getAssetTransaction()
		 * @generated
		 */
		EClass ASSET_TRANSACTION = eINSTANCE.getAssetTransaction();

		/**
		 * The meta object literal for the '<em><b>Change Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET_TRANSACTION__CHANGE_TYPE = eINSTANCE.getAssetTransaction_ChangeType();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.AssetInfoImpl <em>Asset Info</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.AssetInfoImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getAssetInfo()
		 * @generated
		 */
		EClass ASSET_INFO = eINSTANCE.getAssetInfo();

		/**
		 * The meta object literal for the '<em><b>Asset Type Label</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET_INFO__ASSET_TYPE_LABEL = eINSTANCE.getAssetInfo_AssetTypeLabel();

		/**
		 * The meta object literal for the '<em><b>Label</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET_INFO__LABEL = eINSTANCE.getAssetInfo_Label();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET_INFO__DESCRIPTION = eINSTANCE.getAssetInfo_Description();

		/**
		 * The meta object literal for the '<em><b>Asset Identifier</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET_INFO__ASSET_IDENTIFIER = eINSTANCE.getAssetInfo_AssetIdentifier();

		/**
		 * The meta object literal for the '<em><b>Documentation</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ASSET_INFO__DOCUMENTATION = eINSTANCE.getAssetInfo_Documentation();

		/**
		 * The meta object literal for the '<em><b>Transaction Desc</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ASSET_INFO__TRANSACTION_DESC = eINSTANCE.getAssetInfo_TransactionDesc();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.DocumentationReferenceImpl <em>Documentation Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.DocumentationReferenceImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getDocumentationReference()
		 * @generated
		 */
		EClass DOCUMENTATION_REFERENCE = eINSTANCE.getDocumentationReference();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DOCUMENTATION_REFERENCE__ID = eINSTANCE.getDocumentationReference_Id();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DOCUMENTATION_REFERENCE__NAME = eINSTANCE.getDocumentationReference_Name();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DOCUMENTATION_REFERENCE__DESCRIPTION = eINSTANCE.getDocumentationReference_Description();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DOCUMENTATION_REFERENCE__TYPE = eINSTANCE.getDocumentationReference_Type();

		/**
		 * The meta object literal for the '<em><b>Reference</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DOCUMENTATION_REFERENCE__REFERENCE = eINSTANCE.getDocumentationReference_Reference();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.FeedbackTransactionImpl <em>Feedback Transaction</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.FeedbackTransactionImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getFeedbackTransaction()
		 * @generated
		 */
		EClass FEEDBACK_TRANSACTION = eINSTANCE.getFeedbackTransaction();

		/**
		 * The meta object literal for the '<em><b>Feedback</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FEEDBACK_TRANSACTION__FEEDBACK = eINSTANCE.getFeedbackTransaction_Feedback();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.FeedbackImpl <em>Feedback</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.FeedbackImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getFeedback()
		 * @generated
		 */
		EClass FEEDBACK = eINSTANCE.getFeedback();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEEDBACK__ID = eINSTANCE.getFeedback_Id();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEEDBACK__NAME = eINSTANCE.getFeedback_Name();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEEDBACK__DESCRIPTION = eINSTANCE.getFeedback_Description();

		/**
		 * The meta object literal for the '<em><b>Item</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FEEDBACK__ITEM = eINSTANCE.getFeedback_Item();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEEDBACK__TYPE = eINSTANCE.getFeedback_Type();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.FeedbackResultImpl <em>Feedback Result</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.FeedbackResultImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getFeedbackResult()
		 * @generated
		 */
		EClass FEEDBACK_RESULT = eINSTANCE.getFeedbackResult();

		/**
		 * The meta object literal for the '<em><b>Timestamp</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEEDBACK_RESULT__TIMESTAMP = eINSTANCE.getFeedbackResult_Timestamp();

		/**
		 * The meta object literal for the '<em><b>Participant Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEEDBACK_RESULT__PARTICIPANT_ID = eINSTANCE.getFeedbackResult_ParticipantId();

		/**
		 * The meta object literal for the '<em><b>Feedback</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FEEDBACK_RESULT__FEEDBACK = eINSTANCE.getFeedbackResult_Feedback();

		/**
		 * The meta object literal for the '<em><b>Feedback Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEEDBACK_RESULT__FEEDBACK_ID = eINSTANCE.getFeedbackResult_FeedbackId();

		/**
		 * The meta object literal for the '<em><b>Result Item</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FEEDBACK_RESULT__RESULT_ITEM = eINSTANCE.getFeedbackResult_ResultItem();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.FeedbackResultItemImpl <em>Feedback Result Item</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.FeedbackResultItemImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getFeedbackResultItem()
		 * @generated
		 */
		EClass FEEDBACK_RESULT_ITEM = eINSTANCE.getFeedbackResultItem();

		/**
		 * The meta object literal for the '<em><b>Item</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FEEDBACK_RESULT_ITEM__ITEM = eINSTANCE.getFeedbackResultItem_Item();

		/**
		 * The meta object literal for the '<em><b>Item Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEEDBACK_RESULT_ITEM__ITEM_ID = eINSTANCE.getFeedbackResultItem_ItemId();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEEDBACK_RESULT_ITEM__VALUE = eINSTANCE.getFeedbackResultItem_Value();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.FeedbackItemImpl <em>Feedback Item</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.FeedbackItemImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getFeedbackItem()
		 * @generated
		 */
		EClass FEEDBACK_ITEM = eINSTANCE.getFeedbackItem();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEEDBACK_ITEM__ID = eINSTANCE.getFeedbackItem_Id();

		/**
		 * The meta object literal for the '<em><b>Optional</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEEDBACK_ITEM__OPTIONAL = eINSTANCE.getFeedbackItem_Optional();

		/**
		 * The meta object literal for the '<em><b>Question</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEEDBACK_ITEM__QUESTION = eINSTANCE.getFeedbackItem_Question();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEEDBACK_ITEM__DESCRIPTION = eINSTANCE.getFeedbackItem_Description();

		/**
		 * The meta object literal for the '<em><b>Order Count</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEEDBACK_ITEM__ORDER_COUNT = eINSTANCE.getFeedbackItem_OrderCount();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.BooleanFeedbackItemImpl <em>Boolean Feedback Item</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.BooleanFeedbackItemImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getBooleanFeedbackItem()
		 * @generated
		 */
		EClass BOOLEAN_FEEDBACK_ITEM = eINSTANCE.getBooleanFeedbackItem();

		/**
		 * The meta object literal for the '<em><b>Default Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BOOLEAN_FEEDBACK_ITEM__DEFAULT_VALUE = eINSTANCE.getBooleanFeedbackItem_DefaultValue();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.TextFeedbackItemImpl <em>Text Feedback Item</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.TextFeedbackItemImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getTextFeedbackItem()
		 * @generated
		 */
		EClass TEXT_FEEDBACK_ITEM = eINSTANCE.getTextFeedbackItem();

		/**
		 * The meta object literal for the '<em><b>Default Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEXT_FEEDBACK_ITEM__DEFAULT_VALUE = eINSTANCE.getTextFeedbackItem_DefaultValue();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.ScoreFeedbackItemImpl <em>Score Feedback Item</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.ScoreFeedbackItemImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getScoreFeedbackItem()
		 * @generated
		 */
		EClass SCORE_FEEDBACK_ITEM = eINSTANCE.getScoreFeedbackItem();

		/**
		 * The meta object literal for the '<em><b>Default Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCORE_FEEDBACK_ITEM__DEFAULT_VALUE = eINSTANCE.getScoreFeedbackItem_DefaultValue();

		/**
		 * The meta object literal for the '<em><b>Min Score</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCORE_FEEDBACK_ITEM__MIN_SCORE = eINSTANCE.getScoreFeedbackItem_MinScore();

		/**
		 * The meta object literal for the '<em><b>Max Score</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCORE_FEEDBACK_ITEM__MAX_SCORE = eINSTANCE.getScoreFeedbackItem_MaxScore();

		/**
		 * The meta object literal for the '<em><b>Min Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCORE_FEEDBACK_ITEM__MIN_DESCRIPTION = eINSTANCE.getScoreFeedbackItem_MinDescription();

		/**
		 * The meta object literal for the '<em><b>Max Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCORE_FEEDBACK_ITEM__MAX_DESCRIPTION = eINSTANCE.getScoreFeedbackItem_MaxDescription();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.impl.OptionFeedbackItemImpl <em>Option Feedback Item</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.impl.OptionFeedbackItemImpl
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getOptionFeedbackItem()
		 * @generated
		 */
		EClass OPTION_FEEDBACK_ITEM = eINSTANCE.getOptionFeedbackItem();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute OPTION_FEEDBACK_ITEM__VALUE = eINSTANCE.getOptionFeedbackItem_Value();

		/**
		 * The meta object literal for the '<em><b>Multiple Values</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute OPTION_FEEDBACK_ITEM__MULTIPLE_VALUES = eINSTANCE.getOptionFeedbackItem_MultipleValues();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.ContactType <em>Contact Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.ContactType
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getContactType()
		 * @generated
		 */
		EEnum CONTACT_TYPE = eINSTANCE.getContactType();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.TransactionType <em>Transaction Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.TransactionType
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getTransactionType()
		 * @generated
		 */
		EEnum TRANSACTION_TYPE = eINSTANCE.getTransactionType();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.AssetChangeType <em>Asset Change Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.AssetChangeType
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getAssetChangeType()
		 * @generated
		 */
		EEnum ASSET_CHANGE_TYPE = eINSTANCE.getAssetChangeType();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.DocumentationType <em>Documentation Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.DocumentationType
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getDocumentationType()
		 * @generated
		 */
		EEnum DOCUMENTATION_TYPE = eINSTANCE.getDocumentationType();

		/**
		 * The meta object literal for the '{@link org.gecko.notary.model.notary.FeedbackType <em>Feedback Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.notary.model.notary.FeedbackType
		 * @see org.gecko.notary.model.notary.impl.NotaryPackageImpl#getFeedbackType()
		 * @generated
		 */
		EEnum FEEDBACK_TYPE = eINSTANCE.getFeedbackType();

	}

} //NotaryPackage
