/**
 */
package org.gecko.notary.model.notary.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.gecko.notary.model.notary.Asset;
import org.gecko.notary.model.notary.AssetInfo;
import org.gecko.notary.model.notary.AssetLog;
import org.gecko.notary.model.notary.NotaryPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Asset</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetImpl#getAssetLog <em>Asset Log</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetImpl#isInactive <em>Inactive</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetImpl#getCreatorBehalf <em>Creator Behalf</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetImpl#getCreatorId <em>Creator Id</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetImpl#getOwnerId <em>Owner Id</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetImpl#getOwnerName <em>Owner Name</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetImpl#getAsset <em>Asset</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetImpl#getAssetIds <em>Asset Ids</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetImpl#getTransactionDesc <em>Transaction Desc</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetImpl#getInfo <em>Info</em>}</li>
 * </ul>
 *
 * @generated
 */
public class AssetImpl extends MinimalEObjectImpl.Container implements Asset {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getAssetLog() <em>Asset Log</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAssetLog()
	 * @generated
	 * @ordered
	 */
	protected AssetLog assetLog;

	/**
	 * The default value of the '{@link #isInactive() <em>Inactive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInactive()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INACTIVE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isInactive() <em>Inactive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInactive()
	 * @generated
	 * @ordered
	 */
	protected boolean inactive = INACTIVE_EDEFAULT;

	/**
	 * The default value of the '{@link #getCreatorBehalf() <em>Creator Behalf</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCreatorBehalf()
	 * @generated
	 * @ordered
	 */
	protected static final String CREATOR_BEHALF_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCreatorBehalf() <em>Creator Behalf</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCreatorBehalf()
	 * @generated
	 * @ordered
	 */
	protected String creatorBehalf = CREATOR_BEHALF_EDEFAULT;

	/**
	 * The default value of the '{@link #getCreatorId() <em>Creator Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCreatorId()
	 * @generated
	 * @ordered
	 */
	protected static final String CREATOR_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCreatorId() <em>Creator Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCreatorId()
	 * @generated
	 * @ordered
	 */
	protected String creatorId = CREATOR_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getOwnerId() <em>Owner Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnerId()
	 * @generated
	 * @ordered
	 */
	protected static final String OWNER_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getOwnerId() <em>Owner Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnerId()
	 * @generated
	 * @ordered
	 */
	protected String ownerId = OWNER_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getOwnerName() <em>Owner Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnerName()
	 * @generated
	 * @ordered
	 */
	protected static final String OWNER_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getOwnerName() <em>Owner Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnerName()
	 * @generated
	 * @ordered
	 */
	protected String ownerName = OWNER_NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getAsset() <em>Asset</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAsset()
	 * @generated
	 * @ordered
	 */
	protected EList<Asset> asset;

	/**
	 * The cached value of the '{@link #getAssetIds() <em>Asset Ids</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAssetIds()
	 * @generated
	 * @ordered
	 */
	protected EList<String> assetIds;

	/**
	 * The cached value of the '{@link #getTransactionDesc() <em>Transaction Desc</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTransactionDesc()
	 * @generated
	 * @ordered
	 */
	protected EList<String> transactionDesc;

	/**
	 * The cached value of the '{@link #getInfo() <em>Info</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInfo()
	 * @generated
	 * @ordered
	 */
	protected AssetInfo info;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AssetImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NotaryPackage.Literals.ASSET;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotaryPackage.ASSET__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AssetLog getAssetLog() {
		if (assetLog != null && assetLog.eIsProxy()) {
			InternalEObject oldAssetLog = (InternalEObject)assetLog;
			assetLog = (AssetLog)eResolveProxy(oldAssetLog);
			if (assetLog != oldAssetLog) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, NotaryPackage.ASSET__ASSET_LOG, oldAssetLog, assetLog));
			}
		}
		return assetLog;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AssetLog basicGetAssetLog() {
		return assetLog;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAssetLog(AssetLog newAssetLog) {
		AssetLog oldAssetLog = assetLog;
		assetLog = newAssetLog;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotaryPackage.ASSET__ASSET_LOG, oldAssetLog, assetLog));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isInactive() {
		return inactive;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setInactive(boolean newInactive) {
		boolean oldInactive = inactive;
		inactive = newInactive;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotaryPackage.ASSET__INACTIVE, oldInactive, inactive));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCreatorBehalf() {
		return creatorBehalf;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCreatorBehalf(String newCreatorBehalf) {
		String oldCreatorBehalf = creatorBehalf;
		creatorBehalf = newCreatorBehalf;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotaryPackage.ASSET__CREATOR_BEHALF, oldCreatorBehalf, creatorBehalf));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCreatorId() {
		return creatorId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCreatorId(String newCreatorId) {
		String oldCreatorId = creatorId;
		creatorId = newCreatorId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotaryPackage.ASSET__CREATOR_ID, oldCreatorId, creatorId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getOwnerId() {
		return ownerId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setOwnerId(String newOwnerId) {
		String oldOwnerId = ownerId;
		ownerId = newOwnerId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotaryPackage.ASSET__OWNER_ID, oldOwnerId, ownerId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getOwnerName() {
		return ownerName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setOwnerName(String newOwnerName) {
		String oldOwnerName = ownerName;
		ownerName = newOwnerName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotaryPackage.ASSET__OWNER_NAME, oldOwnerName, ownerName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Asset> getAsset() {
		if (asset == null) {
			asset = new EObjectContainmentEList<Asset>(Asset.class, this, NotaryPackage.ASSET__ASSET);
		}
		return asset;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getAssetIds() {
		if (assetIds == null) {
			assetIds = new EDataTypeUniqueEList<String>(String.class, this, NotaryPackage.ASSET__ASSET_IDS);
		}
		return assetIds;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getTransactionDesc() {
		if (transactionDesc == null) {
			transactionDesc = new EDataTypeUniqueEList<String>(String.class, this, NotaryPackage.ASSET__TRANSACTION_DESC);
		}
		return transactionDesc;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AssetInfo getInfo() {
		return info;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInfo(AssetInfo newInfo, NotificationChain msgs) {
		AssetInfo oldInfo = info;
		info = newInfo;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, NotaryPackage.ASSET__INFO, oldInfo, newInfo);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setInfo(AssetInfo newInfo) {
		if (newInfo != info) {
			NotificationChain msgs = null;
			if (info != null)
				msgs = ((InternalEObject)info).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - NotaryPackage.ASSET__INFO, null, msgs);
			if (newInfo != null)
				msgs = ((InternalEObject)newInfo).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - NotaryPackage.ASSET__INFO, null, msgs);
			msgs = basicSetInfo(newInfo, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotaryPackage.ASSET__INFO, newInfo, newInfo));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case NotaryPackage.ASSET__ASSET:
				return ((InternalEList<?>)getAsset()).basicRemove(otherEnd, msgs);
			case NotaryPackage.ASSET__INFO:
				return basicSetInfo(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NotaryPackage.ASSET__ID:
				return getId();
			case NotaryPackage.ASSET__ASSET_LOG:
				if (resolve) return getAssetLog();
				return basicGetAssetLog();
			case NotaryPackage.ASSET__INACTIVE:
				return isInactive();
			case NotaryPackage.ASSET__CREATOR_BEHALF:
				return getCreatorBehalf();
			case NotaryPackage.ASSET__CREATOR_ID:
				return getCreatorId();
			case NotaryPackage.ASSET__OWNER_ID:
				return getOwnerId();
			case NotaryPackage.ASSET__OWNER_NAME:
				return getOwnerName();
			case NotaryPackage.ASSET__ASSET:
				return getAsset();
			case NotaryPackage.ASSET__ASSET_IDS:
				return getAssetIds();
			case NotaryPackage.ASSET__TRANSACTION_DESC:
				return getTransactionDesc();
			case NotaryPackage.ASSET__INFO:
				return getInfo();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NotaryPackage.ASSET__ID:
				setId((String)newValue);
				return;
			case NotaryPackage.ASSET__ASSET_LOG:
				setAssetLog((AssetLog)newValue);
				return;
			case NotaryPackage.ASSET__INACTIVE:
				setInactive((Boolean)newValue);
				return;
			case NotaryPackage.ASSET__CREATOR_BEHALF:
				setCreatorBehalf((String)newValue);
				return;
			case NotaryPackage.ASSET__CREATOR_ID:
				setCreatorId((String)newValue);
				return;
			case NotaryPackage.ASSET__OWNER_ID:
				setOwnerId((String)newValue);
				return;
			case NotaryPackage.ASSET__OWNER_NAME:
				setOwnerName((String)newValue);
				return;
			case NotaryPackage.ASSET__ASSET:
				getAsset().clear();
				getAsset().addAll((Collection<? extends Asset>)newValue);
				return;
			case NotaryPackage.ASSET__ASSET_IDS:
				getAssetIds().clear();
				getAssetIds().addAll((Collection<? extends String>)newValue);
				return;
			case NotaryPackage.ASSET__TRANSACTION_DESC:
				getTransactionDesc().clear();
				getTransactionDesc().addAll((Collection<? extends String>)newValue);
				return;
			case NotaryPackage.ASSET__INFO:
				setInfo((AssetInfo)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NotaryPackage.ASSET__ID:
				setId(ID_EDEFAULT);
				return;
			case NotaryPackage.ASSET__ASSET_LOG:
				setAssetLog((AssetLog)null);
				return;
			case NotaryPackage.ASSET__INACTIVE:
				setInactive(INACTIVE_EDEFAULT);
				return;
			case NotaryPackage.ASSET__CREATOR_BEHALF:
				setCreatorBehalf(CREATOR_BEHALF_EDEFAULT);
				return;
			case NotaryPackage.ASSET__CREATOR_ID:
				setCreatorId(CREATOR_ID_EDEFAULT);
				return;
			case NotaryPackage.ASSET__OWNER_ID:
				setOwnerId(OWNER_ID_EDEFAULT);
				return;
			case NotaryPackage.ASSET__OWNER_NAME:
				setOwnerName(OWNER_NAME_EDEFAULT);
				return;
			case NotaryPackage.ASSET__ASSET:
				getAsset().clear();
				return;
			case NotaryPackage.ASSET__ASSET_IDS:
				getAssetIds().clear();
				return;
			case NotaryPackage.ASSET__TRANSACTION_DESC:
				getTransactionDesc().clear();
				return;
			case NotaryPackage.ASSET__INFO:
				setInfo((AssetInfo)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NotaryPackage.ASSET__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case NotaryPackage.ASSET__ASSET_LOG:
				return assetLog != null;
			case NotaryPackage.ASSET__INACTIVE:
				return inactive != INACTIVE_EDEFAULT;
			case NotaryPackage.ASSET__CREATOR_BEHALF:
				return CREATOR_BEHALF_EDEFAULT == null ? creatorBehalf != null : !CREATOR_BEHALF_EDEFAULT.equals(creatorBehalf);
			case NotaryPackage.ASSET__CREATOR_ID:
				return CREATOR_ID_EDEFAULT == null ? creatorId != null : !CREATOR_ID_EDEFAULT.equals(creatorId);
			case NotaryPackage.ASSET__OWNER_ID:
				return OWNER_ID_EDEFAULT == null ? ownerId != null : !OWNER_ID_EDEFAULT.equals(ownerId);
			case NotaryPackage.ASSET__OWNER_NAME:
				return OWNER_NAME_EDEFAULT == null ? ownerName != null : !OWNER_NAME_EDEFAULT.equals(ownerName);
			case NotaryPackage.ASSET__ASSET:
				return asset != null && !asset.isEmpty();
			case NotaryPackage.ASSET__ASSET_IDS:
				return assetIds != null && !assetIds.isEmpty();
			case NotaryPackage.ASSET__TRANSACTION_DESC:
				return transactionDesc != null && !transactionDesc.isEmpty();
			case NotaryPackage.ASSET__INFO:
				return info != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", inactive: ");
		result.append(inactive);
		result.append(", creatorBehalf: ");
		result.append(creatorBehalf);
		result.append(", creatorId: ");
		result.append(creatorId);
		result.append(", ownerId: ");
		result.append(ownerId);
		result.append(", ownerName: ");
		result.append(ownerName);
		result.append(", assetIds: ");
		result.append(assetIds);
		result.append(", transactionDesc: ");
		result.append(transactionDesc);
		result.append(')');
		return result.toString();
	}

} //AssetImpl
