/**
 */
package org.gecko.notary.model.notary.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.gecko.notary.model.notary.AssetInfo;
import org.gecko.notary.model.notary.DocumentationReference;
import org.gecko.notary.model.notary.NotaryPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Asset Info</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetInfoImpl#getAssetTypeLabel <em>Asset Type Label</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetInfoImpl#getLabel <em>Label</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetInfoImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetInfoImpl#getAssetIdentifier <em>Asset Identifier</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetInfoImpl#getDocumentation <em>Documentation</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetInfoImpl#getTransactionDesc <em>Transaction Desc</em>}</li>
 * </ul>
 *
 * @generated
 */
public class AssetInfoImpl extends MinimalEObjectImpl.Container implements AssetInfo {
	/**
	 * The default value of the '{@link #getAssetTypeLabel() <em>Asset Type Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAssetTypeLabel()
	 * @generated
	 * @ordered
	 */
	protected static final String ASSET_TYPE_LABEL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAssetTypeLabel() <em>Asset Type Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAssetTypeLabel()
	 * @generated
	 * @ordered
	 */
	protected String assetTypeLabel = ASSET_TYPE_LABEL_EDEFAULT;

	/**
	 * The default value of the '{@link #getLabel() <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabel()
	 * @generated
	 * @ordered
	 */
	protected static final String LABEL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLabel() <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabel()
	 * @generated
	 * @ordered
	 */
	protected String label = LABEL_EDEFAULT;

	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * The default value of the '{@link #getAssetIdentifier() <em>Asset Identifier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAssetIdentifier()
	 * @generated
	 * @ordered
	 */
	protected static final String ASSET_IDENTIFIER_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAssetIdentifier() <em>Asset Identifier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAssetIdentifier()
	 * @generated
	 * @ordered
	 */
	protected String assetIdentifier = ASSET_IDENTIFIER_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDocumentation() <em>Documentation</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDocumentation()
	 * @generated
	 * @ordered
	 */
	protected EList<DocumentationReference> documentation;

	/**
	 * The cached value of the '{@link #getTransactionDesc() <em>Transaction Desc</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTransactionDesc()
	 * @generated
	 * @ordered
	 */
	protected EList<String> transactionDesc;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AssetInfoImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NotaryPackage.Literals.ASSET_INFO;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getAssetTypeLabel() {
		return assetTypeLabel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAssetTypeLabel(String newAssetTypeLabel) {
		String oldAssetTypeLabel = assetTypeLabel;
		assetTypeLabel = newAssetTypeLabel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotaryPackage.ASSET_INFO__ASSET_TYPE_LABEL, oldAssetTypeLabel, assetTypeLabel));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLabel() {
		return label;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLabel(String newLabel) {
		String oldLabel = label;
		label = newLabel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotaryPackage.ASSET_INFO__LABEL, oldLabel, label));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotaryPackage.ASSET_INFO__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getAssetIdentifier() {
		return assetIdentifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAssetIdentifier(String newAssetIdentifier) {
		String oldAssetIdentifier = assetIdentifier;
		assetIdentifier = newAssetIdentifier;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotaryPackage.ASSET_INFO__ASSET_IDENTIFIER, oldAssetIdentifier, assetIdentifier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<DocumentationReference> getDocumentation() {
		if (documentation == null) {
			documentation = new EObjectContainmentEList<DocumentationReference>(DocumentationReference.class, this, NotaryPackage.ASSET_INFO__DOCUMENTATION);
		}
		return documentation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getTransactionDesc() {
		if (transactionDesc == null) {
			transactionDesc = new EDataTypeUniqueEList<String>(String.class, this, NotaryPackage.ASSET_INFO__TRANSACTION_DESC);
		}
		return transactionDesc;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case NotaryPackage.ASSET_INFO__DOCUMENTATION:
				return ((InternalEList<?>)getDocumentation()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NotaryPackage.ASSET_INFO__ASSET_TYPE_LABEL:
				return getAssetTypeLabel();
			case NotaryPackage.ASSET_INFO__LABEL:
				return getLabel();
			case NotaryPackage.ASSET_INFO__DESCRIPTION:
				return getDescription();
			case NotaryPackage.ASSET_INFO__ASSET_IDENTIFIER:
				return getAssetIdentifier();
			case NotaryPackage.ASSET_INFO__DOCUMENTATION:
				return getDocumentation();
			case NotaryPackage.ASSET_INFO__TRANSACTION_DESC:
				return getTransactionDesc();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NotaryPackage.ASSET_INFO__ASSET_TYPE_LABEL:
				setAssetTypeLabel((String)newValue);
				return;
			case NotaryPackage.ASSET_INFO__LABEL:
				setLabel((String)newValue);
				return;
			case NotaryPackage.ASSET_INFO__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case NotaryPackage.ASSET_INFO__ASSET_IDENTIFIER:
				setAssetIdentifier((String)newValue);
				return;
			case NotaryPackage.ASSET_INFO__DOCUMENTATION:
				getDocumentation().clear();
				getDocumentation().addAll((Collection<? extends DocumentationReference>)newValue);
				return;
			case NotaryPackage.ASSET_INFO__TRANSACTION_DESC:
				getTransactionDesc().clear();
				getTransactionDesc().addAll((Collection<? extends String>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NotaryPackage.ASSET_INFO__ASSET_TYPE_LABEL:
				setAssetTypeLabel(ASSET_TYPE_LABEL_EDEFAULT);
				return;
			case NotaryPackage.ASSET_INFO__LABEL:
				setLabel(LABEL_EDEFAULT);
				return;
			case NotaryPackage.ASSET_INFO__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case NotaryPackage.ASSET_INFO__ASSET_IDENTIFIER:
				setAssetIdentifier(ASSET_IDENTIFIER_EDEFAULT);
				return;
			case NotaryPackage.ASSET_INFO__DOCUMENTATION:
				getDocumentation().clear();
				return;
			case NotaryPackage.ASSET_INFO__TRANSACTION_DESC:
				getTransactionDesc().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NotaryPackage.ASSET_INFO__ASSET_TYPE_LABEL:
				return ASSET_TYPE_LABEL_EDEFAULT == null ? assetTypeLabel != null : !ASSET_TYPE_LABEL_EDEFAULT.equals(assetTypeLabel);
			case NotaryPackage.ASSET_INFO__LABEL:
				return LABEL_EDEFAULT == null ? label != null : !LABEL_EDEFAULT.equals(label);
			case NotaryPackage.ASSET_INFO__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case NotaryPackage.ASSET_INFO__ASSET_IDENTIFIER:
				return ASSET_IDENTIFIER_EDEFAULT == null ? assetIdentifier != null : !ASSET_IDENTIFIER_EDEFAULT.equals(assetIdentifier);
			case NotaryPackage.ASSET_INFO__DOCUMENTATION:
				return documentation != null && !documentation.isEmpty();
			case NotaryPackage.ASSET_INFO__TRANSACTION_DESC:
				return transactionDesc != null && !transactionDesc.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (assetTypeLabel: ");
		result.append(assetTypeLabel);
		result.append(", label: ");
		result.append(label);
		result.append(", description: ");
		result.append(description);
		result.append(", assetIdentifier: ");
		result.append(assetIdentifier);
		result.append(", transactionDesc: ");
		result.append(transactionDesc);
		result.append(')');
		return result.toString();
	}

} //AssetInfoImpl
