/**
 */
package org.gecko.notary.model.notary.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.gecko.notary.model.notary.Asset;
import org.gecko.notary.model.notary.AssetChangeType;
import org.gecko.notary.model.notary.AssetTransactionEntry;
import org.gecko.notary.model.notary.NotaryPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Asset Transaction Entry</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetTransactionEntryImpl#getAsset <em>Asset</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetTransactionEntryImpl#getChangeType <em>Change Type</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetTransactionEntryImpl#getParentAssetId <em>Parent Asset Id</em>}</li>
 *   <li>{@link org.gecko.notary.model.notary.impl.AssetTransactionEntryImpl#getChangeData <em>Change Data</em>}</li>
 * </ul>
 *
 * @generated
 */
public class AssetTransactionEntryImpl extends TransactionEntryImpl implements AssetTransactionEntry {
	/**
	 * The cached value of the '{@link #getAsset() <em>Asset</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAsset()
	 * @generated
	 * @ordered
	 */
	protected Asset asset;

	/**
	 * The default value of the '{@link #getChangeType() <em>Change Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChangeType()
	 * @generated
	 * @ordered
	 */
	protected static final AssetChangeType CHANGE_TYPE_EDEFAULT = AssetChangeType.UNKNOWN;

	/**
	 * The cached value of the '{@link #getChangeType() <em>Change Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChangeType()
	 * @generated
	 * @ordered
	 */
	protected AssetChangeType changeType = CHANGE_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getParentAssetId() <em>Parent Asset Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParentAssetId()
	 * @generated
	 * @ordered
	 */
	protected static final String PARENT_ASSET_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getParentAssetId() <em>Parent Asset Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParentAssetId()
	 * @generated
	 * @ordered
	 */
	protected String parentAssetId = PARENT_ASSET_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getChangeData() <em>Change Data</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChangeData()
	 * @generated
	 * @ordered
	 */
	protected static final String CHANGE_DATA_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getChangeData() <em>Change Data</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChangeData()
	 * @generated
	 * @ordered
	 */
	protected String changeData = CHANGE_DATA_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AssetTransactionEntryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NotaryPackage.Literals.ASSET_TRANSACTION_ENTRY;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Asset getAsset() {
		return asset;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAsset(Asset newAsset, NotificationChain msgs) {
		Asset oldAsset = asset;
		asset = newAsset;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, NotaryPackage.ASSET_TRANSACTION_ENTRY__ASSET, oldAsset, newAsset);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAsset(Asset newAsset) {
		if (newAsset != asset) {
			NotificationChain msgs = null;
			if (asset != null)
				msgs = ((InternalEObject)asset).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - NotaryPackage.ASSET_TRANSACTION_ENTRY__ASSET, null, msgs);
			if (newAsset != null)
				msgs = ((InternalEObject)newAsset).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - NotaryPackage.ASSET_TRANSACTION_ENTRY__ASSET, null, msgs);
			msgs = basicSetAsset(newAsset, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotaryPackage.ASSET_TRANSACTION_ENTRY__ASSET, newAsset, newAsset));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AssetChangeType getChangeType() {
		return changeType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setChangeType(AssetChangeType newChangeType) {
		AssetChangeType oldChangeType = changeType;
		changeType = newChangeType == null ? CHANGE_TYPE_EDEFAULT : newChangeType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotaryPackage.ASSET_TRANSACTION_ENTRY__CHANGE_TYPE, oldChangeType, changeType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getParentAssetId() {
		return parentAssetId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAssetId(String newParentAssetId) {
		String oldParentAssetId = parentAssetId;
		parentAssetId = newParentAssetId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotaryPackage.ASSET_TRANSACTION_ENTRY__PARENT_ASSET_ID, oldParentAssetId, parentAssetId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getChangeData() {
		return changeData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setChangeData(String newChangeData) {
		String oldChangeData = changeData;
		changeData = newChangeData;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, NotaryPackage.ASSET_TRANSACTION_ENTRY__CHANGE_DATA, oldChangeData, changeData));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case NotaryPackage.ASSET_TRANSACTION_ENTRY__ASSET:
				return basicSetAsset(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NotaryPackage.ASSET_TRANSACTION_ENTRY__ASSET:
				return getAsset();
			case NotaryPackage.ASSET_TRANSACTION_ENTRY__CHANGE_TYPE:
				return getChangeType();
			case NotaryPackage.ASSET_TRANSACTION_ENTRY__PARENT_ASSET_ID:
				return getParentAssetId();
			case NotaryPackage.ASSET_TRANSACTION_ENTRY__CHANGE_DATA:
				return getChangeData();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NotaryPackage.ASSET_TRANSACTION_ENTRY__ASSET:
				setAsset((Asset)newValue);
				return;
			case NotaryPackage.ASSET_TRANSACTION_ENTRY__CHANGE_TYPE:
				setChangeType((AssetChangeType)newValue);
				return;
			case NotaryPackage.ASSET_TRANSACTION_ENTRY__PARENT_ASSET_ID:
				setParentAssetId((String)newValue);
				return;
			case NotaryPackage.ASSET_TRANSACTION_ENTRY__CHANGE_DATA:
				setChangeData((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NotaryPackage.ASSET_TRANSACTION_ENTRY__ASSET:
				setAsset((Asset)null);
				return;
			case NotaryPackage.ASSET_TRANSACTION_ENTRY__CHANGE_TYPE:
				setChangeType(CHANGE_TYPE_EDEFAULT);
				return;
			case NotaryPackage.ASSET_TRANSACTION_ENTRY__PARENT_ASSET_ID:
				setParentAssetId(PARENT_ASSET_ID_EDEFAULT);
				return;
			case NotaryPackage.ASSET_TRANSACTION_ENTRY__CHANGE_DATA:
				setChangeData(CHANGE_DATA_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NotaryPackage.ASSET_TRANSACTION_ENTRY__ASSET:
				return asset != null;
			case NotaryPackage.ASSET_TRANSACTION_ENTRY__CHANGE_TYPE:
				return changeType != CHANGE_TYPE_EDEFAULT;
			case NotaryPackage.ASSET_TRANSACTION_ENTRY__PARENT_ASSET_ID:
				return PARENT_ASSET_ID_EDEFAULT == null ? parentAssetId != null : !PARENT_ASSET_ID_EDEFAULT.equals(parentAssetId);
			case NotaryPackage.ASSET_TRANSACTION_ENTRY__CHANGE_DATA:
				return CHANGE_DATA_EDEFAULT == null ? changeData != null : !CHANGE_DATA_EDEFAULT.equals(changeData);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (changeType: ");
		result.append(changeType);
		result.append(", parentAssetId: ");
		result.append(parentAssetId);
		result.append(", changeData: ");
		result.append(changeData);
		result.append(')');
		return result.toString();
	}

} //AssetTransactionEntryImpl
