/**
 */
package org.gecko.notary.model.notary.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.gecko.notary.model.notary.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class NotaryFactoryImpl extends EFactoryImpl implements NotaryFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static NotaryFactory init() {
		try {
			NotaryFactory theNotaryFactory = (NotaryFactory)EPackage.Registry.INSTANCE.getEFactory(NotaryPackage.eNS_URI);
			if (theNotaryFactory != null) {
				return theNotaryFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new NotaryFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotaryFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case NotaryPackage.PARTICIPANT: return createParticipant();
			case NotaryPackage.PARTICIPANT_DEFINITION: return createParticipantDefinition();
			case NotaryPackage.ADDRESS: return createAddress();
			case NotaryPackage.CONTACT: return createContact();
			case NotaryPackage.TRANSACTION: return createTransaction();
			case NotaryPackage.TRANSACTION_NOTIFICATION: return createTransactionNotification();
			case NotaryPackage.TRANSACTION_ENTRY: return createTransactionEntry();
			case NotaryPackage.ASSET_TRANSACTION_ENTRY: return createAssetTransactionEntry();
			case NotaryPackage.ASSET: return createAsset();
			case NotaryPackage.ASSET_LOG: return createAssetLog();
			case NotaryPackage.NOTIFICATION: return createNotification();
			case NotaryPackage.NOTIFICATION_LOG: return createNotificationLog();
			case NotaryPackage.PARENT_ASSET_ENTRY: return createParentAssetEntry();
			case NotaryPackage.ASSET_TRANSACTION: return createAssetTransaction();
			case NotaryPackage.ASSET_INFO: return createAssetInfo();
			case NotaryPackage.DOCUMENTATION_REFERENCE: return createDocumentationReference();
			case NotaryPackage.FEEDBACK_TRANSACTION: return createFeedbackTransaction();
			case NotaryPackage.FEEDBACK: return createFeedback();
			case NotaryPackage.FEEDBACK_RESULT: return createFeedbackResult();
			case NotaryPackage.FEEDBACK_RESULT_ITEM: return createFeedbackResultItem();
			case NotaryPackage.BOOLEAN_FEEDBACK_ITEM: return createBooleanFeedbackItem();
			case NotaryPackage.TEXT_FEEDBACK_ITEM: return createTextFeedbackItem();
			case NotaryPackage.SCORE_FEEDBACK_ITEM: return createScoreFeedbackItem();
			case NotaryPackage.OPTION_FEEDBACK_ITEM: return createOptionFeedbackItem();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case NotaryPackage.CONTACT_TYPE:
				return createContactTypeFromString(eDataType, initialValue);
			case NotaryPackage.TRANSACTION_TYPE:
				return createTransactionTypeFromString(eDataType, initialValue);
			case NotaryPackage.ASSET_CHANGE_TYPE:
				return createAssetChangeTypeFromString(eDataType, initialValue);
			case NotaryPackage.DOCUMENTATION_TYPE:
				return createDocumentationTypeFromString(eDataType, initialValue);
			case NotaryPackage.FEEDBACK_TYPE:
				return createFeedbackTypeFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case NotaryPackage.CONTACT_TYPE:
				return convertContactTypeToString(eDataType, instanceValue);
			case NotaryPackage.TRANSACTION_TYPE:
				return convertTransactionTypeToString(eDataType, instanceValue);
			case NotaryPackage.ASSET_CHANGE_TYPE:
				return convertAssetChangeTypeToString(eDataType, instanceValue);
			case NotaryPackage.DOCUMENTATION_TYPE:
				return convertDocumentationTypeToString(eDataType, instanceValue);
			case NotaryPackage.FEEDBACK_TYPE:
				return convertFeedbackTypeToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Participant createParticipant() {
		ParticipantImpl participant = new ParticipantImpl();
		return participant;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ParticipantDefinition createParticipantDefinition() {
		ParticipantDefinitionImpl participantDefinition = new ParticipantDefinitionImpl();
		return participantDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Address createAddress() {
		AddressImpl address = new AddressImpl();
		return address;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Contact createContact() {
		ContactImpl contact = new ContactImpl();
		return contact;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Transaction createTransaction() {
		TransactionImpl transaction = new TransactionImpl();
		return transaction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TransactionNotification createTransactionNotification() {
		TransactionNotificationImpl transactionNotification = new TransactionNotificationImpl();
		return transactionNotification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TransactionEntry createTransactionEntry() {
		TransactionEntryImpl transactionEntry = new TransactionEntryImpl();
		return transactionEntry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AssetTransactionEntry createAssetTransactionEntry() {
		AssetTransactionEntryImpl assetTransactionEntry = new AssetTransactionEntryImpl();
		return assetTransactionEntry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Asset createAsset() {
		AssetImpl asset = new AssetImpl();
		return asset;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AssetLog createAssetLog() {
		AssetLogImpl assetLog = new AssetLogImpl();
		return assetLog;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Notification createNotification() {
		NotificationImpl notification = new NotificationImpl();
		return notification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationLog createNotificationLog() {
		NotificationLogImpl notificationLog = new NotificationLogImpl();
		return notificationLog;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ParentAssetEntry createParentAssetEntry() {
		ParentAssetEntryImpl parentAssetEntry = new ParentAssetEntryImpl();
		return parentAssetEntry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AssetTransaction createAssetTransaction() {
		AssetTransactionImpl assetTransaction = new AssetTransactionImpl();
		return assetTransaction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AssetInfo createAssetInfo() {
		AssetInfoImpl assetInfo = new AssetInfoImpl();
		return assetInfo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DocumentationReference createDocumentationReference() {
		DocumentationReferenceImpl documentationReference = new DocumentationReferenceImpl();
		return documentationReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FeedbackTransaction createFeedbackTransaction() {
		FeedbackTransactionImpl feedbackTransaction = new FeedbackTransactionImpl();
		return feedbackTransaction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Feedback createFeedback() {
		FeedbackImpl feedback = new FeedbackImpl();
		return feedback;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FeedbackResult createFeedbackResult() {
		FeedbackResultImpl feedbackResult = new FeedbackResultImpl();
		return feedbackResult;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FeedbackResultItem createFeedbackResultItem() {
		FeedbackResultItemImpl feedbackResultItem = new FeedbackResultItemImpl();
		return feedbackResultItem;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public BooleanFeedbackItem createBooleanFeedbackItem() {
		BooleanFeedbackItemImpl booleanFeedbackItem = new BooleanFeedbackItemImpl();
		return booleanFeedbackItem;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TextFeedbackItem createTextFeedbackItem() {
		TextFeedbackItemImpl textFeedbackItem = new TextFeedbackItemImpl();
		return textFeedbackItem;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ScoreFeedbackItem createScoreFeedbackItem() {
		ScoreFeedbackItemImpl scoreFeedbackItem = new ScoreFeedbackItemImpl();
		return scoreFeedbackItem;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public OptionFeedbackItem createOptionFeedbackItem() {
		OptionFeedbackItemImpl optionFeedbackItem = new OptionFeedbackItemImpl();
		return optionFeedbackItem;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ContactType createContactTypeFromString(EDataType eDataType, String initialValue) {
		ContactType result = ContactType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertContactTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TransactionType createTransactionTypeFromString(EDataType eDataType, String initialValue) {
		TransactionType result = TransactionType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertTransactionTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AssetChangeType createAssetChangeTypeFromString(EDataType eDataType, String initialValue) {
		AssetChangeType result = AssetChangeType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertAssetChangeTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DocumentationType createDocumentationTypeFromString(EDataType eDataType, String initialValue) {
		DocumentationType result = DocumentationType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertDocumentationTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FeedbackType createFeedbackTypeFromString(EDataType eDataType, String initialValue) {
		FeedbackType result = FeedbackType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertFeedbackTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotaryPackage getNotaryPackage() {
		return (NotaryPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static NotaryPackage getPackage() {
		return NotaryPackage.eINSTANCE;
	}

} //NotaryFactoryImpl
