/**
 * Copyright (c) 2012 - 2023 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.search;

/**
 * Interface to get informed when indexing
 * @param <T> the business object
 * @author Mark Hoffmann
 * @since 08.03.2023
 */
public interface IndexListener{
	
	/**
	 * Returns <code>true</code>, if this context object can be handled, otherwise <code>false</code>
	 * @param context the context object
	 * @return <code>true</code>, if this context object can be handled, otherwise <code>false</code>
	 */
	boolean canHandle(IndexContextObject<?> context);
	
	/**
	 * Called on indexing
	 * @param context the {@link IndexContextObject}
	 */
	void onIndex(IndexContextObject<?> context);

}
