package de.jena.vdv454.mqtt;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.gecko.emf.json.constants.EMFJs;
import org.gecko.osgi.messaging.MessagingService;
import org.osgi.service.component.ComponentServiceObjects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

import de.jena.vdv454.mqtt.api.MqttService;

@Component
public class MqttServiceImpl implements MqttService {

	@Reference(target = "(id=test)")
	MessagingService messaging;

	
	@Reference
	ComponentServiceObjects<ResourceSet> resourceSetService;

	@Activate
	public void activate() {

	}

	public void deactivate() {

	}

	/* 
	 * (non-Javadoc)
	 * @see de.jena.vdv545.mqtt.MqttService#publish(java.lang.String, org.eclipse.emf.ecore.EObject)
	 */
	@Override
	public void publish(String service,EObject e) {
	
		ResourceSet set = resourceSetService.getService();
		try {
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			Resource resource = set.createResource(URI.createFileURI("temp.json"),"application/xml+vdv454");
			resource.getContents().add(e);
			resource.save(baos, Collections.singletonMap(EMFJs.OPTION_SERIALIZE_DEFAULT_VALUE, true));
	
		
			messaging.publish(service,ByteBuffer.wrap(baos.toByteArray()));
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		finally{
			resourceSetService.ungetService(set);
		}
	}

}
