package de.jena.vdv545.services;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.gecko.emf.rest.annotations.RessourceOverwriteContentType;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.promise.PromiseFactory;

import de.jena.VDV453Incl454V2017c.AUSNachrichtType;
import de.jena.VDV453Incl454V2017c.AboAUSType;
import de.jena.VDV453Incl454V2017c.AboAnfrageType;
import de.jena.VDV453Incl454V2017c.AboAntwortType;
import de.jena.VDV453Incl454V2017c.BestaetigungType;
import de.jena.VDV453Incl454V2017c.DatenAbrufenAnfrageType;
import de.jena.VDV453Incl454V2017c.DatenAbrufenAntwortType;
import de.jena.VDV453Incl454V2017c.DocumentRoot;
import de.jena.VDV453Incl454V2017c.ErgebnisType;
import de.jena.VDV453Incl454V2017c.IstFahrtType;
import de.jena.VDV453Incl454V2017c.IstUmlaufType;
import de.jena.VDV453Incl454V2017c.StatusAnfrageType;
import de.jena.VDV453Incl454V2017c.StatusAntwortType;
import de.jena.VDV453Incl454V2017c.StatusType;
import de.jena.VDV453Incl454V2017c.VDV453Incl454V2017cFactory;
import de.jena.VDV453Incl454V2017c.VDV453Incl454V2017cPackage;
import de.jena.vdv454.mqtt.api.MqttService;
import de.jena.vdv454.service.handler.api.VDVService;
import de.jena.vdv454.service.handler.api.VDVServiceConstants;
import de.jena.vdv454.service.handler.api.annotation.AusServiceConfig;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyReader;


@Component(immediate = true)
public class AusServiceImpl implements VDVService {

	
	/** VDVSERVICE_454_UMLAUF */
	private static final String VDVSERVICE_454_UMLAUF = "VDVSERVICE/454/umlauf/";
	/** VDVSERVICE_454_FAHRT */
	private static final String VDVSERVICE_454_FAHRT = "VDVSERVICE/454/fahrt/";
	/** ABOVERWALTEN_XML */
	private static final String ABOVERWALTEN_XML = "aboverwalten.xml";
	/** APPLICATION_XML_VDV454 */
	private static final String APPLICATION_XML_VDV454 = "application/xml+vdv454";
	public static final Logger LOGGER = Logger.getLogger(VDVService.class.getName());
	public static final String SERVICENAME = "aus";
	
	private PromiseFactory promFact = new PromiseFactory(Executors.newSingleThreadExecutor());
	private ScheduledExecutorService scheduledExecutorService  = Executors.newSingleThreadScheduledExecutor();
	private EObject data = null;
	private AusServiceConfig ausConfig;
	
	
	@Reference
	ResourceSet rs;
	
	@Reference 
	jakarta.ws.rs.client.ClientBuilder clientBuilder;
	

	@Reference(target = "(osgi.jakartars.name=EMFEObjectMessagebodyReaderWriter)")
	MessageBodyReader<EObject> bodyreader ;
	
	@Reference
	VDV453Incl454V2017cPackage ePackage;
	
	@Reference
	EventAdmin eventAdmin;
	
	@Reference 
	ConfigurationAdmin confAdmin;
	
	@Reference
	MqttService mqtt;
	
	private Client client;
	private Annotation[] annotations = new Annotation[1];


	public AusServiceImpl() {
		annotations[0] = new RessourceOverwriteContentType() {
			public String value() { return APPLICATION_XML_VDV454;}

			@Override
			public Class<? extends Annotation> annotationType() {
				return RessourceOverwriteContentType.class;
			};
		};
	}
	
	
	@Activate
	public void activate(BundleContext bctx, AusServiceConfig config) throws IOException {
		client = clientBuilder.register(bodyreader).build();
		ausConfig = config;
		
		scheduledExecutorService.scheduleAtFixedRate(()->{
			
			this.subscribe(ausConfig.protocol()+
					"://"+
					ausConfig.host()+":"+
					ausConfig.port()+"/"+
					ausConfig.operatorId()+"/"+
					SERVICENAME+'/'+
					VDVServiceConstants.REQUEST_ABO_MANAGEMENT);
						
		}, 0, 1, TimeUnit.DAYS);
		
	}
	public void deactivate() {
		scheduledExecutorService.shutdown();
	}
	public void subscribe(String url) {
		
		
		Resource response = null;
		XMLGregorianCalendar validTo;
		XMLGregorianCalendar now;
		
		try {
			XMLGregorianCalendar now2 = getNow();
			javax.xml.datatype.Duration addOneDay = DatatypeFactory.newInstance().newDurationDayTime(true,1,0,0,0);
			now2.add(addOneDay);
			validTo = now2;
					//DatatypeFactory.newInstance().newXMLGregorianCalendar(2024,3,7,0,0,0,0,0);
			GregorianCalendar cal = new GregorianCalendar();
			cal.setTime(new Date());
			now = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
			
			AboAnfrageType aboRequest =  VDV453Incl454V2017cFactory.eINSTANCE.createAboAnfrageType();
			AboAUSType aboAus =  VDV453Incl454V2017cFactory.eINSTANCE.createAboAUSType();
			DocumentRoot root = VDV453Incl454V2017cFactory.eINSTANCE.createDocumentRoot();
			
			
			aboAus.setAboID(new BigInteger(ausConfig.aboId()));
			aboAus.setVerfallZst(validTo);
			aboAus.setHysterese(BigInteger.valueOf(ausConfig.hystereseInSecounds()));
			aboAus.setVorschauzeit(BigInteger.valueOf(ausConfig.previewTimeInMinutes())); // Vorschauzeit in Minuten
			aboRequest.setZst(now);
			aboRequest.setSender(ausConfig.operatorId());
			aboRequest.getAboAUS().add(aboAus);

			
			root.setAboAnfrage(aboRequest);
			

				Entity<DocumentRoot> entity = Entity.entity(root, "application/xml");	
				Response post = client.target(url).request().post(entity);	
				System.out.println(post);
				
			
				try {
					
					DocumentRoot dr = post.readEntity(DocumentRoot.class, annotations );
					AboAntwortType aw = dr.getAboAntwort();
					
					if(aw!=null) {
						BestaetigungType bs =  aw.getBestaetigung();
						if(bs.getErgebnis().equals(ErgebnisType.OK)){
							System.out.println("Subscription accepted");
						}else {
							System.out.println("Subscription failed");
						}
					}
				}catch(Exception e) {
					LOGGER.warning(e.getCause().getLocalizedMessage());
				}

		} catch (DatatypeConfigurationException e) {
			// TODO Auto-generated catch block
			LOGGER.warning(e.getCause().getLocalizedMessage());
				
		}

	}
	/* 
	 * (non-Javadoc)
	 * @see de.jena.vdv545.serviceHandler.api.VDVService#canHandle(java.lang.String, java.lang.String)
	 */
	@Override
	public boolean canHandle(String servicename, String action) {
		
		if(servicename.equals(SERVICENAME)) return true;
		
		return false;
	}
	/* 
	 * (non-Javadoc)
	 * @see de.jena.vdv545.serviceHandler.api.VDVService#request(java.lang.String, java.lang.String, org.eclipse.emf.ecore.EObject)
	 */
	@Override
	public EObject request(String action, EObject e) {
		
		switch(action) {
		
		case VDVServiceConstants.REQUEST_READY:
			return handleDataRedyRequest(e);
		
		case VDVServiceConstants.REQUEST_STATUS:
			return handleAliveRequest(e);
			
		case VDVServiceConstants.REQUEST_RETRIVE:
			return data;
			
		case "datenabrufen":
			return data;
			
		default:
			return null;
		}
	
	}
	
	public Boolean retriveData() {
	
	
		DocumentRoot root = VDV453Incl454V2017cFactory.eINSTANCE.createDocumentRoot();
		DatenAbrufenAnfrageType datenAbrufenAnfrage = VDV453Incl454V2017cFactory.eINSTANCE.createDatenAbrufenAnfrageType();
		
		try {
			datenAbrufenAnfrage.setSender(ausConfig.operatorId());
			datenAbrufenAnfrage.setZst(getNow());
						
			root.setDatenAbrufenAnfrage(datenAbrufenAnfrage);
			Entity<DocumentRoot> entity = Entity.entity(root, "application/xml");	
			Response post = client.target(ausConfig.protocol()+
					"://"+
					ausConfig.host()+":"+
					ausConfig.port()+"/"+
					ausConfig.operatorId()+"/"+
					SERVICENAME+"/"+
					VDVServiceConstants.REQUEST_RETRIVE
					
					).request().post(entity);	

			DocumentRoot dr = post.readEntity(DocumentRoot.class, annotations );
			DatenAbrufenAntwortType inner_ans = dr.getDatenAbrufenAntwort();
			
			mqtt.publish("longEntryTest", inner_ans);
			EList<AUSNachrichtType> aus_msgs = inner_ans.getAUSNachricht();
			
			if(aus_msgs!= null) {
				data = inner_ans;
				
				aus_msgs.forEach(ausn->{
					
					Collection<IstFahrtType> istFahrtList =  EcoreUtil.copyAll(ausn.getIstFahrt());
					istFahrtList.forEach(istFahrt->{
							String linie = istFahrt.getLinienID();
							mqtt.publish(VDVSERVICE_454_FAHRT+linie, istFahrt);
					});
					Collection<IstUmlaufType> istUmlfList = EcoreUtil.copyAll(ausn.getIstUmlauf());
					istUmlfList.forEach(istUmlf->{
						String umlid = istUmlf.getUmlaufID();
						mqtt.publish(VDVSERVICE_454_UMLAUF+umlid, istUmlf);
					});
				});
			}

		} catch (DatatypeConfigurationException e) {
			LOGGER.warning(e.getCause().getLocalizedMessage());
		} 
		
		
		return false;
	}
	
	private EObject handleDataRedyRequest(EObject e) {
		
			XMLGregorianCalendar now;
			try {
			GregorianCalendar cal = new GregorianCalendar();
			cal.setTime(new Date());
			now = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
		
			DatenAbrufenAntwortType daat = VDV453Incl454V2017cFactory.eINSTANCE.createDatenAbrufenAntwortType();
			BestaetigungType bst = VDV453Incl454V2017cFactory.eINSTANCE.createBestaetigungType();
			bst.setErgebnis(ErgebnisType.OK);
			bst.setZst(now);
			
			daat.setBestaetigung(bst);
			
			promFact.submit(this::retriveData).onFailure(AusServiceImpl::error);
			
			
			return daat;
			
			} catch (DatatypeConfigurationException e1) {
				// TODO Auto-generated catch block
				LOGGER.warning(e1.getCause().getLocalizedMessage());
				return null;
			}
		
	}
	
	private EObject handleAliveRequest(EObject e) {
		if(e.getClass() != DocumentRoot.class) return null;
		DocumentRoot dr = (DocumentRoot) e;
		StatusAnfrageType req = dr.getStatusAnfrage();
		if(req == null) return null;
		
		StatusAntwortType ans = VDV453Incl454V2017cFactory.eINSTANCE.createStatusAntwortType();
		StatusType status = VDV453Incl454V2017cFactory.eINSTANCE.createStatusType();

		status.setErgebnis(ErgebnisType.OK);
		try {
			status.setZst(getNow());
		} catch (DatatypeConfigurationException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
			return null;
		}
		ans.setStatus(status);
		return ans;	
	}

	private XMLGregorianCalendar getNow() throws DatatypeConfigurationException {
		XMLGregorianCalendar now;
		GregorianCalendar cal = new GregorianCalendar();
		cal.setTime(new Date());
		return now = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
	}
	
	
	private static void error(Throwable t) {
		LOGGER.warning(t.getCause().getLocalizedMessage());
	}
	/* 
	 * (non-Javadoc)
	 * @see de.jena.vdv545.serviceHandler.api.VDVService#getData()
	 */
	@Override
	public EObject getData() {
		// TODO Auto-generated method stub
		return data;
	}
	
	
}
