/*
 * Decompiled with CFR 0.152.
 */
package proguard.retrace;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import proguard.classfile.util.ClassUtil;
import proguard.retrace.FrameInfo;

public class FramePattern {
    private static final String REGEX_CLASS = "(?:[^\\s\":./()]+\\.)*[^\\s\":./()]+";
    private static final String REGEX_CLASS_SLASH = "(?:[^\\s\":./()]+/)*[^\\s\":./()]+";
    private static final String REGEX_SOURCE_FILE = "[^:()]*";
    private static final String REGEX_LINE_NUMBER = "-?\\b\\d+\\b";
    private static final String REGEX_TYPE = "(?:[^\\s\":./()]+\\.)*[^\\s\":./()]+(?:\\[\\])*";
    private static final String REGEX_MEMBER = "<?[^\\s\":./()]+>?";
    private static final String REGEX_ARGUMENTS = "(?:(?:[^\\s\":./()]+\\.)*[^\\s\":./()]+(?:\\[\\])*(?:\\s*,\\s*(?:[^\\s\":./()]+\\.)*[^\\s\":./()]+(?:\\[\\])*)*)?";
    private final char[] expressionTypes = new char[32];
    private final int expressionTypeCount;
    private final Pattern pattern;
    private final boolean verbose;

    public FramePattern(String string, boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string.length() + 32);
        int n2 = 0;
        int n3 = 0;
        while ((n = string.indexOf(37, n3)) >= 0 && n != string.length() - 1 && n2 != this.expressionTypes.length) {
            stringBuffer.append(string.substring(n3, n));
            stringBuffer.append('(');
            char c = string.charAt(n + 1);
            switch (c) {
                case 'c': {
                    stringBuffer.append(REGEX_CLASS);
                    break;
                }
                case 'C': {
                    stringBuffer.append(REGEX_CLASS_SLASH);
                    break;
                }
                case 's': {
                    stringBuffer.append(REGEX_SOURCE_FILE);
                    break;
                }
                case 'l': {
                    stringBuffer.append(REGEX_LINE_NUMBER);
                    break;
                }
                case 't': {
                    stringBuffer.append(REGEX_TYPE);
                    break;
                }
                case 'f': {
                    stringBuffer.append(REGEX_MEMBER);
                    break;
                }
                case 'm': {
                    stringBuffer.append(REGEX_MEMBER);
                    break;
                }
                case 'a': {
                    stringBuffer.append(REGEX_ARGUMENTS);
                }
            }
            stringBuffer.append(')');
            this.expressionTypes[n2++] = c;
            n3 = n + 2;
        }
        stringBuffer.append(string.substring(n3));
        this.expressionTypeCount = n2;
        this.pattern = Pattern.compile(stringBuffer.toString());
        this.verbose = bl;
    }

    public FrameInfo parse(String string) {
        Matcher matcher = this.pattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = null;
        String string3 = null;
        int n = 0;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        block10: for (int i = 0; i < this.expressionTypeCount; ++i) {
            int n2 = matcher.start(i + 1);
            if (n2 < 0) continue;
            String string8 = matcher.group(i + 1);
            char c = this.expressionTypes[i];
            switch (c) {
                case 'c': {
                    string2 = string8;
                    continue block10;
                }
                case 'C': {
                    string2 = ClassUtil.externalClassName((String)string8);
                    continue block10;
                }
                case 's': {
                    string3 = string8;
                    continue block10;
                }
                case 'l': {
                    n = Integer.parseInt(string8);
                    continue block10;
                }
                case 't': {
                    string4 = string8;
                    continue block10;
                }
                case 'f': {
                    string5 = string8;
                    continue block10;
                }
                case 'm': {
                    string6 = string8;
                    continue block10;
                }
                case 'a': {
                    string7 = string8;
                }
            }
        }
        return new FrameInfo(string2, string3, n, string4, string5, string6, string7);
    }

    public String format(String string, FrameInfo frameInfo) {
        Matcher matcher = this.pattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < this.expressionTypeCount; ++i) {
            int n2 = matcher.start(i + 1);
            if (n2 < 0) continue;
            int n3 = matcher.end(i + 1);
            String string2 = matcher.group(i + 1);
            stringBuffer.append(string.substring(n, n2));
            char c = this.expressionTypes[i];
            switch (c) {
                case 'c': {
                    stringBuffer.append(frameInfo.getClassName());
                    break;
                }
                case 'C': {
                    stringBuffer.append(ClassUtil.internalClassName((String)frameInfo.getClassName()));
                    break;
                }
                case 's': {
                    stringBuffer.append(frameInfo.getSourceFile());
                    break;
                }
                case 'l': {
                    stringBuffer.append(frameInfo.getLineNumber());
                    break;
                }
                case 't': {
                    stringBuffer.append(frameInfo.getType());
                    break;
                }
                case 'f': {
                    if (this.verbose) {
                        stringBuffer.append(frameInfo.getType()).append(' ');
                    }
                    stringBuffer.append(frameInfo.getFieldName());
                    break;
                }
                case 'm': {
                    if (this.verbose) {
                        stringBuffer.append(frameInfo.getType()).append(' ');
                    }
                    stringBuffer.append(frameInfo.getMethodName());
                    if (!this.verbose) break;
                    stringBuffer.append('(').append(frameInfo.getArguments()).append(')');
                    break;
                }
                case 'a': {
                    stringBuffer.append(frameInfo.getArguments());
                }
            }
            n = n3;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }
}

