/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.eclipse.sensinact.mapping;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Feature Mapping</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.sensinact.mapping.FeatureMapping#getFunctionId <em>Function Id</em>}</li>
 *   <li>{@link org.eclipse.sensinact.mapping.FeatureMapping#getFeaturePath <em>Feature Path</em>}</li>
 * </ul>
 *
 * @see org.eclipse.sensinact.mapping.MappingPackage#getFeatureMapping()
 * @model
 * @generated
 */
@ProviderType
public interface FeatureMapping extends EObject {
	/**
	 * Returns the value of the '<em><b>Function Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Function Id</em>' attribute.
	 * @see #setFunctionId(String)
	 * @see org.eclipse.sensinact.mapping.MappingPackage#getFeatureMapping_FunctionId()
	 * @model
	 * @generated
	 */
	String getFunctionId();

	/**
	 * Sets the value of the '{@link org.eclipse.sensinact.mapping.FeatureMapping#getFunctionId <em>Function Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Function Id</em>' attribute.
	 * @see #getFunctionId()
	 * @generated
	 */
	void setFunctionId(String value);

	/**
	 * Returns the value of the '<em><b>Feature Path</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.emf.ecore.EStructuralFeature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Feature Path</em>' reference list.
	 * @see org.eclipse.sensinact.mapping.MappingPackage#getFeatureMapping_FeaturePath()
	 * @model
	 * @generated
	 */
	EList<EStructuralFeature> getFeaturePath();

} // FeatureMapping
