package org.gecko.emf.sensinact.model;

import java.util.HashMap;
import java.util.Map;

/**
 * Dient als "Telefonbuch", um Funktionsnamen (Strings) aus der XMI-Datei
 * auf ausführbare Java-Logik (Supplier oder Function) abzubilden.
 */
class FunctionRegistryImpl {
    private final Map<String, Object> registry = new HashMap<>();

    public <T> void registerFunction(String name, T function) {
        registry.put(name, function);
    }

    @SuppressWarnings("unchecked")
    public <T> T lookup(String name, Class<T> type) {
        Object function = registry.get(name);
        if (type.isInstance(function)) {
            return (T) function;
        }
        throw new IllegalArgumentException("Keine Funktion vom Typ " + type.getSimpleName() + " für den Namen '" + name + "' registriert.");
    }
}