/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude;

import org.eclipse.emf.ecore.EFactory;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage
 * @generated
 */
@ProviderType
public interface ClaudeChatCompletionFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ClaudeChatCompletionFactory eINSTANCE = org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Claude Request</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Claude Request</em>'.
	 * @generated
	 */
	ClaudeRequest createClaudeRequest();

	/**
	 * Returns a new object of class '<em>Usage</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Usage</em>'.
	 * @generated
	 */
	Usage createUsage();

	/**
	 * Returns a new object of class '<em>Claude Response</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Claude Response</em>'.
	 * @generated
	 */
	ClaudeResponse createClaudeResponse();

	/**
	 * Returns a new object of class '<em>System Prompt</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>System Prompt</em>'.
	 * @generated
	 */
	SystemPrompt createSystemPrompt();

	/**
	 * Returns a new object of class '<em>Message</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Message</em>'.
	 * @generated
	 */
	Message createMessage();

	/**
	 * Returns a new object of class '<em>Text Block</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Text Block</em>'.
	 * @generated
	 */
	TextBlock createTextBlock();

	/**
	 * Returns a new object of class '<em>Image Block</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Image Block</em>'.
	 * @generated
	 */
	ImageBlock createImageBlock();

	/**
	 * Returns a new object of class '<em>Base64 Image Source</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Base64 Image Source</em>'.
	 * @generated
	 */
	Base64ImageSource createBase64ImageSource();

	/**
	 * Returns a new object of class '<em>URL Image Source</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>URL Image Source</em>'.
	 * @generated
	 */
	URLImageSource createURLImageSource();

	/**
	 * Returns a new object of class '<em>Document Block</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Document Block</em>'.
	 * @generated
	 */
	DocumentBlock createDocumentBlock();

	/**
	 * Returns a new object of class '<em>Base64 Document Source</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Base64 Document Source</em>'.
	 * @generated
	 */
	Base64DocumentSource createBase64DocumentSource();

	/**
	 * Returns a new object of class '<em>Plain Text Document Source</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Plain Text Document Source</em>'.
	 * @generated
	 */
	PlainTextDocumentSource createPlainTextDocumentSource();

	/**
	 * Returns a new object of class '<em>URL Document Source</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>URL Document Source</em>'.
	 * @generated
	 */
	URLDocumentSource createURLDocumentSource();

	/**
	 * Returns a new object of class '<em>Tool Use Block</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Tool Use Block</em>'.
	 * @generated
	 */
	ToolUseBlock createToolUseBlock();

	/**
	 * Returns a new object of class '<em>MCP Tool Use Block</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MCP Tool Use Block</em>'.
	 * @generated
	 */
	MCPToolUseBlock createMCPToolUseBlock();

	/**
	 * Returns a new object of class '<em>Tool Result Block</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Tool Result Block</em>'.
	 * @generated
	 */
	ToolResultBlock createToolResultBlock();

	/**
	 * Returns a new object of class '<em>MCP Tool Result Block</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MCP Tool Result Block</em>'.
	 * @generated
	 */
	MCPToolResultBlock createMCPToolResultBlock();

	/**
	 * Returns a new object of class '<em>Tool</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Tool</em>'.
	 * @generated
	 */
	Tool createTool();

	/**
	 * Returns a new object of class '<em>MCP Server</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MCP Server</em>'.
	 * @generated
	 */
	MCPServer createMCPServer();

	/**
	 * Returns a new object of class '<em>MCP Tool Configuration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>MCP Tool Configuration</em>'.
	 * @generated
	 */
	MCPToolConfiguration createMCPToolConfiguration();

	/**
	 * Returns a new object of class '<em>Container</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Container</em>'.
	 * @generated
	 */
	Container createContainer();

	/**
	 * Returns a new object of class '<em>Skill</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Skill</em>'.
	 * @generated
	 */
	Skill createSkill();

	/**
	 * Returns a new object of class '<em>Context Management Config</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Context Management Config</em>'.
	 * @generated
	 */
	ContextManagementConfig createContextManagementConfig();

	/**
	 * Returns a new object of class '<em>Clear Tool Uses Edit</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clear Tool Uses Edit</em>'.
	 * @generated
	 */
	ClearToolUsesEdit createClearToolUsesEdit();

	/**
	 * Returns a new object of class '<em>Clear Thinking Edit</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clear Thinking Edit</em>'.
	 * @generated
	 */
	ClearThinkingEdit createClearThinkingEdit();

	/**
	 * Returns a new object of class '<em>Clear Trigger</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clear Trigger</em>'.
	 * @generated
	 */
	ClearTrigger createClearTrigger();

	/**
	 * Returns a new object of class '<em>Metadata</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Metadata</em>'.
	 * @generated
	 */
	Metadata createMetadata();

	/**
	 * Returns a new object of class '<em>Output Config</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Output Config</em>'.
	 * @generated
	 */
	OutputConfig createOutputConfig();

	/**
	 * Returns a new object of class '<em>Auto Tool Choice</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Auto Tool Choice</em>'.
	 * @generated
	 */
	AutoToolChoice createAutoToolChoice();

	/**
	 * Returns a new object of class '<em>Any Tool Choice</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Any Tool Choice</em>'.
	 * @generated
	 */
	AnyToolChoice createAnyToolChoice();

	/**
	 * Returns a new object of class '<em>Tool Tool Choice</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Tool Tool Choice</em>'.
	 * @generated
	 */
	ToolToolChoice createToolToolChoice();

	/**
	 * Returns a new object of class '<em>None Tool Choice</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>None Tool Choice</em>'.
	 * @generated
	 */
	NoneToolChoice createNoneToolChoice();

	/**
	 * Returns a new object of class '<em>Thinking Config</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Thinking Config</em>'.
	 * @generated
	 */
	ThinkingConfig createThinkingConfig();

	/**
	 * Returns a new object of class '<em>Output Format</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Output Format</em>'.
	 * @generated
	 */
	OutputFormat createOutputFormat();

	/**
	 * Returns a new object of class '<em>Cache Control</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cache Control</em>'.
	 * @generated
	 */
	CacheControl createCacheControl();

	/**
	 * Returns a new object of class '<em>Citations</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Citations</em>'.
	 * @generated
	 */
	Citations createCitations();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	ClaudeChatCompletionPackage getClaudeChatCompletionPackage();

} //ClaudeChatCompletionFactory
