/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionFactory
 * @model kind="package"
 *        annotation="Version value='1.0'"
 *        annotation="http://www.eclipse.org/emf/2002/GenModel complianceLevel='17.0' oSGiCompatible='true' basePackage='org.eclipse.fennec.ai.chat.completion.model' resource='XMI' copyrightText='Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n     Data In Motion - initial API and implementation'"
 * @generated
 */
@ProviderType
@EPackage(uri = ClaudeChatCompletionPackage.eNS_URI, genModel = "/model/claude-chat-completion.genmodel", genModelSourceLocations = {"model/claude-chat-completion.genmodel","org.eclipse.fennec.ai.chat.completion.claude.model/model/claude-chat-completion.genmodel"}, ecore="/model/claude-chat-completion.ecore", ecoreSourceLocations="/model/claude-chat-completion.ecore")
public interface ClaudeChatCompletionPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "claude";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://ai.fenne.eclipse.org/chatcompletion/claude/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "claudechatcompletion";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ClaudeChatCompletionPackage eINSTANCE = org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl <em>Claude Request</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getClaudeRequest()
	 * @generated
	 */
	int CLAUDE_REQUEST = 0;

	/**
	 * The feature id for the '<em><b>Model</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST__MODEL = 0;

	/**
	 * The feature id for the '<em><b>Max Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST__MAX_TOKENS = 1;

	/**
	 * The feature id for the '<em><b>Messages</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST__MESSAGES = 2;

	/**
	 * The feature id for the '<em><b>System</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST__SYSTEM = 3;

	/**
	 * The feature id for the '<em><b>Temperature</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST__TEMPERATURE = 4;

	/**
	 * The feature id for the '<em><b>Stop Sequences</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST__STOP_SEQUENCES = 5;

	/**
	 * The feature id for the '<em><b>Tools</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST__TOOLS = 6;

	/**
	 * The feature id for the '<em><b>Tool Choice</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST__TOOL_CHOICE = 7;

	/**
	 * The feature id for the '<em><b>Stream</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST__STREAM = 8;

	/**
	 * The feature id for the '<em><b>Thinking</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST__THINKING = 9;

	/**
	 * The feature id for the '<em><b>Output Format</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST__OUTPUT_FORMAT = 10;

	/**
	 * The feature id for the '<em><b>Service Tier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST__SERVICE_TIER = 11;

	/**
	 * The feature id for the '<em><b>Mcp Servers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST__MCP_SERVERS = 12;

	/**
	 * The feature id for the '<em><b>Container</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST__CONTAINER = 13;

	/**
	 * The feature id for the '<em><b>Context Management</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST__CONTEXT_MANAGEMENT = 14;

	/**
	 * The feature id for the '<em><b>Metadata</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST__METADATA = 15;

	/**
	 * The feature id for the '<em><b>Output Config</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST__OUTPUT_CONFIG = 16;

	/**
	 * The number of structural features of the '<em>Claude Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST_FEATURE_COUNT = 17;

	/**
	 * The number of operations of the '<em>Claude Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_REQUEST_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.UsageImpl <em>Usage</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.UsageImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getUsage()
	 * @generated
	 */
	int USAGE = 1;

	/**
	 * The feature id for the '<em><b>Input Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE__INPUT_TOKENS = 0;

	/**
	 * The feature id for the '<em><b>Output Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE__OUTPUT_TOKENS = 1;

	/**
	 * The feature id for the '<em><b>Cache Creation Input Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE__CACHE_CREATION_INPUT_TOKENS = 2;

	/**
	 * The feature id for the '<em><b>Cache Read Input Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE__CACHE_READ_INPUT_TOKENS = 3;

	/**
	 * The number of structural features of the '<em>Usage</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Usage</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USAGE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeResponseImpl <em>Claude Response</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeResponseImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getClaudeResponse()
	 * @generated
	 */
	int CLAUDE_RESPONSE = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_RESPONSE__ID = 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_RESPONSE__TYPE = 1;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_RESPONSE__ROLE = 2;

	/**
	 * The feature id for the '<em><b>Content</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_RESPONSE__CONTENT = 3;

	/**
	 * The feature id for the '<em><b>Model</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_RESPONSE__MODEL = 4;

	/**
	 * The feature id for the '<em><b>Stop Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_RESPONSE__STOP_REASON = 5;

	/**
	 * The feature id for the '<em><b>Stop Sequence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_RESPONSE__STOP_SEQUENCE = 6;

	/**
	 * The feature id for the '<em><b>Usage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_RESPONSE__USAGE = 7;

	/**
	 * The number of structural features of the '<em>Claude Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_RESPONSE_FEATURE_COUNT = 8;

	/**
	 * The number of operations of the '<em>Claude Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLAUDE_RESPONSE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.SystemPromptImpl <em>System Prompt</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.SystemPromptImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getSystemPrompt()
	 * @generated
	 */
	int SYSTEM_PROMPT = 3;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_PROMPT__TEXT = 0;

	/**
	 * The feature id for the '<em><b>Cache Control</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_PROMPT__CACHE_CONTROL = 1;

	/**
	 * The number of structural features of the '<em>System Prompt</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_PROMPT_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>System Prompt</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYSTEM_PROMPT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MessageImpl <em>Message</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.MessageImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getMessage()
	 * @generated
	 */
	int MESSAGE = 4;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__ROLE = 0;

	/**
	 * The feature id for the '<em><b>Content</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__CONTENT = 1;

	/**
	 * The number of structural features of the '<em>Message</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Message</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ContentBlockImpl <em>Content Block</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ContentBlockImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getContentBlock()
	 * @generated
	 */
	int CONTENT_BLOCK = 5;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_BLOCK__TYPE = 0;

	/**
	 * The number of structural features of the '<em>Content Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_BLOCK_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Content Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTENT_BLOCK_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.TextBlockImpl <em>Text Block</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.TextBlockImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getTextBlock()
	 * @generated
	 */
	int TEXT_BLOCK = 6;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_BLOCK__TYPE = CONTENT_BLOCK__TYPE;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_BLOCK__TEXT = CONTENT_BLOCK_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Cache Control</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_BLOCK__CACHE_CONTROL = CONTENT_BLOCK_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Citations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_BLOCK__CITATIONS = CONTENT_BLOCK_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Text Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_BLOCK_FEATURE_COUNT = CONTENT_BLOCK_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Text Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEXT_BLOCK_OPERATION_COUNT = CONTENT_BLOCK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ImageBlockImpl <em>Image Block</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ImageBlockImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getImageBlock()
	 * @generated
	 */
	int IMAGE_BLOCK = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_BLOCK__TYPE = CONTENT_BLOCK__TYPE;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_BLOCK__SOURCE = CONTENT_BLOCK_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Cache Control</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_BLOCK__CACHE_CONTROL = CONTENT_BLOCK_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Image Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_BLOCK_FEATURE_COUNT = CONTENT_BLOCK_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Image Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_BLOCK_OPERATION_COUNT = CONTENT_BLOCK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ImageSourceImpl <em>Image Source</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ImageSourceImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getImageSource()
	 * @generated
	 */
	int IMAGE_SOURCE = 8;

	/**
	 * The number of structural features of the '<em>Image Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_SOURCE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Image Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMAGE_SOURCE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.Base64ImageSourceImpl <em>Base64 Image Source</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.Base64ImageSourceImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getBase64ImageSource()
	 * @generated
	 */
	int BASE64_IMAGE_SOURCE = 9;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE64_IMAGE_SOURCE__TYPE = IMAGE_SOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Media Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE64_IMAGE_SOURCE__MEDIA_TYPE = IMAGE_SOURCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Data</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE64_IMAGE_SOURCE__DATA = IMAGE_SOURCE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Base64 Image Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE64_IMAGE_SOURCE_FEATURE_COUNT = IMAGE_SOURCE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Base64 Image Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE64_IMAGE_SOURCE_OPERATION_COUNT = IMAGE_SOURCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.URLImageSourceImpl <em>URL Image Source</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.URLImageSourceImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getURLImageSource()
	 * @generated
	 */
	int URL_IMAGE_SOURCE = 10;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URL_IMAGE_SOURCE__TYPE = IMAGE_SOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URL_IMAGE_SOURCE__URL = IMAGE_SOURCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>URL Image Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URL_IMAGE_SOURCE_FEATURE_COUNT = IMAGE_SOURCE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>URL Image Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URL_IMAGE_SOURCE_OPERATION_COUNT = IMAGE_SOURCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.DocumentBlockImpl <em>Document Block</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.DocumentBlockImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getDocumentBlock()
	 * @generated
	 */
	int DOCUMENT_BLOCK = 11;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_BLOCK__TYPE = CONTENT_BLOCK__TYPE;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_BLOCK__SOURCE = CONTENT_BLOCK_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_BLOCK__TITLE = CONTENT_BLOCK_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Context</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_BLOCK__CONTEXT = CONTENT_BLOCK_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Citations</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_BLOCK__CITATIONS = CONTENT_BLOCK_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Cache Control</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_BLOCK__CACHE_CONTROL = CONTENT_BLOCK_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Document Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_BLOCK_FEATURE_COUNT = CONTENT_BLOCK_FEATURE_COUNT + 5;

	/**
	 * The number of operations of the '<em>Document Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_BLOCK_OPERATION_COUNT = CONTENT_BLOCK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.DocumentSourceImpl <em>Document Source</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.DocumentSourceImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getDocumentSource()
	 * @generated
	 */
	int DOCUMENT_SOURCE = 12;

	/**
	 * The number of structural features of the '<em>Document Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_SOURCE_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Document Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_SOURCE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.Base64DocumentSourceImpl <em>Base64 Document Source</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.Base64DocumentSourceImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getBase64DocumentSource()
	 * @generated
	 */
	int BASE64_DOCUMENT_SOURCE = 13;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE64_DOCUMENT_SOURCE__TYPE = DOCUMENT_SOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Media Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE64_DOCUMENT_SOURCE__MEDIA_TYPE = DOCUMENT_SOURCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Data</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE64_DOCUMENT_SOURCE__DATA = DOCUMENT_SOURCE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Base64 Document Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE64_DOCUMENT_SOURCE_FEATURE_COUNT = DOCUMENT_SOURCE_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Base64 Document Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BASE64_DOCUMENT_SOURCE_OPERATION_COUNT = DOCUMENT_SOURCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.PlainTextDocumentSourceImpl <em>Plain Text Document Source</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.PlainTextDocumentSourceImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getPlainTextDocumentSource()
	 * @generated
	 */
	int PLAIN_TEXT_DOCUMENT_SOURCE = 14;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAIN_TEXT_DOCUMENT_SOURCE__TYPE = DOCUMENT_SOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAIN_TEXT_DOCUMENT_SOURCE__TEXT = DOCUMENT_SOURCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Plain Text Document Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAIN_TEXT_DOCUMENT_SOURCE_FEATURE_COUNT = DOCUMENT_SOURCE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Plain Text Document Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAIN_TEXT_DOCUMENT_SOURCE_OPERATION_COUNT = DOCUMENT_SOURCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.URLDocumentSourceImpl <em>URL Document Source</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.URLDocumentSourceImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getURLDocumentSource()
	 * @generated
	 */
	int URL_DOCUMENT_SOURCE = 15;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URL_DOCUMENT_SOURCE__TYPE = DOCUMENT_SOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URL_DOCUMENT_SOURCE__URL = DOCUMENT_SOURCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>URL Document Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URL_DOCUMENT_SOURCE_FEATURE_COUNT = DOCUMENT_SOURCE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>URL Document Source</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URL_DOCUMENT_SOURCE_OPERATION_COUNT = DOCUMENT_SOURCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolUseBlockImpl <em>Tool Use Block</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolUseBlockImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getToolUseBlock()
	 * @generated
	 */
	int TOOL_USE_BLOCK = 16;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_USE_BLOCK__TYPE = CONTENT_BLOCK__TYPE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_USE_BLOCK__ID = CONTENT_BLOCK_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_USE_BLOCK__NAME = CONTENT_BLOCK_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Input</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_USE_BLOCK__INPUT = CONTENT_BLOCK_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Caller</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_USE_BLOCK__CALLER = CONTENT_BLOCK_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Tool Use Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_USE_BLOCK_FEATURE_COUNT = CONTENT_BLOCK_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Tool Use Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_USE_BLOCK_OPERATION_COUNT = CONTENT_BLOCK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolUseBlockImpl <em>MCP Tool Use Block</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolUseBlockImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getMCPToolUseBlock()
	 * @generated
	 */
	int MCP_TOOL_USE_BLOCK = 17;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_USE_BLOCK__TYPE = CONTENT_BLOCK__TYPE;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_USE_BLOCK__ID = CONTENT_BLOCK_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_USE_BLOCK__NAME = CONTENT_BLOCK_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Server Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_USE_BLOCK__SERVER_NAME = CONTENT_BLOCK_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Input</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_USE_BLOCK__INPUT = CONTENT_BLOCK_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Caller</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_USE_BLOCK__CALLER = CONTENT_BLOCK_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Cache Control</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_USE_BLOCK__CACHE_CONTROL = CONTENT_BLOCK_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>MCP Tool Use Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_USE_BLOCK_FEATURE_COUNT = CONTENT_BLOCK_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>MCP Tool Use Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_USE_BLOCK_OPERATION_COUNT = CONTENT_BLOCK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolResultBlockImpl <em>Tool Result Block</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolResultBlockImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getToolResultBlock()
	 * @generated
	 */
	int TOOL_RESULT_BLOCK = 18;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_RESULT_BLOCK__TYPE = CONTENT_BLOCK__TYPE;

	/**
	 * The feature id for the '<em><b>Tool Use Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_RESULT_BLOCK__TOOL_USE_ID = CONTENT_BLOCK_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Content</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_RESULT_BLOCK__CONTENT = CONTENT_BLOCK_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Is Error</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_RESULT_BLOCK__IS_ERROR = CONTENT_BLOCK_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Tool Result Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_RESULT_BLOCK_FEATURE_COUNT = CONTENT_BLOCK_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Tool Result Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_RESULT_BLOCK_OPERATION_COUNT = CONTENT_BLOCK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolResultBlockImpl <em>MCP Tool Result Block</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolResultBlockImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getMCPToolResultBlock()
	 * @generated
	 */
	int MCP_TOOL_RESULT_BLOCK = 19;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_RESULT_BLOCK__TYPE = CONTENT_BLOCK__TYPE;

	/**
	 * The feature id for the '<em><b>Tool Use Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_RESULT_BLOCK__TOOL_USE_ID = CONTENT_BLOCK_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Content</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_RESULT_BLOCK__CONTENT = CONTENT_BLOCK_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Is Error</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_RESULT_BLOCK__IS_ERROR = CONTENT_BLOCK_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Cache Control</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_RESULT_BLOCK__CACHE_CONTROL = CONTENT_BLOCK_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>MCP Tool Result Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_RESULT_BLOCK_FEATURE_COUNT = CONTENT_BLOCK_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>MCP Tool Result Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_RESULT_BLOCK_OPERATION_COUNT = CONTENT_BLOCK_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolImpl <em>Tool</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getTool()
	 * @generated
	 */
	int TOOL = 20;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL__NAME = 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL__DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Input Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL__INPUT_SCHEMA = 2;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL__TYPE = 3;

	/**
	 * The feature id for the '<em><b>Allowed Callers</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL__ALLOWED_CALLERS = 4;

	/**
	 * The feature id for the '<em><b>Defer Loading</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL__DEFER_LOADING = 5;

	/**
	 * The number of structural features of the '<em>Tool</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>Tool</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPServerImpl <em>MCP Server</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPServerImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getMCPServer()
	 * @generated
	 */
	int MCP_SERVER = 21;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_SERVER__NAME = 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_SERVER__TYPE = 1;

	/**
	 * The feature id for the '<em><b>Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_SERVER__URL = 2;

	/**
	 * The feature id for the '<em><b>Authorization Token</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_SERVER__AUTHORIZATION_TOKEN = 3;

	/**
	 * The feature id for the '<em><b>Tool Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_SERVER__TOOL_CONFIGURATION = 4;

	/**
	 * The number of structural features of the '<em>MCP Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_SERVER_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>MCP Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_SERVER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolConfigurationImpl <em>MCP Tool Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolConfigurationImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getMCPToolConfiguration()
	 * @generated
	 */
	int MCP_TOOL_CONFIGURATION = 22;

	/**
	 * The feature id for the '<em><b>Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_CONFIGURATION__ENABLED = 0;

	/**
	 * The feature id for the '<em><b>Allowed Tools</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_CONFIGURATION__ALLOWED_TOOLS = 1;

	/**
	 * The number of structural features of the '<em>MCP Tool Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_CONFIGURATION_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>MCP Tool Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MCP_TOOL_CONFIGURATION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ContainerImpl <em>Container</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ContainerImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getContainer()
	 * @generated
	 */
	int CONTAINER = 23;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINER__ID = 0;

	/**
	 * The feature id for the '<em><b>Skills</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINER__SKILLS = 1;

	/**
	 * The number of structural features of the '<em>Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINER_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.SkillImpl <em>Skill</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.SkillImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getSkill()
	 * @generated
	 */
	int SKILL = 24;

	/**
	 * The feature id for the '<em><b>Skill Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SKILL__SKILL_ID = 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SKILL__TYPE = 1;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SKILL__VERSION = 2;

	/**
	 * The number of structural features of the '<em>Skill</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SKILL_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Skill</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SKILL_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ContextManagementConfigImpl <em>Context Management Config</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ContextManagementConfigImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getContextManagementConfig()
	 * @generated
	 */
	int CONTEXT_MANAGEMENT_CONFIG = 25;

	/**
	 * The feature id for the '<em><b>Edits</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_MANAGEMENT_CONFIG__EDITS = 0;

	/**
	 * The number of structural features of the '<em>Context Management Config</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_MANAGEMENT_CONFIG_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Context Management Config</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_MANAGEMENT_CONFIG_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ContextEditImpl <em>Context Edit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ContextEditImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getContextEdit()
	 * @generated
	 */
	int CONTEXT_EDIT = 26;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_EDIT__TYPE = 0;

	/**
	 * The number of structural features of the '<em>Context Edit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_EDIT_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Context Edit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_EDIT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearToolUsesEditImpl <em>Clear Tool Uses Edit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearToolUsesEditImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getClearToolUsesEdit()
	 * @generated
	 */
	int CLEAR_TOOL_USES_EDIT = 27;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_TOOL_USES_EDIT__TYPE = CONTEXT_EDIT__TYPE;

	/**
	 * The feature id for the '<em><b>Clear At Least</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_TOOL_USES_EDIT__CLEAR_AT_LEAST = CONTEXT_EDIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Clear Tool Inputs All</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_TOOL_USES_EDIT__CLEAR_TOOL_INPUTS_ALL = CONTEXT_EDIT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Clear Tool Inputs Specific</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_TOOL_USES_EDIT__CLEAR_TOOL_INPUTS_SPECIFIC = CONTEXT_EDIT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Exclude Tools</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_TOOL_USES_EDIT__EXCLUDE_TOOLS = CONTEXT_EDIT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Keep</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_TOOL_USES_EDIT__KEEP = CONTEXT_EDIT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Trigger</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_TOOL_USES_EDIT__TRIGGER = CONTEXT_EDIT_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Clear Tool Uses Edit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_TOOL_USES_EDIT_FEATURE_COUNT = CONTEXT_EDIT_FEATURE_COUNT + 6;

	/**
	 * The number of operations of the '<em>Clear Tool Uses Edit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_TOOL_USES_EDIT_OPERATION_COUNT = CONTEXT_EDIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearThinkingEditImpl <em>Clear Thinking Edit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearThinkingEditImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getClearThinkingEdit()
	 * @generated
	 */
	int CLEAR_THINKING_EDIT = 28;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_THINKING_EDIT__TYPE = CONTEXT_EDIT__TYPE;

	/**
	 * The feature id for the '<em><b>Keep Recent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_THINKING_EDIT__KEEP_RECENT = CONTEXT_EDIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Keep All</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_THINKING_EDIT__KEEP_ALL = CONTEXT_EDIT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Clear Thinking Edit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_THINKING_EDIT_FEATURE_COUNT = CONTEXT_EDIT_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Clear Thinking Edit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_THINKING_EDIT_OPERATION_COUNT = CONTEXT_EDIT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearTriggerImpl <em>Clear Trigger</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearTriggerImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getClearTrigger()
	 * @generated
	 */
	int CLEAR_TRIGGER = 29;

	/**
	 * The feature id for the '<em><b>Input Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_TRIGGER__INPUT_TOKENS = 0;

	/**
	 * The feature id for the '<em><b>Tool Uses Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_TRIGGER__TOOL_USES_COUNT = 1;

	/**
	 * The number of structural features of the '<em>Clear Trigger</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_TRIGGER_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Clear Trigger</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLEAR_TRIGGER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MetadataImpl <em>Metadata</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.MetadataImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getMetadata()
	 * @generated
	 */
	int METADATA = 30;

	/**
	 * The feature id for the '<em><b>User Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METADATA__USER_ID = 0;

	/**
	 * The number of structural features of the '<em>Metadata</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METADATA_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Metadata</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int METADATA_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.OutputConfigImpl <em>Output Config</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.OutputConfigImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getOutputConfig()
	 * @generated
	 */
	int OUTPUT_CONFIG = 31;

	/**
	 * The feature id for the '<em><b>Effort</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_CONFIG__EFFORT = 0;

	/**
	 * The number of structural features of the '<em>Output Config</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_CONFIG_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Output Config</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_CONFIG_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolChoiceImpl <em>Tool Choice</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolChoiceImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getToolChoice()
	 * @generated
	 */
	int TOOL_CHOICE = 32;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_CHOICE__TYPE = 0;

	/**
	 * The feature id for the '<em><b>Disable Parallel Tool Use</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_CHOICE__DISABLE_PARALLEL_TOOL_USE = 1;

	/**
	 * The number of structural features of the '<em>Tool Choice</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_CHOICE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Tool Choice</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_CHOICE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.AutoToolChoiceImpl <em>Auto Tool Choice</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.AutoToolChoiceImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getAutoToolChoice()
	 * @generated
	 */
	int AUTO_TOOL_CHOICE = 33;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUTO_TOOL_CHOICE__TYPE = TOOL_CHOICE__TYPE;

	/**
	 * The feature id for the '<em><b>Disable Parallel Tool Use</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUTO_TOOL_CHOICE__DISABLE_PARALLEL_TOOL_USE = TOOL_CHOICE__DISABLE_PARALLEL_TOOL_USE;

	/**
	 * The number of structural features of the '<em>Auto Tool Choice</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUTO_TOOL_CHOICE_FEATURE_COUNT = TOOL_CHOICE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Auto Tool Choice</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUTO_TOOL_CHOICE_OPERATION_COUNT = TOOL_CHOICE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.AnyToolChoiceImpl <em>Any Tool Choice</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.AnyToolChoiceImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getAnyToolChoice()
	 * @generated
	 */
	int ANY_TOOL_CHOICE = 34;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_TOOL_CHOICE__TYPE = TOOL_CHOICE__TYPE;

	/**
	 * The feature id for the '<em><b>Disable Parallel Tool Use</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_TOOL_CHOICE__DISABLE_PARALLEL_TOOL_USE = TOOL_CHOICE__DISABLE_PARALLEL_TOOL_USE;

	/**
	 * The number of structural features of the '<em>Any Tool Choice</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_TOOL_CHOICE_FEATURE_COUNT = TOOL_CHOICE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Any Tool Choice</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANY_TOOL_CHOICE_OPERATION_COUNT = TOOL_CHOICE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolToolChoiceImpl <em>Tool Tool Choice</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolToolChoiceImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getToolToolChoice()
	 * @generated
	 */
	int TOOL_TOOL_CHOICE = 35;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_TOOL_CHOICE__TYPE = TOOL_CHOICE__TYPE;

	/**
	 * The feature id for the '<em><b>Disable Parallel Tool Use</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_TOOL_CHOICE__DISABLE_PARALLEL_TOOL_USE = TOOL_CHOICE__DISABLE_PARALLEL_TOOL_USE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_TOOL_CHOICE__NAME = TOOL_CHOICE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Tool Tool Choice</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_TOOL_CHOICE_FEATURE_COUNT = TOOL_CHOICE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Tool Tool Choice</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOOL_TOOL_CHOICE_OPERATION_COUNT = TOOL_CHOICE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.NoneToolChoiceImpl <em>None Tool Choice</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.NoneToolChoiceImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getNoneToolChoice()
	 * @generated
	 */
	int NONE_TOOL_CHOICE = 36;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NONE_TOOL_CHOICE__TYPE = TOOL_CHOICE__TYPE;

	/**
	 * The feature id for the '<em><b>Disable Parallel Tool Use</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NONE_TOOL_CHOICE__DISABLE_PARALLEL_TOOL_USE = TOOL_CHOICE__DISABLE_PARALLEL_TOOL_USE;

	/**
	 * The number of structural features of the '<em>None Tool Choice</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NONE_TOOL_CHOICE_FEATURE_COUNT = TOOL_CHOICE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>None Tool Choice</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NONE_TOOL_CHOICE_OPERATION_COUNT = TOOL_CHOICE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ThinkingConfigImpl <em>Thinking Config</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ThinkingConfigImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getThinkingConfig()
	 * @generated
	 */
	int THINKING_CONFIG = 37;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THINKING_CONFIG__TYPE = 0;

	/**
	 * The feature id for the '<em><b>Budget Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THINKING_CONFIG__BUDGET_TOKENS = 1;

	/**
	 * The number of structural features of the '<em>Thinking Config</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THINKING_CONFIG_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Thinking Config</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THINKING_CONFIG_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.OutputFormatImpl <em>Output Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.OutputFormatImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getOutputFormat()
	 * @generated
	 */
	int OUTPUT_FORMAT = 38;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_FORMAT__TYPE = 0;

	/**
	 * The feature id for the '<em><b>Schema</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_FORMAT__SCHEMA = 1;

	/**
	 * The number of structural features of the '<em>Output Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_FORMAT_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Output Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OUTPUT_FORMAT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.CacheControlImpl <em>Cache Control</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.CacheControlImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getCacheControl()
	 * @generated
	 */
	int CACHE_CONTROL = 39;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_CONTROL__TYPE = 0;

	/**
	 * The feature id for the '<em><b>Ttl</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_CONTROL__TTL = 1;

	/**
	 * The number of structural features of the '<em>Cache Control</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_CONTROL_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Cache Control</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_CONTROL_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.CitationsImpl <em>Citations</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.CitationsImpl
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getCitations()
	 * @generated
	 */
	int CITATIONS = 40;

	/**
	 * The feature id for the '<em><b>Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CITATIONS__ENABLED = 0;

	/**
	 * The number of structural features of the '<em>Citations</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CITATIONS_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Citations</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CITATIONS_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Role <em>Role</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Role
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getRole()
	 * @generated
	 */
	int ROLE = 41;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ServiceTier <em>Service Tier</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ServiceTier
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getServiceTier()
	 * @generated
	 */
	int SERVICE_TIER = 42;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingType <em>Thinking Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingType
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getThinkingType()
	 * @generated
	 */
	int THINKING_TYPE = 43;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.SkillType <em>Skill Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.SkillType
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getSkillType()
	 * @generated
	 */
	int SKILL_TYPE = 44;

	/**
	 * The meta object id for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.EffortLevel <em>Effort Level</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.EffortLevel
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getEffortLevel()
	 * @generated
	 */
	int EFFORT_LEVEL = 45;


	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest <em>Claude Request</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Claude Request</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest
	 * @generated
	 */
	EClass getClaudeRequest();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getModel <em>Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Model</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getModel()
	 * @see #getClaudeRequest()
	 * @generated
	 */
	EAttribute getClaudeRequest_Model();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getMaxTokens <em>Max Tokens</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Max Tokens</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getMaxTokens()
	 * @see #getClaudeRequest()
	 * @generated
	 */
	EAttribute getClaudeRequest_MaxTokens();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getMessages <em>Messages</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Messages</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getMessages()
	 * @see #getClaudeRequest()
	 * @generated
	 */
	EReference getClaudeRequest_Messages();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getSystem <em>System</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>System</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getSystem()
	 * @see #getClaudeRequest()
	 * @generated
	 */
	EReference getClaudeRequest_System();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getTemperature <em>Temperature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Temperature</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getTemperature()
	 * @see #getClaudeRequest()
	 * @generated
	 */
	EAttribute getClaudeRequest_Temperature();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getStopSequences <em>Stop Sequences</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Stop Sequences</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getStopSequences()
	 * @see #getClaudeRequest()
	 * @generated
	 */
	EAttribute getClaudeRequest_StopSequences();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getTools <em>Tools</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Tools</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getTools()
	 * @see #getClaudeRequest()
	 * @generated
	 */
	EReference getClaudeRequest_Tools();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getToolChoice <em>Tool Choice</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Tool Choice</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getToolChoice()
	 * @see #getClaudeRequest()
	 * @generated
	 */
	EReference getClaudeRequest_ToolChoice();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#isStream <em>Stream</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Stream</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#isStream()
	 * @see #getClaudeRequest()
	 * @generated
	 */
	EAttribute getClaudeRequest_Stream();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getThinking <em>Thinking</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Thinking</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getThinking()
	 * @see #getClaudeRequest()
	 * @generated
	 */
	EReference getClaudeRequest_Thinking();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getOutputFormat <em>Output Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Output Format</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getOutputFormat()
	 * @see #getClaudeRequest()
	 * @generated
	 */
	EReference getClaudeRequest_OutputFormat();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getServiceTier <em>Service Tier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Service Tier</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getServiceTier()
	 * @see #getClaudeRequest()
	 * @generated
	 */
	EAttribute getClaudeRequest_ServiceTier();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getMcpServers <em>Mcp Servers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Mcp Servers</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getMcpServers()
	 * @see #getClaudeRequest()
	 * @generated
	 */
	EReference getClaudeRequest_McpServers();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getContainer <em>Container</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Container</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getContainer()
	 * @see #getClaudeRequest()
	 * @generated
	 */
	EReference getClaudeRequest_Container();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getContextManagement <em>Context Management</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Context Management</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getContextManagement()
	 * @see #getClaudeRequest()
	 * @generated
	 */
	EReference getClaudeRequest_ContextManagement();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getMetadata <em>Metadata</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Metadata</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getMetadata()
	 * @see #getClaudeRequest()
	 * @generated
	 */
	EReference getClaudeRequest_Metadata();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getOutputConfig <em>Output Config</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Output Config</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getOutputConfig()
	 * @see #getClaudeRequest()
	 * @generated
	 */
	EReference getClaudeRequest_OutputConfig();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Usage <em>Usage</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Usage</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Usage
	 * @generated
	 */
	EClass getUsage();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Usage#getInputTokens <em>Input Tokens</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Input Tokens</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Usage#getInputTokens()
	 * @see #getUsage()
	 * @generated
	 */
	EAttribute getUsage_InputTokens();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Usage#getOutputTokens <em>Output Tokens</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Output Tokens</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Usage#getOutputTokens()
	 * @see #getUsage()
	 * @generated
	 */
	EAttribute getUsage_OutputTokens();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Usage#getCacheCreationInputTokens <em>Cache Creation Input Tokens</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cache Creation Input Tokens</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Usage#getCacheCreationInputTokens()
	 * @see #getUsage()
	 * @generated
	 */
	EAttribute getUsage_CacheCreationInputTokens();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Usage#getCacheReadInputTokens <em>Cache Read Input Tokens</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cache Read Input Tokens</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Usage#getCacheReadInputTokens()
	 * @see #getUsage()
	 * @generated
	 */
	EAttribute getUsage_CacheReadInputTokens();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse <em>Claude Response</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Claude Response</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse
	 * @generated
	 */
	EClass getClaudeResponse();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getId()
	 * @see #getClaudeResponse()
	 * @generated
	 */
	EAttribute getClaudeResponse_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getType()
	 * @see #getClaudeResponse()
	 * @generated
	 */
	EAttribute getClaudeResponse_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getRole()
	 * @see #getClaudeResponse()
	 * @generated
	 */
	EAttribute getClaudeResponse_Role();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getContent <em>Content</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Content</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getContent()
	 * @see #getClaudeResponse()
	 * @generated
	 */
	EReference getClaudeResponse_Content();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getModel <em>Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Model</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getModel()
	 * @see #getClaudeResponse()
	 * @generated
	 */
	EAttribute getClaudeResponse_Model();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getStopReason <em>Stop Reason</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Stop Reason</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getStopReason()
	 * @see #getClaudeResponse()
	 * @generated
	 */
	EAttribute getClaudeResponse_StopReason();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getStopSequence <em>Stop Sequence</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Stop Sequence</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getStopSequence()
	 * @see #getClaudeResponse()
	 * @generated
	 */
	EAttribute getClaudeResponse_StopSequence();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getUsage <em>Usage</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Usage</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getUsage()
	 * @see #getClaudeResponse()
	 * @generated
	 */
	EReference getClaudeResponse_Usage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.SystemPrompt <em>System Prompt</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>System Prompt</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.SystemPrompt
	 * @generated
	 */
	EClass getSystemPrompt();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.SystemPrompt#getText <em>Text</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Text</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.SystemPrompt#getText()
	 * @see #getSystemPrompt()
	 * @generated
	 */
	EAttribute getSystemPrompt_Text();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.SystemPrompt#getCacheControl <em>Cache Control</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Cache Control</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.SystemPrompt#getCacheControl()
	 * @see #getSystemPrompt()
	 * @generated
	 */
	EReference getSystemPrompt_CacheControl();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Message <em>Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Message</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Message
	 * @generated
	 */
	EClass getMessage();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Message#getRole <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Role</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Message#getRole()
	 * @see #getMessage()
	 * @generated
	 */
	EAttribute getMessage_Role();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Message#getContent <em>Content</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Content</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Message#getContent()
	 * @see #getMessage()
	 * @generated
	 */
	EReference getMessage_Content();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ContentBlock <em>Content Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Content Block</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ContentBlock
	 * @generated
	 */
	EClass getContentBlock();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ContentBlock#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ContentBlock#getType()
	 * @see #getContentBlock()
	 * @generated
	 */
	EAttribute getContentBlock_Type();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.TextBlock <em>Text Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Text Block</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.TextBlock
	 * @generated
	 */
	EClass getTextBlock();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.TextBlock#getText <em>Text</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Text</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.TextBlock#getText()
	 * @see #getTextBlock()
	 * @generated
	 */
	EAttribute getTextBlock_Text();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.TextBlock#getCacheControl <em>Cache Control</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Cache Control</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.TextBlock#getCacheControl()
	 * @see #getTextBlock()
	 * @generated
	 */
	EReference getTextBlock_CacheControl();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.TextBlock#getCitations <em>Citations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Citations</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.TextBlock#getCitations()
	 * @see #getTextBlock()
	 * @generated
	 */
	EReference getTextBlock_Citations();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ImageBlock <em>Image Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Image Block</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ImageBlock
	 * @generated
	 */
	EClass getImageBlock();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ImageBlock#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Source</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ImageBlock#getSource()
	 * @see #getImageBlock()
	 * @generated
	 */
	EReference getImageBlock_Source();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ImageBlock#getCacheControl <em>Cache Control</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Cache Control</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ImageBlock#getCacheControl()
	 * @see #getImageBlock()
	 * @generated
	 */
	EReference getImageBlock_CacheControl();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ImageSource <em>Image Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Image Source</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ImageSource
	 * @generated
	 */
	EClass getImageSource();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Base64ImageSource <em>Base64 Image Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Base64 Image Source</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Base64ImageSource
	 * @generated
	 */
	EClass getBase64ImageSource();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Base64ImageSource#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Base64ImageSource#getType()
	 * @see #getBase64ImageSource()
	 * @generated
	 */
	EAttribute getBase64ImageSource_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Base64ImageSource#getMediaType <em>Media Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Media Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Base64ImageSource#getMediaType()
	 * @see #getBase64ImageSource()
	 * @generated
	 */
	EAttribute getBase64ImageSource_MediaType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Base64ImageSource#getData <em>Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Data</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Base64ImageSource#getData()
	 * @see #getBase64ImageSource()
	 * @generated
	 */
	EAttribute getBase64ImageSource_Data();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.URLImageSource <em>URL Image Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>URL Image Source</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.URLImageSource
	 * @generated
	 */
	EClass getURLImageSource();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.URLImageSource#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.URLImageSource#getType()
	 * @see #getURLImageSource()
	 * @generated
	 */
	EAttribute getURLImageSource_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.URLImageSource#getUrl <em>Url</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Url</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.URLImageSource#getUrl()
	 * @see #getURLImageSource()
	 * @generated
	 */
	EAttribute getURLImageSource_Url();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.DocumentBlock <em>Document Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Document Block</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.DocumentBlock
	 * @generated
	 */
	EClass getDocumentBlock();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.DocumentBlock#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Source</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.DocumentBlock#getSource()
	 * @see #getDocumentBlock()
	 * @generated
	 */
	EReference getDocumentBlock_Source();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.DocumentBlock#getTitle <em>Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Title</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.DocumentBlock#getTitle()
	 * @see #getDocumentBlock()
	 * @generated
	 */
	EAttribute getDocumentBlock_Title();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.DocumentBlock#getContext <em>Context</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Context</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.DocumentBlock#getContext()
	 * @see #getDocumentBlock()
	 * @generated
	 */
	EAttribute getDocumentBlock_Context();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.DocumentBlock#getCitations <em>Citations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Citations</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.DocumentBlock#getCitations()
	 * @see #getDocumentBlock()
	 * @generated
	 */
	EReference getDocumentBlock_Citations();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.DocumentBlock#getCacheControl <em>Cache Control</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Cache Control</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.DocumentBlock#getCacheControl()
	 * @see #getDocumentBlock()
	 * @generated
	 */
	EReference getDocumentBlock_CacheControl();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.DocumentSource <em>Document Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Document Source</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.DocumentSource
	 * @generated
	 */
	EClass getDocumentSource();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Base64DocumentSource <em>Base64 Document Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Base64 Document Source</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Base64DocumentSource
	 * @generated
	 */
	EClass getBase64DocumentSource();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Base64DocumentSource#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Base64DocumentSource#getType()
	 * @see #getBase64DocumentSource()
	 * @generated
	 */
	EAttribute getBase64DocumentSource_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Base64DocumentSource#getMediaType <em>Media Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Media Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Base64DocumentSource#getMediaType()
	 * @see #getBase64DocumentSource()
	 * @generated
	 */
	EAttribute getBase64DocumentSource_MediaType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Base64DocumentSource#getData <em>Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Data</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Base64DocumentSource#getData()
	 * @see #getBase64DocumentSource()
	 * @generated
	 */
	EAttribute getBase64DocumentSource_Data();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.PlainTextDocumentSource <em>Plain Text Document Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Plain Text Document Source</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.PlainTextDocumentSource
	 * @generated
	 */
	EClass getPlainTextDocumentSource();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.PlainTextDocumentSource#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.PlainTextDocumentSource#getType()
	 * @see #getPlainTextDocumentSource()
	 * @generated
	 */
	EAttribute getPlainTextDocumentSource_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.PlainTextDocumentSource#getText <em>Text</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Text</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.PlainTextDocumentSource#getText()
	 * @see #getPlainTextDocumentSource()
	 * @generated
	 */
	EAttribute getPlainTextDocumentSource_Text();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.URLDocumentSource <em>URL Document Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>URL Document Source</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.URLDocumentSource
	 * @generated
	 */
	EClass getURLDocumentSource();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.URLDocumentSource#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.URLDocumentSource#getType()
	 * @see #getURLDocumentSource()
	 * @generated
	 */
	EAttribute getURLDocumentSource_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.URLDocumentSource#getUrl <em>Url</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Url</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.URLDocumentSource#getUrl()
	 * @see #getURLDocumentSource()
	 * @generated
	 */
	EAttribute getURLDocumentSource_Url();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolUseBlock <em>Tool Use Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Tool Use Block</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ToolUseBlock
	 * @generated
	 */
	EClass getToolUseBlock();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolUseBlock#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ToolUseBlock#getId()
	 * @see #getToolUseBlock()
	 * @generated
	 */
	EAttribute getToolUseBlock_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolUseBlock#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ToolUseBlock#getName()
	 * @see #getToolUseBlock()
	 * @generated
	 */
	EAttribute getToolUseBlock_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolUseBlock#getInput <em>Input</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Input</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ToolUseBlock#getInput()
	 * @see #getToolUseBlock()
	 * @generated
	 */
	EAttribute getToolUseBlock_Input();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolUseBlock#getCaller <em>Caller</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Caller</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ToolUseBlock#getCaller()
	 * @see #getToolUseBlock()
	 * @generated
	 */
	EAttribute getToolUseBlock_Caller();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolUseBlock <em>MCP Tool Use Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>MCP Tool Use Block</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolUseBlock
	 * @generated
	 */
	EClass getMCPToolUseBlock();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolUseBlock#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolUseBlock#getId()
	 * @see #getMCPToolUseBlock()
	 * @generated
	 */
	EAttribute getMCPToolUseBlock_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolUseBlock#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolUseBlock#getName()
	 * @see #getMCPToolUseBlock()
	 * @generated
	 */
	EAttribute getMCPToolUseBlock_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolUseBlock#getServerName <em>Server Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Server Name</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolUseBlock#getServerName()
	 * @see #getMCPToolUseBlock()
	 * @generated
	 */
	EAttribute getMCPToolUseBlock_ServerName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolUseBlock#getInput <em>Input</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Input</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolUseBlock#getInput()
	 * @see #getMCPToolUseBlock()
	 * @generated
	 */
	EAttribute getMCPToolUseBlock_Input();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolUseBlock#getCaller <em>Caller</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Caller</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolUseBlock#getCaller()
	 * @see #getMCPToolUseBlock()
	 * @generated
	 */
	EAttribute getMCPToolUseBlock_Caller();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolUseBlock#getCacheControl <em>Cache Control</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Cache Control</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolUseBlock#getCacheControl()
	 * @see #getMCPToolUseBlock()
	 * @generated
	 */
	EReference getMCPToolUseBlock_CacheControl();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolResultBlock <em>Tool Result Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Tool Result Block</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ToolResultBlock
	 * @generated
	 */
	EClass getToolResultBlock();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolResultBlock#getToolUseId <em>Tool Use Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Tool Use Id</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ToolResultBlock#getToolUseId()
	 * @see #getToolResultBlock()
	 * @generated
	 */
	EAttribute getToolResultBlock_ToolUseId();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolResultBlock#getContent <em>Content</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Content</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ToolResultBlock#getContent()
	 * @see #getToolResultBlock()
	 * @generated
	 */
	EReference getToolResultBlock_Content();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolResultBlock#isIsError <em>Is Error</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Error</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ToolResultBlock#isIsError()
	 * @see #getToolResultBlock()
	 * @generated
	 */
	EAttribute getToolResultBlock_IsError();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolResultBlock <em>MCP Tool Result Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>MCP Tool Result Block</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolResultBlock
	 * @generated
	 */
	EClass getMCPToolResultBlock();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolResultBlock#getToolUseId <em>Tool Use Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Tool Use Id</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolResultBlock#getToolUseId()
	 * @see #getMCPToolResultBlock()
	 * @generated
	 */
	EAttribute getMCPToolResultBlock_ToolUseId();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolResultBlock#getContent <em>Content</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Content</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolResultBlock#getContent()
	 * @see #getMCPToolResultBlock()
	 * @generated
	 */
	EReference getMCPToolResultBlock_Content();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolResultBlock#isIsError <em>Is Error</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Error</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolResultBlock#isIsError()
	 * @see #getMCPToolResultBlock()
	 * @generated
	 */
	EAttribute getMCPToolResultBlock_IsError();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolResultBlock#getCacheControl <em>Cache Control</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Cache Control</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolResultBlock#getCacheControl()
	 * @see #getMCPToolResultBlock()
	 * @generated
	 */
	EReference getMCPToolResultBlock_CacheControl();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Tool <em>Tool</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Tool</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Tool
	 * @generated
	 */
	EClass getTool();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Tool#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Tool#getName()
	 * @see #getTool()
	 * @generated
	 */
	EAttribute getTool_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Tool#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Tool#getDescription()
	 * @see #getTool()
	 * @generated
	 */
	EAttribute getTool_Description();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Tool#getInputSchema <em>Input Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Input Schema</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Tool#getInputSchema()
	 * @see #getTool()
	 * @generated
	 */
	EAttribute getTool_InputSchema();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Tool#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Tool#getType()
	 * @see #getTool()
	 * @generated
	 */
	EAttribute getTool_Type();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Tool#getAllowedCallers <em>Allowed Callers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Allowed Callers</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Tool#getAllowedCallers()
	 * @see #getTool()
	 * @generated
	 */
	EAttribute getTool_AllowedCallers();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Tool#isDeferLoading <em>Defer Loading</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Defer Loading</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Tool#isDeferLoading()
	 * @see #getTool()
	 * @generated
	 */
	EAttribute getTool_DeferLoading();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPServer <em>MCP Server</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>MCP Server</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPServer
	 * @generated
	 */
	EClass getMCPServer();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPServer#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPServer#getName()
	 * @see #getMCPServer()
	 * @generated
	 */
	EAttribute getMCPServer_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPServer#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPServer#getType()
	 * @see #getMCPServer()
	 * @generated
	 */
	EAttribute getMCPServer_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPServer#getUrl <em>Url</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Url</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPServer#getUrl()
	 * @see #getMCPServer()
	 * @generated
	 */
	EAttribute getMCPServer_Url();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPServer#getAuthorizationToken <em>Authorization Token</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Authorization Token</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPServer#getAuthorizationToken()
	 * @see #getMCPServer()
	 * @generated
	 */
	EAttribute getMCPServer_AuthorizationToken();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPServer#getToolConfiguration <em>Tool Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Tool Configuration</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPServer#getToolConfiguration()
	 * @see #getMCPServer()
	 * @generated
	 */
	EReference getMCPServer_ToolConfiguration();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolConfiguration <em>MCP Tool Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>MCP Tool Configuration</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolConfiguration
	 * @generated
	 */
	EClass getMCPToolConfiguration();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolConfiguration#isEnabled <em>Enabled</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enabled</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolConfiguration#isEnabled()
	 * @see #getMCPToolConfiguration()
	 * @generated
	 */
	EAttribute getMCPToolConfiguration_Enabled();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolConfiguration#getAllowedTools <em>Allowed Tools</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Allowed Tools</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolConfiguration#getAllowedTools()
	 * @see #getMCPToolConfiguration()
	 * @generated
	 */
	EAttribute getMCPToolConfiguration_AllowedTools();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Container <em>Container</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Container</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Container
	 * @generated
	 */
	EClass getContainer();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Container#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Container#getId()
	 * @see #getContainer()
	 * @generated
	 */
	EAttribute getContainer_Id();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Container#getSkills <em>Skills</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Skills</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Container#getSkills()
	 * @see #getContainer()
	 * @generated
	 */
	EReference getContainer_Skills();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Skill <em>Skill</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Skill</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Skill
	 * @generated
	 */
	EClass getSkill();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Skill#getSkillId <em>Skill Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Skill Id</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Skill#getSkillId()
	 * @see #getSkill()
	 * @generated
	 */
	EAttribute getSkill_SkillId();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Skill#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Skill#getType()
	 * @see #getSkill()
	 * @generated
	 */
	EAttribute getSkill_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Skill#getVersion <em>Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Version</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Skill#getVersion()
	 * @see #getSkill()
	 * @generated
	 */
	EAttribute getSkill_Version();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ContextManagementConfig <em>Context Management Config</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Context Management Config</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ContextManagementConfig
	 * @generated
	 */
	EClass getContextManagementConfig();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ContextManagementConfig#getEdits <em>Edits</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Edits</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ContextManagementConfig#getEdits()
	 * @see #getContextManagementConfig()
	 * @generated
	 */
	EReference getContextManagementConfig_Edits();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ContextEdit <em>Context Edit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Context Edit</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ContextEdit
	 * @generated
	 */
	EClass getContextEdit();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ContextEdit#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ContextEdit#getType()
	 * @see #getContextEdit()
	 * @generated
	 */
	EAttribute getContextEdit_Type();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit <em>Clear Tool Uses Edit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Clear Tool Uses Edit</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit
	 * @generated
	 */
	EClass getClearToolUsesEdit();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#getClearAtLeast <em>Clear At Least</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Clear At Least</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#getClearAtLeast()
	 * @see #getClearToolUsesEdit()
	 * @generated
	 */
	EAttribute getClearToolUsesEdit_ClearAtLeast();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#isClearToolInputsAll <em>Clear Tool Inputs All</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Clear Tool Inputs All</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#isClearToolInputsAll()
	 * @see #getClearToolUsesEdit()
	 * @generated
	 */
	EAttribute getClearToolUsesEdit_ClearToolInputsAll();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#getClearToolInputsSpecific <em>Clear Tool Inputs Specific</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Clear Tool Inputs Specific</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#getClearToolInputsSpecific()
	 * @see #getClearToolUsesEdit()
	 * @generated
	 */
	EAttribute getClearToolUsesEdit_ClearToolInputsSpecific();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#getExcludeTools <em>Exclude Tools</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Exclude Tools</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#getExcludeTools()
	 * @see #getClearToolUsesEdit()
	 * @generated
	 */
	EAttribute getClearToolUsesEdit_ExcludeTools();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#getKeep <em>Keep</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Keep</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#getKeep()
	 * @see #getClearToolUsesEdit()
	 * @generated
	 */
	EAttribute getClearToolUsesEdit_Keep();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#getTrigger <em>Trigger</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Trigger</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#getTrigger()
	 * @see #getClearToolUsesEdit()
	 * @generated
	 */
	EReference getClearToolUsesEdit_Trigger();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearThinkingEdit <em>Clear Thinking Edit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Clear Thinking Edit</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClearThinkingEdit
	 * @generated
	 */
	EClass getClearThinkingEdit();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearThinkingEdit#getKeepRecent <em>Keep Recent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Keep Recent</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClearThinkingEdit#getKeepRecent()
	 * @see #getClearThinkingEdit()
	 * @generated
	 */
	EAttribute getClearThinkingEdit_KeepRecent();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearThinkingEdit#isKeepAll <em>Keep All</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Keep All</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClearThinkingEdit#isKeepAll()
	 * @see #getClearThinkingEdit()
	 * @generated
	 */
	EAttribute getClearThinkingEdit_KeepAll();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearTrigger <em>Clear Trigger</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Clear Trigger</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClearTrigger
	 * @generated
	 */
	EClass getClearTrigger();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearTrigger#getInputTokens <em>Input Tokens</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Input Tokens</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClearTrigger#getInputTokens()
	 * @see #getClearTrigger()
	 * @generated
	 */
	EAttribute getClearTrigger_InputTokens();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearTrigger#getToolUsesCount <em>Tool Uses Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Tool Uses Count</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClearTrigger#getToolUsesCount()
	 * @see #getClearTrigger()
	 * @generated
	 */
	EAttribute getClearTrigger_ToolUsesCount();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Metadata <em>Metadata</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Metadata</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Metadata
	 * @generated
	 */
	EClass getMetadata();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Metadata#getUserId <em>User Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>User Id</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Metadata#getUserId()
	 * @see #getMetadata()
	 * @generated
	 */
	EAttribute getMetadata_UserId();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.OutputConfig <em>Output Config</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Output Config</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.OutputConfig
	 * @generated
	 */
	EClass getOutputConfig();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.OutputConfig#getEffort <em>Effort</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Effort</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.OutputConfig#getEffort()
	 * @see #getOutputConfig()
	 * @generated
	 */
	EAttribute getOutputConfig_Effort();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolChoice <em>Tool Choice</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Tool Choice</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ToolChoice
	 * @generated
	 */
	EClass getToolChoice();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolChoice#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ToolChoice#getType()
	 * @see #getToolChoice()
	 * @generated
	 */
	EAttribute getToolChoice_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolChoice#isDisableParallelToolUse <em>Disable Parallel Tool Use</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Disable Parallel Tool Use</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ToolChoice#isDisableParallelToolUse()
	 * @see #getToolChoice()
	 * @generated
	 */
	EAttribute getToolChoice_DisableParallelToolUse();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.AutoToolChoice <em>Auto Tool Choice</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Auto Tool Choice</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.AutoToolChoice
	 * @generated
	 */
	EClass getAutoToolChoice();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.AnyToolChoice <em>Any Tool Choice</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Any Tool Choice</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.AnyToolChoice
	 * @generated
	 */
	EClass getAnyToolChoice();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolToolChoice <em>Tool Tool Choice</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Tool Tool Choice</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ToolToolChoice
	 * @generated
	 */
	EClass getToolToolChoice();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolToolChoice#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ToolToolChoice#getName()
	 * @see #getToolToolChoice()
	 * @generated
	 */
	EAttribute getToolToolChoice_Name();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.NoneToolChoice <em>None Tool Choice</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>None Tool Choice</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.NoneToolChoice
	 * @generated
	 */
	EClass getNoneToolChoice();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingConfig <em>Thinking Config</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Thinking Config</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingConfig
	 * @generated
	 */
	EClass getThinkingConfig();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingConfig#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingConfig#getType()
	 * @see #getThinkingConfig()
	 * @generated
	 */
	EAttribute getThinkingConfig_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingConfig#getBudgetTokens <em>Budget Tokens</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Budget Tokens</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingConfig#getBudgetTokens()
	 * @see #getThinkingConfig()
	 * @generated
	 */
	EAttribute getThinkingConfig_BudgetTokens();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.OutputFormat <em>Output Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Output Format</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.OutputFormat
	 * @generated
	 */
	EClass getOutputFormat();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.OutputFormat#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.OutputFormat#getType()
	 * @see #getOutputFormat()
	 * @generated
	 */
	EAttribute getOutputFormat_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.OutputFormat#getSchema <em>Schema</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Schema</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.OutputFormat#getSchema()
	 * @see #getOutputFormat()
	 * @generated
	 */
	EAttribute getOutputFormat_Schema();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.CacheControl <em>Cache Control</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Cache Control</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.CacheControl
	 * @generated
	 */
	EClass getCacheControl();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.CacheControl#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.CacheControl#getType()
	 * @see #getCacheControl()
	 * @generated
	 */
	EAttribute getCacheControl_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.CacheControl#getTtl <em>Ttl</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ttl</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.CacheControl#getTtl()
	 * @see #getCacheControl()
	 * @generated
	 */
	EAttribute getCacheControl_Ttl();

	/**
	 * Returns the meta object for class '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Citations <em>Citations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Citations</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Citations
	 * @generated
	 */
	EClass getCitations();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Citations#isEnabled <em>Enabled</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enabled</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Citations#isEnabled()
	 * @see #getCitations()
	 * @generated
	 */
	EAttribute getCitations_Enabled();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Role <em>Role</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Role</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Role
	 * @generated
	 */
	EEnum getRole();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ServiceTier <em>Service Tier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Service Tier</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ServiceTier
	 * @generated
	 */
	EEnum getServiceTier();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingType <em>Thinking Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Thinking Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingType
	 * @generated
	 */
	EEnum getThinkingType();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.fennec.ai.chat.completion.model.claude.SkillType <em>Skill Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Skill Type</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.SkillType
	 * @generated
	 */
	EEnum getSkillType();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.fennec.ai.chat.completion.model.claude.EffortLevel <em>Effort Level</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Effort Level</em>'.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.EffortLevel
	 * @generated
	 */
	EEnum getEffortLevel();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ClaudeChatCompletionFactory getClaudeChatCompletionFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl <em>Claude Request</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getClaudeRequest()
		 * @generated
		 */
		EClass CLAUDE_REQUEST = eINSTANCE.getClaudeRequest();

		/**
		 * The meta object literal for the '<em><b>Model</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLAUDE_REQUEST__MODEL = eINSTANCE.getClaudeRequest_Model();

		/**
		 * The meta object literal for the '<em><b>Max Tokens</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLAUDE_REQUEST__MAX_TOKENS = eINSTANCE.getClaudeRequest_MaxTokens();

		/**
		 * The meta object literal for the '<em><b>Messages</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLAUDE_REQUEST__MESSAGES = eINSTANCE.getClaudeRequest_Messages();

		/**
		 * The meta object literal for the '<em><b>System</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLAUDE_REQUEST__SYSTEM = eINSTANCE.getClaudeRequest_System();

		/**
		 * The meta object literal for the '<em><b>Temperature</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLAUDE_REQUEST__TEMPERATURE = eINSTANCE.getClaudeRequest_Temperature();

		/**
		 * The meta object literal for the '<em><b>Stop Sequences</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLAUDE_REQUEST__STOP_SEQUENCES = eINSTANCE.getClaudeRequest_StopSequences();

		/**
		 * The meta object literal for the '<em><b>Tools</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLAUDE_REQUEST__TOOLS = eINSTANCE.getClaudeRequest_Tools();

		/**
		 * The meta object literal for the '<em><b>Tool Choice</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLAUDE_REQUEST__TOOL_CHOICE = eINSTANCE.getClaudeRequest_ToolChoice();

		/**
		 * The meta object literal for the '<em><b>Stream</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLAUDE_REQUEST__STREAM = eINSTANCE.getClaudeRequest_Stream();

		/**
		 * The meta object literal for the '<em><b>Thinking</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLAUDE_REQUEST__THINKING = eINSTANCE.getClaudeRequest_Thinking();

		/**
		 * The meta object literal for the '<em><b>Output Format</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLAUDE_REQUEST__OUTPUT_FORMAT = eINSTANCE.getClaudeRequest_OutputFormat();

		/**
		 * The meta object literal for the '<em><b>Service Tier</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLAUDE_REQUEST__SERVICE_TIER = eINSTANCE.getClaudeRequest_ServiceTier();

		/**
		 * The meta object literal for the '<em><b>Mcp Servers</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLAUDE_REQUEST__MCP_SERVERS = eINSTANCE.getClaudeRequest_McpServers();

		/**
		 * The meta object literal for the '<em><b>Container</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLAUDE_REQUEST__CONTAINER = eINSTANCE.getClaudeRequest_Container();

		/**
		 * The meta object literal for the '<em><b>Context Management</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLAUDE_REQUEST__CONTEXT_MANAGEMENT = eINSTANCE.getClaudeRequest_ContextManagement();

		/**
		 * The meta object literal for the '<em><b>Metadata</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLAUDE_REQUEST__METADATA = eINSTANCE.getClaudeRequest_Metadata();

		/**
		 * The meta object literal for the '<em><b>Output Config</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLAUDE_REQUEST__OUTPUT_CONFIG = eINSTANCE.getClaudeRequest_OutputConfig();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.UsageImpl <em>Usage</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.UsageImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getUsage()
		 * @generated
		 */
		EClass USAGE = eINSTANCE.getUsage();

		/**
		 * The meta object literal for the '<em><b>Input Tokens</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USAGE__INPUT_TOKENS = eINSTANCE.getUsage_InputTokens();

		/**
		 * The meta object literal for the '<em><b>Output Tokens</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USAGE__OUTPUT_TOKENS = eINSTANCE.getUsage_OutputTokens();

		/**
		 * The meta object literal for the '<em><b>Cache Creation Input Tokens</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USAGE__CACHE_CREATION_INPUT_TOKENS = eINSTANCE.getUsage_CacheCreationInputTokens();

		/**
		 * The meta object literal for the '<em><b>Cache Read Input Tokens</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute USAGE__CACHE_READ_INPUT_TOKENS = eINSTANCE.getUsage_CacheReadInputTokens();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeResponseImpl <em>Claude Response</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeResponseImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getClaudeResponse()
		 * @generated
		 */
		EClass CLAUDE_RESPONSE = eINSTANCE.getClaudeResponse();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLAUDE_RESPONSE__ID = eINSTANCE.getClaudeResponse_Id();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLAUDE_RESPONSE__TYPE = eINSTANCE.getClaudeResponse_Type();

		/**
		 * The meta object literal for the '<em><b>Role</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLAUDE_RESPONSE__ROLE = eINSTANCE.getClaudeResponse_Role();

		/**
		 * The meta object literal for the '<em><b>Content</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLAUDE_RESPONSE__CONTENT = eINSTANCE.getClaudeResponse_Content();

		/**
		 * The meta object literal for the '<em><b>Model</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLAUDE_RESPONSE__MODEL = eINSTANCE.getClaudeResponse_Model();

		/**
		 * The meta object literal for the '<em><b>Stop Reason</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLAUDE_RESPONSE__STOP_REASON = eINSTANCE.getClaudeResponse_StopReason();

		/**
		 * The meta object literal for the '<em><b>Stop Sequence</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLAUDE_RESPONSE__STOP_SEQUENCE = eINSTANCE.getClaudeResponse_StopSequence();

		/**
		 * The meta object literal for the '<em><b>Usage</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLAUDE_RESPONSE__USAGE = eINSTANCE.getClaudeResponse_Usage();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.SystemPromptImpl <em>System Prompt</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.SystemPromptImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getSystemPrompt()
		 * @generated
		 */
		EClass SYSTEM_PROMPT = eINSTANCE.getSystemPrompt();

		/**
		 * The meta object literal for the '<em><b>Text</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SYSTEM_PROMPT__TEXT = eINSTANCE.getSystemPrompt_Text();

		/**
		 * The meta object literal for the '<em><b>Cache Control</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SYSTEM_PROMPT__CACHE_CONTROL = eINSTANCE.getSystemPrompt_CacheControl();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MessageImpl <em>Message</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.MessageImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getMessage()
		 * @generated
		 */
		EClass MESSAGE = eINSTANCE.getMessage();

		/**
		 * The meta object literal for the '<em><b>Role</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MESSAGE__ROLE = eINSTANCE.getMessage_Role();

		/**
		 * The meta object literal for the '<em><b>Content</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MESSAGE__CONTENT = eINSTANCE.getMessage_Content();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ContentBlockImpl <em>Content Block</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ContentBlockImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getContentBlock()
		 * @generated
		 */
		EClass CONTENT_BLOCK = eINSTANCE.getContentBlock();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTENT_BLOCK__TYPE = eINSTANCE.getContentBlock_Type();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.TextBlockImpl <em>Text Block</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.TextBlockImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getTextBlock()
		 * @generated
		 */
		EClass TEXT_BLOCK = eINSTANCE.getTextBlock();

		/**
		 * The meta object literal for the '<em><b>Text</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEXT_BLOCK__TEXT = eINSTANCE.getTextBlock_Text();

		/**
		 * The meta object literal for the '<em><b>Cache Control</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEXT_BLOCK__CACHE_CONTROL = eINSTANCE.getTextBlock_CacheControl();

		/**
		 * The meta object literal for the '<em><b>Citations</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TEXT_BLOCK__CITATIONS = eINSTANCE.getTextBlock_Citations();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ImageBlockImpl <em>Image Block</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ImageBlockImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getImageBlock()
		 * @generated
		 */
		EClass IMAGE_BLOCK = eINSTANCE.getImageBlock();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IMAGE_BLOCK__SOURCE = eINSTANCE.getImageBlock_Source();

		/**
		 * The meta object literal for the '<em><b>Cache Control</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IMAGE_BLOCK__CACHE_CONTROL = eINSTANCE.getImageBlock_CacheControl();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ImageSourceImpl <em>Image Source</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ImageSourceImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getImageSource()
		 * @generated
		 */
		EClass IMAGE_SOURCE = eINSTANCE.getImageSource();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.Base64ImageSourceImpl <em>Base64 Image Source</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.Base64ImageSourceImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getBase64ImageSource()
		 * @generated
		 */
		EClass BASE64_IMAGE_SOURCE = eINSTANCE.getBase64ImageSource();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BASE64_IMAGE_SOURCE__TYPE = eINSTANCE.getBase64ImageSource_Type();

		/**
		 * The meta object literal for the '<em><b>Media Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BASE64_IMAGE_SOURCE__MEDIA_TYPE = eINSTANCE.getBase64ImageSource_MediaType();

		/**
		 * The meta object literal for the '<em><b>Data</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BASE64_IMAGE_SOURCE__DATA = eINSTANCE.getBase64ImageSource_Data();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.URLImageSourceImpl <em>URL Image Source</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.URLImageSourceImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getURLImageSource()
		 * @generated
		 */
		EClass URL_IMAGE_SOURCE = eINSTANCE.getURLImageSource();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute URL_IMAGE_SOURCE__TYPE = eINSTANCE.getURLImageSource_Type();

		/**
		 * The meta object literal for the '<em><b>Url</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute URL_IMAGE_SOURCE__URL = eINSTANCE.getURLImageSource_Url();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.DocumentBlockImpl <em>Document Block</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.DocumentBlockImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getDocumentBlock()
		 * @generated
		 */
		EClass DOCUMENT_BLOCK = eINSTANCE.getDocumentBlock();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DOCUMENT_BLOCK__SOURCE = eINSTANCE.getDocumentBlock_Source();

		/**
		 * The meta object literal for the '<em><b>Title</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DOCUMENT_BLOCK__TITLE = eINSTANCE.getDocumentBlock_Title();

		/**
		 * The meta object literal for the '<em><b>Context</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DOCUMENT_BLOCK__CONTEXT = eINSTANCE.getDocumentBlock_Context();

		/**
		 * The meta object literal for the '<em><b>Citations</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DOCUMENT_BLOCK__CITATIONS = eINSTANCE.getDocumentBlock_Citations();

		/**
		 * The meta object literal for the '<em><b>Cache Control</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DOCUMENT_BLOCK__CACHE_CONTROL = eINSTANCE.getDocumentBlock_CacheControl();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.DocumentSourceImpl <em>Document Source</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.DocumentSourceImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getDocumentSource()
		 * @generated
		 */
		EClass DOCUMENT_SOURCE = eINSTANCE.getDocumentSource();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.Base64DocumentSourceImpl <em>Base64 Document Source</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.Base64DocumentSourceImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getBase64DocumentSource()
		 * @generated
		 */
		EClass BASE64_DOCUMENT_SOURCE = eINSTANCE.getBase64DocumentSource();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BASE64_DOCUMENT_SOURCE__TYPE = eINSTANCE.getBase64DocumentSource_Type();

		/**
		 * The meta object literal for the '<em><b>Media Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BASE64_DOCUMENT_SOURCE__MEDIA_TYPE = eINSTANCE.getBase64DocumentSource_MediaType();

		/**
		 * The meta object literal for the '<em><b>Data</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BASE64_DOCUMENT_SOURCE__DATA = eINSTANCE.getBase64DocumentSource_Data();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.PlainTextDocumentSourceImpl <em>Plain Text Document Source</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.PlainTextDocumentSourceImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getPlainTextDocumentSource()
		 * @generated
		 */
		EClass PLAIN_TEXT_DOCUMENT_SOURCE = eINSTANCE.getPlainTextDocumentSource();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAIN_TEXT_DOCUMENT_SOURCE__TYPE = eINSTANCE.getPlainTextDocumentSource_Type();

		/**
		 * The meta object literal for the '<em><b>Text</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PLAIN_TEXT_DOCUMENT_SOURCE__TEXT = eINSTANCE.getPlainTextDocumentSource_Text();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.URLDocumentSourceImpl <em>URL Document Source</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.URLDocumentSourceImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getURLDocumentSource()
		 * @generated
		 */
		EClass URL_DOCUMENT_SOURCE = eINSTANCE.getURLDocumentSource();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute URL_DOCUMENT_SOURCE__TYPE = eINSTANCE.getURLDocumentSource_Type();

		/**
		 * The meta object literal for the '<em><b>Url</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute URL_DOCUMENT_SOURCE__URL = eINSTANCE.getURLDocumentSource_Url();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolUseBlockImpl <em>Tool Use Block</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolUseBlockImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getToolUseBlock()
		 * @generated
		 */
		EClass TOOL_USE_BLOCK = eINSTANCE.getToolUseBlock();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TOOL_USE_BLOCK__ID = eINSTANCE.getToolUseBlock_Id();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TOOL_USE_BLOCK__NAME = eINSTANCE.getToolUseBlock_Name();

		/**
		 * The meta object literal for the '<em><b>Input</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TOOL_USE_BLOCK__INPUT = eINSTANCE.getToolUseBlock_Input();

		/**
		 * The meta object literal for the '<em><b>Caller</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TOOL_USE_BLOCK__CALLER = eINSTANCE.getToolUseBlock_Caller();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolUseBlockImpl <em>MCP Tool Use Block</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolUseBlockImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getMCPToolUseBlock()
		 * @generated
		 */
		EClass MCP_TOOL_USE_BLOCK = eINSTANCE.getMCPToolUseBlock();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MCP_TOOL_USE_BLOCK__ID = eINSTANCE.getMCPToolUseBlock_Id();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MCP_TOOL_USE_BLOCK__NAME = eINSTANCE.getMCPToolUseBlock_Name();

		/**
		 * The meta object literal for the '<em><b>Server Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MCP_TOOL_USE_BLOCK__SERVER_NAME = eINSTANCE.getMCPToolUseBlock_ServerName();

		/**
		 * The meta object literal for the '<em><b>Input</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MCP_TOOL_USE_BLOCK__INPUT = eINSTANCE.getMCPToolUseBlock_Input();

		/**
		 * The meta object literal for the '<em><b>Caller</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MCP_TOOL_USE_BLOCK__CALLER = eINSTANCE.getMCPToolUseBlock_Caller();

		/**
		 * The meta object literal for the '<em><b>Cache Control</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MCP_TOOL_USE_BLOCK__CACHE_CONTROL = eINSTANCE.getMCPToolUseBlock_CacheControl();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolResultBlockImpl <em>Tool Result Block</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolResultBlockImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getToolResultBlock()
		 * @generated
		 */
		EClass TOOL_RESULT_BLOCK = eINSTANCE.getToolResultBlock();

		/**
		 * The meta object literal for the '<em><b>Tool Use Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TOOL_RESULT_BLOCK__TOOL_USE_ID = eINSTANCE.getToolResultBlock_ToolUseId();

		/**
		 * The meta object literal for the '<em><b>Content</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TOOL_RESULT_BLOCK__CONTENT = eINSTANCE.getToolResultBlock_Content();

		/**
		 * The meta object literal for the '<em><b>Is Error</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TOOL_RESULT_BLOCK__IS_ERROR = eINSTANCE.getToolResultBlock_IsError();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolResultBlockImpl <em>MCP Tool Result Block</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolResultBlockImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getMCPToolResultBlock()
		 * @generated
		 */
		EClass MCP_TOOL_RESULT_BLOCK = eINSTANCE.getMCPToolResultBlock();

		/**
		 * The meta object literal for the '<em><b>Tool Use Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MCP_TOOL_RESULT_BLOCK__TOOL_USE_ID = eINSTANCE.getMCPToolResultBlock_ToolUseId();

		/**
		 * The meta object literal for the '<em><b>Content</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MCP_TOOL_RESULT_BLOCK__CONTENT = eINSTANCE.getMCPToolResultBlock_Content();

		/**
		 * The meta object literal for the '<em><b>Is Error</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MCP_TOOL_RESULT_BLOCK__IS_ERROR = eINSTANCE.getMCPToolResultBlock_IsError();

		/**
		 * The meta object literal for the '<em><b>Cache Control</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MCP_TOOL_RESULT_BLOCK__CACHE_CONTROL = eINSTANCE.getMCPToolResultBlock_CacheControl();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolImpl <em>Tool</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getTool()
		 * @generated
		 */
		EClass TOOL = eINSTANCE.getTool();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TOOL__NAME = eINSTANCE.getTool_Name();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TOOL__DESCRIPTION = eINSTANCE.getTool_Description();

		/**
		 * The meta object literal for the '<em><b>Input Schema</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TOOL__INPUT_SCHEMA = eINSTANCE.getTool_InputSchema();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TOOL__TYPE = eINSTANCE.getTool_Type();

		/**
		 * The meta object literal for the '<em><b>Allowed Callers</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TOOL__ALLOWED_CALLERS = eINSTANCE.getTool_AllowedCallers();

		/**
		 * The meta object literal for the '<em><b>Defer Loading</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TOOL__DEFER_LOADING = eINSTANCE.getTool_DeferLoading();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPServerImpl <em>MCP Server</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPServerImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getMCPServer()
		 * @generated
		 */
		EClass MCP_SERVER = eINSTANCE.getMCPServer();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MCP_SERVER__NAME = eINSTANCE.getMCPServer_Name();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MCP_SERVER__TYPE = eINSTANCE.getMCPServer_Type();

		/**
		 * The meta object literal for the '<em><b>Url</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MCP_SERVER__URL = eINSTANCE.getMCPServer_Url();

		/**
		 * The meta object literal for the '<em><b>Authorization Token</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MCP_SERVER__AUTHORIZATION_TOKEN = eINSTANCE.getMCPServer_AuthorizationToken();

		/**
		 * The meta object literal for the '<em><b>Tool Configuration</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MCP_SERVER__TOOL_CONFIGURATION = eINSTANCE.getMCPServer_ToolConfiguration();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolConfigurationImpl <em>MCP Tool Configuration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.MCPToolConfigurationImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getMCPToolConfiguration()
		 * @generated
		 */
		EClass MCP_TOOL_CONFIGURATION = eINSTANCE.getMCPToolConfiguration();

		/**
		 * The meta object literal for the '<em><b>Enabled</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MCP_TOOL_CONFIGURATION__ENABLED = eINSTANCE.getMCPToolConfiguration_Enabled();

		/**
		 * The meta object literal for the '<em><b>Allowed Tools</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MCP_TOOL_CONFIGURATION__ALLOWED_TOOLS = eINSTANCE.getMCPToolConfiguration_AllowedTools();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ContainerImpl <em>Container</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ContainerImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getContainer()
		 * @generated
		 */
		EClass CONTAINER = eINSTANCE.getContainer();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTAINER__ID = eINSTANCE.getContainer_Id();

		/**
		 * The meta object literal for the '<em><b>Skills</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONTAINER__SKILLS = eINSTANCE.getContainer_Skills();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.SkillImpl <em>Skill</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.SkillImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getSkill()
		 * @generated
		 */
		EClass SKILL = eINSTANCE.getSkill();

		/**
		 * The meta object literal for the '<em><b>Skill Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SKILL__SKILL_ID = eINSTANCE.getSkill_SkillId();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SKILL__TYPE = eINSTANCE.getSkill_Type();

		/**
		 * The meta object literal for the '<em><b>Version</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SKILL__VERSION = eINSTANCE.getSkill_Version();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ContextManagementConfigImpl <em>Context Management Config</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ContextManagementConfigImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getContextManagementConfig()
		 * @generated
		 */
		EClass CONTEXT_MANAGEMENT_CONFIG = eINSTANCE.getContextManagementConfig();

		/**
		 * The meta object literal for the '<em><b>Edits</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONTEXT_MANAGEMENT_CONFIG__EDITS = eINSTANCE.getContextManagementConfig_Edits();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ContextEditImpl <em>Context Edit</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ContextEditImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getContextEdit()
		 * @generated
		 */
		EClass CONTEXT_EDIT = eINSTANCE.getContextEdit();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTEXT_EDIT__TYPE = eINSTANCE.getContextEdit_Type();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearToolUsesEditImpl <em>Clear Tool Uses Edit</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearToolUsesEditImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getClearToolUsesEdit()
		 * @generated
		 */
		EClass CLEAR_TOOL_USES_EDIT = eINSTANCE.getClearToolUsesEdit();

		/**
		 * The meta object literal for the '<em><b>Clear At Least</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLEAR_TOOL_USES_EDIT__CLEAR_AT_LEAST = eINSTANCE.getClearToolUsesEdit_ClearAtLeast();

		/**
		 * The meta object literal for the '<em><b>Clear Tool Inputs All</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLEAR_TOOL_USES_EDIT__CLEAR_TOOL_INPUTS_ALL = eINSTANCE.getClearToolUsesEdit_ClearToolInputsAll();

		/**
		 * The meta object literal for the '<em><b>Clear Tool Inputs Specific</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLEAR_TOOL_USES_EDIT__CLEAR_TOOL_INPUTS_SPECIFIC = eINSTANCE.getClearToolUsesEdit_ClearToolInputsSpecific();

		/**
		 * The meta object literal for the '<em><b>Exclude Tools</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLEAR_TOOL_USES_EDIT__EXCLUDE_TOOLS = eINSTANCE.getClearToolUsesEdit_ExcludeTools();

		/**
		 * The meta object literal for the '<em><b>Keep</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLEAR_TOOL_USES_EDIT__KEEP = eINSTANCE.getClearToolUsesEdit_Keep();

		/**
		 * The meta object literal for the '<em><b>Trigger</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLEAR_TOOL_USES_EDIT__TRIGGER = eINSTANCE.getClearToolUsesEdit_Trigger();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearThinkingEditImpl <em>Clear Thinking Edit</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearThinkingEditImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getClearThinkingEdit()
		 * @generated
		 */
		EClass CLEAR_THINKING_EDIT = eINSTANCE.getClearThinkingEdit();

		/**
		 * The meta object literal for the '<em><b>Keep Recent</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLEAR_THINKING_EDIT__KEEP_RECENT = eINSTANCE.getClearThinkingEdit_KeepRecent();

		/**
		 * The meta object literal for the '<em><b>Keep All</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLEAR_THINKING_EDIT__KEEP_ALL = eINSTANCE.getClearThinkingEdit_KeepAll();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearTriggerImpl <em>Clear Trigger</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearTriggerImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getClearTrigger()
		 * @generated
		 */
		EClass CLEAR_TRIGGER = eINSTANCE.getClearTrigger();

		/**
		 * The meta object literal for the '<em><b>Input Tokens</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLEAR_TRIGGER__INPUT_TOKENS = eINSTANCE.getClearTrigger_InputTokens();

		/**
		 * The meta object literal for the '<em><b>Tool Uses Count</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLEAR_TRIGGER__TOOL_USES_COUNT = eINSTANCE.getClearTrigger_ToolUsesCount();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.MetadataImpl <em>Metadata</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.MetadataImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getMetadata()
		 * @generated
		 */
		EClass METADATA = eINSTANCE.getMetadata();

		/**
		 * The meta object literal for the '<em><b>User Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute METADATA__USER_ID = eINSTANCE.getMetadata_UserId();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.OutputConfigImpl <em>Output Config</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.OutputConfigImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getOutputConfig()
		 * @generated
		 */
		EClass OUTPUT_CONFIG = eINSTANCE.getOutputConfig();

		/**
		 * The meta object literal for the '<em><b>Effort</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute OUTPUT_CONFIG__EFFORT = eINSTANCE.getOutputConfig_Effort();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolChoiceImpl <em>Tool Choice</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolChoiceImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getToolChoice()
		 * @generated
		 */
		EClass TOOL_CHOICE = eINSTANCE.getToolChoice();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TOOL_CHOICE__TYPE = eINSTANCE.getToolChoice_Type();

		/**
		 * The meta object literal for the '<em><b>Disable Parallel Tool Use</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TOOL_CHOICE__DISABLE_PARALLEL_TOOL_USE = eINSTANCE.getToolChoice_DisableParallelToolUse();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.AutoToolChoiceImpl <em>Auto Tool Choice</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.AutoToolChoiceImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getAutoToolChoice()
		 * @generated
		 */
		EClass AUTO_TOOL_CHOICE = eINSTANCE.getAutoToolChoice();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.AnyToolChoiceImpl <em>Any Tool Choice</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.AnyToolChoiceImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getAnyToolChoice()
		 * @generated
		 */
		EClass ANY_TOOL_CHOICE = eINSTANCE.getAnyToolChoice();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolToolChoiceImpl <em>Tool Tool Choice</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ToolToolChoiceImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getToolToolChoice()
		 * @generated
		 */
		EClass TOOL_TOOL_CHOICE = eINSTANCE.getToolToolChoice();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TOOL_TOOL_CHOICE__NAME = eINSTANCE.getToolToolChoice_Name();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.NoneToolChoiceImpl <em>None Tool Choice</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.NoneToolChoiceImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getNoneToolChoice()
		 * @generated
		 */
		EClass NONE_TOOL_CHOICE = eINSTANCE.getNoneToolChoice();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ThinkingConfigImpl <em>Thinking Config</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ThinkingConfigImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getThinkingConfig()
		 * @generated
		 */
		EClass THINKING_CONFIG = eINSTANCE.getThinkingConfig();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute THINKING_CONFIG__TYPE = eINSTANCE.getThinkingConfig_Type();

		/**
		 * The meta object literal for the '<em><b>Budget Tokens</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute THINKING_CONFIG__BUDGET_TOKENS = eINSTANCE.getThinkingConfig_BudgetTokens();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.OutputFormatImpl <em>Output Format</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.OutputFormatImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getOutputFormat()
		 * @generated
		 */
		EClass OUTPUT_FORMAT = eINSTANCE.getOutputFormat();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute OUTPUT_FORMAT__TYPE = eINSTANCE.getOutputFormat_Type();

		/**
		 * The meta object literal for the '<em><b>Schema</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute OUTPUT_FORMAT__SCHEMA = eINSTANCE.getOutputFormat_Schema();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.CacheControlImpl <em>Cache Control</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.CacheControlImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getCacheControl()
		 * @generated
		 */
		EClass CACHE_CONTROL = eINSTANCE.getCacheControl();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CACHE_CONTROL__TYPE = eINSTANCE.getCacheControl_Type();

		/**
		 * The meta object literal for the '<em><b>Ttl</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CACHE_CONTROL__TTL = eINSTANCE.getCacheControl_Ttl();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.CitationsImpl <em>Citations</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.CitationsImpl
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getCitations()
		 * @generated
		 */
		EClass CITATIONS = eINSTANCE.getCitations();

		/**
		 * The meta object literal for the '<em><b>Enabled</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CITATIONS__ENABLED = eINSTANCE.getCitations_Enabled();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Role <em>Role</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Role
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getRole()
		 * @generated
		 */
		EEnum ROLE = eINSTANCE.getRole();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ServiceTier <em>Service Tier</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ServiceTier
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getServiceTier()
		 * @generated
		 */
		EEnum SERVICE_TIER = eINSTANCE.getServiceTier();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingType <em>Thinking Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingType
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getThinkingType()
		 * @generated
		 */
		EEnum THINKING_TYPE = eINSTANCE.getThinkingType();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.SkillType <em>Skill Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.SkillType
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getSkillType()
		 * @generated
		 */
		EEnum SKILL_TYPE = eINSTANCE.getSkillType();

		/**
		 * The meta object literal for the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.EffortLevel <em>Effort Level</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.EffortLevel
		 * @see org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeChatCompletionPackageImpl#getEffortLevel()
		 * @generated
		 */
		EEnum EFFORT_LEVEL = eINSTANCE.getEffortLevel();

	}

} //ClaudeChatCompletionPackage
