/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Claude Request</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Request object for the Claude Messages API. Represents a single request to create a message using Claude AI models.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getModel <em>Model</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getMaxTokens <em>Max Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getMessages <em>Messages</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getSystem <em>System</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getTemperature <em>Temperature</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getStopSequences <em>Stop Sequences</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getTools <em>Tools</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getToolChoice <em>Tool Choice</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#isStream <em>Stream</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getThinking <em>Thinking</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getOutputFormat <em>Output Format</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getServiceTier <em>Service Tier</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getMcpServers <em>Mcp Servers</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getContainer <em>Container</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getContextManagement <em>Context Management</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getMetadata <em>Metadata</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getOutputConfig <em>Output Config</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeRequest()
 * @model
 * @generated
 */
@ProviderType
public interface ClaudeRequest extends EObject {
	/**
	 * Returns the value of the '<em><b>Model</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The Claude model identifier to use for this request (e.g., claude-opus-4-5-20251101, claude-3-7-sonnet-20250219). Each model has different capabilities and performance characteristics.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Model</em>' attribute.
	 * @see #setModel(String)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeRequest_Model()
	 * @model required="true"
	 * @generated
	 */
	String getModel();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getModel <em>Model</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Model</em>' attribute.
	 * @see #getModel()
	 * @generated
	 */
	void setModel(String value);

	/**
	 * Returns the value of the '<em><b>Max Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Maximum number of tokens to generate before stopping. The model may stop before reaching this limit. Different models have varying maximum token limits.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Max Tokens</em>' attribute.
	 * @see #setMaxTokens(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeRequest_MaxTokens()
	 * @model required="true"
	 *        extendedMetaData="name='max_tokens'"
	 * @generated
	 */
	int getMaxTokens();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getMaxTokens <em>Max Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Max Tokens</em>' attribute.
	 * @see #getMaxTokens()
	 * @generated
	 */
	void setMaxTokens(int value);

	/**
	 * Returns the value of the '<em><b>Messages</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.fennec.ai.chat.completion.model.claude.Message}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Array of conversational turns alternating between user and assistant roles. Supports text and various content blocks (images, documents, tool results). Maximum 100,000 messages per request.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Messages</em>' containment reference list.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeRequest_Messages()
	 * @model containment="true" required="true"
	 * @generated
	 */
	EList<Message> getMessages();

	/**
	 * Returns the value of the '<em><b>System</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.fennec.ai.chat.completion.model.claude.SystemPrompt}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * System instructions providing context and guidance for Claude. Can include multiple system prompts with cache control options.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>System</em>' containment reference list.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeRequest_System()
	 * @model containment="true"
	 * @generated
	 */
	EList<SystemPrompt> getSystem();

	/**
	 * Returns the value of the '<em><b>Temperature</b></em>' attribute.
	 * The default value is <code>"1.0"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Controls randomness in responses (0.0-1.0). Lower values favor analytical tasks, higher values suit creative work. Default is 1.0.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Temperature</em>' attribute.
	 * @see #setTemperature(double)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeRequest_Temperature()
	 * @model default="1.0"
	 * @generated
	 */
	double getTemperature();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getTemperature <em>Temperature</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Temperature</em>' attribute.
	 * @see #getTemperature()
	 * @generated
	 */
	void setTemperature(double value);

	/**
	 * Returns the value of the '<em><b>Stop Sequences</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Custom text strings that halt generation when matched. When triggered, response includes stop_reason: 'stop_sequence'.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Stop Sequences</em>' attribute list.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeRequest_StopSequences()
	 * @model extendedMetaData="name='stop_sequences'"
	 * @generated
	 */
	EList<String> getStopSequences();

	/**
	 * Returns the value of the '<em><b>Tools</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.fennec.ai.chat.completion.model.claude.Tool}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Definitions of tools that the model can invoke. Each tool includes a name, description, and input schema defining expected parameters.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Tools</em>' containment reference list.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeRequest_Tools()
	 * @model containment="true"
	 * @generated
	 */
	EList<Tool> getTools();

	/**
	 * Returns the value of the '<em><b>Tool Choice</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Controls how the model uses tools. Options: auto (model decides), any (must use tools), tool (force specific tool), none (prohibit tools).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Tool Choice</em>' containment reference.
	 * @see #setToolChoice(ToolChoice)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeRequest_ToolChoice()
	 * @model containment="true"
	 *        extendedMetaData="name='tool_choice'"
	 * @generated
	 */
	ToolChoice getToolChoice();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getToolChoice <em>Tool Choice</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Tool Choice</em>' containment reference.
	 * @see #getToolChoice()
	 * @generated
	 */
	void setToolChoice(ToolChoice value);

	/**
	 * Returns the value of the '<em><b>Stream</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Enables server-sent event streaming for incremental response delivery. Default is false.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Stream</em>' attribute.
	 * @see #setStream(boolean)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeRequest_Stream()
	 * @model default="false"
	 * @generated
	 */
	boolean isStream();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#isStream <em>Stream</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Stream</em>' attribute.
	 * @see #isStream()
	 * @generated
	 */
	void setStream(boolean value);

	/**
	 * Returns the value of the '<em><b>Thinking</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Configuration for extended thinking mode. Allows the model to perform internal reasoning before responding.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Thinking</em>' containment reference.
	 * @see #setThinking(ThinkingConfig)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeRequest_Thinking()
	 * @model containment="true"
	 * @generated
	 */
	ThinkingConfig getThinking();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getThinking <em>Thinking</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Thinking</em>' containment reference.
	 * @see #getThinking()
	 * @generated
	 */
	void setThinking(ThinkingConfig value);

	/**
	 * Returns the value of the '<em><b>Output Format</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Constrains response format using JSON Schema. Specifies the structure for structured output validation.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Output Format</em>' containment reference.
	 * @see #setOutputFormat(OutputFormat)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeRequest_OutputFormat()
	 * @model containment="true"
	 *        extendedMetaData="name='output_format'"
	 * @generated
	 */
	OutputFormat getOutputFormat();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getOutputFormat <em>Output Format</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Output Format</em>' containment reference.
	 * @see #getOutputFormat()
	 * @generated
	 */
	void setOutputFormat(OutputFormat value);

	/**
	 * Returns the value of the '<em><b>Service Tier</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.fennec.ai.chat.completion.model.claude.ServiceTier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Selects API capacity level: 'auto' for priority access when available, or 'standard_only' for standard capacity tier.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Service Tier</em>' attribute.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ServiceTier
	 * @see #setServiceTier(ServiceTier)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeRequest_ServiceTier()
	 * @model extendedMetaData="name='service_tier'"
	 * @generated
	 */
	ServiceTier getServiceTier();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getServiceTier <em>Service Tier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Service Tier</em>' attribute.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ServiceTier
	 * @see #getServiceTier()
	 * @generated
	 */
	void setServiceTier(ServiceTier value);

	/**
	 * Returns the value of the '<em><b>Mcp Servers</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPServer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * List of Model Context Protocol (MCP) servers available during the request. Each server provides additional tools and capabilities.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Mcp Servers</em>' containment reference list.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeRequest_McpServers()
	 * @model containment="true"
	 *        extendedMetaData="name='mcp_servers'"
	 * @generated
	 */
	EList<MCPServer> getMcpServers();

	/**
	 * Returns the value of the '<em><b>Container</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Container identifier for code execution environments. Can specify container ID and skills to load (built-in or custom).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Container</em>' containment reference.
	 * @see #setContainer(Container)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeRequest_Container()
	 * @model containment="true"
	 * @generated
	 */
	Container getContainer();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getContainer <em>Container</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Container</em>' containment reference.
	 * @see #getContainer()
	 * @generated
	 */
	void setContainer(Container value);

	/**
	 * Returns the value of the '<em><b>Context Management</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Controls how Claude manages conversation context across requests. Supports clearing tool uses and thinking blocks based on triggers.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Context Management</em>' containment reference.
	 * @see #setContextManagement(ContextManagementConfig)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeRequest_ContextManagement()
	 * @model containment="true"
	 *        extendedMetaData="name='context_management'"
	 * @generated
	 */
	ContextManagementConfig getContextManagement();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getContextManagement <em>Context Management</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Context Management</em>' containment reference.
	 * @see #getContextManagement()
	 * @generated
	 */
	void setContextManagement(ContextManagementConfig value);

	/**
	 * Returns the value of the '<em><b>Metadata</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Additional metadata for the request, such as user_id for abuse detection. Use opaque identifiers without PII.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Metadata</em>' containment reference.
	 * @see #setMetadata(Metadata)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeRequest_Metadata()
	 * @model containment="true"
	 * @generated
	 */
	Metadata getMetadata();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getMetadata <em>Metadata</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Metadata</em>' containment reference.
	 * @see #getMetadata()
	 * @generated
	 */
	void setMetadata(Metadata value);

	/**
	 * Returns the value of the '<em><b>Output Config</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Controls response effort level (low, medium, high) to balance speed and quality.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Output Config</em>' containment reference.
	 * @see #setOutputConfig(OutputConfig)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeRequest_OutputConfig()
	 * @model containment="true"
	 *        extendedMetaData="name='output_config'"
	 * @generated
	 */
	OutputConfig getOutputConfig();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest#getOutputConfig <em>Output Config</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Output Config</em>' containment reference.
	 * @see #getOutputConfig()
	 * @generated
	 */
	void setOutputConfig(OutputConfig value);

} // ClaudeRequest
