/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Claude Response</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Response object from the Claude Messages API. Contains the model's response, metadata about generation, and usage statistics.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getRole <em>Role</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getContent <em>Content</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getModel <em>Model</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getStopReason <em>Stop Reason</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getStopSequence <em>Stop Sequence</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getUsage <em>Usage</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeResponse()
 * @model
 * @generated
 */
@ProviderType
public interface ClaudeResponse extends EObject {
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Unique identifier for this message response.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeResponse_Id()
	 * @model required="true"
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute.
	 * The default value is <code>"message"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Object type, always 'message' for Messages API responses.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see #setType(String)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeResponse_Type()
	 * @model default="message" required="true"
	 * @generated
	 */
	String getType();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see #getType()
	 * @generated
	 */
	void setType(String value);

	/**
	 * Returns the value of the '<em><b>Role</b></em>' attribute.
	 * The default value is <code>"assistant"</code>.
	 * The literals are from the enumeration {@link org.eclipse.fennec.ai.chat.completion.model.claude.Role}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The role of the message author, always 'assistant' for model responses.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Role</em>' attribute.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Role
	 * @see #setRole(Role)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeResponse_Role()
	 * @model default="assistant" required="true"
	 * @generated
	 */
	Role getRole();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getRole <em>Role</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Role</em>' attribute.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.Role
	 * @see #getRole()
	 * @generated
	 */
	void setRole(Role value);

	/**
	 * Returns the value of the '<em><b>Content</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.fennec.ai.chat.completion.model.claude.ContentBlock}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Array of content blocks that make up the model's response. Can include text, tool_use, thinking, and other block types.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Content</em>' containment reference list.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeResponse_Content()
	 * @model containment="true" required="true"
	 * @generated
	 */
	EList<ContentBlock> getContent();

	/**
	 * Returns the value of the '<em><b>Model</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The model identifier that was used to generate this response.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Model</em>' attribute.
	 * @see #setModel(String)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeResponse_Model()
	 * @model required="true"
	 * @generated
	 */
	String getModel();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getModel <em>Model</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Model</em>' attribute.
	 * @see #getModel()
	 * @generated
	 */
	void setModel(String value);

	/**
	 * Returns the value of the '<em><b>Stop Reason</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The reason why the model stopped generating. Possible values: 'end_turn' (natural completion), 'max_tokens' (reached token limit), 'stop_sequence' (matched custom stop sequence), 'tool_use' (model wants to use a tool).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Stop Reason</em>' attribute.
	 * @see #setStopReason(String)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeResponse_StopReason()
	 * @model required="true"
	 *        extendedMetaData="name='stop_reason'"
	 * @generated
	 */
	String getStopReason();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getStopReason <em>Stop Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Stop Reason</em>' attribute.
	 * @see #getStopReason()
	 * @generated
	 */
	void setStopReason(String value);

	/**
	 * Returns the value of the '<em><b>Stop Sequence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The custom stop sequence that was matched, if stop_reason is 'stop_sequence'.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Stop Sequence</em>' attribute.
	 * @see #setStopSequence(String)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeResponse_StopSequence()
	 * @model extendedMetaData="name='stop_sequence'"
	 * @generated
	 */
	String getStopSequence();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getStopSequence <em>Stop Sequence</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Stop Sequence</em>' attribute.
	 * @see #getStopSequence()
	 * @generated
	 */
	void setStopSequence(String value);

	/**
	 * Returns the value of the '<em><b>Usage</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Token usage information for this request/response, including input tokens, output tokens, and cache statistics.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Usage</em>' containment reference.
	 * @see #setUsage(Usage)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClaudeResponse_Usage()
	 * @model containment="true" required="true"
	 * @generated
	 */
	Usage getUsage();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse#getUsage <em>Usage</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Usage</em>' containment reference.
	 * @see #getUsage()
	 * @generated
	 */
	void setUsage(Usage value);

} // ClaudeResponse
