/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Clear Thinking Edit</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearThinkingEdit#getKeepRecent <em>Keep Recent</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearThinkingEdit#isKeepAll <em>Keep All</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClearThinkingEdit()
 * @model
 * @generated
 */
@ProviderType
public interface ClearThinkingEdit extends ContextEdit {
	/**
	 * Returns the value of the '<em><b>Keep Recent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Keep Recent</em>' attribute.
	 * @see #setKeepRecent(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClearThinkingEdit_KeepRecent()
	 * @model extendedMetaData="name='keep'"
	 * @generated
	 */
	int getKeepRecent();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearThinkingEdit#getKeepRecent <em>Keep Recent</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Keep Recent</em>' attribute.
	 * @see #getKeepRecent()
	 * @generated
	 */
	void setKeepRecent(int value);

	/**
	 * Returns the value of the '<em><b>Keep All</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Keep All</em>' attribute.
	 * @see #setKeepAll(boolean)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClearThinkingEdit_KeepAll()
	 * @model extendedMetaData="name='keep'"
	 * @generated
	 */
	boolean isKeepAll();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearThinkingEdit#isKeepAll <em>Keep All</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Keep All</em>' attribute.
	 * @see #isKeepAll()
	 * @generated
	 */
	void setKeepAll(boolean value);

} // ClearThinkingEdit
