/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude;

import org.eclipse.emf.common.util.EList;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Clear Tool Uses Edit</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#getClearAtLeast <em>Clear At Least</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#isClearToolInputsAll <em>Clear Tool Inputs All</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#getClearToolInputsSpecific <em>Clear Tool Inputs Specific</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#getExcludeTools <em>Exclude Tools</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#getKeep <em>Keep</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#getTrigger <em>Trigger</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClearToolUsesEdit()
 * @model
 * @generated
 */
@ProviderType
public interface ClearToolUsesEdit extends ContextEdit {
	/**
	 * Returns the value of the '<em><b>Clear At Least</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Clear At Least</em>' attribute.
	 * @see #setClearAtLeast(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClearToolUsesEdit_ClearAtLeast()
	 * @model extendedMetaData="name='clear_at_least'"
	 * @generated
	 */
	int getClearAtLeast();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#getClearAtLeast <em>Clear At Least</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Clear At Least</em>' attribute.
	 * @see #getClearAtLeast()
	 * @generated
	 */
	void setClearAtLeast(int value);

	/**
	 * Returns the value of the '<em><b>Clear Tool Inputs All</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Clear Tool Inputs All</em>' attribute.
	 * @see #setClearToolInputsAll(boolean)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClearToolUsesEdit_ClearToolInputsAll()
	 * @model extendedMetaData="name='clear_tool_inputs'"
	 * @generated
	 */
	boolean isClearToolInputsAll();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#isClearToolInputsAll <em>Clear Tool Inputs All</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Clear Tool Inputs All</em>' attribute.
	 * @see #isClearToolInputsAll()
	 * @generated
	 */
	void setClearToolInputsAll(boolean value);

	/**
	 * Returns the value of the '<em><b>Clear Tool Inputs Specific</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Clear Tool Inputs Specific</em>' attribute list.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClearToolUsesEdit_ClearToolInputsSpecific()
	 * @model extendedMetaData="name='clear_tool_inputs'"
	 * @generated
	 */
	EList<String> getClearToolInputsSpecific();

	/**
	 * Returns the value of the '<em><b>Exclude Tools</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Exclude Tools</em>' attribute list.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClearToolUsesEdit_ExcludeTools()
	 * @model extendedMetaData="name='exclude_tools'"
	 * @generated
	 */
	EList<String> getExcludeTools();

	/**
	 * Returns the value of the '<em><b>Keep</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Keep</em>' attribute.
	 * @see #setKeep(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClearToolUsesEdit_Keep()
	 * @model
	 * @generated
	 */
	int getKeep();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#getKeep <em>Keep</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Keep</em>' attribute.
	 * @see #getKeep()
	 * @generated
	 */
	void setKeep(int value);

	/**
	 * Returns the value of the '<em><b>Trigger</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Trigger</em>' containment reference.
	 * @see #setTrigger(ClearTrigger)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClearToolUsesEdit_Trigger()
	 * @model containment="true"
	 * @generated
	 */
	ClearTrigger getTrigger();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit#getTrigger <em>Trigger</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Trigger</em>' containment reference.
	 * @see #getTrigger()
	 * @generated
	 */
	void setTrigger(ClearTrigger value);

} // ClearToolUsesEdit
