/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Clear Trigger</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearTrigger#getInputTokens <em>Input Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearTrigger#getToolUsesCount <em>Tool Uses Count</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClearTrigger()
 * @model
 * @generated
 */
@ProviderType
public interface ClearTrigger extends EObject {
	/**
	 * Returns the value of the '<em><b>Input Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Input Tokens</em>' attribute.
	 * @see #setInputTokens(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClearTrigger_InputTokens()
	 * @model extendedMetaData="name='input_tokens'"
	 * @generated
	 */
	int getInputTokens();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearTrigger#getInputTokens <em>Input Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Input Tokens</em>' attribute.
	 * @see #getInputTokens()
	 * @generated
	 */
	void setInputTokens(int value);

	/**
	 * Returns the value of the '<em><b>Tool Uses Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Tool Uses Count</em>' attribute.
	 * @see #setToolUsesCount(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getClearTrigger_ToolUsesCount()
	 * @model extendedMetaData="name='tool_uses_count'"
	 * @generated
	 */
	int getToolUsesCount();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ClearTrigger#getToolUsesCount <em>Tool Uses Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Tool Uses Count</em>' attribute.
	 * @see #getToolUsesCount()
	 * @generated
	 */
	void setToolUsesCount(int value);

} // ClearTrigger
