/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>MCP Tool Configuration</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Configuration controlling tool availability from an MCP server.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolConfiguration#isEnabled <em>Enabled</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolConfiguration#getAllowedTools <em>Allowed Tools</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getMCPToolConfiguration()
 * @model
 * @generated
 */
@ProviderType
public interface MCPToolConfiguration extends EObject {
	/**
	 * Returns the value of the '<em><b>Enabled</b></em>' attribute.
	 * The default value is <code>"true"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Whether tools from this server are enabled. Default is true.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Enabled</em>' attribute.
	 * @see #setEnabled(boolean)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getMCPToolConfiguration_Enabled()
	 * @model default="true"
	 * @generated
	 */
	boolean isEnabled();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolConfiguration#isEnabled <em>Enabled</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Enabled</em>' attribute.
	 * @see #isEnabled()
	 * @generated
	 */
	void setEnabled(boolean value);

	/**
	 * Returns the value of the '<em><b>Allowed Tools</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * List of specific tool names that are allowed from this server. If empty, all tools are allowed.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Allowed Tools</em>' attribute list.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getMCPToolConfiguration_AllowedTools()
	 * @model extendedMetaData="name='allowed_tools'"
	 * @generated
	 */
	EList<String> getAllowedTools();

} // MCPToolConfiguration
