/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Skill</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Definition of a skill to be loaded in a container.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.Skill#getSkillId <em>Skill Id</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.Skill#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.Skill#getVersion <em>Version</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getSkill()
 * @model
 * @generated
 */
@ProviderType
public interface Skill extends EObject {
	/**
	 * Returns the value of the '<em><b>Skill Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Unique identifier for the skill.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Skill Id</em>' attribute.
	 * @see #setSkillId(String)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getSkill_SkillId()
	 * @model required="true"
	 *        extendedMetaData="name='skill_id'"
	 * @generated
	 */
	String getSkillId();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Skill#getSkillId <em>Skill Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Skill Id</em>' attribute.
	 * @see #getSkillId()
	 * @generated
	 */
	void setSkillId(String value);

	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.fennec.ai.chat.completion.model.claude.SkillType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Skill category: 'anthropic' for built-in skills or 'custom' for user-defined skills.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.SkillType
	 * @see #setType(SkillType)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getSkill_Type()
	 * @model required="true"
	 * @generated
	 */
	SkillType getType();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Skill#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.SkillType
	 * @see #getType()
	 * @generated
	 */
	void setType(SkillType value);

	/**
	 * Returns the value of the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Version of the skill, or 'latest' for the most recent version.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Version</em>' attribute.
	 * @see #setVersion(String)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getSkill_Version()
	 * @model
	 * @generated
	 */
	String getVersion();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Skill#getVersion <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Version</em>' attribute.
	 * @see #getVersion()
	 * @generated
	 */
	void setVersion(String value);

} // Skill
