/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude;

import org.eclipse.emf.common.util.EList;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Tool Result Block</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolResultBlock#getToolUseId <em>Tool Use Id</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolResultBlock#getContent <em>Content</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolResultBlock#isIsError <em>Is Error</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getToolResultBlock()
 * @model
 * @generated
 */
@ProviderType
public interface ToolResultBlock extends ContentBlock {
	/**
	 * Returns the value of the '<em><b>Tool Use Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Tool Use Id</em>' attribute.
	 * @see #setToolUseId(String)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getToolResultBlock_ToolUseId()
	 * @model required="true"
	 *        extendedMetaData="name='tool_use_id'"
	 * @generated
	 */
	String getToolUseId();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolResultBlock#getToolUseId <em>Tool Use Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Tool Use Id</em>' attribute.
	 * @see #getToolUseId()
	 * @generated
	 */
	void setToolUseId(String value);

	/**
	 * Returns the value of the '<em><b>Content</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.fennec.ai.chat.completion.model.claude.ContentBlock}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Content</em>' containment reference list.
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getToolResultBlock_Content()
	 * @model containment="true"
	 * @generated
	 */
	EList<ContentBlock> getContent();

	/**
	 * Returns the value of the '<em><b>Is Error</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Is Error</em>' attribute.
	 * @see #setIsError(boolean)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getToolResultBlock_IsError()
	 * @model default="false"
	 *        extendedMetaData="name='is_error'"
	 * @generated
	 */
	boolean isIsError();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.ToolResultBlock#isIsError <em>Is Error</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Is Error</em>' attribute.
	 * @see #isIsError()
	 * @generated
	 */
	void setIsError(boolean value);

} // ToolResultBlock
