/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Usage</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Token usage information for a request/response pair, including input tokens, output tokens, and cache-related token counts.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.Usage#getInputTokens <em>Input Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.Usage#getOutputTokens <em>Output Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.Usage#getCacheCreationInputTokens <em>Cache Creation Input Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.Usage#getCacheReadInputTokens <em>Cache Read Input Tokens</em>}</li>
 * </ul>
 *
 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getUsage()
 * @model
 * @generated
 */
@ProviderType
public interface Usage extends EObject {
	/**
	 * Returns the value of the '<em><b>Input Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The number of input tokens processed in the request, including user messages and system prompts.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Input Tokens</em>' attribute.
	 * @see #setInputTokens(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getUsage_InputTokens()
	 * @model required="true"
	 *        extendedMetaData="name='input_tokens'"
	 * @generated
	 */
	int getInputTokens();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Usage#getInputTokens <em>Input Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Input Tokens</em>' attribute.
	 * @see #getInputTokens()
	 * @generated
	 */
	void setInputTokens(int value);

	/**
	 * Returns the value of the '<em><b>Output Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The number of output tokens generated in the response by the model.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Output Tokens</em>' attribute.
	 * @see #setOutputTokens(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getUsage_OutputTokens()
	 * @model required="true"
	 *        extendedMetaData="name='output_tokens'"
	 * @generated
	 */
	int getOutputTokens();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Usage#getOutputTokens <em>Output Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Output Tokens</em>' attribute.
	 * @see #getOutputTokens()
	 * @generated
	 */
	void setOutputTokens(int value);

	/**
	 * Returns the value of the '<em><b>Cache Creation Input Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The number of input tokens used to create a new cache entry (only present when cache creation occurs).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Cache Creation Input Tokens</em>' attribute.
	 * @see #setCacheCreationInputTokens(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getUsage_CacheCreationInputTokens()
	 * @model extendedMetaData="name='cache_creation_input_tokens'"
	 * @generated
	 */
	int getCacheCreationInputTokens();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Usage#getCacheCreationInputTokens <em>Cache Creation Input Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Cache Creation Input Tokens</em>' attribute.
	 * @see #getCacheCreationInputTokens()
	 * @generated
	 */
	void setCacheCreationInputTokens(int value);

	/**
	 * Returns the value of the '<em><b>Cache Read Input Tokens</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The number of input tokens retrieved from cache (only present when cache is utilized).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Cache Read Input Tokens</em>' attribute.
	 * @see #setCacheReadInputTokens(int)
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#getUsage_CacheReadInputTokens()
	 * @model extendedMetaData="name='cache_read_input_tokens'"
	 * @generated
	 */
	int getCacheReadInputTokens();

	/**
	 * Sets the value of the '{@link org.eclipse.fennec.ai.chat.completion.model.claude.Usage#getCacheReadInputTokens <em>Cache Read Input Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Cache Read Input Tokens</em>' attribute.
	 * @see #getCacheReadInputTokens()
	 * @generated
	 */
	void setCacheReadInputTokens(int value);

} // Usage
