/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.fennec.ai.chat.completion.model.claude.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ClaudeChatCompletionFactoryImpl extends EFactoryImpl implements ClaudeChatCompletionFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ClaudeChatCompletionFactory init() {
		try {
			ClaudeChatCompletionFactory theClaudeChatCompletionFactory = (ClaudeChatCompletionFactory)EPackage.Registry.INSTANCE.getEFactory(ClaudeChatCompletionPackage.eNS_URI);
			if (theClaudeChatCompletionFactory != null) {
				return theClaudeChatCompletionFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new ClaudeChatCompletionFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ClaudeChatCompletionFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST: return createClaudeRequest();
			case ClaudeChatCompletionPackage.USAGE: return createUsage();
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE: return createClaudeResponse();
			case ClaudeChatCompletionPackage.SYSTEM_PROMPT: return createSystemPrompt();
			case ClaudeChatCompletionPackage.MESSAGE: return createMessage();
			case ClaudeChatCompletionPackage.TEXT_BLOCK: return createTextBlock();
			case ClaudeChatCompletionPackage.IMAGE_BLOCK: return createImageBlock();
			case ClaudeChatCompletionPackage.BASE64_IMAGE_SOURCE: return createBase64ImageSource();
			case ClaudeChatCompletionPackage.URL_IMAGE_SOURCE: return createURLImageSource();
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK: return createDocumentBlock();
			case ClaudeChatCompletionPackage.BASE64_DOCUMENT_SOURCE: return createBase64DocumentSource();
			case ClaudeChatCompletionPackage.PLAIN_TEXT_DOCUMENT_SOURCE: return createPlainTextDocumentSource();
			case ClaudeChatCompletionPackage.URL_DOCUMENT_SOURCE: return createURLDocumentSource();
			case ClaudeChatCompletionPackage.TOOL_USE_BLOCK: return createToolUseBlock();
			case ClaudeChatCompletionPackage.MCP_TOOL_USE_BLOCK: return createMCPToolUseBlock();
			case ClaudeChatCompletionPackage.TOOL_RESULT_BLOCK: return createToolResultBlock();
			case ClaudeChatCompletionPackage.MCP_TOOL_RESULT_BLOCK: return createMCPToolResultBlock();
			case ClaudeChatCompletionPackage.TOOL: return createTool();
			case ClaudeChatCompletionPackage.MCP_SERVER: return createMCPServer();
			case ClaudeChatCompletionPackage.MCP_TOOL_CONFIGURATION: return createMCPToolConfiguration();
			case ClaudeChatCompletionPackage.CONTAINER: return createContainer();
			case ClaudeChatCompletionPackage.SKILL: return createSkill();
			case ClaudeChatCompletionPackage.CONTEXT_MANAGEMENT_CONFIG: return createContextManagementConfig();
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT: return createClearToolUsesEdit();
			case ClaudeChatCompletionPackage.CLEAR_THINKING_EDIT: return createClearThinkingEdit();
			case ClaudeChatCompletionPackage.CLEAR_TRIGGER: return createClearTrigger();
			case ClaudeChatCompletionPackage.METADATA: return createMetadata();
			case ClaudeChatCompletionPackage.OUTPUT_CONFIG: return createOutputConfig();
			case ClaudeChatCompletionPackage.AUTO_TOOL_CHOICE: return createAutoToolChoice();
			case ClaudeChatCompletionPackage.ANY_TOOL_CHOICE: return createAnyToolChoice();
			case ClaudeChatCompletionPackage.TOOL_TOOL_CHOICE: return createToolToolChoice();
			case ClaudeChatCompletionPackage.NONE_TOOL_CHOICE: return createNoneToolChoice();
			case ClaudeChatCompletionPackage.THINKING_CONFIG: return createThinkingConfig();
			case ClaudeChatCompletionPackage.OUTPUT_FORMAT: return createOutputFormat();
			case ClaudeChatCompletionPackage.CACHE_CONTROL: return createCacheControl();
			case ClaudeChatCompletionPackage.CITATIONS: return createCitations();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case ClaudeChatCompletionPackage.ROLE:
				return createRoleFromString(eDataType, initialValue);
			case ClaudeChatCompletionPackage.SERVICE_TIER:
				return createServiceTierFromString(eDataType, initialValue);
			case ClaudeChatCompletionPackage.THINKING_TYPE:
				return createThinkingTypeFromString(eDataType, initialValue);
			case ClaudeChatCompletionPackage.SKILL_TYPE:
				return createSkillTypeFromString(eDataType, initialValue);
			case ClaudeChatCompletionPackage.EFFORT_LEVEL:
				return createEffortLevelFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case ClaudeChatCompletionPackage.ROLE:
				return convertRoleToString(eDataType, instanceValue);
			case ClaudeChatCompletionPackage.SERVICE_TIER:
				return convertServiceTierToString(eDataType, instanceValue);
			case ClaudeChatCompletionPackage.THINKING_TYPE:
				return convertThinkingTypeToString(eDataType, instanceValue);
			case ClaudeChatCompletionPackage.SKILL_TYPE:
				return convertSkillTypeToString(eDataType, instanceValue);
			case ClaudeChatCompletionPackage.EFFORT_LEVEL:
				return convertEffortLevelToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ClaudeRequest createClaudeRequest() {
		ClaudeRequestImpl claudeRequest = new ClaudeRequestImpl();
		return claudeRequest;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Usage createUsage() {
		UsageImpl usage = new UsageImpl();
		return usage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ClaudeResponse createClaudeResponse() {
		ClaudeResponseImpl claudeResponse = new ClaudeResponseImpl();
		return claudeResponse;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SystemPrompt createSystemPrompt() {
		SystemPromptImpl systemPrompt = new SystemPromptImpl();
		return systemPrompt;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Message createMessage() {
		MessageImpl message = new MessageImpl();
		return message;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public TextBlock createTextBlock() {
		TextBlockImpl textBlock = new TextBlockImpl();
		return textBlock;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ImageBlock createImageBlock() {
		ImageBlockImpl imageBlock = new ImageBlockImpl();
		return imageBlock;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Base64ImageSource createBase64ImageSource() {
		Base64ImageSourceImpl base64ImageSource = new Base64ImageSourceImpl();
		return base64ImageSource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public URLImageSource createURLImageSource() {
		URLImageSourceImpl urlImageSource = new URLImageSourceImpl();
		return urlImageSource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DocumentBlock createDocumentBlock() {
		DocumentBlockImpl documentBlock = new DocumentBlockImpl();
		return documentBlock;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Base64DocumentSource createBase64DocumentSource() {
		Base64DocumentSourceImpl base64DocumentSource = new Base64DocumentSourceImpl();
		return base64DocumentSource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PlainTextDocumentSource createPlainTextDocumentSource() {
		PlainTextDocumentSourceImpl plainTextDocumentSource = new PlainTextDocumentSourceImpl();
		return plainTextDocumentSource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public URLDocumentSource createURLDocumentSource() {
		URLDocumentSourceImpl urlDocumentSource = new URLDocumentSourceImpl();
		return urlDocumentSource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ToolUseBlock createToolUseBlock() {
		ToolUseBlockImpl toolUseBlock = new ToolUseBlockImpl();
		return toolUseBlock;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MCPToolUseBlock createMCPToolUseBlock() {
		MCPToolUseBlockImpl mcpToolUseBlock = new MCPToolUseBlockImpl();
		return mcpToolUseBlock;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ToolResultBlock createToolResultBlock() {
		ToolResultBlockImpl toolResultBlock = new ToolResultBlockImpl();
		return toolResultBlock;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MCPToolResultBlock createMCPToolResultBlock() {
		MCPToolResultBlockImpl mcpToolResultBlock = new MCPToolResultBlockImpl();
		return mcpToolResultBlock;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Tool createTool() {
		ToolImpl tool = new ToolImpl();
		return tool;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MCPServer createMCPServer() {
		MCPServerImpl mcpServer = new MCPServerImpl();
		return mcpServer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MCPToolConfiguration createMCPToolConfiguration() {
		MCPToolConfigurationImpl mcpToolConfiguration = new MCPToolConfigurationImpl();
		return mcpToolConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public org.eclipse.fennec.ai.chat.completion.model.claude.Container createContainer() {
		ContainerImpl container = new ContainerImpl();
		return container;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Skill createSkill() {
		SkillImpl skill = new SkillImpl();
		return skill;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ContextManagementConfig createContextManagementConfig() {
		ContextManagementConfigImpl contextManagementConfig = new ContextManagementConfigImpl();
		return contextManagementConfig;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ClearToolUsesEdit createClearToolUsesEdit() {
		ClearToolUsesEditImpl clearToolUsesEdit = new ClearToolUsesEditImpl();
		return clearToolUsesEdit;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ClearThinkingEdit createClearThinkingEdit() {
		ClearThinkingEditImpl clearThinkingEdit = new ClearThinkingEditImpl();
		return clearThinkingEdit;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ClearTrigger createClearTrigger() {
		ClearTriggerImpl clearTrigger = new ClearTriggerImpl();
		return clearTrigger;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Metadata createMetadata() {
		MetadataImpl metadata = new MetadataImpl();
		return metadata;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public OutputConfig createOutputConfig() {
		OutputConfigImpl outputConfig = new OutputConfigImpl();
		return outputConfig;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AutoToolChoice createAutoToolChoice() {
		AutoToolChoiceImpl autoToolChoice = new AutoToolChoiceImpl();
		return autoToolChoice;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AnyToolChoice createAnyToolChoice() {
		AnyToolChoiceImpl anyToolChoice = new AnyToolChoiceImpl();
		return anyToolChoice;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ToolToolChoice createToolToolChoice() {
		ToolToolChoiceImpl toolToolChoice = new ToolToolChoiceImpl();
		return toolToolChoice;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NoneToolChoice createNoneToolChoice() {
		NoneToolChoiceImpl noneToolChoice = new NoneToolChoiceImpl();
		return noneToolChoice;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ThinkingConfig createThinkingConfig() {
		ThinkingConfigImpl thinkingConfig = new ThinkingConfigImpl();
		return thinkingConfig;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public OutputFormat createOutputFormat() {
		OutputFormatImpl outputFormat = new OutputFormatImpl();
		return outputFormat;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CacheControl createCacheControl() {
		CacheControlImpl cacheControl = new CacheControlImpl();
		return cacheControl;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Citations createCitations() {
		CitationsImpl citations = new CitationsImpl();
		return citations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Role createRoleFromString(EDataType eDataType, String initialValue) {
		Role result = Role.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertRoleToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ServiceTier createServiceTierFromString(EDataType eDataType, String initialValue) {
		ServiceTier result = ServiceTier.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertServiceTierToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ThinkingType createThinkingTypeFromString(EDataType eDataType, String initialValue) {
		ThinkingType result = ThinkingType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertThinkingTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SkillType createSkillTypeFromString(EDataType eDataType, String initialValue) {
		SkillType result = SkillType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertSkillTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EffortLevel createEffortLevelFromString(EDataType eDataType, String initialValue) {
		EffortLevel result = EffortLevel.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertEffortLevelToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ClaudeChatCompletionPackage getClaudeChatCompletionPackage() {
		return (ClaudeChatCompletionPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static ClaudeChatCompletionPackage getPackage() {
		return ClaudeChatCompletionPackage.eINSTANCE;
	}

} //ClaudeChatCompletionFactoryImpl
