/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.fennec.ai.chat.completion.model.claude.AnyToolChoice;
import org.eclipse.fennec.ai.chat.completion.model.claude.AutoToolChoice;
import org.eclipse.fennec.ai.chat.completion.model.claude.Base64DocumentSource;
import org.eclipse.fennec.ai.chat.completion.model.claude.Base64ImageSource;
import org.eclipse.fennec.ai.chat.completion.model.claude.CacheControl;
import org.eclipse.fennec.ai.chat.completion.model.claude.Citations;
import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionFactory;
import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest;
import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse;
import org.eclipse.fennec.ai.chat.completion.model.claude.ClearThinkingEdit;
import org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit;
import org.eclipse.fennec.ai.chat.completion.model.claude.ClearTrigger;
import org.eclipse.fennec.ai.chat.completion.model.claude.ContentBlock;
import org.eclipse.fennec.ai.chat.completion.model.claude.ContextEdit;
import org.eclipse.fennec.ai.chat.completion.model.claude.ContextManagementConfig;
import org.eclipse.fennec.ai.chat.completion.model.claude.DocumentBlock;
import org.eclipse.fennec.ai.chat.completion.model.claude.DocumentSource;
import org.eclipse.fennec.ai.chat.completion.model.claude.EffortLevel;
import org.eclipse.fennec.ai.chat.completion.model.claude.ImageBlock;
import org.eclipse.fennec.ai.chat.completion.model.claude.ImageSource;
import org.eclipse.fennec.ai.chat.completion.model.claude.MCPServer;
import org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolConfiguration;
import org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolResultBlock;
import org.eclipse.fennec.ai.chat.completion.model.claude.MCPToolUseBlock;
import org.eclipse.fennec.ai.chat.completion.model.claude.Message;
import org.eclipse.fennec.ai.chat.completion.model.claude.Metadata;
import org.eclipse.fennec.ai.chat.completion.model.claude.NoneToolChoice;
import org.eclipse.fennec.ai.chat.completion.model.claude.OutputConfig;
import org.eclipse.fennec.ai.chat.completion.model.claude.OutputFormat;
import org.eclipse.fennec.ai.chat.completion.model.claude.PlainTextDocumentSource;
import org.eclipse.fennec.ai.chat.completion.model.claude.Role;
import org.eclipse.fennec.ai.chat.completion.model.claude.ServiceTier;
import org.eclipse.fennec.ai.chat.completion.model.claude.Skill;
import org.eclipse.fennec.ai.chat.completion.model.claude.SkillType;
import org.eclipse.fennec.ai.chat.completion.model.claude.SystemPrompt;
import org.eclipse.fennec.ai.chat.completion.model.claude.TextBlock;
import org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingConfig;
import org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingType;
import org.eclipse.fennec.ai.chat.completion.model.claude.Tool;
import org.eclipse.fennec.ai.chat.completion.model.claude.ToolChoice;
import org.eclipse.fennec.ai.chat.completion.model.claude.ToolResultBlock;
import org.eclipse.fennec.ai.chat.completion.model.claude.ToolToolChoice;
import org.eclipse.fennec.ai.chat.completion.model.claude.ToolUseBlock;
import org.eclipse.fennec.ai.chat.completion.model.claude.URLDocumentSource;
import org.eclipse.fennec.ai.chat.completion.model.claude.URLImageSource;
import org.eclipse.fennec.ai.chat.completion.model.claude.Usage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ClaudeChatCompletionPackageImpl extends EPackageImpl implements ClaudeChatCompletionPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass claudeRequestEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass usageEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass claudeResponseEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass systemPromptEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass messageEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass contentBlockEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass textBlockEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass imageBlockEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass imageSourceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass base64ImageSourceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass urlImageSourceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass documentBlockEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass documentSourceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass base64DocumentSourceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass plainTextDocumentSourceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass urlDocumentSourceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass toolUseBlockEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass mcpToolUseBlockEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass toolResultBlockEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass mcpToolResultBlockEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass toolEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass mcpServerEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass mcpToolConfigurationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass containerEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass skillEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass contextManagementConfigEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass contextEditEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass clearToolUsesEditEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass clearThinkingEditEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass clearTriggerEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass metadataEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass outputConfigEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass toolChoiceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass autoToolChoiceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass anyToolChoiceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass toolToolChoiceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass noneToolChoiceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass thinkingConfigEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass outputFormatEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass cacheControlEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass citationsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum roleEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum serviceTierEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum thinkingTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum skillTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum effortLevelEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private ClaudeChatCompletionPackageImpl() {
		super(eNS_URI, ClaudeChatCompletionFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link ClaudeChatCompletionPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static ClaudeChatCompletionPackage init() {
		if (isInited) return (ClaudeChatCompletionPackage)EPackage.Registry.INSTANCE.getEPackage(ClaudeChatCompletionPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredClaudeChatCompletionPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		ClaudeChatCompletionPackageImpl theClaudeChatCompletionPackage = registeredClaudeChatCompletionPackage instanceof ClaudeChatCompletionPackageImpl ? (ClaudeChatCompletionPackageImpl)registeredClaudeChatCompletionPackage : new ClaudeChatCompletionPackageImpl();

		isInited = true;

		// Create package meta-data objects
		theClaudeChatCompletionPackage.createPackageContents();

		// Initialize created meta-data
		theClaudeChatCompletionPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theClaudeChatCompletionPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(ClaudeChatCompletionPackage.eNS_URI, theClaudeChatCompletionPackage);
		return theClaudeChatCompletionPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getClaudeRequest() {
		return claudeRequestEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClaudeRequest_Model() {
		return (EAttribute)claudeRequestEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClaudeRequest_MaxTokens() {
		return (EAttribute)claudeRequestEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getClaudeRequest_Messages() {
		return (EReference)claudeRequestEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getClaudeRequest_System() {
		return (EReference)claudeRequestEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClaudeRequest_Temperature() {
		return (EAttribute)claudeRequestEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClaudeRequest_StopSequences() {
		return (EAttribute)claudeRequestEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getClaudeRequest_Tools() {
		return (EReference)claudeRequestEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getClaudeRequest_ToolChoice() {
		return (EReference)claudeRequestEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClaudeRequest_Stream() {
		return (EAttribute)claudeRequestEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getClaudeRequest_Thinking() {
		return (EReference)claudeRequestEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getClaudeRequest_OutputFormat() {
		return (EReference)claudeRequestEClass.getEStructuralFeatures().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClaudeRequest_ServiceTier() {
		return (EAttribute)claudeRequestEClass.getEStructuralFeatures().get(11);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getClaudeRequest_McpServers() {
		return (EReference)claudeRequestEClass.getEStructuralFeatures().get(12);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getClaudeRequest_Container() {
		return (EReference)claudeRequestEClass.getEStructuralFeatures().get(13);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getClaudeRequest_ContextManagement() {
		return (EReference)claudeRequestEClass.getEStructuralFeatures().get(14);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getClaudeRequest_Metadata() {
		return (EReference)claudeRequestEClass.getEStructuralFeatures().get(15);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getClaudeRequest_OutputConfig() {
		return (EReference)claudeRequestEClass.getEStructuralFeatures().get(16);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getUsage() {
		return usageEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getUsage_InputTokens() {
		return (EAttribute)usageEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getUsage_OutputTokens() {
		return (EAttribute)usageEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getUsage_CacheCreationInputTokens() {
		return (EAttribute)usageEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getUsage_CacheReadInputTokens() {
		return (EAttribute)usageEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getClaudeResponse() {
		return claudeResponseEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClaudeResponse_Id() {
		return (EAttribute)claudeResponseEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClaudeResponse_Type() {
		return (EAttribute)claudeResponseEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClaudeResponse_Role() {
		return (EAttribute)claudeResponseEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getClaudeResponse_Content() {
		return (EReference)claudeResponseEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClaudeResponse_Model() {
		return (EAttribute)claudeResponseEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClaudeResponse_StopReason() {
		return (EAttribute)claudeResponseEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClaudeResponse_StopSequence() {
		return (EAttribute)claudeResponseEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getClaudeResponse_Usage() {
		return (EReference)claudeResponseEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getSystemPrompt() {
		return systemPromptEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSystemPrompt_Text() {
		return (EAttribute)systemPromptEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getSystemPrompt_CacheControl() {
		return (EReference)systemPromptEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMessage() {
		return messageEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMessage_Role() {
		return (EAttribute)messageEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getMessage_Content() {
		return (EReference)messageEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getContentBlock() {
		return contentBlockEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getContentBlock_Type() {
		return (EAttribute)contentBlockEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getTextBlock() {
		return textBlockEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTextBlock_Text() {
		return (EAttribute)textBlockEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getTextBlock_CacheControl() {
		return (EReference)textBlockEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getTextBlock_Citations() {
		return (EReference)textBlockEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getImageBlock() {
		return imageBlockEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getImageBlock_Source() {
		return (EReference)imageBlockEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getImageBlock_CacheControl() {
		return (EReference)imageBlockEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getImageSource() {
		return imageSourceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getBase64ImageSource() {
		return base64ImageSourceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getBase64ImageSource_Type() {
		return (EAttribute)base64ImageSourceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getBase64ImageSource_MediaType() {
		return (EAttribute)base64ImageSourceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getBase64ImageSource_Data() {
		return (EAttribute)base64ImageSourceEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getURLImageSource() {
		return urlImageSourceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getURLImageSource_Type() {
		return (EAttribute)urlImageSourceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getURLImageSource_Url() {
		return (EAttribute)urlImageSourceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getDocumentBlock() {
		return documentBlockEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getDocumentBlock_Source() {
		return (EReference)documentBlockEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getDocumentBlock_Title() {
		return (EAttribute)documentBlockEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getDocumentBlock_Context() {
		return (EAttribute)documentBlockEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getDocumentBlock_Citations() {
		return (EReference)documentBlockEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getDocumentBlock_CacheControl() {
		return (EReference)documentBlockEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getDocumentSource() {
		return documentSourceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getBase64DocumentSource() {
		return base64DocumentSourceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getBase64DocumentSource_Type() {
		return (EAttribute)base64DocumentSourceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getBase64DocumentSource_MediaType() {
		return (EAttribute)base64DocumentSourceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getBase64DocumentSource_Data() {
		return (EAttribute)base64DocumentSourceEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPlainTextDocumentSource() {
		return plainTextDocumentSourceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPlainTextDocumentSource_Type() {
		return (EAttribute)plainTextDocumentSourceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPlainTextDocumentSource_Text() {
		return (EAttribute)plainTextDocumentSourceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getURLDocumentSource() {
		return urlDocumentSourceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getURLDocumentSource_Type() {
		return (EAttribute)urlDocumentSourceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getURLDocumentSource_Url() {
		return (EAttribute)urlDocumentSourceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getToolUseBlock() {
		return toolUseBlockEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getToolUseBlock_Id() {
		return (EAttribute)toolUseBlockEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getToolUseBlock_Name() {
		return (EAttribute)toolUseBlockEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getToolUseBlock_Input() {
		return (EAttribute)toolUseBlockEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getToolUseBlock_Caller() {
		return (EAttribute)toolUseBlockEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMCPToolUseBlock() {
		return mcpToolUseBlockEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMCPToolUseBlock_Id() {
		return (EAttribute)mcpToolUseBlockEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMCPToolUseBlock_Name() {
		return (EAttribute)mcpToolUseBlockEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMCPToolUseBlock_ServerName() {
		return (EAttribute)mcpToolUseBlockEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMCPToolUseBlock_Input() {
		return (EAttribute)mcpToolUseBlockEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMCPToolUseBlock_Caller() {
		return (EAttribute)mcpToolUseBlockEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getMCPToolUseBlock_CacheControl() {
		return (EReference)mcpToolUseBlockEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getToolResultBlock() {
		return toolResultBlockEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getToolResultBlock_ToolUseId() {
		return (EAttribute)toolResultBlockEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getToolResultBlock_Content() {
		return (EReference)toolResultBlockEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getToolResultBlock_IsError() {
		return (EAttribute)toolResultBlockEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMCPToolResultBlock() {
		return mcpToolResultBlockEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMCPToolResultBlock_ToolUseId() {
		return (EAttribute)mcpToolResultBlockEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getMCPToolResultBlock_Content() {
		return (EReference)mcpToolResultBlockEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMCPToolResultBlock_IsError() {
		return (EAttribute)mcpToolResultBlockEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getMCPToolResultBlock_CacheControl() {
		return (EReference)mcpToolResultBlockEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getTool() {
		return toolEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTool_Name() {
		return (EAttribute)toolEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTool_Description() {
		return (EAttribute)toolEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTool_InputSchema() {
		return (EAttribute)toolEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTool_Type() {
		return (EAttribute)toolEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTool_AllowedCallers() {
		return (EAttribute)toolEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTool_DeferLoading() {
		return (EAttribute)toolEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMCPServer() {
		return mcpServerEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMCPServer_Name() {
		return (EAttribute)mcpServerEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMCPServer_Type() {
		return (EAttribute)mcpServerEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMCPServer_Url() {
		return (EAttribute)mcpServerEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMCPServer_AuthorizationToken() {
		return (EAttribute)mcpServerEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getMCPServer_ToolConfiguration() {
		return (EReference)mcpServerEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMCPToolConfiguration() {
		return mcpToolConfigurationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMCPToolConfiguration_Enabled() {
		return (EAttribute)mcpToolConfigurationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMCPToolConfiguration_AllowedTools() {
		return (EAttribute)mcpToolConfigurationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getContainer() {
		return containerEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getContainer_Id() {
		return (EAttribute)containerEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getContainer_Skills() {
		return (EReference)containerEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getSkill() {
		return skillEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSkill_SkillId() {
		return (EAttribute)skillEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSkill_Type() {
		return (EAttribute)skillEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSkill_Version() {
		return (EAttribute)skillEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getContextManagementConfig() {
		return contextManagementConfigEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getContextManagementConfig_Edits() {
		return (EReference)contextManagementConfigEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getContextEdit() {
		return contextEditEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getContextEdit_Type() {
		return (EAttribute)contextEditEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getClearToolUsesEdit() {
		return clearToolUsesEditEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClearToolUsesEdit_ClearAtLeast() {
		return (EAttribute)clearToolUsesEditEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClearToolUsesEdit_ClearToolInputsAll() {
		return (EAttribute)clearToolUsesEditEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClearToolUsesEdit_ClearToolInputsSpecific() {
		return (EAttribute)clearToolUsesEditEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClearToolUsesEdit_ExcludeTools() {
		return (EAttribute)clearToolUsesEditEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClearToolUsesEdit_Keep() {
		return (EAttribute)clearToolUsesEditEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getClearToolUsesEdit_Trigger() {
		return (EReference)clearToolUsesEditEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getClearThinkingEdit() {
		return clearThinkingEditEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClearThinkingEdit_KeepRecent() {
		return (EAttribute)clearThinkingEditEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClearThinkingEdit_KeepAll() {
		return (EAttribute)clearThinkingEditEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getClearTrigger() {
		return clearTriggerEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClearTrigger_InputTokens() {
		return (EAttribute)clearTriggerEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getClearTrigger_ToolUsesCount() {
		return (EAttribute)clearTriggerEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMetadata() {
		return metadataEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMetadata_UserId() {
		return (EAttribute)metadataEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getOutputConfig() {
		return outputConfigEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getOutputConfig_Effort() {
		return (EAttribute)outputConfigEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getToolChoice() {
		return toolChoiceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getToolChoice_Type() {
		return (EAttribute)toolChoiceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getToolChoice_DisableParallelToolUse() {
		return (EAttribute)toolChoiceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAutoToolChoice() {
		return autoToolChoiceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAnyToolChoice() {
		return anyToolChoiceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getToolToolChoice() {
		return toolToolChoiceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getToolToolChoice_Name() {
		return (EAttribute)toolToolChoiceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getNoneToolChoice() {
		return noneToolChoiceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getThinkingConfig() {
		return thinkingConfigEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getThinkingConfig_Type() {
		return (EAttribute)thinkingConfigEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getThinkingConfig_BudgetTokens() {
		return (EAttribute)thinkingConfigEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getOutputFormat() {
		return outputFormatEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getOutputFormat_Type() {
		return (EAttribute)outputFormatEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getOutputFormat_Schema() {
		return (EAttribute)outputFormatEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getCacheControl() {
		return cacheControlEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCacheControl_Type() {
		return (EAttribute)cacheControlEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCacheControl_Ttl() {
		return (EAttribute)cacheControlEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getCitations() {
		return citationsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCitations_Enabled() {
		return (EAttribute)citationsEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getRole() {
		return roleEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getServiceTier() {
		return serviceTierEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getThinkingType() {
		return thinkingTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getSkillType() {
		return skillTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getEffortLevel() {
		return effortLevelEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ClaudeChatCompletionFactory getClaudeChatCompletionFactory() {
		return (ClaudeChatCompletionFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		claudeRequestEClass = createEClass(CLAUDE_REQUEST);
		createEAttribute(claudeRequestEClass, CLAUDE_REQUEST__MODEL);
		createEAttribute(claudeRequestEClass, CLAUDE_REQUEST__MAX_TOKENS);
		createEReference(claudeRequestEClass, CLAUDE_REQUEST__MESSAGES);
		createEReference(claudeRequestEClass, CLAUDE_REQUEST__SYSTEM);
		createEAttribute(claudeRequestEClass, CLAUDE_REQUEST__TEMPERATURE);
		createEAttribute(claudeRequestEClass, CLAUDE_REQUEST__STOP_SEQUENCES);
		createEReference(claudeRequestEClass, CLAUDE_REQUEST__TOOLS);
		createEReference(claudeRequestEClass, CLAUDE_REQUEST__TOOL_CHOICE);
		createEAttribute(claudeRequestEClass, CLAUDE_REQUEST__STREAM);
		createEReference(claudeRequestEClass, CLAUDE_REQUEST__THINKING);
		createEReference(claudeRequestEClass, CLAUDE_REQUEST__OUTPUT_FORMAT);
		createEAttribute(claudeRequestEClass, CLAUDE_REQUEST__SERVICE_TIER);
		createEReference(claudeRequestEClass, CLAUDE_REQUEST__MCP_SERVERS);
		createEReference(claudeRequestEClass, CLAUDE_REQUEST__CONTAINER);
		createEReference(claudeRequestEClass, CLAUDE_REQUEST__CONTEXT_MANAGEMENT);
		createEReference(claudeRequestEClass, CLAUDE_REQUEST__METADATA);
		createEReference(claudeRequestEClass, CLAUDE_REQUEST__OUTPUT_CONFIG);

		usageEClass = createEClass(USAGE);
		createEAttribute(usageEClass, USAGE__INPUT_TOKENS);
		createEAttribute(usageEClass, USAGE__OUTPUT_TOKENS);
		createEAttribute(usageEClass, USAGE__CACHE_CREATION_INPUT_TOKENS);
		createEAttribute(usageEClass, USAGE__CACHE_READ_INPUT_TOKENS);

		claudeResponseEClass = createEClass(CLAUDE_RESPONSE);
		createEAttribute(claudeResponseEClass, CLAUDE_RESPONSE__ID);
		createEAttribute(claudeResponseEClass, CLAUDE_RESPONSE__TYPE);
		createEAttribute(claudeResponseEClass, CLAUDE_RESPONSE__ROLE);
		createEReference(claudeResponseEClass, CLAUDE_RESPONSE__CONTENT);
		createEAttribute(claudeResponseEClass, CLAUDE_RESPONSE__MODEL);
		createEAttribute(claudeResponseEClass, CLAUDE_RESPONSE__STOP_REASON);
		createEAttribute(claudeResponseEClass, CLAUDE_RESPONSE__STOP_SEQUENCE);
		createEReference(claudeResponseEClass, CLAUDE_RESPONSE__USAGE);

		systemPromptEClass = createEClass(SYSTEM_PROMPT);
		createEAttribute(systemPromptEClass, SYSTEM_PROMPT__TEXT);
		createEReference(systemPromptEClass, SYSTEM_PROMPT__CACHE_CONTROL);

		messageEClass = createEClass(MESSAGE);
		createEAttribute(messageEClass, MESSAGE__ROLE);
		createEReference(messageEClass, MESSAGE__CONTENT);

		contentBlockEClass = createEClass(CONTENT_BLOCK);
		createEAttribute(contentBlockEClass, CONTENT_BLOCK__TYPE);

		textBlockEClass = createEClass(TEXT_BLOCK);
		createEAttribute(textBlockEClass, TEXT_BLOCK__TEXT);
		createEReference(textBlockEClass, TEXT_BLOCK__CACHE_CONTROL);
		createEReference(textBlockEClass, TEXT_BLOCK__CITATIONS);

		imageBlockEClass = createEClass(IMAGE_BLOCK);
		createEReference(imageBlockEClass, IMAGE_BLOCK__SOURCE);
		createEReference(imageBlockEClass, IMAGE_BLOCK__CACHE_CONTROL);

		imageSourceEClass = createEClass(IMAGE_SOURCE);

		base64ImageSourceEClass = createEClass(BASE64_IMAGE_SOURCE);
		createEAttribute(base64ImageSourceEClass, BASE64_IMAGE_SOURCE__TYPE);
		createEAttribute(base64ImageSourceEClass, BASE64_IMAGE_SOURCE__MEDIA_TYPE);
		createEAttribute(base64ImageSourceEClass, BASE64_IMAGE_SOURCE__DATA);

		urlImageSourceEClass = createEClass(URL_IMAGE_SOURCE);
		createEAttribute(urlImageSourceEClass, URL_IMAGE_SOURCE__TYPE);
		createEAttribute(urlImageSourceEClass, URL_IMAGE_SOURCE__URL);

		documentBlockEClass = createEClass(DOCUMENT_BLOCK);
		createEReference(documentBlockEClass, DOCUMENT_BLOCK__SOURCE);
		createEAttribute(documentBlockEClass, DOCUMENT_BLOCK__TITLE);
		createEAttribute(documentBlockEClass, DOCUMENT_BLOCK__CONTEXT);
		createEReference(documentBlockEClass, DOCUMENT_BLOCK__CITATIONS);
		createEReference(documentBlockEClass, DOCUMENT_BLOCK__CACHE_CONTROL);

		documentSourceEClass = createEClass(DOCUMENT_SOURCE);

		base64DocumentSourceEClass = createEClass(BASE64_DOCUMENT_SOURCE);
		createEAttribute(base64DocumentSourceEClass, BASE64_DOCUMENT_SOURCE__TYPE);
		createEAttribute(base64DocumentSourceEClass, BASE64_DOCUMENT_SOURCE__MEDIA_TYPE);
		createEAttribute(base64DocumentSourceEClass, BASE64_DOCUMENT_SOURCE__DATA);

		plainTextDocumentSourceEClass = createEClass(PLAIN_TEXT_DOCUMENT_SOURCE);
		createEAttribute(plainTextDocumentSourceEClass, PLAIN_TEXT_DOCUMENT_SOURCE__TYPE);
		createEAttribute(plainTextDocumentSourceEClass, PLAIN_TEXT_DOCUMENT_SOURCE__TEXT);

		urlDocumentSourceEClass = createEClass(URL_DOCUMENT_SOURCE);
		createEAttribute(urlDocumentSourceEClass, URL_DOCUMENT_SOURCE__TYPE);
		createEAttribute(urlDocumentSourceEClass, URL_DOCUMENT_SOURCE__URL);

		toolUseBlockEClass = createEClass(TOOL_USE_BLOCK);
		createEAttribute(toolUseBlockEClass, TOOL_USE_BLOCK__ID);
		createEAttribute(toolUseBlockEClass, TOOL_USE_BLOCK__NAME);
		createEAttribute(toolUseBlockEClass, TOOL_USE_BLOCK__INPUT);
		createEAttribute(toolUseBlockEClass, TOOL_USE_BLOCK__CALLER);

		mcpToolUseBlockEClass = createEClass(MCP_TOOL_USE_BLOCK);
		createEAttribute(mcpToolUseBlockEClass, MCP_TOOL_USE_BLOCK__ID);
		createEAttribute(mcpToolUseBlockEClass, MCP_TOOL_USE_BLOCK__NAME);
		createEAttribute(mcpToolUseBlockEClass, MCP_TOOL_USE_BLOCK__SERVER_NAME);
		createEAttribute(mcpToolUseBlockEClass, MCP_TOOL_USE_BLOCK__INPUT);
		createEAttribute(mcpToolUseBlockEClass, MCP_TOOL_USE_BLOCK__CALLER);
		createEReference(mcpToolUseBlockEClass, MCP_TOOL_USE_BLOCK__CACHE_CONTROL);

		toolResultBlockEClass = createEClass(TOOL_RESULT_BLOCK);
		createEAttribute(toolResultBlockEClass, TOOL_RESULT_BLOCK__TOOL_USE_ID);
		createEReference(toolResultBlockEClass, TOOL_RESULT_BLOCK__CONTENT);
		createEAttribute(toolResultBlockEClass, TOOL_RESULT_BLOCK__IS_ERROR);

		mcpToolResultBlockEClass = createEClass(MCP_TOOL_RESULT_BLOCK);
		createEAttribute(mcpToolResultBlockEClass, MCP_TOOL_RESULT_BLOCK__TOOL_USE_ID);
		createEReference(mcpToolResultBlockEClass, MCP_TOOL_RESULT_BLOCK__CONTENT);
		createEAttribute(mcpToolResultBlockEClass, MCP_TOOL_RESULT_BLOCK__IS_ERROR);
		createEReference(mcpToolResultBlockEClass, MCP_TOOL_RESULT_BLOCK__CACHE_CONTROL);

		toolEClass = createEClass(TOOL);
		createEAttribute(toolEClass, TOOL__NAME);
		createEAttribute(toolEClass, TOOL__DESCRIPTION);
		createEAttribute(toolEClass, TOOL__INPUT_SCHEMA);
		createEAttribute(toolEClass, TOOL__TYPE);
		createEAttribute(toolEClass, TOOL__ALLOWED_CALLERS);
		createEAttribute(toolEClass, TOOL__DEFER_LOADING);

		mcpServerEClass = createEClass(MCP_SERVER);
		createEAttribute(mcpServerEClass, MCP_SERVER__NAME);
		createEAttribute(mcpServerEClass, MCP_SERVER__TYPE);
		createEAttribute(mcpServerEClass, MCP_SERVER__URL);
		createEAttribute(mcpServerEClass, MCP_SERVER__AUTHORIZATION_TOKEN);
		createEReference(mcpServerEClass, MCP_SERVER__TOOL_CONFIGURATION);

		mcpToolConfigurationEClass = createEClass(MCP_TOOL_CONFIGURATION);
		createEAttribute(mcpToolConfigurationEClass, MCP_TOOL_CONFIGURATION__ENABLED);
		createEAttribute(mcpToolConfigurationEClass, MCP_TOOL_CONFIGURATION__ALLOWED_TOOLS);

		containerEClass = createEClass(CONTAINER);
		createEAttribute(containerEClass, CONTAINER__ID);
		createEReference(containerEClass, CONTAINER__SKILLS);

		skillEClass = createEClass(SKILL);
		createEAttribute(skillEClass, SKILL__SKILL_ID);
		createEAttribute(skillEClass, SKILL__TYPE);
		createEAttribute(skillEClass, SKILL__VERSION);

		contextManagementConfigEClass = createEClass(CONTEXT_MANAGEMENT_CONFIG);
		createEReference(contextManagementConfigEClass, CONTEXT_MANAGEMENT_CONFIG__EDITS);

		contextEditEClass = createEClass(CONTEXT_EDIT);
		createEAttribute(contextEditEClass, CONTEXT_EDIT__TYPE);

		clearToolUsesEditEClass = createEClass(CLEAR_TOOL_USES_EDIT);
		createEAttribute(clearToolUsesEditEClass, CLEAR_TOOL_USES_EDIT__CLEAR_AT_LEAST);
		createEAttribute(clearToolUsesEditEClass, CLEAR_TOOL_USES_EDIT__CLEAR_TOOL_INPUTS_ALL);
		createEAttribute(clearToolUsesEditEClass, CLEAR_TOOL_USES_EDIT__CLEAR_TOOL_INPUTS_SPECIFIC);
		createEAttribute(clearToolUsesEditEClass, CLEAR_TOOL_USES_EDIT__EXCLUDE_TOOLS);
		createEAttribute(clearToolUsesEditEClass, CLEAR_TOOL_USES_EDIT__KEEP);
		createEReference(clearToolUsesEditEClass, CLEAR_TOOL_USES_EDIT__TRIGGER);

		clearThinkingEditEClass = createEClass(CLEAR_THINKING_EDIT);
		createEAttribute(clearThinkingEditEClass, CLEAR_THINKING_EDIT__KEEP_RECENT);
		createEAttribute(clearThinkingEditEClass, CLEAR_THINKING_EDIT__KEEP_ALL);

		clearTriggerEClass = createEClass(CLEAR_TRIGGER);
		createEAttribute(clearTriggerEClass, CLEAR_TRIGGER__INPUT_TOKENS);
		createEAttribute(clearTriggerEClass, CLEAR_TRIGGER__TOOL_USES_COUNT);

		metadataEClass = createEClass(METADATA);
		createEAttribute(metadataEClass, METADATA__USER_ID);

		outputConfigEClass = createEClass(OUTPUT_CONFIG);
		createEAttribute(outputConfigEClass, OUTPUT_CONFIG__EFFORT);

		toolChoiceEClass = createEClass(TOOL_CHOICE);
		createEAttribute(toolChoiceEClass, TOOL_CHOICE__TYPE);
		createEAttribute(toolChoiceEClass, TOOL_CHOICE__DISABLE_PARALLEL_TOOL_USE);

		autoToolChoiceEClass = createEClass(AUTO_TOOL_CHOICE);

		anyToolChoiceEClass = createEClass(ANY_TOOL_CHOICE);

		toolToolChoiceEClass = createEClass(TOOL_TOOL_CHOICE);
		createEAttribute(toolToolChoiceEClass, TOOL_TOOL_CHOICE__NAME);

		noneToolChoiceEClass = createEClass(NONE_TOOL_CHOICE);

		thinkingConfigEClass = createEClass(THINKING_CONFIG);
		createEAttribute(thinkingConfigEClass, THINKING_CONFIG__TYPE);
		createEAttribute(thinkingConfigEClass, THINKING_CONFIG__BUDGET_TOKENS);

		outputFormatEClass = createEClass(OUTPUT_FORMAT);
		createEAttribute(outputFormatEClass, OUTPUT_FORMAT__TYPE);
		createEAttribute(outputFormatEClass, OUTPUT_FORMAT__SCHEMA);

		cacheControlEClass = createEClass(CACHE_CONTROL);
		createEAttribute(cacheControlEClass, CACHE_CONTROL__TYPE);
		createEAttribute(cacheControlEClass, CACHE_CONTROL__TTL);

		citationsEClass = createEClass(CITATIONS);
		createEAttribute(citationsEClass, CITATIONS__ENABLED);

		// Create enums
		roleEEnum = createEEnum(ROLE);
		serviceTierEEnum = createEEnum(SERVICE_TIER);
		thinkingTypeEEnum = createEEnum(THINKING_TYPE);
		skillTypeEEnum = createEEnum(SKILL_TYPE);
		effortLevelEEnum = createEEnum(EFFORT_LEVEL);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		textBlockEClass.getESuperTypes().add(this.getContentBlock());
		imageBlockEClass.getESuperTypes().add(this.getContentBlock());
		base64ImageSourceEClass.getESuperTypes().add(this.getImageSource());
		urlImageSourceEClass.getESuperTypes().add(this.getImageSource());
		documentBlockEClass.getESuperTypes().add(this.getContentBlock());
		base64DocumentSourceEClass.getESuperTypes().add(this.getDocumentSource());
		plainTextDocumentSourceEClass.getESuperTypes().add(this.getDocumentSource());
		urlDocumentSourceEClass.getESuperTypes().add(this.getDocumentSource());
		toolUseBlockEClass.getESuperTypes().add(this.getContentBlock());
		mcpToolUseBlockEClass.getESuperTypes().add(this.getContentBlock());
		toolResultBlockEClass.getESuperTypes().add(this.getContentBlock());
		mcpToolResultBlockEClass.getESuperTypes().add(this.getContentBlock());
		clearToolUsesEditEClass.getESuperTypes().add(this.getContextEdit());
		clearThinkingEditEClass.getESuperTypes().add(this.getContextEdit());
		autoToolChoiceEClass.getESuperTypes().add(this.getToolChoice());
		anyToolChoiceEClass.getESuperTypes().add(this.getToolChoice());
		toolToolChoiceEClass.getESuperTypes().add(this.getToolChoice());
		noneToolChoiceEClass.getESuperTypes().add(this.getToolChoice());

		// Initialize classes, features, and operations; add parameters
		initEClass(claudeRequestEClass, ClaudeRequest.class, "ClaudeRequest", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getClaudeRequest_Model(), ecorePackage.getEString(), "model", null, 1, 1, ClaudeRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getClaudeRequest_MaxTokens(), ecorePackage.getEInt(), "maxTokens", null, 1, 1, ClaudeRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getClaudeRequest_Messages(), this.getMessage(), null, "messages", null, 1, -1, ClaudeRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getClaudeRequest_System(), this.getSystemPrompt(), null, "system", null, 0, -1, ClaudeRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getClaudeRequest_Temperature(), ecorePackage.getEDouble(), "temperature", "1.0", 0, 1, ClaudeRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getClaudeRequest_StopSequences(), ecorePackage.getEString(), "stopSequences", null, 0, -1, ClaudeRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getClaudeRequest_Tools(), this.getTool(), null, "tools", null, 0, -1, ClaudeRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getClaudeRequest_ToolChoice(), this.getToolChoice(), null, "toolChoice", null, 0, 1, ClaudeRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getClaudeRequest_Stream(), ecorePackage.getEBoolean(), "stream", "false", 0, 1, ClaudeRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getClaudeRequest_Thinking(), this.getThinkingConfig(), null, "thinking", null, 0, 1, ClaudeRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getClaudeRequest_OutputFormat(), this.getOutputFormat(), null, "outputFormat", null, 0, 1, ClaudeRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getClaudeRequest_ServiceTier(), this.getServiceTier(), "serviceTier", null, 0, 1, ClaudeRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getClaudeRequest_McpServers(), this.getMCPServer(), null, "mcpServers", null, 0, -1, ClaudeRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getClaudeRequest_Container(), this.getContainer(), null, "container", null, 0, 1, ClaudeRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getClaudeRequest_ContextManagement(), this.getContextManagementConfig(), null, "contextManagement", null, 0, 1, ClaudeRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getClaudeRequest_Metadata(), this.getMetadata(), null, "metadata", null, 0, 1, ClaudeRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getClaudeRequest_OutputConfig(), this.getOutputConfig(), null, "outputConfig", null, 0, 1, ClaudeRequest.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(usageEClass, Usage.class, "Usage", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getUsage_InputTokens(), ecorePackage.getEInt(), "inputTokens", null, 1, 1, Usage.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getUsage_OutputTokens(), ecorePackage.getEInt(), "outputTokens", null, 1, 1, Usage.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getUsage_CacheCreationInputTokens(), ecorePackage.getEInt(), "cacheCreationInputTokens", null, 0, 1, Usage.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getUsage_CacheReadInputTokens(), ecorePackage.getEInt(), "cacheReadInputTokens", null, 0, 1, Usage.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(claudeResponseEClass, ClaudeResponse.class, "ClaudeResponse", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getClaudeResponse_Id(), ecorePackage.getEString(), "id", null, 1, 1, ClaudeResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getClaudeResponse_Type(), ecorePackage.getEString(), "type", "message", 1, 1, ClaudeResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getClaudeResponse_Role(), this.getRole(), "role", "assistant", 1, 1, ClaudeResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getClaudeResponse_Content(), this.getContentBlock(), null, "content", null, 1, -1, ClaudeResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getClaudeResponse_Model(), ecorePackage.getEString(), "model", null, 1, 1, ClaudeResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getClaudeResponse_StopReason(), ecorePackage.getEString(), "stopReason", null, 1, 1, ClaudeResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getClaudeResponse_StopSequence(), ecorePackage.getEString(), "stopSequence", null, 0, 1, ClaudeResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getClaudeResponse_Usage(), this.getUsage(), null, "usage", null, 1, 1, ClaudeResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(systemPromptEClass, SystemPrompt.class, "SystemPrompt", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getSystemPrompt_Text(), ecorePackage.getEString(), "text", null, 1, 1, SystemPrompt.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getSystemPrompt_CacheControl(), this.getCacheControl(), null, "cacheControl", null, 0, 1, SystemPrompt.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(messageEClass, Message.class, "Message", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMessage_Role(), this.getRole(), "role", null, 1, 1, Message.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getMessage_Content(), this.getContentBlock(), null, "content", null, 1, -1, Message.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(contentBlockEClass, ContentBlock.class, "ContentBlock", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getContentBlock_Type(), ecorePackage.getEString(), "type", null, 1, 1, ContentBlock.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, IS_DERIVED, IS_ORDERED);

		initEClass(textBlockEClass, TextBlock.class, "TextBlock", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTextBlock_Text(), ecorePackage.getEString(), "text", null, 1, 1, TextBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTextBlock_CacheControl(), this.getCacheControl(), null, "cacheControl", null, 0, 1, TextBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTextBlock_Citations(), this.getCitations(), null, "citations", null, 0, 1, TextBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(imageBlockEClass, ImageBlock.class, "ImageBlock", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getImageBlock_Source(), this.getImageSource(), null, "source", null, 1, 1, ImageBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getImageBlock_CacheControl(), this.getCacheControl(), null, "cacheControl", null, 0, 1, ImageBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(imageSourceEClass, ImageSource.class, "ImageSource", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(base64ImageSourceEClass, Base64ImageSource.class, "Base64ImageSource", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getBase64ImageSource_Type(), ecorePackage.getEString(), "type", "base64", 1, 1, Base64ImageSource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getBase64ImageSource_MediaType(), ecorePackage.getEString(), "mediaType", null, 1, 1, Base64ImageSource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getBase64ImageSource_Data(), ecorePackage.getEString(), "data", null, 1, 1, Base64ImageSource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(urlImageSourceEClass, URLImageSource.class, "URLImageSource", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getURLImageSource_Type(), ecorePackage.getEString(), "type", "url", 1, 1, URLImageSource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getURLImageSource_Url(), ecorePackage.getEString(), "url", null, 1, 1, URLImageSource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(documentBlockEClass, DocumentBlock.class, "DocumentBlock", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getDocumentBlock_Source(), this.getDocumentSource(), null, "source", null, 1, 1, DocumentBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDocumentBlock_Title(), ecorePackage.getEString(), "title", null, 0, 1, DocumentBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDocumentBlock_Context(), ecorePackage.getEString(), "context", null, 0, 1, DocumentBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentBlock_Citations(), this.getCitations(), null, "citations", null, 0, 1, DocumentBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentBlock_CacheControl(), this.getCacheControl(), null, "cacheControl", null, 0, 1, DocumentBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(documentSourceEClass, DocumentSource.class, "DocumentSource", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(base64DocumentSourceEClass, Base64DocumentSource.class, "Base64DocumentSource", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getBase64DocumentSource_Type(), ecorePackage.getEString(), "type", "base64", 1, 1, Base64DocumentSource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getBase64DocumentSource_MediaType(), ecorePackage.getEString(), "mediaType", null, 1, 1, Base64DocumentSource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getBase64DocumentSource_Data(), ecorePackage.getEString(), "data", null, 1, 1, Base64DocumentSource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(plainTextDocumentSourceEClass, PlainTextDocumentSource.class, "PlainTextDocumentSource", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPlainTextDocumentSource_Type(), ecorePackage.getEString(), "type", "text", 1, 1, PlainTextDocumentSource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPlainTextDocumentSource_Text(), ecorePackage.getEString(), "text", null, 1, 1, PlainTextDocumentSource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(urlDocumentSourceEClass, URLDocumentSource.class, "URLDocumentSource", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getURLDocumentSource_Type(), ecorePackage.getEString(), "type", "url", 1, 1, URLDocumentSource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getURLDocumentSource_Url(), ecorePackage.getEString(), "url", null, 1, 1, URLDocumentSource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(toolUseBlockEClass, ToolUseBlock.class, "ToolUseBlock", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getToolUseBlock_Id(), ecorePackage.getEString(), "id", null, 1, 1, ToolUseBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getToolUseBlock_Name(), ecorePackage.getEString(), "name", null, 1, 1, ToolUseBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getToolUseBlock_Input(), ecorePackage.getEString(), "input", null, 1, 1, ToolUseBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getToolUseBlock_Caller(), ecorePackage.getEString(), "caller", null, 0, 1, ToolUseBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(mcpToolUseBlockEClass, MCPToolUseBlock.class, "MCPToolUseBlock", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMCPToolUseBlock_Id(), ecorePackage.getEString(), "id", null, 1, 1, MCPToolUseBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMCPToolUseBlock_Name(), ecorePackage.getEString(), "name", null, 1, 1, MCPToolUseBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMCPToolUseBlock_ServerName(), ecorePackage.getEString(), "serverName", null, 1, 1, MCPToolUseBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMCPToolUseBlock_Input(), ecorePackage.getEString(), "input", null, 1, 1, MCPToolUseBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMCPToolUseBlock_Caller(), ecorePackage.getEString(), "caller", null, 0, 1, MCPToolUseBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getMCPToolUseBlock_CacheControl(), this.getCacheControl(), null, "cacheControl", null, 0, 1, MCPToolUseBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(toolResultBlockEClass, ToolResultBlock.class, "ToolResultBlock", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getToolResultBlock_ToolUseId(), ecorePackage.getEString(), "toolUseId", null, 1, 1, ToolResultBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getToolResultBlock_Content(), this.getContentBlock(), null, "content", null, 0, -1, ToolResultBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getToolResultBlock_IsError(), ecorePackage.getEBoolean(), "isError", "false", 0, 1, ToolResultBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(mcpToolResultBlockEClass, MCPToolResultBlock.class, "MCPToolResultBlock", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMCPToolResultBlock_ToolUseId(), ecorePackage.getEString(), "toolUseId", null, 1, 1, MCPToolResultBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getMCPToolResultBlock_Content(), this.getContentBlock(), null, "content", null, 0, -1, MCPToolResultBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMCPToolResultBlock_IsError(), ecorePackage.getEBoolean(), "isError", "false", 0, 1, MCPToolResultBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getMCPToolResultBlock_CacheControl(), this.getCacheControl(), null, "cacheControl", null, 0, 1, MCPToolResultBlock.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(toolEClass, Tool.class, "Tool", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTool_Name(), ecorePackage.getEString(), "name", null, 1, 1, Tool.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTool_Description(), ecorePackage.getEString(), "description", null, 0, 1, Tool.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTool_InputSchema(), ecorePackage.getEString(), "inputSchema", null, 1, 1, Tool.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTool_Type(), ecorePackage.getEString(), "type", "custom", 0, 1, Tool.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTool_AllowedCallers(), ecorePackage.getEString(), "allowedCallers", null, 0, -1, Tool.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTool_DeferLoading(), ecorePackage.getEBoolean(), "deferLoading", "false", 0, 1, Tool.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(mcpServerEClass, MCPServer.class, "MCPServer", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMCPServer_Name(), ecorePackage.getEString(), "name", null, 1, 1, MCPServer.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMCPServer_Type(), ecorePackage.getEString(), "type", "url", 1, 1, MCPServer.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMCPServer_Url(), ecorePackage.getEString(), "url", null, 1, 1, MCPServer.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMCPServer_AuthorizationToken(), ecorePackage.getEString(), "authorizationToken", null, 0, 1, MCPServer.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getMCPServer_ToolConfiguration(), this.getMCPToolConfiguration(), null, "toolConfiguration", null, 0, 1, MCPServer.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(mcpToolConfigurationEClass, MCPToolConfiguration.class, "MCPToolConfiguration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMCPToolConfiguration_Enabled(), ecorePackage.getEBoolean(), "enabled", "true", 0, 1, MCPToolConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMCPToolConfiguration_AllowedTools(), ecorePackage.getEString(), "allowedTools", null, 0, -1, MCPToolConfiguration.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(containerEClass, org.eclipse.fennec.ai.chat.completion.model.claude.Container.class, "Container", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getContainer_Id(), ecorePackage.getEString(), "id", null, 0, 1, org.eclipse.fennec.ai.chat.completion.model.claude.Container.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getContainer_Skills(), this.getSkill(), null, "skills", null, 0, -1, org.eclipse.fennec.ai.chat.completion.model.claude.Container.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(skillEClass, Skill.class, "Skill", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getSkill_SkillId(), ecorePackage.getEString(), "skillId", null, 1, 1, Skill.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSkill_Type(), this.getSkillType(), "type", null, 1, 1, Skill.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSkill_Version(), ecorePackage.getEString(), "version", null, 0, 1, Skill.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(contextManagementConfigEClass, ContextManagementConfig.class, "ContextManagementConfig", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getContextManagementConfig_Edits(), this.getContextEdit(), null, "edits", null, 0, -1, ContextManagementConfig.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(contextEditEClass, ContextEdit.class, "ContextEdit", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getContextEdit_Type(), ecorePackage.getEString(), "type", null, 1, 1, ContextEdit.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, IS_DERIVED, IS_ORDERED);

		initEClass(clearToolUsesEditEClass, ClearToolUsesEdit.class, "ClearToolUsesEdit", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getClearToolUsesEdit_ClearAtLeast(), ecorePackage.getEInt(), "clearAtLeast", null, 0, 1, ClearToolUsesEdit.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getClearToolUsesEdit_ClearToolInputsAll(), ecorePackage.getEBoolean(), "clearToolInputsAll", null, 0, 1, ClearToolUsesEdit.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getClearToolUsesEdit_ClearToolInputsSpecific(), ecorePackage.getEString(), "clearToolInputsSpecific", null, 0, -1, ClearToolUsesEdit.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getClearToolUsesEdit_ExcludeTools(), ecorePackage.getEString(), "excludeTools", null, 0, -1, ClearToolUsesEdit.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getClearToolUsesEdit_Keep(), ecorePackage.getEInt(), "keep", null, 0, 1, ClearToolUsesEdit.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getClearToolUsesEdit_Trigger(), this.getClearTrigger(), null, "trigger", null, 0, 1, ClearToolUsesEdit.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(clearThinkingEditEClass, ClearThinkingEdit.class, "ClearThinkingEdit", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getClearThinkingEdit_KeepRecent(), ecorePackage.getEInt(), "keepRecent", null, 0, 1, ClearThinkingEdit.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getClearThinkingEdit_KeepAll(), ecorePackage.getEBoolean(), "keepAll", null, 0, 1, ClearThinkingEdit.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(clearTriggerEClass, ClearTrigger.class, "ClearTrigger", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getClearTrigger_InputTokens(), ecorePackage.getEInt(), "inputTokens", null, 0, 1, ClearTrigger.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getClearTrigger_ToolUsesCount(), ecorePackage.getEInt(), "toolUsesCount", null, 0, 1, ClearTrigger.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(metadataEClass, Metadata.class, "Metadata", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMetadata_UserId(), ecorePackage.getEString(), "userId", null, 0, 1, Metadata.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(outputConfigEClass, OutputConfig.class, "OutputConfig", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getOutputConfig_Effort(), this.getEffortLevel(), "effort", null, 0, 1, OutputConfig.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(toolChoiceEClass, ToolChoice.class, "ToolChoice", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getToolChoice_Type(), ecorePackage.getEString(), "type", null, 1, 1, ToolChoice.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, IS_DERIVED, IS_ORDERED);
		initEAttribute(getToolChoice_DisableParallelToolUse(), ecorePackage.getEBoolean(), "disableParallelToolUse", "false", 0, 1, ToolChoice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(autoToolChoiceEClass, AutoToolChoice.class, "AutoToolChoice", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(anyToolChoiceEClass, AnyToolChoice.class, "AnyToolChoice", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(toolToolChoiceEClass, ToolToolChoice.class, "ToolToolChoice", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getToolToolChoice_Name(), ecorePackage.getEString(), "name", null, 1, 1, ToolToolChoice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(noneToolChoiceEClass, NoneToolChoice.class, "NoneToolChoice", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(thinkingConfigEClass, ThinkingConfig.class, "ThinkingConfig", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getThinkingConfig_Type(), this.getThinkingType(), "type", null, 1, 1, ThinkingConfig.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getThinkingConfig_BudgetTokens(), ecorePackage.getEInt(), "budgetTokens", null, 0, 1, ThinkingConfig.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(outputFormatEClass, OutputFormat.class, "OutputFormat", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getOutputFormat_Type(), ecorePackage.getEString(), "type", "json_schema", 1, 1, OutputFormat.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getOutputFormat_Schema(), ecorePackage.getEString(), "schema", null, 1, 1, OutputFormat.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(cacheControlEClass, CacheControl.class, "CacheControl", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getCacheControl_Type(), ecorePackage.getEString(), "type", "ephemeral", 1, 1, CacheControl.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCacheControl_Ttl(), ecorePackage.getEString(), "ttl", null, 0, 1, CacheControl.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(citationsEClass, Citations.class, "Citations", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getCitations_Enabled(), ecorePackage.getEBoolean(), "enabled", "true", 0, 1, Citations.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(roleEEnum, Role.class, "Role");
		addEEnumLiteral(roleEEnum, Role.USER);
		addEEnumLiteral(roleEEnum, Role.ASSISTANT);

		initEEnum(serviceTierEEnum, ServiceTier.class, "ServiceTier");
		addEEnumLiteral(serviceTierEEnum, ServiceTier.AUTO);
		addEEnumLiteral(serviceTierEEnum, ServiceTier.STANDARD_ONLY);

		initEEnum(thinkingTypeEEnum, ThinkingType.class, "ThinkingType");
		addEEnumLiteral(thinkingTypeEEnum, ThinkingType.ENABLED);
		addEEnumLiteral(thinkingTypeEEnum, ThinkingType.DISABLED);

		initEEnum(skillTypeEEnum, SkillType.class, "SkillType");
		addEEnumLiteral(skillTypeEEnum, SkillType.ANTHROPIC);
		addEEnumLiteral(skillTypeEEnum, SkillType.CUSTOM);

		initEEnum(effortLevelEEnum, EffortLevel.class, "EffortLevel");
		addEEnumLiteral(effortLevelEEnum, EffortLevel.LOW);
		addEEnumLiteral(effortLevelEEnum, EffortLevel.MEDIUM);
		addEEnumLiteral(effortLevelEEnum, EffortLevel.HIGH);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// Version
		createVersionAnnotations();
		// http://www.eclipse.org/emf/2002/GenModel
		createGenModelAnnotations();
		// http:///org/eclipse/emf/ecore/util/ExtendedMetaData
		createExtendedMetaDataAnnotations();
	}

	/**
	 * Initializes the annotations for <b>Version</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createVersionAnnotations() {
		String source = "Version";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "value", "1.0"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/GenModel</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createGenModelAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/GenModel";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "complianceLevel", "17.0",
			   "oSGiCompatible", "true",
			   "basePackage", "org.eclipse.fennec.ai.chat.completion.model",
			   "resource", "XMI",
			   "copyrightText", "Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n     Data In Motion - initial API and implementation"
		   });
		addAnnotation
		  (claudeRequestEClass,
		   source,
		   new String[] {
			   "documentation", "Request object for the Claude Messages API. Represents a single request to create a message using Claude AI models."
		   });
		addAnnotation
		  (getClaudeRequest_Model(),
		   source,
		   new String[] {
			   "documentation", "The Claude model identifier to use for this request (e.g., claude-opus-4-5-20251101, claude-3-7-sonnet-20250219). Each model has different capabilities and performance characteristics."
		   });
		addAnnotation
		  (getClaudeRequest_MaxTokens(),
		   source,
		   new String[] {
			   "documentation", "Maximum number of tokens to generate before stopping. The model may stop before reaching this limit. Different models have varying maximum token limits."
		   });
		addAnnotation
		  (getClaudeRequest_Messages(),
		   source,
		   new String[] {
			   "documentation", "Array of conversational turns alternating between user and assistant roles. Supports text and various content blocks (images, documents, tool results). Maximum 100,000 messages per request."
		   });
		addAnnotation
		  (getClaudeRequest_System(),
		   source,
		   new String[] {
			   "documentation", "System instructions providing context and guidance for Claude. Can include multiple system prompts with cache control options."
		   });
		addAnnotation
		  (getClaudeRequest_Temperature(),
		   source,
		   new String[] {
			   "documentation", "Controls randomness in responses (0.0-1.0). Lower values favor analytical tasks, higher values suit creative work. Default is 1.0."
		   });
		addAnnotation
		  (getClaudeRequest_StopSequences(),
		   source,
		   new String[] {
			   "documentation", "Custom text strings that halt generation when matched. When triggered, response includes stop_reason: \'stop_sequence\'."
		   });
		addAnnotation
		  (getClaudeRequest_Tools(),
		   source,
		   new String[] {
			   "documentation", "Definitions of tools that the model can invoke. Each tool includes a name, description, and input schema defining expected parameters."
		   });
		addAnnotation
		  (getClaudeRequest_ToolChoice(),
		   source,
		   new String[] {
			   "documentation", "Controls how the model uses tools. Options: auto (model decides), any (must use tools), tool (force specific tool), none (prohibit tools)."
		   });
		addAnnotation
		  (getClaudeRequest_Stream(),
		   source,
		   new String[] {
			   "documentation", "Enables server-sent event streaming for incremental response delivery. Default is false."
		   });
		addAnnotation
		  (getClaudeRequest_Thinking(),
		   source,
		   new String[] {
			   "documentation", "Configuration for extended thinking mode. Allows the model to perform internal reasoning before responding."
		   });
		addAnnotation
		  (getClaudeRequest_OutputFormat(),
		   source,
		   new String[] {
			   "documentation", "Constrains response format using JSON Schema. Specifies the structure for structured output validation."
		   });
		addAnnotation
		  (getClaudeRequest_ServiceTier(),
		   source,
		   new String[] {
			   "documentation", "Selects API capacity level: \'auto\' for priority access when available, or \'standard_only\' for standard capacity tier."
		   });
		addAnnotation
		  (getClaudeRequest_McpServers(),
		   source,
		   new String[] {
			   "documentation", "List of Model Context Protocol (MCP) servers available during the request. Each server provides additional tools and capabilities."
		   });
		addAnnotation
		  (getClaudeRequest_Container(),
		   source,
		   new String[] {
			   "documentation", "Container identifier for code execution environments. Can specify container ID and skills to load (built-in or custom)."
		   });
		addAnnotation
		  (getClaudeRequest_ContextManagement(),
		   source,
		   new String[] {
			   "documentation", "Controls how Claude manages conversation context across requests. Supports clearing tool uses and thinking blocks based on triggers."
		   });
		addAnnotation
		  (getClaudeRequest_Metadata(),
		   source,
		   new String[] {
			   "documentation", "Additional metadata for the request, such as user_id for abuse detection. Use opaque identifiers without PII."
		   });
		addAnnotation
		  (getClaudeRequest_OutputConfig(),
		   source,
		   new String[] {
			   "documentation", "Controls response effort level (low, medium, high) to balance speed and quality."
		   });
		addAnnotation
		  (usageEClass,
		   source,
		   new String[] {
			   "documentation", "Token usage information for a request/response pair, including input tokens, output tokens, and cache-related token counts."
		   });
		addAnnotation
		  (getUsage_InputTokens(),
		   source,
		   new String[] {
			   "documentation", "The number of input tokens processed in the request, including user messages and system prompts."
		   });
		addAnnotation
		  (getUsage_OutputTokens(),
		   source,
		   new String[] {
			   "documentation", "The number of output tokens generated in the response by the model."
		   });
		addAnnotation
		  (getUsage_CacheCreationInputTokens(),
		   source,
		   new String[] {
			   "documentation", "The number of input tokens used to create a new cache entry (only present when cache creation occurs)."
		   });
		addAnnotation
		  (getUsage_CacheReadInputTokens(),
		   source,
		   new String[] {
			   "documentation", "The number of input tokens retrieved from cache (only present when cache is utilized)."
		   });
		addAnnotation
		  (claudeResponseEClass,
		   source,
		   new String[] {
			   "documentation", "Response object from the Claude Messages API. Contains the model\'s response, metadata about generation, and usage statistics."
		   });
		addAnnotation
		  (getClaudeResponse_Id(),
		   source,
		   new String[] {
			   "documentation", "Unique identifier for this message response."
		   });
		addAnnotation
		  (getClaudeResponse_Type(),
		   source,
		   new String[] {
			   "documentation", "Object type, always \'message\' for Messages API responses."
		   });
		addAnnotation
		  (getClaudeResponse_Role(),
		   source,
		   new String[] {
			   "documentation", "The role of the message author, always \'assistant\' for model responses."
		   });
		addAnnotation
		  (getClaudeResponse_Content(),
		   source,
		   new String[] {
			   "documentation", "Array of content blocks that make up the model\'s response. Can include text, tool_use, thinking, and other block types."
		   });
		addAnnotation
		  (getClaudeResponse_Model(),
		   source,
		   new String[] {
			   "documentation", "The model identifier that was used to generate this response."
		   });
		addAnnotation
		  (getClaudeResponse_StopReason(),
		   source,
		   new String[] {
			   "documentation", "The reason why the model stopped generating. Possible values: \'end_turn\' (natural completion), \'max_tokens\' (reached token limit), \'stop_sequence\' (matched custom stop sequence), \'tool_use\' (model wants to use a tool)."
		   });
		addAnnotation
		  (getClaudeResponse_StopSequence(),
		   source,
		   new String[] {
			   "documentation", "The custom stop sequence that was matched, if stop_reason is \'stop_sequence\'."
		   });
		addAnnotation
		  (getClaudeResponse_Usage(),
		   source,
		   new String[] {
			   "documentation", "Token usage information for this request/response, including input tokens, output tokens, and cache statistics."
		   });
		addAnnotation
		  (systemPromptEClass,
		   source,
		   new String[] {
			   "documentation", "System-level instructions that provide context and guidance for the model\'s behavior without being part of the conversation history."
		   });
		addAnnotation
		  (getSystemPrompt_Text(),
		   source,
		   new String[] {
			   "documentation", "The text content of the system prompt."
		   });
		addAnnotation
		  (getSystemPrompt_CacheControl(),
		   source,
		   new String[] {
			   "documentation", "Optional cache control configuration for ephemeral caching with TTL options."
		   });
		addAnnotation
		  (messageEClass,
		   source,
		   new String[] {
			   "documentation", "Represents a single conversational turn in the messages array with a role and content."
		   });
		addAnnotation
		  (getMessage_Role(),
		   source,
		   new String[] {
			   "documentation", "The role of the message sender: either \'user\' or \'assistant\'."
		   });
		addAnnotation
		  (getMessage_Content(),
		   source,
		   new String[] {
			   "documentation", "The content of the message as an array of content blocks (text, images, documents, tool uses, etc.)."
		   });
		addAnnotation
		  (contentBlockEClass,
		   source,
		   new String[] {
			   "documentation", "Abstract base class for all content block types that can appear in messages."
		   });
		addAnnotation
		  (getContentBlock_Type(),
		   source,
		   new String[] {
			   "documentation", "The type discriminator for this content block (e.g., \'text\', \'image\', \'document\', \'tool_use\', \'tool_result\')."
		   });
		addAnnotation
		  (toolEClass,
		   source,
		   new String[] {
			   "documentation", "Definition of a custom tool that the model can invoke during conversation."
		   });
		addAnnotation
		  (getTool_Name(),
		   source,
		   new String[] {
			   "documentation", "Unique identifier for the tool."
		   });
		addAnnotation
		  (getTool_Description(),
		   source,
		   new String[] {
			   "documentation", "Description explaining the tool\'s purpose and when to use it (strongly recommended for better tool selection)."
		   });
		addAnnotation
		  (getTool_InputSchema(),
		   source,
		   new String[] {
			   "documentation", "JSON Schema defining the expected input parameter structure for this tool."
		   });
		addAnnotation
		  (getTool_Type(),
		   source,
		   new String[] {
			   "documentation", "Tool type, typically \'custom\' for user-defined tools."
		   });
		addAnnotation
		  (getTool_AllowedCallers(),
		   source,
		   new String[] {
			   "documentation", "List of allowed callers that can invoke this tool (e.g., \'direct\', \'code_execution_20250825\')."
		   });
		addAnnotation
		  (getTool_DeferLoading(),
		   source,
		   new String[] {
			   "documentation", "When true, the tool is loaded only when needed via tool_reference return."
		   });
		addAnnotation
		  (mcpServerEClass,
		   source,
		   new String[] {
			   "documentation", "Configuration for a Model Context Protocol (MCP) server that provides additional tools and capabilities."
		   });
		addAnnotation
		  (getMCPServer_Name(),
		   source,
		   new String[] {
			   "documentation", "Unique identifier for this MCP server."
		   });
		addAnnotation
		  (getMCPServer_Type(),
		   source,
		   new String[] {
			   "documentation", "Server type, typically \'url\' for URL-based MCP servers."
		   });
		addAnnotation
		  (getMCPServer_Url(),
		   source,
		   new String[] {
			   "documentation", "The endpoint URL of the MCP server."
		   });
		addAnnotation
		  (getMCPServer_AuthorizationToken(),
		   source,
		   new String[] {
			   "documentation", "Optional authorization token for authenticating requests to the MCP server."
		   });
		addAnnotation
		  (getMCPServer_ToolConfiguration(),
		   source,
		   new String[] {
			   "documentation", "Optional configuration controlling which tools from this server are available."
		   });
		addAnnotation
		  (mcpToolConfigurationEClass,
		   source,
		   new String[] {
			   "documentation", "Configuration controlling tool availability from an MCP server."
		   });
		addAnnotation
		  (getMCPToolConfiguration_Enabled(),
		   source,
		   new String[] {
			   "documentation", "Whether tools from this server are enabled. Default is true."
		   });
		addAnnotation
		  (getMCPToolConfiguration_AllowedTools(),
		   source,
		   new String[] {
			   "documentation", "List of specific tool names that are allowed from this server. If empty, all tools are allowed."
		   });
		addAnnotation
		  (containerEClass,
		   source,
		   new String[] {
			   "documentation", "Container configuration for code execution environments, supporting reuse across requests."
		   });
		addAnnotation
		  (getContainer_Id(),
		   source,
		   new String[] {
			   "documentation", "Optional container identifier for reusing an existing container."
		   });
		addAnnotation
		  (getContainer_Skills(),
		   source,
		   new String[] {
			   "documentation", "List of skills to load in the container (built-in or custom)."
		   });
		addAnnotation
		  (skillEClass,
		   source,
		   new String[] {
			   "documentation", "Definition of a skill to be loaded in a container."
		   });
		addAnnotation
		  (getSkill_SkillId(),
		   source,
		   new String[] {
			   "documentation", "Unique identifier for the skill."
		   });
		addAnnotation
		  (getSkill_Type(),
		   source,
		   new String[] {
			   "documentation", "Skill category: \'anthropic\' for built-in skills or \'custom\' for user-defined skills."
		   });
		addAnnotation
		  (getSkill_Version(),
		   source,
		   new String[] {
			   "documentation", "Version of the skill, or \'latest\' for the most recent version."
		   });
	}

	/**
	 * Initializes the annotations for <b>http:///org/eclipse/emf/ecore/util/ExtendedMetaData</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createExtendedMetaDataAnnotations() {
		String source = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";
		addAnnotation
		  (getClaudeRequest_MaxTokens(),
		   source,
		   new String[] {
			   "name", "max_tokens"
		   });
		addAnnotation
		  (getClaudeRequest_StopSequences(),
		   source,
		   new String[] {
			   "name", "stop_sequences"
		   });
		addAnnotation
		  (getClaudeRequest_ToolChoice(),
		   source,
		   new String[] {
			   "name", "tool_choice"
		   });
		addAnnotation
		  (getClaudeRequest_OutputFormat(),
		   source,
		   new String[] {
			   "name", "output_format"
		   });
		addAnnotation
		  (getClaudeRequest_ServiceTier(),
		   source,
		   new String[] {
			   "name", "service_tier"
		   });
		addAnnotation
		  (getClaudeRequest_McpServers(),
		   source,
		   new String[] {
			   "name", "mcp_servers"
		   });
		addAnnotation
		  (getClaudeRequest_ContextManagement(),
		   source,
		   new String[] {
			   "name", "context_management"
		   });
		addAnnotation
		  (getClaudeRequest_OutputConfig(),
		   source,
		   new String[] {
			   "name", "output_config"
		   });
		addAnnotation
		  (getUsage_InputTokens(),
		   source,
		   new String[] {
			   "name", "input_tokens"
		   });
		addAnnotation
		  (getUsage_OutputTokens(),
		   source,
		   new String[] {
			   "name", "output_tokens"
		   });
		addAnnotation
		  (getUsage_CacheCreationInputTokens(),
		   source,
		   new String[] {
			   "name", "cache_creation_input_tokens"
		   });
		addAnnotation
		  (getUsage_CacheReadInputTokens(),
		   source,
		   new String[] {
			   "name", "cache_read_input_tokens"
		   });
		addAnnotation
		  (getClaudeResponse_StopReason(),
		   source,
		   new String[] {
			   "name", "stop_reason"
		   });
		addAnnotation
		  (getClaudeResponse_StopSequence(),
		   source,
		   new String[] {
			   "name", "stop_sequence"
		   });
		addAnnotation
		  (getSystemPrompt_CacheControl(),
		   source,
		   new String[] {
			   "name", "cache_control"
		   });
		addAnnotation
		  (getTextBlock_CacheControl(),
		   source,
		   new String[] {
			   "name", "cache_control"
		   });
		addAnnotation
		  (getImageBlock_CacheControl(),
		   source,
		   new String[] {
			   "name", "cache_control"
		   });
		addAnnotation
		  (getBase64ImageSource_MediaType(),
		   source,
		   new String[] {
			   "name", "media_type"
		   });
		addAnnotation
		  (getDocumentBlock_CacheControl(),
		   source,
		   new String[] {
			   "name", "cache_control"
		   });
		addAnnotation
		  (getBase64DocumentSource_MediaType(),
		   source,
		   new String[] {
			   "name", "media_type"
		   });
		addAnnotation
		  (getMCPToolUseBlock_ServerName(),
		   source,
		   new String[] {
			   "name", "server_name"
		   });
		addAnnotation
		  (getMCPToolUseBlock_CacheControl(),
		   source,
		   new String[] {
			   "name", "cache_control"
		   });
		addAnnotation
		  (getToolResultBlock_ToolUseId(),
		   source,
		   new String[] {
			   "name", "tool_use_id"
		   });
		addAnnotation
		  (getToolResultBlock_IsError(),
		   source,
		   new String[] {
			   "name", "is_error"
		   });
		addAnnotation
		  (getMCPToolResultBlock_ToolUseId(),
		   source,
		   new String[] {
			   "name", "tool_use_id"
		   });
		addAnnotation
		  (getMCPToolResultBlock_IsError(),
		   source,
		   new String[] {
			   "name", "is_error"
		   });
		addAnnotation
		  (getMCPToolResultBlock_CacheControl(),
		   source,
		   new String[] {
			   "name", "cache_control"
		   });
		addAnnotation
		  (getTool_InputSchema(),
		   source,
		   new String[] {
			   "name", "input_schema"
		   });
		addAnnotation
		  (getTool_AllowedCallers(),
		   source,
		   new String[] {
			   "name", "allowed_callers"
		   });
		addAnnotation
		  (getTool_DeferLoading(),
		   source,
		   new String[] {
			   "name", "defer_loading"
		   });
		addAnnotation
		  (getMCPServer_AuthorizationToken(),
		   source,
		   new String[] {
			   "name", "authorization_token"
		   });
		addAnnotation
		  (getMCPServer_ToolConfiguration(),
		   source,
		   new String[] {
			   "name", "tool_configuration"
		   });
		addAnnotation
		  (getMCPToolConfiguration_AllowedTools(),
		   source,
		   new String[] {
			   "name", "allowed_tools"
		   });
		addAnnotation
		  (getSkill_SkillId(),
		   source,
		   new String[] {
			   "name", "skill_id"
		   });
		addAnnotation
		  (getClearToolUsesEdit_ClearAtLeast(),
		   source,
		   new String[] {
			   "name", "clear_at_least"
		   });
		addAnnotation
		  (getClearToolUsesEdit_ClearToolInputsAll(),
		   source,
		   new String[] {
			   "name", "clear_tool_inputs"
		   });
		addAnnotation
		  (getClearToolUsesEdit_ClearToolInputsSpecific(),
		   source,
		   new String[] {
			   "name", "clear_tool_inputs"
		   });
		addAnnotation
		  (getClearToolUsesEdit_ExcludeTools(),
		   source,
		   new String[] {
			   "name", "exclude_tools"
		   });
		addAnnotation
		  (getClearThinkingEdit_KeepRecent(),
		   source,
		   new String[] {
			   "name", "keep"
		   });
		addAnnotation
		  (getClearThinkingEdit_KeepAll(),
		   source,
		   new String[] {
			   "name", "keep"
		   });
		addAnnotation
		  (getClearTrigger_InputTokens(),
		   source,
		   new String[] {
			   "name", "input_tokens"
		   });
		addAnnotation
		  (getClearTrigger_ToolUsesCount(),
		   source,
		   new String[] {
			   "name", "tool_uses_count"
		   });
		addAnnotation
		  (getMetadata_UserId(),
		   source,
		   new String[] {
			   "name", "user_id"
		   });
		addAnnotation
		  (getToolChoice_DisableParallelToolUse(),
		   source,
		   new String[] {
			   "name", "disable_parallel_tool_use"
		   });
		addAnnotation
		  (getThinkingConfig_BudgetTokens(),
		   source,
		   new String[] {
			   "name", "budget_tokens"
		   });
	}

} //ClaudeChatCompletionPackageImpl
