/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeRequest;
import org.eclipse.fennec.ai.chat.completion.model.claude.ContextManagementConfig;
import org.eclipse.fennec.ai.chat.completion.model.claude.MCPServer;
import org.eclipse.fennec.ai.chat.completion.model.claude.Message;
import org.eclipse.fennec.ai.chat.completion.model.claude.Metadata;
import org.eclipse.fennec.ai.chat.completion.model.claude.OutputConfig;
import org.eclipse.fennec.ai.chat.completion.model.claude.OutputFormat;
import org.eclipse.fennec.ai.chat.completion.model.claude.ServiceTier;
import org.eclipse.fennec.ai.chat.completion.model.claude.SystemPrompt;
import org.eclipse.fennec.ai.chat.completion.model.claude.ThinkingConfig;
import org.eclipse.fennec.ai.chat.completion.model.claude.Tool;
import org.eclipse.fennec.ai.chat.completion.model.claude.ToolChoice;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Claude Request</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl#getModel <em>Model</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl#getMaxTokens <em>Max Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl#getMessages <em>Messages</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl#getSystem <em>System</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl#getTemperature <em>Temperature</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl#getStopSequences <em>Stop Sequences</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl#getTools <em>Tools</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl#getToolChoice <em>Tool Choice</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl#isStream <em>Stream</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl#getThinking <em>Thinking</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl#getOutputFormat <em>Output Format</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl#getServiceTier <em>Service Tier</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl#getMcpServers <em>Mcp Servers</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl#getContainer <em>Container</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl#getContextManagement <em>Context Management</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl#getMetadata <em>Metadata</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeRequestImpl#getOutputConfig <em>Output Config</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ClaudeRequestImpl extends MinimalEObjectImpl.Container implements ClaudeRequest {
	/**
	 * The default value of the '{@link #getModel() <em>Model</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModel()
	 * @generated
	 * @ordered
	 */
	protected static final String MODEL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getModel() <em>Model</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModel()
	 * @generated
	 * @ordered
	 */
	protected String model = MODEL_EDEFAULT;

	/**
	 * The default value of the '{@link #getMaxTokens() <em>Max Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxTokens()
	 * @generated
	 * @ordered
	 */
	protected static final int MAX_TOKENS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getMaxTokens() <em>Max Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxTokens()
	 * @generated
	 * @ordered
	 */
	protected int maxTokens = MAX_TOKENS_EDEFAULT;

	/**
	 * The cached value of the '{@link #getMessages() <em>Messages</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMessages()
	 * @generated
	 * @ordered
	 */
	protected EList<Message> messages;

	/**
	 * The cached value of the '{@link #getSystem() <em>System</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSystem()
	 * @generated
	 * @ordered
	 */
	protected EList<SystemPrompt> system;

	/**
	 * The default value of the '{@link #getTemperature() <em>Temperature</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTemperature()
	 * @generated
	 * @ordered
	 */
	protected static final double TEMPERATURE_EDEFAULT = 1.0;

	/**
	 * The cached value of the '{@link #getTemperature() <em>Temperature</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTemperature()
	 * @generated
	 * @ordered
	 */
	protected double temperature = TEMPERATURE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getStopSequences() <em>Stop Sequences</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStopSequences()
	 * @generated
	 * @ordered
	 */
	protected EList<String> stopSequences;

	/**
	 * The cached value of the '{@link #getTools() <em>Tools</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTools()
	 * @generated
	 * @ordered
	 */
	protected EList<Tool> tools;

	/**
	 * The cached value of the '{@link #getToolChoice() <em>Tool Choice</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getToolChoice()
	 * @generated
	 * @ordered
	 */
	protected ToolChoice toolChoice;

	/**
	 * The default value of the '{@link #isStream() <em>Stream</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isStream()
	 * @generated
	 * @ordered
	 */
	protected static final boolean STREAM_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isStream() <em>Stream</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isStream()
	 * @generated
	 * @ordered
	 */
	protected boolean stream = STREAM_EDEFAULT;

	/**
	 * The cached value of the '{@link #getThinking() <em>Thinking</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getThinking()
	 * @generated
	 * @ordered
	 */
	protected ThinkingConfig thinking;

	/**
	 * The cached value of the '{@link #getOutputFormat() <em>Output Format</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOutputFormat()
	 * @generated
	 * @ordered
	 */
	protected OutputFormat outputFormat;

	/**
	 * The default value of the '{@link #getServiceTier() <em>Service Tier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getServiceTier()
	 * @generated
	 * @ordered
	 */
	protected static final ServiceTier SERVICE_TIER_EDEFAULT = ServiceTier.AUTO;

	/**
	 * The cached value of the '{@link #getServiceTier() <em>Service Tier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getServiceTier()
	 * @generated
	 * @ordered
	 */
	protected ServiceTier serviceTier = SERVICE_TIER_EDEFAULT;

	/**
	 * The cached value of the '{@link #getMcpServers() <em>Mcp Servers</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMcpServers()
	 * @generated
	 * @ordered
	 */
	protected EList<MCPServer> mcpServers;

	/**
	 * The cached value of the '{@link #getContainer() <em>Container</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContainer()
	 * @generated
	 * @ordered
	 */
	protected org.eclipse.fennec.ai.chat.completion.model.claude.Container container;

	/**
	 * The cached value of the '{@link #getContextManagement() <em>Context Management</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContextManagement()
	 * @generated
	 * @ordered
	 */
	protected ContextManagementConfig contextManagement;

	/**
	 * The cached value of the '{@link #getMetadata() <em>Metadata</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMetadata()
	 * @generated
	 * @ordered
	 */
	protected Metadata metadata;

	/**
	 * The cached value of the '{@link #getOutputConfig() <em>Output Config</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOutputConfig()
	 * @generated
	 * @ordered
	 */
	protected OutputConfig outputConfig;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClaudeRequestImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ClaudeChatCompletionPackage.Literals.CLAUDE_REQUEST;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getModel() {
		return model;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setModel(String newModel) {
		String oldModel = model;
		model = newModel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__MODEL, oldModel, model));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getMaxTokens() {
		return maxTokens;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMaxTokens(int newMaxTokens) {
		int oldMaxTokens = maxTokens;
		maxTokens = newMaxTokens;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__MAX_TOKENS, oldMaxTokens, maxTokens));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Message> getMessages() {
		if (messages == null) {
			messages = new EObjectContainmentEList<Message>(Message.class, this, ClaudeChatCompletionPackage.CLAUDE_REQUEST__MESSAGES);
		}
		return messages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SystemPrompt> getSystem() {
		if (system == null) {
			system = new EObjectContainmentEList<SystemPrompt>(SystemPrompt.class, this, ClaudeChatCompletionPackage.CLAUDE_REQUEST__SYSTEM);
		}
		return system;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getTemperature() {
		return temperature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTemperature(double newTemperature) {
		double oldTemperature = temperature;
		temperature = newTemperature;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__TEMPERATURE, oldTemperature, temperature));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getStopSequences() {
		if (stopSequences == null) {
			stopSequences = new EDataTypeUniqueEList<String>(String.class, this, ClaudeChatCompletionPackage.CLAUDE_REQUEST__STOP_SEQUENCES);
		}
		return stopSequences;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Tool> getTools() {
		if (tools == null) {
			tools = new EObjectContainmentEList<Tool>(Tool.class, this, ClaudeChatCompletionPackage.CLAUDE_REQUEST__TOOLS);
		}
		return tools;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ToolChoice getToolChoice() {
		return toolChoice;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetToolChoice(ToolChoice newToolChoice, NotificationChain msgs) {
		ToolChoice oldToolChoice = toolChoice;
		toolChoice = newToolChoice;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__TOOL_CHOICE, oldToolChoice, newToolChoice);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setToolChoice(ToolChoice newToolChoice) {
		if (newToolChoice != toolChoice) {
			NotificationChain msgs = null;
			if (toolChoice != null)
				msgs = ((InternalEObject)toolChoice).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.CLAUDE_REQUEST__TOOL_CHOICE, null, msgs);
			if (newToolChoice != null)
				msgs = ((InternalEObject)newToolChoice).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.CLAUDE_REQUEST__TOOL_CHOICE, null, msgs);
			msgs = basicSetToolChoice(newToolChoice, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__TOOL_CHOICE, newToolChoice, newToolChoice));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isStream() {
		return stream;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStream(boolean newStream) {
		boolean oldStream = stream;
		stream = newStream;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__STREAM, oldStream, stream));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ThinkingConfig getThinking() {
		return thinking;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetThinking(ThinkingConfig newThinking, NotificationChain msgs) {
		ThinkingConfig oldThinking = thinking;
		thinking = newThinking;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__THINKING, oldThinking, newThinking);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setThinking(ThinkingConfig newThinking) {
		if (newThinking != thinking) {
			NotificationChain msgs = null;
			if (thinking != null)
				msgs = ((InternalEObject)thinking).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.CLAUDE_REQUEST__THINKING, null, msgs);
			if (newThinking != null)
				msgs = ((InternalEObject)newThinking).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.CLAUDE_REQUEST__THINKING, null, msgs);
			msgs = basicSetThinking(newThinking, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__THINKING, newThinking, newThinking));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public OutputFormat getOutputFormat() {
		return outputFormat;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOutputFormat(OutputFormat newOutputFormat, NotificationChain msgs) {
		OutputFormat oldOutputFormat = outputFormat;
		outputFormat = newOutputFormat;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__OUTPUT_FORMAT, oldOutputFormat, newOutputFormat);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setOutputFormat(OutputFormat newOutputFormat) {
		if (newOutputFormat != outputFormat) {
			NotificationChain msgs = null;
			if (outputFormat != null)
				msgs = ((InternalEObject)outputFormat).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.CLAUDE_REQUEST__OUTPUT_FORMAT, null, msgs);
			if (newOutputFormat != null)
				msgs = ((InternalEObject)newOutputFormat).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.CLAUDE_REQUEST__OUTPUT_FORMAT, null, msgs);
			msgs = basicSetOutputFormat(newOutputFormat, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__OUTPUT_FORMAT, newOutputFormat, newOutputFormat));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ServiceTier getServiceTier() {
		return serviceTier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setServiceTier(ServiceTier newServiceTier) {
		ServiceTier oldServiceTier = serviceTier;
		serviceTier = newServiceTier == null ? SERVICE_TIER_EDEFAULT : newServiceTier;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__SERVICE_TIER, oldServiceTier, serviceTier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<MCPServer> getMcpServers() {
		if (mcpServers == null) {
			mcpServers = new EObjectContainmentEList<MCPServer>(MCPServer.class, this, ClaudeChatCompletionPackage.CLAUDE_REQUEST__MCP_SERVERS);
		}
		return mcpServers;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public org.eclipse.fennec.ai.chat.completion.model.claude.Container getContainer() {
		return container;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetContainer(org.eclipse.fennec.ai.chat.completion.model.claude.Container newContainer, NotificationChain msgs) {
		org.eclipse.fennec.ai.chat.completion.model.claude.Container oldContainer = container;
		container = newContainer;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__CONTAINER, oldContainer, newContainer);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setContainer(org.eclipse.fennec.ai.chat.completion.model.claude.Container newContainer) {
		if (newContainer != container) {
			NotificationChain msgs = null;
			if (container != null)
				msgs = ((InternalEObject)container).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.CLAUDE_REQUEST__CONTAINER, null, msgs);
			if (newContainer != null)
				msgs = ((InternalEObject)newContainer).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.CLAUDE_REQUEST__CONTAINER, null, msgs);
			msgs = basicSetContainer(newContainer, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__CONTAINER, newContainer, newContainer));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ContextManagementConfig getContextManagement() {
		return contextManagement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetContextManagement(ContextManagementConfig newContextManagement, NotificationChain msgs) {
		ContextManagementConfig oldContextManagement = contextManagement;
		contextManagement = newContextManagement;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__CONTEXT_MANAGEMENT, oldContextManagement, newContextManagement);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setContextManagement(ContextManagementConfig newContextManagement) {
		if (newContextManagement != contextManagement) {
			NotificationChain msgs = null;
			if (contextManagement != null)
				msgs = ((InternalEObject)contextManagement).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.CLAUDE_REQUEST__CONTEXT_MANAGEMENT, null, msgs);
			if (newContextManagement != null)
				msgs = ((InternalEObject)newContextManagement).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.CLAUDE_REQUEST__CONTEXT_MANAGEMENT, null, msgs);
			msgs = basicSetContextManagement(newContextManagement, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__CONTEXT_MANAGEMENT, newContextManagement, newContextManagement));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Metadata getMetadata() {
		return metadata;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMetadata(Metadata newMetadata, NotificationChain msgs) {
		Metadata oldMetadata = metadata;
		metadata = newMetadata;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__METADATA, oldMetadata, newMetadata);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMetadata(Metadata newMetadata) {
		if (newMetadata != metadata) {
			NotificationChain msgs = null;
			if (metadata != null)
				msgs = ((InternalEObject)metadata).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.CLAUDE_REQUEST__METADATA, null, msgs);
			if (newMetadata != null)
				msgs = ((InternalEObject)newMetadata).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.CLAUDE_REQUEST__METADATA, null, msgs);
			msgs = basicSetMetadata(newMetadata, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__METADATA, newMetadata, newMetadata));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public OutputConfig getOutputConfig() {
		return outputConfig;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOutputConfig(OutputConfig newOutputConfig, NotificationChain msgs) {
		OutputConfig oldOutputConfig = outputConfig;
		outputConfig = newOutputConfig;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__OUTPUT_CONFIG, oldOutputConfig, newOutputConfig);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setOutputConfig(OutputConfig newOutputConfig) {
		if (newOutputConfig != outputConfig) {
			NotificationChain msgs = null;
			if (outputConfig != null)
				msgs = ((InternalEObject)outputConfig).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.CLAUDE_REQUEST__OUTPUT_CONFIG, null, msgs);
			if (newOutputConfig != null)
				msgs = ((InternalEObject)newOutputConfig).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.CLAUDE_REQUEST__OUTPUT_CONFIG, null, msgs);
			msgs = basicSetOutputConfig(newOutputConfig, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_REQUEST__OUTPUT_CONFIG, newOutputConfig, newOutputConfig));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__MESSAGES:
				return ((InternalEList<?>)getMessages()).basicRemove(otherEnd, msgs);
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__SYSTEM:
				return ((InternalEList<?>)getSystem()).basicRemove(otherEnd, msgs);
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__TOOLS:
				return ((InternalEList<?>)getTools()).basicRemove(otherEnd, msgs);
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__TOOL_CHOICE:
				return basicSetToolChoice(null, msgs);
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__THINKING:
				return basicSetThinking(null, msgs);
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__OUTPUT_FORMAT:
				return basicSetOutputFormat(null, msgs);
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__MCP_SERVERS:
				return ((InternalEList<?>)getMcpServers()).basicRemove(otherEnd, msgs);
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__CONTAINER:
				return basicSetContainer(null, msgs);
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__CONTEXT_MANAGEMENT:
				return basicSetContextManagement(null, msgs);
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__METADATA:
				return basicSetMetadata(null, msgs);
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__OUTPUT_CONFIG:
				return basicSetOutputConfig(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__MODEL:
				return getModel();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__MAX_TOKENS:
				return getMaxTokens();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__MESSAGES:
				return getMessages();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__SYSTEM:
				return getSystem();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__TEMPERATURE:
				return getTemperature();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__STOP_SEQUENCES:
				return getStopSequences();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__TOOLS:
				return getTools();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__TOOL_CHOICE:
				return getToolChoice();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__STREAM:
				return isStream();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__THINKING:
				return getThinking();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__OUTPUT_FORMAT:
				return getOutputFormat();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__SERVICE_TIER:
				return getServiceTier();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__MCP_SERVERS:
				return getMcpServers();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__CONTAINER:
				return getContainer();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__CONTEXT_MANAGEMENT:
				return getContextManagement();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__METADATA:
				return getMetadata();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__OUTPUT_CONFIG:
				return getOutputConfig();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__MODEL:
				setModel((String)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__MAX_TOKENS:
				setMaxTokens((Integer)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__MESSAGES:
				getMessages().clear();
				getMessages().addAll((Collection<? extends Message>)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__SYSTEM:
				getSystem().clear();
				getSystem().addAll((Collection<? extends SystemPrompt>)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__TEMPERATURE:
				setTemperature((Double)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__STOP_SEQUENCES:
				getStopSequences().clear();
				getStopSequences().addAll((Collection<? extends String>)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__TOOLS:
				getTools().clear();
				getTools().addAll((Collection<? extends Tool>)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__TOOL_CHOICE:
				setToolChoice((ToolChoice)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__STREAM:
				setStream((Boolean)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__THINKING:
				setThinking((ThinkingConfig)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__OUTPUT_FORMAT:
				setOutputFormat((OutputFormat)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__SERVICE_TIER:
				setServiceTier((ServiceTier)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__MCP_SERVERS:
				getMcpServers().clear();
				getMcpServers().addAll((Collection<? extends MCPServer>)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__CONTAINER:
				setContainer((org.eclipse.fennec.ai.chat.completion.model.claude.Container)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__CONTEXT_MANAGEMENT:
				setContextManagement((ContextManagementConfig)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__METADATA:
				setMetadata((Metadata)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__OUTPUT_CONFIG:
				setOutputConfig((OutputConfig)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__MODEL:
				setModel(MODEL_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__MAX_TOKENS:
				setMaxTokens(MAX_TOKENS_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__MESSAGES:
				getMessages().clear();
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__SYSTEM:
				getSystem().clear();
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__TEMPERATURE:
				setTemperature(TEMPERATURE_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__STOP_SEQUENCES:
				getStopSequences().clear();
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__TOOLS:
				getTools().clear();
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__TOOL_CHOICE:
				setToolChoice((ToolChoice)null);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__STREAM:
				setStream(STREAM_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__THINKING:
				setThinking((ThinkingConfig)null);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__OUTPUT_FORMAT:
				setOutputFormat((OutputFormat)null);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__SERVICE_TIER:
				setServiceTier(SERVICE_TIER_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__MCP_SERVERS:
				getMcpServers().clear();
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__CONTAINER:
				setContainer((org.eclipse.fennec.ai.chat.completion.model.claude.Container)null);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__CONTEXT_MANAGEMENT:
				setContextManagement((ContextManagementConfig)null);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__METADATA:
				setMetadata((Metadata)null);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__OUTPUT_CONFIG:
				setOutputConfig((OutputConfig)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__MODEL:
				return MODEL_EDEFAULT == null ? model != null : !MODEL_EDEFAULT.equals(model);
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__MAX_TOKENS:
				return maxTokens != MAX_TOKENS_EDEFAULT;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__MESSAGES:
				return messages != null && !messages.isEmpty();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__SYSTEM:
				return system != null && !system.isEmpty();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__TEMPERATURE:
				return temperature != TEMPERATURE_EDEFAULT;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__STOP_SEQUENCES:
				return stopSequences != null && !stopSequences.isEmpty();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__TOOLS:
				return tools != null && !tools.isEmpty();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__TOOL_CHOICE:
				return toolChoice != null;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__STREAM:
				return stream != STREAM_EDEFAULT;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__THINKING:
				return thinking != null;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__OUTPUT_FORMAT:
				return outputFormat != null;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__SERVICE_TIER:
				return serviceTier != SERVICE_TIER_EDEFAULT;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__MCP_SERVERS:
				return mcpServers != null && !mcpServers.isEmpty();
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__CONTAINER:
				return container != null;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__CONTEXT_MANAGEMENT:
				return contextManagement != null;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__METADATA:
				return metadata != null;
			case ClaudeChatCompletionPackage.CLAUDE_REQUEST__OUTPUT_CONFIG:
				return outputConfig != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (model: ");
		result.append(model);
		result.append(", maxTokens: ");
		result.append(maxTokens);
		result.append(", temperature: ");
		result.append(temperature);
		result.append(", stopSequences: ");
		result.append(stopSequences);
		result.append(", stream: ");
		result.append(stream);
		result.append(", serviceTier: ");
		result.append(serviceTier);
		result.append(')');
		return result.toString();
	}

} //ClaudeRequestImpl
