/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeResponse;
import org.eclipse.fennec.ai.chat.completion.model.claude.ContentBlock;
import org.eclipse.fennec.ai.chat.completion.model.claude.Role;
import org.eclipse.fennec.ai.chat.completion.model.claude.Usage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Claude Response</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeResponseImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeResponseImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeResponseImpl#getRole <em>Role</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeResponseImpl#getContent <em>Content</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeResponseImpl#getModel <em>Model</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeResponseImpl#getStopReason <em>Stop Reason</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeResponseImpl#getStopSequence <em>Stop Sequence</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClaudeResponseImpl#getUsage <em>Usage</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ClaudeResponseImpl extends MinimalEObjectImpl.Container implements ClaudeResponse {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final String TYPE_EDEFAULT = "message";

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected String type = TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getRole() <em>Role</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRole()
	 * @generated
	 * @ordered
	 */
	protected static final Role ROLE_EDEFAULT = Role.ASSISTANT;

	/**
	 * The cached value of the '{@link #getRole() <em>Role</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRole()
	 * @generated
	 * @ordered
	 */
	protected Role role = ROLE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getContent() <em>Content</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContent()
	 * @generated
	 * @ordered
	 */
	protected EList<ContentBlock> content;

	/**
	 * The default value of the '{@link #getModel() <em>Model</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModel()
	 * @generated
	 * @ordered
	 */
	protected static final String MODEL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getModel() <em>Model</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getModel()
	 * @generated
	 * @ordered
	 */
	protected String model = MODEL_EDEFAULT;

	/**
	 * The default value of the '{@link #getStopReason() <em>Stop Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStopReason()
	 * @generated
	 * @ordered
	 */
	protected static final String STOP_REASON_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getStopReason() <em>Stop Reason</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStopReason()
	 * @generated
	 * @ordered
	 */
	protected String stopReason = STOP_REASON_EDEFAULT;

	/**
	 * The default value of the '{@link #getStopSequence() <em>Stop Sequence</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStopSequence()
	 * @generated
	 * @ordered
	 */
	protected static final String STOP_SEQUENCE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getStopSequence() <em>Stop Sequence</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStopSequence()
	 * @generated
	 * @ordered
	 */
	protected String stopSequence = STOP_SEQUENCE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getUsage() <em>Usage</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUsage()
	 * @generated
	 * @ordered
	 */
	protected Usage usage;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClaudeResponseImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ClaudeChatCompletionPackage.Literals.CLAUDE_RESPONSE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_RESPONSE__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setType(String newType) {
		String oldType = type;
		type = newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_RESPONSE__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Role getRole() {
		return role;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRole(Role newRole) {
		Role oldRole = role;
		role = newRole == null ? ROLE_EDEFAULT : newRole;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_RESPONSE__ROLE, oldRole, role));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ContentBlock> getContent() {
		if (content == null) {
			content = new EObjectContainmentEList<ContentBlock>(ContentBlock.class, this, ClaudeChatCompletionPackage.CLAUDE_RESPONSE__CONTENT);
		}
		return content;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getModel() {
		return model;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setModel(String newModel) {
		String oldModel = model;
		model = newModel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_RESPONSE__MODEL, oldModel, model));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getStopReason() {
		return stopReason;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStopReason(String newStopReason) {
		String oldStopReason = stopReason;
		stopReason = newStopReason;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_RESPONSE__STOP_REASON, oldStopReason, stopReason));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getStopSequence() {
		return stopSequence;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStopSequence(String newStopSequence) {
		String oldStopSequence = stopSequence;
		stopSequence = newStopSequence;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_RESPONSE__STOP_SEQUENCE, oldStopSequence, stopSequence));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Usage getUsage() {
		return usage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetUsage(Usage newUsage, NotificationChain msgs) {
		Usage oldUsage = usage;
		usage = newUsage;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_RESPONSE__USAGE, oldUsage, newUsage);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUsage(Usage newUsage) {
		if (newUsage != usage) {
			NotificationChain msgs = null;
			if (usage != null)
				msgs = ((InternalEObject)usage).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.CLAUDE_RESPONSE__USAGE, null, msgs);
			if (newUsage != null)
				msgs = ((InternalEObject)newUsage).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.CLAUDE_RESPONSE__USAGE, null, msgs);
			msgs = basicSetUsage(newUsage, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLAUDE_RESPONSE__USAGE, newUsage, newUsage));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__CONTENT:
				return ((InternalEList<?>)getContent()).basicRemove(otherEnd, msgs);
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__USAGE:
				return basicSetUsage(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__ID:
				return getId();
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__TYPE:
				return getType();
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__ROLE:
				return getRole();
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__CONTENT:
				return getContent();
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__MODEL:
				return getModel();
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__STOP_REASON:
				return getStopReason();
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__STOP_SEQUENCE:
				return getStopSequence();
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__USAGE:
				return getUsage();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__ID:
				setId((String)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__TYPE:
				setType((String)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__ROLE:
				setRole((Role)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__CONTENT:
				getContent().clear();
				getContent().addAll((Collection<? extends ContentBlock>)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__MODEL:
				setModel((String)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__STOP_REASON:
				setStopReason((String)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__STOP_SEQUENCE:
				setStopSequence((String)newValue);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__USAGE:
				setUsage((Usage)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__ID:
				setId(ID_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__ROLE:
				setRole(ROLE_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__CONTENT:
				getContent().clear();
				return;
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__MODEL:
				setModel(MODEL_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__STOP_REASON:
				setStopReason(STOP_REASON_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__STOP_SEQUENCE:
				setStopSequence(STOP_SEQUENCE_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__USAGE:
				setUsage((Usage)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__TYPE:
				return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__ROLE:
				return role != ROLE_EDEFAULT;
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__CONTENT:
				return content != null && !content.isEmpty();
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__MODEL:
				return MODEL_EDEFAULT == null ? model != null : !MODEL_EDEFAULT.equals(model);
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__STOP_REASON:
				return STOP_REASON_EDEFAULT == null ? stopReason != null : !STOP_REASON_EDEFAULT.equals(stopReason);
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__STOP_SEQUENCE:
				return STOP_SEQUENCE_EDEFAULT == null ? stopSequence != null : !STOP_SEQUENCE_EDEFAULT.equals(stopSequence);
			case ClaudeChatCompletionPackage.CLAUDE_RESPONSE__USAGE:
				return usage != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", type: ");
		result.append(type);
		result.append(", role: ");
		result.append(role);
		result.append(", model: ");
		result.append(model);
		result.append(", stopReason: ");
		result.append(stopReason);
		result.append(", stopSequence: ");
		result.append(stopSequence);
		result.append(')');
		return result.toString();
	}

} //ClaudeResponseImpl
