/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.claude.ClearThinkingEdit;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Clear Thinking Edit</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearThinkingEditImpl#getKeepRecent <em>Keep Recent</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearThinkingEditImpl#isKeepAll <em>Keep All</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ClearThinkingEditImpl extends ContextEditImpl implements ClearThinkingEdit {
	/**
	 * The default value of the '{@link #getKeepRecent() <em>Keep Recent</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKeepRecent()
	 * @generated
	 * @ordered
	 */
	protected static final int KEEP_RECENT_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getKeepRecent() <em>Keep Recent</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKeepRecent()
	 * @generated
	 * @ordered
	 */
	protected int keepRecent = KEEP_RECENT_EDEFAULT;

	/**
	 * The default value of the '{@link #isKeepAll() <em>Keep All</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isKeepAll()
	 * @generated
	 * @ordered
	 */
	protected static final boolean KEEP_ALL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isKeepAll() <em>Keep All</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isKeepAll()
	 * @generated
	 * @ordered
	 */
	protected boolean keepAll = KEEP_ALL_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClearThinkingEditImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ClaudeChatCompletionPackage.Literals.CLEAR_THINKING_EDIT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getKeepRecent() {
		return keepRecent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setKeepRecent(int newKeepRecent) {
		int oldKeepRecent = keepRecent;
		keepRecent = newKeepRecent;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLEAR_THINKING_EDIT__KEEP_RECENT, oldKeepRecent, keepRecent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isKeepAll() {
		return keepAll;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setKeepAll(boolean newKeepAll) {
		boolean oldKeepAll = keepAll;
		keepAll = newKeepAll;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLEAR_THINKING_EDIT__KEEP_ALL, oldKeepAll, keepAll));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLEAR_THINKING_EDIT__KEEP_RECENT:
				return getKeepRecent();
			case ClaudeChatCompletionPackage.CLEAR_THINKING_EDIT__KEEP_ALL:
				return isKeepAll();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLEAR_THINKING_EDIT__KEEP_RECENT:
				setKeepRecent((Integer)newValue);
				return;
			case ClaudeChatCompletionPackage.CLEAR_THINKING_EDIT__KEEP_ALL:
				setKeepAll((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLEAR_THINKING_EDIT__KEEP_RECENT:
				setKeepRecent(KEEP_RECENT_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.CLEAR_THINKING_EDIT__KEEP_ALL:
				setKeepAll(KEEP_ALL_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLEAR_THINKING_EDIT__KEEP_RECENT:
				return keepRecent != KEEP_RECENT_EDEFAULT;
			case ClaudeChatCompletionPackage.CLEAR_THINKING_EDIT__KEEP_ALL:
				return keepAll != KEEP_ALL_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (keepRecent: ");
		result.append(keepRecent);
		result.append(", keepAll: ");
		result.append(keepAll);
		result.append(')');
		return result.toString();
	}

} //ClearThinkingEditImpl
