/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;

import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.claude.ClearToolUsesEdit;
import org.eclipse.fennec.ai.chat.completion.model.claude.ClearTrigger;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Clear Tool Uses Edit</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearToolUsesEditImpl#getClearAtLeast <em>Clear At Least</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearToolUsesEditImpl#isClearToolInputsAll <em>Clear Tool Inputs All</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearToolUsesEditImpl#getClearToolInputsSpecific <em>Clear Tool Inputs Specific</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearToolUsesEditImpl#getExcludeTools <em>Exclude Tools</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearToolUsesEditImpl#getKeep <em>Keep</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearToolUsesEditImpl#getTrigger <em>Trigger</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ClearToolUsesEditImpl extends ContextEditImpl implements ClearToolUsesEdit {
	/**
	 * The default value of the '{@link #getClearAtLeast() <em>Clear At Least</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClearAtLeast()
	 * @generated
	 * @ordered
	 */
	protected static final int CLEAR_AT_LEAST_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getClearAtLeast() <em>Clear At Least</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClearAtLeast()
	 * @generated
	 * @ordered
	 */
	protected int clearAtLeast = CLEAR_AT_LEAST_EDEFAULT;

	/**
	 * The default value of the '{@link #isClearToolInputsAll() <em>Clear Tool Inputs All</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isClearToolInputsAll()
	 * @generated
	 * @ordered
	 */
	protected static final boolean CLEAR_TOOL_INPUTS_ALL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isClearToolInputsAll() <em>Clear Tool Inputs All</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isClearToolInputsAll()
	 * @generated
	 * @ordered
	 */
	protected boolean clearToolInputsAll = CLEAR_TOOL_INPUTS_ALL_EDEFAULT;

	/**
	 * The cached value of the '{@link #getClearToolInputsSpecific() <em>Clear Tool Inputs Specific</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClearToolInputsSpecific()
	 * @generated
	 * @ordered
	 */
	protected EList<String> clearToolInputsSpecific;

	/**
	 * The cached value of the '{@link #getExcludeTools() <em>Exclude Tools</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExcludeTools()
	 * @generated
	 * @ordered
	 */
	protected EList<String> excludeTools;

	/**
	 * The default value of the '{@link #getKeep() <em>Keep</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKeep()
	 * @generated
	 * @ordered
	 */
	protected static final int KEEP_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getKeep() <em>Keep</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKeep()
	 * @generated
	 * @ordered
	 */
	protected int keep = KEEP_EDEFAULT;

	/**
	 * The cached value of the '{@link #getTrigger() <em>Trigger</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTrigger()
	 * @generated
	 * @ordered
	 */
	protected ClearTrigger trigger;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClearToolUsesEditImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ClaudeChatCompletionPackage.Literals.CLEAR_TOOL_USES_EDIT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getClearAtLeast() {
		return clearAtLeast;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setClearAtLeast(int newClearAtLeast) {
		int oldClearAtLeast = clearAtLeast;
		clearAtLeast = newClearAtLeast;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__CLEAR_AT_LEAST, oldClearAtLeast, clearAtLeast));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isClearToolInputsAll() {
		return clearToolInputsAll;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setClearToolInputsAll(boolean newClearToolInputsAll) {
		boolean oldClearToolInputsAll = clearToolInputsAll;
		clearToolInputsAll = newClearToolInputsAll;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__CLEAR_TOOL_INPUTS_ALL, oldClearToolInputsAll, clearToolInputsAll));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getClearToolInputsSpecific() {
		if (clearToolInputsSpecific == null) {
			clearToolInputsSpecific = new EDataTypeUniqueEList<String>(String.class, this, ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__CLEAR_TOOL_INPUTS_SPECIFIC);
		}
		return clearToolInputsSpecific;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<String> getExcludeTools() {
		if (excludeTools == null) {
			excludeTools = new EDataTypeUniqueEList<String>(String.class, this, ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__EXCLUDE_TOOLS);
		}
		return excludeTools;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getKeep() {
		return keep;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setKeep(int newKeep) {
		int oldKeep = keep;
		keep = newKeep;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__KEEP, oldKeep, keep));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ClearTrigger getTrigger() {
		return trigger;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTrigger(ClearTrigger newTrigger, NotificationChain msgs) {
		ClearTrigger oldTrigger = trigger;
		trigger = newTrigger;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__TRIGGER, oldTrigger, newTrigger);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTrigger(ClearTrigger newTrigger) {
		if (newTrigger != trigger) {
			NotificationChain msgs = null;
			if (trigger != null)
				msgs = ((InternalEObject)trigger).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__TRIGGER, null, msgs);
			if (newTrigger != null)
				msgs = ((InternalEObject)newTrigger).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__TRIGGER, null, msgs);
			msgs = basicSetTrigger(newTrigger, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__TRIGGER, newTrigger, newTrigger));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__TRIGGER:
				return basicSetTrigger(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__CLEAR_AT_LEAST:
				return getClearAtLeast();
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__CLEAR_TOOL_INPUTS_ALL:
				return isClearToolInputsAll();
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__CLEAR_TOOL_INPUTS_SPECIFIC:
				return getClearToolInputsSpecific();
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__EXCLUDE_TOOLS:
				return getExcludeTools();
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__KEEP:
				return getKeep();
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__TRIGGER:
				return getTrigger();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__CLEAR_AT_LEAST:
				setClearAtLeast((Integer)newValue);
				return;
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__CLEAR_TOOL_INPUTS_ALL:
				setClearToolInputsAll((Boolean)newValue);
				return;
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__CLEAR_TOOL_INPUTS_SPECIFIC:
				getClearToolInputsSpecific().clear();
				getClearToolInputsSpecific().addAll((Collection<? extends String>)newValue);
				return;
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__EXCLUDE_TOOLS:
				getExcludeTools().clear();
				getExcludeTools().addAll((Collection<? extends String>)newValue);
				return;
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__KEEP:
				setKeep((Integer)newValue);
				return;
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__TRIGGER:
				setTrigger((ClearTrigger)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__CLEAR_AT_LEAST:
				setClearAtLeast(CLEAR_AT_LEAST_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__CLEAR_TOOL_INPUTS_ALL:
				setClearToolInputsAll(CLEAR_TOOL_INPUTS_ALL_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__CLEAR_TOOL_INPUTS_SPECIFIC:
				getClearToolInputsSpecific().clear();
				return;
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__EXCLUDE_TOOLS:
				getExcludeTools().clear();
				return;
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__KEEP:
				setKeep(KEEP_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__TRIGGER:
				setTrigger((ClearTrigger)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__CLEAR_AT_LEAST:
				return clearAtLeast != CLEAR_AT_LEAST_EDEFAULT;
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__CLEAR_TOOL_INPUTS_ALL:
				return clearToolInputsAll != CLEAR_TOOL_INPUTS_ALL_EDEFAULT;
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__CLEAR_TOOL_INPUTS_SPECIFIC:
				return clearToolInputsSpecific != null && !clearToolInputsSpecific.isEmpty();
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__EXCLUDE_TOOLS:
				return excludeTools != null && !excludeTools.isEmpty();
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__KEEP:
				return keep != KEEP_EDEFAULT;
			case ClaudeChatCompletionPackage.CLEAR_TOOL_USES_EDIT__TRIGGER:
				return trigger != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (clearAtLeast: ");
		result.append(clearAtLeast);
		result.append(", clearToolInputsAll: ");
		result.append(clearToolInputsAll);
		result.append(", clearToolInputsSpecific: ");
		result.append(clearToolInputsSpecific);
		result.append(", excludeTools: ");
		result.append(excludeTools);
		result.append(", keep: ");
		result.append(keep);
		result.append(')');
		return result.toString();
	}

} //ClearToolUsesEditImpl
