/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.claude.ClearTrigger;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Clear Trigger</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearTriggerImpl#getInputTokens <em>Input Tokens</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.ClearTriggerImpl#getToolUsesCount <em>Tool Uses Count</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ClearTriggerImpl extends MinimalEObjectImpl.Container implements ClearTrigger {
	/**
	 * The default value of the '{@link #getInputTokens() <em>Input Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInputTokens()
	 * @generated
	 * @ordered
	 */
	protected static final int INPUT_TOKENS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getInputTokens() <em>Input Tokens</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInputTokens()
	 * @generated
	 * @ordered
	 */
	protected int inputTokens = INPUT_TOKENS_EDEFAULT;

	/**
	 * The default value of the '{@link #getToolUsesCount() <em>Tool Uses Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getToolUsesCount()
	 * @generated
	 * @ordered
	 */
	protected static final int TOOL_USES_COUNT_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getToolUsesCount() <em>Tool Uses Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getToolUsesCount()
	 * @generated
	 * @ordered
	 */
	protected int toolUsesCount = TOOL_USES_COUNT_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClearTriggerImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ClaudeChatCompletionPackage.Literals.CLEAR_TRIGGER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getInputTokens() {
		return inputTokens;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setInputTokens(int newInputTokens) {
		int oldInputTokens = inputTokens;
		inputTokens = newInputTokens;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLEAR_TRIGGER__INPUT_TOKENS, oldInputTokens, inputTokens));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getToolUsesCount() {
		return toolUsesCount;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setToolUsesCount(int newToolUsesCount) {
		int oldToolUsesCount = toolUsesCount;
		toolUsesCount = newToolUsesCount;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.CLEAR_TRIGGER__TOOL_USES_COUNT, oldToolUsesCount, toolUsesCount));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLEAR_TRIGGER__INPUT_TOKENS:
				return getInputTokens();
			case ClaudeChatCompletionPackage.CLEAR_TRIGGER__TOOL_USES_COUNT:
				return getToolUsesCount();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLEAR_TRIGGER__INPUT_TOKENS:
				setInputTokens((Integer)newValue);
				return;
			case ClaudeChatCompletionPackage.CLEAR_TRIGGER__TOOL_USES_COUNT:
				setToolUsesCount((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLEAR_TRIGGER__INPUT_TOKENS:
				setInputTokens(INPUT_TOKENS_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.CLEAR_TRIGGER__TOOL_USES_COUNT:
				setToolUsesCount(TOOL_USES_COUNT_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.CLEAR_TRIGGER__INPUT_TOKENS:
				return inputTokens != INPUT_TOKENS_EDEFAULT;
			case ClaudeChatCompletionPackage.CLEAR_TRIGGER__TOOL_USES_COUNT:
				return toolUsesCount != TOOL_USES_COUNT_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (inputTokens: ");
		result.append(inputTokens);
		result.append(", toolUsesCount: ");
		result.append(toolUsesCount);
		result.append(')');
		return result.toString();
	}

} //ClearTriggerImpl
