/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.eclipse.fennec.ai.chat.completion.model.claude.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.fennec.ai.chat.completion.model.claude.CacheControl;
import org.eclipse.fennec.ai.chat.completion.model.claude.Citations;
import org.eclipse.fennec.ai.chat.completion.model.claude.ClaudeChatCompletionPackage;
import org.eclipse.fennec.ai.chat.completion.model.claude.DocumentBlock;
import org.eclipse.fennec.ai.chat.completion.model.claude.DocumentSource;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Document Block</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.DocumentBlockImpl#getSource <em>Source</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.DocumentBlockImpl#getTitle <em>Title</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.DocumentBlockImpl#getContext <em>Context</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.DocumentBlockImpl#getCitations <em>Citations</em>}</li>
 *   <li>{@link org.eclipse.fennec.ai.chat.completion.model.claude.impl.DocumentBlockImpl#getCacheControl <em>Cache Control</em>}</li>
 * </ul>
 *
 * @generated
 */
public class DocumentBlockImpl extends ContentBlockImpl implements DocumentBlock {
	/**
	 * The cached value of the '{@link #getSource() <em>Source</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSource()
	 * @generated
	 * @ordered
	 */
	protected DocumentSource source;

	/**
	 * The default value of the '{@link #getTitle() <em>Title</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTitle()
	 * @generated
	 * @ordered
	 */
	protected static final String TITLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTitle() <em>Title</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTitle()
	 * @generated
	 * @ordered
	 */
	protected String title = TITLE_EDEFAULT;

	/**
	 * The default value of the '{@link #getContext() <em>Context</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContext()
	 * @generated
	 * @ordered
	 */
	protected static final String CONTEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getContext() <em>Context</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContext()
	 * @generated
	 * @ordered
	 */
	protected String context = CONTEXT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getCitations() <em>Citations</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCitations()
	 * @generated
	 * @ordered
	 */
	protected Citations citations;

	/**
	 * The cached value of the '{@link #getCacheControl() <em>Cache Control</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCacheControl()
	 * @generated
	 * @ordered
	 */
	protected CacheControl cacheControl;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DocumentBlockImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ClaudeChatCompletionPackage.Literals.DOCUMENT_BLOCK;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DocumentSource getSource() {
		return source;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSource(DocumentSource newSource, NotificationChain msgs) {
		DocumentSource oldSource = source;
		source = newSource;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.DOCUMENT_BLOCK__SOURCE, oldSource, newSource);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSource(DocumentSource newSource) {
		if (newSource != source) {
			NotificationChain msgs = null;
			if (source != null)
				msgs = ((InternalEObject)source).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.DOCUMENT_BLOCK__SOURCE, null, msgs);
			if (newSource != null)
				msgs = ((InternalEObject)newSource).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.DOCUMENT_BLOCK__SOURCE, null, msgs);
			msgs = basicSetSource(newSource, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.DOCUMENT_BLOCK__SOURCE, newSource, newSource));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getTitle() {
		return title;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTitle(String newTitle) {
		String oldTitle = title;
		title = newTitle;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.DOCUMENT_BLOCK__TITLE, oldTitle, title));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getContext() {
		return context;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setContext(String newContext) {
		String oldContext = context;
		context = newContext;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CONTEXT, oldContext, context));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Citations getCitations() {
		return citations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCitations(Citations newCitations, NotificationChain msgs) {
		Citations oldCitations = citations;
		citations = newCitations;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CITATIONS, oldCitations, newCitations);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCitations(Citations newCitations) {
		if (newCitations != citations) {
			NotificationChain msgs = null;
			if (citations != null)
				msgs = ((InternalEObject)citations).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CITATIONS, null, msgs);
			if (newCitations != null)
				msgs = ((InternalEObject)newCitations).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CITATIONS, null, msgs);
			msgs = basicSetCitations(newCitations, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CITATIONS, newCitations, newCitations));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CacheControl getCacheControl() {
		return cacheControl;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCacheControl(CacheControl newCacheControl, NotificationChain msgs) {
		CacheControl oldCacheControl = cacheControl;
		cacheControl = newCacheControl;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CACHE_CONTROL, oldCacheControl, newCacheControl);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCacheControl(CacheControl newCacheControl) {
		if (newCacheControl != cacheControl) {
			NotificationChain msgs = null;
			if (cacheControl != null)
				msgs = ((InternalEObject)cacheControl).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CACHE_CONTROL, null, msgs);
			if (newCacheControl != null)
				msgs = ((InternalEObject)newCacheControl).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CACHE_CONTROL, null, msgs);
			msgs = basicSetCacheControl(newCacheControl, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CACHE_CONTROL, newCacheControl, newCacheControl));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__SOURCE:
				return basicSetSource(null, msgs);
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CITATIONS:
				return basicSetCitations(null, msgs);
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CACHE_CONTROL:
				return basicSetCacheControl(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__SOURCE:
				return getSource();
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__TITLE:
				return getTitle();
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CONTEXT:
				return getContext();
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CITATIONS:
				return getCitations();
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CACHE_CONTROL:
				return getCacheControl();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__SOURCE:
				setSource((DocumentSource)newValue);
				return;
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__TITLE:
				setTitle((String)newValue);
				return;
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CONTEXT:
				setContext((String)newValue);
				return;
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CITATIONS:
				setCitations((Citations)newValue);
				return;
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CACHE_CONTROL:
				setCacheControl((CacheControl)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__SOURCE:
				setSource((DocumentSource)null);
				return;
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__TITLE:
				setTitle(TITLE_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CONTEXT:
				setContext(CONTEXT_EDEFAULT);
				return;
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CITATIONS:
				setCitations((Citations)null);
				return;
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CACHE_CONTROL:
				setCacheControl((CacheControl)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__SOURCE:
				return source != null;
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__TITLE:
				return TITLE_EDEFAULT == null ? title != null : !TITLE_EDEFAULT.equals(title);
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CONTEXT:
				return CONTEXT_EDEFAULT == null ? context != null : !CONTEXT_EDEFAULT.equals(context);
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CITATIONS:
				return citations != null;
			case ClaudeChatCompletionPackage.DOCUMENT_BLOCK__CACHE_CONTROL:
				return cacheControl != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (title: ");
		result.append(title);
		result.append(", context: ");
		result.append(context);
		result.append(')');
		return result.toString();
	}

} //DocumentBlockImpl
